
Int testLambda() {
	var fn = (Int x) => x + 3;
	fn.call(10);
}

Int callLambda(fn(Int)->Int x) {
	x.call(10);
}

Int testLambdaParam() {
	callLambda((a) => a + 5);
}

Int testLambdaVar() {
	fn(Int)->Int x = (a) => a + 20;
	x.call(12);
}

Int testLambdaCapture() {
	Int outside = 20;
	callLambda((x) => x + outside);
}

Int testLambdaCapture2() {
	Int outside = 20;
	var foo = (Int x) => x + outside;
	foo.call(33);
}


fn->Int createCounter() {
	Int now = 0;
	() => now++;
}

Str testLambdaMemory() {
	var a = createCounter();
	var b = createCounter();

	Int[] result;
	result << a.call();
	result << a.call();
	result << a.call();
	result << b.call();
	result << b.call();
	result << a.call();

	result.toS();
}

class LambdaEnv {
	Int x;

	init() {
		init { x = 7; }
	}

	fn(Int)->Int captureImplicit() {
		return (Int a) => a + x;
	}

	fn(Int)->Int captureExplicit() {
		return (Int a) => a + this.x;
	}
}

Int testLambdaThisImplicit() {
	LambdaEnv e;
	var fn = e.captureImplicit();
	fn.call(13);
}

Int testLambdaThisExplicit() {
	LambdaEnv e;
	var fn = e.captureExplicit();
	fn.call(13);
}

Int testLambdaExplicitReturn() {
	var x = (Int x) => {
		if (x > 10) {
			return 75;
		} else if (x < 0) {
			return 35;
		} else {
			200;
		}
	};

	x.call(20) + x.call(-1);
}
