![SPIKE](assets/spike-banner-lg.png)

## About

This document outlines the security policy and procedures for reporting
security vulnerabilities in **SPIKE**, along with the version support policy.

## Supported Versions

Only the most recent version of **SPIKE** is currently being supported with 
security updates.

Note that **SPIKE** consists of more than a single component, and during a 
release cut, all components are signed and tagged with the same version.

After **SPIKE** hits a major **1.0.0** Version, this will change,
and we will also have a support plan for various major versions.

## Reporting a Vulnerability

We are very thankful for—and if desired, happy to credit—security researchers 
and users who report vulnerabilities to the SPIKE community.

Please send your vulnerability reports to [security@spike.ist](mailto:security@spike.ist).

We don't have an official turnover time, but if nobody gets back
to you within a week, please send another email.

We take all vulnerability reports seriously, and you will be notified
if your report is accepted or declined, and what further actions we are going
to take on it.

## Handling

* All reports are thoroughly investigated by SPIKE Maintainers.
* Any vulnerability information shared will not be shared with others unless it 
  is necessary to fix the issue. Information is shared only on a "*need to know*" 
  basis.
* As the security issue moves through the identification and resolution process, 
  the reporter will be notified.
* Additional questions about the vulnerability may also be asked of the reporter. 

Note that while SPIKE is very active, it is a vendor-neutral CNCF-overseen
project maintained by volunteers, not by a single Company. As such, security 
issue handling is done on a best-effort basis. 

## Disclosures

We will coordinate publishing disclosures and security releases in a way that 
is realistic and necessary for end users. We prefer to fully disclose the 
vulnerability as soon as possible once user mitigation is available. 

Disclosures will always be published in a timely manner after a release is 
published that fixes the vulnerability.

A disclosure will likely (*but not always*) contain an overview, details about
the vulnerability, a fix that is typically an update or a patch, and optionally
a workaround if available.

Links to disclosures will also be added to the [SPIKE Changelog][changelog]
once we publish a fix for a vulnerability.

[changelog]: https://spike.ist/tracking/changelog/ "SPIKE Changelog"
