use super::Isotope;
use super::N_ISOTOPES;

/// Array containing all isotopes, ordered by atomic number and then mass number
///
/// ```
/// use mendeleev::Isotope;
/// use mendeleev::ALL_ISOTOPES;
/// use mendeleev::N_ISOTOPES;
///
/// ALL_ISOTOPES.iter().zip(ALL_ISOTOPES.iter().skip(1)).all(|(prev, next)|
/// ((prev.element().atomic_number(), prev.mass_number())
/// < (next.element().atomic_number(), next.mass_number())));
/// ```
pub const ALL_ISOTOPES: [Isotope; N_ISOTOPES] = [
    Isotope::H1,
    Isotope::H2,
    Isotope::H3,
    Isotope::H4,
    Isotope::H5,
    Isotope::H6,
    Isotope::H7,
    Isotope::He3,
    Isotope::He4,
    Isotope::He5,
    Isotope::He6,
    Isotope::He7,
    Isotope::He8,
    Isotope::He9,
    Isotope::He10,
    Isotope::Li3,
    Isotope::Li4,
    Isotope::Li5,
    Isotope::Li6,
    Isotope::Li7,
    Isotope::Li8,
    Isotope::Li9,
    Isotope::Li10,
    Isotope::Li11,
    Isotope::Li12,
    Isotope::Li13,
    Isotope::Be5,
    Isotope::Be6,
    Isotope::Be7,
    Isotope::Be8,
    Isotope::Be9,
    Isotope::Be10,
    Isotope::Be11,
    Isotope::Be12,
    Isotope::Be13,
    Isotope::Be14,
    Isotope::Be15,
    Isotope::Be16,
    Isotope::B6,
    Isotope::B7,
    Isotope::B8,
    Isotope::B9,
    Isotope::B10,
    Isotope::B11,
    Isotope::B12,
    Isotope::B13,
    Isotope::B14,
    Isotope::B15,
    Isotope::B16,
    Isotope::B17,
    Isotope::B18,
    Isotope::B19,
    Isotope::B20,
    Isotope::B21,
    Isotope::C8,
    Isotope::C9,
    Isotope::C10,
    Isotope::C11,
    Isotope::C12,
    Isotope::C13,
    Isotope::C14,
    Isotope::C15,
    Isotope::C16,
    Isotope::C17,
    Isotope::C18,
    Isotope::C19,
    Isotope::C20,
    Isotope::C21,
    Isotope::C22,
    Isotope::C23,
    Isotope::N10,
    Isotope::N11,
    Isotope::N12,
    Isotope::N13,
    Isotope::N14,
    Isotope::N15,
    Isotope::N16,
    Isotope::N17,
    Isotope::N18,
    Isotope::N19,
    Isotope::N20,
    Isotope::N21,
    Isotope::N22,
    Isotope::N23,
    Isotope::N24,
    Isotope::N25,
    Isotope::O11,
    Isotope::O12,
    Isotope::O13,
    Isotope::O14,
    Isotope::O15,
    Isotope::O16,
    Isotope::O17,
    Isotope::O18,
    Isotope::O19,
    Isotope::O20,
    Isotope::O21,
    Isotope::O22,
    Isotope::O23,
    Isotope::O24,
    Isotope::O25,
    Isotope::O26,
    Isotope::O27,
    Isotope::O28,
    Isotope::F13,
    Isotope::F14,
    Isotope::F15,
    Isotope::F16,
    Isotope::F17,
    Isotope::F18,
    Isotope::F19,
    Isotope::F20,
    Isotope::F21,
    Isotope::F22,
    Isotope::F23,
    Isotope::F24,
    Isotope::F25,
    Isotope::F26,
    Isotope::F27,
    Isotope::F28,
    Isotope::F29,
    Isotope::F30,
    Isotope::F31,
    Isotope::Ne15,
    Isotope::Ne16,
    Isotope::Ne17,
    Isotope::Ne18,
    Isotope::Ne19,
    Isotope::Ne20,
    Isotope::Ne21,
    Isotope::Ne22,
    Isotope::Ne23,
    Isotope::Ne24,
    Isotope::Ne25,
    Isotope::Ne26,
    Isotope::Ne27,
    Isotope::Ne28,
    Isotope::Ne29,
    Isotope::Ne30,
    Isotope::Ne31,
    Isotope::Ne32,
    Isotope::Ne33,
    Isotope::Ne34,
    Isotope::Na17,
    Isotope::Na18,
    Isotope::Na19,
    Isotope::Na20,
    Isotope::Na21,
    Isotope::Na22,
    Isotope::Na23,
    Isotope::Na24,
    Isotope::Na25,
    Isotope::Na26,
    Isotope::Na27,
    Isotope::Na28,
    Isotope::Na29,
    Isotope::Na30,
    Isotope::Na31,
    Isotope::Na32,
    Isotope::Na33,
    Isotope::Na34,
    Isotope::Na35,
    Isotope::Na36,
    Isotope::Na37,
    Isotope::Na38,
    Isotope::Na39,
    Isotope::Mg19,
    Isotope::Mg20,
    Isotope::Mg21,
    Isotope::Mg22,
    Isotope::Mg23,
    Isotope::Mg24,
    Isotope::Mg25,
    Isotope::Mg26,
    Isotope::Mg27,
    Isotope::Mg28,
    Isotope::Mg29,
    Isotope::Mg30,
    Isotope::Mg31,
    Isotope::Mg32,
    Isotope::Mg33,
    Isotope::Mg34,
    Isotope::Mg35,
    Isotope::Mg36,
    Isotope::Mg37,
    Isotope::Mg38,
    Isotope::Mg39,
    Isotope::Mg40,
    Isotope::Mg41,
    Isotope::Al21,
    Isotope::Al22,
    Isotope::Al23,
    Isotope::Al24,
    Isotope::Al25,
    Isotope::Al26,
    Isotope::Al27,
    Isotope::Al28,
    Isotope::Al29,
    Isotope::Al30,
    Isotope::Al31,
    Isotope::Al32,
    Isotope::Al33,
    Isotope::Al34,
    Isotope::Al35,
    Isotope::Al36,
    Isotope::Al37,
    Isotope::Al38,
    Isotope::Al39,
    Isotope::Al40,
    Isotope::Al41,
    Isotope::Al42,
    Isotope::Al43,
    Isotope::Si22,
    Isotope::Si23,
    Isotope::Si24,
    Isotope::Si25,
    Isotope::Si26,
    Isotope::Si27,
    Isotope::Si28,
    Isotope::Si29,
    Isotope::Si30,
    Isotope::Si31,
    Isotope::Si32,
    Isotope::Si33,
    Isotope::Si34,
    Isotope::Si35,
    Isotope::Si36,
    Isotope::Si37,
    Isotope::Si38,
    Isotope::Si39,
    Isotope::Si40,
    Isotope::Si41,
    Isotope::Si42,
    Isotope::Si43,
    Isotope::Si44,
    Isotope::Si45,
    Isotope::P24,
    Isotope::P25,
    Isotope::P26,
    Isotope::P27,
    Isotope::P28,
    Isotope::P29,
    Isotope::P30,
    Isotope::P31,
    Isotope::P32,
    Isotope::P33,
    Isotope::P34,
    Isotope::P35,
    Isotope::P36,
    Isotope::P37,
    Isotope::P38,
    Isotope::P39,
    Isotope::P40,
    Isotope::P41,
    Isotope::P42,
    Isotope::P43,
    Isotope::P44,
    Isotope::P45,
    Isotope::P46,
    Isotope::P47,
    Isotope::S26,
    Isotope::S27,
    Isotope::S28,
    Isotope::S29,
    Isotope::S30,
    Isotope::S31,
    Isotope::S32,
    Isotope::S33,
    Isotope::S34,
    Isotope::S35,
    Isotope::S36,
    Isotope::S37,
    Isotope::S38,
    Isotope::S39,
    Isotope::S40,
    Isotope::S41,
    Isotope::S42,
    Isotope::S43,
    Isotope::S44,
    Isotope::S45,
    Isotope::S46,
    Isotope::S47,
    Isotope::S48,
    Isotope::S49,
    Isotope::Cl28,
    Isotope::Cl29,
    Isotope::Cl30,
    Isotope::Cl31,
    Isotope::Cl32,
    Isotope::Cl33,
    Isotope::Cl34,
    Isotope::Cl35,
    Isotope::Cl36,
    Isotope::Cl37,
    Isotope::Cl38,
    Isotope::Cl39,
    Isotope::Cl40,
    Isotope::Cl41,
    Isotope::Cl42,
    Isotope::Cl43,
    Isotope::Cl44,
    Isotope::Cl45,
    Isotope::Cl46,
    Isotope::Cl47,
    Isotope::Cl48,
    Isotope::Cl49,
    Isotope::Cl50,
    Isotope::Cl51,
    Isotope::Cl52,
    Isotope::Ar29,
    Isotope::Ar30,
    Isotope::Ar31,
    Isotope::Ar32,
    Isotope::Ar33,
    Isotope::Ar34,
    Isotope::Ar35,
    Isotope::Ar36,
    Isotope::Ar37,
    Isotope::Ar38,
    Isotope::Ar39,
    Isotope::Ar40,
    Isotope::Ar41,
    Isotope::Ar42,
    Isotope::Ar43,
    Isotope::Ar44,
    Isotope::Ar45,
    Isotope::Ar46,
    Isotope::Ar47,
    Isotope::Ar48,
    Isotope::Ar49,
    Isotope::Ar50,
    Isotope::Ar51,
    Isotope::Ar52,
    Isotope::Ar53,
    Isotope::Ar54,
    Isotope::K31,
    Isotope::K32,
    Isotope::K33,
    Isotope::K34,
    Isotope::K35,
    Isotope::K36,
    Isotope::K37,
    Isotope::K38,
    Isotope::K39,
    Isotope::K40,
    Isotope::K41,
    Isotope::K42,
    Isotope::K43,
    Isotope::K44,
    Isotope::K45,
    Isotope::K46,
    Isotope::K47,
    Isotope::K48,
    Isotope::K49,
    Isotope::K50,
    Isotope::K51,
    Isotope::K52,
    Isotope::K53,
    Isotope::K54,
    Isotope::K55,
    Isotope::K56,
    Isotope::K57,
    Isotope::K58,
    Isotope::K59,
    Isotope::Ca33,
    Isotope::Ca34,
    Isotope::Ca35,
    Isotope::Ca36,
    Isotope::Ca37,
    Isotope::Ca38,
    Isotope::Ca39,
    Isotope::Ca40,
    Isotope::Ca41,
    Isotope::Ca42,
    Isotope::Ca43,
    Isotope::Ca44,
    Isotope::Ca45,
    Isotope::Ca46,
    Isotope::Ca47,
    Isotope::Ca48,
    Isotope::Ca49,
    Isotope::Ca50,
    Isotope::Ca51,
    Isotope::Ca52,
    Isotope::Ca53,
    Isotope::Ca54,
    Isotope::Ca55,
    Isotope::Ca56,
    Isotope::Ca57,
    Isotope::Ca58,
    Isotope::Ca59,
    Isotope::Ca60,
    Isotope::Ca61,
    Isotope::Sc35,
    Isotope::Sc36,
    Isotope::Sc37,
    Isotope::Sc38,
    Isotope::Sc39,
    Isotope::Sc40,
    Isotope::Sc41,
    Isotope::Sc42,
    Isotope::Sc43,
    Isotope::Sc44,
    Isotope::Sc45,
    Isotope::Sc46,
    Isotope::Sc47,
    Isotope::Sc48,
    Isotope::Sc49,
    Isotope::Sc50,
    Isotope::Sc51,
    Isotope::Sc52,
    Isotope::Sc53,
    Isotope::Sc54,
    Isotope::Sc55,
    Isotope::Sc56,
    Isotope::Sc57,
    Isotope::Sc58,
    Isotope::Sc59,
    Isotope::Sc60,
    Isotope::Sc61,
    Isotope::Sc62,
    Isotope::Sc63,
    Isotope::Ti37,
    Isotope::Ti38,
    Isotope::Ti39,
    Isotope::Ti40,
    Isotope::Ti41,
    Isotope::Ti42,
    Isotope::Ti43,
    Isotope::Ti44,
    Isotope::Ti45,
    Isotope::Ti46,
    Isotope::Ti47,
    Isotope::Ti48,
    Isotope::Ti49,
    Isotope::Ti50,
    Isotope::Ti51,
    Isotope::Ti52,
    Isotope::Ti53,
    Isotope::Ti54,
    Isotope::Ti55,
    Isotope::Ti56,
    Isotope::Ti57,
    Isotope::Ti58,
    Isotope::Ti59,
    Isotope::Ti60,
    Isotope::Ti61,
    Isotope::Ti62,
    Isotope::Ti63,
    Isotope::Ti64,
    Isotope::Ti65,
    Isotope::V39,
    Isotope::V40,
    Isotope::V41,
    Isotope::V42,
    Isotope::V43,
    Isotope::V44,
    Isotope::V45,
    Isotope::V46,
    Isotope::V47,
    Isotope::V48,
    Isotope::V49,
    Isotope::V50,
    Isotope::V51,
    Isotope::V52,
    Isotope::V53,
    Isotope::V54,
    Isotope::V55,
    Isotope::V56,
    Isotope::V57,
    Isotope::V58,
    Isotope::V59,
    Isotope::V60,
    Isotope::V61,
    Isotope::V62,
    Isotope::V63,
    Isotope::V64,
    Isotope::V65,
    Isotope::V66,
    Isotope::V67,
    Isotope::Cr41,
    Isotope::Cr42,
    Isotope::Cr43,
    Isotope::Cr44,
    Isotope::Cr45,
    Isotope::Cr46,
    Isotope::Cr47,
    Isotope::Cr48,
    Isotope::Cr49,
    Isotope::Cr50,
    Isotope::Cr51,
    Isotope::Cr52,
    Isotope::Cr53,
    Isotope::Cr54,
    Isotope::Cr55,
    Isotope::Cr56,
    Isotope::Cr57,
    Isotope::Cr58,
    Isotope::Cr59,
    Isotope::Cr60,
    Isotope::Cr61,
    Isotope::Cr62,
    Isotope::Cr63,
    Isotope::Cr64,
    Isotope::Cr65,
    Isotope::Cr66,
    Isotope::Cr67,
    Isotope::Cr68,
    Isotope::Cr69,
    Isotope::Cr70,
    Isotope::Mn43,
    Isotope::Mn44,
    Isotope::Mn45,
    Isotope::Mn46,
    Isotope::Mn47,
    Isotope::Mn48,
    Isotope::Mn49,
    Isotope::Mn50,
    Isotope::Mn51,
    Isotope::Mn52,
    Isotope::Mn53,
    Isotope::Mn54,
    Isotope::Mn55,
    Isotope::Mn56,
    Isotope::Mn57,
    Isotope::Mn58,
    Isotope::Mn59,
    Isotope::Mn60,
    Isotope::Mn61,
    Isotope::Mn62,
    Isotope::Mn63,
    Isotope::Mn64,
    Isotope::Mn65,
    Isotope::Mn66,
    Isotope::Mn67,
    Isotope::Mn68,
    Isotope::Mn69,
    Isotope::Mn70,
    Isotope::Mn71,
    Isotope::Mn72,
    Isotope::Mn73,
    Isotope::Fe45,
    Isotope::Fe46,
    Isotope::Fe47,
    Isotope::Fe48,
    Isotope::Fe49,
    Isotope::Fe50,
    Isotope::Fe51,
    Isotope::Fe52,
    Isotope::Fe53,
    Isotope::Fe54,
    Isotope::Fe55,
    Isotope::Fe56,
    Isotope::Fe57,
    Isotope::Fe58,
    Isotope::Fe59,
    Isotope::Fe60,
    Isotope::Fe61,
    Isotope::Fe62,
    Isotope::Fe63,
    Isotope::Fe64,
    Isotope::Fe65,
    Isotope::Fe66,
    Isotope::Fe67,
    Isotope::Fe68,
    Isotope::Fe69,
    Isotope::Fe70,
    Isotope::Fe71,
    Isotope::Fe72,
    Isotope::Fe73,
    Isotope::Fe74,
    Isotope::Fe75,
    Isotope::Fe76,
    Isotope::Co47,
    Isotope::Co48,
    Isotope::Co49,
    Isotope::Co50,
    Isotope::Co51,
    Isotope::Co52,
    Isotope::Co53,
    Isotope::Co54,
    Isotope::Co55,
    Isotope::Co56,
    Isotope::Co57,
    Isotope::Co58,
    Isotope::Co59,
    Isotope::Co60,
    Isotope::Co61,
    Isotope::Co62,
    Isotope::Co63,
    Isotope::Co64,
    Isotope::Co65,
    Isotope::Co66,
    Isotope::Co67,
    Isotope::Co68,
    Isotope::Co69,
    Isotope::Co70,
    Isotope::Co71,
    Isotope::Co72,
    Isotope::Co73,
    Isotope::Co74,
    Isotope::Co75,
    Isotope::Co76,
    Isotope::Co77,
    Isotope::Co78,
    Isotope::Ni48,
    Isotope::Ni49,
    Isotope::Ni50,
    Isotope::Ni51,
    Isotope::Ni52,
    Isotope::Ni53,
    Isotope::Ni54,
    Isotope::Ni55,
    Isotope::Ni56,
    Isotope::Ni57,
    Isotope::Ni58,
    Isotope::Ni59,
    Isotope::Ni60,
    Isotope::Ni61,
    Isotope::Ni62,
    Isotope::Ni63,
    Isotope::Ni64,
    Isotope::Ni65,
    Isotope::Ni66,
    Isotope::Ni67,
    Isotope::Ni68,
    Isotope::Ni69,
    Isotope::Ni70,
    Isotope::Ni71,
    Isotope::Ni72,
    Isotope::Ni73,
    Isotope::Ni74,
    Isotope::Ni75,
    Isotope::Ni76,
    Isotope::Ni77,
    Isotope::Ni78,
    Isotope::Ni79,
    Isotope::Ni80,
    Isotope::Ni81,
    Isotope::Ni82,
    Isotope::Cu52,
    Isotope::Cu53,
    Isotope::Cu54,
    Isotope::Cu55,
    Isotope::Cu56,
    Isotope::Cu57,
    Isotope::Cu58,
    Isotope::Cu59,
    Isotope::Cu60,
    Isotope::Cu61,
    Isotope::Cu62,
    Isotope::Cu63,
    Isotope::Cu64,
    Isotope::Cu65,
    Isotope::Cu66,
    Isotope::Cu67,
    Isotope::Cu68,
    Isotope::Cu69,
    Isotope::Cu70,
    Isotope::Cu71,
    Isotope::Cu72,
    Isotope::Cu73,
    Isotope::Cu74,
    Isotope::Cu75,
    Isotope::Cu76,
    Isotope::Cu77,
    Isotope::Cu78,
    Isotope::Cu79,
    Isotope::Cu80,
    Isotope::Cu81,
    Isotope::Cu82,
    Isotope::Cu83,
    Isotope::Cu84,
    Isotope::Zn54,
    Isotope::Zn55,
    Isotope::Zn56,
    Isotope::Zn57,
    Isotope::Zn58,
    Isotope::Zn59,
    Isotope::Zn60,
    Isotope::Zn61,
    Isotope::Zn62,
    Isotope::Zn63,
    Isotope::Zn64,
    Isotope::Zn65,
    Isotope::Zn66,
    Isotope::Zn67,
    Isotope::Zn68,
    Isotope::Zn69,
    Isotope::Zn70,
    Isotope::Zn71,
    Isotope::Zn72,
    Isotope::Zn73,
    Isotope::Zn74,
    Isotope::Zn75,
    Isotope::Zn76,
    Isotope::Zn77,
    Isotope::Zn78,
    Isotope::Zn79,
    Isotope::Zn80,
    Isotope::Zn81,
    Isotope::Zn82,
    Isotope::Zn83,
    Isotope::Zn84,
    Isotope::Zn85,
    Isotope::Zn86,
    Isotope::Ga56,
    Isotope::Ga57,
    Isotope::Ga58,
    Isotope::Ga59,
    Isotope::Ga60,
    Isotope::Ga61,
    Isotope::Ga62,
    Isotope::Ga63,
    Isotope::Ga64,
    Isotope::Ga65,
    Isotope::Ga66,
    Isotope::Ga67,
    Isotope::Ga68,
    Isotope::Ga69,
    Isotope::Ga70,
    Isotope::Ga71,
    Isotope::Ga72,
    Isotope::Ga73,
    Isotope::Ga74,
    Isotope::Ga75,
    Isotope::Ga76,
    Isotope::Ga77,
    Isotope::Ga78,
    Isotope::Ga79,
    Isotope::Ga80,
    Isotope::Ga81,
    Isotope::Ga82,
    Isotope::Ga83,
    Isotope::Ga84,
    Isotope::Ga85,
    Isotope::Ga86,
    Isotope::Ga87,
    Isotope::Ga88,
    Isotope::Ge58,
    Isotope::Ge59,
    Isotope::Ge60,
    Isotope::Ge61,
    Isotope::Ge62,
    Isotope::Ge63,
    Isotope::Ge64,
    Isotope::Ge65,
    Isotope::Ge66,
    Isotope::Ge67,
    Isotope::Ge68,
    Isotope::Ge69,
    Isotope::Ge70,
    Isotope::Ge71,
    Isotope::Ge72,
    Isotope::Ge73,
    Isotope::Ge74,
    Isotope::Ge75,
    Isotope::Ge76,
    Isotope::Ge77,
    Isotope::Ge78,
    Isotope::Ge79,
    Isotope::Ge80,
    Isotope::Ge81,
    Isotope::Ge82,
    Isotope::Ge83,
    Isotope::Ge84,
    Isotope::Ge85,
    Isotope::Ge86,
    Isotope::Ge87,
    Isotope::Ge88,
    Isotope::Ge89,
    Isotope::Ge90,
    Isotope::As60,
    Isotope::As61,
    Isotope::As62,
    Isotope::As63,
    Isotope::As64,
    Isotope::As65,
    Isotope::As66,
    Isotope::As67,
    Isotope::As68,
    Isotope::As69,
    Isotope::As70,
    Isotope::As71,
    Isotope::As72,
    Isotope::As73,
    Isotope::As74,
    Isotope::As75,
    Isotope::As76,
    Isotope::As77,
    Isotope::As78,
    Isotope::As79,
    Isotope::As80,
    Isotope::As81,
    Isotope::As82,
    Isotope::As83,
    Isotope::As84,
    Isotope::As85,
    Isotope::As86,
    Isotope::As87,
    Isotope::As88,
    Isotope::As89,
    Isotope::As90,
    Isotope::As91,
    Isotope::As92,
    Isotope::Se63,
    Isotope::Se64,
    Isotope::Se65,
    Isotope::Se66,
    Isotope::Se67,
    Isotope::Se68,
    Isotope::Se69,
    Isotope::Se70,
    Isotope::Se71,
    Isotope::Se72,
    Isotope::Se73,
    Isotope::Se74,
    Isotope::Se75,
    Isotope::Se76,
    Isotope::Se77,
    Isotope::Se78,
    Isotope::Se79,
    Isotope::Se80,
    Isotope::Se81,
    Isotope::Se82,
    Isotope::Se83,
    Isotope::Se84,
    Isotope::Se85,
    Isotope::Se86,
    Isotope::Se87,
    Isotope::Se88,
    Isotope::Se89,
    Isotope::Se90,
    Isotope::Se91,
    Isotope::Se92,
    Isotope::Se93,
    Isotope::Se94,
    Isotope::Se95,
    Isotope::Br65,
    Isotope::Br66,
    Isotope::Br67,
    Isotope::Br68,
    Isotope::Br69,
    Isotope::Br70,
    Isotope::Br71,
    Isotope::Br72,
    Isotope::Br73,
    Isotope::Br74,
    Isotope::Br75,
    Isotope::Br76,
    Isotope::Br77,
    Isotope::Br78,
    Isotope::Br79,
    Isotope::Br80,
    Isotope::Br81,
    Isotope::Br82,
    Isotope::Br83,
    Isotope::Br84,
    Isotope::Br85,
    Isotope::Br86,
    Isotope::Br87,
    Isotope::Br88,
    Isotope::Br89,
    Isotope::Br90,
    Isotope::Br91,
    Isotope::Br92,
    Isotope::Br93,
    Isotope::Br94,
    Isotope::Br95,
    Isotope::Br96,
    Isotope::Br97,
    Isotope::Br98,
    Isotope::Kr67,
    Isotope::Kr68,
    Isotope::Kr69,
    Isotope::Kr70,
    Isotope::Kr71,
    Isotope::Kr72,
    Isotope::Kr73,
    Isotope::Kr74,
    Isotope::Kr75,
    Isotope::Kr76,
    Isotope::Kr77,
    Isotope::Kr78,
    Isotope::Kr79,
    Isotope::Kr80,
    Isotope::Kr81,
    Isotope::Kr82,
    Isotope::Kr83,
    Isotope::Kr84,
    Isotope::Kr85,
    Isotope::Kr86,
    Isotope::Kr87,
    Isotope::Kr88,
    Isotope::Kr89,
    Isotope::Kr90,
    Isotope::Kr91,
    Isotope::Kr92,
    Isotope::Kr93,
    Isotope::Kr94,
    Isotope::Kr95,
    Isotope::Kr96,
    Isotope::Kr97,
    Isotope::Kr98,
    Isotope::Kr99,
    Isotope::Kr100,
    Isotope::Kr101,
    Isotope::Rb71,
    Isotope::Rb72,
    Isotope::Rb73,
    Isotope::Rb74,
    Isotope::Rb75,
    Isotope::Rb76,
    Isotope::Rb77,
    Isotope::Rb78,
    Isotope::Rb79,
    Isotope::Rb80,
    Isotope::Rb81,
    Isotope::Rb82,
    Isotope::Rb83,
    Isotope::Rb84,
    Isotope::Rb85,
    Isotope::Rb86,
    Isotope::Rb87,
    Isotope::Rb88,
    Isotope::Rb89,
    Isotope::Rb90,
    Isotope::Rb91,
    Isotope::Rb92,
    Isotope::Rb93,
    Isotope::Rb94,
    Isotope::Rb95,
    Isotope::Rb96,
    Isotope::Rb97,
    Isotope::Rb98,
    Isotope::Rb99,
    Isotope::Rb100,
    Isotope::Rb101,
    Isotope::Rb102,
    Isotope::Rb103,
    Isotope::Rb104,
    Isotope::Sr73,
    Isotope::Sr74,
    Isotope::Sr75,
    Isotope::Sr76,
    Isotope::Sr77,
    Isotope::Sr78,
    Isotope::Sr79,
    Isotope::Sr80,
    Isotope::Sr81,
    Isotope::Sr82,
    Isotope::Sr83,
    Isotope::Sr84,
    Isotope::Sr85,
    Isotope::Sr86,
    Isotope::Sr87,
    Isotope::Sr88,
    Isotope::Sr89,
    Isotope::Sr90,
    Isotope::Sr91,
    Isotope::Sr92,
    Isotope::Sr93,
    Isotope::Sr94,
    Isotope::Sr95,
    Isotope::Sr96,
    Isotope::Sr97,
    Isotope::Sr98,
    Isotope::Sr99,
    Isotope::Sr100,
    Isotope::Sr101,
    Isotope::Sr102,
    Isotope::Sr103,
    Isotope::Sr104,
    Isotope::Sr105,
    Isotope::Sr106,
    Isotope::Sr107,
    Isotope::Y75,
    Isotope::Y76,
    Isotope::Y77,
    Isotope::Y78,
    Isotope::Y79,
    Isotope::Y80,
    Isotope::Y81,
    Isotope::Y82,
    Isotope::Y83,
    Isotope::Y84,
    Isotope::Y85,
    Isotope::Y86,
    Isotope::Y87,
    Isotope::Y88,
    Isotope::Y89,
    Isotope::Y90,
    Isotope::Y91,
    Isotope::Y92,
    Isotope::Y93,
    Isotope::Y94,
    Isotope::Y95,
    Isotope::Y96,
    Isotope::Y97,
    Isotope::Y98,
    Isotope::Y99,
    Isotope::Y100,
    Isotope::Y101,
    Isotope::Y102,
    Isotope::Y103,
    Isotope::Y104,
    Isotope::Y105,
    Isotope::Y106,
    Isotope::Y107,
    Isotope::Y108,
    Isotope::Y109,
    Isotope::Zr77,
    Isotope::Zr78,
    Isotope::Zr79,
    Isotope::Zr80,
    Isotope::Zr81,
    Isotope::Zr82,
    Isotope::Zr83,
    Isotope::Zr84,
    Isotope::Zr85,
    Isotope::Zr86,
    Isotope::Zr87,
    Isotope::Zr88,
    Isotope::Zr89,
    Isotope::Zr90,
    Isotope::Zr91,
    Isotope::Zr92,
    Isotope::Zr93,
    Isotope::Zr94,
    Isotope::Zr95,
    Isotope::Zr96,
    Isotope::Zr97,
    Isotope::Zr98,
    Isotope::Zr99,
    Isotope::Zr100,
    Isotope::Zr101,
    Isotope::Zr102,
    Isotope::Zr103,
    Isotope::Zr104,
    Isotope::Zr105,
    Isotope::Zr106,
    Isotope::Zr107,
    Isotope::Zr108,
    Isotope::Zr109,
    Isotope::Zr110,
    Isotope::Zr111,
    Isotope::Zr112,
    Isotope::Zr113,
    Isotope::Nb79,
    Isotope::Nb80,
    Isotope::Nb81,
    Isotope::Nb82,
    Isotope::Nb83,
    Isotope::Nb84,
    Isotope::Nb85,
    Isotope::Nb86,
    Isotope::Nb87,
    Isotope::Nb88,
    Isotope::Nb89,
    Isotope::Nb90,
    Isotope::Nb91,
    Isotope::Nb92,
    Isotope::Nb93,
    Isotope::Nb94,
    Isotope::Nb95,
    Isotope::Nb96,
    Isotope::Nb97,
    Isotope::Nb98,
    Isotope::Nb99,
    Isotope::Nb100,
    Isotope::Nb101,
    Isotope::Nb102,
    Isotope::Nb103,
    Isotope::Nb104,
    Isotope::Nb105,
    Isotope::Nb106,
    Isotope::Nb107,
    Isotope::Nb108,
    Isotope::Nb109,
    Isotope::Nb110,
    Isotope::Nb111,
    Isotope::Nb112,
    Isotope::Nb113,
    Isotope::Nb114,
    Isotope::Nb115,
    Isotope::Nb116,
    Isotope::Mo81,
    Isotope::Mo82,
    Isotope::Mo83,
    Isotope::Mo84,
    Isotope::Mo85,
    Isotope::Mo86,
    Isotope::Mo87,
    Isotope::Mo88,
    Isotope::Mo89,
    Isotope::Mo90,
    Isotope::Mo91,
    Isotope::Mo92,
    Isotope::Mo93,
    Isotope::Mo94,
    Isotope::Mo95,
    Isotope::Mo96,
    Isotope::Mo97,
    Isotope::Mo98,
    Isotope::Mo99,
    Isotope::Mo100,
    Isotope::Mo101,
    Isotope::Mo102,
    Isotope::Mo103,
    Isotope::Mo104,
    Isotope::Mo105,
    Isotope::Mo106,
    Isotope::Mo107,
    Isotope::Mo108,
    Isotope::Mo109,
    Isotope::Mo110,
    Isotope::Mo111,
    Isotope::Mo112,
    Isotope::Mo113,
    Isotope::Mo114,
    Isotope::Mo115,
    Isotope::Mo116,
    Isotope::Mo117,
    Isotope::Mo118,
    Isotope::Mo119,
    Isotope::Tc83,
    Isotope::Tc84,
    Isotope::Tc85,
    Isotope::Tc86,
    Isotope::Tc87,
    Isotope::Tc88,
    Isotope::Tc89,
    Isotope::Tc90,
    Isotope::Tc91,
    Isotope::Tc92,
    Isotope::Tc93,
    Isotope::Tc94,
    Isotope::Tc95,
    Isotope::Tc96,
    Isotope::Tc97,
    Isotope::Tc98,
    Isotope::Tc99,
    Isotope::Tc100,
    Isotope::Tc101,
    Isotope::Tc102,
    Isotope::Tc103,
    Isotope::Tc104,
    Isotope::Tc105,
    Isotope::Tc106,
    Isotope::Tc107,
    Isotope::Tc108,
    Isotope::Tc109,
    Isotope::Tc110,
    Isotope::Tc111,
    Isotope::Tc112,
    Isotope::Tc113,
    Isotope::Tc114,
    Isotope::Tc115,
    Isotope::Tc116,
    Isotope::Tc117,
    Isotope::Tc118,
    Isotope::Tc119,
    Isotope::Tc120,
    Isotope::Tc121,
    Isotope::Tc122,
    Isotope::Ru85,
    Isotope::Ru86,
    Isotope::Ru87,
    Isotope::Ru88,
    Isotope::Ru89,
    Isotope::Ru90,
    Isotope::Ru91,
    Isotope::Ru92,
    Isotope::Ru93,
    Isotope::Ru94,
    Isotope::Ru95,
    Isotope::Ru96,
    Isotope::Ru97,
    Isotope::Ru98,
    Isotope::Ru99,
    Isotope::Ru100,
    Isotope::Ru101,
    Isotope::Ru102,
    Isotope::Ru103,
    Isotope::Ru104,
    Isotope::Ru105,
    Isotope::Ru106,
    Isotope::Ru107,
    Isotope::Ru108,
    Isotope::Ru109,
    Isotope::Ru110,
    Isotope::Ru111,
    Isotope::Ru112,
    Isotope::Ru113,
    Isotope::Ru114,
    Isotope::Ru115,
    Isotope::Ru116,
    Isotope::Ru117,
    Isotope::Ru118,
    Isotope::Ru119,
    Isotope::Ru120,
    Isotope::Ru121,
    Isotope::Ru122,
    Isotope::Ru123,
    Isotope::Ru124,
    Isotope::Ru125,
    Isotope::Rh88,
    Isotope::Rh89,
    Isotope::Rh90,
    Isotope::Rh91,
    Isotope::Rh92,
    Isotope::Rh93,
    Isotope::Rh94,
    Isotope::Rh95,
    Isotope::Rh96,
    Isotope::Rh97,
    Isotope::Rh98,
    Isotope::Rh99,
    Isotope::Rh100,
    Isotope::Rh101,
    Isotope::Rh102,
    Isotope::Rh103,
    Isotope::Rh104,
    Isotope::Rh105,
    Isotope::Rh106,
    Isotope::Rh107,
    Isotope::Rh108,
    Isotope::Rh109,
    Isotope::Rh110,
    Isotope::Rh111,
    Isotope::Rh112,
    Isotope::Rh113,
    Isotope::Rh114,
    Isotope::Rh115,
    Isotope::Rh116,
    Isotope::Rh117,
    Isotope::Rh118,
    Isotope::Rh119,
    Isotope::Rh120,
    Isotope::Rh121,
    Isotope::Rh122,
    Isotope::Rh123,
    Isotope::Rh124,
    Isotope::Rh125,
    Isotope::Rh126,
    Isotope::Rh127,
    Isotope::Rh128,
    Isotope::Pd90,
    Isotope::Pd91,
    Isotope::Pd92,
    Isotope::Pd93,
    Isotope::Pd94,
    Isotope::Pd95,
    Isotope::Pd96,
    Isotope::Pd97,
    Isotope::Pd98,
    Isotope::Pd99,
    Isotope::Pd100,
    Isotope::Pd101,
    Isotope::Pd102,
    Isotope::Pd103,
    Isotope::Pd104,
    Isotope::Pd105,
    Isotope::Pd106,
    Isotope::Pd107,
    Isotope::Pd108,
    Isotope::Pd109,
    Isotope::Pd110,
    Isotope::Pd111,
    Isotope::Pd112,
    Isotope::Pd113,
    Isotope::Pd114,
    Isotope::Pd115,
    Isotope::Pd116,
    Isotope::Pd117,
    Isotope::Pd118,
    Isotope::Pd119,
    Isotope::Pd120,
    Isotope::Pd121,
    Isotope::Pd122,
    Isotope::Pd123,
    Isotope::Pd124,
    Isotope::Pd125,
    Isotope::Pd126,
    Isotope::Pd127,
    Isotope::Pd128,
    Isotope::Pd129,
    Isotope::Pd130,
    Isotope::Pd131,
    Isotope::Ag92,
    Isotope::Ag93,
    Isotope::Ag94,
    Isotope::Ag95,
    Isotope::Ag96,
    Isotope::Ag97,
    Isotope::Ag98,
    Isotope::Ag99,
    Isotope::Ag100,
    Isotope::Ag101,
    Isotope::Ag102,
    Isotope::Ag103,
    Isotope::Ag104,
    Isotope::Ag105,
    Isotope::Ag106,
    Isotope::Ag107,
    Isotope::Ag108,
    Isotope::Ag109,
    Isotope::Ag110,
    Isotope::Ag111,
    Isotope::Ag112,
    Isotope::Ag113,
    Isotope::Ag114,
    Isotope::Ag115,
    Isotope::Ag116,
    Isotope::Ag117,
    Isotope::Ag118,
    Isotope::Ag119,
    Isotope::Ag120,
    Isotope::Ag121,
    Isotope::Ag122,
    Isotope::Ag123,
    Isotope::Ag124,
    Isotope::Ag125,
    Isotope::Ag126,
    Isotope::Ag127,
    Isotope::Ag128,
    Isotope::Ag129,
    Isotope::Ag130,
    Isotope::Ag131,
    Isotope::Ag132,
    Isotope::Ag133,
    Isotope::Cd94,
    Isotope::Cd95,
    Isotope::Cd96,
    Isotope::Cd97,
    Isotope::Cd98,
    Isotope::Cd99,
    Isotope::Cd100,
    Isotope::Cd101,
    Isotope::Cd102,
    Isotope::Cd103,
    Isotope::Cd104,
    Isotope::Cd105,
    Isotope::Cd106,
    Isotope::Cd107,
    Isotope::Cd108,
    Isotope::Cd109,
    Isotope::Cd110,
    Isotope::Cd111,
    Isotope::Cd112,
    Isotope::Cd113,
    Isotope::Cd114,
    Isotope::Cd115,
    Isotope::Cd116,
    Isotope::Cd117,
    Isotope::Cd118,
    Isotope::Cd119,
    Isotope::Cd120,
    Isotope::Cd121,
    Isotope::Cd122,
    Isotope::Cd123,
    Isotope::Cd124,
    Isotope::Cd125,
    Isotope::Cd126,
    Isotope::Cd127,
    Isotope::Cd128,
    Isotope::Cd129,
    Isotope::Cd130,
    Isotope::Cd131,
    Isotope::Cd132,
    Isotope::Cd133,
    Isotope::Cd134,
    Isotope::Cd135,
    Isotope::In96,
    Isotope::In97,
    Isotope::In98,
    Isotope::In99,
    Isotope::In100,
    Isotope::In101,
    Isotope::In102,
    Isotope::In103,
    Isotope::In104,
    Isotope::In105,
    Isotope::In106,
    Isotope::In107,
    Isotope::In108,
    Isotope::In109,
    Isotope::In110,
    Isotope::In111,
    Isotope::In112,
    Isotope::In113,
    Isotope::In114,
    Isotope::In115,
    Isotope::In116,
    Isotope::In117,
    Isotope::In118,
    Isotope::In119,
    Isotope::In120,
    Isotope::In121,
    Isotope::In122,
    Isotope::In123,
    Isotope::In124,
    Isotope::In125,
    Isotope::In126,
    Isotope::In127,
    Isotope::In128,
    Isotope::In129,
    Isotope::In130,
    Isotope::In131,
    Isotope::In132,
    Isotope::In133,
    Isotope::In134,
    Isotope::In135,
    Isotope::In136,
    Isotope::In137,
    Isotope::Sn99,
    Isotope::Sn100,
    Isotope::Sn101,
    Isotope::Sn102,
    Isotope::Sn103,
    Isotope::Sn104,
    Isotope::Sn105,
    Isotope::Sn106,
    Isotope::Sn107,
    Isotope::Sn108,
    Isotope::Sn109,
    Isotope::Sn110,
    Isotope::Sn111,
    Isotope::Sn112,
    Isotope::Sn113,
    Isotope::Sn114,
    Isotope::Sn115,
    Isotope::Sn116,
    Isotope::Sn117,
    Isotope::Sn118,
    Isotope::Sn119,
    Isotope::Sn120,
    Isotope::Sn121,
    Isotope::Sn122,
    Isotope::Sn123,
    Isotope::Sn124,
    Isotope::Sn125,
    Isotope::Sn126,
    Isotope::Sn127,
    Isotope::Sn128,
    Isotope::Sn129,
    Isotope::Sn130,
    Isotope::Sn131,
    Isotope::Sn132,
    Isotope::Sn133,
    Isotope::Sn134,
    Isotope::Sn135,
    Isotope::Sn136,
    Isotope::Sn137,
    Isotope::Sn138,
    Isotope::Sn139,
    Isotope::Sn140,
    Isotope::Sb102,
    Isotope::Sb103,
    Isotope::Sb104,
    Isotope::Sb105,
    Isotope::Sb106,
    Isotope::Sb107,
    Isotope::Sb108,
    Isotope::Sb109,
    Isotope::Sb110,
    Isotope::Sb111,
    Isotope::Sb112,
    Isotope::Sb113,
    Isotope::Sb114,
    Isotope::Sb115,
    Isotope::Sb116,
    Isotope::Sb117,
    Isotope::Sb118,
    Isotope::Sb119,
    Isotope::Sb120,
    Isotope::Sb121,
    Isotope::Sb122,
    Isotope::Sb123,
    Isotope::Sb124,
    Isotope::Sb125,
    Isotope::Sb126,
    Isotope::Sb127,
    Isotope::Sb128,
    Isotope::Sb129,
    Isotope::Sb130,
    Isotope::Sb131,
    Isotope::Sb132,
    Isotope::Sb133,
    Isotope::Sb134,
    Isotope::Sb135,
    Isotope::Sb136,
    Isotope::Sb137,
    Isotope::Sb138,
    Isotope::Sb139,
    Isotope::Sb140,
    Isotope::Sb141,
    Isotope::Sb142,
    Isotope::Te104,
    Isotope::Te105,
    Isotope::Te106,
    Isotope::Te107,
    Isotope::Te108,
    Isotope::Te109,
    Isotope::Te110,
    Isotope::Te111,
    Isotope::Te112,
    Isotope::Te113,
    Isotope::Te114,
    Isotope::Te115,
    Isotope::Te116,
    Isotope::Te117,
    Isotope::Te118,
    Isotope::Te119,
    Isotope::Te120,
    Isotope::Te121,
    Isotope::Te122,
    Isotope::Te123,
    Isotope::Te124,
    Isotope::Te125,
    Isotope::Te126,
    Isotope::Te127,
    Isotope::Te128,
    Isotope::Te129,
    Isotope::Te130,
    Isotope::Te131,
    Isotope::Te132,
    Isotope::Te133,
    Isotope::Te134,
    Isotope::Te135,
    Isotope::Te136,
    Isotope::Te137,
    Isotope::Te138,
    Isotope::Te139,
    Isotope::Te140,
    Isotope::Te141,
    Isotope::Te142,
    Isotope::Te143,
    Isotope::Te144,
    Isotope::Te145,
    Isotope::I106,
    Isotope::I107,
    Isotope::I108,
    Isotope::I109,
    Isotope::I110,
    Isotope::I111,
    Isotope::I112,
    Isotope::I113,
    Isotope::I114,
    Isotope::I115,
    Isotope::I116,
    Isotope::I117,
    Isotope::I118,
    Isotope::I119,
    Isotope::I120,
    Isotope::I121,
    Isotope::I122,
    Isotope::I123,
    Isotope::I124,
    Isotope::I125,
    Isotope::I126,
    Isotope::I127,
    Isotope::I128,
    Isotope::I129,
    Isotope::I130,
    Isotope::I131,
    Isotope::I132,
    Isotope::I133,
    Isotope::I134,
    Isotope::I135,
    Isotope::I136,
    Isotope::I137,
    Isotope::I138,
    Isotope::I139,
    Isotope::I140,
    Isotope::I141,
    Isotope::I142,
    Isotope::I143,
    Isotope::I144,
    Isotope::I145,
    Isotope::I146,
    Isotope::I147,
    Isotope::Xe108,
    Isotope::Xe109,
    Isotope::Xe110,
    Isotope::Xe111,
    Isotope::Xe112,
    Isotope::Xe113,
    Isotope::Xe114,
    Isotope::Xe115,
    Isotope::Xe116,
    Isotope::Xe117,
    Isotope::Xe118,
    Isotope::Xe119,
    Isotope::Xe120,
    Isotope::Xe121,
    Isotope::Xe122,
    Isotope::Xe123,
    Isotope::Xe124,
    Isotope::Xe125,
    Isotope::Xe126,
    Isotope::Xe127,
    Isotope::Xe128,
    Isotope::Xe129,
    Isotope::Xe130,
    Isotope::Xe131,
    Isotope::Xe132,
    Isotope::Xe133,
    Isotope::Xe134,
    Isotope::Xe135,
    Isotope::Xe136,
    Isotope::Xe137,
    Isotope::Xe138,
    Isotope::Xe139,
    Isotope::Xe140,
    Isotope::Xe141,
    Isotope::Xe142,
    Isotope::Xe143,
    Isotope::Xe144,
    Isotope::Xe145,
    Isotope::Xe146,
    Isotope::Xe147,
    Isotope::Xe148,
    Isotope::Xe149,
    Isotope::Xe150,
    Isotope::Cs111,
    Isotope::Cs112,
    Isotope::Cs113,
    Isotope::Cs114,
    Isotope::Cs115,
    Isotope::Cs116,
    Isotope::Cs117,
    Isotope::Cs118,
    Isotope::Cs119,
    Isotope::Cs120,
    Isotope::Cs121,
    Isotope::Cs122,
    Isotope::Cs123,
    Isotope::Cs124,
    Isotope::Cs125,
    Isotope::Cs126,
    Isotope::Cs127,
    Isotope::Cs128,
    Isotope::Cs129,
    Isotope::Cs130,
    Isotope::Cs131,
    Isotope::Cs132,
    Isotope::Cs133,
    Isotope::Cs134,
    Isotope::Cs135,
    Isotope::Cs136,
    Isotope::Cs137,
    Isotope::Cs138,
    Isotope::Cs139,
    Isotope::Cs140,
    Isotope::Cs141,
    Isotope::Cs142,
    Isotope::Cs143,
    Isotope::Cs144,
    Isotope::Cs145,
    Isotope::Cs146,
    Isotope::Cs147,
    Isotope::Cs148,
    Isotope::Cs149,
    Isotope::Cs150,
    Isotope::Cs151,
    Isotope::Cs152,
    Isotope::Ba113,
    Isotope::Ba114,
    Isotope::Ba115,
    Isotope::Ba116,
    Isotope::Ba117,
    Isotope::Ba118,
    Isotope::Ba119,
    Isotope::Ba120,
    Isotope::Ba121,
    Isotope::Ba122,
    Isotope::Ba123,
    Isotope::Ba124,
    Isotope::Ba125,
    Isotope::Ba126,
    Isotope::Ba127,
    Isotope::Ba128,
    Isotope::Ba129,
    Isotope::Ba130,
    Isotope::Ba131,
    Isotope::Ba132,
    Isotope::Ba133,
    Isotope::Ba134,
    Isotope::Ba135,
    Isotope::Ba136,
    Isotope::Ba137,
    Isotope::Ba138,
    Isotope::Ba139,
    Isotope::Ba140,
    Isotope::Ba141,
    Isotope::Ba142,
    Isotope::Ba143,
    Isotope::Ba144,
    Isotope::Ba145,
    Isotope::Ba146,
    Isotope::Ba147,
    Isotope::Ba148,
    Isotope::Ba149,
    Isotope::Ba150,
    Isotope::Ba151,
    Isotope::Ba152,
    Isotope::Ba153,
    Isotope::Ba154,
    Isotope::La116,
    Isotope::La117,
    Isotope::La118,
    Isotope::La119,
    Isotope::La120,
    Isotope::La121,
    Isotope::La122,
    Isotope::La123,
    Isotope::La124,
    Isotope::La125,
    Isotope::La126,
    Isotope::La127,
    Isotope::La128,
    Isotope::La129,
    Isotope::La130,
    Isotope::La131,
    Isotope::La132,
    Isotope::La133,
    Isotope::La134,
    Isotope::La135,
    Isotope::La136,
    Isotope::La137,
    Isotope::La138,
    Isotope::La139,
    Isotope::La140,
    Isotope::La141,
    Isotope::La142,
    Isotope::La143,
    Isotope::La144,
    Isotope::La145,
    Isotope::La146,
    Isotope::La147,
    Isotope::La148,
    Isotope::La149,
    Isotope::La150,
    Isotope::La151,
    Isotope::La152,
    Isotope::La153,
    Isotope::La154,
    Isotope::La155,
    Isotope::La156,
    Isotope::La157,
    Isotope::Ce119,
    Isotope::Ce120,
    Isotope::Ce121,
    Isotope::Ce122,
    Isotope::Ce123,
    Isotope::Ce124,
    Isotope::Ce125,
    Isotope::Ce126,
    Isotope::Ce127,
    Isotope::Ce128,
    Isotope::Ce129,
    Isotope::Ce130,
    Isotope::Ce131,
    Isotope::Ce132,
    Isotope::Ce133,
    Isotope::Ce134,
    Isotope::Ce135,
    Isotope::Ce136,
    Isotope::Ce137,
    Isotope::Ce138,
    Isotope::Ce139,
    Isotope::Ce140,
    Isotope::Ce141,
    Isotope::Ce142,
    Isotope::Ce143,
    Isotope::Ce144,
    Isotope::Ce145,
    Isotope::Ce146,
    Isotope::Ce147,
    Isotope::Ce148,
    Isotope::Ce149,
    Isotope::Ce150,
    Isotope::Ce151,
    Isotope::Ce152,
    Isotope::Ce153,
    Isotope::Ce154,
    Isotope::Ce155,
    Isotope::Ce156,
    Isotope::Ce157,
    Isotope::Ce158,
    Isotope::Ce159,
    Isotope::Pr121,
    Isotope::Pr122,
    Isotope::Pr123,
    Isotope::Pr124,
    Isotope::Pr125,
    Isotope::Pr126,
    Isotope::Pr127,
    Isotope::Pr128,
    Isotope::Pr129,
    Isotope::Pr130,
    Isotope::Pr131,
    Isotope::Pr132,
    Isotope::Pr133,
    Isotope::Pr134,
    Isotope::Pr135,
    Isotope::Pr136,
    Isotope::Pr137,
    Isotope::Pr138,
    Isotope::Pr139,
    Isotope::Pr140,
    Isotope::Pr141,
    Isotope::Pr142,
    Isotope::Pr143,
    Isotope::Pr144,
    Isotope::Pr145,
    Isotope::Pr146,
    Isotope::Pr147,
    Isotope::Pr148,
    Isotope::Pr149,
    Isotope::Pr150,
    Isotope::Pr151,
    Isotope::Pr152,
    Isotope::Pr153,
    Isotope::Pr154,
    Isotope::Pr155,
    Isotope::Pr156,
    Isotope::Pr157,
    Isotope::Pr158,
    Isotope::Pr159,
    Isotope::Pr160,
    Isotope::Pr161,
    Isotope::Nd124,
    Isotope::Nd125,
    Isotope::Nd126,
    Isotope::Nd127,
    Isotope::Nd128,
    Isotope::Nd129,
    Isotope::Nd130,
    Isotope::Nd131,
    Isotope::Nd132,
    Isotope::Nd133,
    Isotope::Nd134,
    Isotope::Nd135,
    Isotope::Nd136,
    Isotope::Nd137,
    Isotope::Nd138,
    Isotope::Nd139,
    Isotope::Nd140,
    Isotope::Nd141,
    Isotope::Nd142,
    Isotope::Nd143,
    Isotope::Nd144,
    Isotope::Nd145,
    Isotope::Nd146,
    Isotope::Nd147,
    Isotope::Nd148,
    Isotope::Nd149,
    Isotope::Nd150,
    Isotope::Nd151,
    Isotope::Nd152,
    Isotope::Nd153,
    Isotope::Nd154,
    Isotope::Nd155,
    Isotope::Nd156,
    Isotope::Nd157,
    Isotope::Nd158,
    Isotope::Nd159,
    Isotope::Nd160,
    Isotope::Nd161,
    Isotope::Nd162,
    Isotope::Nd163,
    Isotope::Pm126,
    Isotope::Pm127,
    Isotope::Pm128,
    Isotope::Pm129,
    Isotope::Pm130,
    Isotope::Pm131,
    Isotope::Pm132,
    Isotope::Pm133,
    Isotope::Pm134,
    Isotope::Pm135,
    Isotope::Pm136,
    Isotope::Pm137,
    Isotope::Pm138,
    Isotope::Pm139,
    Isotope::Pm140,
    Isotope::Pm141,
    Isotope::Pm142,
    Isotope::Pm143,
    Isotope::Pm144,
    Isotope::Pm145,
    Isotope::Pm146,
    Isotope::Pm147,
    Isotope::Pm148,
    Isotope::Pm149,
    Isotope::Pm150,
    Isotope::Pm151,
    Isotope::Pm152,
    Isotope::Pm153,
    Isotope::Pm154,
    Isotope::Pm155,
    Isotope::Pm156,
    Isotope::Pm157,
    Isotope::Pm158,
    Isotope::Pm159,
    Isotope::Pm160,
    Isotope::Pm161,
    Isotope::Pm162,
    Isotope::Pm163,
    Isotope::Pm164,
    Isotope::Pm165,
    Isotope::Sm128,
    Isotope::Sm129,
    Isotope::Sm130,
    Isotope::Sm131,
    Isotope::Sm132,
    Isotope::Sm133,
    Isotope::Sm134,
    Isotope::Sm135,
    Isotope::Sm136,
    Isotope::Sm137,
    Isotope::Sm138,
    Isotope::Sm139,
    Isotope::Sm140,
    Isotope::Sm141,
    Isotope::Sm142,
    Isotope::Sm143,
    Isotope::Sm144,
    Isotope::Sm145,
    Isotope::Sm146,
    Isotope::Sm147,
    Isotope::Sm148,
    Isotope::Sm149,
    Isotope::Sm150,
    Isotope::Sm151,
    Isotope::Sm152,
    Isotope::Sm153,
    Isotope::Sm154,
    Isotope::Sm155,
    Isotope::Sm156,
    Isotope::Sm157,
    Isotope::Sm158,
    Isotope::Sm159,
    Isotope::Sm160,
    Isotope::Sm161,
    Isotope::Sm162,
    Isotope::Sm163,
    Isotope::Sm164,
    Isotope::Sm165,
    Isotope::Sm166,
    Isotope::Sm167,
    Isotope::Sm168,
    Isotope::Eu130,
    Isotope::Eu131,
    Isotope::Eu132,
    Isotope::Eu133,
    Isotope::Eu134,
    Isotope::Eu135,
    Isotope::Eu136,
    Isotope::Eu137,
    Isotope::Eu138,
    Isotope::Eu139,
    Isotope::Eu140,
    Isotope::Eu141,
    Isotope::Eu142,
    Isotope::Eu143,
    Isotope::Eu144,
    Isotope::Eu145,
    Isotope::Eu146,
    Isotope::Eu147,
    Isotope::Eu148,
    Isotope::Eu149,
    Isotope::Eu150,
    Isotope::Eu151,
    Isotope::Eu152,
    Isotope::Eu153,
    Isotope::Eu154,
    Isotope::Eu155,
    Isotope::Eu156,
    Isotope::Eu157,
    Isotope::Eu158,
    Isotope::Eu159,
    Isotope::Eu160,
    Isotope::Eu161,
    Isotope::Eu162,
    Isotope::Eu163,
    Isotope::Eu164,
    Isotope::Eu165,
    Isotope::Eu166,
    Isotope::Eu167,
    Isotope::Eu168,
    Isotope::Eu169,
    Isotope::Eu170,
    Isotope::Gd133,
    Isotope::Gd134,
    Isotope::Gd135,
    Isotope::Gd136,
    Isotope::Gd137,
    Isotope::Gd138,
    Isotope::Gd139,
    Isotope::Gd140,
    Isotope::Gd141,
    Isotope::Gd142,
    Isotope::Gd143,
    Isotope::Gd144,
    Isotope::Gd145,
    Isotope::Gd146,
    Isotope::Gd147,
    Isotope::Gd148,
    Isotope::Gd149,
    Isotope::Gd150,
    Isotope::Gd151,
    Isotope::Gd152,
    Isotope::Gd153,
    Isotope::Gd154,
    Isotope::Gd155,
    Isotope::Gd156,
    Isotope::Gd157,
    Isotope::Gd158,
    Isotope::Gd159,
    Isotope::Gd160,
    Isotope::Gd161,
    Isotope::Gd162,
    Isotope::Gd163,
    Isotope::Gd164,
    Isotope::Gd165,
    Isotope::Gd166,
    Isotope::Gd167,
    Isotope::Gd168,
    Isotope::Gd169,
    Isotope::Gd170,
    Isotope::Gd171,
    Isotope::Gd172,
    Isotope::Tb135,
    Isotope::Tb136,
    Isotope::Tb137,
    Isotope::Tb138,
    Isotope::Tb139,
    Isotope::Tb140,
    Isotope::Tb141,
    Isotope::Tb142,
    Isotope::Tb143,
    Isotope::Tb144,
    Isotope::Tb145,
    Isotope::Tb146,
    Isotope::Tb147,
    Isotope::Tb148,
    Isotope::Tb149,
    Isotope::Tb150,
    Isotope::Tb151,
    Isotope::Tb152,
    Isotope::Tb153,
    Isotope::Tb154,
    Isotope::Tb155,
    Isotope::Tb156,
    Isotope::Tb157,
    Isotope::Tb158,
    Isotope::Tb159,
    Isotope::Tb160,
    Isotope::Tb161,
    Isotope::Tb162,
    Isotope::Tb163,
    Isotope::Tb164,
    Isotope::Tb165,
    Isotope::Tb166,
    Isotope::Tb167,
    Isotope::Tb168,
    Isotope::Tb169,
    Isotope::Tb170,
    Isotope::Tb171,
    Isotope::Tb172,
    Isotope::Tb173,
    Isotope::Tb174,
    Isotope::Dy138,
    Isotope::Dy139,
    Isotope::Dy140,
    Isotope::Dy141,
    Isotope::Dy142,
    Isotope::Dy143,
    Isotope::Dy144,
    Isotope::Dy145,
    Isotope::Dy146,
    Isotope::Dy147,
    Isotope::Dy148,
    Isotope::Dy149,
    Isotope::Dy150,
    Isotope::Dy151,
    Isotope::Dy152,
    Isotope::Dy153,
    Isotope::Dy154,
    Isotope::Dy155,
    Isotope::Dy156,
    Isotope::Dy157,
    Isotope::Dy158,
    Isotope::Dy159,
    Isotope::Dy160,
    Isotope::Dy161,
    Isotope::Dy162,
    Isotope::Dy163,
    Isotope::Dy164,
    Isotope::Dy165,
    Isotope::Dy166,
    Isotope::Dy167,
    Isotope::Dy168,
    Isotope::Dy169,
    Isotope::Dy170,
    Isotope::Dy171,
    Isotope::Dy172,
    Isotope::Dy173,
    Isotope::Dy174,
    Isotope::Dy175,
    Isotope::Dy176,
    Isotope::Ho140,
    Isotope::Ho141,
    Isotope::Ho142,
    Isotope::Ho143,
    Isotope::Ho144,
    Isotope::Ho145,
    Isotope::Ho146,
    Isotope::Ho147,
    Isotope::Ho148,
    Isotope::Ho149,
    Isotope::Ho150,
    Isotope::Ho151,
    Isotope::Ho152,
    Isotope::Ho153,
    Isotope::Ho154,
    Isotope::Ho155,
    Isotope::Ho156,
    Isotope::Ho157,
    Isotope::Ho158,
    Isotope::Ho159,
    Isotope::Ho160,
    Isotope::Ho161,
    Isotope::Ho162,
    Isotope::Ho163,
    Isotope::Ho164,
    Isotope::Ho165,
    Isotope::Ho166,
    Isotope::Ho167,
    Isotope::Ho168,
    Isotope::Ho169,
    Isotope::Ho170,
    Isotope::Ho171,
    Isotope::Ho172,
    Isotope::Ho173,
    Isotope::Ho174,
    Isotope::Ho175,
    Isotope::Ho176,
    Isotope::Ho177,
    Isotope::Ho178,
    Isotope::Er142,
    Isotope::Er143,
    Isotope::Er144,
    Isotope::Er145,
    Isotope::Er146,
    Isotope::Er147,
    Isotope::Er148,
    Isotope::Er149,
    Isotope::Er150,
    Isotope::Er151,
    Isotope::Er152,
    Isotope::Er153,
    Isotope::Er154,
    Isotope::Er155,
    Isotope::Er156,
    Isotope::Er157,
    Isotope::Er158,
    Isotope::Er159,
    Isotope::Er160,
    Isotope::Er161,
    Isotope::Er162,
    Isotope::Er163,
    Isotope::Er164,
    Isotope::Er165,
    Isotope::Er166,
    Isotope::Er167,
    Isotope::Er168,
    Isotope::Er169,
    Isotope::Er170,
    Isotope::Er171,
    Isotope::Er172,
    Isotope::Er173,
    Isotope::Er174,
    Isotope::Er175,
    Isotope::Er176,
    Isotope::Er177,
    Isotope::Er178,
    Isotope::Er179,
    Isotope::Er180,
    Isotope::Tm144,
    Isotope::Tm145,
    Isotope::Tm146,
    Isotope::Tm147,
    Isotope::Tm148,
    Isotope::Tm149,
    Isotope::Tm150,
    Isotope::Tm151,
    Isotope::Tm152,
    Isotope::Tm153,
    Isotope::Tm154,
    Isotope::Tm155,
    Isotope::Tm156,
    Isotope::Tm157,
    Isotope::Tm158,
    Isotope::Tm159,
    Isotope::Tm160,
    Isotope::Tm161,
    Isotope::Tm162,
    Isotope::Tm163,
    Isotope::Tm164,
    Isotope::Tm165,
    Isotope::Tm166,
    Isotope::Tm167,
    Isotope::Tm168,
    Isotope::Tm169,
    Isotope::Tm170,
    Isotope::Tm171,
    Isotope::Tm172,
    Isotope::Tm173,
    Isotope::Tm174,
    Isotope::Tm175,
    Isotope::Tm176,
    Isotope::Tm177,
    Isotope::Tm178,
    Isotope::Tm179,
    Isotope::Tm180,
    Isotope::Tm181,
    Isotope::Tm182,
    Isotope::Yb148,
    Isotope::Yb149,
    Isotope::Yb150,
    Isotope::Yb151,
    Isotope::Yb152,
    Isotope::Yb153,
    Isotope::Yb154,
    Isotope::Yb155,
    Isotope::Yb156,
    Isotope::Yb157,
    Isotope::Yb158,
    Isotope::Yb159,
    Isotope::Yb160,
    Isotope::Yb161,
    Isotope::Yb162,
    Isotope::Yb163,
    Isotope::Yb164,
    Isotope::Yb165,
    Isotope::Yb166,
    Isotope::Yb167,
    Isotope::Yb168,
    Isotope::Yb169,
    Isotope::Yb170,
    Isotope::Yb171,
    Isotope::Yb172,
    Isotope::Yb173,
    Isotope::Yb174,
    Isotope::Yb175,
    Isotope::Yb176,
    Isotope::Yb177,
    Isotope::Yb178,
    Isotope::Yb179,
    Isotope::Yb180,
    Isotope::Yb181,
    Isotope::Yb182,
    Isotope::Yb183,
    Isotope::Yb184,
    Isotope::Yb185,
    Isotope::Lu150,
    Isotope::Lu151,
    Isotope::Lu152,
    Isotope::Lu153,
    Isotope::Lu154,
    Isotope::Lu155,
    Isotope::Lu156,
    Isotope::Lu157,
    Isotope::Lu158,
    Isotope::Lu159,
    Isotope::Lu160,
    Isotope::Lu161,
    Isotope::Lu162,
    Isotope::Lu163,
    Isotope::Lu164,
    Isotope::Lu165,
    Isotope::Lu166,
    Isotope::Lu167,
    Isotope::Lu168,
    Isotope::Lu169,
    Isotope::Lu170,
    Isotope::Lu171,
    Isotope::Lu172,
    Isotope::Lu173,
    Isotope::Lu174,
    Isotope::Lu175,
    Isotope::Lu176,
    Isotope::Lu177,
    Isotope::Lu178,
    Isotope::Lu179,
    Isotope::Lu180,
    Isotope::Lu181,
    Isotope::Lu182,
    Isotope::Lu183,
    Isotope::Lu184,
    Isotope::Lu185,
    Isotope::Lu186,
    Isotope::Lu187,
    Isotope::Lu188,
    Isotope::Hf153,
    Isotope::Hf154,
    Isotope::Hf155,
    Isotope::Hf156,
    Isotope::Hf157,
    Isotope::Hf158,
    Isotope::Hf159,
    Isotope::Hf160,
    Isotope::Hf161,
    Isotope::Hf162,
    Isotope::Hf163,
    Isotope::Hf164,
    Isotope::Hf165,
    Isotope::Hf166,
    Isotope::Hf167,
    Isotope::Hf168,
    Isotope::Hf169,
    Isotope::Hf170,
    Isotope::Hf171,
    Isotope::Hf172,
    Isotope::Hf173,
    Isotope::Hf174,
    Isotope::Hf175,
    Isotope::Hf176,
    Isotope::Hf177,
    Isotope::Hf178,
    Isotope::Hf179,
    Isotope::Hf180,
    Isotope::Hf181,
    Isotope::Hf182,
    Isotope::Hf183,
    Isotope::Hf184,
    Isotope::Hf185,
    Isotope::Hf186,
    Isotope::Hf187,
    Isotope::Hf188,
    Isotope::Hf189,
    Isotope::Hf190,
    Isotope::Ta155,
    Isotope::Ta156,
    Isotope::Ta157,
    Isotope::Ta158,
    Isotope::Ta159,
    Isotope::Ta160,
    Isotope::Ta161,
    Isotope::Ta162,
    Isotope::Ta163,
    Isotope::Ta164,
    Isotope::Ta165,
    Isotope::Ta166,
    Isotope::Ta167,
    Isotope::Ta168,
    Isotope::Ta169,
    Isotope::Ta170,
    Isotope::Ta171,
    Isotope::Ta172,
    Isotope::Ta173,
    Isotope::Ta174,
    Isotope::Ta175,
    Isotope::Ta176,
    Isotope::Ta177,
    Isotope::Ta178,
    Isotope::Ta179,
    Isotope::Ta180,
    Isotope::Ta181,
    Isotope::Ta182,
    Isotope::Ta183,
    Isotope::Ta184,
    Isotope::Ta185,
    Isotope::Ta186,
    Isotope::Ta187,
    Isotope::Ta188,
    Isotope::Ta189,
    Isotope::Ta190,
    Isotope::Ta191,
    Isotope::Ta192,
    Isotope::Ta193,
    Isotope::Ta194,
    Isotope::W157,
    Isotope::W158,
    Isotope::W159,
    Isotope::W160,
    Isotope::W161,
    Isotope::W162,
    Isotope::W163,
    Isotope::W164,
    Isotope::W165,
    Isotope::W166,
    Isotope::W167,
    Isotope::W168,
    Isotope::W169,
    Isotope::W170,
    Isotope::W171,
    Isotope::W172,
    Isotope::W173,
    Isotope::W174,
    Isotope::W175,
    Isotope::W176,
    Isotope::W177,
    Isotope::W178,
    Isotope::W179,
    Isotope::W180,
    Isotope::W181,
    Isotope::W182,
    Isotope::W183,
    Isotope::W184,
    Isotope::W185,
    Isotope::W186,
    Isotope::W187,
    Isotope::W188,
    Isotope::W189,
    Isotope::W190,
    Isotope::W191,
    Isotope::W192,
    Isotope::W193,
    Isotope::W194,
    Isotope::W195,
    Isotope::W196,
    Isotope::W197,
    Isotope::Re159,
    Isotope::Re160,
    Isotope::Re161,
    Isotope::Re162,
    Isotope::Re163,
    Isotope::Re164,
    Isotope::Re165,
    Isotope::Re166,
    Isotope::Re167,
    Isotope::Re168,
    Isotope::Re169,
    Isotope::Re170,
    Isotope::Re171,
    Isotope::Re172,
    Isotope::Re173,
    Isotope::Re174,
    Isotope::Re175,
    Isotope::Re176,
    Isotope::Re177,
    Isotope::Re178,
    Isotope::Re179,
    Isotope::Re180,
    Isotope::Re181,
    Isotope::Re182,
    Isotope::Re183,
    Isotope::Re184,
    Isotope::Re185,
    Isotope::Re186,
    Isotope::Re187,
    Isotope::Re188,
    Isotope::Re189,
    Isotope::Re190,
    Isotope::Re191,
    Isotope::Re192,
    Isotope::Re193,
    Isotope::Re194,
    Isotope::Re195,
    Isotope::Re196,
    Isotope::Re197,
    Isotope::Re198,
    Isotope::Re199,
    Isotope::Os161,
    Isotope::Os162,
    Isotope::Os163,
    Isotope::Os164,
    Isotope::Os165,
    Isotope::Os166,
    Isotope::Os167,
    Isotope::Os168,
    Isotope::Os169,
    Isotope::Os170,
    Isotope::Os171,
    Isotope::Os172,
    Isotope::Os173,
    Isotope::Os174,
    Isotope::Os175,
    Isotope::Os176,
    Isotope::Os177,
    Isotope::Os178,
    Isotope::Os179,
    Isotope::Os180,
    Isotope::Os181,
    Isotope::Os182,
    Isotope::Os183,
    Isotope::Os184,
    Isotope::Os185,
    Isotope::Os186,
    Isotope::Os187,
    Isotope::Os188,
    Isotope::Os189,
    Isotope::Os190,
    Isotope::Os191,
    Isotope::Os192,
    Isotope::Os193,
    Isotope::Os194,
    Isotope::Os195,
    Isotope::Os196,
    Isotope::Os197,
    Isotope::Os198,
    Isotope::Os199,
    Isotope::Os200,
    Isotope::Os201,
    Isotope::Os202,
    Isotope::Os203,
    Isotope::Ir163,
    Isotope::Ir164,
    Isotope::Ir165,
    Isotope::Ir166,
    Isotope::Ir167,
    Isotope::Ir168,
    Isotope::Ir169,
    Isotope::Ir170,
    Isotope::Ir171,
    Isotope::Ir172,
    Isotope::Ir173,
    Isotope::Ir174,
    Isotope::Ir175,
    Isotope::Ir176,
    Isotope::Ir177,
    Isotope::Ir178,
    Isotope::Ir179,
    Isotope::Ir180,
    Isotope::Ir181,
    Isotope::Ir182,
    Isotope::Ir183,
    Isotope::Ir184,
    Isotope::Ir185,
    Isotope::Ir186,
    Isotope::Ir187,
    Isotope::Ir188,
    Isotope::Ir189,
    Isotope::Ir190,
    Isotope::Ir191,
    Isotope::Ir192,
    Isotope::Ir193,
    Isotope::Ir194,
    Isotope::Ir195,
    Isotope::Ir196,
    Isotope::Ir197,
    Isotope::Ir198,
    Isotope::Ir199,
    Isotope::Ir200,
    Isotope::Ir201,
    Isotope::Ir202,
    Isotope::Ir203,
    Isotope::Ir204,
    Isotope::Ir205,
    Isotope::Pt165,
    Isotope::Pt166,
    Isotope::Pt167,
    Isotope::Pt168,
    Isotope::Pt169,
    Isotope::Pt170,
    Isotope::Pt171,
    Isotope::Pt172,
    Isotope::Pt173,
    Isotope::Pt174,
    Isotope::Pt175,
    Isotope::Pt176,
    Isotope::Pt177,
    Isotope::Pt178,
    Isotope::Pt179,
    Isotope::Pt180,
    Isotope::Pt181,
    Isotope::Pt182,
    Isotope::Pt183,
    Isotope::Pt184,
    Isotope::Pt185,
    Isotope::Pt186,
    Isotope::Pt187,
    Isotope::Pt188,
    Isotope::Pt189,
    Isotope::Pt190,
    Isotope::Pt191,
    Isotope::Pt192,
    Isotope::Pt193,
    Isotope::Pt194,
    Isotope::Pt195,
    Isotope::Pt196,
    Isotope::Pt197,
    Isotope::Pt198,
    Isotope::Pt199,
    Isotope::Pt200,
    Isotope::Pt201,
    Isotope::Pt202,
    Isotope::Pt203,
    Isotope::Pt204,
    Isotope::Pt205,
    Isotope::Pt206,
    Isotope::Pt207,
    Isotope::Pt208,
    Isotope::Au168,
    Isotope::Au169,
    Isotope::Au170,
    Isotope::Au171,
    Isotope::Au172,
    Isotope::Au173,
    Isotope::Au174,
    Isotope::Au175,
    Isotope::Au176,
    Isotope::Au177,
    Isotope::Au178,
    Isotope::Au179,
    Isotope::Au180,
    Isotope::Au181,
    Isotope::Au182,
    Isotope::Au183,
    Isotope::Au184,
    Isotope::Au185,
    Isotope::Au186,
    Isotope::Au187,
    Isotope::Au188,
    Isotope::Au189,
    Isotope::Au190,
    Isotope::Au191,
    Isotope::Au192,
    Isotope::Au193,
    Isotope::Au194,
    Isotope::Au195,
    Isotope::Au196,
    Isotope::Au197,
    Isotope::Au198,
    Isotope::Au199,
    Isotope::Au200,
    Isotope::Au201,
    Isotope::Au202,
    Isotope::Au203,
    Isotope::Au204,
    Isotope::Au205,
    Isotope::Au206,
    Isotope::Au207,
    Isotope::Au208,
    Isotope::Au209,
    Isotope::Au210,
    Isotope::Hg170,
    Isotope::Hg171,
    Isotope::Hg172,
    Isotope::Hg173,
    Isotope::Hg174,
    Isotope::Hg175,
    Isotope::Hg176,
    Isotope::Hg177,
    Isotope::Hg178,
    Isotope::Hg179,
    Isotope::Hg180,
    Isotope::Hg181,
    Isotope::Hg182,
    Isotope::Hg183,
    Isotope::Hg184,
    Isotope::Hg185,
    Isotope::Hg186,
    Isotope::Hg187,
    Isotope::Hg188,
    Isotope::Hg189,
    Isotope::Hg190,
    Isotope::Hg191,
    Isotope::Hg192,
    Isotope::Hg193,
    Isotope::Hg194,
    Isotope::Hg195,
    Isotope::Hg196,
    Isotope::Hg197,
    Isotope::Hg198,
    Isotope::Hg199,
    Isotope::Hg200,
    Isotope::Hg201,
    Isotope::Hg202,
    Isotope::Hg203,
    Isotope::Hg204,
    Isotope::Hg205,
    Isotope::Hg206,
    Isotope::Hg207,
    Isotope::Hg208,
    Isotope::Hg209,
    Isotope::Hg210,
    Isotope::Hg211,
    Isotope::Hg212,
    Isotope::Hg213,
    Isotope::Hg214,
    Isotope::Hg215,
    Isotope::Hg216,
    Isotope::Tl176,
    Isotope::Tl177,
    Isotope::Tl178,
    Isotope::Tl179,
    Isotope::Tl180,
    Isotope::Tl181,
    Isotope::Tl182,
    Isotope::Tl183,
    Isotope::Tl184,
    Isotope::Tl185,
    Isotope::Tl186,
    Isotope::Tl187,
    Isotope::Tl188,
    Isotope::Tl189,
    Isotope::Tl190,
    Isotope::Tl191,
    Isotope::Tl192,
    Isotope::Tl193,
    Isotope::Tl194,
    Isotope::Tl195,
    Isotope::Tl196,
    Isotope::Tl197,
    Isotope::Tl198,
    Isotope::Tl199,
    Isotope::Tl200,
    Isotope::Tl201,
    Isotope::Tl202,
    Isotope::Tl203,
    Isotope::Tl204,
    Isotope::Tl205,
    Isotope::Tl206,
    Isotope::Tl207,
    Isotope::Tl208,
    Isotope::Tl209,
    Isotope::Tl210,
    Isotope::Tl211,
    Isotope::Tl212,
    Isotope::Tl213,
    Isotope::Tl214,
    Isotope::Tl215,
    Isotope::Tl216,
    Isotope::Tl217,
    Isotope::Tl218,
    Isotope::Pb178,
    Isotope::Pb179,
    Isotope::Pb180,
    Isotope::Pb181,
    Isotope::Pb182,
    Isotope::Pb183,
    Isotope::Pb184,
    Isotope::Pb185,
    Isotope::Pb186,
    Isotope::Pb187,
    Isotope::Pb188,
    Isotope::Pb189,
    Isotope::Pb190,
    Isotope::Pb191,
    Isotope::Pb192,
    Isotope::Pb193,
    Isotope::Pb194,
    Isotope::Pb195,
    Isotope::Pb196,
    Isotope::Pb197,
    Isotope::Pb198,
    Isotope::Pb199,
    Isotope::Pb200,
    Isotope::Pb201,
    Isotope::Pb202,
    Isotope::Pb203,
    Isotope::Pb204,
    Isotope::Pb205,
    Isotope::Pb206,
    Isotope::Pb207,
    Isotope::Pb208,
    Isotope::Pb209,
    Isotope::Pb210,
    Isotope::Pb211,
    Isotope::Pb212,
    Isotope::Pb213,
    Isotope::Pb214,
    Isotope::Pb215,
    Isotope::Pb216,
    Isotope::Pb217,
    Isotope::Pb218,
    Isotope::Pb219,
    Isotope::Pb220,
    Isotope::Bi184,
    Isotope::Bi185,
    Isotope::Bi186,
    Isotope::Bi187,
    Isotope::Bi188,
    Isotope::Bi189,
    Isotope::Bi190,
    Isotope::Bi191,
    Isotope::Bi192,
    Isotope::Bi193,
    Isotope::Bi194,
    Isotope::Bi195,
    Isotope::Bi196,
    Isotope::Bi197,
    Isotope::Bi198,
    Isotope::Bi199,
    Isotope::Bi200,
    Isotope::Bi201,
    Isotope::Bi202,
    Isotope::Bi203,
    Isotope::Bi204,
    Isotope::Bi205,
    Isotope::Bi206,
    Isotope::Bi207,
    Isotope::Bi208,
    Isotope::Bi209,
    Isotope::Bi210,
    Isotope::Bi211,
    Isotope::Bi212,
    Isotope::Bi213,
    Isotope::Bi214,
    Isotope::Bi215,
    Isotope::Bi216,
    Isotope::Bi217,
    Isotope::Bi218,
    Isotope::Bi219,
    Isotope::Bi220,
    Isotope::Bi221,
    Isotope::Bi222,
    Isotope::Bi223,
    Isotope::Bi224,
    Isotope::Po186,
    Isotope::Po187,
    Isotope::Po188,
    Isotope::Po189,
    Isotope::Po190,
    Isotope::Po191,
    Isotope::Po192,
    Isotope::Po193,
    Isotope::Po194,
    Isotope::Po195,
    Isotope::Po196,
    Isotope::Po197,
    Isotope::Po198,
    Isotope::Po199,
    Isotope::Po200,
    Isotope::Po201,
    Isotope::Po202,
    Isotope::Po203,
    Isotope::Po204,
    Isotope::Po205,
    Isotope::Po206,
    Isotope::Po207,
    Isotope::Po208,
    Isotope::Po209,
    Isotope::Po210,
    Isotope::Po211,
    Isotope::Po212,
    Isotope::Po213,
    Isotope::Po214,
    Isotope::Po215,
    Isotope::Po216,
    Isotope::Po217,
    Isotope::Po218,
    Isotope::Po219,
    Isotope::Po220,
    Isotope::Po221,
    Isotope::Po222,
    Isotope::Po223,
    Isotope::Po224,
    Isotope::Po225,
    Isotope::Po226,
    Isotope::Po227,
    Isotope::At191,
    Isotope::At192,
    Isotope::At193,
    Isotope::At194,
    Isotope::At195,
    Isotope::At196,
    Isotope::At197,
    Isotope::At198,
    Isotope::At199,
    Isotope::At200,
    Isotope::At201,
    Isotope::At202,
    Isotope::At203,
    Isotope::At204,
    Isotope::At205,
    Isotope::At206,
    Isotope::At207,
    Isotope::At208,
    Isotope::At209,
    Isotope::At210,
    Isotope::At211,
    Isotope::At212,
    Isotope::At213,
    Isotope::At214,
    Isotope::At215,
    Isotope::At216,
    Isotope::At217,
    Isotope::At218,
    Isotope::At219,
    Isotope::At220,
    Isotope::At221,
    Isotope::At222,
    Isotope::At223,
    Isotope::At224,
    Isotope::At225,
    Isotope::At226,
    Isotope::At227,
    Isotope::At228,
    Isotope::At229,
    Isotope::Rn193,
    Isotope::Rn194,
    Isotope::Rn195,
    Isotope::Rn196,
    Isotope::Rn197,
    Isotope::Rn198,
    Isotope::Rn199,
    Isotope::Rn200,
    Isotope::Rn201,
    Isotope::Rn202,
    Isotope::Rn203,
    Isotope::Rn204,
    Isotope::Rn205,
    Isotope::Rn206,
    Isotope::Rn207,
    Isotope::Rn208,
    Isotope::Rn209,
    Isotope::Rn210,
    Isotope::Rn211,
    Isotope::Rn212,
    Isotope::Rn213,
    Isotope::Rn214,
    Isotope::Rn215,
    Isotope::Rn216,
    Isotope::Rn217,
    Isotope::Rn218,
    Isotope::Rn219,
    Isotope::Rn220,
    Isotope::Rn221,
    Isotope::Rn222,
    Isotope::Rn223,
    Isotope::Rn224,
    Isotope::Rn225,
    Isotope::Rn226,
    Isotope::Rn227,
    Isotope::Rn228,
    Isotope::Rn229,
    Isotope::Rn230,
    Isotope::Rn231,
    Isotope::Fr197,
    Isotope::Fr198,
    Isotope::Fr199,
    Isotope::Fr200,
    Isotope::Fr201,
    Isotope::Fr202,
    Isotope::Fr203,
    Isotope::Fr204,
    Isotope::Fr205,
    Isotope::Fr206,
    Isotope::Fr207,
    Isotope::Fr208,
    Isotope::Fr209,
    Isotope::Fr210,
    Isotope::Fr211,
    Isotope::Fr212,
    Isotope::Fr213,
    Isotope::Fr214,
    Isotope::Fr215,
    Isotope::Fr216,
    Isotope::Fr217,
    Isotope::Fr218,
    Isotope::Fr219,
    Isotope::Fr220,
    Isotope::Fr221,
    Isotope::Fr222,
    Isotope::Fr223,
    Isotope::Fr224,
    Isotope::Fr225,
    Isotope::Fr226,
    Isotope::Fr227,
    Isotope::Fr228,
    Isotope::Fr229,
    Isotope::Fr230,
    Isotope::Fr231,
    Isotope::Fr232,
    Isotope::Fr233,
    Isotope::Ra201,
    Isotope::Ra202,
    Isotope::Ra203,
    Isotope::Ra204,
    Isotope::Ra205,
    Isotope::Ra206,
    Isotope::Ra207,
    Isotope::Ra208,
    Isotope::Ra209,
    Isotope::Ra210,
    Isotope::Ra211,
    Isotope::Ra212,
    Isotope::Ra213,
    Isotope::Ra214,
    Isotope::Ra215,
    Isotope::Ra216,
    Isotope::Ra217,
    Isotope::Ra218,
    Isotope::Ra219,
    Isotope::Ra220,
    Isotope::Ra221,
    Isotope::Ra222,
    Isotope::Ra223,
    Isotope::Ra224,
    Isotope::Ra225,
    Isotope::Ra226,
    Isotope::Ra227,
    Isotope::Ra228,
    Isotope::Ra229,
    Isotope::Ra230,
    Isotope::Ra231,
    Isotope::Ra232,
    Isotope::Ra233,
    Isotope::Ra234,
    Isotope::Ra235,
    Isotope::Ac205,
    Isotope::Ac206,
    Isotope::Ac207,
    Isotope::Ac208,
    Isotope::Ac209,
    Isotope::Ac210,
    Isotope::Ac211,
    Isotope::Ac212,
    Isotope::Ac213,
    Isotope::Ac214,
    Isotope::Ac215,
    Isotope::Ac216,
    Isotope::Ac217,
    Isotope::Ac218,
    Isotope::Ac219,
    Isotope::Ac220,
    Isotope::Ac221,
    Isotope::Ac222,
    Isotope::Ac223,
    Isotope::Ac224,
    Isotope::Ac225,
    Isotope::Ac226,
    Isotope::Ac227,
    Isotope::Ac228,
    Isotope::Ac229,
    Isotope::Ac230,
    Isotope::Ac231,
    Isotope::Ac232,
    Isotope::Ac233,
    Isotope::Ac234,
    Isotope::Ac235,
    Isotope::Ac236,
    Isotope::Ac237,
    Isotope::Th208,
    Isotope::Th209,
    Isotope::Th210,
    Isotope::Th211,
    Isotope::Th212,
    Isotope::Th213,
    Isotope::Th214,
    Isotope::Th215,
    Isotope::Th216,
    Isotope::Th217,
    Isotope::Th218,
    Isotope::Th219,
    Isotope::Th220,
    Isotope::Th221,
    Isotope::Th222,
    Isotope::Th223,
    Isotope::Th224,
    Isotope::Th225,
    Isotope::Th226,
    Isotope::Th227,
    Isotope::Th228,
    Isotope::Th229,
    Isotope::Th230,
    Isotope::Th231,
    Isotope::Th232,
    Isotope::Th233,
    Isotope::Th234,
    Isotope::Th235,
    Isotope::Th236,
    Isotope::Th237,
    Isotope::Th238,
    Isotope::Th239,
    Isotope::Pa211,
    Isotope::Pa212,
    Isotope::Pa213,
    Isotope::Pa214,
    Isotope::Pa215,
    Isotope::Pa216,
    Isotope::Pa217,
    Isotope::Pa218,
    Isotope::Pa219,
    Isotope::Pa220,
    Isotope::Pa221,
    Isotope::Pa222,
    Isotope::Pa223,
    Isotope::Pa224,
    Isotope::Pa225,
    Isotope::Pa226,
    Isotope::Pa227,
    Isotope::Pa228,
    Isotope::Pa229,
    Isotope::Pa230,
    Isotope::Pa231,
    Isotope::Pa232,
    Isotope::Pa233,
    Isotope::Pa234,
    Isotope::Pa235,
    Isotope::Pa236,
    Isotope::Pa237,
    Isotope::Pa238,
    Isotope::Pa239,
    Isotope::Pa240,
    Isotope::Pa241,
    Isotope::U215,
    Isotope::U216,
    Isotope::U217,
    Isotope::U218,
    Isotope::U219,
    Isotope::U220,
    Isotope::U221,
    Isotope::U222,
    Isotope::U223,
    Isotope::U224,
    Isotope::U225,
    Isotope::U226,
    Isotope::U227,
    Isotope::U228,
    Isotope::U229,
    Isotope::U230,
    Isotope::U231,
    Isotope::U232,
    Isotope::U233,
    Isotope::U234,
    Isotope::U235,
    Isotope::U236,
    Isotope::U237,
    Isotope::U238,
    Isotope::U239,
    Isotope::U240,
    Isotope::U241,
    Isotope::U242,
    Isotope::U243,
    Isotope::Np219,
    Isotope::Np220,
    Isotope::Np221,
    Isotope::Np222,
    Isotope::Np223,
    Isotope::Np224,
    Isotope::Np225,
    Isotope::Np226,
    Isotope::Np227,
    Isotope::Np228,
    Isotope::Np229,
    Isotope::Np230,
    Isotope::Np231,
    Isotope::Np232,
    Isotope::Np233,
    Isotope::Np234,
    Isotope::Np235,
    Isotope::Np236,
    Isotope::Np237,
    Isotope::Np238,
    Isotope::Np239,
    Isotope::Np240,
    Isotope::Np241,
    Isotope::Np242,
    Isotope::Np243,
    Isotope::Np244,
    Isotope::Np245,
    Isotope::Pu221,
    Isotope::Pu222,
    Isotope::Pu223,
    Isotope::Pu224,
    Isotope::Pu225,
    Isotope::Pu226,
    Isotope::Pu227,
    Isotope::Pu228,
    Isotope::Pu229,
    Isotope::Pu230,
    Isotope::Pu231,
    Isotope::Pu232,
    Isotope::Pu233,
    Isotope::Pu234,
    Isotope::Pu235,
    Isotope::Pu236,
    Isotope::Pu237,
    Isotope::Pu238,
    Isotope::Pu239,
    Isotope::Pu240,
    Isotope::Pu241,
    Isotope::Pu242,
    Isotope::Pu243,
    Isotope::Pu244,
    Isotope::Pu245,
    Isotope::Pu246,
    Isotope::Pu247,
    Isotope::Am223,
    Isotope::Am224,
    Isotope::Am225,
    Isotope::Am226,
    Isotope::Am227,
    Isotope::Am228,
    Isotope::Am229,
    Isotope::Am230,
    Isotope::Am231,
    Isotope::Am232,
    Isotope::Am233,
    Isotope::Am234,
    Isotope::Am235,
    Isotope::Am236,
    Isotope::Am237,
    Isotope::Am238,
    Isotope::Am239,
    Isotope::Am240,
    Isotope::Am241,
    Isotope::Am242,
    Isotope::Am243,
    Isotope::Am244,
    Isotope::Am245,
    Isotope::Am246,
    Isotope::Am247,
    Isotope::Am248,
    Isotope::Am249,
    Isotope::Cm231,
    Isotope::Cm232,
    Isotope::Cm233,
    Isotope::Cm234,
    Isotope::Cm235,
    Isotope::Cm236,
    Isotope::Cm237,
    Isotope::Cm238,
    Isotope::Cm239,
    Isotope::Cm240,
    Isotope::Cm241,
    Isotope::Cm242,
    Isotope::Cm243,
    Isotope::Cm244,
    Isotope::Cm245,
    Isotope::Cm246,
    Isotope::Cm247,
    Isotope::Cm248,
    Isotope::Cm249,
    Isotope::Cm250,
    Isotope::Cm251,
    Isotope::Cm252,
    Isotope::Bk233,
    Isotope::Bk234,
    Isotope::Bk235,
    Isotope::Bk236,
    Isotope::Bk237,
    Isotope::Bk238,
    Isotope::Bk239,
    Isotope::Bk240,
    Isotope::Bk241,
    Isotope::Bk242,
    Isotope::Bk243,
    Isotope::Bk244,
    Isotope::Bk245,
    Isotope::Bk246,
    Isotope::Bk247,
    Isotope::Bk248,
    Isotope::Bk249,
    Isotope::Bk250,
    Isotope::Bk251,
    Isotope::Bk252,
    Isotope::Bk253,
    Isotope::Bk254,
    Isotope::Cf237,
    Isotope::Cf238,
    Isotope::Cf239,
    Isotope::Cf240,
    Isotope::Cf241,
    Isotope::Cf242,
    Isotope::Cf243,
    Isotope::Cf244,
    Isotope::Cf245,
    Isotope::Cf246,
    Isotope::Cf247,
    Isotope::Cf248,
    Isotope::Cf249,
    Isotope::Cf250,
    Isotope::Cf251,
    Isotope::Cf252,
    Isotope::Cf253,
    Isotope::Cf254,
    Isotope::Cf255,
    Isotope::Cf256,
    Isotope::Es239,
    Isotope::Es240,
    Isotope::Es241,
    Isotope::Es242,
    Isotope::Es243,
    Isotope::Es244,
    Isotope::Es245,
    Isotope::Es246,
    Isotope::Es247,
    Isotope::Es248,
    Isotope::Es249,
    Isotope::Es250,
    Isotope::Es251,
    Isotope::Es252,
    Isotope::Es253,
    Isotope::Es254,
    Isotope::Es255,
    Isotope::Es256,
    Isotope::Es257,
    Isotope::Es258,
    Isotope::Fm241,
    Isotope::Fm242,
    Isotope::Fm243,
    Isotope::Fm244,
    Isotope::Fm245,
    Isotope::Fm246,
    Isotope::Fm247,
    Isotope::Fm248,
    Isotope::Fm249,
    Isotope::Fm250,
    Isotope::Fm251,
    Isotope::Fm252,
    Isotope::Fm253,
    Isotope::Fm254,
    Isotope::Fm255,
    Isotope::Fm256,
    Isotope::Fm257,
    Isotope::Fm258,
    Isotope::Fm259,
    Isotope::Fm260,
    Isotope::Md244,
    Isotope::Md245,
    Isotope::Md246,
    Isotope::Md247,
    Isotope::Md248,
    Isotope::Md249,
    Isotope::Md250,
    Isotope::Md251,
    Isotope::Md252,
    Isotope::Md253,
    Isotope::Md254,
    Isotope::Md255,
    Isotope::Md256,
    Isotope::Md257,
    Isotope::Md258,
    Isotope::Md259,
    Isotope::Md260,
    Isotope::Md261,
    Isotope::Md262,
    Isotope::No248,
    Isotope::No249,
    Isotope::No250,
    Isotope::No251,
    Isotope::No252,
    Isotope::No253,
    Isotope::No254,
    Isotope::No255,
    Isotope::No256,
    Isotope::No257,
    Isotope::No258,
    Isotope::No259,
    Isotope::No260,
    Isotope::No261,
    Isotope::No262,
    Isotope::No263,
    Isotope::No264,
    Isotope::Lr251,
    Isotope::Lr252,
    Isotope::Lr253,
    Isotope::Lr254,
    Isotope::Lr255,
    Isotope::Lr256,
    Isotope::Lr257,
    Isotope::Lr258,
    Isotope::Lr259,
    Isotope::Lr260,
    Isotope::Lr261,
    Isotope::Lr262,
    Isotope::Lr263,
    Isotope::Lr264,
    Isotope::Lr265,
    Isotope::Lr266,
    Isotope::Rf253,
    Isotope::Rf254,
    Isotope::Rf255,
    Isotope::Rf256,
    Isotope::Rf257,
    Isotope::Rf258,
    Isotope::Rf259,
    Isotope::Rf260,
    Isotope::Rf261,
    Isotope::Rf262,
    Isotope::Rf263,
    Isotope::Rf264,
    Isotope::Rf265,
    Isotope::Rf266,
    Isotope::Rf267,
    Isotope::Rf268,
    Isotope::Db255,
    Isotope::Db256,
    Isotope::Db257,
    Isotope::Db258,
    Isotope::Db259,
    Isotope::Db260,
    Isotope::Db261,
    Isotope::Db262,
    Isotope::Db263,
    Isotope::Db264,
    Isotope::Db265,
    Isotope::Db266,
    Isotope::Db267,
    Isotope::Db268,
    Isotope::Db269,
    Isotope::Db270,
    Isotope::Sg258,
    Isotope::Sg259,
    Isotope::Sg260,
    Isotope::Sg261,
    Isotope::Sg262,
    Isotope::Sg263,
    Isotope::Sg264,
    Isotope::Sg265,
    Isotope::Sg266,
    Isotope::Sg267,
    Isotope::Sg268,
    Isotope::Sg269,
    Isotope::Sg270,
    Isotope::Sg271,
    Isotope::Sg272,
    Isotope::Sg273,
    Isotope::Bh260,
    Isotope::Bh261,
    Isotope::Bh262,
    Isotope::Bh263,
    Isotope::Bh264,
    Isotope::Bh265,
    Isotope::Bh266,
    Isotope::Bh267,
    Isotope::Bh268,
    Isotope::Bh269,
    Isotope::Bh270,
    Isotope::Bh271,
    Isotope::Bh272,
    Isotope::Bh273,
    Isotope::Bh274,
    Isotope::Bh275,
    Isotope::Bh276,
    Isotope::Bh277,
    Isotope::Bh278,
    Isotope::Hs263,
    Isotope::Hs264,
    Isotope::Hs265,
    Isotope::Hs266,
    Isotope::Hs267,
    Isotope::Hs268,
    Isotope::Hs269,
    Isotope::Hs270,
    Isotope::Hs271,
    Isotope::Hs272,
    Isotope::Hs273,
    Isotope::Hs274,
    Isotope::Hs275,
    Isotope::Hs276,
    Isotope::Hs277,
    Isotope::Hs278,
    Isotope::Hs279,
    Isotope::Hs280,
    Isotope::Mt265,
    Isotope::Mt266,
    Isotope::Mt267,
    Isotope::Mt268,
    Isotope::Mt269,
    Isotope::Mt270,
    Isotope::Mt271,
    Isotope::Mt272,
    Isotope::Mt273,
    Isotope::Mt274,
    Isotope::Mt275,
    Isotope::Mt276,
    Isotope::Mt277,
    Isotope::Mt278,
    Isotope::Mt279,
    Isotope::Mt280,
    Isotope::Mt281,
    Isotope::Mt282,
    Isotope::Ds267,
    Isotope::Ds268,
    Isotope::Ds269,
    Isotope::Ds270,
    Isotope::Ds271,
    Isotope::Ds272,
    Isotope::Ds273,
    Isotope::Ds274,
    Isotope::Ds275,
    Isotope::Ds276,
    Isotope::Ds277,
    Isotope::Ds278,
    Isotope::Ds279,
    Isotope::Ds280,
    Isotope::Ds281,
    Isotope::Ds282,
    Isotope::Ds283,
    Isotope::Ds284,
    Isotope::Rg272,
    Isotope::Rg273,
    Isotope::Rg274,
    Isotope::Rg275,
    Isotope::Rg276,
    Isotope::Rg277,
    Isotope::Rg278,
    Isotope::Rg279,
    Isotope::Rg280,
    Isotope::Rg281,
    Isotope::Rg282,
    Isotope::Rg283,
    Isotope::Rg284,
    Isotope::Rg285,
    Isotope::Rg286,
    Isotope::Cn276,
    Isotope::Cn277,
    Isotope::Cn278,
    Isotope::Cn279,
    Isotope::Cn280,
    Isotope::Cn281,
    Isotope::Cn282,
    Isotope::Cn283,
    Isotope::Cn284,
    Isotope::Cn285,
    Isotope::Cn286,
    Isotope::Cn287,
    Isotope::Cn288,
    Isotope::Nh278,
    Isotope::Nh279,
    Isotope::Nh280,
    Isotope::Nh281,
    Isotope::Nh282,
    Isotope::Nh283,
    Isotope::Nh284,
    Isotope::Nh285,
    Isotope::Nh286,
    Isotope::Nh287,
    Isotope::Nh288,
    Isotope::Nh289,
    Isotope::Nh290,
    Isotope::Fl284,
    Isotope::Fl285,
    Isotope::Fl286,
    Isotope::Fl287,
    Isotope::Fl288,
    Isotope::Fl289,
    Isotope::Fl290,
    Isotope::Fl291,
    Isotope::Mc287,
    Isotope::Mc288,
    Isotope::Mc289,
    Isotope::Mc290,
    Isotope::Mc291,
    Isotope::Mc292,
    Isotope::Lv289,
    Isotope::Lv290,
    Isotope::Lv291,
    Isotope::Lv292,
    Isotope::Lv293,
    Isotope::Ts291,
    Isotope::Ts292,
    Isotope::Ts293,
    Isotope::Ts294,
    Isotope::Og293,
    Isotope::Og294,
    Isotope::Og295,
];

impl Isotope {
    /// Returns a slice containing all isotopes, ordered by atomic number and then mass number
    ///
    /// ```
    /// use mendeleev::Isotope;
    /// use mendeleev::N_ISOTOPES;
    ///
    /// Isotope::list().iter().zip(Isotope::list().iter().skip(1)).all(|(prev, next)|
    /// ((prev.element().atomic_number(), prev.mass_number())
    /// < (next.element().atomic_number(), next.mass_number())));
    /// ```
    pub const fn list() -> &'static [Self] {
        &ALL_ISOTOPES
    }

    /// Returns an iterator that yields all the isotopes by value, ordered by atomic number and
    /// then mass number
    ///
    /// ```
    /// use mendeleev::Isotope;
    ///
    /// assert_eq!(Isotope::iter().next(), Some(Isotope::H1));
    /// ```
    pub fn iter() -> impl Iterator<Item = Self> + Clone {
        ALL_ISOTOPES.into_iter()
    }
}
