// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from LdapManager.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.auth {
  public class LdapManager_5_0_0 : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("auth.LdapManager:5.0.0", null);

    public LdapManager_5_0_0(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public LdapManager_5_0_0(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new LdapManager_5_0_0 StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new LdapManager_5_0_0(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public enum ServerType {
      ACTIVE_DIRECTORY,
      OPEN_LDAP,
    }

    public enum SecurityProtocol {
      SEC_PROTO_NONE,
      SEC_PROTO_SSL,
      SEC_PROTO_STARTTLS,
    }

    public class ServerSettings : ICloneable {
      public object Clone() {
        ServerSettings copy = new ServerSettings();
        copy.server = this.server;
        copy.type = this.type;
        copy.secProto = this.secProto;
        copy.port = this.port;
        copy.sslPort = this.sslPort;
        copy.forceTrustedCert = this.forceTrustedCert;
        copy.allowOffTimeRangeCerts = this.allowOffTimeRangeCerts;
        copy.certificate = this.certificate;
        copy.adsDomain = this.adsDomain;
        copy.useAnonymousBind = this.useAnonymousBind;
        copy.bindDN = this.bindDN;
        copy.bindPwd = this.bindPwd;
        copy.searchBaseDN = this.searchBaseDN;
        copy.loginNameAttr = this.loginNameAttr;
        copy.userEntryObjClass = this.userEntryObjClass;
        copy.userSearchFilter = this.userSearchFilter;
        copy.groupInfoInUserEntry = this.groupInfoInUserEntry;
        copy.supportNestedGroups = this.supportNestedGroups;
        copy.groupMemberAttr = this.groupMemberAttr;
        copy.groupEntryObjClass = this.groupEntryObjClass;
        copy.groupSearchFilter = this.groupSearchFilter;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["server"] = this.server;
        json["type"] = (int)this.type;
        json["secProto"] = (int)this.secProto;
        json["port"] = this.port;
        json["sslPort"] = this.sslPort;
        json["forceTrustedCert"] = this.forceTrustedCert;
        json["allowOffTimeRangeCerts"] = this.allowOffTimeRangeCerts;
        json["certificate"] = this.certificate;
        json["adsDomain"] = this.adsDomain;
        json["useAnonymousBind"] = this.useAnonymousBind;
        json["bindDN"] = this.bindDN;
        json["bindPwd"] = this.bindPwd;
        json["searchBaseDN"] = this.searchBaseDN;
        json["loginNameAttr"] = this.loginNameAttr;
        json["userEntryObjClass"] = this.userEntryObjClass;
        json["userSearchFilter"] = this.userSearchFilter;
        json["groupInfoInUserEntry"] = this.groupInfoInUserEntry;
        json["supportNestedGroups"] = this.supportNestedGroups;
        json["groupMemberAttr"] = this.groupMemberAttr;
        json["groupEntryObjClass"] = this.groupEntryObjClass;
        json["groupSearchFilter"] = this.groupSearchFilter;
        return json;
      }

      public static ServerSettings Decode(LightJson.JsonObject json, Agent agent) {
        ServerSettings inst = new ServerSettings();
        inst.server = (string)json["server"];
        inst.type = (Com.Raritan.Idl.auth.LdapManager_5_0_0.ServerType)(int)json["type"];
        inst.secProto = (Com.Raritan.Idl.auth.LdapManager_5_0_0.SecurityProtocol)(int)json["secProto"];
        inst.port = (int)json["port"];
        inst.sslPort = (int)json["sslPort"];
        inst.forceTrustedCert = (bool)json["forceTrustedCert"];
        inst.allowOffTimeRangeCerts = (bool)json["allowOffTimeRangeCerts"];
        inst.certificate = (string)json["certificate"];
        inst.adsDomain = (string)json["adsDomain"];
        inst.useAnonymousBind = (bool)json["useAnonymousBind"];
        inst.bindDN = (string)json["bindDN"];
        inst.bindPwd = (string)json["bindPwd"];
        inst.searchBaseDN = (string)json["searchBaseDN"];
        inst.loginNameAttr = (string)json["loginNameAttr"];
        inst.userEntryObjClass = (string)json["userEntryObjClass"];
        inst.userSearchFilter = (string)json["userSearchFilter"];
        inst.groupInfoInUserEntry = (bool)json["groupInfoInUserEntry"];
        inst.supportNestedGroups = (bool)json["supportNestedGroups"];
        inst.groupMemberAttr = (string)json["groupMemberAttr"];
        inst.groupEntryObjClass = (string)json["groupEntryObjClass"];
        inst.groupSearchFilter = (string)json["groupSearchFilter"];
        return inst;
      }

      public string server = "";
      public Com.Raritan.Idl.auth.LdapManager_5_0_0.ServerType type = Com.Raritan.Idl.auth.LdapManager_5_0_0.ServerType.ACTIVE_DIRECTORY;
      public Com.Raritan.Idl.auth.LdapManager_5_0_0.SecurityProtocol secProto = Com.Raritan.Idl.auth.LdapManager_5_0_0.SecurityProtocol.SEC_PROTO_NONE;
      public int port = 0;
      public int sslPort = 0;
      public bool forceTrustedCert = false;
      public bool allowOffTimeRangeCerts = false;
      public string certificate = "";
      public string adsDomain = "";
      public bool useAnonymousBind = false;
      public string bindDN = "";
      public string bindPwd = "";
      public string searchBaseDN = "";
      public string loginNameAttr = "";
      public string userEntryObjClass = "";
      public string userSearchFilter = "";
      public bool groupInfoInUserEntry = false;
      public bool supportNestedGroups = false;
      public string groupMemberAttr = "";
      public string groupEntryObjClass = "";
      public string groupSearchFilter = "";
    }

    public class GetLdapServersResult {
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.auth.LdapManager_5_0_0.ServerSettings> _ret_;
    }

    public GetLdapServersResult getLdapServers() {
      JsonObject _parameters = null;
      var _result = RpcCall("getLdapServers", _parameters);
      var _ret = new GetLdapServersResult();
      _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.auth.LdapManager_5_0_0.ServerSettings>(_result["_ret_"].AsJsonArray.Select(
        _value => Com.Raritan.Idl.auth.LdapManager_5_0_0.ServerSettings.Decode(_value, agent)));
      return _ret;
    }

    public AsyncRequest getLdapServers(AsyncRpcResponse<GetLdapServersResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getLdapServers(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getLdapServers(AsyncRpcResponse<GetLdapServersResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getLdapServers", _parameters,
        _result => {
          try {
            var _ret = new GetLdapServersResult();
            _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.auth.LdapManager_5_0_0.ServerSettings>(_result["_ret_"].AsJsonArray.Select(
              _value => Com.Raritan.Idl.auth.LdapManager_5_0_0.ServerSettings.Decode(_value, agent)));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public const int ERR_CYCLIC_DEP = 1;

    public const int ERR_INVALID_CFG = 2;

    public class SetLdapServersResult {
      public int _ret_;
    }

    public SetLdapServersResult setLdapServers(System.Collections.Generic.IEnumerable<Com.Raritan.Idl.auth.LdapManager_5_0_0.ServerSettings> serverList) {
      var _parameters = new LightJson.JsonObject();
      _parameters["serverList"] = new JsonArray(serverList.Select(
        _value => (JsonValue)(_value.Encode())));

      var _result = RpcCall("setLdapServers", _parameters);
      var _ret = new SetLdapServersResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setLdapServers(System.Collections.Generic.IEnumerable<Com.Raritan.Idl.auth.LdapManager_5_0_0.ServerSettings> serverList, AsyncRpcResponse<SetLdapServersResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setLdapServers(serverList, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setLdapServers(System.Collections.Generic.IEnumerable<Com.Raritan.Idl.auth.LdapManager_5_0_0.ServerSettings> serverList, AsyncRpcResponse<SetLdapServersResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["serverList"] = new JsonArray(serverList.Select(
          _value => (JsonValue)(_value.Encode())));
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setLdapServers", _parameters,
        _result => {
          try {
            var _ret = new SetLdapServersResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public const int ERR_SERVER_UNSPECIFIED = 1;

    public const int ERR_SERVER_UNREACHABLE = 3;

    public const int ERR_AUTHENTICATION_FAILED = 4;

    public const int ERR_NO_ROLES = 5;

    public const int ERR_NO_KNOWN_ROLES = 6;

    public class TestLdapServerResult {
      public int _ret_;
      public string diagMsg;
    }

    public TestLdapServerResult testLdapServer(string username, string password, Com.Raritan.Idl.auth.LdapManager_5_0_0.ServerSettings settings) {
      var _parameters = new LightJson.JsonObject();
      _parameters["username"] = username;
      _parameters["password"] = password;
      _parameters["settings"] = settings.Encode();

      var _result = RpcCall("testLdapServer", _parameters);
      var _ret = new TestLdapServerResult();
      _ret._ret_ = (int)_result["_ret_"];
      _ret.diagMsg = (string)_result["diagMsg"];
      return _ret;
    }

    public AsyncRequest testLdapServer(string username, string password, Com.Raritan.Idl.auth.LdapManager_5_0_0.ServerSettings settings, AsyncRpcResponse<TestLdapServerResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return testLdapServer(username, password, settings, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest testLdapServer(string username, string password, Com.Raritan.Idl.auth.LdapManager_5_0_0.ServerSettings settings, AsyncRpcResponse<TestLdapServerResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["username"] = username;
        _parameters["password"] = password;
        _parameters["settings"] = settings.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("testLdapServer", _parameters,
        _result => {
          try {
            var _ret = new TestLdapServerResult();
            _ret._ret_ = (int)_result["_ret_"];
            _ret.diagMsg = (string)_result["diagMsg"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
