---
title: View Menu
authors:
  - Peter Hoban
  - Thomas Schoeps
  - Kai Pastor
keywords: Menus
parent: Menus
grand_parent: Reference
nav_order: 0.3
last_modified_date: 11 June 2025
---

#### ![ ](../mapper-images/move.png) Pan
**(F6)**

Activates the [pan tool](toolbars.md#pan_map) which can be used to move the map. Note that key F6 starts panning immediately.


#### ![ ](../mapper-images/view-zoom-in.png) Zoom in
**F7**

Zoom in (enlarge) to view the map closer.


#### ![ ](../mapper-images/view-zoom-out.png) Zoom out
**F8**

Zoom out (shrink) the map to see more of it.


#### ![ ](../mapper-images/view-box-zoom.png) Zoom to box

Use this tool to zoom to a selectable rectangular area. Left-click and drag to define the box where to zoom to after releasing the mouse button.


#### ![ ](../mapper-images/view-show-all.png) Show whole map {#zoom-all}

Use this tool to display the whole map on your screen.


#### Set custom zoom factor...

Shows a dialog to enter a specific zoom factor. Note that the zoom factor on the screen is not necessarily equal to the printed scale of the map.


---

#### ![ ](../mapper-images/grid.png) Show grid
**G**

Shows or hides the [map grid](grid.md).


#### ![ ](../mapper-images/view-hatch-areas.png) Hatch areas
**F2**

When this toggle is activated, all area objects in the map will be drawn in a hatched, semi-transparent style. This is useful to be able to see any templates below the map.


#### ![ ](../mapper-images/view-baseline.png) Baseline view
**F3**

When this toggle is activated, instead of the normal appearance of map objects only their midpoints respectively baselines are displayed. This can be combined with Hatch areas to see anything below the map even better.


#### Overprinting simulation {#overprinting}
**F4**

When this toggle is activated, the effect of printing the map with layers of spot colors on top of each other will be simulated. This leads to improved map readability. This function requires a color set with spot color definitions.


#### Hide all templates
**F10**

When this toggle is activated, no [templates](templates.md) will be displayed. This is useful to check the appearance of the map alone.


---

#### Display coordinates as ... {#coorddisplay}

The coordinates of the cursor on the map are shown in the position box at the bottom right corner of the program window. Paper coordinates refer to positions on a paper print, from an arbitrary origin. If your map has been [georeferenced](georeferencing.md), additional coordinate systems will be available. Projected coordinates are meters of easting and northing. Latitude &amp; longitude may be expressed in decimal degrees or in degrees, minutes and seconds.

The coordinate system may also be selected by a right-click on the position box at the bottom right corner of your screen which will provide the same choices.


---

#### Toggle fullscreen mode {#fullscreen}
**F11**

This toggle switches the display to full screen mode and back.


---

#### ![ ](../mapper-images/window-new.png) Tag editor
**Ctrl+Shift+6**

This toggle shows or hides the [tag editor](object_tags.md#the-tag-editor).


#### ![ ](../mapper-images/colors.png) Color window
**Ctrl+Shift+7**

This toggle shows or hides the [color window](color_dock_widget.md).


#### ![ ](../mapper-images/symbols.png) Symbol window
**Ctrl+Shift+8**

This toggle shows or hides the [symbol pane](symbol_dock_widget.md).


#### ![ ](../mapper-images/templates.png) Template setup window
**Ctrl+Shift+9**

This toggle shows or hides the [template setup window](templates.md#setup).
