#!/usr/bin/perl
use 5.016;
use strict;
use warnings;

use POSIX qw(strftime);

sub rfc3339 {

    my ($time) = @_;
    $time //= time;

    return strftime('%Y-%m-%dT%H:%M:%SZ', gmtime $time);

}

my $TITLE = "Huge Test Feed";
my $SUBTITLE = "A test feed that is huge.";
my $SELF = "me";
my $LINK = "also-me";
my $ID = "mememememe";
my $UPDATED = rfc3339;
my $AUTHOR = "Samuel Young";
my @TAGS = qw(abc def ghi);

print <<"HERE";
<?xml version="1.0" encoding="utf-8"?>
<feed xmlns="http://www.w3.org/2005/Atom">
    <title>$TITLE</title>
    <subtitle>$SUBTITLE</subtitle>
    <link href="$SELF" rel="self"/>
    <link href="$LINK"/>
    <id>$ID</id>
    <updated>$UPDATED</updated>
HERE

for my $i (0 .. 20_000) {

    my $time = int rand time;

    print <<"HERE";
    <entry>
        <title>$i:$time</title>
        <link href="$SELF"/>
        <id>$i:$time</id>
        <updated>@{[rfc3339($time)]}</updated>
        <summary>$time</summary>
        <author><name>$AUTHOR</name></author>
        @{[map { "<category term=\"$_\"/>" } @TAGS]}
    </entry>
HERE

}

print <<"HERE";
</feed>
HERE

1;
