// license:BSD-3-Clause
// copyright-holders:Steve Ellenoff,R. Belmont,Ryan Holtz
/*****************************************************************************
 *
 *   cecalls.hxx
 *
 *   Addresses of certain Windows CE kernel calls, for use in debugging
 *   the bring-up of ARM-based Windows CE systems, e.g. Jornada 7xx.
 *
 *****************************************************************************/

void arm7_cpu_device::init_ce_kernel_addrs()
{
	memset(m_ce_kernel_addr_present, 0, 0x10400);

	add_ce_kernel_addr(0xf0010000, "SH_AFS_Unmount");
	add_ce_kernel_addr(0xf0010000, "SH_AFS_CloseHandle");
	add_ce_kernel_addr(0xf0010008, "SH_AFS_CreateDirectoryW");
	add_ce_kernel_addr(0xf001000c, "SH_AFS_RemoveDirectoryW");
	add_ce_kernel_addr(0xf0010010, "SH_AFS_GetFileAttributesW");
	add_ce_kernel_addr(0xf0010014, "SH_AFS_SetFileAttributesW");
	add_ce_kernel_addr(0xf0010018, "SH_AFS_CreateFileW");
	add_ce_kernel_addr(0xf001001c, "SH_AFS_DeleteFileW");
	add_ce_kernel_addr(0xf0010020, "SH_AFS_MoveFileW");
	add_ce_kernel_addr(0xf0010024, "SH_AFS_FindFirstFileW");
	add_ce_kernel_addr(0xf0010030, "SH_AFS_PrestoChangoFileName");
	add_ce_kernel_addr(0xf0010034, "SH_AFS_CloseAllFileHandles");
	add_ce_kernel_addr(0xf0010038, "SH_AFS_GetDiskFreeSpace");
	add_ce_kernel_addr(0xf001003c, "SH_AFS_NotifyMountedFS");
	add_ce_kernel_addr(0xf0010040, "SH_AFS_RegisterFileSystemFunction");
	add_ce_kernel_addr(0xf0010044, "SH_AFS_FindFirstChangeNotificationW");
	add_ce_kernel_addr(0xf000fffc, "SH_WIN32_NotSupported");
	add_ce_kernel_addr(0xf000fff8, "SH_WIN32_CreateAPISet");
	add_ce_kernel_addr(0xf000fff4, "SH_WIN32_VirtualAlloc");
	add_ce_kernel_addr(0xf000fff0, "SH_WIN32_VirtualFree");
	add_ce_kernel_addr(0xf000ffec, "SH_WIN32_VirtualProtect");
	add_ce_kernel_addr(0xf000ffe8, "SH_WIN32_VirtualQuery");
	add_ce_kernel_addr(0xf000ffe4, "SH_WIN32_VirtualCopy");
	add_ce_kernel_addr(0xf000ffe0, "SH_WIN32_LoadLibraryW");
	add_ce_kernel_addr(0xf000ffdc, "SH_WIN32_FreeLibrary");
	add_ce_kernel_addr(0xf000ffd8, "SH_WIN32_GetProcAddressW");
	add_ce_kernel_addr(0xf000ffd4, "SH_WIN32_ThreadAttachOrDetach");
	add_ce_kernel_addr(0xf000ffd0, "SH_WIN32_ThreadDetachAllDLLs");
	add_ce_kernel_addr(0xf000ffcc, "SH_WIN32_GetTickCount");
	add_ce_kernel_addr(0xf000ffc8, "SH_WIN32_OutputDebugStringW");
	add_ce_kernel_addr(0xf000ffc4, "SH_WIN32_TlsCall");
	add_ce_kernel_addr(0xf000ffc0, "SH_WIN32_GetSystemInfo");
	add_ce_kernel_addr(0xf000ffbc, "SH_WIN32_U_ropen");
	add_ce_kernel_addr(0xf000ffb8, "SH_WIN32_U_rread");
	add_ce_kernel_addr(0xf000ffb4, "SH_WIN32_U_rwrite");
	add_ce_kernel_addr(0xf000ffb0, "SH_WIN32_U_rlseek");
	add_ce_kernel_addr(0xf000ffac, "SH_WIN32_U_rclose");
	add_ce_kernel_addr(0xf000ffa8, "SH_WIN32_RegisterDbgZones");
	add_ce_kernel_addr(0xf000ffa4, "SH_WIN32_NKvDbgPrintfW");
	add_ce_kernel_addr(0xf000ffa0, "SH_WIN32_ProfileSyscall");
	add_ce_kernel_addr(0xf000ff9c, "SH_WIN32_FindResourceW");
	add_ce_kernel_addr(0xf000ff98, "SH_WIN32_LoadResource");
	add_ce_kernel_addr(0xf000ff94, "SH_WIN32_SizeofResource");
	add_ce_kernel_addr(0xf000ff90, "SH_WIN32_GetRealTime");
	add_ce_kernel_addr(0xf000ff8c, "SH_WIN32_SetRealTime");
	add_ce_kernel_addr(0xf000ff88, "SH_WIN32_ProcessDetachAllDLLs");
	add_ce_kernel_addr(0xf000ff84, "SH_WIN32_ExtractResource");
	add_ce_kernel_addr(0xf000ff80, "SH_WIN32_GetRomFileInfo");
	add_ce_kernel_addr(0xf000ff7c, "SH_WIN32_GetRomFileBytes");
	add_ce_kernel_addr(0xf000ff78, "SH_WIN32_CacheRangeFlush");
	add_ce_kernel_addr(0xf000ff74, "SH_WIN32_AddTrackedItem");
	add_ce_kernel_addr(0xf000ff70, "SH_WIN32_DeleteTrackedItem");
	add_ce_kernel_addr(0xf000ff6c, "SH_WIN32_PrintTrackedItem");
	add_ce_kernel_addr(0xf000ff68, "SH_WIN32_GetKPhys");
	add_ce_kernel_addr(0xf000ff64, "SH_WIN32_GiveKPhys");
	add_ce_kernel_addr(0xf000ff60, "SH_WIN32_SetExceptionHandler");
	add_ce_kernel_addr(0xf000ff5c, "SH_WIN32_RegisterTrackedItem");
	add_ce_kernel_addr(0xf000ff58, "SH_WIN32_FilterTrackedItem");
	add_ce_kernel_addr(0xf000ff54, "SH_WIN32_SetKernelAlarm");
	add_ce_kernel_addr(0xf000ff50, "SH_WIN32_RefreshKernelAlarm");
	add_ce_kernel_addr(0xf000ff4c, "SH_WIN32_CeGetRandomSeed");
	add_ce_kernel_addr(0xf000ff48, "SH_WIN32_CloseProcOE");
	add_ce_kernel_addr(0xf000ff44, "SH_WIN32_SetGwesOOMEvent");
	add_ce_kernel_addr(0xf000ff40, "SH_WIN32_StringCompress");
	add_ce_kernel_addr(0xf000ff3c, "SH_WIN32_StringDecompress");
	add_ce_kernel_addr(0xf000ff38, "SH_WIN32_BinaryCompress");
	add_ce_kernel_addr(0xf000ff34, "SH_WIN32_BinaryDecompress");
	add_ce_kernel_addr(0xf000ff30, "SH_WIN32_CreateEventW");
	add_ce_kernel_addr(0xf000ff2c, "SH_WIN32_CreateProcessW");
	add_ce_kernel_addr(0xf000ff28, "SH_WIN32_CreateThread");
	add_ce_kernel_addr(0xf000ff24, "SH_WIN32_InputDebugCharW");
	add_ce_kernel_addr(0xf000ff20, "SH_WIN32_TakeCritSec");
	add_ce_kernel_addr(0xf000ff1c, "SH_WIN32_LeaveCritSec");
	add_ce_kernel_addr(0xf000ff18, "SH_WIN32_WaitForMultipleObjects");
	add_ce_kernel_addr(0xf000ff14, "SH_WIN32_MapPtrToProcess");
	add_ce_kernel_addr(0xf000ff10, "SH_WIN32_MapPtrUnsecure");
	add_ce_kernel_addr(0xf000ff0c, "SH_WIN32_GetProcFromPtr");
	add_ce_kernel_addr(0xf000ff08, "SH_WIN32_IsBadPtr");
	add_ce_kernel_addr(0xf000ff04, "SH_WIN32_GetProcAddrBits");
	add_ce_kernel_addr(0xf000ff00, "SH_WIN32_GetFSHeapInfo");
	add_ce_kernel_addr(0xf000fefc, "SH_WIN32_OtherThreadsRunning");
	add_ce_kernel_addr(0xf000fef8, "SH_WIN32_KillAllOtherThreads");
	add_ce_kernel_addr(0xf000fef4, "SH_WIN32_GetOwnerProcess");
	add_ce_kernel_addr(0xf000fef0, "SH_WIN32_GetCallerProcess");
	add_ce_kernel_addr(0xf000feec, "SH_WIN32_GetIdleTime");
	add_ce_kernel_addr(0xf000fee8, "SH_WIN32_SetLowestScheduledPriority");
	add_ce_kernel_addr(0xf000fee4, "SH_WIN32_IsPrimaryThread");
	add_ce_kernel_addr(0xf000fee0, "SH_WIN32_SetProcPermissions");
	add_ce_kernel_addr(0xf000fedc, "SH_WIN32_GetCurrentPermissions");
	add_ce_kernel_addr(0xf000fed4, "SH_WIN32_SetDaylightTime");
	add_ce_kernel_addr(0xf000fed0, "SH_WIN32_SetTimeZoneBias");
	add_ce_kernel_addr(0xf000fecc, "SH_WIN32_SetCleanRebootFlag");
	add_ce_kernel_addr(0xf000fec8, "SH_WIN32_CreateCrit");
	add_ce_kernel_addr(0xf000fec4, "SH_WIN32_PowerOffSystem");
	add_ce_kernel_addr(0xf000fec0, "SH_WIN32_CreateMutexW");
	add_ce_kernel_addr(0xf000febc, "SH_WIN32_SetDbgZone");
	add_ce_kernel_addr(0xf000feb8, "SH_WIN32_Sleep");
	add_ce_kernel_addr(0xf000feb4, "SH_WIN32_TurnOnProfiling");
	add_ce_kernel_addr(0xf000feb0, "SH_WIN32_TurnOffProfiling");
	add_ce_kernel_addr(0xf000feac, "SH_WIN32_CeGetCurrentTrust");
	add_ce_kernel_addr(0xf000fea8, "SH_WIN32_CeGetCallerTrust");
	add_ce_kernel_addr(0xf000fea4, "SH_WIN32_NKTerminateThread");
	add_ce_kernel_addr(0xf000fea0, "SH_WIN32_SetLastError");
	add_ce_kernel_addr(0xf000fe9c, "SH_WIN32_GetLastError");
	add_ce_kernel_addr(0xf000fe98, "SH_WIN32_GetProcName");
	add_ce_kernel_addr(0xf000fe94, "SH_WIN32_ExitProcess");
	add_ce_kernel_addr(0xf000fe90, "SH_WIN32_CloseAllHandles");
	add_ce_kernel_addr(0xf000fe8c, "SH_WIN32_SetHandleOwner");
	add_ce_kernel_addr(0xf000fe88, "SH_WIN32_LoadDriver");
	add_ce_kernel_addr(0xf000fe84, "SH_WIN32_CreateFileMappingW");
	add_ce_kernel_addr(0xf000fe80, "SH_WIN32_UnmapViewOfFile");
	add_ce_kernel_addr(0xf000fe7c, "SH_WIN32_FlushViewOfFile");
	add_ce_kernel_addr(0xf000fe78, "SH_WIN32_CreateFileForMappingW");
	add_ce_kernel_addr(0xf000fe74, "SH_WIN32_KernelIoControl");
	add_ce_kernel_addr(0xf000fe70, "SH_WIN32_GetCallStackSnapshot");
	add_ce_kernel_addr(0xf000fe6c, "SH_WIN32_PPSHRestart");
	add_ce_kernel_addr(0xf000fe64, "SH_WIN32_UpdateNLSInfoEx");
	add_ce_kernel_addr(0xf000fe60, "SH_WIN32_ConnectDebugger");
	add_ce_kernel_addr(0xf000fe5c, "SH_WIN32_InterruptInitialize");
	add_ce_kernel_addr(0xf000fe58, "SH_WIN32_InterruptDone");
	add_ce_kernel_addr(0xf000fe54, "SH_WIN32_InterruptDisable");
	add_ce_kernel_addr(0xf000fe50, "SH_WIN32_SetKMode");
	add_ce_kernel_addr(0xf000fe4c, "SH_WIN32_SetPowerOffHandler");
	add_ce_kernel_addr(0xf000fe48, "SH_WIN32_SetGwesPowerHandler");
	add_ce_kernel_addr(0xf000fe44, "SH_WIN32_SetHardwareWatch");
	add_ce_kernel_addr(0xf000fe40, "SH_WIN32_QueryAPISetID");
	add_ce_kernel_addr(0xf000fe3c, "SH_WIN32_PerformCallBack");
	add_ce_kernel_addr(0xf000fe38, "SH_WIN32_RaiseException");
	add_ce_kernel_addr(0xf000fe34, "SH_WIN32_GetCallerProcessIndex");
	add_ce_kernel_addr(0xf000fe30, "SH_WIN32_WaitForDebugEvent");
	add_ce_kernel_addr(0xf000fe2c, "SH_WIN32_ContinueDebugEvent");
	add_ce_kernel_addr(0xf000fe28, "SH_WIN32_DebugNotify");
	add_ce_kernel_addr(0xf000fe24, "SH_WIN32_OpenProcess");
	add_ce_kernel_addr(0xf000fe20, "SH_WIN32_THCreateSnapshot");
	add_ce_kernel_addr(0xf000fe1c, "SH_WIN32_THGrow");
	add_ce_kernel_addr(0xf000fe18, "SH_WIN32_NotifyForceCleanboot");
	add_ce_kernel_addr(0xf000fe14, "SH_WIN32_DumpKCallProfile");
	add_ce_kernel_addr(0xf000fe10, "SH_WIN32_GetProcessVersion");
	add_ce_kernel_addr(0xf000fe0c, "SH_WIN32_GetModuleFileNameW");
	add_ce_kernel_addr(0xf000fe08, "SH_WIN32_QueryPerformanceCounter");
	add_ce_kernel_addr(0xf000fe04, "SH_WIN32_QueryPerformanceFrequency");
	add_ce_kernel_addr(0xf000fe00, "SH_WIN32_KernExtractIcons");
	add_ce_kernel_addr(0xf000fdfc, "SH_WIN32_ForcePageout");
	add_ce_kernel_addr(0xf000fdf8, "SH_WIN32_GetThreadTimes");
	add_ce_kernel_addr(0xf000fdf4, "SH_WIN32_GetModuleHandleW");
	add_ce_kernel_addr(0xf000fdf0, "SH_WIN32_SetWDevicePowerHandler");
	add_ce_kernel_addr(0xf000fdec, "SH_WIN32_SetStdioPathW");
	add_ce_kernel_addr(0xf000fde8, "SH_WIN32_GetStdioPathW");
	add_ce_kernel_addr(0xf000fde4, "SH_WIN32_ReadRegistryFromOEM");
	add_ce_kernel_addr(0xf000fde0, "SH_WIN32_WriteRegistryToOEM");
	add_ce_kernel_addr(0xf000fddc, "SH_WIN32_WriteDebugLED");
	add_ce_kernel_addr(0xf000fdd8, "SH_WIN32_LockPages");
	add_ce_kernel_addr(0xf000fdd4, "SH_WIN32_UnlockPages");
	add_ce_kernel_addr(0xf000fdd0, "SH_WIN32_VirtualSetAttributes");
	add_ce_kernel_addr(0xf000fdcc, "SH_WIN32_SetRAMMode");
	add_ce_kernel_addr(0xf000fdc8, "SH_WIN32_SetStoreQueueBase");
	add_ce_kernel_addr(0xf000fdc4, "SH_WIN32_FlushViewOfFileMaybe");
	add_ce_kernel_addr(0xf000fdc0, "SH_WIN32_GetProcAddressA");
	add_ce_kernel_addr(0xf000fdbc, "SH_WIN32_GetCommandLineW");
	add_ce_kernel_addr(0xf000fdb8, "SH_WIN32_DisableThreadLibraryCalls");
	add_ce_kernel_addr(0xf000fdb4, "SH_WIN32_CreateSemaphoreW");
	add_ce_kernel_addr(0xf000fdb0, "SH_WIN32_LoadLibraryExW");
	add_ce_kernel_addr(0xf000fdac, "SH_WIN32_PerformCallForward");
	add_ce_kernel_addr(0xf000fda8, "SH_WIN32_CeMapArgumentArray");
	add_ce_kernel_addr(0xf000fda4, "SH_WIN32_KillThreadIfNeeded");
	add_ce_kernel_addr(0xf000fda0, "SH_WIN32_GetProcessIndexFromID");
	add_ce_kernel_addr(0xf000fd9c, "SH_WIN32_RegisterGwesHandler");
	add_ce_kernel_addr(0xf000fd98, "SH_WIN32_GetProfileBaseAddress");
	add_ce_kernel_addr(0xf000fd94, "SH_WIN32_SetProfilePortAddress");
	add_ce_kernel_addr(0xf000fd90, "SH_WIN32_CeLogData");
	add_ce_kernel_addr(0xf000fd8c, "SH_WIN32_CeLogSetZones");
	add_ce_kernel_addr(0xf000fd88, "SH_WIN32_CeModuleJit");
	add_ce_kernel_addr(0xf000fd84, "SH_WIN32_CeSetExtendedPdata");
	add_ce_kernel_addr(0xf000fd80, "SH_WIN32_VerQueryValueW");
	add_ce_kernel_addr(0xf000fd7c, "SH_WIN32_GetFileVersionInfoSizeW");
	add_ce_kernel_addr(0xf000fd78, "SH_WIN32_GetFileVersionInfoW");
	add_ce_kernel_addr(0xf000fd74, "SH_WIN32_CreateLocaleView");
	add_ce_kernel_addr(0xf000fd70, "SH_WIN32_CeLogReSync");
	add_ce_kernel_addr(0xf000fd6c, "SH_WIN32_LoadIntChainHandler");
	add_ce_kernel_addr(0xf000fd68, "SH_WIN32_FreeIntChainHandler");
	add_ce_kernel_addr(0xf000fd64, "SH_WIN32_LoadKernelLibrary");
	add_ce_kernel_addr(0xf000fd60, "SH_WIN32_AllocPhysMem");
	add_ce_kernel_addr(0xf000fd5c, "SH_WIN32_FreePhysMem");
	add_ce_kernel_addr(0xf000fd58, "SH_WIN32_KernelLibIoControl");
	add_ce_kernel_addr(0xf000fd54, "SH_WIN32_OpenEventW");
	add_ce_kernel_addr(0xf000fd50, "SH_WIN32_SleepTillTick");
	add_ce_kernel_addr(0xf000fd4c, "SH_WIN32_DuplicateHandle");
	add_ce_kernel_addr(0xf000fd48, "SH_WIN32_CreateStaticMapping");
	add_ce_kernel_addr(0xf000fd44, "SH_WIN32_MapCallerPtr");
	add_ce_kernel_addr(0xf000fd40, "SH_WIN32_MapPtrToProcWithSize");
	add_ce_kernel_addr(0xf000fd3c, "SH_WIN32_LoadStringW");
	add_ce_kernel_addr(0xf000fd38, "SH_WIN32_QueryInstructionSet");
	add_ce_kernel_addr(0xf000fd34, "SH_WIN32_CeLogGetZones");
	add_ce_kernel_addr(0xf000fd30, "SH_WIN32_GetProcessIDFromIndex");
	add_ce_kernel_addr(0xf000fd2c, "SH_WIN32_IsProcessorFeaturePresent");
	add_ce_kernel_addr(0xf000fd28, "SH_WIN32_DecompressBinaryBlock");
	add_ce_kernel_addr(0xf000fd24, "SH_WIN32_PageOutModule");
	add_ce_kernel_addr(0xf000fd20, "SH_WIN32_InterruptMask");
	add_ce_kernel_addr(0xf000fd1c, "SH_WIN32_GetProcModList");
	add_ce_kernel_addr(0xf000fd18, "SH_WIN32_FreeModFromCurrProc");
	add_ce_kernel_addr(0xf000fd14, "SH_WIN32_CeVirtualSharedAlloc");
	add_ce_kernel_addr(0xf000fd10, "SH_WIN32_NKDeleteStaticMapping");
	add_ce_kernel_addr(0xf000fd0c, "SH_WIN32_CreateToken");
	add_ce_kernel_addr(0xf000fd08, "SH_WIN32_RevertToSelf");
	add_ce_kernel_addr(0xf000fd04, "SH_WIN32_CeImpersonateCurrProc");
	add_ce_kernel_addr(0xf000fd00, "SH_WIN32_CeDuplicateToken");
	add_ce_kernel_addr(0xf000fcfc, "SH_WIN32_ConnectHdstub");
	add_ce_kernel_addr(0xf000fcf8, "SH_WIN32_ConnectOsAxsT0");
	add_ce_kernel_addr(0xf000fcf4, "SH_WIN32_IsNamedEventSignaled");
	add_ce_kernel_addr(0xf000fcf0, "SH_WIN32_ConnectOsAxsT1");
	add_ce_kernel_addr(0xf000fcec, "SH_WIN32_DebugSetProcessKillOnExit");
	add_ce_kernel_addr(0xf000fce8, "SH_WIN32_CeGetProcessTrust");
	add_ce_kernel_addr(0xf000fce4, "SH_WIN32_CeOpenFileHandle");

	add_ce_kernel_addr(0xf000fbfc, "SH_CURTHREAD_ThreadCloseHandle");
	add_ce_kernel_addr(0xf000fbf8, "SH_CURTHREAD_SuspendThread");
	add_ce_kernel_addr(0xf000fbf4, "SH_CURTHREAD_ResumeThread");
	add_ce_kernel_addr(0xf000fbf0, "SH_CURTHREAD_SetThreadPriority");
	add_ce_kernel_addr(0xf000fbec, "SH_CURTHREAD_GetThreadPriority");
	add_ce_kernel_addr(0xf000fbe8, "SH_CURTHREAD_GetExitCodeThread");
	add_ce_kernel_addr(0xf000fbe4, "SH_CURTHREAD_GetThreadContext");
	add_ce_kernel_addr(0xf000fbe0, "SH_CURTHREAD_SetThreadContext");
	add_ce_kernel_addr(0xf000fbdc, "SH_CURTHREAD_TerminateThread");
	add_ce_kernel_addr(0xf000fbd8, "SH_CURTHREAD_CeGetThreadPriority");
	add_ce_kernel_addr(0xf000fbd4, "SH_CURTHREAD_CeSetThreadPriority");
	add_ce_kernel_addr(0xf000fbd0, "SH_CURTHREAD_CeGetThreadQuantum");
	add_ce_kernel_addr(0xf000fbcc, "SH_CURTHREAD_CeSetThreadQuantum");
	add_ce_kernel_addr(0xf000f800, "SH_CURPROC_ProcCloseHandle");
	add_ce_kernel_addr(0xf000f7f8, "SH_CURPROC_TerminateProcess");
	add_ce_kernel_addr(0xf000f7f4, "SH_CURPROC_GetExitCodeProcess");
	add_ce_kernel_addr(0xf000f7ec, "SH_CURPROC_FlushInstructionCache");
	add_ce_kernel_addr(0xf000f7e8, "SH_CURPROC_ReadProcessMemory");
	add_ce_kernel_addr(0xf000f7e4, "SH_CURPROC_WriteProcessMemory");
	add_ce_kernel_addr(0xf000f7e0, "SH_CURPROC_DebugActiveProcess");
	add_ce_kernel_addr(0xf000f7dc, "SH_CURPROC_GetModuleInformation");
	add_ce_kernel_addr(0xf000f7d8, "SH_CURPROC_CeSetProcessVersion");
	add_ce_kernel_addr(0xf000f7d4, "SH_CURPROC_DebugActiveProcessStop");
	add_ce_kernel_addr(0xf000f7d0, "SH_CURPROC_CeGetModuleInfo");
	add_ce_kernel_addr(0xf000f7cc, "SH_CURPROC_CheckRemoteDebuggerPresent");
	add_ce_kernel_addr(0xf000f000, "HT_EVENT_EventCloseHandle");
	add_ce_kernel_addr(0xf000eff8, "HT_EVENT_EventModify");
	add_ce_kernel_addr(0xf000eff4, "HT_EVENT_AddEventAccess");
	add_ce_kernel_addr(0xf000eff0, "HT_EVENT_EventGetData");
	add_ce_kernel_addr(0xf000efec, "HT_EVENT_EventSetData");
	add_ce_kernel_addr(0xf000ec00, "HT_MUTEX_MutexCloseHandle");
	add_ce_kernel_addr(0xf000ebf8, "HT_MUTEX_ReleaseMutex");
	add_ce_kernel_addr(0xf000e800, "HT_APISET_CloseAPISet");
	add_ce_kernel_addr(0xf000e7f8, "HT_APISET_RegisterAPISet");
	add_ce_kernel_addr(0xf000e7f4, "HT_APISET_CreateAPIHandle");
	add_ce_kernel_addr(0xf000e7f0, "HT_APISET_VerifyAPIHandle");
	add_ce_kernel_addr(0xf000e3fc, "HT_FILE_PSLGetStoreInfo");
	add_ce_kernel_addr(0xf000e3f8, "HT_FILE_PSLDismountStore");
	add_ce_kernel_addr(0xf000e3f8, "HT_FILE_ReadFile");
	add_ce_kernel_addr(0xf000e3f4, "HT_FILE_PSLFormatStore");
	add_ce_kernel_addr(0xf000e3f4, "HT_FILE_WriteFile");
	add_ce_kernel_addr(0xf000e3f0, "HT_FILE_GetFileSize");
	add_ce_kernel_addr(0xf000e3f0, "HT_FILE_PSLCreatePart");
	add_ce_kernel_addr(0xf000e3ec, "HT_FILE_PSLDeletePartition");
	add_ce_kernel_addr(0xf000e3ec, "HT_FILE_SetFilePointer");
	add_ce_kernel_addr(0xf000e3e8, "HT_FILE_GetFileInformationByHandle");
	add_ce_kernel_addr(0xf000e3e8, "HT_FILE_PSLOpenPartition");
	add_ce_kernel_addr(0xf000e3e4, "HT_FILE_FlushFileBuffers");
	add_ce_kernel_addr(0xf000e3e4, "HT_FILE_PSLMountPartition");
	add_ce_kernel_addr(0xf000e3e0, "HT_FILE_GetFileTime");
	add_ce_kernel_addr(0xf000e3e0, "HT_FILE_PSLDismountPartition");
	add_ce_kernel_addr(0xf000e3dc, "HT_FILE_PSLRenamePartition");
	add_ce_kernel_addr(0xf000e3dc, "HT_FILE_SetFileTime");
	add_ce_kernel_addr(0xf000e3d8, "HT_FILE_PSLSetPartitionAttributes");
	add_ce_kernel_addr(0xf000e3d8, "HT_FILE_SetEndOfFile");
	add_ce_kernel_addr(0xf000e3d4, "HT_FILE_DeviceIoControl");
	add_ce_kernel_addr(0xf000e3d0, "HT_FILE_PSLGetPartitionInfo");
	add_ce_kernel_addr(0xf000e3d0, "HT_FILE_ReadFileWithSeek");
	add_ce_kernel_addr(0xf000e3cc, "HT_FILE_PSLFormatPart");
	add_ce_kernel_addr(0xf000e3cc, "HT_FILE_WriteFileWithSeek");
	add_ce_kernel_addr(0xf000e3c8, "HT_FILE_PSLFindFirstPartition");
	add_ce_kernel_addr(0xf000e000, "HT_FIND_FindClose");
	//add_ce_kernel_addr(0xf000e000, "HT_FIND_PSLFindClosePartition");
	//add_ce_kernel_addr(0xf000e000, "HT_FIND_PSLFindCloseStore");
	add_ce_kernel_addr(0xf000dff8, "HT_FIND_FindNextFileW");
	//add_ce_kernel_addr(0xf000dff8, "HT_FIND_PSLFindNextPartition");
	//add_ce_kernel_addr(0xf000dff8, "HT_FIND_PSLFindNextStore");
	add_ce_kernel_addr(0xf000dbf8, "HT_DBFILE_CeSeekDatabaseEx");
	add_ce_kernel_addr(0xf000dbf4, "HT_DBFILE_CeDeleteRecord");
	add_ce_kernel_addr(0xf000dbf0, "HT_DBFILE_CeReadRecordPropsEx");
	add_ce_kernel_addr(0xf000dbec, "HT_DBFILE_CeWriteRecordProps");
	add_ce_kernel_addr(0xf000dbe8, "HT_DBFILE_CeGetDBInformationByHandle");
	add_ce_kernel_addr(0xf000d7f8, "HT_DBFIND_CeFindNextDatabaseEx");
	add_ce_kernel_addr(0xf000d400, "HT_SOCKET_AFDCloseSocket");
	add_ce_kernel_addr(0xf000d3f8, "HT_SOCKET_AFDAccept");
	add_ce_kernel_addr(0xf000d3f4, "HT_SOCKET_AFDBind");
	add_ce_kernel_addr(0xf000d3f0, "HT_SOCKET_AFDConnect");
	add_ce_kernel_addr(0xf000d3ec, "HT_SOCKET_AFDIoctl");
	add_ce_kernel_addr(0xf000d3e8, "HT_SOCKET_AFDListen");
	add_ce_kernel_addr(0xf000d3e4, "HT_SOCKET_AFDRecv");
	add_ce_kernel_addr(0xf000d3e0, "HT_SOCKET_AFDSend");
	add_ce_kernel_addr(0xf000d3dc, "HT_SOCKET_AFDShutdown");
	add_ce_kernel_addr(0xf000d3d8, "HT_SOCKET_AFDGetsockname");
	add_ce_kernel_addr(0xf000d3d4, "HT_SOCKET_AFDGetpeername");
	add_ce_kernel_addr(0xf000d3d0, "HT_SOCKET_AFDGetSockOpt");
	add_ce_kernel_addr(0xf000d3cc, "HT_SOCKET_AFDSetSockOpt");
	add_ce_kernel_addr(0xf000d3c8, "HT_SOCKET_AFDWakeup");
	add_ce_kernel_addr(0xf000d3c4, "HT_SOCKET_AFDGetOverlappedResult");
	add_ce_kernel_addr(0xf000d3c0, "HT_SOCKET_AFDEventSelect");
	add_ce_kernel_addr(0xf000d3bc, "HT_SOCKET_AFDEnumNetworkEvents");
	add_ce_kernel_addr(0xf000cc00, "HT_SEMAPHORE_SemaphoreCloseHandle");
	add_ce_kernel_addr(0xf000cbf8, "HT_SEMAPHORE_ReleaseSemaphore");
	add_ce_kernel_addr(0xf000c800, "HT_FSMAP_MapCloseHandle");
	add_ce_kernel_addr(0xf000c7f8, "HT_FSMAP_MapViewOfFile");
	add_ce_kernel_addr(0xf000c400, "HT_WNETENUM_WNetCloseEnum");
	add_ce_kernel_addr(0xf000c3f8, "HT_WNETENUM_WNetEnumResourceW");
	add_ce_kernel_addr(0xf000bff8, "SH_GDI_AddFontResourceW");
	add_ce_kernel_addr(0xf000bff4, "SH_GDI_BitBlt");
	add_ce_kernel_addr(0xf000bff0, "SH_GDI_CombineRgn");
	add_ce_kernel_addr(0xf000bfec, "SH_GDI_CreateCompatibleDC");
	add_ce_kernel_addr(0xf000bfe8, "SH_GDI_CreateDIBPatternBrushPt");
	add_ce_kernel_addr(0xF000BFE4, "SH_GDI_CreateDIBSection");
	add_ce_kernel_addr(0xf000bfe0, "SH_GDI_CreateFontIndirectW");
	add_ce_kernel_addr(0xf000bfdc, "SH_GDI_CreateRectRgnIndirect");
	add_ce_kernel_addr(0xf000bfd8, "SH_GDI_CreatePenIndirect");
	add_ce_kernel_addr(0xf000bfd4, "SH_GDI_CreateSolidBrush");
	add_ce_kernel_addr(0xf000bfd0, "SH_GDI_DeleteDC");
	add_ce_kernel_addr(0xf000bfcc, "SH_GDI_DeleteObject");
	add_ce_kernel_addr(0xf000bfc8, "SH_GDI_DrawEdge");
	add_ce_kernel_addr(0xf000bfc4, "SH_GDI_DrawFocusRect");
	add_ce_kernel_addr(0xf000bfc0, "SH_GDI_DrawTextW");
	add_ce_kernel_addr(0xf000bfbc, "SH_GDI_Ellipse");
	add_ce_kernel_addr(0xf000bfb8, "SH_GDI_EnumFontFamiliesW");
	add_ce_kernel_addr(0xF000BFB4, "SH_GDI_EnumFontsW");
	add_ce_kernel_addr(0xf000bfb0, "SH_GDI_ExcludeClipRect");
	add_ce_kernel_addr(0xf000bfac, "SH_GDI_ExtTextOutW");
	add_ce_kernel_addr(0xf000bfa8, "SH_GDI_FillRect");
	add_ce_kernel_addr(0xf000bfa0, "SH_GDI_GetBkColor");
	add_ce_kernel_addr(0xf000bf9c, "SH_GDI_GetBkMode");
	add_ce_kernel_addr(0xf000bf98, "SH_GDI_GetClipRgn");
	add_ce_kernel_addr(0xf000bf94, "SH_GDI_GetCurrentObject");
	add_ce_kernel_addr(0xf000bf90, "SH_GDI_GetDeviceCaps");
	add_ce_kernel_addr(0xf000bf8c, "SH_GDI_GetNearestColor");
	add_ce_kernel_addr(0xf000bf88, "SH_GDI_GetObjectW");
	add_ce_kernel_addr(0xf000bf84, "SH_GDI_GetObjectType");
	add_ce_kernel_addr(0xf000bf80, "SH_GDI_GetPixel");
	add_ce_kernel_addr(0xf000bf7c, "SH_GDI_GetRegionData");
	add_ce_kernel_addr(0xf000bf78, "SH_GDI_GetRgnBox");
	add_ce_kernel_addr(0xf000bf74, "SH_GDI_GetStockObject");
	add_ce_kernel_addr(0xf000bf70, "SH_GDI_PatBlt");
	add_ce_kernel_addr(0xf000bf6c, "SH_GDI_GetTextColor");
	add_ce_kernel_addr(0xf000bf68, "SH_GDI_GetTextExtentExPointW");
	add_ce_kernel_addr(0xf000bf64, "SH_GDI_GetTextFaceW");
	add_ce_kernel_addr(0xf000bf60, "SH_GDI_GetTextMetricsW");
	add_ce_kernel_addr(0xf000bf5c, "SH_GDI_MaskBlt");
	add_ce_kernel_addr(0xf000bf58, "SH_GDI_OffsetRgn");
	add_ce_kernel_addr(0xf000bf54, "SH_GDI_Polygon");
	add_ce_kernel_addr(0xf000bf50, "SH_GDI_Polyline");
	add_ce_kernel_addr(0xf000bf4c, "SH_GDI_PtInRegion");
	add_ce_kernel_addr(0xf000bf48, "SH_GDI_Rectangle");
	add_ce_kernel_addr(0xf000bf44, "SH_GDI_RectInRegion");
	add_ce_kernel_addr(0xf000bf40, "SH_GDI_RemoveFontResourceW");
	add_ce_kernel_addr(0xf000bf3c, "SH_GDI_RestoreDC");
	add_ce_kernel_addr(0xf000bf38, "SH_GDI_RoundRect");
	add_ce_kernel_addr(0xf000bf34, "SH_GDI_SaveDC");
	add_ce_kernel_addr(0xf000bf30, "SH_GDI_SelectClipRgn");
	add_ce_kernel_addr(0xf000bf2c, "SH_GDI_SelectObject");
	add_ce_kernel_addr(0xf000bf28, "SH_GDI_SetBkColor");
	add_ce_kernel_addr(0xf000bf24, "SH_GDI_SetBkMode");
	add_ce_kernel_addr(0xf000bf20, "SH_GDI_SetBrushOrgEx");
	add_ce_kernel_addr(0xf000bf1c, "SH_GDI_SetPixel");
	add_ce_kernel_addr(0xf000bf18, "SH_GDI_SetTextColor");
	add_ce_kernel_addr(0xf000bf14, "SH_GDI_StretchBlt");
	add_ce_kernel_addr(0xf000bf10, "SH_GDI_CreateBitmap");
	add_ce_kernel_addr(0xf000bf0c, "SH_GDI_CreateCompatibleBitmap");
	add_ce_kernel_addr(0xf000bf08, "SH_GDI_GetSysColorBrush");
	add_ce_kernel_addr(0xf000bf04, "SH_GDI_IntersectClipRect");
	add_ce_kernel_addr(0xf000bf00, "SH_GDI_GetClipBox");
	add_ce_kernel_addr(0xf000befc, "SH_GDI_CeRemoveFontResource");
	add_ce_kernel_addr(0xf000bef8, "SH_GDI_EnableEUDC");
	add_ce_kernel_addr(0xf000bef4, "SH_GDI_CloseEnhMetaFile");
	add_ce_kernel_addr(0xf000bef0, "SH_GDI_CreateEnhMetaFileW");
	add_ce_kernel_addr(0xf000beec, "SH_GDI_DeleteEnhMetaFile");
	add_ce_kernel_addr(0xf000bee8, "SH_GDI_PlayEnhMetaFile");
	add_ce_kernel_addr(0xf000bee4, "SH_GDI_CreatePalette");
	add_ce_kernel_addr(0xf000bee0, "SH_GDI_SelectPalette");
	add_ce_kernel_addr(0xf000bedc, "SH_GDI_RealizePalette");
	add_ce_kernel_addr(0xf000bed8, "SH_GDI_GetPaletteEntries");
	add_ce_kernel_addr(0xf000bed4, "SH_GDI_SetPaletteEntries");
	add_ce_kernel_addr(0xf000bed0, "SH_GDI_GetSystemPaletteEntries");
	add_ce_kernel_addr(0xf000becc, "SH_GDI_GetNearestPaletteIndex");
	add_ce_kernel_addr(0xf000bec8, "SH_GDI_CreatePen");
	add_ce_kernel_addr(0xf000bec4, "SH_GDI_StartDocW");
	add_ce_kernel_addr(0xf000bec0, "SH_GDI_EndDoc");
	add_ce_kernel_addr(0xf000bebc, "SH_GDI_StartPage");
	add_ce_kernel_addr(0xf000beb8, "SH_GDI_EndPage");
	add_ce_kernel_addr(0xf000beb4, "SH_GDI_AbortDoc");
	add_ce_kernel_addr(0xf000beb0, "SH_GDI_SetAbortProc");
	add_ce_kernel_addr(0xf000beac, "SH_GDI_CreateDCW");
	add_ce_kernel_addr(0xf000bea8, "SH_GDI_CreateRectRgn");
	add_ce_kernel_addr(0xf000bea4, "SH_GDI_FillRgn");
	add_ce_kernel_addr(0xf000bea0, "SH_GDI_SetROP2");
	add_ce_kernel_addr(0xf000be9c, "SH_GDI_SetRectRgn");
	add_ce_kernel_addr(0xf000be98, "SH_GDI_RectVisible");
	add_ce_kernel_addr(0xf000be94, "SH_GDI_CreatePatternBrush");
	add_ce_kernel_addr(0xf000be90, "SH_GDI_CreateBitmapFromPointer");
	add_ce_kernel_addr(0xf000be8c, "SH_GDI_SetViewportOrgEx");
	add_ce_kernel_addr(0xf000be88, "SH_GDI_TransparentImage");
	add_ce_kernel_addr(0xf000be84, "SH_GDI_SetObjectOwner");
	add_ce_kernel_addr(0xf000be80, "SH_GDI_TranslateCharsetInfo");
	add_ce_kernel_addr(0xf000be7c, "SH_GDI_ExtEscape");
	add_ce_kernel_addr(0xf000be78, "SH_GDI_SetWindowsHookExW_Trap");
	add_ce_kernel_addr(0xf000be74, "SH_GDI_UnhookWindowsHookEx_Trap");
	add_ce_kernel_addr(0xf000be70, "SH_GDI_GetForegroundInfo");
	add_ce_kernel_addr(0xf000be6c, "SH_GDI_CeGetUserNotificationPreferences");
	add_ce_kernel_addr(0xf000be68, "SH_GDI_CeSetUserNotificationEx");
	add_ce_kernel_addr(0xf000be64, "SH_GDI_CeClearUserNotification");
	add_ce_kernel_addr(0xf000be60, "SH_GDI_CeRunAppAtEvent");
	add_ce_kernel_addr(0xf000be5c, "SH_GDI_CeHandleAppNotifications");
	add_ce_kernel_addr(0xf000be58, "SH_GDI_CeGetUserNotificationHandles");
	add_ce_kernel_addr(0xf000be54, "SH_GDI_CeGetUserNotification");
	add_ce_kernel_addr(0xf000be50, "SH_GDI_CeEventHasOccurred");
	add_ce_kernel_addr(0xf000be4c, "SH_GDI_SetWindowRgn_Trap");
	add_ce_kernel_addr(0xf000be48, "SH_GDI_GetPrivateCallbacks_Trap");
	add_ce_kernel_addr(0xf000be44, "SH_GDI_GetWindowRgn_Trap");
	add_ce_kernel_addr(0xf000be40, "SH_GDI_CeRunAppAtTime");
	add_ce_kernel_addr(0xf000be3c, "SH_GDI_GetDesktopWindow_Trap");
	add_ce_kernel_addr(0xf000be38, "SH_GDI_InSendMessage_Trap");
	add_ce_kernel_addr(0xf000be34, "SH_GDI_GetQueueStatus_Trap");
	add_ce_kernel_addr(0xf000be30, "SH_GDI_AllKeys_Trap");
	add_ce_kernel_addr(0xf000be2c, "SH_GDI_LoadAnimatedCursor_Trap");
	add_ce_kernel_addr(0xf000be28, "SH_GDI_SendMessageTimeout");
	add_ce_kernel_addr(0xf000be24, "SH_GDI_SetProp_Trap");
	add_ce_kernel_addr(0xf000be20, "SH_GDI_GetProp_Trap");
	add_ce_kernel_addr(0xf000be1c, "SH_GDI_RemoveProp_Trap");
	add_ce_kernel_addr(0xf000be18, "SH_GDI_EnumPropsEx_Trap");
	add_ce_kernel_addr(0xf000be14, "SH_GDI_GetMessageQueueReadyTimeStamp");
	add_ce_kernel_addr(0xf000be10, "SH_GDI_RegisterTaskBarEx");
	add_ce_kernel_addr(0xf000be0c, "SH_GDI_RegisterDesktop");
	add_ce_kernel_addr(0xf000be08, "SH_GDI_GlobalAddAtomW");
	add_ce_kernel_addr(0xf000be04, "SH_GDI_GlobalDeleteAtom");
	add_ce_kernel_addr(0xf000be00, "SH_GDI_GlobalFindAtomW");
	add_ce_kernel_addr(0xf000bdfc, "SH_GDI_MonitorFromPoint_Trap");
	add_ce_kernel_addr(0xf000bdf8, "SH_GDI_MonitorFromRect_Trap");
	add_ce_kernel_addr(0xf000bdf4, "SH_GDI_MonitorFromWindow_Trap");
	add_ce_kernel_addr(0xf000bdf0, "SH_GDI_GetMonitorInfo_Trap");
	add_ce_kernel_addr(0xf000bdec, "SH_GDI_EnumDisplayMonitors_Trap");
	add_ce_kernel_addr(0xf000bde8, "SH_GDI_AccessibilitySoundSentryEvent_Trap");
	add_ce_kernel_addr(0xf000bde4, "SH_GDI_ChangeDisplaySettingsEx_Trap");
	add_ce_kernel_addr(0xf000bde0, "SH_GDI_InvalidateRgn_Trap");
	add_ce_kernel_addr(0xf000bddc, "SH_GDI_ValidateRgn_Trap");
	add_ce_kernel_addr(0xf000bdd8, "SH_GDI_ExtCreateRegion");
	add_ce_kernel_addr(0xf000bdd4, "SH_GDI_MoveToEx");
	add_ce_kernel_addr(0xf000bdd0, "SH_GDI_LineTo");
	add_ce_kernel_addr(0xf000bdcc, "SH_GDI_GetCurrentPositionEx");
	add_ce_kernel_addr(0xf000bdc8, "SH_GDI_SetTextAlign");
	add_ce_kernel_addr(0xf000bdc4, "SH_GDI_GetTextAlign");
	add_ce_kernel_addr(0xf000bdc0, "SH_GDI_GetCharWidth32");
	add_ce_kernel_addr(0xf000bdbc, "SH_GDI_GetDIBColorTable");
	add_ce_kernel_addr(0xf000bdb8, "SH_GDI_SetDIBColorTable");
	add_ce_kernel_addr(0xf000bdb4, "SH_GDI_StretchDIBits");
	add_ce_kernel_addr(0xf000bdb0, "SH_GDI_RedrawWindow_Trap");
	add_ce_kernel_addr(0xf000bdac, "SH_GDI_SetBitmapBits");
	add_ce_kernel_addr(0xf000bda8, "SH_GDI_SetDIBitsToDevice");
	add_ce_kernel_addr(0xf000bda4, "SH_GDI_GradientFill");
	add_ce_kernel_addr(0xf000bda0, "SH_GDI_InvertRect");
	add_ce_kernel_addr(0xf000bd9c, "SH_GDI_EnumDisplaySettings_Trap");
	add_ce_kernel_addr(0xf000bd98, "SH_GDI_EnumDisplayDevices_Trap");
	add_ce_kernel_addr(0xf000bd94, "SH_GDI_GetCharABCWidths");
	add_ce_kernel_addr(0xf000bd90, "SH_GDI_ShowStartupWindow_Trap");
	add_ce_kernel_addr(0xF000BD8C, "SH_GDI_GetGweApiSetTables");
	add_ce_kernel_addr(0xF000BD88, "SH_GDI_GetStretchBltMode");
	add_ce_kernel_addr(0xF000BD84, "SH_GDI_SetStretchBltMode");
	add_ce_kernel_addr(0xF000BD80, "SH_GDI_AlphaBlend");
	add_ce_kernel_addr(0xF000BD7C, "SH_GDI_GetIconInfo");
	add_ce_kernel_addr(0xF000BD78, "SH_GDI_EnumFontFamiliesExW");
	add_ce_kernel_addr(0xF000BD74, "SH_GDI_GetFontData");
	add_ce_kernel_addr(0xF000BD70, "SH_GDI_GetCharABCWidthsI");
	add_ce_kernel_addr(0xF000BD6C, "SH_GDI_GetOutlineTextMetricsW");
	add_ce_kernel_addr(0xF000BD68, "SH_GDI_SetLayout");
	add_ce_kernel_addr(0xF000BD64, "SH_GDI_GetLayout");
	add_ce_kernel_addr(0xF000BD60, "SH_GDI_SetTextCharacterExtra");
	add_ce_kernel_addr(0xF000BD5C, "SH_GDI_GetTextCharacterExtra");
	add_ce_kernel_addr(0xF000BD58, "SH_GDI_ImmGetKeyboardLayout");
	add_ce_kernel_addr(0xF000BD54, "SH_GDI_GetViewportOrgEx");
	add_ce_kernel_addr(0xF000BD50, "SH_GDI_GetViewportExtEx");
	add_ce_kernel_addr(0xF000BD4C, "SH_GDI_OffsetViewportOrgEx");
	add_ce_kernel_addr(0xF000BD48, "SH_GDI_GetROP2");
	add_ce_kernel_addr(0xF000BD44, "SH_GDI_SetWindowOrgEx");
	add_ce_kernel_addr(0xF000BD40, "SH_GDI_GetWindowOrgEx");
	add_ce_kernel_addr(0xF000BD3C, "SH_GDI_GetWindowExtEx");
	add_ce_kernel_addr(0xF000BD34, "SH_GDI_Gesture");
	add_ce_kernel_addr(0xF000BD30, "SH_GDI_GetWindowAutoGesture");
	add_ce_kernel_addr(0xF000BD2C, "SH_GDI_SetWindowAutoGesture");
	add_ce_kernel_addr(0xF000BD28, "SH_GDI_RegisterGesture");
	add_ce_kernel_addr(0xF000BD24, "SH_GDI_RegisterDefaultGestureHandler");
	add_ce_kernel_addr(0xF000BD20, "SH_GDI_SetLayeredWindowAttributes");
	add_ce_kernel_addr(0xF000BD1C, "SH_GDI_GetLayeredWindowAttributes");
	add_ce_kernel_addr(0xF000BD18, "SH_GDI_UpdateLayeredWindow");
	add_ce_kernel_addr(0xF000BD14, "SH_GDI_UpdateLayeredWindowIndirect");
	add_ce_kernel_addr(0xF000BD10, "SH_GDI_DrawThemePrimitive");
	add_ce_kernel_addr(0xF000BD0C, "SH_GDI_ThemePrimitiveExists");
	add_ce_kernel_addr(0xF000BD08, "SH_GDI_UpdateThemePrimitives");
	add_ce_kernel_addr(0xF000BD04, "SH_GDI_COREDLL_2872");


	add_ce_kernel_addr(0xf000bbf8, "SH_WMGR_RegisterClassWApiSetEntry_Trap");
	add_ce_kernel_addr(0xf000bbf4, "SH_WMGR_UnregisterClassW_Trap");
	add_ce_kernel_addr(0xf000bbf0, "SH_WMGR_CreateWindowExW_Trap");
	add_ce_kernel_addr(0xf000bbec, "SH_WMGR_PostMessageW");
	add_ce_kernel_addr(0xf000bbe8, "SH_WMGR_PostQuitMessage_Trap");
	add_ce_kernel_addr(0xf000bbe4, "SH_WMGR_SendMessageW");
	add_ce_kernel_addr(0xf000bbe0, "SH_WMGR_GetMessageW");
	add_ce_kernel_addr(0xf000bbdc, "SH_WMGR_TranslateMessage_Trap");
	add_ce_kernel_addr(0xf000bbd8, "SH_WMGR_DispatchMessageW");
	add_ce_kernel_addr(0xf000bbd4, "SH_WMGR_GetCapture_Trap");
	add_ce_kernel_addr(0xf000bbd0, "SH_WMGR_SetCapture_Trap");
	add_ce_kernel_addr(0xf000bbcc, "SH_WMGR_ReleaseCapture_Trap");
	add_ce_kernel_addr(0xf000bbc8, "SH_WMGR_SetWindowPos");
	add_ce_kernel_addr(0xf000bbc4, "SH_WMGR_GetWindowRect");
	add_ce_kernel_addr(0xf000bbc0, "SH_WMGR_GetClientRect");
	add_ce_kernel_addr(0xf000bbbc, "SH_WMGR_InvalidateRect");
	add_ce_kernel_addr(0xf000bbb8, "SH_WMGR_GetWindow");
	add_ce_kernel_addr(0xf000bbb4, "SH_WMGR_GetSystemMetrics");
	add_ce_kernel_addr(0xf000bbb0, "SH_WMGR_ImageList_GetDragImage");
	add_ce_kernel_addr(0xf000bbac, "SH_WMGR_ImageList_GetIconSize");
	add_ce_kernel_addr(0xf000bba8, "SH_WMGR_ImageList_SetIconSize");
	add_ce_kernel_addr(0xf000bba4, "SH_WMGR_ImageList_GetImageInfo");
	add_ce_kernel_addr(0xf000bba0, "SH_WMGR_ImageList_Merge");
	add_ce_kernel_addr(0xf000bb9c, "SH_WMGR_ShowCursor_Trap");
	add_ce_kernel_addr(0xf000bb98, "SH_WMGR_SetCursorPos_Trap");
	add_ce_kernel_addr(0xf000bb94, "SH_WMGR_ImageList_CopyDitherImage");
	add_ce_kernel_addr(0xf000bb90, "SH_WMGR_ImageList_DrawIndirect");
	add_ce_kernel_addr(0xf000bb8c, "SH_WMGR_ImageList_DragShowNolock");
	add_ce_kernel_addr(0xf000bb88, "SH_WMGR_WindowFromPoint_Trap");
	add_ce_kernel_addr(0xf000bb84, "SH_WMGR_ChildWindowFromPoint_Trap");
	add_ce_kernel_addr(0xf000bb80, "SH_WMGR_ClientToScreen");
	add_ce_kernel_addr(0xf000bb7c, "SH_WMGR_ScreenToClient_Trap");
	add_ce_kernel_addr(0xf000bb78, "SH_WMGR_SetWindowTextW_Trap");
	add_ce_kernel_addr(0xf000bb74, "SH_WMGR_GetWindowTextW_Trap");
	add_ce_kernel_addr(0xf000bb70, "SH_WMGR_SetWindowLongW");
	add_ce_kernel_addr(0xf000bb6c, "SH_WMGR_GetWindowLongW");
	add_ce_kernel_addr(0xf000bb68, "SH_WMGR_BeginPaint");
	add_ce_kernel_addr(0xf000bb64, "SH_WMGR_EndPaint");
	add_ce_kernel_addr(0xf000bb60, "SH_WMGR_GetDC");
	add_ce_kernel_addr(0xf000bb5c, "SH_WMGR_ReleaseDC");
	add_ce_kernel_addr(0xf000bb58, "SH_WMGR_DefWindowProcW");
	add_ce_kernel_addr(0xf000bb54, "SH_WMGR_GetClassLongW_Trap");
	add_ce_kernel_addr(0xf000bb50, "SH_WMGR_SetClassLongW_Trap");
	add_ce_kernel_addr(0xf000bb4c, "SH_WMGR_DestroyWindow_Trap");
	add_ce_kernel_addr(0xf000bb48, "SH_WMGR_ShowWindow_Trap");
	add_ce_kernel_addr(0xf000bb44, "SH_WMGR_UpdateWindow_Trap");
	add_ce_kernel_addr(0xf000bb40, "SH_WMGR_SetParent_Trap");
	add_ce_kernel_addr(0xf000bb3c, "SH_WMGR_GetParent");
	add_ce_kernel_addr(0xf000bb38, "SH_WMGR_MessageBoxW_Trap");
	add_ce_kernel_addr(0xf000bb34, "SH_WMGR_SetFocus_Trap");
	add_ce_kernel_addr(0xf000bb30, "SH_WMGR_GetFocus");
	add_ce_kernel_addr(0xf000bb2c, "SH_WMGR_GetActiveWindow_Trap");
	add_ce_kernel_addr(0xf000bb28, "SH_WMGR_GetWindowDC_Trap");
	add_ce_kernel_addr(0xf000bb24, "SH_WMGR_GetSysColor");
	add_ce_kernel_addr(0xf000bb20, "SH_WMGR_AdjustWindowRectEx_Trap");
	add_ce_kernel_addr(0xf000bb1c, "SH_WMGR_IsWindow");
	add_ce_kernel_addr(0xf000bb18, "SH_WMGR_CreatePopupMenu_Trap");
	add_ce_kernel_addr(0xf000bb14, "SH_WMGR_InsertMenuW_Trap");
	add_ce_kernel_addr(0xf000bb10, "SH_WMGR_AppendMenuW_Trap");
	add_ce_kernel_addr(0xf000bb0c, "SH_WMGR_RemoveMenu_Trap");
	add_ce_kernel_addr(0xf000bb08, "SH_WMGR_DestroyMenu_Trap");
	add_ce_kernel_addr(0xf000bb04, "SH_WMGR_TrackPopupMenuEx_Trap");
	add_ce_kernel_addr(0xf000bb00, "SH_WMGR_LoadMenuW_Trap");
	add_ce_kernel_addr(0xf000bafc, "SH_WMGR_EnableMenuItem_Trap");
	add_ce_kernel_addr(0xf000baf8, "SH_WMGR_MoveWindow_Trap");
	add_ce_kernel_addr(0xf000baf4, "SH_WMGR_GetUpdateRgn_Trap");
	add_ce_kernel_addr(0xf000baf0, "SH_WMGR_GetUpdateRect_Trap");
	add_ce_kernel_addr(0xf000baec, "SH_WMGR_BringWindowToTop_Trap");
	add_ce_kernel_addr(0xf000bae8, "SH_WMGR_GetWindowTextLengthW_Trap");
	add_ce_kernel_addr(0xf000bae4, "SH_WMGR_IsChild_Trap");
	add_ce_kernel_addr(0xf000bae0, "SH_WMGR_IsWindowVisible");
	add_ce_kernel_addr(0xf000badc, "SH_WMGR_ValidateRect_Trap");
	add_ce_kernel_addr(0xf000bad8, "SH_WMGR_LoadBitmapW_Trap");
	add_ce_kernel_addr(0xf000bad4, "SH_WMGR_CheckMenuItem_Trap");
	add_ce_kernel_addr(0xf000bad0, "SH_WMGR_CheckMenuRadioItem_Trap");
	add_ce_kernel_addr(0xf000bacc, "SH_WMGR_DeleteMenu");
	add_ce_kernel_addr(0xf000bac8, "SH_WMGR_LoadIconW_Trap");
	add_ce_kernel_addr(0xf000bac4, "SH_WMGR_DrawIconEx_Trap");
	add_ce_kernel_addr(0xf000bac0, "SH_WMGR_DestroyIcon_Trap");
	add_ce_kernel_addr(0xf000babc, "SH_WMGR_GetAsyncKeyState");
	add_ce_kernel_addr(0xf000bab8, "SH_WMGR_multitouch_event");
	add_ce_kernel_addr(0xf000bab4, "SH_WMGR_DialogBoxIndirectParamW");
	add_ce_kernel_addr(0xf000bab0, "SH_WMGR_EndDialog");
	add_ce_kernel_addr(0xf000baac, "SH_WMGR_GetDlgItem");
	add_ce_kernel_addr(0xf000baa8, "SH_WMGR_GetDlgCtrlID");
	add_ce_kernel_addr(0xf000baa4, "SH_WMGR_GetKeyState");
	add_ce_kernel_addr(0xf000baa0, "SH_WMGR_KeybdGetDeviceInfo");
	add_ce_kernel_addr(0xf000ba9c, "SH_WMGR_KeybdInitStates");
	add_ce_kernel_addr(0xf000ba98, "SH_WMGR_PostKeybdMessage");
	add_ce_kernel_addr(0xf000ba94, "SH_WMGR_KeybdVKeyToUnicode");
	add_ce_kernel_addr(0xf000ba90, "SH_WMGR_keybd_event");
	add_ce_kernel_addr(0xf000ba8c, "SH_WMGR_mouse_event");
	add_ce_kernel_addr(0xf000ba88, "SH_WMGR_SetScrollInfo");
	add_ce_kernel_addr(0xf000ba84, "SH_WMGR_SetScrollPos");
	add_ce_kernel_addr(0xf000ba80, "SH_WMGR_SetScrollRange");
	add_ce_kernel_addr(0xf000ba7c, "SH_WMGR_GetScrollInfo");
	add_ce_kernel_addr(0xf000ba78, "SH_WMGR_PeekMessageW");
	add_ce_kernel_addr(0xf000ba74, "SH_WMGR_MapVirtualKeyW");
	add_ce_kernel_addr(0xf000ba70, "SH_WMGR_GetMessageWNoWait");
	add_ce_kernel_addr(0xf000ba6c, "SH_WMGR_GetClassNameW");
	add_ce_kernel_addr(0xf000ba68, "SH_WMGR_MapWindowPoints");
	add_ce_kernel_addr(0xf000ba64, "SH_WMGR_LoadImageW");
	add_ce_kernel_addr(0xf000ba60, "SH_WMGR_GetForegroundWindow");
	add_ce_kernel_addr(0xf000ba5c, "SH_WMGR_SetForegroundWindow");
	add_ce_kernel_addr(0xf000ba58, "SH_WMGR_RegisterTaskBar");
	add_ce_kernel_addr(0xf000ba54, "SH_WMGR_SetActiveWindow");
	add_ce_kernel_addr(0xf000ba50, "SH_WMGR_CallWindowProcW_Trap");
	add_ce_kernel_addr(0xf000ba4c, "SH_WMGR_GetClassInfoW");
	add_ce_kernel_addr(0xf000ba48, "SH_WMGR_GetNextDlgTabItem");
	add_ce_kernel_addr(0xf000ba44, "SH_WMGR_CreateDialogIndirectParamW");
	add_ce_kernel_addr(0xf000ba40, "SH_WMGR_IsDialogMessageW");
	add_ce_kernel_addr(0xf000ba3c, "SH_WMGR_SetDlgItemInt");
	add_ce_kernel_addr(0xf000ba38, "SH_WMGR_GetDlgItemInt");
	add_ce_kernel_addr(0xf000ba34, "SH_WMGR_FindWindowW");
	add_ce_kernel_addr(0xf000ba30, "SH_WMGR_CreateCaret");
	add_ce_kernel_addr(0xf000ba2c, "SH_WMGR_DestroyCaret");
	add_ce_kernel_addr(0xf000ba28, "SH_WMGR_HideCaret");
	add_ce_kernel_addr(0xf000ba24, "SH_WMGR_ShowCaret");
	add_ce_kernel_addr(0xf000ba20, "SH_WMGR_SetCaretPos");
	add_ce_kernel_addr(0xf000ba1c, "SH_WMGR_GetCaretPos");
	add_ce_kernel_addr(0xf000ba18, "SH_WMGR_GetCursorPos_Trap");
	add_ce_kernel_addr(0xf000ba14, "SH_WMGR_ClipCursor");
	add_ce_kernel_addr(0xf000ba10, "SH_WMGR_GetClipCursor");
	add_ce_kernel_addr(0xf000ba0c, "SH_WMGR_GetCursor_Trap");
	add_ce_kernel_addr(0xf000ba08, "SH_WMGR_ExtractIconExW");
	add_ce_kernel_addr(0xf000ba04, "SH_WMGR_SetTimer_Trap");
	add_ce_kernel_addr(0xf000ba00, "SH_WMGR_KillTimer_Trap");
	add_ce_kernel_addr(0xf000b9fc, "SH_WMGR_GetNextDlgGroupItem");
	add_ce_kernel_addr(0xf000b9f8, "SH_WMGR_CheckRadioButton");
	add_ce_kernel_addr(0xf000b9f4, "SH_WMGR_EnableWindow");
	add_ce_kernel_addr(0xf000b9f0, "SH_WMGR_IsWindowEnabled");
	add_ce_kernel_addr(0xf000b9ec, "SH_WMGR_CreateMenu");
	add_ce_kernel_addr(0xf000b9e8, "SH_WMGR_GetSubMenu");
	add_ce_kernel_addr(0xf000b9e4, "SH_WMGR_DefDlgProcW");
	add_ce_kernel_addr(0xf000b9e0, "SH_WMGR_SendNotifyMessageW");
	add_ce_kernel_addr(0xf000b9dc, "SH_WMGR_PostThreadMessageW");
	add_ce_kernel_addr(0xf000b9d8, "SH_WMGR_TranslateAcceleratorW");
	add_ce_kernel_addr(0xf000b9d4, "SH_WMGR_GetKeyboardLayout");
	add_ce_kernel_addr(0xf000b9d0, "SH_WMGR_GetKeyboardLayoutList");
	add_ce_kernel_addr(0xf000b9cc, "SH_WMGR_GetKeyboardType");
	add_ce_kernel_addr(0xf000b9c8, "SH_WMGR_ImageList_Create");
	add_ce_kernel_addr(0xf000b9c4, "SH_WMGR_ImageList_Destroy");
	add_ce_kernel_addr(0xf000b9c0, "SH_WMGR_ImageList_GetImageCount");
	add_ce_kernel_addr(0xf000b9bc, "SH_WMGR_ImageList_Add");
	add_ce_kernel_addr(0xf000b9b8, "SH_WMGR_ImageList_ReplaceIcon");
	add_ce_kernel_addr(0xf000b9b4, "SH_WMGR_ImageList_SetBkColor");
	add_ce_kernel_addr(0xf000b9b0, "SH_WMGR_ImageList_GetBkColor");
	add_ce_kernel_addr(0xf000b9ac, "SH_WMGR_ImageList_SetOverlayImage");
	add_ce_kernel_addr(0xf000b9a8, "SH_WMGR_ImageList_Draw");
	add_ce_kernel_addr(0xf000b9a4, "SH_WMGR_ImageList_Replace");
	add_ce_kernel_addr(0xf000b9a0, "SH_WMGR_ImageList_AddMasked");
	add_ce_kernel_addr(0xf000b99c, "SH_WMGR_ImageList_DrawEx");
	add_ce_kernel_addr(0xf000b998, "SH_WMGR_ImageList_Remove");
	add_ce_kernel_addr(0xf000b994, "SH_WMGR_ImageList_GetIcon");
	add_ce_kernel_addr(0xf000b990, "SH_WMGR_ImageList_LoadImage");
	add_ce_kernel_addr(0xf000b98c, "SH_WMGR_ImageList_BeginDrag");
	add_ce_kernel_addr(0xf000b988, "SH_WMGR_ImageList_EndDrag");
	add_ce_kernel_addr(0xf000b984, "SH_WMGR_ImageList_DragEnter");
	add_ce_kernel_addr(0xf000b980, "SH_WMGR_ImageList_DragLeave");
	add_ce_kernel_addr(0xf000b97c, "SH_WMGR_ImageList_DragMove");
	add_ce_kernel_addr(0xf000b978, "SH_WMGR_ImageList_SetDragCursorImage");
	add_ce_kernel_addr(0xf000b974, "SH_WMGR_AudioUpdateFromRegistry");
	add_ce_kernel_addr(0xf000b970, "SH_WMGR_ScrollDC");
	add_ce_kernel_addr(0xf000b96c, "SH_WMGR_ScrollWindowEx");
	add_ce_kernel_addr(0xf000b968, "SH_WMGR_OpenClipboard");
	add_ce_kernel_addr(0xf000b964, "SH_WMGR_CloseClipboard");
	add_ce_kernel_addr(0xf000b960, "SH_WMGR_GetClipboardOwner");
	add_ce_kernel_addr(0xf000b95c, "SH_WMGR_SetClipboardData");
	add_ce_kernel_addr(0xf000b958, "SH_WMGR_GetClipboardDataGwe");
	add_ce_kernel_addr(0xf000b954, "SH_WMGR_RegisterClipboardFormatW");
	add_ce_kernel_addr(0xf000b950, "SH_WMGR_CountClipboardFormats");
	add_ce_kernel_addr(0xf000b94c, "SH_WMGR_EnumClipboardFormats");
	add_ce_kernel_addr(0xf000b948, "SH_WMGR_GetClipboardFormatNameW");
	add_ce_kernel_addr(0xf000b944, "SH_WMGR_EmptyClipboard");
	add_ce_kernel_addr(0xf000b940, "SH_WMGR_IsClipboardFormatAvailable");
	add_ce_kernel_addr(0xf000b93c, "SH_WMGR_GetPriorityClipboardFormat");
	add_ce_kernel_addr(0xf000b938, "SH_WMGR_GetOpenClipboardWindow");
	add_ce_kernel_addr(0xf000b934, "SH_WMGR_MessageBeep");
	add_ce_kernel_addr(0xf000b930, "SH_WMGR_SystemIdleTimerReset");
	add_ce_kernel_addr(0xf000b92c, "SH_WMGR_SystemIdleTimerUpdateMax");
	add_ce_kernel_addr(0xf000b928, "SH_WMGR_Unused182");
	add_ce_kernel_addr(0xf000b924, "SH_WMGR_SetKeyboardTarget");
	add_ce_kernel_addr(0xf000b920, "SH_WMGR_GetKeyboardTarget");
	add_ce_kernel_addr(0xf000b91c, "SH_WMGR_NotifyWinUserSystem");
	add_ce_kernel_addr(0xf000b918, "SH_WMGR_SetMenuItemInfoW");
	add_ce_kernel_addr(0xf000b914, "SH_WMGR_GetMenuItemInfoW");
	add_ce_kernel_addr(0xf000b910, "SH_WMGR_SetCaretBlinkTime");
	add_ce_kernel_addr(0xf000b90c, "SH_WMGR_GetCaretBlinkTime");
	add_ce_kernel_addr(0xf000b908, "SH_WMGR_GetMessagePos");
	add_ce_kernel_addr(0xf000b904, "SH_WMGR_QASetWindowsJournalHook");
	add_ce_kernel_addr(0xf000b900, "SH_WMGR_QAUnhookWindowsJournalHook");
	add_ce_kernel_addr(0xf000b8fc, "SH_WMGR_NLedGetDeviceInfo");
	add_ce_kernel_addr(0xf000b8f8, "SH_WMGR_NLedSetDevice");
	add_ce_kernel_addr(0xf000b8f4, "SH_WMGR_EnumWindows_Trap");
	add_ce_kernel_addr(0xf000b8f0, "SH_WMGR_RectangleAnimation");
	add_ce_kernel_addr(0xf000b8ec, "SH_WMGR_MapDialogRect");
	add_ce_kernel_addr(0xf000b8e8, "SH_WMGR_GetSystemPowerStatusEx");
	add_ce_kernel_addr(0xf000b8e4, "SH_WMGR_GetDialogBaseUnits");
	add_ce_kernel_addr(0xf000b8e0, "SH_WMGR_GetDoubleClickTime");
	add_ce_kernel_addr(0xf000b8dc, "SH_WMGR_GetWindowThreadProcessId");
	add_ce_kernel_addr(0xf000b8d8, "SH_WMGR_CreateIconIndirect");
	add_ce_kernel_addr(0xf000b8d4, "SH_WMGR_ShellModalEnd");
	add_ce_kernel_addr(0xf000b8d0, "SH_WMGR_TouchCalibrate");
	add_ce_kernel_addr(0xf000b8cc, "SH_WMGR_BatteryGetLifeTimeInfo");
	add_ce_kernel_addr(0xf000b8c8, "SH_WMGR_BatteryDrvrGetLevels");
	add_ce_kernel_addr(0xf000b8c4, "SH_WMGR_GwesPowerOffSystem");
	add_ce_kernel_addr(0xf000b8c0, "SH_WMGR_BatteryNotifyOfTimeChange");
	add_ce_kernel_addr(0xf000b8bc, "SH_WMGR_LoadCursorW_Trap");
	add_ce_kernel_addr(0xf000b8b8, "SH_WMGR_SetCursor");
	add_ce_kernel_addr(0xf000b8b4, "SH_WMGR_DestroyCursor_Trap");
	add_ce_kernel_addr(0xf000b8b0, "SH_WMGR_DisableCaretSystemWide");
	add_ce_kernel_addr(0xf000b8ac, "SH_WMGR_EnableCaretSystemWide");
	add_ce_kernel_addr(0xf000b8a8, "SH_WMGR_GetMouseMovePoints");
	add_ce_kernel_addr(0xf000b8a4, "SH_WMGR_BatteryDrvrSupportsChangeNotification");
	add_ce_kernel_addr(0xf000b8a0, "SH_WMGR_EnableHardwareKeyboard");
	add_ce_kernel_addr(0xf000b89c, "SH_WMGR_GetKeyboardStatus");
	add_ce_kernel_addr(0xf000b898, "SH_WMGR_RegisterSIPanel");
	add_ce_kernel_addr(0xf000b894, "SH_WMGR_GetAsyncShiftFlags");
	add_ce_kernel_addr(0xf000b890, "SH_WMGR_MsgWaitForMultipleObjectsEx");
	add_ce_kernel_addr(0xf000b88c, "SH_WMGR_SetAssociatedMenu");
	add_ce_kernel_addr(0xf000b888, "SH_WMGR_GetAssociatedMenu");
	add_ce_kernel_addr(0xf000b884, "SH_WMGR_DrawMenuBar");
	add_ce_kernel_addr(0xf000b880, "SH_WMGR_SetSysColors");
	add_ce_kernel_addr(0xf000b87c, "SH_WMGR_DrawFrameControl");
	add_ce_kernel_addr(0xf000b878, "SH_WMGR_CreateCursor_Trap");
	add_ce_kernel_addr(0xf000b874, "SH_WMGR_RegisterWindowMessageW");
	add_ce_kernel_addr(0xf000b870, "SH_WMGR_SystemParametersInfo_GWE_Trap");
	add_ce_kernel_addr(0xf000b86c, "SH_WMGR_SendInput");
	add_ce_kernel_addr(0xf000b868, "SH_WMGR_SendDlgItemMessageW");
	add_ce_kernel_addr(0xf000b864, "SH_WMGR_SetDlgItemTextW");
	add_ce_kernel_addr(0xf000b860, "SH_WMGR_GetDlgItemTextW");
	add_ce_kernel_addr(0xf000b85c, "SH_WMGR_GetMessageSource_Trap");
	add_ce_kernel_addr(0xf000b858, "SH_WMGR_RegisterHotKey_Trap");
	add_ce_kernel_addr(0xf000b854, "SH_WMGR_UnregisterHotKey_Trap");
	add_ce_kernel_addr(0xf000b850, "SH_WMGR_ImageList_Copy");
	add_ce_kernel_addr(0xf000b84c, "SH_WMGR_ImageList_Duplicate");
	add_ce_kernel_addr(0xf000b848, "SH_WMGR_ImageList_SetImageCount");
	add_ce_kernel_addr(0xf000b844, "SH_WMGR_UnregisterFunc1_Trap");
	add_ce_kernel_addr(0xf000b840, "SH_WMGR_ImmGetContextFromWindowGwe");
	add_ce_kernel_addr(0xf000b83c, "SH_WMGR_ImmAssociateContextWithWindowGwe");
	add_ce_kernel_addr(0xf000b838, "SH_WMGR_ImmSetHotKey");
	add_ce_kernel_addr(0xf000b834, "SH_WMGR_BeginDeferWindowPos_Trap");
	add_ce_kernel_addr(0xf000b830, "SH_WMGR_DeferWindowPos_Trap");
	add_ce_kernel_addr(0xf000b82c, "SH_WMGR_EndDeferWindowPos_Trap");
	add_ce_kernel_addr(0xf000b828, "SH_WMGR_ImmGetHotKey");
	add_ce_kernel_addr(0xf000b824, "SH_WMGR_GetDCEx_Trap");
	add_ce_kernel_addr(0xf000b820, "SH_WMGR_GwesPowerDown");
	add_ce_kernel_addr(0xf000b81c, "SH_WMGR_GwesPowerUp");
	add_ce_kernel_addr(0xf000b810, "SH_WMGR_LoadKeyboardLayoutW");
	add_ce_kernel_addr(0xf000b80c, "SH_WMGR_ActivateKeyboardLayout");
	add_ce_kernel_addr(0xf000b808, "SH_WMGR_GetSystemPowerStatusEx2");
	add_ce_kernel_addr(0xf000b804, "SH_WMGR_GetKeyboardLayoutNameW");
	add_ce_kernel_addr(0xf000b7fc, "SH_WNET_WNetAddConnection3W");
	add_ce_kernel_addr(0xf000b7f8, "SH_WNET_WNetCancelConnection2W");
	add_ce_kernel_addr(0xf000b7f4, "SH_WNET_WNetConnectionDialog1W");
	add_ce_kernel_addr(0xf000b7f0, "SH_WNET_WNetDisconnectDialog");
	add_ce_kernel_addr(0xf000b7ec, "SH_WNET_WNetDisconnectDialog1W");
	add_ce_kernel_addr(0xf000b7e8, "SH_WNET_WNetGetConnectionW");
	add_ce_kernel_addr(0xf000b7e4, "SH_WNET_WNetGetUniversalNameW");
	add_ce_kernel_addr(0xf000b7e0, "SH_WNET_WNetGetUserW");
	add_ce_kernel_addr(0xf000b7dc, "SH_WNET_WNetOpenEnumW");
	add_ce_kernel_addr(0xf000b3f8, "SH_COMM_AFDSocket");
	add_ce_kernel_addr(0xf000b3f4, "SH_COMM_AFDControl");
	add_ce_kernel_addr(0xf000b3f0, "SH_COMM_AFDEnumProtocolsW");
	add_ce_kernel_addr(0xf000b3ec, "SH_COMM_RasDial");
	add_ce_kernel_addr(0xf000b3e8, "SH_COMM_RasHangup");
	add_ce_kernel_addr(0xf000b3e4, "SH_COMM_AFDGetHostentByAttr");
	add_ce_kernel_addr(0xf000b3e0, "SH_COMM_AFDAddIPHostent");
	add_ce_kernel_addr(0xf000b3dc, "SH_COMM_RasIOControl");
	add_ce_kernel_addr(0xf000b3d8, "SH_COMM_AFDSelect");
	add_ce_kernel_addr(0xf000b3d4, "SH_COMM_RasEnumEntries");
	add_ce_kernel_addr(0xf000b3d0, "SH_COMM_RasGetEntryDialParams");
	add_ce_kernel_addr(0xf000b3cc, "SH_COMM_RasSetEntryDialParams");
	add_ce_kernel_addr(0xf000b3c8, "SH_COMM_RasGetEntryProperties");
	add_ce_kernel_addr(0xf000b3c4, "SH_COMM_RasSetEntryProperties");
	add_ce_kernel_addr(0xf000b3c0, "SH_COMM_RasValidateEntryName");
	add_ce_kernel_addr(0xf000b3bc, "SH_COMM_RasDeleteEntry");
	add_ce_kernel_addr(0xf000b3b8, "SH_COMM_RasRenameEntry");
	add_ce_kernel_addr(0xf000b3b4, "SH_COMM_AFDAddInterface");
	add_ce_kernel_addr(0xf000b3b0, "SH_COMM_RasEnumConnections");
	add_ce_kernel_addr(0xf000b3ac, "SH_COMM_RasGetConnectStatus");
	add_ce_kernel_addr(0xf000b3a8, "SH_COMM_RasGetEntryDevConfig");
	add_ce_kernel_addr(0xf000b3a4, "SH_COMM_RasSetEntryDevConfig");
	add_ce_kernel_addr(0xf000b3a0, "SH_COMM_NETbios");
	add_ce_kernel_addr(0xf000b398, "SH_COMM_PMInstallProvider");
	add_ce_kernel_addr(0xf000b394, "SH_COMM_PMEnumProtocols");
	add_ce_kernel_addr(0xf000b390, "SH_COMM_PMFindProvider");
	add_ce_kernel_addr(0xf000b38c, "SH_COMM_PMInstallNameSpace");
	add_ce_kernel_addr(0xf000b388, "SH_COMM_PMEnumNameSpaceProviders");
	add_ce_kernel_addr(0xf000b384, "SH_COMM_PMFindNameSpaces");
	add_ce_kernel_addr(0xf000b380, "SH_COMM_PMAddrConvert");
	add_ce_kernel_addr(0xf000aff8, "SH_FILESYS_APIS_CreateDirectoryW");
	add_ce_kernel_addr(0xf000aff4, "SH_FILESYS_APIS_RemoveDirectoryW");
	add_ce_kernel_addr(0xf000aff0, "SH_FILESYS_APIS_MoveFileW");
	add_ce_kernel_addr(0xf000afec, "SH_FILESYS_APIS_CopyFileW");
	add_ce_kernel_addr(0xf000afe8, "SH_FILESYS_APIS_DeleteFileW");
	add_ce_kernel_addr(0xf000afe4, "SH_FILESYS_APIS_GetFileAttributesW");
	add_ce_kernel_addr(0xf000afe0, "SH_FILESYS_APIS_FindFirstFileW");
	add_ce_kernel_addr(0xf000afdc, "SH_FILESYS_APIS_CreateFileW");
	add_ce_kernel_addr(0xf000afd8, "SH_FILESYS_APIS_CeRegisterFileSystemNotification");
	add_ce_kernel_addr(0xf000afd4, "SH_FILESYS_APIS_CeRegisterReplNotification");
	add_ce_kernel_addr(0xf000afd0, "SH_FILESYS_APIS_CeOidGetInfoEx2");
	add_ce_kernel_addr(0xf000afcc, "SH_FILESYS_APIS_CeFindFirstDatabaseEx");
	add_ce_kernel_addr(0xf000afc8, "SH_FILESYS_APIS_CeCreateDatabaseEx2");
	add_ce_kernel_addr(0xf000afc4, "SH_FILESYS_APIS_CeSetDatabaseInfoEx2");
	add_ce_kernel_addr(0xf000afc0, "SH_FILESYS_APIS_CeOpenDatabaseEx2");
	add_ce_kernel_addr(0xf000afbc, "SH_FILESYS_APIS_RegCloseKey");
	add_ce_kernel_addr(0xf000afb8, "SH_FILESYS_APIS_RegCreateKeyExW");
	add_ce_kernel_addr(0xf000afb4, "SH_FILESYS_APIS_RegDeleteKeyW");
	add_ce_kernel_addr(0xf000afb0, "SH_FILESYS_APIS_RegDeleteValueW");
	add_ce_kernel_addr(0xf000afac, "SH_FILESYS_APIS_RegEnumValueW");
	add_ce_kernel_addr(0xf000afa8, "SH_FILESYS_APIS_RegEnumKeyExW");
	add_ce_kernel_addr(0xf000afa4, "SH_FILESYS_APIS_RegOpenKeyExW");
	add_ce_kernel_addr(0xf000afa0, "SH_FILESYS_APIS_RegQueryInfoKeyW");
	add_ce_kernel_addr(0xf000af9c, "SH_FILESYS_APIS_RegQueryValueExW");
	add_ce_kernel_addr(0xf000af98, "SH_FILESYS_APIS_RegSetValueExW");
	add_ce_kernel_addr(0xf000af94, "SH_FILESYS_APIS_GetTempPathW");
	add_ce_kernel_addr(0xf000af90, "SH_FILESYS_APIS_CeDeleteDatabaseEx");
	add_ce_kernel_addr(0xf000af8c, "SH_FILESYS_APIS_CheckPassword");
	add_ce_kernel_addr(0xf000af88, "SH_FILESYS_APIS_SetPassword");
	add_ce_kernel_addr(0xf000af84, "SH_FILESYS_APIS_SetFileAttributesW");
	add_ce_kernel_addr(0xf000af80, "SH_FILESYS_APIS_GetStoreInformation");
	add_ce_kernel_addr(0xf000af7c, "SH_FILESYS_APIS_CeGetReplChangeMask");
	add_ce_kernel_addr(0xf000af78, "SH_FILESYS_APIS_CeSetReplChangeMask");
	add_ce_kernel_addr(0xf000af74, "SH_FILESYS_APIS_CeGetReplChangeBitsEx");
	add_ce_kernel_addr(0xf000af70, "SH_FILESYS_APIS_CeClearReplChangeBitsEx");
	add_ce_kernel_addr(0xf000af6c, "SH_FILESYS_APIS_CeGetReplOtherBitsEx");
	add_ce_kernel_addr(0xf000af68, "SH_FILESYS_APIS_CeSetReplOtherBitsEx");
	add_ce_kernel_addr(0xf000af64, "SH_FILESYS_APIS_GetSystemMemoryDivision");
	add_ce_kernel_addr(0xf000af60, "SH_FILESYS_APIS_SetSystemMemoryDivision");
	add_ce_kernel_addr(0xf000af5c, "SH_FILESYS_APIS_RegCopyFile");
	add_ce_kernel_addr(0xf000af58, "SH_FILESYS_APIS_CloseAllFileHandles");
	add_ce_kernel_addr(0xf000af54, "SH_FILESYS_APIS_DeleteAndRenameFile");
	add_ce_kernel_addr(0xf000af50, "SH_FILESYS_APIS_RegRestoreFile");
	add_ce_kernel_addr(0xf000af4c, "SH_FILESYS_APIS_RegisterAFSEx");
	add_ce_kernel_addr(0xf000af48, "SH_FILESYS_APIS_DeregisterAFS");
	add_ce_kernel_addr(0xf000af44, "SH_FILESYS_APIS_GetPasswordActive");
	add_ce_kernel_addr(0xf000af40, "SH_FILESYS_APIS_SetPasswordActive");
	add_ce_kernel_addr(0xf000af3c, "SH_FILESYS_APIS_RegFlushKey");
	add_ce_kernel_addr(0xf000af38, "SH_FILESYS_APIS_FileSystemPowerFunction");
	add_ce_kernel_addr(0xf000af34, "SH_FILESYS_APIS_CeSetReplChangeBitsEx");
	add_ce_kernel_addr(0xf000af30, "SH_FILESYS_APIS_RegisterAFSName");
	add_ce_kernel_addr(0xf000af2c, "SH_FILESYS_APIS_DeregisterAFSName");
	add_ce_kernel_addr(0xf000af28, "SH_FILESYS_APIS_GetDiskFreeSpaceExW");
	add_ce_kernel_addr(0xf000af24, "SH_FILESYS_APIS_IsSystemFile");
	add_ce_kernel_addr(0xf000af20, "SH_FILESYS_APIS_CeChangeDatabaseLCID");
	add_ce_kernel_addr(0xf000af1c, "SH_FILESYS_APIS_DumpFileSystemHeap");
	add_ce_kernel_addr(0xf000af18, "SH_FILESYS_APIS_CeMountDBVol");
	add_ce_kernel_addr(0xf000af14, "SH_FILESYS_APIS_CeEnumDBVolumes");
	add_ce_kernel_addr(0xf000af10, "SH_FILESYS_APIS_CeUnmountDBVol");
	add_ce_kernel_addr(0xf000af0c, "SH_FILESYS_APIS_CeFlushDBVol");
	add_ce_kernel_addr(0xf000af08, "SH_FILESYS_APIS_CeFreeNotification");
	add_ce_kernel_addr(0xf000af04, "SH_FILESYS_APIS_FindFirstFileExW");
	add_ce_kernel_addr(0xf000af00, "SH_FILESYS_APIS_RegSaveKey");
	add_ce_kernel_addr(0xf000aefc, "SH_FILESYS_APIS_RegReplaceKey");
	add_ce_kernel_addr(0xf000aef8, "SH_FILESYS_APIS_SignalStarted");
	add_ce_kernel_addr(0xf000aef4, "SH_FILESYS_APIS_SetCurrentUser");
	add_ce_kernel_addr(0xf000aef0, "SH_FILESYS_APIS_SetUserData");
	add_ce_kernel_addr(0xf000aeec, "SH_FILESYS_APIS_GetUserInformation");
	add_ce_kernel_addr(0xf000aee8, "SH_FILESYS_APIS_SetPasswordStatus");
	add_ce_kernel_addr(0xf000aee4, "SH_FILESYS_APIS_GetPasswordStatus");
	add_ce_kernel_addr(0xf000aee0, "SH_FILESYS_APIS_ReplOpenSync");
	add_ce_kernel_addr(0xf000aedc, "SH_FILESYS_APIS_ReplCheckpoint");
	add_ce_kernel_addr(0xf000aed8, "SH_FILESYS_APIS_ReplCloseSync");
	add_ce_kernel_addr(0xf000aed4, "SH_FILESYS_APIS_ReplGetSyncState");
	add_ce_kernel_addr(0xf000aed0, "SH_FILESYS_APIS_ReplChangeSyncSettings");
	add_ce_kernel_addr(0xf000aecc, "SH_FILESYS_APIS_ReplFindNextChange");
	add_ce_kernel_addr(0xf000aec8, "SH_FILESYS_APIS_ReplGetOidStatus");
	add_ce_kernel_addr(0xf000aec4, "SH_FILESYS_APIS_CreateMsgQueue");
	add_ce_kernel_addr(0xf000aec0, "SH_FILESYS_APIS_OpenMsgQueue");
	add_ce_kernel_addr(0xf000aebc, "SH_FILESYS_APIS_ReadMsgQueue");
	add_ce_kernel_addr(0xf000aeb8, "SH_FILESYS_APIS_WriteMsgQueue");
	add_ce_kernel_addr(0xf000aeb4, "SH_FILESYS_APIS_GetMsgQueueInfo");
	add_ce_kernel_addr(0xf000aeb0, "SH_FILESYS_APIS_CloseMsgQueue");
	add_ce_kernel_addr(0xf000aeac, "SH_FILESYS_APIS_CryptProtectData");
	add_ce_kernel_addr(0xf000aea8, "SH_FILESYS_APIS_CryptUnprotectData");
	add_ce_kernel_addr(0xf000aea4, "SH_FILESYS_APIS_GenRandom");
	add_ce_kernel_addr(0xf000aea0, "SH_FILESYS_APIS_FindFirstChangeNotificationW");
	add_ce_kernel_addr(0xf000ae9c, "SH_FILESYS_APIS_FindNextChangeNotification");
	add_ce_kernel_addr(0xf000ae98, "SH_FILESYS_APIS_FindCloseChangeNotification");
	add_ce_kernel_addr(0xf000ae94, "SH_FILESYS_APIS_CeGetFileNotificationInfo");
	add_ce_kernel_addr(0xf000abf4, "SH_SHELL_GetOpenFileNameW");
	add_ce_kernel_addr(0xf000abf0, "SH_SHELL_GetSaveFileNameW");
	add_ce_kernel_addr(0xf000abe8, "SH_SHELL_Shell_NotifyIcon");
	add_ce_kernel_addr(0xf000abe4, "SH_SHELL_SHAddToRecentDocs");
	add_ce_kernel_addr(0xf000abdc, "SH_SHELL_SHCreateExplorerInstance");
	add_ce_kernel_addr(0xf000ab94, "SH_SHELL_NotSystemParametersInfo_Trap");
	add_ce_kernel_addr(0xf000ab90, "SH_SHELL_SHGetAppKeyAssoc_Trap");
	add_ce_kernel_addr(0xf000ab8c, "SH_SHELL_SHSetAppKeyWndAssoc_Trap");
	add_ce_kernel_addr(0xf000ab78, "SH_SHELL_SHFileNotifyRemove_Trap");
	add_ce_kernel_addr(0xf000ab74, "SH_SHELL_SHFileNotifyFree_Trap");
	add_ce_kernel_addr(0xf000ab6c, "SH_SHELL_SHCloseApps_Trap");
	add_ce_kernel_addr(0xf000ab68, "SH_SHELL_SHSipPreference_Trap");
	add_ce_kernel_addr(0xf000ab5c, "SH_SHELL_SHSetNavBarText_Trap");
	add_ce_kernel_addr(0xf000ab58, "SH_SHELL_SHDoneButton_Trap");
	add_ce_kernel_addr(0xf000ab38, "SH_SHELL_SHChangeNotifyRegister_Trap");
	add_ce_kernel_addr(0xf000ab24, "SH_SHELL_SHNotificationAdd_Trap");
	add_ce_kernel_addr(0xf000ab20, "SH_SHELL_SHNotificationUpdate_Trap");
	add_ce_kernel_addr(0xf000ab1c, "SH_SHELL_SHNotificationRemove_Trap");
	add_ce_kernel_addr(0xf000ab18, "SH_SHELL_SHNotificationGetData_Trap");
	add_ce_kernel_addr(0xf000aadc, "SH_SHELL_SendChangeNotificationToWindow_Trap");
	add_ce_kernel_addr(0xf000a7f8, "SH_DEVMGR_APIS_RegisterDevice");
	add_ce_kernel_addr(0xf000a7f4, "SH_DEVMGR_APIS_DeregisterDevice");
	add_ce_kernel_addr(0xf000a7f0, "SH_DEVMGR_APIS_CloseAllDeviceHandles");
	add_ce_kernel_addr(0xf000a7ec, "SH_DEVMGR_APIS_CreateDeviceHandle");
	add_ce_kernel_addr(0xf000a7e8, "SH_DEVMGR_APIS_LoadFSD");
	add_ce_kernel_addr(0xf000a7e0, "SH_DEVMGR_APIS_DeactivateDevice");
	add_ce_kernel_addr(0xf000a7dc, "SH_DEVMGR_APIS_LoadFSDEx");
	add_ce_kernel_addr(0xf000a7d8, "SH_DEVMGR_APIS_GetDeviceByIndex");
	add_ce_kernel_addr(0xf000a7d4, "SH_DEVMGR_APIS_CeResyncFilesys");
	add_ce_kernel_addr(0xf000a7d0, "SH_DEVMGR_APIS_ActivateDeviceEx");
	add_ce_kernel_addr(0xf000a7cc, "SH_DEVMGR_APIS_RequestDeviceNotifications");
	add_ce_kernel_addr(0xf000a7c8, "SH_DEVMGR_APIS_StopDeviceNotifications");
	add_ce_kernel_addr(0xf000a7c4, "SH_DEVMGR_APIS__GetDevicePathFromPnp");
	add_ce_kernel_addr(0xf000a7c0, "SH_DEVMGR_APIS_ResourceCreateList");
	add_ce_kernel_addr(0xf000a7bc, "SH_DEVMGR_APIS_ResourceAdjust");
	add_ce_kernel_addr(0xf000a7b8, "SH_DEVMGR_APIS_GetSystemPowerState");
	add_ce_kernel_addr(0xf000a7b4, "SH_DEVMGR_APIS_SetSystemPowerState");
	add_ce_kernel_addr(0xf000a7b0, "SH_DEVMGR_APIS_SetPowerRequirement");
	add_ce_kernel_addr(0xf000a7ac, "SH_DEVMGR_APIS_ReleasePowerRequirement");
	add_ce_kernel_addr(0xf000a7a8, "SH_DEVMGR_APIS_RequestPowerNotifications");
	add_ce_kernel_addr(0xf000a7a4, "SH_DEVMGR_APIS_StopPowerNotifications");
	add_ce_kernel_addr(0xf000a79c, "SH_DEVMGR_APIS_DevicePowerNotify");
	add_ce_kernel_addr(0xf000a798, "SH_DEVMGR_APIS_RegisterPowerRelationship");
	add_ce_kernel_addr(0xf000a794, "SH_DEVMGR_APIS_ReleasePowerRelationship");
	add_ce_kernel_addr(0xf000a790, "SH_DEVMGR_APIS_SetDevicePower");
	add_ce_kernel_addr(0xf000a78c, "SH_DEVMGR_APIS_GetDevicePower");
	add_ce_kernel_addr(0xf000a788, "SH_DEVMGR_APIS_AdvertiseInterface");
	add_ce_kernel_addr(0xf000a3f8, "SH_TAPI_lineClose");
	add_ce_kernel_addr(0xf000a3f4, "SH_TAPI_lineConfigDialogEdit");
	add_ce_kernel_addr(0xf000a3f0, "SH_TAPI_lineDeallocateCall");
	add_ce_kernel_addr(0xf000a3ec, "SH_TAPI_lineDrop");
	add_ce_kernel_addr(0xf000a3e8, "SH_TAPI_lineGetDevCaps");
	add_ce_kernel_addr(0xf000a3e4, "SH_TAPI_lineGetDevConfig");
	add_ce_kernel_addr(0xf000a3e0, "SH_TAPI_lineGetTranslateCaps");
	add_ce_kernel_addr(0xf000a3dc, "SH_TAPI_TAPIlineInitialize");
	add_ce_kernel_addr(0xf000a3d8, "SH_TAPI_lineMakeCall");
	add_ce_kernel_addr(0xf000a3d4, "SH_TAPI_lineNegotiateAPIVersion");
	add_ce_kernel_addr(0xf000a3d0, "SH_TAPI_lineOpen");
	add_ce_kernel_addr(0xf000a3cc, "SH_TAPI_lineSetDevConfig");
	add_ce_kernel_addr(0xf000a3c8, "SH_TAPI_lineSetStatusMessages");
	add_ce_kernel_addr(0xf000a3c4, "SH_TAPI_TAPIlineShutdown");
	add_ce_kernel_addr(0xf000a3c0, "SH_TAPI_lineTranslateAddress");
	add_ce_kernel_addr(0xf000a3bc, "SH_TAPI_lineTranslateDialog");
	add_ce_kernel_addr(0xf000a3b8, "SH_TAPI_lineGetID");
	add_ce_kernel_addr(0xf000a3b4, "SH_TAPI_lineAddProvider");
	add_ce_kernel_addr(0xf000a3b0, "SH_TAPI_lineSetCurrentLocation");
	add_ce_kernel_addr(0xf000a3ac, "SH_TAPI_lineAccept");
	add_ce_kernel_addr(0xf000a3a8, "SH_TAPI_lineAddToConference");
	add_ce_kernel_addr(0xf000a3a4, "SH_TAPI_lineAnswer");
	add_ce_kernel_addr(0xf000a3a0, "SH_TAPI_lineBlindTransfer");
	add_ce_kernel_addr(0xf000a39c, "SH_TAPI_lineCompleteTransfer");
	add_ce_kernel_addr(0xf000a398, "SH_TAPI_lineDevSpecific");
	add_ce_kernel_addr(0xf000a394, "SH_TAPI_lineDial");
	add_ce_kernel_addr(0xf000a390, "SH_TAPI_lineForward");
	add_ce_kernel_addr(0xf000a38c, "SH_TAPI_lineGenerateDigits");
	add_ce_kernel_addr(0xf000a388, "SH_TAPI_lineGenerateTone");
	add_ce_kernel_addr(0xf000a384, "SH_TAPI_lineGetAddressCaps");
	add_ce_kernel_addr(0xf000a380, "SH_TAPI_lineGetAddressID");
	add_ce_kernel_addr(0xf000a37c, "SH_TAPI_lineGetAddressStatus");
	add_ce_kernel_addr(0xf000a378, "SH_TAPI_lineGetAppPriority");
	add_ce_kernel_addr(0xf000a374, "SH_TAPI_lineGetCallInfo");
	add_ce_kernel_addr(0xf000a370, "SH_TAPI_lineGetCallStatus");
	add_ce_kernel_addr(0xf000a36c, "SH_TAPI_lineGetConfRelatedCalls");
	add_ce_kernel_addr(0xf000a368, "SH_TAPI_lineGetIcon");
	add_ce_kernel_addr(0xf000a364, "SH_TAPI_lineGetLineDevStatus");
	add_ce_kernel_addr(0xf000a360, "SH_TAPI_lineGetMessage");
	add_ce_kernel_addr(0xf000a35c, "SH_TAPI_lineGetNewCalls");
	add_ce_kernel_addr(0xf000a358, "SH_TAPI_lineGetNumRings");
	add_ce_kernel_addr(0xf000a354, "SH_TAPI_lineGetProviderList");
	add_ce_kernel_addr(0xf000a350, "SH_TAPI_lineGetStatusMessages");
	add_ce_kernel_addr(0xf000a34c, "SH_TAPI_lineHandoff");
	add_ce_kernel_addr(0xf000a348, "SH_TAPI_lineHold");
	add_ce_kernel_addr(0xf000a344, "SH_TAPI_TAPIlineInitializeEx");
	add_ce_kernel_addr(0xf000a340, "SH_TAPI_lineMonitorDigits");
	add_ce_kernel_addr(0xf000a33c, "SH_TAPI_lineMonitorMedia");
	add_ce_kernel_addr(0xf000a338, "SH_TAPI_lineNegotiateExtVersion");
	add_ce_kernel_addr(0xf000a334, "SH_TAPI_linePickup");
	add_ce_kernel_addr(0xf000a330, "SH_TAPI_linePrepareAddToConference");
	add_ce_kernel_addr(0xf000a32c, "SH_TAPI_lineRedirect");
	add_ce_kernel_addr(0xf000a328, "SH_TAPI_lineReleaseUserUserInfo");
	add_ce_kernel_addr(0xf000a324, "SH_TAPI_lineRemoveFromConference");
	add_ce_kernel_addr(0xf000a320, "SH_TAPI_lineSendUserUserInfo");
	add_ce_kernel_addr(0xf000a31c, "SH_TAPI_lineSetAppPriority");
	add_ce_kernel_addr(0xf000a318, "SH_TAPI_lineSetCallParams");
	add_ce_kernel_addr(0xf000a314, "SH_TAPI_lineSetCallPrivilege");
	add_ce_kernel_addr(0xf000a310, "SH_TAPI_lineSetMediaMode");
	add_ce_kernel_addr(0xf000a30c, "SH_TAPI_lineSetNumRings");
	add_ce_kernel_addr(0xf000a308, "SH_TAPI_lineSetTerminal");
	add_ce_kernel_addr(0xf000a304, "SH_TAPI_lineSetTollList");
	add_ce_kernel_addr(0xf000a300, "SH_TAPI_lineSetupConference");
	add_ce_kernel_addr(0xf000a2fc, "SH_TAPI_lineSetupTransfer");
	add_ce_kernel_addr(0xf000a2f8, "SH_TAPI_lineSwapHold");
	add_ce_kernel_addr(0xf000a2f4, "SH_TAPI_lineUnhold");
	add_ce_kernel_addr(0xf000a2f0, "SH_TAPI_phoneClose");
	add_ce_kernel_addr(0xf000a2ec, "SH_TAPI_phoneConfigDialog");
	add_ce_kernel_addr(0xf000a2e8, "SH_TAPI_phoneDevSpecific");
	add_ce_kernel_addr(0xf000a2e4, "SH_TAPI_phoneGetDevCaps");
	add_ce_kernel_addr(0xf000a2e0, "SH_TAPI_phoneGetGain");
	add_ce_kernel_addr(0xf000a2dc, "SH_TAPI_phoneGetHookSwitch");
	add_ce_kernel_addr(0xf000a2d8, "SH_TAPI_phoneGetIcon");
	add_ce_kernel_addr(0xf000a2d4, "SH_TAPI_phoneGetID");
	add_ce_kernel_addr(0xf000a2d0, "SH_TAPI_phoneGetMessage");
	add_ce_kernel_addr(0xf000a2cc, "SH_TAPI_phoneGetRing");
	add_ce_kernel_addr(0xf000a2c8, "SH_TAPI_phoneGetStatus");
	add_ce_kernel_addr(0xf000a2c4, "SH_TAPI_phoneGetStatusMessages");
	add_ce_kernel_addr(0xf000a2c0, "SH_TAPI_phoneGetVolume");
	add_ce_kernel_addr(0xf000a2bc, "SH_TAPI_TAPIphoneInitializeEx");
	add_ce_kernel_addr(0xf000a2b8, "SH_TAPI_phoneNegotiateAPIVersion");
	add_ce_kernel_addr(0xf000a2b4, "SH_TAPI_phoneNegotiateExtVersion");
	add_ce_kernel_addr(0xf000a2b0, "SH_TAPI_phoneOpen");
	add_ce_kernel_addr(0xf000a2ac, "SH_TAPI_phoneSetGain");
	add_ce_kernel_addr(0xf000a2a8, "SH_TAPI_phoneSetHookSwitch");
	add_ce_kernel_addr(0xf000a2a4, "SH_TAPI_phoneSetRing");
	add_ce_kernel_addr(0xf000a2a0, "SH_TAPI_phoneSetStatusMessages");
	add_ce_kernel_addr(0xf000a29c, "SH_TAPI_phoneSetVolume");
	add_ce_kernel_addr(0xf000a298, "SH_TAPI_TAPIphoneShutdown");
	add_ce_kernel_addr(0xf0009ff8, "SH_PATCHER_PatchExe");
	add_ce_kernel_addr(0xf0009ff4, "SH_PATCHER_PatchDll");
	add_ce_kernel_addr(0xf0009ff0, "SH_PATCHER_FreeDllPatch");
	add_ce_kernel_addr(0xf00097f8, "SH_SERVICES_ActivateService");
	add_ce_kernel_addr(0xf00097f4, "SH_SERVICES_RegisterService");
	add_ce_kernel_addr(0xf00097f0, "SH_SERVICES_DeregisterService");
	add_ce_kernel_addr(0xf00097ec, "SH_SERVICES_CloseAllServiceHandles");
	add_ce_kernel_addr(0xf00097e8, "SH_SERVICES_CreateServiceHandle");
	add_ce_kernel_addr(0xf00097e4, "SH_SERVICES_GetServiceByIndex");
	add_ce_kernel_addr(0xf00097e0, "SH_SERVICES_ServiceIoControl");
	add_ce_kernel_addr(0xf00097dc, "SH_SERVICES_ServiceAddPort");
	add_ce_kernel_addr(0xf00097d8, "SH_SERVICES_ServiceUnbindPorts");
	add_ce_kernel_addr(0xf00097d4, "SH_SERVICES_EnumServices");
	add_ce_kernel_addr(0xf00097d0, "SH_SERVICES_GetServiceHandle");
	add_ce_kernel_addr(0xf00097cc, "SH_SERVICES_ServiceClosePort");
}

void arm7_cpu_device::print_ce_kernel_address(const offs_t addr)
{
	if (addr < 0x10400 && m_ce_kernel_addr_present[addr])
	{
		printf("Kernel Call: %s\n", m_ce_kernel_addrs[addr].c_str());
	}
	else if (addr == 0xFFFFCB80)
		printf("Kernel Call: InterlockedPopList\n");
	else if (addr == 0xFFFFCB98)
		printf("Kernel Call: InterlockedPushList\n");
	else if (addr == 0xFFFFCBAC)
		printf("Kernel Call: InterlockedCompareExchange\n");
	else if (addr == 0xFFFFCBC0)
		printf("Kernel Call: InterlockedExchangeAdd\n");
	else if (addr == 0xFFFFCBD4)
		printf("Kernel Call: InterlockedExchange\n");
}
