//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armstoragesync_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/storagesync/armstoragesync"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/storagesync/resource-manager/Microsoft.StorageSync/stable/2020-09-01/examples/StorageSyncServiceCheckNameAvailability_AlreadyExists.json
func ExampleServicesClient_CheckNameAvailability_storageSyncServiceCheckNameAvailabilityAlreadyExists() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstoragesync.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewServicesClient().CheckNameAvailability(ctx, "westus", armstoragesync.CheckNameAvailabilityParameters{
		Name: to.Ptr("newstoragesyncservicename"),
		Type: to.Ptr("Microsoft.StorageSync/storageSyncServices"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CheckNameAvailabilityResult = armstoragesync.CheckNameAvailabilityResult{
	// 	Message: to.Ptr("An account named 'newstoragesyncservicename' is already in use."),
	// 	NameAvailable: to.Ptr(false),
	// 	Reason: to.Ptr(armstoragesync.NameAvailabilityReasonAlreadyExists),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/storagesync/resource-manager/Microsoft.StorageSync/stable/2020-09-01/examples/StorageSyncServiceCheckNameAvailability_Available.json
func ExampleServicesClient_CheckNameAvailability_storageSyncServiceCheckNameAvailabilityAvailable() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstoragesync.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewServicesClient().CheckNameAvailability(ctx, "westus", armstoragesync.CheckNameAvailabilityParameters{
		Name: to.Ptr("newstoragesyncservicename"),
		Type: to.Ptr("Microsoft.StorageSync/storageSyncServices"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CheckNameAvailabilityResult = armstoragesync.CheckNameAvailabilityResult{
	// 	NameAvailable: to.Ptr(true),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/storagesync/resource-manager/Microsoft.StorageSync/stable/2020-09-01/examples/StorageSyncServices_Create.json
func ExampleServicesClient_BeginCreate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstoragesync.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewServicesClient().BeginCreate(ctx, "SampleResourceGroup_1", "SampleStorageSyncService_1", armstoragesync.ServiceCreateParameters{
		Location: to.Ptr("WestUS"),
		Properties: &armstoragesync.ServiceCreateParametersProperties{
			IncomingTrafficPolicy: to.Ptr(armstoragesync.IncomingTrafficPolicyAllowAllTraffic),
		},
		Tags: map[string]*string{},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Service = armstoragesync.Service{
	// 	Name: to.Ptr("SampleStorageSyncService_1"),
	// 	Type: to.Ptr("Microsoft.StorageSync/storageSyncServices"),
	// 	ID: to.Ptr("/subscriptions/3a048283-338f-4002-a9dd-a50fdadcb392/resourceGroups/SampleResourceGroup_1/providers/Microsoft.StorageSync/storageSyncServices/SampleStorageSyncService_1"),
	// 	Location: to.Ptr("WestUS"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Properties: &armstoragesync.ServiceProperties{
	// 		IncomingTrafficPolicy: to.Ptr(armstoragesync.IncomingTrafficPolicyAllowAllTraffic),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/storagesync/resource-manager/Microsoft.StorageSync/stable/2020-09-01/examples/StorageSyncServices_Get.json
func ExampleServicesClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstoragesync.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewServicesClient().Get(ctx, "SampleResourceGroup_1", "SampleStorageSyncService_1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Service = armstoragesync.Service{
	// 	Name: to.Ptr("SampleStorageSyncService_1"),
	// 	Type: to.Ptr("Microsoft.StorageSync/storageSyncServices"),
	// 	ID: to.Ptr("/subscriptions/3a048283-338f-4002-a9dd-a50fdadcb392/resourceGroups/SampleResourceGroup_1/providers/Microsoft.StorageSync/storageSyncServices/SampleStorageSyncService_1"),
	// 	Location: to.Ptr("WestUS"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Properties: &armstoragesync.ServiceProperties{
	// 		IncomingTrafficPolicy: to.Ptr(armstoragesync.IncomingTrafficPolicyAllowAllTraffic),
	// 		PrivateEndpointConnections: []*armstoragesync.PrivateEndpointConnection{
	// 			{
	// 				ID: to.Ptr("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageSync/{resource}/{resourceName}/privateEndpointConnections/SampleStorageSyncService_1.cd99f12ba6f3483f9292229e4f822258"),
	// 				Properties: &armstoragesync.PrivateEndpointConnectionProperties{
	// 					PrivateEndpoint: &armstoragesync.PrivateEndpoint{
	// 						ID: to.Ptr("subscriptions/52b8da2f-61e0-4a1f-8dde-336911f367fb/resourceGroups/SampleResourceGroup_2/providers/Microsoft.Network/privateEndpoints/testpe01"),
	// 					},
	// 					PrivateLinkServiceConnectionState: &armstoragesync.PrivateLinkServiceConnectionState{
	// 						Description: to.Ptr("Please approve my request, thanks."),
	// 						Status: to.Ptr(armstoragesync.PrivateEndpointServiceConnectionStatusPending),
	// 					},
	// 				},
	// 		}},
	// 		StorageSyncServiceStatus: to.Ptr[int32](0),
	// 		StorageSyncServiceUID: to.Ptr("\"2de01144-72da-4d7f-9d0c-e858855114a8\""),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/storagesync/resource-manager/Microsoft.StorageSync/stable/2020-09-01/examples/StorageSyncServices_Update.json
func ExampleServicesClient_BeginUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstoragesync.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewServicesClient().BeginUpdate(ctx, "SampleResourceGroup_1", "SampleStorageSyncService_1", &armstoragesync.ServicesClientBeginUpdateOptions{Parameters: &armstoragesync.ServiceUpdateParameters{
		Properties: &armstoragesync.ServiceUpdateProperties{
			IncomingTrafficPolicy: to.Ptr(armstoragesync.IncomingTrafficPolicyAllowAllTraffic),
		},
		Tags: map[string]*string{
			"Dept":        to.Ptr("IT"),
			"Environment": to.Ptr("Test"),
		},
	},
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Service = armstoragesync.Service{
	// 	Name: to.Ptr("SampleStorageSyncService_1"),
	// 	Type: to.Ptr("Microsoft.StorageSync/storageSyncServices"),
	// 	ID: to.Ptr("/subscriptions/3a048283-338f-4002-a9dd-a50fdadcb392/resourceGroups/SampleResourceGroup_1/providers/Microsoft.StorageSync/storageSyncServices/SampleStorageSyncService_1"),
	// 	Location: to.Ptr("WestUS"),
	// 	Tags: map[string]*string{
	// 		"Dept": to.Ptr("IT"),
	// 		"Environment": to.Ptr("Test"),
	// 	},
	// 	Properties: &armstoragesync.ServiceProperties{
	// 		IncomingTrafficPolicy: to.Ptr(armstoragesync.IncomingTrafficPolicyAllowAllTraffic),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/storagesync/resource-manager/Microsoft.StorageSync/stable/2020-09-01/examples/StorageSyncServices_Delete.json
func ExampleServicesClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstoragesync.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewServicesClient().BeginDelete(ctx, "SampleResourceGroup_1", "SampleStorageSyncService_1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/storagesync/resource-manager/Microsoft.StorageSync/stable/2020-09-01/examples/StorageSyncServices_ListByResourceGroup.json
func ExampleServicesClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstoragesync.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewServicesClient().NewListByResourceGroupPager("SampleResourceGroup_1", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ServiceArray = armstoragesync.ServiceArray{
		// 	Value: []*armstoragesync.Service{
		// 		{
		// 			Name: to.Ptr("SampleStorageSyncService_1"),
		// 			Type: to.Ptr("Microsoft.StorageSync/storageSyncServices"),
		// 			ID: to.Ptr("/subscriptions/3a048283-338f-4002-a9dd-a50fdadcb392/resourceGroups/SampleResourceGroup_1/providers/Microsoft.StorageSync/storageSyncServices/SampleStorageSyncService_1"),
		// 			Location: to.Ptr("WestUS"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Properties: &armstoragesync.ServiceProperties{
		// 				IncomingTrafficPolicy: to.Ptr(armstoragesync.IncomingTrafficPolicyAllowAllTraffic),
		// 				StorageSyncServiceStatus: to.Ptr[int32](0),
		// 				StorageSyncServiceUID: to.Ptr("\"3d1bf292-0f2a-4cc1-a3e1-60f35800e40c\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("SampleStorageSyncService_2"),
		// 			Type: to.Ptr("Microsoft.StorageSync/storageSyncServices"),
		// 			ID: to.Ptr("/subscriptions/3a048283-338f-4002-a9dd-a50fdadcb392/resourceGroups/SampleResourceGroup_1/providers/Microsoft.StorageSync/storageSyncServices/SampleStorageSyncService_2"),
		// 			Location: to.Ptr("WestUS"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Properties: &armstoragesync.ServiceProperties{
		// 				IncomingTrafficPolicy: to.Ptr(armstoragesync.IncomingTrafficPolicyAllowAllTraffic),
		// 				StorageSyncServiceStatus: to.Ptr[int32](0),
		// 				StorageSyncServiceUID: to.Ptr("\"2de01144-72da-4d7f-9d0c-e858855114a8\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("SampleStorageSyncService_3"),
		// 			Type: to.Ptr("Microsoft.StorageSync/storageSyncServices"),
		// 			ID: to.Ptr("/subscriptions/3a048283-338f-4002-a9dd-a50fdadcb392/resourceGroups/SampleResourceGroup_1/providers/Microsoft.StorageSync/storageSyncServices/SampleStorageSyncService_3"),
		// 			Location: to.Ptr("WestUS"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Properties: &armstoragesync.ServiceProperties{
		// 				IncomingTrafficPolicy: to.Ptr(armstoragesync.IncomingTrafficPolicyAllowAllTraffic),
		// 				StorageSyncServiceStatus: to.Ptr[int32](0),
		// 				StorageSyncServiceUID: to.Ptr("\"b2c58ee5-933e-462c-8a9e-b30f2bdd8fa3\""),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/storagesync/resource-manager/Microsoft.StorageSync/stable/2020-09-01/examples/StorageSyncServices_ListBySubscription.json
func ExampleServicesClient_NewListBySubscriptionPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstoragesync.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewServicesClient().NewListBySubscriptionPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ServiceArray = armstoragesync.ServiceArray{
		// 	Value: []*armstoragesync.Service{
		// 		{
		// 			Name: to.Ptr("SampleStorageSyncService_1"),
		// 			Type: to.Ptr("Microsoft.StorageSync/storageSyncServices"),
		// 			ID: to.Ptr("/subscriptions/3a048283-338f-4002-a9dd-a50fdadcb392/resourceGroups/SampleResourceGroup_1/providers/Microsoft.StorageSync/storageSyncServices/SampleStorageSyncService_1"),
		// 			Location: to.Ptr("WestUS"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Properties: &armstoragesync.ServiceProperties{
		// 				IncomingTrafficPolicy: to.Ptr(armstoragesync.IncomingTrafficPolicyAllowAllTraffic),
		// 				StorageSyncServiceStatus: to.Ptr[int32](0),
		// 				StorageSyncServiceUID: to.Ptr("\"3d1bf292-0f2a-4cc1-a3e1-60f35800e40c\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("SampleStorageSyncService_2"),
		// 			Type: to.Ptr("Microsoft.StorageSync/storageSyncServices"),
		// 			ID: to.Ptr("/subscriptions/3a048283-338f-4002-a9dd-a50fdadcb392/resourceGroups/SampleResourceGroup_1/providers/Microsoft.StorageSync/storageSyncServices/SampleStorageSyncService_2"),
		// 			Location: to.Ptr("WestUS"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Properties: &armstoragesync.ServiceProperties{
		// 				IncomingTrafficPolicy: to.Ptr(armstoragesync.IncomingTrafficPolicyAllowAllTraffic),
		// 				StorageSyncServiceStatus: to.Ptr[int32](0),
		// 				StorageSyncServiceUID: to.Ptr("\"2de01144-72da-4d7f-9d0c-e858855114a8\""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("SampleStorageSyncService_3"),
		// 			Type: to.Ptr("Microsoft.StorageSync/storageSyncServices"),
		// 			ID: to.Ptr("/subscriptions/3a048283-338f-4002-a9dd-a50fdadcb392/resourceGroups/SampleResourceGroup_1/providers/Microsoft.StorageSync/storageSyncServices/SampleStorageSyncService_3"),
		// 			Location: to.Ptr("WestUS"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Properties: &armstoragesync.ServiceProperties{
		// 				IncomingTrafficPolicy: to.Ptr(armstoragesync.IncomingTrafficPolicyAllowAllTraffic),
		// 				StorageSyncServiceStatus: to.Ptr[int32](0),
		// 				StorageSyncServiceUID: to.Ptr("\"b2c58ee5-933e-462c-8a9e-b30f2bdd8fa3\""),
		// 			},
		// 	}},
		// }
	}
}
