//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armsql_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/sql/armsql/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c78b5d8bd3aff2d82a5f034d9164b1a9ac030e09/specification/sql/resource-manager/Microsoft.Sql/preview/2022-11-01-preview/examples/DatabaseSqlVulnerabilityAssessmentListScansResults.json
func ExampleDatabaseSQLVulnerabilityAssessmentScanResultClient_NewListByScanPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDatabaseSQLVulnerabilityAssessmentScanResultClient().NewListByScanPager("vulnerabilityassessmenttest-4711", "testsvr", "master", armsql.SQLVulnerabilityAssessmentNameDefault, "scanId1", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.VulnerabilityAssessmentScanListResult = armsql.VulnerabilityAssessmentScanListResult{
		// 	Value: []*armsql.VulnerabilityAssessmentScanResults{
		// 		{
		// 			Name: to.Ptr("VA1234"),
		// 			Type: to.Ptr("Microsoft.Sql/servers/databases/sqlVulnerabilityAssessments/scans/scanResults"),
		// 			ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/vulnerabilityassessmenttest-4711/providers/Microsoft.Sql/servers/testsvr/databases/master/sqlVulnerabilityAssessments/Default/scans/scanId1/scanResults/VA1234"),
		// 			Properties: &armsql.VulnerabilityAssessmentScanResultProperties{
		// 				IsTrimmed: to.Ptr(false),
		// 				QueryResults: [][]*string{
		// 					[]*string{
		// 						to.Ptr("a1"),
		// 						to.Ptr("a2"),
		// 						to.Ptr("a3")},
		// 						[]*string{
		// 							to.Ptr("b1"),
		// 							to.Ptr("b2"),
		// 							to.Ptr("b3")}},
		// 							Remediation: &armsql.Remediation{
		// 								Description: to.Ptr("Remove users"),
		// 								Automated: to.Ptr(false),
		// 								Scripts: []*string{
		// 									to.Ptr("drop user a"),
		// 									to.Ptr("drop user b")},
		// 								},
		// 								RuleID: to.Ptr("VA1234"),
		// 								RuleMetadata: &armsql.VaRule{
		// 									Description: to.Ptr("This is an example check"),
		// 									BenchmarkReferences: []*armsql.BenchmarkReference{
		// 										{
		// 											Benchmark: to.Ptr("fedramp"),
		// 											Reference: to.Ptr("v1"),
		// 									}},
		// 									Category: to.Ptr("information"),
		// 									QueryCheck: &armsql.QueryCheck{
		// 										ColumnNames: []*string{
		// 											to.Ptr("col1"),
		// 											to.Ptr("col2"),
		// 											to.Ptr("col3")},
		// 											ExpectedResult: [][]*string{
		// 											},
		// 											Query: to.Ptr("Select a1,a2, a3"),
		// 										},
		// 										Rationale: to.Ptr("This is important"),
		// 										RuleID: to.Ptr("VA1234"),
		// 										RuleType: to.Ptr(armsql.RuleTypeNegativeList),
		// 										Severity: to.Ptr(armsql.RuleSeverityInformational),
		// 										Title: to.Ptr("This is the title"),
		// 									},
		// 									Status: to.Ptr(armsql.RuleStatusNonFinding),
		// 								},
		// 							},
		// 							{
		// 								Name: to.Ptr("VA2341"),
		// 								Type: to.Ptr("Microsoft.Sql/servers/databases/sqlVulnerabilityAssessments/scans/scanResults"),
		// 								ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default-SQL-Onebox/providers/Microsoft.Sql/servers/testsvr/databases/master/sqlVulnerabilityAssessments/Default/scans/scanId1/scanResults/VA2341"),
		// 								Properties: &armsql.VulnerabilityAssessmentScanResultProperties{
		// 									IsTrimmed: to.Ptr(false),
		// 									QueryResults: [][]*string{
		// 										[]*string{
		// 											to.Ptr("a1"),
		// 											to.Ptr("a2"),
		// 											to.Ptr("a3")},
		// 											[]*string{
		// 												to.Ptr("b1"),
		// 												to.Ptr("b2"),
		// 												to.Ptr("b3")}},
		// 												Remediation: &armsql.Remediation{
		// 													Description: to.Ptr("Remove users"),
		// 													Automated: to.Ptr(false),
		// 													Scripts: []*string{
		// 														to.Ptr("drop user a"),
		// 														to.Ptr("drop user b")},
		// 													},
		// 													RuleID: to.Ptr("VA2341"),
		// 													RuleMetadata: &armsql.VaRule{
		// 														Description: to.Ptr("This is an example check"),
		// 														BenchmarkReferences: []*armsql.BenchmarkReference{
		// 															{
		// 																Benchmark: to.Ptr("fedramp"),
		// 																Reference: to.Ptr("v1"),
		// 														}},
		// 														Category: to.Ptr("information"),
		// 														QueryCheck: &armsql.QueryCheck{
		// 															ColumnNames: []*string{
		// 																to.Ptr("col1"),
		// 																to.Ptr("col2"),
		// 																to.Ptr("col3")},
		// 																ExpectedResult: [][]*string{
		// 																},
		// 																Query: to.Ptr("Select a1,a2, a3"),
		// 															},
		// 															Rationale: to.Ptr("This is important"),
		// 															RuleID: to.Ptr("VA1234"),
		// 															RuleType: to.Ptr(armsql.RuleTypeNegativeList),
		// 															Severity: to.Ptr(armsql.RuleSeverityInformational),
		// 															Title: to.Ptr("This is the title"),
		// 														},
		// 														Status: to.Ptr(armsql.RuleStatusNonFinding),
		// 													},
		// 											}},
		// 										}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c78b5d8bd3aff2d82a5f034d9164b1a9ac030e09/specification/sql/resource-manager/Microsoft.Sql/preview/2022-11-01-preview/examples/DatabaseSqlVulnerabilityAssessmentScansResults.json
func ExampleDatabaseSQLVulnerabilityAssessmentScanResultClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDatabaseSQLVulnerabilityAssessmentScanResultClient().Get(ctx, "vulnerabilityassessmenttest-4711", "vulnerabilityassessmenttest-6411", "master", armsql.SQLVulnerabilityAssessmentNameDefault, "scanId1", "VA1234", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.VulnerabilityAssessmentScanResults = armsql.VulnerabilityAssessmentScanResults{
	// 	Name: to.Ptr("VA1234"),
	// 	Type: to.Ptr("Microsoft.Sql/servers/sqlVulnerabilityAssessments/scans/scanResults"),
	// 	ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/vulnerabilityassessmenttest-4711/providers/Microsoft.Sql/servers/vulnerabilityassessmenttest-6411/sqlVulnerabilityAssessments/Default/scans/scanId1/scanResults/VA1234"),
	// 	Properties: &armsql.VulnerabilityAssessmentScanResultProperties{
	// 		IsTrimmed: to.Ptr(false),
	// 		QueryResults: [][]*string{
	// 			[]*string{
	// 				to.Ptr("a1"),
	// 				to.Ptr("a2"),
	// 				to.Ptr("a3")},
	// 				[]*string{
	// 					to.Ptr("b1"),
	// 					to.Ptr("b2"),
	// 					to.Ptr("b3")}},
	// 					Remediation: &armsql.Remediation{
	// 						Description: to.Ptr("Remove users"),
	// 						Automated: to.Ptr(false),
	// 						Scripts: []*string{
	// 							to.Ptr("drop user a"),
	// 							to.Ptr("drop user b")},
	// 						},
	// 						RuleID: to.Ptr("VA1234"),
	// 						RuleMetadata: &armsql.VaRule{
	// 							Description: to.Ptr("This is an example check"),
	// 							BenchmarkReferences: []*armsql.BenchmarkReference{
	// 								{
	// 									Benchmark: to.Ptr("fedramp"),
	// 									Reference: to.Ptr("v1"),
	// 							}},
	// 							Category: to.Ptr("information"),
	// 							QueryCheck: &armsql.QueryCheck{
	// 								ColumnNames: []*string{
	// 									to.Ptr("col1"),
	// 									to.Ptr("col2"),
	// 									to.Ptr("col3")},
	// 									ExpectedResult: [][]*string{
	// 									},
	// 									Query: to.Ptr("Select a1,a2, a3"),
	// 								},
	// 								Rationale: to.Ptr("This is important"),
	// 								RuleID: to.Ptr("VA1234"),
	// 								RuleType: to.Ptr(armsql.RuleTypeNegativeList),
	// 								Severity: to.Ptr(armsql.RuleSeverityInformational),
	// 								Title: to.Ptr("This is the title"),
	// 							},
	// 							Status: to.Ptr(armsql.RuleStatusNonFinding),
	// 						},
	// 					}
}
