//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armpolicy_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/resources/armpolicy"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/resources/resource-manager/Microsoft.Authorization/stable/2022-06-01/examples/deletePolicyAssignment.json
func ExampleAssignmentsClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicy.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAssignmentsClient().Delete(ctx, "subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2", "EnforceNaming", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Assignment = armpolicy.Assignment{
	// 	Name: to.Ptr("EnforceNaming"),
	// 	Type: to.Ptr("Microsoft.Authorization/policyAssignments"),
	// 	ID: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyAssignments/EnforceNaming"),
	// 	Properties: &armpolicy.AssignmentProperties{
	// 		Description: to.Ptr("Force resource names to begin with given DeptA and end with -LC"),
	// 		DisplayName: to.Ptr("Enforce resource naming rules"),
	// 		Metadata: map[string]any{
	// 			"assignedBy": "Special Someone",
	// 		},
	// 		NotScopes: []*string{
	// 		},
	// 		Parameters: map[string]*armpolicy.ParameterValuesValue{
	// 			"prefix": &armpolicy.ParameterValuesValue{
	// 				Value: "DeptA",
	// 			},
	// 			"suffix": &armpolicy.ParameterValuesValue{
	// 				Value: "-LC",
	// 			},
	// 		},
	// 		PolicyDefinitionID: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming"),
	// 		Scope: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/resources/resource-manager/Microsoft.Authorization/stable/2022-06-01/examples/createPolicyAssignment.json
func ExampleAssignmentsClient_Create_createOrUpdateAPolicyAssignment() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicy.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewAssignmentsClient().Create(ctx, "subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2", "EnforceNaming", armpolicy.Assignment{
		Properties: &armpolicy.AssignmentProperties{
			Description: to.Ptr("Force resource names to begin with given DeptA and end with -LC"),
			DisplayName: to.Ptr("Enforce resource naming rules"),
			Metadata: map[string]any{
				"assignedBy": "Special Someone",
			},
			NonComplianceMessages: []*armpolicy.NonComplianceMessage{
				{
					Message: to.Ptr("Resource names must start with 'DeptA' and end with '-LC'."),
				}},
			Parameters: map[string]*armpolicy.ParameterValuesValue{
				"prefix": {
					Value: "DeptA",
				},
				"suffix": {
					Value: "-LC",
				},
			},
			PolicyDefinitionID: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/resources/resource-manager/Microsoft.Authorization/stable/2022-06-01/examples/createPolicyAssignmentWithIdentity.json
func ExampleAssignmentsClient_Create_createOrUpdateAPolicyAssignmentWithASystemAssignedIdentity() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicy.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewAssignmentsClient().Create(ctx, "subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2", "EnforceNaming", armpolicy.Assignment{
		Identity: &armpolicy.Identity{
			Type: to.Ptr(armpolicy.ResourceIdentityTypeSystemAssigned),
		},
		Location: to.Ptr("eastus"),
		Properties: &armpolicy.AssignmentProperties{
			Description:     to.Ptr("Force resource names to begin with given DeptA and end with -LC"),
			DisplayName:     to.Ptr("Enforce resource naming rules"),
			EnforcementMode: to.Ptr(armpolicy.EnforcementModeDefault),
			Metadata: map[string]any{
				"assignedBy": "Foo Bar",
			},
			Parameters: map[string]*armpolicy.ParameterValuesValue{
				"prefix": {
					Value: "DeptA",
				},
				"suffix": {
					Value: "-LC",
				},
			},
			PolicyDefinitionID: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/resources/resource-manager/Microsoft.Authorization/stable/2022-06-01/examples/createPolicyAssignmentWithUserAssignedIdentity.json
func ExampleAssignmentsClient_Create_createOrUpdateAPolicyAssignmentWithAUserAssignedIdentity() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicy.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewAssignmentsClient().Create(ctx, "subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2", "EnforceNaming", armpolicy.Assignment{
		Identity: &armpolicy.Identity{
			Type: to.Ptr(armpolicy.ResourceIdentityTypeUserAssigned),
			UserAssignedIdentities: map[string]*armpolicy.UserAssignedIdentitiesValue{
				"/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/resourceGroups/testResourceGroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/test-identity": {},
			},
		},
		Location: to.Ptr("eastus"),
		Properties: &armpolicy.AssignmentProperties{
			Description:     to.Ptr("Force resource names to begin with given DeptA and end with -LC"),
			DisplayName:     to.Ptr("Enforce resource naming rules"),
			EnforcementMode: to.Ptr(armpolicy.EnforcementModeDefault),
			Metadata: map[string]any{
				"assignedBy": "Foo Bar",
			},
			Parameters: map[string]*armpolicy.ParameterValuesValue{
				"prefix": {
					Value: "DeptA",
				},
				"suffix": {
					Value: "-LC",
				},
			},
			PolicyDefinitionID: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/resources/resource-manager/Microsoft.Authorization/stable/2022-06-01/examples/createPolicyAssignmentNonComplianceMessages.json
func ExampleAssignmentsClient_Create_createOrUpdateAPolicyAssignmentWithMultipleNonComplianceMessages() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicy.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewAssignmentsClient().Create(ctx, "subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2", "securityInitAssignment", armpolicy.Assignment{
		Properties: &armpolicy.AssignmentProperties{
			DisplayName: to.Ptr("Enforce security policies"),
			NonComplianceMessages: []*armpolicy.NonComplianceMessage{
				{
					Message: to.Ptr("Resources must comply with all internal security policies. See <internal site URL> for more info."),
				},
				{
					Message:                     to.Ptr("Resource names must start with 'DeptA' and end with '-LC'."),
					PolicyDefinitionReferenceID: to.Ptr("10420126870854049575"),
				},
				{
					Message:                     to.Ptr("Storage accounts must have firewall rules configured."),
					PolicyDefinitionReferenceID: to.Ptr("8572513655450389710"),
				}},
			PolicyDefinitionID: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policySetDefinitions/securityInitiative"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/resources/resource-manager/Microsoft.Authorization/stable/2022-06-01/examples/createPolicyAssignmentWithOverrides.json
func ExampleAssignmentsClient_Create_createOrUpdateAPolicyAssignmentWithOverrides() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicy.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewAssignmentsClient().Create(ctx, "subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2", "CostManagement", armpolicy.Assignment{
		Properties: &armpolicy.AssignmentProperties{
			Description: to.Ptr("Limit the resource location and resource SKU"),
			DisplayName: to.Ptr("Limit the resource location and resource SKU"),
			Metadata: map[string]any{
				"assignedBy": "Special Someone",
			},
			Overrides: []*armpolicy.Override{
				{
					Kind: to.Ptr(armpolicy.OverrideKindPolicyEffect),
					Selectors: []*armpolicy.Selector{
						{
							In: []*string{
								to.Ptr("Limit_Skus"),
								to.Ptr("Limit_Locations")},
							Kind: to.Ptr(armpolicy.SelectorKindPolicyDefinitionReferenceID),
						}},
					Value: to.Ptr("Audit"),
				}},
			PolicyDefinitionID: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policySetDefinitions/CostManagement"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/resources/resource-manager/Microsoft.Authorization/stable/2022-06-01/examples/createPolicyAssignmentWithResourceSelectors.json
func ExampleAssignmentsClient_Create_createOrUpdateAPolicyAssignmentWithResourceSelectors() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicy.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewAssignmentsClient().Create(ctx, "subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2", "CostManagement", armpolicy.Assignment{
		Properties: &armpolicy.AssignmentProperties{
			Description: to.Ptr("Limit the resource location and resource SKU"),
			DisplayName: to.Ptr("Limit the resource location and resource SKU"),
			Metadata: map[string]any{
				"assignedBy": "Special Someone",
			},
			PolicyDefinitionID: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policySetDefinitions/CostManagement"),
			ResourceSelectors: []*armpolicy.ResourceSelector{
				{
					Name: to.Ptr("SDPRegions"),
					Selectors: []*armpolicy.Selector{
						{
							In: []*string{
								to.Ptr("eastus2euap"),
								to.Ptr("centraluseuap")},
							Kind: to.Ptr(armpolicy.SelectorKindResourceLocation),
						}},
				}},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/resources/resource-manager/Microsoft.Authorization/stable/2022-06-01/examples/createPolicyAssignmentWithoutEnforcement.json
func ExampleAssignmentsClient_Create_createOrUpdateAPolicyAssignmentWithoutEnforcingPolicyEffectDuringResourceCreationOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicy.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewAssignmentsClient().Create(ctx, "subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2", "EnforceNaming", armpolicy.Assignment{
		Properties: &armpolicy.AssignmentProperties{
			Description:     to.Ptr("Force resource names to begin with given DeptA and end with -LC"),
			DisplayName:     to.Ptr("Enforce resource naming rules"),
			EnforcementMode: to.Ptr(armpolicy.EnforcementModeDoNotEnforce),
			Metadata: map[string]any{
				"assignedBy": "Special Someone",
			},
			Parameters: map[string]*armpolicy.ParameterValuesValue{
				"prefix": {
					Value: "DeptA",
				},
				"suffix": {
					Value: "-LC",
				},
			},
			PolicyDefinitionID: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/resources/resource-manager/Microsoft.Authorization/stable/2022-06-01/examples/getPolicyAssignment.json
func ExampleAssignmentsClient_Get_retrieveAPolicyAssignment() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicy.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAssignmentsClient().Get(ctx, "subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2", "EnforceNaming", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Assignment = armpolicy.Assignment{
	// 	Name: to.Ptr("EnforceNaming"),
	// 	Type: to.Ptr("Microsoft.Authorization/policyAssignments"),
	// 	ID: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyAssignments/EnforceNaming"),
	// 	Properties: &armpolicy.AssignmentProperties{
	// 		Description: to.Ptr("Force resource names to begin with given DeptA and end with -LC"),
	// 		DisplayName: to.Ptr("Enforce resource naming rules"),
	// 		EnforcementMode: to.Ptr(armpolicy.EnforcementModeDefault),
	// 		Metadata: map[string]any{
	// 			"assignedBy": "Special Someone",
	// 		},
	// 		NotScopes: []*string{
	// 		},
	// 		Parameters: map[string]*armpolicy.ParameterValuesValue{
	// 			"prefix": &armpolicy.ParameterValuesValue{
	// 				Value: "DeptA",
	// 			},
	// 			"suffix": &armpolicy.ParameterValuesValue{
	// 				Value: "-LC",
	// 			},
	// 		},
	// 		PolicyDefinitionID: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming"),
	// 		Scope: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/resources/resource-manager/Microsoft.Authorization/stable/2022-06-01/examples/getPolicyAssignmentWithIdentity.json
func ExampleAssignmentsClient_Get_retrieveAPolicyAssignmentWithASystemAssignedIdentity() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicy.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAssignmentsClient().Get(ctx, "subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2", "EnforceNaming", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Assignment = armpolicy.Assignment{
	// 	Name: to.Ptr("EnforceNaming"),
	// 	Type: to.Ptr("Microsoft.Authorization/policyAssignments"),
	// 	ID: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyAssignments/EnforceNaming"),
	// 	Identity: &armpolicy.Identity{
	// 		Type: to.Ptr(armpolicy.ResourceIdentityTypeSystemAssigned),
	// 		PrincipalID: to.Ptr("e6d23f8d-af97-4fbc-bda6-00604e4e3d0a"),
	// 		TenantID: to.Ptr("4bee2b8a-1bee-47c2-90e9-404241551135"),
	// 	},
	// 	Location: to.Ptr("westus"),
	// 	Properties: &armpolicy.AssignmentProperties{
	// 		Description: to.Ptr("Force resource names to begin with given DeptA and end with -LC"),
	// 		DisplayName: to.Ptr("Enforce resource naming rules"),
	// 		EnforcementMode: to.Ptr(armpolicy.EnforcementModeDefault),
	// 		Metadata: map[string]any{
	// 			"assignedBy": "Special Someone",
	// 		},
	// 		NotScopes: []*string{
	// 		},
	// 		Parameters: map[string]*armpolicy.ParameterValuesValue{
	// 			"prefix": &armpolicy.ParameterValuesValue{
	// 				Value: "DeptA",
	// 			},
	// 			"suffix": &armpolicy.ParameterValuesValue{
	// 				Value: "-LC",
	// 			},
	// 		},
	// 		PolicyDefinitionID: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming"),
	// 		Scope: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/resources/resource-manager/Microsoft.Authorization/stable/2022-06-01/examples/getPolicyAssignmentWithUserAssignedIdentity.json
func ExampleAssignmentsClient_Get_retrieveAPolicyAssignmentWithAUserAssignedIdentity() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicy.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAssignmentsClient().Get(ctx, "subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2", "EnforceNaming", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Assignment = armpolicy.Assignment{
	// 	Name: to.Ptr("EnforceNaming"),
	// 	Type: to.Ptr("Microsoft.Authorization/policyAssignments"),
	// 	ID: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyAssignments/EnforceNaming"),
	// 	Identity: &armpolicy.Identity{
	// 		Type: to.Ptr(armpolicy.ResourceIdentityTypeUserAssigned),
	// 		UserAssignedIdentities: map[string]*armpolicy.UserAssignedIdentitiesValue{
	// 			"/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/resourceGroups/testResourceGroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/test-identity": &armpolicy.UserAssignedIdentitiesValue{
	// 				ClientID: to.Ptr("4bee2b8a-1bee-47c2-90e9-404241551135"),
	// 				PrincipalID: to.Ptr("e6d23f8d-af97-4fbc-bda6-00604e4e3d0a"),
	// 			},
	// 		},
	// 	},
	// 	Location: to.Ptr("westus"),
	// 	Properties: &armpolicy.AssignmentProperties{
	// 		Description: to.Ptr("Force resource names to begin with given DeptA and end with -LC"),
	// 		DisplayName: to.Ptr("Enforce resource naming rules"),
	// 		EnforcementMode: to.Ptr(armpolicy.EnforcementModeDefault),
	// 		Metadata: map[string]any{
	// 			"assignedBy": "Special Someone",
	// 		},
	// 		NotScopes: []*string{
	// 		},
	// 		Parameters: map[string]*armpolicy.ParameterValuesValue{
	// 			"prefix": &armpolicy.ParameterValuesValue{
	// 				Value: "DeptA",
	// 			},
	// 			"suffix": &armpolicy.ParameterValuesValue{
	// 				Value: "-LC",
	// 			},
	// 		},
	// 		PolicyDefinitionID: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming"),
	// 		Scope: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/resources/resource-manager/Microsoft.Authorization/stable/2022-06-01/examples/getPolicyAssignmentWithOverrides.json
func ExampleAssignmentsClient_Get_retrieveAPolicyAssignmentWithOverrides() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicy.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAssignmentsClient().Get(ctx, "subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2", "CostManagement", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Assignment = armpolicy.Assignment{
	// 	Name: to.Ptr("CostManagement"),
	// 	Type: to.Ptr("Microsoft.Authorization/policyAssignments"),
	// 	ID: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyAssignments/CostManagement"),
	// 	Properties: &armpolicy.AssignmentProperties{
	// 		Description: to.Ptr("Limit the resource location and resource SKU"),
	// 		DisplayName: to.Ptr("Limit the resource location and resource SKU"),
	// 		EnforcementMode: to.Ptr(armpolicy.EnforcementModeDefault),
	// 		Metadata: map[string]any{
	// 			"assignedBy": "Special Someone",
	// 		},
	// 		NotScopes: []*string{
	// 		},
	// 		Overrides: []*armpolicy.Override{
	// 			{
	// 				Kind: to.Ptr(armpolicy.OverrideKindPolicyEffect),
	// 				Selectors: []*armpolicy.Selector{
	// 					{
	// 						In: []*string{
	// 							to.Ptr("Limit_Skus"),
	// 							to.Ptr("Limit_Locations")},
	// 							Kind: to.Ptr(armpolicy.SelectorKindPolicyDefinitionReferenceID),
	// 					}},
	// 					Value: to.Ptr("Audit"),
	// 			}},
	// 			PolicyDefinitionID: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policySetDefinitions/CostManagement"),
	// 			Scope: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2"),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/resources/resource-manager/Microsoft.Authorization/stable/2022-06-01/examples/getPolicyAssignmentWithResourceSelectors.json
func ExampleAssignmentsClient_Get_retrieveAPolicyAssignmentWithResourceSelectors() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicy.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAssignmentsClient().Get(ctx, "subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2", "CostManagement", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Assignment = armpolicy.Assignment{
	// 	Name: to.Ptr("CostManagement"),
	// 	Type: to.Ptr("Microsoft.Authorization/policyAssignments"),
	// 	ID: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyAssignments/CostManagement"),
	// 	Properties: &armpolicy.AssignmentProperties{
	// 		Description: to.Ptr("Limit the resource location and resource SKU"),
	// 		DisplayName: to.Ptr("Limit the resource location and resource SKU"),
	// 		EnforcementMode: to.Ptr(armpolicy.EnforcementModeDefault),
	// 		Metadata: map[string]any{
	// 			"assignedBy": "Special Someone",
	// 		},
	// 		NotScopes: []*string{
	// 		},
	// 		PolicyDefinitionID: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policySetDefinitions/CostManagement"),
	// 		ResourceSelectors: []*armpolicy.ResourceSelector{
	// 			{
	// 				Name: to.Ptr("SDPRegions"),
	// 				Selectors: []*armpolicy.Selector{
	// 					{
	// 						In: []*string{
	// 							to.Ptr("eastus2euap"),
	// 							to.Ptr("centraluseuap")},
	// 							Kind: to.Ptr(armpolicy.SelectorKindResourceLocation),
	// 					}},
	// 			}},
	// 			Scope: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2"),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/resources/resource-manager/Microsoft.Authorization/stable/2022-06-01/examples/updatePolicyAssignmentWithIdentity.json
func ExampleAssignmentsClient_Update_updateAPolicyAssignmentWithASystemAssignedIdentity() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicy.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAssignmentsClient().Update(ctx, "subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2", "EnforceNaming", armpolicy.AssignmentUpdate{
		Identity: &armpolicy.Identity{
			Type: to.Ptr(armpolicy.ResourceIdentityTypeSystemAssigned),
		},
		Location: to.Ptr("eastus"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Assignment = armpolicy.Assignment{
	// 	Name: to.Ptr("EnforceNaming"),
	// 	Type: to.Ptr("Microsoft.Authorization/policyAssignments"),
	// 	ID: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyAssignments/EnforceNaming"),
	// 	Identity: &armpolicy.Identity{
	// 		Type: to.Ptr(armpolicy.ResourceIdentityTypeSystemAssigned),
	// 		PrincipalID: to.Ptr("e6d23f8d-af97-4fbc-bda6-00604e4e3d0a"),
	// 		TenantID: to.Ptr("4bee2b8a-1bee-47c2-90e9-404241551135"),
	// 	},
	// 	Location: to.Ptr("eastus"),
	// 	Properties: &armpolicy.AssignmentProperties{
	// 		Description: to.Ptr("Force resource names to begin with given DeptA and end with -LC"),
	// 		DisplayName: to.Ptr("Enforce resource naming rules"),
	// 		EnforcementMode: to.Ptr(armpolicy.EnforcementModeDefault),
	// 		Metadata: map[string]any{
	// 			"assignedBy": "Special Someone",
	// 		},
	// 		NotScopes: []*string{
	// 		},
	// 		Parameters: map[string]*armpolicy.ParameterValuesValue{
	// 			"prefix": &armpolicy.ParameterValuesValue{
	// 				Value: "DeptA",
	// 			},
	// 			"suffix": &armpolicy.ParameterValuesValue{
	// 				Value: "-LC",
	// 			},
	// 		},
	// 		PolicyDefinitionID: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming"),
	// 		Scope: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/resources/resource-manager/Microsoft.Authorization/stable/2022-06-01/examples/updatePolicyAssignmentWithUserAssignedIdentity.json
func ExampleAssignmentsClient_Update_updateAPolicyAssignmentWithAUserAssignedIdentity() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicy.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAssignmentsClient().Update(ctx, "subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2", "EnforceNaming", armpolicy.AssignmentUpdate{
		Identity: &armpolicy.Identity{
			Type: to.Ptr(armpolicy.ResourceIdentityTypeUserAssigned),
			UserAssignedIdentities: map[string]*armpolicy.UserAssignedIdentitiesValue{
				"/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/resourceGroups/testResourceGroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/test-identity": {},
			},
		},
		Location: to.Ptr("eastus"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Assignment = armpolicy.Assignment{
	// 	Name: to.Ptr("EnforceNaming"),
	// 	Type: to.Ptr("Microsoft.Authorization/policyAssignments"),
	// 	ID: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyAssignments/EnforceNaming"),
	// 	Identity: &armpolicy.Identity{
	// 		Type: to.Ptr(armpolicy.ResourceIdentityTypeUserAssigned),
	// 		UserAssignedIdentities: map[string]*armpolicy.UserAssignedIdentitiesValue{
	// 			"/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/resourceGroups/testResourceGroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/test-identity": &armpolicy.UserAssignedIdentitiesValue{
	// 				ClientID: to.Ptr("4bee2b8a-1bee-47c2-90e9-404241551135"),
	// 				PrincipalID: to.Ptr("e6d23f8d-af97-4fbc-bda6-00604e4e3d0a"),
	// 			},
	// 		},
	// 	},
	// 	Location: to.Ptr("eastus"),
	// 	Properties: &armpolicy.AssignmentProperties{
	// 		Description: to.Ptr("Force resource names to begin with given DeptA and end with -LC"),
	// 		DisplayName: to.Ptr("Enforce resource naming rules"),
	// 		EnforcementMode: to.Ptr(armpolicy.EnforcementModeDefault),
	// 		Metadata: map[string]any{
	// 			"assignedBy": "Special Someone",
	// 		},
	// 		NotScopes: []*string{
	// 		},
	// 		Parameters: map[string]*armpolicy.ParameterValuesValue{
	// 			"prefix": &armpolicy.ParameterValuesValue{
	// 				Value: "DeptA",
	// 			},
	// 			"suffix": &armpolicy.ParameterValuesValue{
	// 				Value: "-LC",
	// 			},
	// 		},
	// 		PolicyDefinitionID: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming"),
	// 		Scope: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/resources/resource-manager/Microsoft.Authorization/stable/2022-06-01/examples/updatePolicyAssignmentWithOverrides.json
func ExampleAssignmentsClient_Update_updateAPolicyAssignmentWithOverrides() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicy.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAssignmentsClient().Update(ctx, "subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2", "CostManagement", armpolicy.AssignmentUpdate{
		Properties: &armpolicy.AssignmentUpdateProperties{
			Overrides: []*armpolicy.Override{
				{
					Kind: to.Ptr(armpolicy.OverrideKindPolicyEffect),
					Selectors: []*armpolicy.Selector{
						{
							In: []*string{
								to.Ptr("Limit_Skus"),
								to.Ptr("Limit_Locations")},
							Kind: to.Ptr(armpolicy.SelectorKindPolicyDefinitionReferenceID),
						}},
					Value: to.Ptr("Audit"),
				}},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Assignment = armpolicy.Assignment{
	// 	Name: to.Ptr("CostManagement"),
	// 	Type: to.Ptr("Microsoft.Authorization/policyAssignments"),
	// 	ID: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyAssignments/CostManagement"),
	// 	Properties: &armpolicy.AssignmentProperties{
	// 		Description: to.Ptr("Limit the resource location and resource SKU"),
	// 		DisplayName: to.Ptr("Limit the resource location and resource SKU"),
	// 		EnforcementMode: to.Ptr(armpolicy.EnforcementModeDefault),
	// 		Metadata: map[string]any{
	// 			"assignedBy": "Special Someone",
	// 		},
	// 		NotScopes: []*string{
	// 		},
	// 		Overrides: []*armpolicy.Override{
	// 			{
	// 				Kind: to.Ptr(armpolicy.OverrideKindPolicyEffect),
	// 				Selectors: []*armpolicy.Selector{
	// 					{
	// 						In: []*string{
	// 							to.Ptr("Limit_Skus"),
	// 							to.Ptr("Limit_Locations")},
	// 							Kind: to.Ptr(armpolicy.SelectorKindPolicyDefinitionReferenceID),
	// 					}},
	// 					Value: to.Ptr("Audit"),
	// 			}},
	// 			PolicyDefinitionID: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policySetDefinitions/CostManagement"),
	// 			Scope: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2"),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/resources/resource-manager/Microsoft.Authorization/stable/2022-06-01/examples/updatePolicyAssignmentWithResourceSelectors.json
func ExampleAssignmentsClient_Update_updateAPolicyAssignmentWithResourceSelectors() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicy.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAssignmentsClient().Update(ctx, "subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2", "CostManagement", armpolicy.AssignmentUpdate{
		Properties: &armpolicy.AssignmentUpdateProperties{
			ResourceSelectors: []*armpolicy.ResourceSelector{
				{
					Name: to.Ptr("SDPRegions"),
					Selectors: []*armpolicy.Selector{
						{
							In: []*string{
								to.Ptr("eastus2euap"),
								to.Ptr("centraluseuap")},
							Kind: to.Ptr(armpolicy.SelectorKindResourceLocation),
						}},
				}},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Assignment = armpolicy.Assignment{
	// 	Name: to.Ptr("CostManagement"),
	// 	Type: to.Ptr("Microsoft.Authorization/policyAssignments"),
	// 	ID: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyAssignments/CostManagement"),
	// 	Properties: &armpolicy.AssignmentProperties{
	// 		Description: to.Ptr("Limit the resource location and resource SKU"),
	// 		DisplayName: to.Ptr("Limit the resource location and resource SKU"),
	// 		EnforcementMode: to.Ptr(armpolicy.EnforcementModeDefault),
	// 		Metadata: map[string]any{
	// 			"assignedBy": "Special Someone",
	// 		},
	// 		NotScopes: []*string{
	// 		},
	// 		PolicyDefinitionID: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policySetDefinitions/CostManagement"),
	// 		ResourceSelectors: []*armpolicy.ResourceSelector{
	// 			{
	// 				Name: to.Ptr("SDPRegions"),
	// 				Selectors: []*armpolicy.Selector{
	// 					{
	// 						In: []*string{
	// 							to.Ptr("eastus2euap"),
	// 							to.Ptr("centraluseuap")},
	// 							Kind: to.Ptr(armpolicy.SelectorKindResourceLocation),
	// 					}},
	// 			}},
	// 			Scope: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2"),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/resources/resource-manager/Microsoft.Authorization/stable/2022-06-01/examples/listPolicyAssignmentsForResourceGroup.json
func ExampleAssignmentsClient_NewListForResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicy.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewAssignmentsClient().NewListForResourceGroupPager("TestResourceGroup", &armpolicy.AssignmentsClientListForResourceGroupOptions{Filter: to.Ptr("atScope()"),
		Top: nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.AssignmentListResult = armpolicy.AssignmentListResult{
		// 	Value: []*armpolicy.Assignment{
		// 		{
		// 			Name: to.Ptr("TestCostManagement"),
		// 			Type: to.Ptr("Microsoft.Authorization/policyAssignments"),
		// 			ID: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/resourceGroups/TestResourceGroup/providers/Microsoft.Authorization/policyAssignments/TestCostManagement"),
		// 			Identity: &armpolicy.Identity{
		// 				Type: to.Ptr(armpolicy.ResourceIdentityTypeSystemAssigned),
		// 				PrincipalID: to.Ptr("e6d23f8d-af97-4fbc-bda6-00604e4e3d0a"),
		// 				TenantID: to.Ptr("4bee2b8a-1bee-47c2-90e9-404241551135"),
		// 			},
		// 			Location: to.Ptr("eastus"),
		// 			Properties: &armpolicy.AssignmentProperties{
		// 				Description: to.Ptr("Minimize the risk of accidental cost overruns"),
		// 				DisplayName: to.Ptr("Storage Cost Management"),
		// 				Metadata: map[string]any{
		// 					"category": "Cost Management",
		// 				},
		// 				NotScopes: []*string{
		// 				},
		// 				Parameters: map[string]*armpolicy.ParameterValuesValue{
		// 					"allowedSkus": &armpolicy.ParameterValuesValue{
		// 						Value: "Standard_A1",
		// 					},
		// 				},
		// 				PolicyDefinitionID: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/storageSkus"),
		// 				Scope: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/resourceGroups/TestResourceGroup"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("TestTagEnforcement"),
		// 			Type: to.Ptr("Microsoft.Authorization/policyAssignments"),
		// 			ID: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/resourceGroups/TestResourceGroup/providers/Microsoft.Authorization/policyAssignments/TestTagEnforcement"),
		// 			Properties: &armpolicy.AssignmentProperties{
		// 				Description: to.Ptr("Ensure a given tag key and value are present on all resources"),
		// 				DisplayName: to.Ptr("Enforces a tag key and value"),
		// 				NotScopes: []*string{
		// 				},
		// 				PolicyDefinitionID: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/TagKeyValue"),
		// 				Scope: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/resourceGroups/TestResourceGroup"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/resources/resource-manager/Microsoft.Authorization/stable/2022-06-01/examples/listPolicyAssignmentsForResource.json
func ExampleAssignmentsClient_NewListForResourcePager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicy.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewAssignmentsClient().NewListForResourcePager("TestResourceGroup", "Microsoft.Compute", "virtualMachines/MyTestVm", "domainNames", "MyTestComputer.cloudapp.net", &armpolicy.AssignmentsClientListForResourceOptions{Filter: nil,
		Top: nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.AssignmentListResult = armpolicy.AssignmentListResult{
		// 	Value: []*armpolicy.Assignment{
		// 		{
		// 			Name: to.Ptr("TestCostManagement"),
		// 			Type: to.Ptr("Microsoft.Authorization/policyAssignments"),
		// 			ID: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/resourceGroups/TestResourceGroup/providers/Microsoft.Authorization/policyAssignments/TestCostManagement"),
		// 			Identity: &armpolicy.Identity{
		// 				Type: to.Ptr(armpolicy.ResourceIdentityTypeSystemAssigned),
		// 				PrincipalID: to.Ptr("e6d23f8d-af97-4fbc-bda6-00604e4e3d0a"),
		// 				TenantID: to.Ptr("4bee2b8a-1bee-47c2-90e9-404241551135"),
		// 			},
		// 			Location: to.Ptr("eastus"),
		// 			Properties: &armpolicy.AssignmentProperties{
		// 				Description: to.Ptr("Minimize the risk of accidental cost overruns"),
		// 				DisplayName: to.Ptr("VM Cost Management"),
		// 				Metadata: map[string]any{
		// 					"category": "Cost Management",
		// 				},
		// 				NotScopes: []*string{
		// 				},
		// 				Parameters: map[string]*armpolicy.ParameterValuesValue{
		// 					"allowedSkus": &armpolicy.ParameterValuesValue{
		// 						Value: "Standard_A1",
		// 					},
		// 				},
		// 				PolicyDefinitionID: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/vmSkus"),
		// 				Scope: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/resourceGroups/TestResourceGroup"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("TestTagEnforcement"),
		// 			Type: to.Ptr("Microsoft.Authorization/policyAssignments"),
		// 			ID: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/resourceGroups/TestResourceGroup/providers/Microsoft.Authorization/policyAssignments/TestTagEnforcement"),
		// 			Properties: &armpolicy.AssignmentProperties{
		// 				Description: to.Ptr("Ensure a given tag key and value are present on all resources"),
		// 				DisplayName: to.Ptr("Enforces a tag key and value"),
		// 				NotScopes: []*string{
		// 				},
		// 				PolicyDefinitionID: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/TagKeyValue"),
		// 				Scope: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/resourceGroups/TestResourceGroup"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/resources/resource-manager/Microsoft.Authorization/stable/2022-06-01/examples/listPolicyAssignmentsForManagementGroup.json
func ExampleAssignmentsClient_NewListForManagementGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicy.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewAssignmentsClient().NewListForManagementGroupPager("TestManagementGroup", &armpolicy.AssignmentsClientListForManagementGroupOptions{Filter: to.Ptr("atScope()"),
		Top: nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.AssignmentListResult = armpolicy.AssignmentListResult{
		// 	Value: []*armpolicy.Assignment{
		// 		{
		// 			Name: to.Ptr("TestCostManagement"),
		// 			Type: to.Ptr("Microsoft.Authorization/policyAssignments"),
		// 			ID: to.Ptr("/providers/Microsoft.Management/managementGroups/TestManagementGroup/providers/Microsoft.Authorization/policyAssignments/TestCostManagement"),
		// 			Identity: &armpolicy.Identity{
		// 				Type: to.Ptr(armpolicy.ResourceIdentityTypeSystemAssigned),
		// 				PrincipalID: to.Ptr("e6d23f8d-af97-4fbc-bda6-00604e4e3d0a"),
		// 				TenantID: to.Ptr("4bee2b8a-1bee-47c2-90e9-404241551135"),
		// 			},
		// 			Location: to.Ptr("eastus"),
		// 			Properties: &armpolicy.AssignmentProperties{
		// 				Description: to.Ptr("Minimize the risk of accidental cost overruns"),
		// 				DisplayName: to.Ptr("Storage Cost Management"),
		// 				Metadata: map[string]any{
		// 					"category": "Cost Management",
		// 				},
		// 				NotScopes: []*string{
		// 				},
		// 				Parameters: map[string]*armpolicy.ParameterValuesValue{
		// 					"allowedSkus": &armpolicy.ParameterValuesValue{
		// 						Value: "Standard_A1",
		// 					},
		// 				},
		// 				PolicyDefinitionID: to.Ptr("/providers/Microsoft.Management/managementGroups/TestManagementGroup/providers/Microsoft.Authorization/policyDefinitions/storageSkus"),
		// 				Scope: to.Ptr("/providers/Microsoft.Management/managementGroups/TestManagementGroup"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("TestTagEnforcement"),
		// 			Type: to.Ptr("Microsoft.Authorization/policyAssignments"),
		// 			ID: to.Ptr("/providers/Microsoft.Management/managementGroups/TestManagementGroup/providers/Microsoft.Authorization/policyAssignments/TestTagEnforcement"),
		// 			Properties: &armpolicy.AssignmentProperties{
		// 				Description: to.Ptr("Ensure a given tag key and value are present on all resources"),
		// 				DisplayName: to.Ptr("Enforces a tag key and value"),
		// 				NotScopes: []*string{
		// 				},
		// 				PolicyDefinitionID: to.Ptr("/providers/Microsoft.Management/managementGroups/TestManagementGroup/providers/Microsoft.Authorization/policyDefinitions/TagKeyValue"),
		// 				Scope: to.Ptr("/providers/Microsoft.Management/managementGroups/TestManagementGroup"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/resources/resource-manager/Microsoft.Authorization/stable/2022-06-01/examples/listPolicyAssignments.json
func ExampleAssignmentsClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicy.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewAssignmentsClient().NewListPager(&armpolicy.AssignmentsClientListOptions{Filter: to.Ptr("atScope()"),
		Top: nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.AssignmentListResult = armpolicy.AssignmentListResult{
		// 	Value: []*armpolicy.Assignment{
		// 		{
		// 			Name: to.Ptr("CostManagement"),
		// 			Type: to.Ptr("Microsoft.Authorization/policyAssignments"),
		// 			ID: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyAssignments/CostManagement"),
		// 			Identity: &armpolicy.Identity{
		// 				Type: to.Ptr(armpolicy.ResourceIdentityTypeSystemAssigned),
		// 				PrincipalID: to.Ptr("e6d23f8d-af97-4fbc-bda6-00604e4e3d0a"),
		// 				TenantID: to.Ptr("4bee2b8a-1bee-47c2-90e9-404241551135"),
		// 			},
		// 			Location: to.Ptr("eastus"),
		// 			Properties: &armpolicy.AssignmentProperties{
		// 				Description: to.Ptr("Minimize the risk of accidental cost overruns"),
		// 				DisplayName: to.Ptr("Storage Cost Management"),
		// 				Metadata: map[string]any{
		// 					"category": "Cost Management",
		// 				},
		// 				NotScopes: []*string{
		// 				},
		// 				Parameters: map[string]*armpolicy.ParameterValuesValue{
		// 					"allowedSkus": &armpolicy.ParameterValuesValue{
		// 						Value: "Standard_A1",
		// 					},
		// 				},
		// 				PolicyDefinitionID: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/storageSkus"),
		// 				Scope: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("TagEnforcement"),
		// 			Type: to.Ptr("Microsoft.Authorization/policyAssignments"),
		// 			ID: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyAssignments/TagEnforcement"),
		// 			Properties: &armpolicy.AssignmentProperties{
		// 				Description: to.Ptr("Ensure a given tag key and value are present on all resources"),
		// 				DisplayName: to.Ptr("Enforces a tag key and value"),
		// 				NotScopes: []*string{
		// 				},
		// 				PolicyDefinitionID: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/TagKeyValue"),
		// 				Scope: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/resources/resource-manager/Microsoft.Authorization/stable/2022-06-01/examples/deletePolicyAssignmentById.json
func ExampleAssignmentsClient_DeleteByID() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicy.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAssignmentsClient().DeleteByID(ctx, "providers/Microsoft.Management/managementGroups/MyManagementGroup/providers/Microsoft.Authorization/policyAssignments/LowCostStorage", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Assignment = armpolicy.Assignment{
	// 	Name: to.Ptr("LowCostStorage"),
	// 	Type: to.Ptr("Microsoft.Authorization/policyAssignments"),
	// 	ID: to.Ptr("/providers/Microsoft.Management/managementGroups/MyManagementGroup/providers/Microsoft.Authorization/policyAssignments/LowCostStorage"),
	// 	Properties: &armpolicy.AssignmentProperties{
	// 		Description: to.Ptr("Allow only storage accounts of SKU Standard_GRS or Standard_LRS to be created"),
	// 		DisplayName: to.Ptr("Enforce storage account SKU"),
	// 		Metadata: map[string]any{
	// 			"assignedBy": "Cheapskate Boss",
	// 		},
	// 		NotScopes: []*string{
	// 		},
	// 		Parameters: map[string]*armpolicy.ParameterValuesValue{
	// 			"listOfAllowedSKUs": &armpolicy.ParameterValuesValue{
	// 				Value: []any{
	// 					"Standard_GRS",
	// 					"Standard_LRS",
	// 				},
	// 			},
	// 		},
	// 		PolicyDefinitionID: to.Ptr("/providers/Microsoft.Authorization/policyDefinitions/7433c107-6db4-4ad1-b57a-a76dce0154a1"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/resources/resource-manager/Microsoft.Authorization/stable/2022-06-01/examples/createPolicyAssignmentById.json
func ExampleAssignmentsClient_CreateByID_createOrUpdatePolicyAssignmentById() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicy.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewAssignmentsClient().CreateByID(ctx, "providers/Microsoft.Management/managementGroups/MyManagementGroup/providers/Microsoft.Authorization/policyAssignments/LowCostStorage", armpolicy.Assignment{
		Properties: &armpolicy.AssignmentProperties{
			Description:     to.Ptr("Allow only storage accounts of SKU Standard_GRS or Standard_LRS to be created"),
			DisplayName:     to.Ptr("Enforce storage account SKU"),
			EnforcementMode: to.Ptr(armpolicy.EnforcementModeDefault),
			Metadata: map[string]any{
				"assignedBy": "Cheapskate Boss",
			},
			Parameters: map[string]*armpolicy.ParameterValuesValue{
				"listOfAllowedSKUs": {
					Value: []any{
						"Standard_GRS",
						"Standard_LRS",
					},
				},
			},
			PolicyDefinitionID: to.Ptr("/providers/Microsoft.Authorization/policyDefinitions/7433c107-6db4-4ad1-b57a-a76dce0154a1"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/resources/resource-manager/Microsoft.Authorization/stable/2022-06-01/examples/createPolicyAssignmentWithIdentityById.json
func ExampleAssignmentsClient_CreateByID_createOrUpdatePolicyAssignmentWithAManagedIdentityById() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicy.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewAssignmentsClient().CreateByID(ctx, "providers/Microsoft.Management/managementGroups/MyManagementGroup/providers/Microsoft.Authorization/policyAssignments/LowCostStorage", armpolicy.Assignment{
		Identity: &armpolicy.Identity{
			Type: to.Ptr(armpolicy.ResourceIdentityTypeSystemAssigned),
		},
		Location: to.Ptr("eastus"),
		Properties: &armpolicy.AssignmentProperties{
			Description:     to.Ptr("Allow only storage accounts of SKU Standard_GRS or Standard_LRS to be created"),
			DisplayName:     to.Ptr("Enforce storage account SKU"),
			EnforcementMode: to.Ptr(armpolicy.EnforcementModeDefault),
			Metadata: map[string]any{
				"assignedBy": "Cheapskate Boss",
			},
			Parameters: map[string]*armpolicy.ParameterValuesValue{
				"listOfAllowedSKUs": {
					Value: []any{
						"Standard_GRS",
						"Standard_LRS",
					},
				},
			},
			PolicyDefinitionID: to.Ptr("/providers/Microsoft.Authorization/policyDefinitions/7433c107-6db4-4ad1-b57a-a76dce0154a1"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/resources/resource-manager/Microsoft.Authorization/stable/2022-06-01/examples/getPolicyAssignmentById.json
func ExampleAssignmentsClient_GetByID_retrieveAPolicyAssignmentById() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicy.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAssignmentsClient().GetByID(ctx, "providers/Microsoft.Management/managementGroups/MyManagementGroup/providers/Microsoft.Authorization/policyAssignments/LowCostStorage", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Assignment = armpolicy.Assignment{
	// 	Name: to.Ptr("LowCostStorage"),
	// 	Type: to.Ptr("Microsoft.Authorization/policyAssignments"),
	// 	ID: to.Ptr("/providers/Microsoft.Management/managementGroups/MyManagementGroup/providers/Microsoft.Authorization/policyAssignments/LowCostStorage"),
	// 	Properties: &armpolicy.AssignmentProperties{
	// 		Description: to.Ptr("Allow only storage accounts of SKU Standard_GRS or Standard_LRS to be created"),
	// 		DisplayName: to.Ptr("Enforce storage account SKU"),
	// 		EnforcementMode: to.Ptr(armpolicy.EnforcementModeDefault),
	// 		Metadata: map[string]any{
	// 			"assignedBy": "Cheapskate Boss",
	// 		},
	// 		NotScopes: []*string{
	// 		},
	// 		Parameters: map[string]*armpolicy.ParameterValuesValue{
	// 			"listOfAllowedSKUs": &armpolicy.ParameterValuesValue{
	// 				Value: []any{
	// 					"Standard_GRS",
	// 					"Standard_LRS",
	// 				},
	// 			},
	// 		},
	// 		PolicyDefinitionID: to.Ptr("/providers/Microsoft.Authorization/policyDefinitions/7433c107-6db4-4ad1-b57a-a76dce0154a1"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/resources/resource-manager/Microsoft.Authorization/stable/2022-06-01/examples/getPolicyAssignmentWithIdentityById.json
func ExampleAssignmentsClient_GetByID_retrieveAPolicyAssignmentWithAManagedIdentityById() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicy.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAssignmentsClient().GetByID(ctx, "providers/Microsoft.Management/managementGroups/MyManagementGroup/providers/Microsoft.Authorization/policyAssignments/LowCostStorage", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Assignment = armpolicy.Assignment{
	// 	Name: to.Ptr("LowCostStorage"),
	// 	Type: to.Ptr("Microsoft.Authorization/policyAssignments"),
	// 	ID: to.Ptr("/providers/Microsoft.Management/managementGroups/MyManagementGroup/providers/Microsoft.Authorization/policyAssignments/LowCostStorage"),
	// 	Identity: &armpolicy.Identity{
	// 		Type: to.Ptr(armpolicy.ResourceIdentityTypeSystemAssigned),
	// 		PrincipalID: to.Ptr("e6d23f8d-af97-4fbc-bda6-00604e4e3d0a"),
	// 		TenantID: to.Ptr("4bee2b8a-1bee-47c2-90e9-404241551135"),
	// 	},
	// 	Location: to.Ptr("westus"),
	// 	Properties: &armpolicy.AssignmentProperties{
	// 		Description: to.Ptr("Allow only storage accounts of SKU Standard_GRS or Standard_LRS to be created"),
	// 		DisplayName: to.Ptr("Enforce storage account SKU"),
	// 		EnforcementMode: to.Ptr(armpolicy.EnforcementModeDefault),
	// 		Metadata: map[string]any{
	// 			"assignedBy": "Cheapskate Boss",
	// 		},
	// 		NotScopes: []*string{
	// 		},
	// 		Parameters: map[string]*armpolicy.ParameterValuesValue{
	// 			"listOfAllowedSKUs": &armpolicy.ParameterValuesValue{
	// 				Value: []any{
	// 					"Standard_GRS",
	// 					"Standard_LRS",
	// 				},
	// 			},
	// 		},
	// 		PolicyDefinitionID: to.Ptr("/providers/Microsoft.Authorization/policyDefinitions/7433c107-6db4-4ad1-b57a-a76dce0154a1"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/resources/resource-manager/Microsoft.Authorization/stable/2022-06-01/examples/updatePolicyAssignmentWithIdentityById.json
func ExampleAssignmentsClient_UpdateByID() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicy.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAssignmentsClient().UpdateByID(ctx, "providers/Microsoft.Management/managementGroups/MyManagementGroup/providers/Microsoft.Authorization/policyAssignments/LowCostStorage", armpolicy.AssignmentUpdate{
		Identity: &armpolicy.Identity{
			Type: to.Ptr(armpolicy.ResourceIdentityTypeSystemAssigned),
		},
		Location: to.Ptr("eastus"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Assignment = armpolicy.Assignment{
	// 	Name: to.Ptr("LowCostStorage"),
	// 	Type: to.Ptr("Microsoft.Authorization/policyAssignments"),
	// 	ID: to.Ptr("/providers/Microsoft.Management/managementGroups/MyManagementGroup/providers/Microsoft.Authorization/policyAssignments/LowCostStorage"),
	// 	Identity: &armpolicy.Identity{
	// 		Type: to.Ptr(armpolicy.ResourceIdentityTypeSystemAssigned),
	// 		PrincipalID: to.Ptr("e6d23f8d-af97-4fbc-bda6-00604e4e3d0a"),
	// 		TenantID: to.Ptr("4bee2b8a-1bee-47c2-90e9-404241551135"),
	// 	},
	// 	Location: to.Ptr("eastus"),
	// 	Properties: &armpolicy.AssignmentProperties{
	// 		Description: to.Ptr("Allow only storage accounts of SKU Standard_GRS or Standard_LRS to be created"),
	// 		DisplayName: to.Ptr("Enforce storage account SKU"),
	// 		EnforcementMode: to.Ptr(armpolicy.EnforcementModeDefault),
	// 		Metadata: map[string]any{
	// 			"assignedBy": "Cheapskate Boss",
	// 		},
	// 		NotScopes: []*string{
	// 		},
	// 		Parameters: map[string]*armpolicy.ParameterValuesValue{
	// 			"listOfAllowedSKUs": &armpolicy.ParameterValuesValue{
	// 				Value: []any{
	// 					"Standard_GRS",
	// 					"Standard_LRS",
	// 				},
	// 			},
	// 		},
	// 		PolicyDefinitionID: to.Ptr("/providers/Microsoft.Authorization/policyDefinitions/7433c107-6db4-4ad1-b57a-a76dce0154a1"),
	// 	},
	// }
}
