//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/devtestlabs/armdevtestlabs"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// ArtifactsServer is a fake server for instances of the armdevtestlabs.ArtifactsClient type.
type ArtifactsServer struct {
	// GenerateArmTemplate is the fake for method ArtifactsClient.GenerateArmTemplate
	// HTTP status codes to indicate success: http.StatusOK
	GenerateArmTemplate func(ctx context.Context, resourceGroupName string, labName string, artifactSourceName string, name string, generateArmTemplateRequest armdevtestlabs.GenerateArmTemplateRequest, options *armdevtestlabs.ArtifactsClientGenerateArmTemplateOptions) (resp azfake.Responder[armdevtestlabs.ArtifactsClientGenerateArmTemplateResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ArtifactsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, labName string, artifactSourceName string, name string, options *armdevtestlabs.ArtifactsClientGetOptions) (resp azfake.Responder[armdevtestlabs.ArtifactsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method ArtifactsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, labName string, artifactSourceName string, options *armdevtestlabs.ArtifactsClientListOptions) (resp azfake.PagerResponder[armdevtestlabs.ArtifactsClientListResponse])
}

// NewArtifactsServerTransport creates a new instance of ArtifactsServerTransport with the provided implementation.
// The returned ArtifactsServerTransport instance is connected to an instance of armdevtestlabs.ArtifactsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewArtifactsServerTransport(srv *ArtifactsServer) *ArtifactsServerTransport {
	return &ArtifactsServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armdevtestlabs.ArtifactsClientListResponse]](),
	}
}

// ArtifactsServerTransport connects instances of armdevtestlabs.ArtifactsClient to instances of ArtifactsServer.
// Don't use this type directly, use NewArtifactsServerTransport instead.
type ArtifactsServerTransport struct {
	srv          *ArtifactsServer
	newListPager *tracker[azfake.PagerResponder[armdevtestlabs.ArtifactsClientListResponse]]
}

// Do implements the policy.Transporter interface for ArtifactsServerTransport.
func (a *ArtifactsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ArtifactsClient.GenerateArmTemplate":
		resp, err = a.dispatchGenerateArmTemplate(req)
	case "ArtifactsClient.Get":
		resp, err = a.dispatchGet(req)
	case "ArtifactsClient.NewListPager":
		resp, err = a.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (a *ArtifactsServerTransport) dispatchGenerateArmTemplate(req *http.Request) (*http.Response, error) {
	if a.srv.GenerateArmTemplate == nil {
		return nil, &nonRetriableError{errors.New("fake for method GenerateArmTemplate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DevTestLab/labs/(?P<labName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/artifactsources/(?P<artifactSourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/artifacts/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/generateArmTemplate`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armdevtestlabs.GenerateArmTemplateRequest](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	labNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("labName")])
	if err != nil {
		return nil, err
	}
	artifactSourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("artifactSourceName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.GenerateArmTemplate(req.Context(), resourceGroupNameParam, labNameParam, artifactSourceNameParam, nameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ArmTemplateInfo, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *ArtifactsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if a.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DevTestLab/labs/(?P<labName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/artifactsources/(?P<artifactSourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/artifacts/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	labNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("labName")])
	if err != nil {
		return nil, err
	}
	artifactSourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("artifactSourceName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	expandUnescaped, err := url.QueryUnescape(qp.Get("$expand"))
	if err != nil {
		return nil, err
	}
	expandParam := getOptional(expandUnescaped)
	var options *armdevtestlabs.ArtifactsClientGetOptions
	if expandParam != nil {
		options = &armdevtestlabs.ArtifactsClientGetOptions{
			Expand: expandParam,
		}
	}
	respr, errRespr := a.srv.Get(req.Context(), resourceGroupNameParam, labNameParam, artifactSourceNameParam, nameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Artifact, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *ArtifactsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if a.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := a.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DevTestLab/labs/(?P<labName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/artifactsources/(?P<artifactSourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/artifacts`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		labNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("labName")])
		if err != nil {
			return nil, err
		}
		artifactSourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("artifactSourceName")])
		if err != nil {
			return nil, err
		}
		expandUnescaped, err := url.QueryUnescape(qp.Get("$expand"))
		if err != nil {
			return nil, err
		}
		expandParam := getOptional(expandUnescaped)
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		orderbyUnescaped, err := url.QueryUnescape(qp.Get("$orderby"))
		if err != nil {
			return nil, err
		}
		orderbyParam := getOptional(orderbyUnescaped)
		var options *armdevtestlabs.ArtifactsClientListOptions
		if expandParam != nil || filterParam != nil || topParam != nil || orderbyParam != nil {
			options = &armdevtestlabs.ArtifactsClientListOptions{
				Expand:  expandParam,
				Filter:  filterParam,
				Top:     topParam,
				Orderby: orderbyParam,
			}
		}
		resp := a.srv.NewListPager(resourceGroupNameParam, labNameParam, artifactSourceNameParam, options)
		newListPager = &resp
		a.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armdevtestlabs.ArtifactsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		a.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		a.newListPager.remove(req)
	}
	return resp, nil
}
