"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.rectifyVheaTable = exports.rectifyHheaTable = void 0;
const Ot = require("@ot-builder/ot");
function inPlaceRectifyHheaVheaTable(rec, newTable, table) {
    newTable.advanceMax = table.advanceMax;
    newTable.minStartSideBearing = table.minStartSideBearing;
    newTable.minEndSideBearing = table.minEndSideBearing;
    newTable.maxExtent = table.maxExtent;
    newTable._reserved0 = table._reserved0;
    newTable._reserved1 = table._reserved1;
    newTable._reserved2 = table._reserved2;
    newTable._reserved3 = table._reserved3;
    newTable.numberOfLongMetrics = table.numberOfLongMetrics;
    newTable.ascender = rec.coord(table.ascender);
    newTable.descender = rec.coord(table.descender);
    newTable.lineGap = rec.coord(table.lineGap);
    newTable.caretSlopeRise = rec.coord(table.caretSlopeRise);
    newTable.caretSlopeRun = rec.coord(table.caretSlopeRun);
    newTable.caretOffset = rec.coord(table.caretOffset);
}
function rectifyHheaTable(rec, table) {
    const newTable = new Ot.MetricHead.Hhea(table.majorVersion, table.minorVersion);
    inPlaceRectifyHheaVheaTable(rec, newTable, table);
    return newTable;
}
exports.rectifyHheaTable = rectifyHheaTable;
function rectifyVheaTable(rec, table) {
    const newTable = new Ot.MetricHead.Vhea(table.majorVersion, table.minorVersion);
    inPlaceRectifyHheaVheaTable(rec, newTable, table);
    return newTable;
}
exports.rectifyVheaTable = rectifyVheaTable;
//# sourceMappingURL=hhea-vhea.js.map