/* vim: set ts=2 et sw=2 tw=80: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

/* This file is generated from sources in nss/gtests/common/wycheproof
 * automatically and should not be touched manually.
 * Generation is trigged by calling python3 genTestVectors.py */

#ifndef dsa_vectors_h__
#define dsa_vectors_h__

#include "testvectors_base/test-structs.h"

static const std::vector<uint8_t> kPubKey0{
    0x30, 0x82, 0x01, 0xb6, 0x30, 0x82, 0x01, 0x2b, 0x06, 0x07, 0x2a, 0x86,
    0x48, 0xce, 0x38, 0x04, 0x01, 0x30, 0x82, 0x01, 0x1e, 0x02, 0x81, 0x81,
    0x00, 0xb3, 0x4c, 0xe9, 0xc1, 0xe7, 0x82, 0x94, 0xd3, 0x25, 0x84, 0x73,
    0x84, 0x20, 0x05, 0xd2, 0xa4, 0x8c, 0x8c, 0x56, 0x6c, 0xfc, 0xa8, 0xf8,
    0x4c, 0x06, 0x06, 0xf2, 0x52, 0x9b, 0x59, 0xa6, 0xd3, 0x8a, 0xae, 0x07,
    0x1b, 0x53, 0xbb, 0x21, 0x67, 0xea, 0xa4, 0xfc, 0x3b, 0x01, 0xfe, 0x17,
    0x6e, 0x78, 0x7e, 0x48, 0x1b, 0x60, 0x37, 0xaa, 0xc6, 0x2c, 0xbc, 0x3d,
    0x08, 0x97, 0x99, 0x53, 0x6a, 0x86, 0x9f, 0xa8, 0xcd, 0xfe, 0xa1, 0xe8,
    0xb1, 0xfd, 0x2d, 0x1c, 0xd3, 0xa3, 0x03, 0x50, 0x85, 0x9a, 0x2c, 0xd6,
    0xb3, 0xec, 0x2f, 0x9b, 0xfb, 0xb6, 0x8b, 0xb1, 0x1b, 0x4b, 0xbe, 0x2a,
    0xda, 0xa1, 0x8d, 0x64, 0xa9, 0x36, 0x39, 0x54, 0x3a, 0xe5, 0xe1, 0x62,
    0x93, 0xe3, 0x11, 0xc0, 0xcf, 0x8c, 0x8d, 0x6e, 0x18, 0x0d, 0xf0, 0x5d,
    0x08, 0xc2, 0xfd, 0x2d, 0x93, 0xd5, 0x70, 0x75, 0x1f, 0x02, 0x15, 0x00,
    0xb9, 0x0b, 0x38, 0xba, 0x0a, 0x50, 0xa4, 0x3e, 0xc6, 0x89, 0x8d, 0x3f,
    0x9b, 0x68, 0x04, 0x97, 0x77, 0xf4, 0x89, 0xb1, 0x02, 0x81, 0x80, 0x08,
    0x35, 0xaa, 0x8c, 0x35, 0x8b, 0xbf, 0x01, 0xa1, 0x84, 0x6d, 0x12, 0x06,
    0x32, 0x3f, 0xab, 0xe4, 0x08, 0xb0, 0xe9, 0x87, 0x89, 0xfc, 0xc6, 0x23,
    0x9d, 0xa1, 0x4d, 0x4b, 0x3f, 0x86, 0xc2, 0x76, 0xa8, 0xf4, 0x8a, 0xa8,
    0x5a, 0x59, 0x50, 0x7e, 0x62, 0x0a, 0xd1, 0xbc, 0x74, 0x5f, 0x0f, 0x1c,
    0xbf, 0x63, 0xec, 0x98, 0xc2, 0x29, 0xc2, 0x61, 0x0d, 0x77, 0xc6, 0x34,
    0xd1, 0x64, 0x2e, 0x40, 0x43, 0x54, 0x77, 0x16, 0x55, 0xb2, 0xd5, 0x66,
    0x2f, 0x7a, 0x45, 0x22, 0x71, 0x78, 0xce, 0x34, 0x30, 0xaf, 0x0f, 0x6b,
    0x3b, 0xb9, 0x4b, 0x52, 0xf7, 0xf5, 0x1e, 0x97, 0xba, 0xd6, 0x59, 0xb1,
    0xba, 0x06, 0x84, 0xe2, 0x08, 0xbe, 0x62, 0x4c, 0x28, 0xd8, 0x2f, 0xb1,
    0x16, 0x2f, 0x18, 0xdd, 0x9d, 0xce, 0x45, 0x21, 0x64, 0x61, 0x65, 0x4c,
    0xf3, 0x37, 0x46, 0x24, 0xd1, 0x5a, 0x8d, 0x03, 0x81, 0x84, 0x00, 0x02,
    0x81, 0x80, 0x17, 0x39, 0x31, 0xdd, 0xa3, 0x1e, 0xff, 0x32, 0xf2, 0x4b,
    0x38, 0x30, 0x91, 0xbf, 0x77, 0xea, 0xcd, 0xc6, 0xef, 0xd5, 0x57, 0x62,
    0x49, 0x11, 0xd8, 0xe9, 0xb9, 0xde, 0xbf, 0x0f, 0x25, 0x6d, 0x0c, 0xff,
    0xac, 0x55, 0x67, 0xb3, 0x3f, 0x6e, 0xaa, 0xe9, 0xd3, 0x27, 0x5b, 0xbe,
    0xd7, 0xef, 0x9f, 0x5f, 0x94, 0xc4, 0x00, 0x3c, 0x95, 0x9e, 0x49, 0xa1,
    0xed, 0x3f, 0x58, 0xc3, 0x1b, 0x21, 0xba, 0xcc, 0xc0, 0xed, 0x88, 0x40,
    0xb4, 0x61, 0x45, 0xf1, 0x21, 0xb8, 0x90, 0x6d, 0x07, 0x21, 0x29, 0xba,
    0xe0, 0x1f, 0x07, 0x19, 0x47, 0x99, 0x7e, 0x8e, 0xf7, 0x60, 0xd2, 0xd9,
    0xea, 0x21, 0xd0, 0x8a, 0x5e, 0xb7, 0xe8, 0x93, 0x90, 0xb2, 0x1a, 0x85,
    0x66, 0x47, 0x13, 0xc5, 0x49, 0xe2, 0x5f, 0xed, 0xa6, 0xe9, 0xe6, 0xc3,
    0x19, 0x70, 0x86, 0x6b, 0xdf, 0xbc, 0x8f, 0xa9, 0x81, 0xf6};

static const std::vector<uint8_t> kPubKey1{
    0x30, 0x82, 0x01, 0xb6, 0x30, 0x82, 0x01, 0x2b, 0x06, 0x07, 0x2a, 0x86,
    0x48, 0xce, 0x38, 0x04, 0x01, 0x30, 0x82, 0x01, 0x1e, 0x02, 0x81, 0x81,
    0x00, 0xb3, 0x4c, 0xe9, 0xc1, 0xe7, 0x82, 0x94, 0xd3, 0x25, 0x84, 0x73,
    0x84, 0x20, 0x05, 0xd2, 0xa4, 0x8c, 0x8c, 0x56, 0x6c, 0xfc, 0xa8, 0xf8,
    0x4c, 0x06, 0x06, 0xf2, 0x52, 0x9b, 0x59, 0xa6, 0xd3, 0x8a, 0xae, 0x07,
    0x1b, 0x53, 0xbb, 0x21, 0x67, 0xea, 0xa4, 0xfc, 0x3b, 0x01, 0xfe, 0x17,
    0x6e, 0x78, 0x7e, 0x48, 0x1b, 0x60, 0x37, 0xaa, 0xc6, 0x2c, 0xbc, 0x3d,
    0x08, 0x97, 0x99, 0x53, 0x6a, 0x86, 0x9f, 0xa8, 0xcd, 0xfe, 0xa1, 0xe8,
    0xb1, 0xfd, 0x2d, 0x1c, 0xd3, 0xa3, 0x03, 0x50, 0x85, 0x9a, 0x2c, 0xd6,
    0xb3, 0xec, 0x2f, 0x9b, 0xfb, 0xb6, 0x8b, 0xb1, 0x1b, 0x4b, 0xbe, 0x2a,
    0xda, 0xa1, 0x8d, 0x64, 0xa9, 0x36, 0x39, 0x54, 0x3a, 0xe5, 0xe1, 0x62,
    0x93, 0xe3, 0x11, 0xc0, 0xcf, 0x8c, 0x8d, 0x6e, 0x18, 0x0d, 0xf0, 0x5d,
    0x08, 0xc2, 0xfd, 0x2d, 0x93, 0xd5, 0x70, 0x75, 0x1f, 0x02, 0x15, 0x00,
    0xb9, 0x0b, 0x38, 0xba, 0x0a, 0x50, 0xa4, 0x3e, 0xc6, 0x89, 0x8d, 0x3f,
    0x9b, 0x68, 0x04, 0x97, 0x77, 0xf4, 0x89, 0xb1, 0x02, 0x81, 0x80, 0x08,
    0x35, 0xaa, 0x8c, 0x35, 0x8b, 0xbf, 0x01, 0xa1, 0x84, 0x6d, 0x12, 0x06,
    0x32, 0x3f, 0xab, 0xe4, 0x08, 0xb0, 0xe9, 0x87, 0x89, 0xfc, 0xc6, 0x23,
    0x9d, 0xa1, 0x4d, 0x4b, 0x3f, 0x86, 0xc2, 0x76, 0xa8, 0xf4, 0x8a, 0xa8,
    0x5a, 0x59, 0x50, 0x7e, 0x62, 0x0a, 0xd1, 0xbc, 0x74, 0x5f, 0x0f, 0x1c,
    0xbf, 0x63, 0xec, 0x98, 0xc2, 0x29, 0xc2, 0x61, 0x0d, 0x77, 0xc6, 0x34,
    0xd1, 0x64, 0x2e, 0x40, 0x43, 0x54, 0x77, 0x16, 0x55, 0xb2, 0xd5, 0x66,
    0x2f, 0x7a, 0x45, 0x22, 0x71, 0x78, 0xce, 0x34, 0x30, 0xaf, 0x0f, 0x6b,
    0x3b, 0xb9, 0x4b, 0x52, 0xf7, 0xf5, 0x1e, 0x97, 0xba, 0xd6, 0x59, 0xb1,
    0xba, 0x06, 0x84, 0xe2, 0x08, 0xbe, 0x62, 0x4c, 0x28, 0xd8, 0x2f, 0xb1,
    0x16, 0x2f, 0x18, 0xdd, 0x9d, 0xce, 0x45, 0x21, 0x64, 0x61, 0x65, 0x4c,
    0xf3, 0x37, 0x46, 0x24, 0xd1, 0x5a, 0x8d, 0x03, 0x81, 0x84, 0x00, 0x02,
    0x81, 0x80, 0x71, 0x3e, 0x9f, 0x81, 0x08, 0xa6, 0xa7, 0x07, 0x54, 0x85,
    0xa3, 0x7c, 0xe1, 0xa3, 0xb0, 0x40, 0xcc, 0xe5, 0x63, 0xa0, 0x44, 0x56,
    0x14, 0xfe, 0x09, 0x9f, 0xb1, 0xbf, 0xfd, 0x68, 0xac, 0xb3, 0x6f, 0x9e,
    0x04, 0xd8, 0xad, 0x17, 0xac, 0xe3, 0xc1, 0x36, 0xda, 0x66, 0xf7, 0x30,
    0xeb, 0x7f, 0xf1, 0x89, 0x36, 0x42, 0x4f, 0xfa, 0x4e, 0x5a, 0xe5, 0xb1,
    0xe7, 0xda, 0xc3, 0x75, 0xd8, 0xd1, 0x64, 0x69, 0x72, 0x54, 0xb8, 0xb7,
    0xe8, 0x48, 0xf5, 0xe7, 0x9d, 0xa2, 0x5c, 0x79, 0xdf, 0x5c, 0x07, 0x27,
    0xd5, 0xda, 0x34, 0x98, 0x40, 0x5c, 0xd0, 0xf4, 0xe4, 0x6d, 0x13, 0x6c,
    0x35, 0x1d, 0x70, 0x3c, 0xc4, 0xbf, 0x0d, 0x3f, 0x4f, 0xbb, 0x16, 0x53,
    0x92, 0x88, 0x86, 0x84, 0x96, 0x4a, 0x93, 0xad, 0x30, 0xfa, 0x17, 0x94,
    0x88, 0xca, 0xd4, 0xa6, 0x65, 0x5d, 0xd4, 0xfa, 0x97, 0x54};

static const std::vector<uint8_t> kPubKey2{
    0x30, 0x82, 0x01, 0xb4, 0x30, 0x82, 0x01, 0x2b, 0x06, 0x07, 0x2a, 0x86,
    0x48, 0xce, 0x38, 0x04, 0x01, 0x30, 0x82, 0x01, 0x1e, 0x02, 0x81, 0x81,
    0x00, 0xb3, 0x4c, 0xe9, 0xc1, 0xe7, 0x82, 0x94, 0xd3, 0x25, 0x84, 0x73,
    0x84, 0x20, 0x05, 0xd2, 0xa4, 0x8c, 0x8c, 0x56, 0x6c, 0xfc, 0xa8, 0xf8,
    0x4c, 0x06, 0x06, 0xf2, 0x52, 0x9b, 0x59, 0xa6, 0xd3, 0x8a, 0xae, 0x07,
    0x1b, 0x53, 0xbb, 0x21, 0x67, 0xea, 0xa4, 0xfc, 0x3b, 0x01, 0xfe, 0x17,
    0x6e, 0x78, 0x7e, 0x48, 0x1b, 0x60, 0x37, 0xaa, 0xc6, 0x2c, 0xbc, 0x3d,
    0x08, 0x97, 0x99, 0x53, 0x6a, 0x86, 0x9f, 0xa8, 0xcd, 0xfe, 0xa1, 0xe8,
    0xb1, 0xfd, 0x2d, 0x1c, 0xd3, 0xa3, 0x03, 0x50, 0x85, 0x9a, 0x2c, 0xd6,
    0xb3, 0xec, 0x2f, 0x9b, 0xfb, 0xb6, 0x8b, 0xb1, 0x1b, 0x4b, 0xbe, 0x2a,
    0xda, 0xa1, 0x8d, 0x64, 0xa9, 0x36, 0x39, 0x54, 0x3a, 0xe5, 0xe1, 0x62,
    0x93, 0xe3, 0x11, 0xc0, 0xcf, 0x8c, 0x8d, 0x6e, 0x18, 0x0d, 0xf0, 0x5d,
    0x08, 0xc2, 0xfd, 0x2d, 0x93, 0xd5, 0x70, 0x75, 0x1f, 0x02, 0x15, 0x00,
    0xb9, 0x0b, 0x38, 0xba, 0x0a, 0x50, 0xa4, 0x3e, 0xc6, 0x89, 0x8d, 0x3f,
    0x9b, 0x68, 0x04, 0x97, 0x77, 0xf4, 0x89, 0xb1, 0x02, 0x81, 0x80, 0x08,
    0x35, 0xaa, 0x8c, 0x35, 0x8b, 0xbf, 0x01, 0xa1, 0x84, 0x6d, 0x12, 0x06,
    0x32, 0x3f, 0xab, 0xe4, 0x08, 0xb0, 0xe9, 0x87, 0x89, 0xfc, 0xc6, 0x23,
    0x9d, 0xa1, 0x4d, 0x4b, 0x3f, 0x86, 0xc2, 0x76, 0xa8, 0xf4, 0x8a, 0xa8,
    0x5a, 0x59, 0x50, 0x7e, 0x62, 0x0a, 0xd1, 0xbc, 0x74, 0x5f, 0x0f, 0x1c,
    0xbf, 0x63, 0xec, 0x98, 0xc2, 0x29, 0xc2, 0x61, 0x0d, 0x77, 0xc6, 0x34,
    0xd1, 0x64, 0x2e, 0x40, 0x43, 0x54, 0x77, 0x16, 0x55, 0xb2, 0xd5, 0x66,
    0x2f, 0x7a, 0x45, 0x22, 0x71, 0x78, 0xce, 0x34, 0x30, 0xaf, 0x0f, 0x6b,
    0x3b, 0xb9, 0x4b, 0x52, 0xf7, 0xf5, 0x1e, 0x97, 0xba, 0xd6, 0x59, 0xb1,
    0xba, 0x06, 0x84, 0xe2, 0x08, 0xbe, 0x62, 0x4c, 0x28, 0xd8, 0x2f, 0xb1,
    0x16, 0x2f, 0x18, 0xdd, 0x9d, 0xce, 0x45, 0x21, 0x64, 0x61, 0x65, 0x4c,
    0xf3, 0x37, 0x46, 0x24, 0xd1, 0x5a, 0x8d, 0x03, 0x81, 0x82, 0x00, 0x02,
    0x7f, 0x61, 0xfe, 0x5b, 0x61, 0xf6, 0xd5, 0x55, 0xad, 0xa7, 0xdc, 0x0e,
    0xba, 0xc3, 0x45, 0x9f, 0xcc, 0xd8, 0xdf, 0xba, 0xd1, 0x8b, 0xa9, 0x4d,
    0xbe, 0xa5, 0x24, 0x37, 0xcd, 0x7f, 0xb4, 0x31, 0xdf, 0x40, 0x4d, 0x47,
    0x38, 0xc5, 0x94, 0xe7, 0x20, 0xa6, 0xd7, 0x86, 0x27, 0x5a, 0xcd, 0x02,
    0x25, 0x9c, 0xa6, 0x13, 0xa0, 0x8a, 0x2d, 0xe1, 0x18, 0xd0, 0x15, 0x0d,
    0x2c, 0xca, 0xe6, 0x02, 0x10, 0x2a, 0xca, 0x0c, 0xd0, 0x36, 0x66, 0xa5,
    0x3f, 0x67, 0xc0, 0xb9, 0x94, 0x3d, 0xf5, 0x04, 0x6c, 0x15, 0xba, 0xea,
    0xf4, 0x96, 0xa9, 0xf0, 0x18, 0xb7, 0xc9, 0x39, 0xde, 0x15, 0x09, 0xde,
    0x71, 0xce, 0x47, 0xdd, 0x6f, 0x44, 0xc5, 0x7f, 0x4e, 0x01, 0xe5, 0x69,
    0xbe, 0x46, 0x93, 0x27, 0x73, 0x19, 0x0c, 0x15, 0x44, 0x70, 0xce, 0xfb,
    0xd1, 0xf4, 0xaf, 0x82, 0xd2, 0x8e, 0x4b, 0x31};

static const std::vector<uint8_t> kPubKey3{
    0x30, 0x82, 0x03, 0x42, 0x30, 0x82, 0x02, 0x35, 0x06, 0x07, 0x2a, 0x86,
    0x48, 0xce, 0x38, 0x04, 0x01, 0x30, 0x82, 0x02, 0x28, 0x02, 0x82, 0x01,
    0x01, 0x00, 0x8f, 0x79, 0x35, 0xd9, 0xb9, 0xaa, 0xe9, 0xbf, 0xab, 0xed,
    0x88, 0x7a, 0xcf, 0x49, 0x51, 0xb6, 0xf3, 0x2e, 0xc5, 0x9e, 0x3b, 0xaf,
    0x37, 0x18, 0xe8, 0xea, 0xc4, 0x96, 0x1f, 0x3e, 0xfd, 0x36, 0x06, 0xe7,
    0x43, 0x51, 0xa9, 0xc4, 0x18, 0x33, 0x39, 0xb8, 0x09, 0xe7, 0xc2, 0xae,
    0x1c, 0x53, 0x9b, 0xa7, 0x47, 0x5b, 0x85, 0xd0, 0x11, 0xad, 0xb8, 0xb4,
    0x79, 0x87, 0x75, 0x49, 0x84, 0x69, 0x5c, 0xac, 0x0e, 0x8f, 0x14, 0xb3,
    0x36, 0x08, 0x28, 0xa2, 0x2f, 0xfa, 0x27, 0x11, 0x0a, 0x3d, 0x62, 0xa9,
    0x93, 0x45, 0x34, 0x09, 0xa0, 0xfe, 0x69, 0x6c, 0x46, 0x58, 0xf8, 0x4b,
    0xdd, 0x20, 0x81, 0x9c, 0x37, 0x09, 0xa0, 0x10, 0x57, 0xb1, 0x95, 0xad,
    0xcd, 0x00, 0x23, 0x3d, 0xba, 0x54, 0x84, 0xb6, 0x29, 0x1f, 0x9d, 0x64,
    0x8e, 0xf8, 0x83, 0x44, 0x86, 0x77, 0x97, 0x9c, 0xec, 0x04, 0xb4, 0x34,
    0xa6, 0xac, 0x2e, 0x75, 0xe9, 0x98, 0x5d, 0xe2, 0x3d, 0xb0, 0x29, 0x2f,
    0xc1, 0x11, 0x8c, 0x9f, 0xfa, 0x9d, 0x81, 0x81, 0xe7, 0x33, 0x8d, 0xb7,
    0x92, 0xb7, 0x30, 0xd7, 0xb9, 0xe3, 0x49, 0x59, 0x2f, 0x68, 0x09, 0x98,
    0x72, 0x15, 0x39, 0x15, 0xea, 0x3d, 0x6b, 0x8b, 0x46, 0x53, 0xc6, 0x33,
    0x45, 0x8f, 0x80, 0x3b, 0x32, 0xa4, 0xc2, 0xe0, 0xf2, 0x72, 0x90, 0x25,
    0x6e, 0x4e, 0x3f, 0x8a, 0x3b, 0x08, 0x38, 0xa1, 0xc4, 0x50, 0xe4, 0xe1,
    0x8c, 0x1a, 0x29, 0xa3, 0x7d, 0xdf, 0x5e, 0xa1, 0x43, 0xde, 0x4b, 0x66,
    0xff, 0x04, 0x90, 0x3e, 0xd5, 0xcf, 0x16, 0x23, 0xe1, 0x58, 0xd4, 0x87,
    0xc6, 0x08, 0xe9, 0x7f, 0x21, 0x1c, 0xd8, 0x1d, 0xca, 0x23, 0xcb, 0x6e,
    0x38, 0x07, 0x65, 0xf8, 0x22, 0xe3, 0x42, 0xbe, 0x48, 0x4c, 0x05, 0x76,
    0x39, 0x39, 0x60, 0x1c, 0xd6, 0x67, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96,
    0xa6, 0x85, 0x78, 0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7,
    0x85, 0xef, 0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69,
    0x5d, 0x02, 0x82, 0x01, 0x00, 0x16, 0xa6, 0x5c, 0x58, 0x20, 0x48, 0x50,
    0x70, 0x4e, 0x75, 0x02, 0xa3, 0x97, 0x57, 0x04, 0x0d, 0x34, 0xda, 0x3a,
    0x34, 0x78, 0xc1, 0x54, 0xd4, 0xe4, 0xa5, 0xc0, 0x2d, 0x24, 0x2e, 0xe0,
    0x4f, 0x96, 0xe6, 0x1e, 0x4b, 0xd0, 0x90, 0x4a, 0xbd, 0xac, 0x8f, 0x37,
    0xee, 0xb1, 0xe0, 0x9f, 0x31, 0x82, 0xd2, 0x3c, 0x90, 0x43, 0xcb, 0x64,
    0x2f, 0x88, 0x00, 0x41, 0x60, 0xed, 0xf9, 0xca, 0x09, 0xb3, 0x20, 0x76,
    0xa7, 0x9c, 0x32, 0xa6, 0x27, 0xf2, 0x47, 0x3e, 0x91, 0x87, 0x9b, 0xa2,
    0xc4, 0xe7, 0x44, 0xbd, 0x20, 0x81, 0x54, 0x4c, 0xb5, 0x5b, 0x80, 0x2c,
    0x36, 0x8d, 0x1f, 0xa8, 0x3e, 0xd4, 0x89, 0xe9, 0x4e, 0x0f, 0xa0, 0x68,
    0x8e, 0x32, 0x42, 0x8a, 0x5c, 0x78, 0xc4, 0x78, 0xc6, 0x8d, 0x05, 0x27,
    0xb7, 0x1c, 0x9a, 0x3a, 0xbb, 0x0b, 0x0b, 0xe1, 0x2c, 0x44, 0x68, 0x96,
    0x39, 0xe7, 0xd3, 0xce, 0x74, 0xdb, 0x10, 0x1a, 0x65, 0xaa, 0x2b, 0x87,
    0xf6, 0x4c, 0x68, 0x26, 0xdb, 0x3e, 0xc7, 0x2f, 0x4b, 0x55, 0x99, 0x83,
    0x4b, 0xb4, 0xed, 0xb0, 0x2f, 0x7c, 0x90, 0xe9, 0xa4, 0x96, 0xd3, 0xa5,
    0x5d, 0x53, 0x5b, 0xeb, 0xfc, 0x45, 0xd4, 0xf6, 0x19, 0xf6, 0x3f, 0x3d,
    0xed, 0xbb, 0x87, 0x39, 0x25, 0xc2, 0xf2, 0x24, 0xe0, 0x77, 0x31, 0x29,
    0x6d, 0xa8, 0x87, 0xec, 0x1e, 0x47, 0x48, 0xf8, 0x7e, 0xfb, 0x5f, 0xde,
    0xb7, 0x54, 0x84, 0x31, 0x6b, 0x22, 0x32, 0xde, 0xe5, 0x53, 0xdd, 0xaf,
    0x02, 0x11, 0x2b, 0x0d, 0x1f, 0x02, 0xda, 0x30, 0x97, 0x32, 0x24, 0xfe,
    0x27, 0xae, 0xda, 0x8b, 0x9d, 0x4b, 0x29, 0x22, 0xd9, 0xba, 0x8b, 0xe3,
    0x9e, 0xd9, 0xe1, 0x03, 0xa6, 0x3c, 0x52, 0x81, 0x0b, 0xc6, 0x88, 0xb7,
    0xe2, 0xed, 0x43, 0x16, 0xe1, 0xef, 0x17, 0xdb, 0xde, 0x03, 0x82, 0x01,
    0x05, 0x00, 0x02, 0x82, 0x01, 0x00, 0x1e, 0x77, 0xf8, 0x42, 0xb1, 0xae,
    0x0f, 0xcd, 0x99, 0x29, 0xd3, 0x94, 0x16, 0x1d, 0x41, 0xe1, 0x46, 0x14,
    0xff, 0x75, 0x07, 0xa9, 0xa3, 0x1f, 0x4a, 0x1f, 0x14, 0xd2, 0x2e, 0x2a,
    0x62, 0x7a, 0x1f, 0x4e, 0x59, 0x66, 0x24, 0x88, 0x3f, 0x1a, 0x5b, 0x16,
    0x8e, 0x94, 0x25, 0x14, 0x6f, 0x22, 0xd5, 0xf6, 0xee, 0x28, 0x75, 0x74,
    0x14, 0x71, 0x4b, 0xb9, 0x94, 0xba, 0x11, 0x29, 0xf0, 0x15, 0xd6, 0xe0,
    0x4a, 0x71, 0x7e, 0xdf, 0x9b, 0x53, 0x0a, 0x5d, 0x5c, 0xab, 0x94, 0xf1,
    0x46, 0x31, 0xe8, 0xb4, 0xcf, 0x79, 0xae, 0xb3, 0x58, 0xcc, 0x74, 0x18,
    0x45, 0x55, 0x38, 0x41, 0xe8, 0xac, 0x46, 0x16, 0x30, 0xe8, 0x04, 0xa6,
    0x2f, 0x43, 0x67, 0x6b, 0xa6, 0x79, 0x4a, 0xf6, 0x68, 0x99, 0xc3, 0x77,
    0xb8, 0x69, 0xea, 0x61, 0x2a, 0x7b, 0x9f, 0xe6, 0x61, 0x1a, 0xa9, 0x6b,
    0xe5, 0x2e, 0xb8, 0xb6, 0x2c, 0x97, 0x91, 0x17, 0xbb, 0xbc, 0xca, 0x8a,
    0x7e, 0xc1, 0xe1, 0xff, 0xab, 0x1c, 0x7d, 0xfc, 0xfc, 0x70, 0x48, 0x70,
    0x0d, 0x3a, 0xe3, 0x85, 0x81, 0x36, 0xe8, 0x97, 0x70, 0x1d, 0x7c, 0x29,
    0x21, 0xb5, 0xdf, 0xef, 0x1d, 0x1f, 0x89, 0x7f, 0x50, 0xd9, 0x6c, 0xa1,
    0xb5, 0xc2, 0xed, 0xc5, 0x8c, 0xad, 0xa1, 0x89, 0x19, 0xe3, 0x56, 0x42,
    0xf0, 0x80, 0x7e, 0xeb, 0xfa, 0x00, 0xc9, 0x9a, 0x32, 0xf4, 0xd0, 0x95,
    0xc3, 0x18, 0x8f, 0x78, 0xed, 0x54, 0x71, 0x1b, 0xe0, 0x32, 0x5c, 0x4b,
    0x53, 0x2a, 0xec, 0xcd, 0x65, 0x40, 0xa5, 0x67, 0xc3, 0x27, 0x22, 0x54,
    0x40, 0xea, 0x15, 0x31, 0x9b, 0xde, 0x06, 0x51, 0x04, 0x79, 0xa1, 0x86,
    0x17, 0x99, 0xe2, 0x5b, 0x57, 0xde, 0xcc, 0x73, 0xc0, 0x36, 0xd7, 0x5a,
    0x07, 0x02, 0xbd, 0x37, 0x3c, 0xa2, 0x31, 0x34, 0x99, 0x31};

static const std::vector<uint8_t> kPubKey4{
    0x30, 0x82, 0x03, 0x42, 0x30, 0x82, 0x02, 0x35, 0x06, 0x07, 0x2a, 0x86,
    0x48, 0xce, 0x38, 0x04, 0x01, 0x30, 0x82, 0x02, 0x28, 0x02, 0x82, 0x01,
    0x01, 0x00, 0x8f, 0x79, 0x35, 0xd9, 0xb9, 0xaa, 0xe9, 0xbf, 0xab, 0xed,
    0x88, 0x7a, 0xcf, 0x49, 0x51, 0xb6, 0xf3, 0x2e, 0xc5, 0x9e, 0x3b, 0xaf,
    0x37, 0x18, 0xe8, 0xea, 0xc4, 0x96, 0x1f, 0x3e, 0xfd, 0x36, 0x06, 0xe7,
    0x43, 0x51, 0xa9, 0xc4, 0x18, 0x33, 0x39, 0xb8, 0x09, 0xe7, 0xc2, 0xae,
    0x1c, 0x53, 0x9b, 0xa7, 0x47, 0x5b, 0x85, 0xd0, 0x11, 0xad, 0xb8, 0xb4,
    0x79, 0x87, 0x75, 0x49, 0x84, 0x69, 0x5c, 0xac, 0x0e, 0x8f, 0x14, 0xb3,
    0x36, 0x08, 0x28, 0xa2, 0x2f, 0xfa, 0x27, 0x11, 0x0a, 0x3d, 0x62, 0xa9,
    0x93, 0x45, 0x34, 0x09, 0xa0, 0xfe, 0x69, 0x6c, 0x46, 0x58, 0xf8, 0x4b,
    0xdd, 0x20, 0x81, 0x9c, 0x37, 0x09, 0xa0, 0x10, 0x57, 0xb1, 0x95, 0xad,
    0xcd, 0x00, 0x23, 0x3d, 0xba, 0x54, 0x84, 0xb6, 0x29, 0x1f, 0x9d, 0x64,
    0x8e, 0xf8, 0x83, 0x44, 0x86, 0x77, 0x97, 0x9c, 0xec, 0x04, 0xb4, 0x34,
    0xa6, 0xac, 0x2e, 0x75, 0xe9, 0x98, 0x5d, 0xe2, 0x3d, 0xb0, 0x29, 0x2f,
    0xc1, 0x11, 0x8c, 0x9f, 0xfa, 0x9d, 0x81, 0x81, 0xe7, 0x33, 0x8d, 0xb7,
    0x92, 0xb7, 0x30, 0xd7, 0xb9, 0xe3, 0x49, 0x59, 0x2f, 0x68, 0x09, 0x98,
    0x72, 0x15, 0x39, 0x15, 0xea, 0x3d, 0x6b, 0x8b, 0x46, 0x53, 0xc6, 0x33,
    0x45, 0x8f, 0x80, 0x3b, 0x32, 0xa4, 0xc2, 0xe0, 0xf2, 0x72, 0x90, 0x25,
    0x6e, 0x4e, 0x3f, 0x8a, 0x3b, 0x08, 0x38, 0xa1, 0xc4, 0x50, 0xe4, 0xe1,
    0x8c, 0x1a, 0x29, 0xa3, 0x7d, 0xdf, 0x5e, 0xa1, 0x43, 0xde, 0x4b, 0x66,
    0xff, 0x04, 0x90, 0x3e, 0xd5, 0xcf, 0x16, 0x23, 0xe1, 0x58, 0xd4, 0x87,
    0xc6, 0x08, 0xe9, 0x7f, 0x21, 0x1c, 0xd8, 0x1d, 0xca, 0x23, 0xcb, 0x6e,
    0x38, 0x07, 0x65, 0xf8, 0x22, 0xe3, 0x42, 0xbe, 0x48, 0x4c, 0x05, 0x76,
    0x39, 0x39, 0x60, 0x1c, 0xd6, 0x67, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96,
    0xa6, 0x85, 0x78, 0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7,
    0x85, 0xef, 0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69,
    0x5d, 0x02, 0x82, 0x01, 0x00, 0x16, 0xa6, 0x5c, 0x58, 0x20, 0x48, 0x50,
    0x70, 0x4e, 0x75, 0x02, 0xa3, 0x97, 0x57, 0x04, 0x0d, 0x34, 0xda, 0x3a,
    0x34, 0x78, 0xc1, 0x54, 0xd4, 0xe4, 0xa5, 0xc0, 0x2d, 0x24, 0x2e, 0xe0,
    0x4f, 0x96, 0xe6, 0x1e, 0x4b, 0xd0, 0x90, 0x4a, 0xbd, 0xac, 0x8f, 0x37,
    0xee, 0xb1, 0xe0, 0x9f, 0x31, 0x82, 0xd2, 0x3c, 0x90, 0x43, 0xcb, 0x64,
    0x2f, 0x88, 0x00, 0x41, 0x60, 0xed, 0xf9, 0xca, 0x09, 0xb3, 0x20, 0x76,
    0xa7, 0x9c, 0x32, 0xa6, 0x27, 0xf2, 0x47, 0x3e, 0x91, 0x87, 0x9b, 0xa2,
    0xc4, 0xe7, 0x44, 0xbd, 0x20, 0x81, 0x54, 0x4c, 0xb5, 0x5b, 0x80, 0x2c,
    0x36, 0x8d, 0x1f, 0xa8, 0x3e, 0xd4, 0x89, 0xe9, 0x4e, 0x0f, 0xa0, 0x68,
    0x8e, 0x32, 0x42, 0x8a, 0x5c, 0x78, 0xc4, 0x78, 0xc6, 0x8d, 0x05, 0x27,
    0xb7, 0x1c, 0x9a, 0x3a, 0xbb, 0x0b, 0x0b, 0xe1, 0x2c, 0x44, 0x68, 0x96,
    0x39, 0xe7, 0xd3, 0xce, 0x74, 0xdb, 0x10, 0x1a, 0x65, 0xaa, 0x2b, 0x87,
    0xf6, 0x4c, 0x68, 0x26, 0xdb, 0x3e, 0xc7, 0x2f, 0x4b, 0x55, 0x99, 0x83,
    0x4b, 0xb4, 0xed, 0xb0, 0x2f, 0x7c, 0x90, 0xe9, 0xa4, 0x96, 0xd3, 0xa5,
    0x5d, 0x53, 0x5b, 0xeb, 0xfc, 0x45, 0xd4, 0xf6, 0x19, 0xf6, 0x3f, 0x3d,
    0xed, 0xbb, 0x87, 0x39, 0x25, 0xc2, 0xf2, 0x24, 0xe0, 0x77, 0x31, 0x29,
    0x6d, 0xa8, 0x87, 0xec, 0x1e, 0x47, 0x48, 0xf8, 0x7e, 0xfb, 0x5f, 0xde,
    0xb7, 0x54, 0x84, 0x31, 0x6b, 0x22, 0x32, 0xde, 0xe5, 0x53, 0xdd, 0xaf,
    0x02, 0x11, 0x2b, 0x0d, 0x1f, 0x02, 0xda, 0x30, 0x97, 0x32, 0x24, 0xfe,
    0x27, 0xae, 0xda, 0x8b, 0x9d, 0x4b, 0x29, 0x22, 0xd9, 0xba, 0x8b, 0xe3,
    0x9e, 0xd9, 0xe1, 0x03, 0xa6, 0x3c, 0x52, 0x81, 0x0b, 0xc6, 0x88, 0xb7,
    0xe2, 0xed, 0x43, 0x16, 0xe1, 0xef, 0x17, 0xdb, 0xde, 0x03, 0x82, 0x01,
    0x05, 0x00, 0x02, 0x82, 0x01, 0x00, 0x69, 0x78, 0xb6, 0x8d, 0x31, 0x33,
    0x4e, 0xe5, 0xbc, 0x7b, 0x3e, 0x91, 0xab, 0x6c, 0x23, 0x36, 0xfa, 0xb4,
    0x5c, 0x64, 0x83, 0x6b, 0xd9, 0x2c, 0xb5, 0x33, 0x7b, 0x73, 0x4d, 0xb9,
    0xe8, 0xe4, 0x4f, 0x88, 0x9f, 0x88, 0x69, 0x82, 0x9f, 0x4f, 0xe1, 0x74,
    0xdc, 0x93, 0x44, 0xc1, 0x64, 0xa0, 0xba, 0x5b, 0x01, 0x26, 0x25, 0x9b,
    0xa8, 0xa4, 0x3f, 0x60, 0x75, 0x64, 0xfa, 0x4a, 0x1d, 0x0d, 0x49, 0x64,
    0x5e, 0x1d, 0x58, 0x86, 0xa1, 0xfc, 0x48, 0x5e, 0x2f, 0xe9, 0x1e, 0x56,
    0xea, 0xe3, 0x30, 0xda, 0x05, 0xe1, 0x7b, 0x0b, 0x3d, 0x01, 0x8c, 0x29,
    0x02, 0x85, 0xb2, 0x49, 0xbc, 0x40, 0x9e, 0x7a, 0xf5, 0x43, 0x00, 0xfc,
    0x7c, 0x3e, 0xb3, 0x49, 0x11, 0x45, 0x7e, 0x23, 0x71, 0x93, 0x1a, 0xd9,
    0x30, 0x2e, 0x84, 0x50, 0xcd, 0x95, 0xdf, 0x3d, 0x56, 0x1e, 0xa0, 0xad,
    0x94, 0xd0, 0xa2, 0xea, 0xbc, 0xaf, 0xe0, 0xdd, 0x67, 0x28, 0xfb, 0x28,
    0x00, 0x29, 0xb5, 0x56, 0xd9, 0xf4, 0xfa, 0x7c, 0x0f, 0x46, 0xa7, 0x80,
    0x43, 0x29, 0x93, 0x67, 0x08, 0xe9, 0x7e, 0x11, 0xfc, 0x22, 0xb2, 0xa5,
    0x07, 0x61, 0xa8, 0x90, 0xc6, 0x5b, 0x5f, 0xea, 0x2a, 0x1a, 0x41, 0x72,
    0xf6, 0xbe, 0x9e, 0xaa, 0x60, 0xe7, 0x38, 0xcd, 0xf6, 0x0c, 0x01, 0x51,
    0x42, 0xe2, 0xe5, 0x62, 0xbb, 0x62, 0xa1, 0x1e, 0x81, 0x0c, 0xcd, 0xf0,
    0xbf, 0x63, 0x33, 0x07, 0x38, 0x2f, 0x2d, 0x9a, 0x97, 0x69, 0xb1, 0x15,
    0xdf, 0xcd, 0xab, 0x4b, 0xac, 0xae, 0x73, 0xfe, 0xca, 0x28, 0x9d, 0xb2,
    0x09, 0xdc, 0xe3, 0x4c, 0xbe, 0x12, 0x6e, 0x8c, 0x7f, 0x9d, 0x9e, 0x4f,
    0x8f, 0x71, 0x13, 0x49, 0xa6, 0x08, 0xd5, 0x67, 0xb4, 0x8c, 0x05, 0x0e,
    0x9d, 0xfb, 0x32, 0xbc, 0x18, 0x4e, 0xca, 0xa4, 0xf0, 0xf0};

static const std::vector<uint8_t> kPubKey5{
    0x30, 0x82, 0x03, 0x42, 0x30, 0x82, 0x02, 0x35, 0x06, 0x07, 0x2a, 0x86,
    0x48, 0xce, 0x38, 0x04, 0x01, 0x30, 0x82, 0x02, 0x28, 0x02, 0x82, 0x01,
    0x01, 0x00, 0x8f, 0x79, 0x35, 0xd9, 0xb9, 0xaa, 0xe9, 0xbf, 0xab, 0xed,
    0x88, 0x7a, 0xcf, 0x49, 0x51, 0xb6, 0xf3, 0x2e, 0xc5, 0x9e, 0x3b, 0xaf,
    0x37, 0x18, 0xe8, 0xea, 0xc4, 0x96, 0x1f, 0x3e, 0xfd, 0x36, 0x06, 0xe7,
    0x43, 0x51, 0xa9, 0xc4, 0x18, 0x33, 0x39, 0xb8, 0x09, 0xe7, 0xc2, 0xae,
    0x1c, 0x53, 0x9b, 0xa7, 0x47, 0x5b, 0x85, 0xd0, 0x11, 0xad, 0xb8, 0xb4,
    0x79, 0x87, 0x75, 0x49, 0x84, 0x69, 0x5c, 0xac, 0x0e, 0x8f, 0x14, 0xb3,
    0x36, 0x08, 0x28, 0xa2, 0x2f, 0xfa, 0x27, 0x11, 0x0a, 0x3d, 0x62, 0xa9,
    0x93, 0x45, 0x34, 0x09, 0xa0, 0xfe, 0x69, 0x6c, 0x46, 0x58, 0xf8, 0x4b,
    0xdd, 0x20, 0x81, 0x9c, 0x37, 0x09, 0xa0, 0x10, 0x57, 0xb1, 0x95, 0xad,
    0xcd, 0x00, 0x23, 0x3d, 0xba, 0x54, 0x84, 0xb6, 0x29, 0x1f, 0x9d, 0x64,
    0x8e, 0xf8, 0x83, 0x44, 0x86, 0x77, 0x97, 0x9c, 0xec, 0x04, 0xb4, 0x34,
    0xa6, 0xac, 0x2e, 0x75, 0xe9, 0x98, 0x5d, 0xe2, 0x3d, 0xb0, 0x29, 0x2f,
    0xc1, 0x11, 0x8c, 0x9f, 0xfa, 0x9d, 0x81, 0x81, 0xe7, 0x33, 0x8d, 0xb7,
    0x92, 0xb7, 0x30, 0xd7, 0xb9, 0xe3, 0x49, 0x59, 0x2f, 0x68, 0x09, 0x98,
    0x72, 0x15, 0x39, 0x15, 0xea, 0x3d, 0x6b, 0x8b, 0x46, 0x53, 0xc6, 0x33,
    0x45, 0x8f, 0x80, 0x3b, 0x32, 0xa4, 0xc2, 0xe0, 0xf2, 0x72, 0x90, 0x25,
    0x6e, 0x4e, 0x3f, 0x8a, 0x3b, 0x08, 0x38, 0xa1, 0xc4, 0x50, 0xe4, 0xe1,
    0x8c, 0x1a, 0x29, 0xa3, 0x7d, 0xdf, 0x5e, 0xa1, 0x43, 0xde, 0x4b, 0x66,
    0xff, 0x04, 0x90, 0x3e, 0xd5, 0xcf, 0x16, 0x23, 0xe1, 0x58, 0xd4, 0x87,
    0xc6, 0x08, 0xe9, 0x7f, 0x21, 0x1c, 0xd8, 0x1d, 0xca, 0x23, 0xcb, 0x6e,
    0x38, 0x07, 0x65, 0xf8, 0x22, 0xe3, 0x42, 0xbe, 0x48, 0x4c, 0x05, 0x76,
    0x39, 0x39, 0x60, 0x1c, 0xd6, 0x67, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96,
    0xa6, 0x85, 0x78, 0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7,
    0x85, 0xef, 0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69,
    0x5d, 0x02, 0x82, 0x01, 0x00, 0x16, 0xa6, 0x5c, 0x58, 0x20, 0x48, 0x50,
    0x70, 0x4e, 0x75, 0x02, 0xa3, 0x97, 0x57, 0x04, 0x0d, 0x34, 0xda, 0x3a,
    0x34, 0x78, 0xc1, 0x54, 0xd4, 0xe4, 0xa5, 0xc0, 0x2d, 0x24, 0x2e, 0xe0,
    0x4f, 0x96, 0xe6, 0x1e, 0x4b, 0xd0, 0x90, 0x4a, 0xbd, 0xac, 0x8f, 0x37,
    0xee, 0xb1, 0xe0, 0x9f, 0x31, 0x82, 0xd2, 0x3c, 0x90, 0x43, 0xcb, 0x64,
    0x2f, 0x88, 0x00, 0x41, 0x60, 0xed, 0xf9, 0xca, 0x09, 0xb3, 0x20, 0x76,
    0xa7, 0x9c, 0x32, 0xa6, 0x27, 0xf2, 0x47, 0x3e, 0x91, 0x87, 0x9b, 0xa2,
    0xc4, 0xe7, 0x44, 0xbd, 0x20, 0x81, 0x54, 0x4c, 0xb5, 0x5b, 0x80, 0x2c,
    0x36, 0x8d, 0x1f, 0xa8, 0x3e, 0xd4, 0x89, 0xe9, 0x4e, 0x0f, 0xa0, 0x68,
    0x8e, 0x32, 0x42, 0x8a, 0x5c, 0x78, 0xc4, 0x78, 0xc6, 0x8d, 0x05, 0x27,
    0xb7, 0x1c, 0x9a, 0x3a, 0xbb, 0x0b, 0x0b, 0xe1, 0x2c, 0x44, 0x68, 0x96,
    0x39, 0xe7, 0xd3, 0xce, 0x74, 0xdb, 0x10, 0x1a, 0x65, 0xaa, 0x2b, 0x87,
    0xf6, 0x4c, 0x68, 0x26, 0xdb, 0x3e, 0xc7, 0x2f, 0x4b, 0x55, 0x99, 0x83,
    0x4b, 0xb4, 0xed, 0xb0, 0x2f, 0x7c, 0x90, 0xe9, 0xa4, 0x96, 0xd3, 0xa5,
    0x5d, 0x53, 0x5b, 0xeb, 0xfc, 0x45, 0xd4, 0xf6, 0x19, 0xf6, 0x3f, 0x3d,
    0xed, 0xbb, 0x87, 0x39, 0x25, 0xc2, 0xf2, 0x24, 0xe0, 0x77, 0x31, 0x29,
    0x6d, 0xa8, 0x87, 0xec, 0x1e, 0x47, 0x48, 0xf8, 0x7e, 0xfb, 0x5f, 0xde,
    0xb7, 0x54, 0x84, 0x31, 0x6b, 0x22, 0x32, 0xde, 0xe5, 0x53, 0xdd, 0xaf,
    0x02, 0x11, 0x2b, 0x0d, 0x1f, 0x02, 0xda, 0x30, 0x97, 0x32, 0x24, 0xfe,
    0x27, 0xae, 0xda, 0x8b, 0x9d, 0x4b, 0x29, 0x22, 0xd9, 0xba, 0x8b, 0xe3,
    0x9e, 0xd9, 0xe1, 0x03, 0xa6, 0x3c, 0x52, 0x81, 0x0b, 0xc6, 0x88, 0xb7,
    0xe2, 0xed, 0x43, 0x16, 0xe1, 0xef, 0x17, 0xdb, 0xde, 0x03, 0x82, 0x01,
    0x05, 0x00, 0x02, 0x82, 0x01, 0x00, 0x2a, 0x64, 0x95, 0x3b, 0xde, 0x40,
    0x78, 0x9f, 0x80, 0xed, 0x82, 0x27, 0x19, 0x22, 0x86, 0x11, 0x5b, 0x92,
    0xd0, 0x9d, 0x5d, 0xe9, 0x69, 0x04, 0xe8, 0x03, 0xec, 0x4e, 0xcf, 0xbd,
    0x73, 0xe0, 0xf0, 0x8e, 0x82, 0x91, 0x0f, 0xeb, 0xf1, 0x9f, 0xa3, 0xcd,
    0xc5, 0x5f, 0xf2, 0x0e, 0xb9, 0x70, 0xd9, 0xc7, 0x12, 0xf4, 0x47, 0x85,
    0xc0, 0xfd, 0x59, 0x2c, 0x17, 0xfb, 0x43, 0xf4, 0x62, 0x53, 0x57, 0xa4,
    0xac, 0x8a, 0x1a, 0x62, 0x8f, 0x72, 0x04, 0x0a, 0xe5, 0x36, 0x08, 0x39,
    0xc7, 0xc1, 0xf6, 0xb2, 0x14, 0xe7, 0xa1, 0x55, 0x30, 0xfe, 0x22, 0x88,
    0x71, 0x39, 0xea, 0x0f, 0x05, 0xa9, 0xda, 0xf9, 0xd9, 0x5b, 0xd6, 0xb7,
    0x46, 0x7a, 0xbf, 0x91, 0x07, 0xc9, 0xfb, 0xe3, 0x1e, 0x36, 0x33, 0x02,
    0x76, 0xee, 0xcc, 0xce, 0x3d, 0x59, 0x63, 0x52, 0x06, 0xd6, 0x0c, 0xa2,
    0x56, 0xf9, 0xaf, 0x60, 0x62, 0x76, 0x26, 0xb0, 0x59, 0x49, 0x84, 0xb5,
    0xa0, 0x75, 0xc4, 0x2c, 0x42, 0x06, 0x7f, 0xa8, 0xc3, 0x30, 0xf2, 0x58,
    0xbc, 0xf1, 0x45, 0xdf, 0x27, 0xa9, 0x7d, 0xa8, 0xee, 0x41, 0x9b, 0x54,
    0xe3, 0xab, 0x29, 0x6c, 0x7c, 0xe9, 0xef, 0x6a, 0x01, 0x13, 0x38, 0x9b,
    0x3c, 0xac, 0x78, 0x85, 0xb4, 0x4b, 0x37, 0x22, 0xd2, 0x7c, 0xad, 0x60,
    0xe4, 0xe5, 0xa9, 0x24, 0xa1, 0xed, 0x03, 0x42, 0xce, 0xa9, 0xe9, 0x92,
    0x56, 0xf6, 0xbc, 0x13, 0x08, 0xd4, 0xaf, 0x2c, 0x0a, 0xf9, 0x37, 0x9b,
    0x1c, 0xf2, 0x11, 0x9c, 0xe1, 0x13, 0xc0, 0x85, 0x70, 0x5f, 0x55, 0x19,
    0xcc, 0xc1, 0xba, 0x85, 0x62, 0xa2, 0x23, 0x61, 0x90, 0xd3, 0xf0, 0xc0,
    0xa1, 0x0f, 0x01, 0x46, 0x6a, 0xd7, 0x9a, 0x48, 0x12, 0x7c, 0x28, 0x43,
    0x3f, 0x6b, 0x34, 0xe2, 0x4a, 0x53, 0x9a, 0xf6, 0x0f, 0x3d};

static const std::vector<uint8_t> kPubKey6{
    0x30, 0x82, 0x03, 0x43, 0x30, 0x82, 0x02, 0x35, 0x06, 0x07, 0x2a, 0x86,
    0x48, 0xce, 0x38, 0x04, 0x01, 0x30, 0x82, 0x02, 0x28, 0x02, 0x82, 0x01,
    0x01, 0x00, 0x8f, 0x79, 0x35, 0xd9, 0xb9, 0xaa, 0xe9, 0xbf, 0xab, 0xed,
    0x88, 0x7a, 0xcf, 0x49, 0x51, 0xb6, 0xf3, 0x2e, 0xc5, 0x9e, 0x3b, 0xaf,
    0x37, 0x18, 0xe8, 0xea, 0xc4, 0x96, 0x1f, 0x3e, 0xfd, 0x36, 0x06, 0xe7,
    0x43, 0x51, 0xa9, 0xc4, 0x18, 0x33, 0x39, 0xb8, 0x09, 0xe7, 0xc2, 0xae,
    0x1c, 0x53, 0x9b, 0xa7, 0x47, 0x5b, 0x85, 0xd0, 0x11, 0xad, 0xb8, 0xb4,
    0x79, 0x87, 0x75, 0x49, 0x84, 0x69, 0x5c, 0xac, 0x0e, 0x8f, 0x14, 0xb3,
    0x36, 0x08, 0x28, 0xa2, 0x2f, 0xfa, 0x27, 0x11, 0x0a, 0x3d, 0x62, 0xa9,
    0x93, 0x45, 0x34, 0x09, 0xa0, 0xfe, 0x69, 0x6c, 0x46, 0x58, 0xf8, 0x4b,
    0xdd, 0x20, 0x81, 0x9c, 0x37, 0x09, 0xa0, 0x10, 0x57, 0xb1, 0x95, 0xad,
    0xcd, 0x00, 0x23, 0x3d, 0xba, 0x54, 0x84, 0xb6, 0x29, 0x1f, 0x9d, 0x64,
    0x8e, 0xf8, 0x83, 0x44, 0x86, 0x77, 0x97, 0x9c, 0xec, 0x04, 0xb4, 0x34,
    0xa6, 0xac, 0x2e, 0x75, 0xe9, 0x98, 0x5d, 0xe2, 0x3d, 0xb0, 0x29, 0x2f,
    0xc1, 0x11, 0x8c, 0x9f, 0xfa, 0x9d, 0x81, 0x81, 0xe7, 0x33, 0x8d, 0xb7,
    0x92, 0xb7, 0x30, 0xd7, 0xb9, 0xe3, 0x49, 0x59, 0x2f, 0x68, 0x09, 0x98,
    0x72, 0x15, 0x39, 0x15, 0xea, 0x3d, 0x6b, 0x8b, 0x46, 0x53, 0xc6, 0x33,
    0x45, 0x8f, 0x80, 0x3b, 0x32, 0xa4, 0xc2, 0xe0, 0xf2, 0x72, 0x90, 0x25,
    0x6e, 0x4e, 0x3f, 0x8a, 0x3b, 0x08, 0x38, 0xa1, 0xc4, 0x50, 0xe4, 0xe1,
    0x8c, 0x1a, 0x29, 0xa3, 0x7d, 0xdf, 0x5e, 0xa1, 0x43, 0xde, 0x4b, 0x66,
    0xff, 0x04, 0x90, 0x3e, 0xd5, 0xcf, 0x16, 0x23, 0xe1, 0x58, 0xd4, 0x87,
    0xc6, 0x08, 0xe9, 0x7f, 0x21, 0x1c, 0xd8, 0x1d, 0xca, 0x23, 0xcb, 0x6e,
    0x38, 0x07, 0x65, 0xf8, 0x22, 0xe3, 0x42, 0xbe, 0x48, 0x4c, 0x05, 0x76,
    0x39, 0x39, 0x60, 0x1c, 0xd6, 0x67, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96,
    0xa6, 0x85, 0x78, 0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7,
    0x85, 0xef, 0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69,
    0x5d, 0x02, 0x82, 0x01, 0x00, 0x16, 0xa6, 0x5c, 0x58, 0x20, 0x48, 0x50,
    0x70, 0x4e, 0x75, 0x02, 0xa3, 0x97, 0x57, 0x04, 0x0d, 0x34, 0xda, 0x3a,
    0x34, 0x78, 0xc1, 0x54, 0xd4, 0xe4, 0xa5, 0xc0, 0x2d, 0x24, 0x2e, 0xe0,
    0x4f, 0x96, 0xe6, 0x1e, 0x4b, 0xd0, 0x90, 0x4a, 0xbd, 0xac, 0x8f, 0x37,
    0xee, 0xb1, 0xe0, 0x9f, 0x31, 0x82, 0xd2, 0x3c, 0x90, 0x43, 0xcb, 0x64,
    0x2f, 0x88, 0x00, 0x41, 0x60, 0xed, 0xf9, 0xca, 0x09, 0xb3, 0x20, 0x76,
    0xa7, 0x9c, 0x32, 0xa6, 0x27, 0xf2, 0x47, 0x3e, 0x91, 0x87, 0x9b, 0xa2,
    0xc4, 0xe7, 0x44, 0xbd, 0x20, 0x81, 0x54, 0x4c, 0xb5, 0x5b, 0x80, 0x2c,
    0x36, 0x8d, 0x1f, 0xa8, 0x3e, 0xd4, 0x89, 0xe9, 0x4e, 0x0f, 0xa0, 0x68,
    0x8e, 0x32, 0x42, 0x8a, 0x5c, 0x78, 0xc4, 0x78, 0xc6, 0x8d, 0x05, 0x27,
    0xb7, 0x1c, 0x9a, 0x3a, 0xbb, 0x0b, 0x0b, 0xe1, 0x2c, 0x44, 0x68, 0x96,
    0x39, 0xe7, 0xd3, 0xce, 0x74, 0xdb, 0x10, 0x1a, 0x65, 0xaa, 0x2b, 0x87,
    0xf6, 0x4c, 0x68, 0x26, 0xdb, 0x3e, 0xc7, 0x2f, 0x4b, 0x55, 0x99, 0x83,
    0x4b, 0xb4, 0xed, 0xb0, 0x2f, 0x7c, 0x90, 0xe9, 0xa4, 0x96, 0xd3, 0xa5,
    0x5d, 0x53, 0x5b, 0xeb, 0xfc, 0x45, 0xd4, 0xf6, 0x19, 0xf6, 0x3f, 0x3d,
    0xed, 0xbb, 0x87, 0x39, 0x25, 0xc2, 0xf2, 0x24, 0xe0, 0x77, 0x31, 0x29,
    0x6d, 0xa8, 0x87, 0xec, 0x1e, 0x47, 0x48, 0xf8, 0x7e, 0xfb, 0x5f, 0xde,
    0xb7, 0x54, 0x84, 0x31, 0x6b, 0x22, 0x32, 0xde, 0xe5, 0x53, 0xdd, 0xaf,
    0x02, 0x11, 0x2b, 0x0d, 0x1f, 0x02, 0xda, 0x30, 0x97, 0x32, 0x24, 0xfe,
    0x27, 0xae, 0xda, 0x8b, 0x9d, 0x4b, 0x29, 0x22, 0xd9, 0xba, 0x8b, 0xe3,
    0x9e, 0xd9, 0xe1, 0x03, 0xa6, 0x3c, 0x52, 0x81, 0x0b, 0xc6, 0x88, 0xb7,
    0xe2, 0xed, 0x43, 0x16, 0xe1, 0xef, 0x17, 0xdb, 0xde, 0x03, 0x82, 0x01,
    0x06, 0x00, 0x02, 0x82, 0x01, 0x01, 0x00, 0x84, 0x81, 0x77, 0xb9, 0xbc,
    0xff, 0x13, 0x6c, 0x52, 0xca, 0xef, 0x2a, 0x4a, 0x9b, 0xcb, 0x64, 0xdb,
    0xef, 0xba, 0xc6, 0x9e, 0x18, 0xaa, 0xe4, 0x99, 0x69, 0x6b, 0x5e, 0xc7,
    0xb2, 0x70, 0xe9, 0x04, 0x78, 0xb4, 0x13, 0xbb, 0x8a, 0xd8, 0xf8, 0xee,
    0xe8, 0xad, 0x32, 0x10, 0x7d, 0x7b, 0xa4, 0x92, 0xc3, 0x6b, 0x00, 0x7f,
    0x9e, 0xf3, 0x0e, 0xbe, 0x1e, 0xe4, 0x84, 0xd0, 0xea, 0x7c, 0xb0, 0xff,
    0x4a, 0xfa, 0xa8, 0xc7, 0x05, 0xad, 0x5e, 0x16, 0x57, 0x69, 0x75, 0x41,
    0x4f, 0x1b, 0xc0, 0xef, 0xed, 0x25, 0xc2, 0x19, 0x0a, 0x3e, 0xd0, 0x06,
    0x8b, 0xff, 0xa1, 0xf0, 0x3b, 0xf6, 0xf2, 0x10, 0x56, 0xc9, 0xbb, 0x38,
    0x33, 0x50, 0x85, 0x19, 0x97, 0xcb, 0xc8, 0x9c, 0xf8, 0x72, 0x9b, 0x39,
    0x45, 0x27, 0xf0, 0x8a, 0xb9, 0x3c, 0xe9, 0xb3, 0x60, 0xaa, 0x05, 0x5a,
    0x47, 0x17, 0x7e, 0x82, 0xa4, 0xce, 0x6f, 0xe7, 0x6c, 0x8d, 0xff, 0xdd,
    0xbd, 0x6e, 0xe2, 0x0f, 0xa0, 0x8d, 0x00, 0x85, 0xd3, 0x98, 0x3e, 0xdd,
    0x2c, 0x8d, 0x9a, 0x36, 0x6a, 0xd2, 0x24, 0x5b, 0x4e, 0xd2, 0x8d, 0x67,
    0x54, 0x76, 0x9f, 0x5f, 0x3a, 0x79, 0x8b, 0xe4, 0xbe, 0x19, 0xcf, 0x46,
    0x93, 0x99, 0x86, 0x5d, 0x46, 0x4e, 0x3f, 0x64, 0x04, 0x38, 0xbc, 0xe0,
    0x3c, 0x96, 0x2c, 0x23, 0x44, 0xd0, 0xd5, 0x50, 0x54, 0x2a, 0xed, 0x3d,
    0xb5, 0x5c, 0x15, 0x38, 0x33, 0xbe, 0xa4, 0x4b, 0x41, 0x46, 0x87, 0x8b,
    0xa3, 0x47, 0xc8, 0x61, 0x44, 0x36, 0xc6, 0xaa, 0xc4, 0xfd, 0x1a, 0x60,
    0xf2, 0x5c, 0x62, 0xb3, 0xf8, 0x69, 0xa7, 0xd5, 0x5c, 0xab, 0x4b, 0x71,
    0x22, 0xd5, 0xe9, 0xaf, 0x43, 0x22, 0xa3, 0xfc, 0x82, 0x14, 0xfa, 0x55,
    0xdc, 0x1e, 0xe0, 0x21, 0x45, 0x9f, 0xb2, 0xc4, 0x59, 0x58, 0x27};

static const std::vector<uint8_t> kPubKey7{
    0x30, 0x82, 0x03, 0x42, 0x30, 0x82, 0x02, 0x35, 0x06, 0x07, 0x2a, 0x86,
    0x48, 0xce, 0x38, 0x04, 0x01, 0x30, 0x82, 0x02, 0x28, 0x02, 0x82, 0x01,
    0x01, 0x00, 0x8f, 0x79, 0x35, 0xd9, 0xb9, 0xaa, 0xe9, 0xbf, 0xab, 0xed,
    0x88, 0x7a, 0xcf, 0x49, 0x51, 0xb6, 0xf3, 0x2e, 0xc5, 0x9e, 0x3b, 0xaf,
    0x37, 0x18, 0xe8, 0xea, 0xc4, 0x96, 0x1f, 0x3e, 0xfd, 0x36, 0x06, 0xe7,
    0x43, 0x51, 0xa9, 0xc4, 0x18, 0x33, 0x39, 0xb8, 0x09, 0xe7, 0xc2, 0xae,
    0x1c, 0x53, 0x9b, 0xa7, 0x47, 0x5b, 0x85, 0xd0, 0x11, 0xad, 0xb8, 0xb4,
    0x79, 0x87, 0x75, 0x49, 0x84, 0x69, 0x5c, 0xac, 0x0e, 0x8f, 0x14, 0xb3,
    0x36, 0x08, 0x28, 0xa2, 0x2f, 0xfa, 0x27, 0x11, 0x0a, 0x3d, 0x62, 0xa9,
    0x93, 0x45, 0x34, 0x09, 0xa0, 0xfe, 0x69, 0x6c, 0x46, 0x58, 0xf8, 0x4b,
    0xdd, 0x20, 0x81, 0x9c, 0x37, 0x09, 0xa0, 0x10, 0x57, 0xb1, 0x95, 0xad,
    0xcd, 0x00, 0x23, 0x3d, 0xba, 0x54, 0x84, 0xb6, 0x29, 0x1f, 0x9d, 0x64,
    0x8e, 0xf8, 0x83, 0x44, 0x86, 0x77, 0x97, 0x9c, 0xec, 0x04, 0xb4, 0x34,
    0xa6, 0xac, 0x2e, 0x75, 0xe9, 0x98, 0x5d, 0xe2, 0x3d, 0xb0, 0x29, 0x2f,
    0xc1, 0x11, 0x8c, 0x9f, 0xfa, 0x9d, 0x81, 0x81, 0xe7, 0x33, 0x8d, 0xb7,
    0x92, 0xb7, 0x30, 0xd7, 0xb9, 0xe3, 0x49, 0x59, 0x2f, 0x68, 0x09, 0x98,
    0x72, 0x15, 0x39, 0x15, 0xea, 0x3d, 0x6b, 0x8b, 0x46, 0x53, 0xc6, 0x33,
    0x45, 0x8f, 0x80, 0x3b, 0x32, 0xa4, 0xc2, 0xe0, 0xf2, 0x72, 0x90, 0x25,
    0x6e, 0x4e, 0x3f, 0x8a, 0x3b, 0x08, 0x38, 0xa1, 0xc4, 0x50, 0xe4, 0xe1,
    0x8c, 0x1a, 0x29, 0xa3, 0x7d, 0xdf, 0x5e, 0xa1, 0x43, 0xde, 0x4b, 0x66,
    0xff, 0x04, 0x90, 0x3e, 0xd5, 0xcf, 0x16, 0x23, 0xe1, 0x58, 0xd4, 0x87,
    0xc6, 0x08, 0xe9, 0x7f, 0x21, 0x1c, 0xd8, 0x1d, 0xca, 0x23, 0xcb, 0x6e,
    0x38, 0x07, 0x65, 0xf8, 0x22, 0xe3, 0x42, 0xbe, 0x48, 0x4c, 0x05, 0x76,
    0x39, 0x39, 0x60, 0x1c, 0xd6, 0x67, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96,
    0xa6, 0x85, 0x78, 0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7,
    0x85, 0xef, 0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69,
    0x5d, 0x02, 0x82, 0x01, 0x00, 0x16, 0xa6, 0x5c, 0x58, 0x20, 0x48, 0x50,
    0x70, 0x4e, 0x75, 0x02, 0xa3, 0x97, 0x57, 0x04, 0x0d, 0x34, 0xda, 0x3a,
    0x34, 0x78, 0xc1, 0x54, 0xd4, 0xe4, 0xa5, 0xc0, 0x2d, 0x24, 0x2e, 0xe0,
    0x4f, 0x96, 0xe6, 0x1e, 0x4b, 0xd0, 0x90, 0x4a, 0xbd, 0xac, 0x8f, 0x37,
    0xee, 0xb1, 0xe0, 0x9f, 0x31, 0x82, 0xd2, 0x3c, 0x90, 0x43, 0xcb, 0x64,
    0x2f, 0x88, 0x00, 0x41, 0x60, 0xed, 0xf9, 0xca, 0x09, 0xb3, 0x20, 0x76,
    0xa7, 0x9c, 0x32, 0xa6, 0x27, 0xf2, 0x47, 0x3e, 0x91, 0x87, 0x9b, 0xa2,
    0xc4, 0xe7, 0x44, 0xbd, 0x20, 0x81, 0x54, 0x4c, 0xb5, 0x5b, 0x80, 0x2c,
    0x36, 0x8d, 0x1f, 0xa8, 0x3e, 0xd4, 0x89, 0xe9, 0x4e, 0x0f, 0xa0, 0x68,
    0x8e, 0x32, 0x42, 0x8a, 0x5c, 0x78, 0xc4, 0x78, 0xc6, 0x8d, 0x05, 0x27,
    0xb7, 0x1c, 0x9a, 0x3a, 0xbb, 0x0b, 0x0b, 0xe1, 0x2c, 0x44, 0x68, 0x96,
    0x39, 0xe7, 0xd3, 0xce, 0x74, 0xdb, 0x10, 0x1a, 0x65, 0xaa, 0x2b, 0x87,
    0xf6, 0x4c, 0x68, 0x26, 0xdb, 0x3e, 0xc7, 0x2f, 0x4b, 0x55, 0x99, 0x83,
    0x4b, 0xb4, 0xed, 0xb0, 0x2f, 0x7c, 0x90, 0xe9, 0xa4, 0x96, 0xd3, 0xa5,
    0x5d, 0x53, 0x5b, 0xeb, 0xfc, 0x45, 0xd4, 0xf6, 0x19, 0xf6, 0x3f, 0x3d,
    0xed, 0xbb, 0x87, 0x39, 0x25, 0xc2, 0xf2, 0x24, 0xe0, 0x77, 0x31, 0x29,
    0x6d, 0xa8, 0x87, 0xec, 0x1e, 0x47, 0x48, 0xf8, 0x7e, 0xfb, 0x5f, 0xde,
    0xb7, 0x54, 0x84, 0x31, 0x6b, 0x22, 0x32, 0xde, 0xe5, 0x53, 0xdd, 0xaf,
    0x02, 0x11, 0x2b, 0x0d, 0x1f, 0x02, 0xda, 0x30, 0x97, 0x32, 0x24, 0xfe,
    0x27, 0xae, 0xda, 0x8b, 0x9d, 0x4b, 0x29, 0x22, 0xd9, 0xba, 0x8b, 0xe3,
    0x9e, 0xd9, 0xe1, 0x03, 0xa6, 0x3c, 0x52, 0x81, 0x0b, 0xc6, 0x88, 0xb7,
    0xe2, 0xed, 0x43, 0x16, 0xe1, 0xef, 0x17, 0xdb, 0xde, 0x03, 0x82, 0x01,
    0x05, 0x00, 0x02, 0x82, 0x01, 0x00, 0x62, 0x93, 0x74, 0x92, 0x95, 0x37,
    0xe2, 0xc3, 0xb0, 0x9f, 0x30, 0xd8, 0x81, 0x55, 0x4c, 0xa7, 0x35, 0x7f,
    0x89, 0xe2, 0x51, 0x05, 0x47, 0x4d, 0xbb, 0xce, 0x06, 0xe4, 0x00, 0x1e,
    0xfd, 0x61, 0x48, 0x1a, 0x45, 0x7a, 0xa0, 0xd7, 0xd7, 0xe5, 0x65, 0xe9,
    0x0b, 0x7a, 0x3d, 0x9c, 0x68, 0x80, 0x05, 0xfb, 0x40, 0x4b, 0xf3, 0xb6,
    0xd3, 0xe6, 0x1e, 0x40, 0x23, 0x00, 0xbe, 0xee, 0x7c, 0x58, 0xce, 0xea,
    0xf0, 0x0b, 0x11, 0x2d, 0xdf, 0xee, 0xf3, 0xcb, 0xc2, 0x02, 0x0b, 0xa2,
    0x20, 0x6d, 0xd4, 0xef, 0x05, 0x63, 0xd7, 0xfa, 0x52, 0xc3, 0x21, 0xb4,
    0xee, 0x62, 0x80, 0xeb, 0x85, 0x85, 0x04, 0x1d, 0x03, 0xca, 0xdb, 0x92,
    0x44, 0xdf, 0xf2, 0x1d, 0xc9, 0x04, 0x17, 0xbb, 0xe6, 0xf0, 0x6b, 0x91,
    0xc2, 0xca, 0x64, 0x84, 0x43, 0x7c, 0x38, 0x46, 0x92, 0x6b, 0x18, 0xee,
    0x22, 0x27, 0x50, 0x81, 0xb6, 0x07, 0x26, 0xe7, 0xa2, 0x6a, 0x29, 0xa9,
    0x47, 0xea, 0xbd, 0x03, 0x5e, 0xde, 0x83, 0xd6, 0x59, 0x27, 0xb3, 0xce,
    0xb0, 0xd4, 0xd8, 0xc2, 0xf3, 0x4e, 0x94, 0xa3, 0xde, 0x0f, 0x57, 0xe4,
    0xea, 0x99, 0xaf, 0x05, 0x96, 0x57, 0x52, 0x9f, 0x69, 0x54, 0xb1, 0xac,
    0x9b, 0xb4, 0x48, 0x4c, 0xa7, 0x6b, 0x40, 0x83, 0xe1, 0xcf, 0x42, 0x64,
    0xef, 0xf0, 0x28, 0x66, 0x21, 0x37, 0x76, 0x1e, 0x4d, 0x7f, 0x35, 0xb1,
    0xed, 0xa3, 0xcf, 0x51, 0x68, 0x56, 0xf2, 0x55, 0x53, 0x84, 0x0e, 0x43,
    0xae, 0x38, 0x37, 0x9d, 0x23, 0x4b, 0x06, 0xc8, 0x91, 0x82, 0x21, 0x32,
    0x08, 0x1d, 0x19, 0xf0, 0xd5, 0xdb, 0x9f, 0x23, 0xb4, 0xbb, 0xd5, 0xf5,
    0x66, 0x7d, 0xd7, 0x8f, 0x3d, 0xd7, 0xf1, 0xfe, 0x5f, 0x25, 0xca, 0x48,
    0x51, 0x5f, 0x63, 0x35, 0xce, 0x1c, 0x9f, 0xd0, 0xa6, 0x4b};

const DsaTestVector kDsaWycheproofVectors[] = {

    // Comment: Legacy:ASN encoding of r misses leading 0
    // tcID: 1
    {SEC_OID_SHA1,
     1,
     {0x30, 0x2c, 0x02, 0x14, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d, 0x90, 0xe1,
      0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb, 0x4a,
      0x02, 0x14, 0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32, 0xd1,
      0xf9, 0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: valid
    // tcID: 2
    {SEC_OID_SHA1,
     2,
     {0x30, 0x2d, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d, 0x90,
      0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb,
      0x4a, 0x02, 0x14, 0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32,
      0xd1, 0xf9, 0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: long form encoding of length of sequence
    // tcID: 3
    {SEC_OID_SHA1,
     3,
     {0x30, 0x81, 0x2d, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d,
      0x90, 0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e, 0x38,
      0xdb, 0x4a, 0x02, 0x14, 0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35,
      0x32, 0xd1, 0xf9, 0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: length of sequence contains leading 0
    // tcID: 4
    {SEC_OID_SHA1,
     4,
     {0x30, 0x82, 0x00, 0x2d, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25,
      0x8f, 0xbf, 0x7d, 0x90, 0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37,
      0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb, 0x4a, 0x02, 0x14, 0x49,
      0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32, 0xd1, 0xf9,
      0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: wrong length of sequence
    // tcID: 5
    {SEC_OID_SHA1,
     5,
     {0x30, 0x2e, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d, 0x90,
      0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb,
      0x4a, 0x02, 0x14, 0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32,
      0xd1, 0xf9, 0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: wrong length of sequence
    // tcID: 6
    {SEC_OID_SHA1,
     6,
     {0x30, 0x2c, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d, 0x90,
      0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb,
      0x4a, 0x02, 0x14, 0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32,
      0xd1, 0xf9, 0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: uint32 overflow in length of sequence
    // tcID: 7
    {SEC_OID_SHA1,
     7,
     {0x30, 0x85, 0x01, 0x00, 0x00, 0x00, 0x2d, 0x02, 0x15, 0x00, 0xaa,
      0x6a, 0x25, 0x8f, 0xbf, 0x7d, 0x90, 0xe1, 0x56, 0x14, 0x67, 0x6d,
      0x37, 0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb, 0x4a, 0x02, 0x14, 0x49,
      0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32, 0xd1, 0xf9, 0x91,
      0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: uint64 overflow in length of sequence
    // tcID: 8
    {SEC_OID_SHA1,
     8,
     {0x30, 0x89, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2d, 0x02,
      0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d, 0x90, 0xe1, 0x56, 0x14,
      0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb, 0x4a, 0x02, 0x14,
      0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32, 0xd1, 0xf9, 0x91,
      0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: length of sequence = 2**31 - 1
    // tcID: 9
    {SEC_OID_SHA1,
     9,
     {0x30, 0x84, 0x7f, 0xff, 0xff, 0xff, 0x02, 0x15, 0x00, 0xaa, 0x6a,
      0x25, 0x8f, 0xbf, 0x7d, 0x90, 0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37,
      0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb, 0x4a, 0x02, 0x14, 0x49, 0x6d,
      0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32, 0xd1, 0xf9, 0x91, 0x20,
      0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: length of sequence = 2**32 - 1
    // tcID: 10
    {SEC_OID_SHA1,
     10,
     {0x30, 0x84, 0xff, 0xff, 0xff, 0xff, 0x02, 0x15, 0x00, 0xaa, 0x6a,
      0x25, 0x8f, 0xbf, 0x7d, 0x90, 0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37,
      0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb, 0x4a, 0x02, 0x14, 0x49, 0x6d,
      0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32, 0xd1, 0xf9, 0x91, 0x20,
      0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: length of sequence = 2**40 - 1
    // tcID: 11
    {SEC_OID_SHA1,
     11,
     {0x30, 0x85, 0xff, 0xff, 0xff, 0xff, 0xff, 0x02, 0x15, 0x00, 0xaa,
      0x6a, 0x25, 0x8f, 0xbf, 0x7d, 0x90, 0xe1, 0x56, 0x14, 0x67, 0x6d,
      0x37, 0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb, 0x4a, 0x02, 0x14, 0x49,
      0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32, 0xd1, 0xf9, 0x91,
      0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: length of sequence = 2**64 - 1
    // tcID: 12
    {SEC_OID_SHA1,
     12,
     {0x30, 0x88, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x02,
      0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d, 0x90, 0xe1, 0x56,
      0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb, 0x4a,
      0x02, 0x14, 0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32,
      0xd1, 0xf9, 0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: incorrect length of sequence
    // tcID: 13
    {SEC_OID_SHA1,
     13,
     {0x30, 0xff, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d, 0x90,
      0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb,
      0x4a, 0x02, 0x14, 0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32,
      0xd1, 0xf9, 0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: indefinite length without termination
    // tcID: 14
    {SEC_OID_SHA1,
     14,
     {0x30, 0x80, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d, 0x90,
      0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb,
      0x4a, 0x02, 0x14, 0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32,
      0xd1, 0xf9, 0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: indefinite length without termination
    // tcID: 15
    {SEC_OID_SHA1,
     15,
     {0x30, 0x2d, 0x02, 0x80, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d, 0x90,
      0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb,
      0x4a, 0x02, 0x14, 0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32,
      0xd1, 0xf9, 0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: indefinite length without termination
    // tcID: 16
    {SEC_OID_SHA1,
     16,
     {0x30, 0x2d, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d, 0x90,
      0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb,
      0x4a, 0x02, 0x80, 0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32,
      0xd1, 0xf9, 0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: removing sequence
    // tcID: 17
    {SEC_OID_SHA1,
     17,
     {},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: lonely sequence tag
    // tcID: 18
    {SEC_OID_SHA1,
     18,
     {0x30},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: appending 0's to sequence
    // tcID: 19
    {SEC_OID_SHA1,
     19,
     {0x30, 0x2f, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf,
      0x7d, 0x90, 0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8,
      0xb1, 0x0e, 0x38, 0xdb, 0x4a, 0x02, 0x14, 0x49, 0x6d, 0x52,
      0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32, 0xd1, 0xf9, 0x91, 0x20,
      0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b, 0x00, 0x00},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: prepending 0's to sequence
    // tcID: 20
    {SEC_OID_SHA1,
     20,
     {0x30, 0x2f, 0x00, 0x00, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25,
      0x8f, 0xbf, 0x7d, 0x90, 0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37,
      0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb, 0x4a, 0x02, 0x14, 0x49,
      0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32, 0xd1, 0xf9,
      0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: appending unused 0's to sequence
    // tcID: 21
    {SEC_OID_SHA1,
     21,
     {0x30, 0x2d, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf,
      0x7d, 0x90, 0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8,
      0xb1, 0x0e, 0x38, 0xdb, 0x4a, 0x02, 0x14, 0x49, 0x6d, 0x52,
      0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32, 0xd1, 0xf9, 0x91, 0x20,
      0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b, 0x00, 0x00},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: appending null value to sequence
    // tcID: 22
    {SEC_OID_SHA1,
     22,
     {0x30, 0x2f, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf,
      0x7d, 0x90, 0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8,
      0xb1, 0x0e, 0x38, 0xdb, 0x4a, 0x02, 0x14, 0x49, 0x6d, 0x52,
      0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32, 0xd1, 0xf9, 0x91, 0x20,
      0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b, 0x05, 0x00},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: including garbage
    // tcID: 23
    {SEC_OID_SHA1,
     23,
     {0x30, 0x32, 0x49, 0x81, 0x77, 0x30, 0x2d, 0x02, 0x15, 0x00, 0xaa,
      0x6a, 0x25, 0x8f, 0xbf, 0x7d, 0x90, 0xe1, 0x56, 0x14, 0x67, 0x6d,
      0x37, 0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb, 0x4a, 0x02, 0x14, 0x49,
      0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32, 0xd1, 0xf9, 0x91,
      0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: including garbage
    // tcID: 24
    {SEC_OID_SHA1,
     24,
     {0x30, 0x31, 0x25, 0x00, 0x30, 0x2d, 0x02, 0x15, 0x00, 0xaa, 0x6a,
      0x25, 0x8f, 0xbf, 0x7d, 0x90, 0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37,
      0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb, 0x4a, 0x02, 0x14, 0x49, 0x6d,
      0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32, 0xd1, 0xf9, 0x91, 0x20,
      0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: including garbage
    // tcID: 25
    {SEC_OID_SHA1,
     25,
     {0x30, 0x2f, 0x30, 0x2d, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f,
      0xbf, 0x7d, 0x90, 0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8,
      0xb1, 0x0e, 0x38, 0xdb, 0x4a, 0x02, 0x14, 0x49, 0x6d, 0x52, 0x20,
      0xb5, 0xf6, 0x7d, 0x35, 0x32, 0xd1, 0xf9, 0x91, 0x20, 0x3b, 0xc3,
      0x52, 0x3b, 0x96, 0x4c, 0x3b, 0x00, 0x04, 0xde, 0xad, 0xbe, 0xef},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: including garbage
    // tcID: 26
    {SEC_OID_SHA1,
     26,
     {0x30, 0x32, 0x22, 0x1a, 0x49, 0x81, 0x77, 0x02, 0x15, 0x00, 0xaa,
      0x6a, 0x25, 0x8f, 0xbf, 0x7d, 0x90, 0xe1, 0x56, 0x14, 0x67, 0x6d,
      0x37, 0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb, 0x4a, 0x02, 0x14, 0x49,
      0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32, 0xd1, 0xf9, 0x91,
      0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: including garbage
    // tcID: 27
    {SEC_OID_SHA1,
     27,
     {0x30, 0x31, 0x22, 0x19, 0x25, 0x00, 0x02, 0x15, 0x00, 0xaa, 0x6a,
      0x25, 0x8f, 0xbf, 0x7d, 0x90, 0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37,
      0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb, 0x4a, 0x02, 0x14, 0x49, 0x6d,
      0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32, 0xd1, 0xf9, 0x91, 0x20,
      0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: including garbage
    // tcID: 28
    {SEC_OID_SHA1,
     28,
     {0x30, 0x35, 0x22, 0x17, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f,
      0xbf, 0x7d, 0x90, 0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8,
      0xb1, 0x0e, 0x38, 0xdb, 0x4a, 0x00, 0x04, 0xde, 0xad, 0xbe, 0xef,
      0x02, 0x14, 0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32,
      0xd1, 0xf9, 0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: including garbage
    // tcID: 29
    {SEC_OID_SHA1,
     29,
     {0x30, 0x32, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d,
      0x90, 0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e,
      0x38, 0xdb, 0x4a, 0x22, 0x19, 0x49, 0x81, 0x77, 0x02, 0x14, 0x49,
      0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32, 0xd1, 0xf9, 0x91,
      0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: including garbage
    // tcID: 30
    {SEC_OID_SHA1,
     30,
     {0x30, 0x31, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d,
      0x90, 0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e,
      0x38, 0xdb, 0x4a, 0x22, 0x18, 0x25, 0x00, 0x02, 0x14, 0x49, 0x6d,
      0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32, 0xd1, 0xf9, 0x91, 0x20,
      0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: including garbage
    // tcID: 31
    {SEC_OID_SHA1,
     31,
     {0x30, 0x35, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d,
      0x90, 0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e,
      0x38, 0xdb, 0x4a, 0x22, 0x16, 0x02, 0x14, 0x49, 0x6d, 0x52, 0x20,
      0xb5, 0xf6, 0x7d, 0x35, 0x32, 0xd1, 0xf9, 0x91, 0x20, 0x3b, 0xc3,
      0x52, 0x3b, 0x96, 0x4c, 0x3b, 0x00, 0x04, 0xde, 0xad, 0xbe, 0xef},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: including undefined tags
    // tcID: 32
    {SEC_OID_SHA1,
     32,
     {0x30, 0x35, 0xaa, 0x00, 0xbb, 0x00, 0xcd, 0x00, 0x30, 0x2d, 0x02,
      0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d, 0x90, 0xe1, 0x56,
      0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb, 0x4a,
      0x02, 0x14, 0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32,
      0xd1, 0xf9, 0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: including undefined tags
    // tcID: 33
    {SEC_OID_SHA1,
     33,
     {0x30, 0x33, 0xaa, 0x02, 0xaa, 0xbb, 0x30, 0x2d, 0x02, 0x15, 0x00,
      0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d, 0x90, 0xe1, 0x56, 0x14, 0x67,
      0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb, 0x4a, 0x02, 0x14,
      0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32, 0xd1, 0xf9,
      0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: including undefined tags
    // tcID: 34
    {SEC_OID_SHA1,
     34,
     {0x30, 0x35, 0x22, 0x1d, 0xaa, 0x00, 0xbb, 0x00, 0xcd, 0x00, 0x02,
      0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d, 0x90, 0xe1, 0x56,
      0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb, 0x4a,
      0x02, 0x14, 0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32,
      0xd1, 0xf9, 0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: including undefined tags
    // tcID: 35
    {SEC_OID_SHA1,
     35,
     {0x30, 0x33, 0x22, 0x1b, 0xaa, 0x02, 0xaa, 0xbb, 0x02, 0x15, 0x00,
      0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d, 0x90, 0xe1, 0x56, 0x14, 0x67,
      0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb, 0x4a, 0x02, 0x14,
      0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32, 0xd1, 0xf9,
      0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: including undefined tags
    // tcID: 36
    {SEC_OID_SHA1,
     36,
     {0x30, 0x35, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d,
      0x90, 0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e,
      0x38, 0xdb, 0x4a, 0x22, 0x1c, 0xaa, 0x00, 0xbb, 0x00, 0xcd, 0x00,
      0x02, 0x14, 0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32,
      0xd1, 0xf9, 0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: including undefined tags
    // tcID: 37
    {SEC_OID_SHA1,
     37,
     {0x30, 0x33, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d,
      0x90, 0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e,
      0x38, 0xdb, 0x4a, 0x22, 0x1a, 0xaa, 0x02, 0xaa, 0xbb, 0x02, 0x14,
      0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32, 0xd1, 0xf9,
      0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: truncated length of sequence
    // tcID: 38
    {SEC_OID_SHA1,
     38,
     {0x30, 0x81},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: using composition with indefinite length
    // tcID: 39
    {SEC_OID_SHA1,
     39,
     {0x30, 0x80, 0x30, 0x2d, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f,
      0xbf, 0x7d, 0x90, 0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8,
      0xb1, 0x0e, 0x38, 0xdb, 0x4a, 0x02, 0x14, 0x49, 0x6d, 0x52, 0x20,
      0xb5, 0xf6, 0x7d, 0x35, 0x32, 0xd1, 0xf9, 0x91, 0x20, 0x3b, 0xc3,
      0x52, 0x3b, 0x96, 0x4c, 0x3b, 0x00, 0x00},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: using composition with indefinite length
    // tcID: 40
    {SEC_OID_SHA1,
     40,
     {0x30, 0x31, 0x22, 0x80, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f,
      0xbf, 0x7d, 0x90, 0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8,
      0xb1, 0x0e, 0x38, 0xdb, 0x4a, 0x00, 0x00, 0x02, 0x14, 0x49, 0x6d,
      0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32, 0xd1, 0xf9, 0x91, 0x20,
      0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: using composition with indefinite length
    // tcID: 41
    {SEC_OID_SHA1,
     41,
     {0x30, 0x31, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d,
      0x90, 0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e,
      0x38, 0xdb, 0x4a, 0x22, 0x80, 0x02, 0x14, 0x49, 0x6d, 0x52, 0x20,
      0xb5, 0xf6, 0x7d, 0x35, 0x32, 0xd1, 0xf9, 0x91, 0x20, 0x3b, 0xc3,
      0x52, 0x3b, 0x96, 0x4c, 0x3b, 0x00, 0x00},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: using composition with wrong tag
    // tcID: 42
    {SEC_OID_SHA1,
     42,
     {0x30, 0x80, 0x31, 0x2d, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f,
      0xbf, 0x7d, 0x90, 0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8,
      0xb1, 0x0e, 0x38, 0xdb, 0x4a, 0x02, 0x14, 0x49, 0x6d, 0x52, 0x20,
      0xb5, 0xf6, 0x7d, 0x35, 0x32, 0xd1, 0xf9, 0x91, 0x20, 0x3b, 0xc3,
      0x52, 0x3b, 0x96, 0x4c, 0x3b, 0x00, 0x00},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: using composition with wrong tag
    // tcID: 43
    {SEC_OID_SHA1,
     43,
     {0x30, 0x31, 0x22, 0x80, 0x03, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f,
      0xbf, 0x7d, 0x90, 0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8,
      0xb1, 0x0e, 0x38, 0xdb, 0x4a, 0x00, 0x00, 0x02, 0x14, 0x49, 0x6d,
      0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32, 0xd1, 0xf9, 0x91, 0x20,
      0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: using composition with wrong tag
    // tcID: 44
    {SEC_OID_SHA1,
     44,
     {0x30, 0x31, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d,
      0x90, 0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e,
      0x38, 0xdb, 0x4a, 0x22, 0x80, 0x03, 0x14, 0x49, 0x6d, 0x52, 0x20,
      0xb5, 0xf6, 0x7d, 0x35, 0x32, 0xd1, 0xf9, 0x91, 0x20, 0x3b, 0xc3,
      0x52, 0x3b, 0x96, 0x4c, 0x3b, 0x00, 0x00},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Replacing sequence with NULL
    // tcID: 45
    {SEC_OID_SHA1,
     45,
     {0x05, 0x00},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: changing tag value of sequence
    // tcID: 46
    {SEC_OID_SHA1,
     46,
     {0x2e, 0x2d, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d, 0x90,
      0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb,
      0x4a, 0x02, 0x14, 0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32,
      0xd1, 0xf9, 0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: changing tag value of sequence
    // tcID: 47
    {SEC_OID_SHA1,
     47,
     {0x2f, 0x2d, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d, 0x90,
      0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb,
      0x4a, 0x02, 0x14, 0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32,
      0xd1, 0xf9, 0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: changing tag value of sequence
    // tcID: 48
    {SEC_OID_SHA1,
     48,
     {0x31, 0x2d, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d, 0x90,
      0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb,
      0x4a, 0x02, 0x14, 0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32,
      0xd1, 0xf9, 0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: changing tag value of sequence
    // tcID: 49
    {SEC_OID_SHA1,
     49,
     {0x32, 0x2d, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d, 0x90,
      0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb,
      0x4a, 0x02, 0x14, 0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32,
      0xd1, 0xf9, 0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: changing tag value of sequence
    // tcID: 50
    {SEC_OID_SHA1,
     50,
     {0xff, 0x2d, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d, 0x90,
      0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb,
      0x4a, 0x02, 0x14, 0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32,
      0xd1, 0xf9, 0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: dropping value of sequence
    // tcID: 51
    {SEC_OID_SHA1,
     51,
     {0x30, 0x00},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: using composition for sequence
    // tcID: 52
    {SEC_OID_SHA1,
     52,
     {0x30, 0x31, 0x30, 0x01, 0x02, 0x30, 0x2c, 0x15, 0x00, 0xaa, 0x6a,
      0x25, 0x8f, 0xbf, 0x7d, 0x90, 0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37,
      0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb, 0x4a, 0x02, 0x14, 0x49, 0x6d,
      0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32, 0xd1, 0xf9, 0x91, 0x20,
      0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: truncated sequence
    // tcID: 53
    {SEC_OID_SHA1,
     53,
     {0x30, 0x2c, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d, 0x90,
      0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb,
      0x4a, 0x02, 0x14, 0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32,
      0xd1, 0xf9, 0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: truncated sequence
    // tcID: 54
    {SEC_OID_SHA1,
     54,
     {0x30, 0x2c, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d, 0x90, 0xe1,
      0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb, 0x4a,
      0x02, 0x14, 0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32, 0xd1,
      0xf9, 0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: indefinite length
    // tcID: 55
    {SEC_OID_SHA1,
     55,
     {0x30, 0x80, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf,
      0x7d, 0x90, 0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8,
      0xb1, 0x0e, 0x38, 0xdb, 0x4a, 0x02, 0x14, 0x49, 0x6d, 0x52,
      0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32, 0xd1, 0xf9, 0x91, 0x20,
      0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b, 0x00, 0x00},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: indefinite length with truncated delimiter
    // tcID: 56
    {SEC_OID_SHA1,
     56,
     {0x30, 0x80, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d, 0x90,
      0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb,
      0x4a, 0x02, 0x14, 0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32,
      0xd1, 0xf9, 0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b, 0x00},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: indefinite length with additional element
    // tcID: 57
    {SEC_OID_SHA1,
     57,
     {0x30, 0x80, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d,
      0x90, 0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e,
      0x38, 0xdb, 0x4a, 0x02, 0x14, 0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6,
      0x7d, 0x35, 0x32, 0xd1, 0xf9, 0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b,
      0x96, 0x4c, 0x3b, 0x05, 0x00, 0x00, 0x00},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: indefinite length with truncated element
    // tcID: 58
    {SEC_OID_SHA1,
     58,
     {0x30, 0x80, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d,
      0x90, 0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e,
      0x38, 0xdb, 0x4a, 0x02, 0x14, 0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6,
      0x7d, 0x35, 0x32, 0xd1, 0xf9, 0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b,
      0x96, 0x4c, 0x3b, 0x06, 0x08, 0x11, 0x22, 0x00, 0x00},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: indefinite length with garbage
    // tcID: 59
    {SEC_OID_SHA1,
     59,
     {0x30, 0x80, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d,
      0x90, 0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e,
      0x38, 0xdb, 0x4a, 0x02, 0x14, 0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6,
      0x7d, 0x35, 0x32, 0xd1, 0xf9, 0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b,
      0x96, 0x4c, 0x3b, 0x00, 0x00, 0xfe, 0x02, 0xbe, 0xef},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: indefinite length with nonempty EOC
    // tcID: 60
    {SEC_OID_SHA1,
     60,
     {0x30, 0x80, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d,
      0x90, 0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e,
      0x38, 0xdb, 0x4a, 0x02, 0x14, 0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6,
      0x7d, 0x35, 0x32, 0xd1, 0xf9, 0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b,
      0x96, 0x4c, 0x3b, 0x00, 0x02, 0xbe, 0xef},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: prepend empty sequence
    // tcID: 61
    {SEC_OID_SHA1,
     61,
     {0x30, 0x2f, 0x30, 0x00, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25,
      0x8f, 0xbf, 0x7d, 0x90, 0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37,
      0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb, 0x4a, 0x02, 0x14, 0x49,
      0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32, 0xd1, 0xf9,
      0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: append empty sequence
    // tcID: 62
    {SEC_OID_SHA1,
     62,
     {0x30, 0x2f, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf,
      0x7d, 0x90, 0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8,
      0xb1, 0x0e, 0x38, 0xdb, 0x4a, 0x02, 0x14, 0x49, 0x6d, 0x52,
      0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32, 0xd1, 0xf9, 0x91, 0x20,
      0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b, 0x30, 0x00},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: append garbage with high tag number
    // tcID: 63
    {SEC_OID_SHA1,
     63,
     {0x30, 0x30, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf,
      0x7d, 0x90, 0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8,
      0xb1, 0x0e, 0x38, 0xdb, 0x4a, 0x02, 0x14, 0x49, 0x6d, 0x52,
      0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32, 0xd1, 0xf9, 0x91, 0x20,
      0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b, 0xbf, 0x7f, 0x00},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: sequence of sequence
    // tcID: 64
    {SEC_OID_SHA1,
     64,
     {0x30, 0x2f, 0x30, 0x2d, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25,
      0x8f, 0xbf, 0x7d, 0x90, 0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37,
      0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb, 0x4a, 0x02, 0x14, 0x49,
      0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32, 0xd1, 0xf9,
      0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: truncated sequence: removed last 1 elements
    // tcID: 65
    {SEC_OID_SHA1,
     65,
     {0x30, 0x17, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f,
      0xbf, 0x7d, 0x90, 0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37,
      0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb, 0x4a},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: repeating element in sequence
    // tcID: 66
    {SEC_OID_SHA1,
     66,
     {0x30, 0x43, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d, 0x90,
      0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb,
      0x4a, 0x02, 0x14, 0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32,
      0xd1, 0xf9, 0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b, 0x02,
      0x14, 0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32, 0xd1, 0xf9,
      0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: long form encoding of length of integer
    // tcID: 67
    {SEC_OID_SHA1,
     67,
     {0x30, 0x2e, 0x02, 0x81, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d,
      0x90, 0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e, 0x38,
      0xdb, 0x4a, 0x02, 0x14, 0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35,
      0x32, 0xd1, 0xf9, 0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: long form encoding of length of integer
    // tcID: 68
    {SEC_OID_SHA1,
     68,
     {0x30, 0x2e, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d, 0x90,
      0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb,
      0x4a, 0x02, 0x81, 0x14, 0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35,
      0x32, 0xd1, 0xf9, 0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: length of integer contains leading 0
    // tcID: 69
    {SEC_OID_SHA1,
     69,
     {0x30, 0x2f, 0x02, 0x82, 0x00, 0x15, 0x00, 0xaa, 0x6a, 0x25,
      0x8f, 0xbf, 0x7d, 0x90, 0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37,
      0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb, 0x4a, 0x02, 0x14, 0x49,
      0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32, 0xd1, 0xf9,
      0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: length of integer contains leading 0
    // tcID: 70
    {SEC_OID_SHA1,
     70,
     {0x30, 0x2f, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf,
      0x7d, 0x90, 0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8,
      0xb1, 0x0e, 0x38, 0xdb, 0x4a, 0x02, 0x82, 0x00, 0x14, 0x49,
      0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32, 0xd1, 0xf9,
      0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: wrong length of integer
    // tcID: 71
    {SEC_OID_SHA1,
     71,
     {0x30, 0x2d, 0x02, 0x16, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d, 0x90,
      0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb,
      0x4a, 0x02, 0x14, 0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32,
      0xd1, 0xf9, 0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: wrong length of integer
    // tcID: 72
    {SEC_OID_SHA1,
     72,
     {0x30, 0x2d, 0x02, 0x14, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d, 0x90,
      0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb,
      0x4a, 0x02, 0x14, 0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32,
      0xd1, 0xf9, 0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: wrong length of integer
    // tcID: 73
    {SEC_OID_SHA1,
     73,
     {0x30, 0x2d, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d, 0x90,
      0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb,
      0x4a, 0x02, 0x15, 0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32,
      0xd1, 0xf9, 0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: wrong length of integer
    // tcID: 74
    {SEC_OID_SHA1,
     74,
     {0x30, 0x2d, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d, 0x90,
      0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb,
      0x4a, 0x02, 0x13, 0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32,
      0xd1, 0xf9, 0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: uint32 overflow in length of integer
    // tcID: 75
    {SEC_OID_SHA1,
     75,
     {0x30, 0x32, 0x02, 0x85, 0x01, 0x00, 0x00, 0x00, 0x15, 0x00, 0xaa,
      0x6a, 0x25, 0x8f, 0xbf, 0x7d, 0x90, 0xe1, 0x56, 0x14, 0x67, 0x6d,
      0x37, 0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb, 0x4a, 0x02, 0x14, 0x49,
      0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32, 0xd1, 0xf9, 0x91,
      0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: uint32 overflow in length of integer
    // tcID: 76
    {SEC_OID_SHA1,
     76,
     {0x30, 0x32, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d,
      0x90, 0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e,
      0x38, 0xdb, 0x4a, 0x02, 0x85, 0x01, 0x00, 0x00, 0x00, 0x14, 0x49,
      0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32, 0xd1, 0xf9, 0x91,
      0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: uint64 overflow in length of integer
    // tcID: 77
    {SEC_OID_SHA1,
     77,
     {0x30, 0x36, 0x02, 0x89, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d, 0x90, 0xe1, 0x56, 0x14,
      0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb, 0x4a, 0x02, 0x14,
      0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32, 0xd1, 0xf9, 0x91,
      0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: uint64 overflow in length of integer
    // tcID: 78
    {SEC_OID_SHA1,
     78,
     {0x30, 0x36, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d, 0x90,
      0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb,
      0x4a, 0x02, 0x89, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14,
      0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32, 0xd1, 0xf9, 0x91,
      0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: length of integer = 2**31 - 1
    // tcID: 79
    {SEC_OID_SHA1,
     79,
     {0x30, 0x31, 0x02, 0x84, 0x7f, 0xff, 0xff, 0xff, 0x00, 0xaa, 0x6a,
      0x25, 0x8f, 0xbf, 0x7d, 0x90, 0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37,
      0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb, 0x4a, 0x02, 0x14, 0x49, 0x6d,
      0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32, 0xd1, 0xf9, 0x91, 0x20,
      0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: length of integer = 2**31 - 1
    // tcID: 80
    {SEC_OID_SHA1,
     80,
     {0x30, 0x31, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d,
      0x90, 0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e,
      0x38, 0xdb, 0x4a, 0x02, 0x84, 0x7f, 0xff, 0xff, 0xff, 0x49, 0x6d,
      0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32, 0xd1, 0xf9, 0x91, 0x20,
      0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: length of integer = 2**32 - 1
    // tcID: 81
    {SEC_OID_SHA1,
     81,
     {0x30, 0x31, 0x02, 0x84, 0xff, 0xff, 0xff, 0xff, 0x00, 0xaa, 0x6a,
      0x25, 0x8f, 0xbf, 0x7d, 0x90, 0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37,
      0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb, 0x4a, 0x02, 0x14, 0x49, 0x6d,
      0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32, 0xd1, 0xf9, 0x91, 0x20,
      0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: length of integer = 2**32 - 1
    // tcID: 82
    {SEC_OID_SHA1,
     82,
     {0x30, 0x31, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d,
      0x90, 0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e,
      0x38, 0xdb, 0x4a, 0x02, 0x84, 0xff, 0xff, 0xff, 0xff, 0x49, 0x6d,
      0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32, 0xd1, 0xf9, 0x91, 0x20,
      0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: length of integer = 2**40 - 1
    // tcID: 83
    {SEC_OID_SHA1,
     83,
     {0x30, 0x32, 0x02, 0x85, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0xaa,
      0x6a, 0x25, 0x8f, 0xbf, 0x7d, 0x90, 0xe1, 0x56, 0x14, 0x67, 0x6d,
      0x37, 0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb, 0x4a, 0x02, 0x14, 0x49,
      0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32, 0xd1, 0xf9, 0x91,
      0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: length of integer = 2**40 - 1
    // tcID: 84
    {SEC_OID_SHA1,
     84,
     {0x30, 0x32, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d,
      0x90, 0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e,
      0x38, 0xdb, 0x4a, 0x02, 0x85, 0xff, 0xff, 0xff, 0xff, 0xff, 0x49,
      0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32, 0xd1, 0xf9, 0x91,
      0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: length of integer = 2**64 - 1
    // tcID: 85
    {SEC_OID_SHA1,
     85,
     {0x30, 0x35, 0x02, 0x88, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d, 0x90, 0xe1, 0x56,
      0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb, 0x4a,
      0x02, 0x14, 0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32,
      0xd1, 0xf9, 0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: length of integer = 2**64 - 1
    // tcID: 86
    {SEC_OID_SHA1,
     86,
     {0x30, 0x35, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d,
      0x90, 0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e,
      0x38, 0xdb, 0x4a, 0x02, 0x88, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32,
      0xd1, 0xf9, 0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: incorrect length of integer
    // tcID: 87
    {SEC_OID_SHA1,
     87,
     {0x30, 0x2d, 0x02, 0xff, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d, 0x90,
      0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb,
      0x4a, 0x02, 0x14, 0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32,
      0xd1, 0xf9, 0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: incorrect length of integer
    // tcID: 88
    {SEC_OID_SHA1,
     88,
     {0x30, 0x2d, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d, 0x90,
      0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb,
      0x4a, 0x02, 0xff, 0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32,
      0xd1, 0xf9, 0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: removing integer
    // tcID: 89
    {SEC_OID_SHA1,
     89,
     {0x30, 0x16, 0x02, 0x14, 0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35,
      0x32, 0xd1, 0xf9, 0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: lonely integer tag
    // tcID: 90
    {SEC_OID_SHA1,
     90,
     {0x30, 0x17, 0x02, 0x02, 0x14, 0x49, 0x6d, 0x52, 0x20,
      0xb5, 0xf6, 0x7d, 0x35, 0x32, 0xd1, 0xf9, 0x91, 0x20,
      0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: lonely integer tag
    // tcID: 91
    {SEC_OID_SHA1,
     91,
     {0x30, 0x18, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f,
      0xbf, 0x7d, 0x90, 0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37,
      0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb, 0x4a, 0x02},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: appending 0's to integer
    // tcID: 92
    {SEC_OID_SHA1,
     92,
     {0x30, 0x2f, 0x02, 0x17, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf,
      0x7d, 0x90, 0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8,
      0xb1, 0x0e, 0x38, 0xdb, 0x4a, 0x00, 0x00, 0x02, 0x14, 0x49,
      0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32, 0xd1, 0xf9,
      0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: appending 0's to integer
    // tcID: 93
    {SEC_OID_SHA1,
     93,
     {0x30, 0x2f, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf,
      0x7d, 0x90, 0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8,
      0xb1, 0x0e, 0x38, 0xdb, 0x4a, 0x02, 0x16, 0x49, 0x6d, 0x52,
      0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32, 0xd1, 0xf9, 0x91, 0x20,
      0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b, 0x00, 0x00},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: prepending 0's to integer
    // tcID: 94
    {SEC_OID_SHA1,
     94,
     {0x30, 0x2f, 0x02, 0x17, 0x00, 0x00, 0x00, 0xaa, 0x6a, 0x25,
      0x8f, 0xbf, 0x7d, 0x90, 0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37,
      0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb, 0x4a, 0x02, 0x14, 0x49,
      0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32, 0xd1, 0xf9,
      0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: prepending 0's to integer
    // tcID: 95
    {SEC_OID_SHA1,
     95,
     {0x30, 0x2f, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf,
      0x7d, 0x90, 0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8,
      0xb1, 0x0e, 0x38, 0xdb, 0x4a, 0x02, 0x16, 0x00, 0x00, 0x49,
      0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32, 0xd1, 0xf9,
      0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: appending unused 0's to integer
    // tcID: 96
    {SEC_OID_SHA1,
     96,
     {0x30, 0x2f, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf,
      0x7d, 0x90, 0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8,
      0xb1, 0x0e, 0x38, 0xdb, 0x4a, 0x00, 0x00, 0x02, 0x14, 0x49,
      0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32, 0xd1, 0xf9,
      0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: appending null value to integer
    // tcID: 97
    {SEC_OID_SHA1,
     97,
     {0x30, 0x2f, 0x02, 0x17, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf,
      0x7d, 0x90, 0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8,
      0xb1, 0x0e, 0x38, 0xdb, 0x4a, 0x05, 0x00, 0x02, 0x14, 0x49,
      0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32, 0xd1, 0xf9,
      0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: appending null value to integer
    // tcID: 98
    {SEC_OID_SHA1,
     98,
     {0x30, 0x2f, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf,
      0x7d, 0x90, 0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8,
      0xb1, 0x0e, 0x38, 0xdb, 0x4a, 0x02, 0x16, 0x49, 0x6d, 0x52,
      0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32, 0xd1, 0xf9, 0x91, 0x20,
      0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b, 0x05, 0x00},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: truncated length of integer
    // tcID: 99
    {SEC_OID_SHA1,
     99,
     {0x30, 0x18, 0x02, 0x81, 0x02, 0x14, 0x49, 0x6d, 0x52,
      0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32, 0xd1, 0xf9, 0x91,
      0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: truncated length of integer
    // tcID: 100
    {SEC_OID_SHA1,
     100,
     {0x30, 0x19, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f,
      0xbf, 0x7d, 0x90, 0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37,
      0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb, 0x4a, 0x02, 0x81},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Replacing integer with NULL
    // tcID: 101
    {SEC_OID_SHA1,
     101,
     {0x30, 0x18, 0x05, 0x00, 0x02, 0x14, 0x49, 0x6d, 0x52,
      0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32, 0xd1, 0xf9, 0x91,
      0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Replacing integer with NULL
    // tcID: 102
    {SEC_OID_SHA1,
     102,
     {0x30, 0x19, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f,
      0xbf, 0x7d, 0x90, 0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37,
      0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb, 0x4a, 0x05, 0x00},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: changing tag value of integer
    // tcID: 103
    {SEC_OID_SHA1,
     103,
     {0x30, 0x2d, 0x00, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d, 0x90,
      0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb,
      0x4a, 0x02, 0x14, 0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32,
      0xd1, 0xf9, 0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: changing tag value of integer
    // tcID: 104
    {SEC_OID_SHA1,
     104,
     {0x30, 0x2d, 0x01, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d, 0x90,
      0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb,
      0x4a, 0x02, 0x14, 0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32,
      0xd1, 0xf9, 0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: changing tag value of integer
    // tcID: 105
    {SEC_OID_SHA1,
     105,
     {0x30, 0x2d, 0x03, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d, 0x90,
      0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb,
      0x4a, 0x02, 0x14, 0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32,
      0xd1, 0xf9, 0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: changing tag value of integer
    // tcID: 106
    {SEC_OID_SHA1,
     106,
     {0x30, 0x2d, 0x04, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d, 0x90,
      0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb,
      0x4a, 0x02, 0x14, 0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32,
      0xd1, 0xf9, 0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: changing tag value of integer
    // tcID: 107
    {SEC_OID_SHA1,
     107,
     {0x30, 0x2d, 0xff, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d, 0x90,
      0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb,
      0x4a, 0x02, 0x14, 0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32,
      0xd1, 0xf9, 0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: changing tag value of integer
    // tcID: 108
    {SEC_OID_SHA1,
     108,
     {0x30, 0x2d, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d, 0x90,
      0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb,
      0x4a, 0x00, 0x14, 0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32,
      0xd1, 0xf9, 0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: changing tag value of integer
    // tcID: 109
    {SEC_OID_SHA1,
     109,
     {0x30, 0x2d, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d, 0x90,
      0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb,
      0x4a, 0x01, 0x14, 0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32,
      0xd1, 0xf9, 0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: changing tag value of integer
    // tcID: 110
    {SEC_OID_SHA1,
     110,
     {0x30, 0x2d, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d, 0x90,
      0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb,
      0x4a, 0x03, 0x14, 0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32,
      0xd1, 0xf9, 0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: changing tag value of integer
    // tcID: 111
    {SEC_OID_SHA1,
     111,
     {0x30, 0x2d, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d, 0x90,
      0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb,
      0x4a, 0x04, 0x14, 0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32,
      0xd1, 0xf9, 0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: changing tag value of integer
    // tcID: 112
    {SEC_OID_SHA1,
     112,
     {0x30, 0x2d, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d, 0x90,
      0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb,
      0x4a, 0xff, 0x14, 0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32,
      0xd1, 0xf9, 0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: dropping value of integer
    // tcID: 113
    {SEC_OID_SHA1,
     113,
     {0x30, 0x18, 0x02, 0x00, 0x02, 0x14, 0x49, 0x6d, 0x52,
      0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32, 0xd1, 0xf9, 0x91,
      0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: dropping value of integer
    // tcID: 114
    {SEC_OID_SHA1,
     114,
     {0x30, 0x19, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f,
      0xbf, 0x7d, 0x90, 0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37,
      0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb, 0x4a, 0x02, 0x00},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: using composition for integer
    // tcID: 115
    {SEC_OID_SHA1,
     115,
     {0x30, 0x31, 0x22, 0x19, 0x02, 0x01, 0x00, 0x02, 0x14, 0xaa, 0x6a,
      0x25, 0x8f, 0xbf, 0x7d, 0x90, 0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37,
      0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb, 0x4a, 0x02, 0x14, 0x49, 0x6d,
      0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32, 0xd1, 0xf9, 0x91, 0x20,
      0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: using composition for integer
    // tcID: 116
    {SEC_OID_SHA1,
     116,
     {0x30, 0x31, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d,
      0x90, 0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e,
      0x38, 0xdb, 0x4a, 0x22, 0x18, 0x02, 0x01, 0x49, 0x02, 0x13, 0x6d,
      0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32, 0xd1, 0xf9, 0x91, 0x20,
      0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: modify first byte of integer
    // tcID: 117
    {SEC_OID_SHA1,
     117,
     {0x30, 0x2d, 0x02, 0x15, 0x02, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d, 0x90,
      0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb,
      0x4a, 0x02, 0x14, 0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32,
      0xd1, 0xf9, 0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: modify first byte of integer
    // tcID: 118
    {SEC_OID_SHA1,
     118,
     {0x30, 0x2d, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d, 0x90,
      0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb,
      0x4a, 0x02, 0x14, 0x4b, 0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32,
      0xd1, 0xf9, 0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: modify last byte of integer
    // tcID: 119
    {SEC_OID_SHA1,
     119,
     {0x30, 0x2d, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d, 0x90,
      0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb,
      0xca, 0x02, 0x14, 0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32,
      0xd1, 0xf9, 0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: modify last byte of integer
    // tcID: 120
    {SEC_OID_SHA1,
     120,
     {0x30, 0x2d, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d, 0x90,
      0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb,
      0x4a, 0x02, 0x14, 0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32,
      0xd1, 0xf9, 0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0xbb},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: truncated integer
    // tcID: 121
    {SEC_OID_SHA1,
     121,
     {0x30, 0x2c, 0x02, 0x14, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d, 0x90,
      0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb,
      0x02, 0x14, 0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32, 0xd1,
      0xf9, 0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: truncated integer
    // tcID: 122
    {SEC_OID_SHA1,
     122,
     {0x30, 0x2c, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d, 0x90,
      0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb,
      0x4a, 0x02, 0x13, 0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32,
      0xd1, 0xf9, 0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: truncated integer
    // tcID: 123
    {SEC_OID_SHA1,
     123,
     {0x30, 0x2c, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d, 0x90,
      0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb,
      0x4a, 0x02, 0x13, 0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32, 0xd1,
      0xf9, 0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: leading ff in integer
    // tcID: 124
    {SEC_OID_SHA1,
     124,
     {0x30, 0x2e, 0x02, 0x16, 0xff, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d,
      0x90, 0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e, 0x38,
      0xdb, 0x4a, 0x02, 0x14, 0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35,
      0x32, 0xd1, 0xf9, 0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: leading ff in integer
    // tcID: 125
    {SEC_OID_SHA1,
     125,
     {0x30, 0x2e, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d, 0x90,
      0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb,
      0x4a, 0x02, 0x15, 0xff, 0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35,
      0x32, 0xd1, 0xf9, 0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: replaced integer by infinity
    // tcID: 126
    {SEC_OID_SHA1,
     126,
     {0x30, 0x19, 0x09, 0x01, 0x80, 0x02, 0x14, 0x49, 0x6d,
      0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32, 0xd1, 0xf9,
      0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: replaced integer by infinity
    // tcID: 127
    {SEC_OID_SHA1,
     127,
     {0x30, 0x1a, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf,
      0x7d, 0x90, 0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8,
      0xb1, 0x0e, 0x38, 0xdb, 0x4a, 0x09, 0x01, 0x80},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: replacing integer with zero
    // tcID: 128
    {SEC_OID_SHA1,
     128,
     {0x30, 0x19, 0x02, 0x01, 0x00, 0x02, 0x14, 0x49, 0x6d,
      0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32, 0xd1, 0xf9,
      0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: replacing integer with zero
    // tcID: 129
    {SEC_OID_SHA1,
     129,
     {0x30, 0x1a, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf,
      0x7d, 0x90, 0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8,
      0xb1, 0x0e, 0x38, 0xdb, 0x4a, 0x02, 0x01, 0x00},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the group order
    // tcID: 130
    {SEC_OID_SHA1,
     130,
     {0x30, 0x2d, 0x02, 0x15, 0x01, 0x63, 0x75, 0x5e, 0x49, 0xc9, 0xce, 0x35,
      0x20, 0x1c, 0x9d, 0xf4, 0xac, 0xd2, 0xe5, 0xfd, 0x48, 0x86, 0x2d, 0x64,
      0xfb, 0x02, 0x14, 0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32,
      0xd1, 0xf9, 0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the group order
    // tcID: 131
    {SEC_OID_SHA1,
     131,
     {0x30, 0x2c, 0x02, 0x14, 0xf1, 0x5e, 0xec, 0xd5, 0xb5, 0x2c, 0xec, 0xa2,
      0x8f, 0x8a, 0xda, 0x2d, 0x9c, 0x15, 0xf4, 0x19, 0x96, 0x44, 0x51, 0x99,
      0x02, 0x14, 0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32, 0xd1,
      0xf9, 0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the group order
    // tcID: 132
    {SEC_OID_SHA1,
     132,
     {0x30, 0x2d, 0x02, 0x15, 0xff, 0x55, 0x95, 0xda, 0x70, 0x40, 0x82, 0x6f,
      0x1e, 0xa9, 0xeb, 0x98, 0x92, 0xc8, 0x82, 0x07, 0x4e, 0xf1, 0xc7, 0x24,
      0xb6, 0x02, 0x14, 0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32,
      0xd1, 0xf9, 0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the group order
    // tcID: 133
    {SEC_OID_SHA1,
     133,
     {0x30, 0x2c, 0x02, 0x14, 0x0e, 0xa1, 0x13, 0x2a, 0x4a, 0xd3, 0x13, 0x5d,
      0x70, 0x75, 0x25, 0xd2, 0x63, 0xea, 0x0b, 0xe6, 0x69, 0xbb, 0xae, 0x67,
      0x02, 0x14, 0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32, 0xd1,
      0xf9, 0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the group order
    // tcID: 134
    {SEC_OID_SHA1,
     134,
     {0x30, 0x2d, 0x02, 0x15, 0xfe, 0x9c, 0x8a, 0xa1, 0xb6, 0x36, 0x31, 0xca,
      0xdf, 0xe3, 0x62, 0x0b, 0x53, 0x2d, 0x1a, 0x02, 0xb7, 0x79, 0xd2, 0x9b,
      0x05, 0x02, 0x14, 0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32,
      0xd1, 0xf9, 0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the group order
    // tcID: 135
    {SEC_OID_SHA1,
     135,
     {0x30, 0x2d, 0x02, 0x15, 0x01, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d, 0x90,
      0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb,
      0x4a, 0x02, 0x14, 0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32,
      0xd1, 0xf9, 0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the group order
    // tcID: 136
    {SEC_OID_SHA1,
     136,
     {0x30, 0x2c, 0x02, 0x14, 0x55, 0x95, 0xda, 0x70, 0x40, 0x82, 0x6f, 0x1e,
      0xa9, 0xeb, 0x98, 0x92, 0xc8, 0x82, 0x07, 0x4e, 0xf1, 0xc7, 0x24, 0xb6,
      0x02, 0x14, 0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35, 0x32, 0xd1,
      0xf9, 0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the group order
    // tcID: 137
    {SEC_OID_SHA1,
     137,
     {0x30, 0x2e, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d, 0x90,
      0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb,
      0x4a, 0x02, 0x15, 0x01, 0x02, 0x78, 0x8a, 0xda, 0xc0, 0x47, 0x21, 0x73,
      0xf9, 0x5b, 0x86, 0xd0, 0xbb, 0xa3, 0xc7, 0xe9, 0xb3, 0x8a, 0xd5, 0xec},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the group order
    // tcID: 138
    {SEC_OID_SHA1,
     138,
     {0x30, 0x2d, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d, 0x90,
      0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb,
      0x4a, 0x02, 0x14, 0x90, 0x62, 0x19, 0x66, 0xab, 0xa5, 0xd8, 0xf6, 0x6c,
      0x48, 0x6c, 0x51, 0x84, 0xd3, 0xbe, 0xba, 0xc3, 0xa1, 0xc2, 0x8a},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the group order
    // tcID: 139
    {SEC_OID_SHA1,
     139,
     {0x30, 0x2d, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d, 0x90,
      0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb,
      0x4a, 0x02, 0x14, 0xb6, 0x92, 0xad, 0xdf, 0x4a, 0x09, 0x82, 0xca, 0xcd,
      0x2e, 0x06, 0x6e, 0xdf, 0xc4, 0x3c, 0xad, 0xc4, 0x69, 0xb3, 0xc5},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the group order
    // tcID: 140
    {SEC_OID_SHA1,
     140,
     {0x30, 0x2d, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d, 0x90,
      0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb,
      0x4a, 0x02, 0x14, 0x6f, 0x9d, 0xe6, 0x99, 0x54, 0x5a, 0x27, 0x09, 0x93,
      0xb7, 0x93, 0xae, 0x7b, 0x2c, 0x41, 0x45, 0x3c, 0x5e, 0x3d, 0x76},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the group order
    // tcID: 141
    {SEC_OID_SHA1,
     141,
     {0x30, 0x2e, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d, 0x90,
      0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb,
      0x4a, 0x02, 0x15, 0xfe, 0xfd, 0x87, 0x75, 0x25, 0x3f, 0xb8, 0xde, 0x8c,
      0x06, 0xa4, 0x79, 0x2f, 0x44, 0x5c, 0x38, 0x16, 0x4c, 0x75, 0x2a, 0x14},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the group order
    // tcID: 142
    {SEC_OID_SHA1,
     142,
     {0x30, 0x2e, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d, 0x90,
      0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb,
      0x4a, 0x02, 0x15, 0x01, 0x49, 0x6d, 0x52, 0x20, 0xb5, 0xf6, 0x7d, 0x35,
      0x32, 0xd1, 0xf9, 0x91, 0x20, 0x3b, 0xc3, 0x52, 0x3b, 0x96, 0x4c, 0x3b},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the group order
    // tcID: 143
    {SEC_OID_SHA1,
     143,
     {0x30, 0x2e, 0x02, 0x15, 0x00, 0xaa, 0x6a, 0x25, 0x8f, 0xbf, 0x7d, 0x90,
      0xe1, 0x56, 0x14, 0x67, 0x6d, 0x37, 0x7d, 0xf8, 0xb1, 0x0e, 0x38, 0xdb,
      0x4a, 0x02, 0x15, 0x00, 0xb6, 0x92, 0xad, 0xdf, 0x4a, 0x09, 0x82, 0xca,
      0xcd, 0x2e, 0x06, 0x6e, 0xdf, 0xc4, 0x3c, 0xad, 0xc4, 0x69, 0xb3, 0xc5},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 144
    {SEC_OID_SHA1,
     144,
     {0x30, 0x1a, 0x02, 0x01, 0x00, 0x02, 0x15, 0xff, 0x46, 0xf4,
      0xc7, 0x45, 0xf5, 0xaf, 0x5b, 0xc1, 0x39, 0x76, 0x72, 0xc0,
      0x64, 0x97, 0xfb, 0x68, 0x88, 0x0b, 0x76, 0x4f},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 145
    {SEC_OID_SHA1,
     145,
     {0x30, 0x06, 0x02, 0x01, 0x00, 0x02, 0x01, 0x00},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 146
    {SEC_OID_SHA1,
     146,
     {0x30, 0x06, 0x02, 0x01, 0x00, 0x02, 0x01, 0x01},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 147
    {SEC_OID_SHA1,
     147,
     {0x30, 0x06, 0x02, 0x01, 0x00, 0x02, 0x01, 0xff},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 148
    {SEC_OID_SHA1,
     148,
     {0x30, 0x19, 0x02, 0x01, 0x00, 0x02, 0x14, 0x5c, 0x85,
      0x9c, 0x5d, 0x05, 0x28, 0x52, 0x1f, 0x63, 0x44, 0xc6,
      0x9f, 0xcd, 0xb4, 0x02, 0x4b, 0xbb, 0xfa, 0x44, 0xd8},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 149
    {SEC_OID_SHA1,
     149,
     {0x30, 0x19, 0x02, 0x01, 0x00, 0x02, 0x14, 0x5c, 0x85,
      0x9c, 0x5d, 0x05, 0x28, 0x52, 0x1f, 0x63, 0x44, 0xc6,
      0x9f, 0xcd, 0xb4, 0x02, 0x4b, 0xbb, 0xfa, 0x44, 0xd9},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 150
    {SEC_OID_SHA1,
     150,
     {0x30, 0x1a, 0x02, 0x01, 0x00, 0x02, 0x15, 0x00, 0xb9, 0x0b,
      0x38, 0xba, 0x0a, 0x50, 0xa4, 0x3e, 0xc6, 0x89, 0x8d, 0x3f,
      0x9b, 0x68, 0x04, 0x97, 0x77, 0xf4, 0x89, 0xb0},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 151
    {SEC_OID_SHA1,
     151,
     {0x30, 0x1a, 0x02, 0x01, 0x00, 0x02, 0x15, 0x00, 0xb9, 0x0b,
      0x38, 0xba, 0x0a, 0x50, 0xa4, 0x3e, 0xc6, 0x89, 0x8d, 0x3f,
      0x9b, 0x68, 0x04, 0x97, 0x77, 0xf4, 0x89, 0xb1},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 152
    {SEC_OID_SHA1,
     152,
     {0x30, 0x1a, 0x02, 0x01, 0x00, 0x02, 0x15, 0x00, 0xb9, 0x0b,
      0x38, 0xba, 0x0a, 0x50, 0xa4, 0x3e, 0xc6, 0x89, 0x8d, 0x3f,
      0x9b, 0x68, 0x04, 0x97, 0x77, 0xf4, 0x89, 0xb2},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 153
    {SEC_OID_SHA1,
     153,
     {0x30, 0x1a, 0x02, 0x01, 0x00, 0x02, 0x15, 0x01, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 154
    {SEC_OID_SHA1,
     154,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x02, 0x81, 0x81, 0x00, 0xb3, 0x4c,
      0xe9, 0xc1, 0xe7, 0x82, 0x94, 0xd3, 0x25, 0x84, 0x73, 0x84, 0x20, 0x05,
      0xd2, 0xa4, 0x8c, 0x8c, 0x56, 0x6c, 0xfc, 0xa8, 0xf8, 0x4c, 0x06, 0x06,
      0xf2, 0x52, 0x9b, 0x59, 0xa6, 0xd3, 0x8a, 0xae, 0x07, 0x1b, 0x53, 0xbb,
      0x21, 0x67, 0xea, 0xa4, 0xfc, 0x3b, 0x01, 0xfe, 0x17, 0x6e, 0x78, 0x7e,
      0x48, 0x1b, 0x60, 0x37, 0xaa, 0xc6, 0x2c, 0xbc, 0x3d, 0x08, 0x97, 0x99,
      0x53, 0x6a, 0x86, 0x9f, 0xa8, 0xcd, 0xfe, 0xa1, 0xe8, 0xb1, 0xfd, 0x2d,
      0x1c, 0xd3, 0xa3, 0x03, 0x50, 0x85, 0x9a, 0x2c, 0xd6, 0xb3, 0xec, 0x2f,
      0x9b, 0xfb, 0xb6, 0x8b, 0xb1, 0x1b, 0x4b, 0xbe, 0x2a, 0xda, 0xa1, 0x8d,
      0x64, 0xa9, 0x36, 0x39, 0x54, 0x3a, 0xe5, 0xe1, 0x62, 0x93, 0xe3, 0x11,
      0xc0, 0xcf, 0x8c, 0x8d, 0x6e, 0x18, 0x0d, 0xf0, 0x5d, 0x08, 0xc2, 0xfd,
      0x2d, 0x93, 0xd5, 0x70, 0x75, 0x1f},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 155
    {SEC_OID_SHA1,
     155,
     {0x30, 0x08, 0x02, 0x01, 0x00, 0x09, 0x03, 0x80, 0xfe, 0x01},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 156
    {SEC_OID_SHA1,
     156,
     {0x30, 0x06, 0x02, 0x01, 0x00, 0x09, 0x01, 0x42},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 157
    {SEC_OID_SHA1,
     157,
     {0x30, 0x1a, 0x02, 0x01, 0x01, 0x02, 0x15, 0xff, 0x46, 0xf4,
      0xc7, 0x45, 0xf5, 0xaf, 0x5b, 0xc1, 0x39, 0x76, 0x72, 0xc0,
      0x64, 0x97, 0xfb, 0x68, 0x88, 0x0b, 0x76, 0x4f},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 158
    {SEC_OID_SHA1,
     158,
     {0x30, 0x06, 0x02, 0x01, 0x01, 0x02, 0x01, 0x00},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 159
    {SEC_OID_SHA1,
     159,
     {0x30, 0x06, 0x02, 0x01, 0x01, 0x02, 0x01, 0x01},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 160
    {SEC_OID_SHA1,
     160,
     {0x30, 0x06, 0x02, 0x01, 0x01, 0x02, 0x01, 0xff},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 161
    {SEC_OID_SHA1,
     161,
     {0x30, 0x19, 0x02, 0x01, 0x01, 0x02, 0x14, 0x5c, 0x85,
      0x9c, 0x5d, 0x05, 0x28, 0x52, 0x1f, 0x63, 0x44, 0xc6,
      0x9f, 0xcd, 0xb4, 0x02, 0x4b, 0xbb, 0xfa, 0x44, 0xd8},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 162
    {SEC_OID_SHA1,
     162,
     {0x30, 0x19, 0x02, 0x01, 0x01, 0x02, 0x14, 0x5c, 0x85,
      0x9c, 0x5d, 0x05, 0x28, 0x52, 0x1f, 0x63, 0x44, 0xc6,
      0x9f, 0xcd, 0xb4, 0x02, 0x4b, 0xbb, 0xfa, 0x44, 0xd9},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 163
    {SEC_OID_SHA1,
     163,
     {0x30, 0x1a, 0x02, 0x01, 0x01, 0x02, 0x15, 0x00, 0xb9, 0x0b,
      0x38, 0xba, 0x0a, 0x50, 0xa4, 0x3e, 0xc6, 0x89, 0x8d, 0x3f,
      0x9b, 0x68, 0x04, 0x97, 0x77, 0xf4, 0x89, 0xb0},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 164
    {SEC_OID_SHA1,
     164,
     {0x30, 0x1a, 0x02, 0x01, 0x01, 0x02, 0x15, 0x00, 0xb9, 0x0b,
      0x38, 0xba, 0x0a, 0x50, 0xa4, 0x3e, 0xc6, 0x89, 0x8d, 0x3f,
      0x9b, 0x68, 0x04, 0x97, 0x77, 0xf4, 0x89, 0xb1},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 165
    {SEC_OID_SHA1,
     165,
     {0x30, 0x1a, 0x02, 0x01, 0x01, 0x02, 0x15, 0x00, 0xb9, 0x0b,
      0x38, 0xba, 0x0a, 0x50, 0xa4, 0x3e, 0xc6, 0x89, 0x8d, 0x3f,
      0x9b, 0x68, 0x04, 0x97, 0x77, 0xf4, 0x89, 0xb2},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 166
    {SEC_OID_SHA1,
     166,
     {0x30, 0x1a, 0x02, 0x01, 0x01, 0x02, 0x15, 0x01, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 167
    {SEC_OID_SHA1,
     167,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x01, 0x02, 0x81, 0x81, 0x00, 0xb3, 0x4c,
      0xe9, 0xc1, 0xe7, 0x82, 0x94, 0xd3, 0x25, 0x84, 0x73, 0x84, 0x20, 0x05,
      0xd2, 0xa4, 0x8c, 0x8c, 0x56, 0x6c, 0xfc, 0xa8, 0xf8, 0x4c, 0x06, 0x06,
      0xf2, 0x52, 0x9b, 0x59, 0xa6, 0xd3, 0x8a, 0xae, 0x07, 0x1b, 0x53, 0xbb,
      0x21, 0x67, 0xea, 0xa4, 0xfc, 0x3b, 0x01, 0xfe, 0x17, 0x6e, 0x78, 0x7e,
      0x48, 0x1b, 0x60, 0x37, 0xaa, 0xc6, 0x2c, 0xbc, 0x3d, 0x08, 0x97, 0x99,
      0x53, 0x6a, 0x86, 0x9f, 0xa8, 0xcd, 0xfe, 0xa1, 0xe8, 0xb1, 0xfd, 0x2d,
      0x1c, 0xd3, 0xa3, 0x03, 0x50, 0x85, 0x9a, 0x2c, 0xd6, 0xb3, 0xec, 0x2f,
      0x9b, 0xfb, 0xb6, 0x8b, 0xb1, 0x1b, 0x4b, 0xbe, 0x2a, 0xda, 0xa1, 0x8d,
      0x64, 0xa9, 0x36, 0x39, 0x54, 0x3a, 0xe5, 0xe1, 0x62, 0x93, 0xe3, 0x11,
      0xc0, 0xcf, 0x8c, 0x8d, 0x6e, 0x18, 0x0d, 0xf0, 0x5d, 0x08, 0xc2, 0xfd,
      0x2d, 0x93, 0xd5, 0x70, 0x75, 0x1f},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 168
    {SEC_OID_SHA1,
     168,
     {0x30, 0x08, 0x02, 0x01, 0x01, 0x09, 0x03, 0x80, 0xfe, 0x01},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 169
    {SEC_OID_SHA1,
     169,
     {0x30, 0x06, 0x02, 0x01, 0x01, 0x09, 0x01, 0x42},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 170
    {SEC_OID_SHA1,
     170,
     {0x30, 0x1a, 0x02, 0x01, 0xff, 0x02, 0x15, 0xff, 0x46, 0xf4,
      0xc7, 0x45, 0xf5, 0xaf, 0x5b, 0xc1, 0x39, 0x76, 0x72, 0xc0,
      0x64, 0x97, 0xfb, 0x68, 0x88, 0x0b, 0x76, 0x4f},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 171
    {SEC_OID_SHA1,
     171,
     {0x30, 0x06, 0x02, 0x01, 0xff, 0x02, 0x01, 0x00},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 172
    {SEC_OID_SHA1,
     172,
     {0x30, 0x06, 0x02, 0x01, 0xff, 0x02, 0x01, 0x01},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 173
    {SEC_OID_SHA1,
     173,
     {0x30, 0x06, 0x02, 0x01, 0xff, 0x02, 0x01, 0xff},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 174
    {SEC_OID_SHA1,
     174,
     {0x30, 0x19, 0x02, 0x01, 0xff, 0x02, 0x14, 0x5c, 0x85,
      0x9c, 0x5d, 0x05, 0x28, 0x52, 0x1f, 0x63, 0x44, 0xc6,
      0x9f, 0xcd, 0xb4, 0x02, 0x4b, 0xbb, 0xfa, 0x44, 0xd8},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 175
    {SEC_OID_SHA1,
     175,
     {0x30, 0x19, 0x02, 0x01, 0xff, 0x02, 0x14, 0x5c, 0x85,
      0x9c, 0x5d, 0x05, 0x28, 0x52, 0x1f, 0x63, 0x44, 0xc6,
      0x9f, 0xcd, 0xb4, 0x02, 0x4b, 0xbb, 0xfa, 0x44, 0xd9},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 176
    {SEC_OID_SHA1,
     176,
     {0x30, 0x1a, 0x02, 0x01, 0xff, 0x02, 0x15, 0x00, 0xb9, 0x0b,
      0x38, 0xba, 0x0a, 0x50, 0xa4, 0x3e, 0xc6, 0x89, 0x8d, 0x3f,
      0x9b, 0x68, 0x04, 0x97, 0x77, 0xf4, 0x89, 0xb0},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 177
    {SEC_OID_SHA1,
     177,
     {0x30, 0x1a, 0x02, 0x01, 0xff, 0x02, 0x15, 0x00, 0xb9, 0x0b,
      0x38, 0xba, 0x0a, 0x50, 0xa4, 0x3e, 0xc6, 0x89, 0x8d, 0x3f,
      0x9b, 0x68, 0x04, 0x97, 0x77, 0xf4, 0x89, 0xb1},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 178
    {SEC_OID_SHA1,
     178,
     {0x30, 0x1a, 0x02, 0x01, 0xff, 0x02, 0x15, 0x00, 0xb9, 0x0b,
      0x38, 0xba, 0x0a, 0x50, 0xa4, 0x3e, 0xc6, 0x89, 0x8d, 0x3f,
      0x9b, 0x68, 0x04, 0x97, 0x77, 0xf4, 0x89, 0xb2},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 179
    {SEC_OID_SHA1,
     179,
     {0x30, 0x1a, 0x02, 0x01, 0xff, 0x02, 0x15, 0x01, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 180
    {SEC_OID_SHA1,
     180,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0xff, 0x02, 0x81, 0x81, 0x00, 0xb3, 0x4c,
      0xe9, 0xc1, 0xe7, 0x82, 0x94, 0xd3, 0x25, 0x84, 0x73, 0x84, 0x20, 0x05,
      0xd2, 0xa4, 0x8c, 0x8c, 0x56, 0x6c, 0xfc, 0xa8, 0xf8, 0x4c, 0x06, 0x06,
      0xf2, 0x52, 0x9b, 0x59, 0xa6, 0xd3, 0x8a, 0xae, 0x07, 0x1b, 0x53, 0xbb,
      0x21, 0x67, 0xea, 0xa4, 0xfc, 0x3b, 0x01, 0xfe, 0x17, 0x6e, 0x78, 0x7e,
      0x48, 0x1b, 0x60, 0x37, 0xaa, 0xc6, 0x2c, 0xbc, 0x3d, 0x08, 0x97, 0x99,
      0x53, 0x6a, 0x86, 0x9f, 0xa8, 0xcd, 0xfe, 0xa1, 0xe8, 0xb1, 0xfd, 0x2d,
      0x1c, 0xd3, 0xa3, 0x03, 0x50, 0x85, 0x9a, 0x2c, 0xd6, 0xb3, 0xec, 0x2f,
      0x9b, 0xfb, 0xb6, 0x8b, 0xb1, 0x1b, 0x4b, 0xbe, 0x2a, 0xda, 0xa1, 0x8d,
      0x64, 0xa9, 0x36, 0x39, 0x54, 0x3a, 0xe5, 0xe1, 0x62, 0x93, 0xe3, 0x11,
      0xc0, 0xcf, 0x8c, 0x8d, 0x6e, 0x18, 0x0d, 0xf0, 0x5d, 0x08, 0xc2, 0xfd,
      0x2d, 0x93, 0xd5, 0x70, 0x75, 0x1f},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 181
    {SEC_OID_SHA1,
     181,
     {0x30, 0x08, 0x02, 0x01, 0xff, 0x09, 0x03, 0x80, 0xfe, 0x01},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 182
    {SEC_OID_SHA1,
     182,
     {0x30, 0x06, 0x02, 0x01, 0xff, 0x09, 0x01, 0x42},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 183
    {SEC_OID_SHA1,
     183,
     {0x30, 0x2d, 0x02, 0x14, 0x5c, 0x85, 0x9c, 0x5d, 0x05, 0x28, 0x52, 0x1f,
      0x63, 0x44, 0xc6, 0x9f, 0xcd, 0xb4, 0x02, 0x4b, 0xbb, 0xfa, 0x44, 0xd8,
      0x02, 0x15, 0xff, 0x46, 0xf4, 0xc7, 0x45, 0xf5, 0xaf, 0x5b, 0xc1, 0x39,
      0x76, 0x72, 0xc0, 0x64, 0x97, 0xfb, 0x68, 0x88, 0x0b, 0x76, 0x4f},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 184
    {SEC_OID_SHA1,
     184,
     {0x30, 0x19, 0x02, 0x14, 0x5c, 0x85, 0x9c, 0x5d, 0x05,
      0x28, 0x52, 0x1f, 0x63, 0x44, 0xc6, 0x9f, 0xcd, 0xb4,
      0x02, 0x4b, 0xbb, 0xfa, 0x44, 0xd8, 0x02, 0x01, 0x00},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 185
    {SEC_OID_SHA1,
     185,
     {0x30, 0x19, 0x02, 0x14, 0x5c, 0x85, 0x9c, 0x5d, 0x05,
      0x28, 0x52, 0x1f, 0x63, 0x44, 0xc6, 0x9f, 0xcd, 0xb4,
      0x02, 0x4b, 0xbb, 0xfa, 0x44, 0xd8, 0x02, 0x01, 0x01},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 186
    {SEC_OID_SHA1,
     186,
     {0x30, 0x19, 0x02, 0x14, 0x5c, 0x85, 0x9c, 0x5d, 0x05,
      0x28, 0x52, 0x1f, 0x63, 0x44, 0xc6, 0x9f, 0xcd, 0xb4,
      0x02, 0x4b, 0xbb, 0xfa, 0x44, 0xd8, 0x02, 0x01, 0xff},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 187
    {SEC_OID_SHA1,
     187,
     {0x30, 0x2c, 0x02, 0x14, 0x5c, 0x85, 0x9c, 0x5d, 0x05, 0x28, 0x52, 0x1f,
      0x63, 0x44, 0xc6, 0x9f, 0xcd, 0xb4, 0x02, 0x4b, 0xbb, 0xfa, 0x44, 0xd8,
      0x02, 0x14, 0x5c, 0x85, 0x9c, 0x5d, 0x05, 0x28, 0x52, 0x1f, 0x63, 0x44,
      0xc6, 0x9f, 0xcd, 0xb4, 0x02, 0x4b, 0xbb, 0xfa, 0x44, 0xd8},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 188
    {SEC_OID_SHA1,
     188,
     {0x30, 0x2c, 0x02, 0x14, 0x5c, 0x85, 0x9c, 0x5d, 0x05, 0x28, 0x52, 0x1f,
      0x63, 0x44, 0xc6, 0x9f, 0xcd, 0xb4, 0x02, 0x4b, 0xbb, 0xfa, 0x44, 0xd8,
      0x02, 0x14, 0x5c, 0x85, 0x9c, 0x5d, 0x05, 0x28, 0x52, 0x1f, 0x63, 0x44,
      0xc6, 0x9f, 0xcd, 0xb4, 0x02, 0x4b, 0xbb, 0xfa, 0x44, 0xd9},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 189
    {SEC_OID_SHA1,
     189,
     {0x30, 0x2d, 0x02, 0x14, 0x5c, 0x85, 0x9c, 0x5d, 0x05, 0x28, 0x52, 0x1f,
      0x63, 0x44, 0xc6, 0x9f, 0xcd, 0xb4, 0x02, 0x4b, 0xbb, 0xfa, 0x44, 0xd8,
      0x02, 0x15, 0x00, 0xb9, 0x0b, 0x38, 0xba, 0x0a, 0x50, 0xa4, 0x3e, 0xc6,
      0x89, 0x8d, 0x3f, 0x9b, 0x68, 0x04, 0x97, 0x77, 0xf4, 0x89, 0xb0},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 190
    {SEC_OID_SHA1,
     190,
     {0x30, 0x2d, 0x02, 0x14, 0x5c, 0x85, 0x9c, 0x5d, 0x05, 0x28, 0x52, 0x1f,
      0x63, 0x44, 0xc6, 0x9f, 0xcd, 0xb4, 0x02, 0x4b, 0xbb, 0xfa, 0x44, 0xd8,
      0x02, 0x15, 0x00, 0xb9, 0x0b, 0x38, 0xba, 0x0a, 0x50, 0xa4, 0x3e, 0xc6,
      0x89, 0x8d, 0x3f, 0x9b, 0x68, 0x04, 0x97, 0x77, 0xf4, 0x89, 0xb1},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 191
    {SEC_OID_SHA1,
     191,
     {0x30, 0x2d, 0x02, 0x14, 0x5c, 0x85, 0x9c, 0x5d, 0x05, 0x28, 0x52, 0x1f,
      0x63, 0x44, 0xc6, 0x9f, 0xcd, 0xb4, 0x02, 0x4b, 0xbb, 0xfa, 0x44, 0xd8,
      0x02, 0x15, 0x00, 0xb9, 0x0b, 0x38, 0xba, 0x0a, 0x50, 0xa4, 0x3e, 0xc6,
      0x89, 0x8d, 0x3f, 0x9b, 0x68, 0x04, 0x97, 0x77, 0xf4, 0x89, 0xb2},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 192
    {SEC_OID_SHA1,
     192,
     {0x30, 0x2d, 0x02, 0x14, 0x5c, 0x85, 0x9c, 0x5d, 0x05, 0x28, 0x52, 0x1f,
      0x63, 0x44, 0xc6, 0x9f, 0xcd, 0xb4, 0x02, 0x4b, 0xbb, 0xfa, 0x44, 0xd8,
      0x02, 0x15, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 193
    {SEC_OID_SHA1,
     193,
     {0x30, 0x81, 0x9a, 0x02, 0x14, 0x5c, 0x85, 0x9c, 0x5d, 0x05, 0x28, 0x52,
      0x1f, 0x63, 0x44, 0xc6, 0x9f, 0xcd, 0xb4, 0x02, 0x4b, 0xbb, 0xfa, 0x44,
      0xd8, 0x02, 0x81, 0x81, 0x00, 0xb3, 0x4c, 0xe9, 0xc1, 0xe7, 0x82, 0x94,
      0xd3, 0x25, 0x84, 0x73, 0x84, 0x20, 0x05, 0xd2, 0xa4, 0x8c, 0x8c, 0x56,
      0x6c, 0xfc, 0xa8, 0xf8, 0x4c, 0x06, 0x06, 0xf2, 0x52, 0x9b, 0x59, 0xa6,
      0xd3, 0x8a, 0xae, 0x07, 0x1b, 0x53, 0xbb, 0x21, 0x67, 0xea, 0xa4, 0xfc,
      0x3b, 0x01, 0xfe, 0x17, 0x6e, 0x78, 0x7e, 0x48, 0x1b, 0x60, 0x37, 0xaa,
      0xc6, 0x2c, 0xbc, 0x3d, 0x08, 0x97, 0x99, 0x53, 0x6a, 0x86, 0x9f, 0xa8,
      0xcd, 0xfe, 0xa1, 0xe8, 0xb1, 0xfd, 0x2d, 0x1c, 0xd3, 0xa3, 0x03, 0x50,
      0x85, 0x9a, 0x2c, 0xd6, 0xb3, 0xec, 0x2f, 0x9b, 0xfb, 0xb6, 0x8b, 0xb1,
      0x1b, 0x4b, 0xbe, 0x2a, 0xda, 0xa1, 0x8d, 0x64, 0xa9, 0x36, 0x39, 0x54,
      0x3a, 0xe5, 0xe1, 0x62, 0x93, 0xe3, 0x11, 0xc0, 0xcf, 0x8c, 0x8d, 0x6e,
      0x18, 0x0d, 0xf0, 0x5d, 0x08, 0xc2, 0xfd, 0x2d, 0x93, 0xd5, 0x70, 0x75,
      0x1f},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 194
    {SEC_OID_SHA1,
     194,
     {0x30, 0x1b, 0x02, 0x14, 0x5c, 0x85, 0x9c, 0x5d, 0x05, 0x28,
      0x52, 0x1f, 0x63, 0x44, 0xc6, 0x9f, 0xcd, 0xb4, 0x02, 0x4b,
      0xbb, 0xfa, 0x44, 0xd8, 0x09, 0x03, 0x80, 0xfe, 0x01},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 195
    {SEC_OID_SHA1,
     195,
     {0x30, 0x19, 0x02, 0x14, 0x5c, 0x85, 0x9c, 0x5d, 0x05,
      0x28, 0x52, 0x1f, 0x63, 0x44, 0xc6, 0x9f, 0xcd, 0xb4,
      0x02, 0x4b, 0xbb, 0xfa, 0x44, 0xd8, 0x09, 0x01, 0x42},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 196
    {SEC_OID_SHA1,
     196,
     {0x30, 0x2d, 0x02, 0x14, 0x5c, 0x85, 0x9c, 0x5d, 0x05, 0x28, 0x52, 0x1f,
      0x63, 0x44, 0xc6, 0x9f, 0xcd, 0xb4, 0x02, 0x4b, 0xbb, 0xfa, 0x44, 0xd9,
      0x02, 0x15, 0xff, 0x46, 0xf4, 0xc7, 0x45, 0xf5, 0xaf, 0x5b, 0xc1, 0x39,
      0x76, 0x72, 0xc0, 0x64, 0x97, 0xfb, 0x68, 0x88, 0x0b, 0x76, 0x4f},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 197
    {SEC_OID_SHA1,
     197,
     {0x30, 0x19, 0x02, 0x14, 0x5c, 0x85, 0x9c, 0x5d, 0x05,
      0x28, 0x52, 0x1f, 0x63, 0x44, 0xc6, 0x9f, 0xcd, 0xb4,
      0x02, 0x4b, 0xbb, 0xfa, 0x44, 0xd9, 0x02, 0x01, 0x00},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 198
    {SEC_OID_SHA1,
     198,
     {0x30, 0x19, 0x02, 0x14, 0x5c, 0x85, 0x9c, 0x5d, 0x05,
      0x28, 0x52, 0x1f, 0x63, 0x44, 0xc6, 0x9f, 0xcd, 0xb4,
      0x02, 0x4b, 0xbb, 0xfa, 0x44, 0xd9, 0x02, 0x01, 0x01},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 199
    {SEC_OID_SHA1,
     199,
     {0x30, 0x19, 0x02, 0x14, 0x5c, 0x85, 0x9c, 0x5d, 0x05,
      0x28, 0x52, 0x1f, 0x63, 0x44, 0xc6, 0x9f, 0xcd, 0xb4,
      0x02, 0x4b, 0xbb, 0xfa, 0x44, 0xd9, 0x02, 0x01, 0xff},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 200
    {SEC_OID_SHA1,
     200,
     {0x30, 0x2c, 0x02, 0x14, 0x5c, 0x85, 0x9c, 0x5d, 0x05, 0x28, 0x52, 0x1f,
      0x63, 0x44, 0xc6, 0x9f, 0xcd, 0xb4, 0x02, 0x4b, 0xbb, 0xfa, 0x44, 0xd9,
      0x02, 0x14, 0x5c, 0x85, 0x9c, 0x5d, 0x05, 0x28, 0x52, 0x1f, 0x63, 0x44,
      0xc6, 0x9f, 0xcd, 0xb4, 0x02, 0x4b, 0xbb, 0xfa, 0x44, 0xd8},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 201
    {SEC_OID_SHA1,
     201,
     {0x30, 0x2c, 0x02, 0x14, 0x5c, 0x85, 0x9c, 0x5d, 0x05, 0x28, 0x52, 0x1f,
      0x63, 0x44, 0xc6, 0x9f, 0xcd, 0xb4, 0x02, 0x4b, 0xbb, 0xfa, 0x44, 0xd9,
      0x02, 0x14, 0x5c, 0x85, 0x9c, 0x5d, 0x05, 0x28, 0x52, 0x1f, 0x63, 0x44,
      0xc6, 0x9f, 0xcd, 0xb4, 0x02, 0x4b, 0xbb, 0xfa, 0x44, 0xd9},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 202
    {SEC_OID_SHA1,
     202,
     {0x30, 0x2d, 0x02, 0x14, 0x5c, 0x85, 0x9c, 0x5d, 0x05, 0x28, 0x52, 0x1f,
      0x63, 0x44, 0xc6, 0x9f, 0xcd, 0xb4, 0x02, 0x4b, 0xbb, 0xfa, 0x44, 0xd9,
      0x02, 0x15, 0x00, 0xb9, 0x0b, 0x38, 0xba, 0x0a, 0x50, 0xa4, 0x3e, 0xc6,
      0x89, 0x8d, 0x3f, 0x9b, 0x68, 0x04, 0x97, 0x77, 0xf4, 0x89, 0xb0},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 203
    {SEC_OID_SHA1,
     203,
     {0x30, 0x2d, 0x02, 0x14, 0x5c, 0x85, 0x9c, 0x5d, 0x05, 0x28, 0x52, 0x1f,
      0x63, 0x44, 0xc6, 0x9f, 0xcd, 0xb4, 0x02, 0x4b, 0xbb, 0xfa, 0x44, 0xd9,
      0x02, 0x15, 0x00, 0xb9, 0x0b, 0x38, 0xba, 0x0a, 0x50, 0xa4, 0x3e, 0xc6,
      0x89, 0x8d, 0x3f, 0x9b, 0x68, 0x04, 0x97, 0x77, 0xf4, 0x89, 0xb1},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 204
    {SEC_OID_SHA1,
     204,
     {0x30, 0x2d, 0x02, 0x14, 0x5c, 0x85, 0x9c, 0x5d, 0x05, 0x28, 0x52, 0x1f,
      0x63, 0x44, 0xc6, 0x9f, 0xcd, 0xb4, 0x02, 0x4b, 0xbb, 0xfa, 0x44, 0xd9,
      0x02, 0x15, 0x00, 0xb9, 0x0b, 0x38, 0xba, 0x0a, 0x50, 0xa4, 0x3e, 0xc6,
      0x89, 0x8d, 0x3f, 0x9b, 0x68, 0x04, 0x97, 0x77, 0xf4, 0x89, 0xb2},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 205
    {SEC_OID_SHA1,
     205,
     {0x30, 0x2d, 0x02, 0x14, 0x5c, 0x85, 0x9c, 0x5d, 0x05, 0x28, 0x52, 0x1f,
      0x63, 0x44, 0xc6, 0x9f, 0xcd, 0xb4, 0x02, 0x4b, 0xbb, 0xfa, 0x44, 0xd9,
      0x02, 0x15, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 206
    {SEC_OID_SHA1,
     206,
     {0x30, 0x81, 0x9a, 0x02, 0x14, 0x5c, 0x85, 0x9c, 0x5d, 0x05, 0x28, 0x52,
      0x1f, 0x63, 0x44, 0xc6, 0x9f, 0xcd, 0xb4, 0x02, 0x4b, 0xbb, 0xfa, 0x44,
      0xd9, 0x02, 0x81, 0x81, 0x00, 0xb3, 0x4c, 0xe9, 0xc1, 0xe7, 0x82, 0x94,
      0xd3, 0x25, 0x84, 0x73, 0x84, 0x20, 0x05, 0xd2, 0xa4, 0x8c, 0x8c, 0x56,
      0x6c, 0xfc, 0xa8, 0xf8, 0x4c, 0x06, 0x06, 0xf2, 0x52, 0x9b, 0x59, 0xa6,
      0xd3, 0x8a, 0xae, 0x07, 0x1b, 0x53, 0xbb, 0x21, 0x67, 0xea, 0xa4, 0xfc,
      0x3b, 0x01, 0xfe, 0x17, 0x6e, 0x78, 0x7e, 0x48, 0x1b, 0x60, 0x37, 0xaa,
      0xc6, 0x2c, 0xbc, 0x3d, 0x08, 0x97, 0x99, 0x53, 0x6a, 0x86, 0x9f, 0xa8,
      0xcd, 0xfe, 0xa1, 0xe8, 0xb1, 0xfd, 0x2d, 0x1c, 0xd3, 0xa3, 0x03, 0x50,
      0x85, 0x9a, 0x2c, 0xd6, 0xb3, 0xec, 0x2f, 0x9b, 0xfb, 0xb6, 0x8b, 0xb1,
      0x1b, 0x4b, 0xbe, 0x2a, 0xda, 0xa1, 0x8d, 0x64, 0xa9, 0x36, 0x39, 0x54,
      0x3a, 0xe5, 0xe1, 0x62, 0x93, 0xe3, 0x11, 0xc0, 0xcf, 0x8c, 0x8d, 0x6e,
      0x18, 0x0d, 0xf0, 0x5d, 0x08, 0xc2, 0xfd, 0x2d, 0x93, 0xd5, 0x70, 0x75,
      0x1f},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 207
    {SEC_OID_SHA1,
     207,
     {0x30, 0x1b, 0x02, 0x14, 0x5c, 0x85, 0x9c, 0x5d, 0x05, 0x28,
      0x52, 0x1f, 0x63, 0x44, 0xc6, 0x9f, 0xcd, 0xb4, 0x02, 0x4b,
      0xbb, 0xfa, 0x44, 0xd9, 0x09, 0x03, 0x80, 0xfe, 0x01},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 208
    {SEC_OID_SHA1,
     208,
     {0x30, 0x19, 0x02, 0x14, 0x5c, 0x85, 0x9c, 0x5d, 0x05,
      0x28, 0x52, 0x1f, 0x63, 0x44, 0xc6, 0x9f, 0xcd, 0xb4,
      0x02, 0x4b, 0xbb, 0xfa, 0x44, 0xd9, 0x09, 0x01, 0x42},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 209
    {SEC_OID_SHA1,
     209,
     {0x30, 0x2e, 0x02, 0x15, 0x00, 0xb9, 0x0b, 0x38, 0xba, 0x0a, 0x50, 0xa4,
      0x3e, 0xc6, 0x89, 0x8d, 0x3f, 0x9b, 0x68, 0x04, 0x97, 0x77, 0xf4, 0x89,
      0xb0, 0x02, 0x15, 0xff, 0x46, 0xf4, 0xc7, 0x45, 0xf5, 0xaf, 0x5b, 0xc1,
      0x39, 0x76, 0x72, 0xc0, 0x64, 0x97, 0xfb, 0x68, 0x88, 0x0b, 0x76, 0x4f},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 210
    {SEC_OID_SHA1,
     210,
     {0x30, 0x1a, 0x02, 0x15, 0x00, 0xb9, 0x0b, 0x38, 0xba, 0x0a,
      0x50, 0xa4, 0x3e, 0xc6, 0x89, 0x8d, 0x3f, 0x9b, 0x68, 0x04,
      0x97, 0x77, 0xf4, 0x89, 0xb0, 0x02, 0x01, 0x00},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 211
    {SEC_OID_SHA1,
     211,
     {0x30, 0x1a, 0x02, 0x15, 0x00, 0xb9, 0x0b, 0x38, 0xba, 0x0a,
      0x50, 0xa4, 0x3e, 0xc6, 0x89, 0x8d, 0x3f, 0x9b, 0x68, 0x04,
      0x97, 0x77, 0xf4, 0x89, 0xb0, 0x02, 0x01, 0x01},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 212
    {SEC_OID_SHA1,
     212,
     {0x30, 0x1a, 0x02, 0x15, 0x00, 0xb9, 0x0b, 0x38, 0xba, 0x0a,
      0x50, 0xa4, 0x3e, 0xc6, 0x89, 0x8d, 0x3f, 0x9b, 0x68, 0x04,
      0x97, 0x77, 0xf4, 0x89, 0xb0, 0x02, 0x01, 0xff},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 213
    {SEC_OID_SHA1,
     213,
     {0x30, 0x2d, 0x02, 0x15, 0x00, 0xb9, 0x0b, 0x38, 0xba, 0x0a, 0x50, 0xa4,
      0x3e, 0xc6, 0x89, 0x8d, 0x3f, 0x9b, 0x68, 0x04, 0x97, 0x77, 0xf4, 0x89,
      0xb0, 0x02, 0x14, 0x5c, 0x85, 0x9c, 0x5d, 0x05, 0x28, 0x52, 0x1f, 0x63,
      0x44, 0xc6, 0x9f, 0xcd, 0xb4, 0x02, 0x4b, 0xbb, 0xfa, 0x44, 0xd8},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 214
    {SEC_OID_SHA1,
     214,
     {0x30, 0x2d, 0x02, 0x15, 0x00, 0xb9, 0x0b, 0x38, 0xba, 0x0a, 0x50, 0xa4,
      0x3e, 0xc6, 0x89, 0x8d, 0x3f, 0x9b, 0x68, 0x04, 0x97, 0x77, 0xf4, 0x89,
      0xb0, 0x02, 0x14, 0x5c, 0x85, 0x9c, 0x5d, 0x05, 0x28, 0x52, 0x1f, 0x63,
      0x44, 0xc6, 0x9f, 0xcd, 0xb4, 0x02, 0x4b, 0xbb, 0xfa, 0x44, 0xd9},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 215
    {SEC_OID_SHA1,
     215,
     {0x30, 0x2e, 0x02, 0x15, 0x00, 0xb9, 0x0b, 0x38, 0xba, 0x0a, 0x50, 0xa4,
      0x3e, 0xc6, 0x89, 0x8d, 0x3f, 0x9b, 0x68, 0x04, 0x97, 0x77, 0xf4, 0x89,
      0xb0, 0x02, 0x15, 0x00, 0xb9, 0x0b, 0x38, 0xba, 0x0a, 0x50, 0xa4, 0x3e,
      0xc6, 0x89, 0x8d, 0x3f, 0x9b, 0x68, 0x04, 0x97, 0x77, 0xf4, 0x89, 0xb0},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 216
    {SEC_OID_SHA1,
     216,
     {0x30, 0x2e, 0x02, 0x15, 0x00, 0xb9, 0x0b, 0x38, 0xba, 0x0a, 0x50, 0xa4,
      0x3e, 0xc6, 0x89, 0x8d, 0x3f, 0x9b, 0x68, 0x04, 0x97, 0x77, 0xf4, 0x89,
      0xb0, 0x02, 0x15, 0x00, 0xb9, 0x0b, 0x38, 0xba, 0x0a, 0x50, 0xa4, 0x3e,
      0xc6, 0x89, 0x8d, 0x3f, 0x9b, 0x68, 0x04, 0x97, 0x77, 0xf4, 0x89, 0xb1},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 217
    {SEC_OID_SHA1,
     217,
     {0x30, 0x2e, 0x02, 0x15, 0x00, 0xb9, 0x0b, 0x38, 0xba, 0x0a, 0x50, 0xa4,
      0x3e, 0xc6, 0x89, 0x8d, 0x3f, 0x9b, 0x68, 0x04, 0x97, 0x77, 0xf4, 0x89,
      0xb0, 0x02, 0x15, 0x00, 0xb9, 0x0b, 0x38, 0xba, 0x0a, 0x50, 0xa4, 0x3e,
      0xc6, 0x89, 0x8d, 0x3f, 0x9b, 0x68, 0x04, 0x97, 0x77, 0xf4, 0x89, 0xb2},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 218
    {SEC_OID_SHA1,
     218,
     {0x30, 0x2e, 0x02, 0x15, 0x00, 0xb9, 0x0b, 0x38, 0xba, 0x0a, 0x50, 0xa4,
      0x3e, 0xc6, 0x89, 0x8d, 0x3f, 0x9b, 0x68, 0x04, 0x97, 0x77, 0xf4, 0x89,
      0xb0, 0x02, 0x15, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 219
    {SEC_OID_SHA1,
     219,
     {0x30, 0x81, 0x9b, 0x02, 0x15, 0x00, 0xb9, 0x0b, 0x38, 0xba, 0x0a, 0x50,
      0xa4, 0x3e, 0xc6, 0x89, 0x8d, 0x3f, 0x9b, 0x68, 0x04, 0x97, 0x77, 0xf4,
      0x89, 0xb0, 0x02, 0x81, 0x81, 0x00, 0xb3, 0x4c, 0xe9, 0xc1, 0xe7, 0x82,
      0x94, 0xd3, 0x25, 0x84, 0x73, 0x84, 0x20, 0x05, 0xd2, 0xa4, 0x8c, 0x8c,
      0x56, 0x6c, 0xfc, 0xa8, 0xf8, 0x4c, 0x06, 0x06, 0xf2, 0x52, 0x9b, 0x59,
      0xa6, 0xd3, 0x8a, 0xae, 0x07, 0x1b, 0x53, 0xbb, 0x21, 0x67, 0xea, 0xa4,
      0xfc, 0x3b, 0x01, 0xfe, 0x17, 0x6e, 0x78, 0x7e, 0x48, 0x1b, 0x60, 0x37,
      0xaa, 0xc6, 0x2c, 0xbc, 0x3d, 0x08, 0x97, 0x99, 0x53, 0x6a, 0x86, 0x9f,
      0xa8, 0xcd, 0xfe, 0xa1, 0xe8, 0xb1, 0xfd, 0x2d, 0x1c, 0xd3, 0xa3, 0x03,
      0x50, 0x85, 0x9a, 0x2c, 0xd6, 0xb3, 0xec, 0x2f, 0x9b, 0xfb, 0xb6, 0x8b,
      0xb1, 0x1b, 0x4b, 0xbe, 0x2a, 0xda, 0xa1, 0x8d, 0x64, 0xa9, 0x36, 0x39,
      0x54, 0x3a, 0xe5, 0xe1, 0x62, 0x93, 0xe3, 0x11, 0xc0, 0xcf, 0x8c, 0x8d,
      0x6e, 0x18, 0x0d, 0xf0, 0x5d, 0x08, 0xc2, 0xfd, 0x2d, 0x93, 0xd5, 0x70,
      0x75, 0x1f},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 220
    {SEC_OID_SHA1,
     220,
     {0x30, 0x1c, 0x02, 0x15, 0x00, 0xb9, 0x0b, 0x38, 0xba, 0x0a,
      0x50, 0xa4, 0x3e, 0xc6, 0x89, 0x8d, 0x3f, 0x9b, 0x68, 0x04,
      0x97, 0x77, 0xf4, 0x89, 0xb0, 0x09, 0x03, 0x80, 0xfe, 0x01},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 221
    {SEC_OID_SHA1,
     221,
     {0x30, 0x1a, 0x02, 0x15, 0x00, 0xb9, 0x0b, 0x38, 0xba, 0x0a,
      0x50, 0xa4, 0x3e, 0xc6, 0x89, 0x8d, 0x3f, 0x9b, 0x68, 0x04,
      0x97, 0x77, 0xf4, 0x89, 0xb0, 0x09, 0x01, 0x42},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 222
    {SEC_OID_SHA1,
     222,
     {0x30, 0x2e, 0x02, 0x15, 0x00, 0xb9, 0x0b, 0x38, 0xba, 0x0a, 0x50, 0xa4,
      0x3e, 0xc6, 0x89, 0x8d, 0x3f, 0x9b, 0x68, 0x04, 0x97, 0x77, 0xf4, 0x89,
      0xb1, 0x02, 0x15, 0xff, 0x46, 0xf4, 0xc7, 0x45, 0xf5, 0xaf, 0x5b, 0xc1,
      0x39, 0x76, 0x72, 0xc0, 0x64, 0x97, 0xfb, 0x68, 0x88, 0x0b, 0x76, 0x4f},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 223
    {SEC_OID_SHA1,
     223,
     {0x30, 0x1a, 0x02, 0x15, 0x00, 0xb9, 0x0b, 0x38, 0xba, 0x0a,
      0x50, 0xa4, 0x3e, 0xc6, 0x89, 0x8d, 0x3f, 0x9b, 0x68, 0x04,
      0x97, 0x77, 0xf4, 0x89, 0xb1, 0x02, 0x01, 0x00},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 224
    {SEC_OID_SHA1,
     224,
     {0x30, 0x1a, 0x02, 0x15, 0x00, 0xb9, 0x0b, 0x38, 0xba, 0x0a,
      0x50, 0xa4, 0x3e, 0xc6, 0x89, 0x8d, 0x3f, 0x9b, 0x68, 0x04,
      0x97, 0x77, 0xf4, 0x89, 0xb1, 0x02, 0x01, 0x01},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 225
    {SEC_OID_SHA1,
     225,
     {0x30, 0x1a, 0x02, 0x15, 0x00, 0xb9, 0x0b, 0x38, 0xba, 0x0a,
      0x50, 0xa4, 0x3e, 0xc6, 0x89, 0x8d, 0x3f, 0x9b, 0x68, 0x04,
      0x97, 0x77, 0xf4, 0x89, 0xb1, 0x02, 0x01, 0xff},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 226
    {SEC_OID_SHA1,
     226,
     {0x30, 0x2d, 0x02, 0x15, 0x00, 0xb9, 0x0b, 0x38, 0xba, 0x0a, 0x50, 0xa4,
      0x3e, 0xc6, 0x89, 0x8d, 0x3f, 0x9b, 0x68, 0x04, 0x97, 0x77, 0xf4, 0x89,
      0xb1, 0x02, 0x14, 0x5c, 0x85, 0x9c, 0x5d, 0x05, 0x28, 0x52, 0x1f, 0x63,
      0x44, 0xc6, 0x9f, 0xcd, 0xb4, 0x02, 0x4b, 0xbb, 0xfa, 0x44, 0xd8},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 227
    {SEC_OID_SHA1,
     227,
     {0x30, 0x2d, 0x02, 0x15, 0x00, 0xb9, 0x0b, 0x38, 0xba, 0x0a, 0x50, 0xa4,
      0x3e, 0xc6, 0x89, 0x8d, 0x3f, 0x9b, 0x68, 0x04, 0x97, 0x77, 0xf4, 0x89,
      0xb1, 0x02, 0x14, 0x5c, 0x85, 0x9c, 0x5d, 0x05, 0x28, 0x52, 0x1f, 0x63,
      0x44, 0xc6, 0x9f, 0xcd, 0xb4, 0x02, 0x4b, 0xbb, 0xfa, 0x44, 0xd9},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 228
    {SEC_OID_SHA1,
     228,
     {0x30, 0x2e, 0x02, 0x15, 0x00, 0xb9, 0x0b, 0x38, 0xba, 0x0a, 0x50, 0xa4,
      0x3e, 0xc6, 0x89, 0x8d, 0x3f, 0x9b, 0x68, 0x04, 0x97, 0x77, 0xf4, 0x89,
      0xb1, 0x02, 0x15, 0x00, 0xb9, 0x0b, 0x38, 0xba, 0x0a, 0x50, 0xa4, 0x3e,
      0xc6, 0x89, 0x8d, 0x3f, 0x9b, 0x68, 0x04, 0x97, 0x77, 0xf4, 0x89, 0xb0},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 229
    {SEC_OID_SHA1,
     229,
     {0x30, 0x2e, 0x02, 0x15, 0x00, 0xb9, 0x0b, 0x38, 0xba, 0x0a, 0x50, 0xa4,
      0x3e, 0xc6, 0x89, 0x8d, 0x3f, 0x9b, 0x68, 0x04, 0x97, 0x77, 0xf4, 0x89,
      0xb1, 0x02, 0x15, 0x00, 0xb9, 0x0b, 0x38, 0xba, 0x0a, 0x50, 0xa4, 0x3e,
      0xc6, 0x89, 0x8d, 0x3f, 0x9b, 0x68, 0x04, 0x97, 0x77, 0xf4, 0x89, 0xb1},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 230
    {SEC_OID_SHA1,
     230,
     {0x30, 0x2e, 0x02, 0x15, 0x00, 0xb9, 0x0b, 0x38, 0xba, 0x0a, 0x50, 0xa4,
      0x3e, 0xc6, 0x89, 0x8d, 0x3f, 0x9b, 0x68, 0x04, 0x97, 0x77, 0xf4, 0x89,
      0xb1, 0x02, 0x15, 0x00, 0xb9, 0x0b, 0x38, 0xba, 0x0a, 0x50, 0xa4, 0x3e,
      0xc6, 0x89, 0x8d, 0x3f, 0x9b, 0x68, 0x04, 0x97, 0x77, 0xf4, 0x89, 0xb2},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 231
    {SEC_OID_SHA1,
     231,
     {0x30, 0x2e, 0x02, 0x15, 0x00, 0xb9, 0x0b, 0x38, 0xba, 0x0a, 0x50, 0xa4,
      0x3e, 0xc6, 0x89, 0x8d, 0x3f, 0x9b, 0x68, 0x04, 0x97, 0x77, 0xf4, 0x89,
      0xb1, 0x02, 0x15, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 232
    {SEC_OID_SHA1,
     232,
     {0x30, 0x81, 0x9b, 0x02, 0x15, 0x00, 0xb9, 0x0b, 0x38, 0xba, 0x0a, 0x50,
      0xa4, 0x3e, 0xc6, 0x89, 0x8d, 0x3f, 0x9b, 0x68, 0x04, 0x97, 0x77, 0xf4,
      0x89, 0xb1, 0x02, 0x81, 0x81, 0x00, 0xb3, 0x4c, 0xe9, 0xc1, 0xe7, 0x82,
      0x94, 0xd3, 0x25, 0x84, 0x73, 0x84, 0x20, 0x05, 0xd2, 0xa4, 0x8c, 0x8c,
      0x56, 0x6c, 0xfc, 0xa8, 0xf8, 0x4c, 0x06, 0x06, 0xf2, 0x52, 0x9b, 0x59,
      0xa6, 0xd3, 0x8a, 0xae, 0x07, 0x1b, 0x53, 0xbb, 0x21, 0x67, 0xea, 0xa4,
      0xfc, 0x3b, 0x01, 0xfe, 0x17, 0x6e, 0x78, 0x7e, 0x48, 0x1b, 0x60, 0x37,
      0xaa, 0xc6, 0x2c, 0xbc, 0x3d, 0x08, 0x97, 0x99, 0x53, 0x6a, 0x86, 0x9f,
      0xa8, 0xcd, 0xfe, 0xa1, 0xe8, 0xb1, 0xfd, 0x2d, 0x1c, 0xd3, 0xa3, 0x03,
      0x50, 0x85, 0x9a, 0x2c, 0xd6, 0xb3, 0xec, 0x2f, 0x9b, 0xfb, 0xb6, 0x8b,
      0xb1, 0x1b, 0x4b, 0xbe, 0x2a, 0xda, 0xa1, 0x8d, 0x64, 0xa9, 0x36, 0x39,
      0x54, 0x3a, 0xe5, 0xe1, 0x62, 0x93, 0xe3, 0x11, 0xc0, 0xcf, 0x8c, 0x8d,
      0x6e, 0x18, 0x0d, 0xf0, 0x5d, 0x08, 0xc2, 0xfd, 0x2d, 0x93, 0xd5, 0x70,
      0x75, 0x1f},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 233
    {SEC_OID_SHA1,
     233,
     {0x30, 0x1c, 0x02, 0x15, 0x00, 0xb9, 0x0b, 0x38, 0xba, 0x0a,
      0x50, 0xa4, 0x3e, 0xc6, 0x89, 0x8d, 0x3f, 0x9b, 0x68, 0x04,
      0x97, 0x77, 0xf4, 0x89, 0xb1, 0x09, 0x03, 0x80, 0xfe, 0x01},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 234
    {SEC_OID_SHA1,
     234,
     {0x30, 0x1a, 0x02, 0x15, 0x00, 0xb9, 0x0b, 0x38, 0xba, 0x0a,
      0x50, 0xa4, 0x3e, 0xc6, 0x89, 0x8d, 0x3f, 0x9b, 0x68, 0x04,
      0x97, 0x77, 0xf4, 0x89, 0xb1, 0x09, 0x01, 0x42},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 235
    {SEC_OID_SHA1,
     235,
     {0x30, 0x2e, 0x02, 0x15, 0x00, 0xb9, 0x0b, 0x38, 0xba, 0x0a, 0x50, 0xa4,
      0x3e, 0xc6, 0x89, 0x8d, 0x3f, 0x9b, 0x68, 0x04, 0x97, 0x77, 0xf4, 0x89,
      0xb2, 0x02, 0x15, 0xff, 0x46, 0xf4, 0xc7, 0x45, 0xf5, 0xaf, 0x5b, 0xc1,
      0x39, 0x76, 0x72, 0xc0, 0x64, 0x97, 0xfb, 0x68, 0x88, 0x0b, 0x76, 0x4f},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 236
    {SEC_OID_SHA1,
     236,
     {0x30, 0x1a, 0x02, 0x15, 0x00, 0xb9, 0x0b, 0x38, 0xba, 0x0a,
      0x50, 0xa4, 0x3e, 0xc6, 0x89, 0x8d, 0x3f, 0x9b, 0x68, 0x04,
      0x97, 0x77, 0xf4, 0x89, 0xb2, 0x02, 0x01, 0x00},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 237
    {SEC_OID_SHA1,
     237,
     {0x30, 0x1a, 0x02, 0x15, 0x00, 0xb9, 0x0b, 0x38, 0xba, 0x0a,
      0x50, 0xa4, 0x3e, 0xc6, 0x89, 0x8d, 0x3f, 0x9b, 0x68, 0x04,
      0x97, 0x77, 0xf4, 0x89, 0xb2, 0x02, 0x01, 0x01},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 238
    {SEC_OID_SHA1,
     238,
     {0x30, 0x1a, 0x02, 0x15, 0x00, 0xb9, 0x0b, 0x38, 0xba, 0x0a,
      0x50, 0xa4, 0x3e, 0xc6, 0x89, 0x8d, 0x3f, 0x9b, 0x68, 0x04,
      0x97, 0x77, 0xf4, 0x89, 0xb2, 0x02, 0x01, 0xff},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 239
    {SEC_OID_SHA1,
     239,
     {0x30, 0x2d, 0x02, 0x15, 0x00, 0xb9, 0x0b, 0x38, 0xba, 0x0a, 0x50, 0xa4,
      0x3e, 0xc6, 0x89, 0x8d, 0x3f, 0x9b, 0x68, 0x04, 0x97, 0x77, 0xf4, 0x89,
      0xb2, 0x02, 0x14, 0x5c, 0x85, 0x9c, 0x5d, 0x05, 0x28, 0x52, 0x1f, 0x63,
      0x44, 0xc6, 0x9f, 0xcd, 0xb4, 0x02, 0x4b, 0xbb, 0xfa, 0x44, 0xd8},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 240
    {SEC_OID_SHA1,
     240,
     {0x30, 0x2d, 0x02, 0x15, 0x00, 0xb9, 0x0b, 0x38, 0xba, 0x0a, 0x50, 0xa4,
      0x3e, 0xc6, 0x89, 0x8d, 0x3f, 0x9b, 0x68, 0x04, 0x97, 0x77, 0xf4, 0x89,
      0xb2, 0x02, 0x14, 0x5c, 0x85, 0x9c, 0x5d, 0x05, 0x28, 0x52, 0x1f, 0x63,
      0x44, 0xc6, 0x9f, 0xcd, 0xb4, 0x02, 0x4b, 0xbb, 0xfa, 0x44, 0xd9},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 241
    {SEC_OID_SHA1,
     241,
     {0x30, 0x2e, 0x02, 0x15, 0x00, 0xb9, 0x0b, 0x38, 0xba, 0x0a, 0x50, 0xa4,
      0x3e, 0xc6, 0x89, 0x8d, 0x3f, 0x9b, 0x68, 0x04, 0x97, 0x77, 0xf4, 0x89,
      0xb2, 0x02, 0x15, 0x00, 0xb9, 0x0b, 0x38, 0xba, 0x0a, 0x50, 0xa4, 0x3e,
      0xc6, 0x89, 0x8d, 0x3f, 0x9b, 0x68, 0x04, 0x97, 0x77, 0xf4, 0x89, 0xb0},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 242
    {SEC_OID_SHA1,
     242,
     {0x30, 0x2e, 0x02, 0x15, 0x00, 0xb9, 0x0b, 0x38, 0xba, 0x0a, 0x50, 0xa4,
      0x3e, 0xc6, 0x89, 0x8d, 0x3f, 0x9b, 0x68, 0x04, 0x97, 0x77, 0xf4, 0x89,
      0xb2, 0x02, 0x15, 0x00, 0xb9, 0x0b, 0x38, 0xba, 0x0a, 0x50, 0xa4, 0x3e,
      0xc6, 0x89, 0x8d, 0x3f, 0x9b, 0x68, 0x04, 0x97, 0x77, 0xf4, 0x89, 0xb1},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 243
    {SEC_OID_SHA1,
     243,
     {0x30, 0x2e, 0x02, 0x15, 0x00, 0xb9, 0x0b, 0x38, 0xba, 0x0a, 0x50, 0xa4,
      0x3e, 0xc6, 0x89, 0x8d, 0x3f, 0x9b, 0x68, 0x04, 0x97, 0x77, 0xf4, 0x89,
      0xb2, 0x02, 0x15, 0x00, 0xb9, 0x0b, 0x38, 0xba, 0x0a, 0x50, 0xa4, 0x3e,
      0xc6, 0x89, 0x8d, 0x3f, 0x9b, 0x68, 0x04, 0x97, 0x77, 0xf4, 0x89, 0xb2},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 244
    {SEC_OID_SHA1,
     244,
     {0x30, 0x2e, 0x02, 0x15, 0x00, 0xb9, 0x0b, 0x38, 0xba, 0x0a, 0x50, 0xa4,
      0x3e, 0xc6, 0x89, 0x8d, 0x3f, 0x9b, 0x68, 0x04, 0x97, 0x77, 0xf4, 0x89,
      0xb2, 0x02, 0x15, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 245
    {SEC_OID_SHA1,
     245,
     {0x30, 0x81, 0x9b, 0x02, 0x15, 0x00, 0xb9, 0x0b, 0x38, 0xba, 0x0a, 0x50,
      0xa4, 0x3e, 0xc6, 0x89, 0x8d, 0x3f, 0x9b, 0x68, 0x04, 0x97, 0x77, 0xf4,
      0x89, 0xb2, 0x02, 0x81, 0x81, 0x00, 0xb3, 0x4c, 0xe9, 0xc1, 0xe7, 0x82,
      0x94, 0xd3, 0x25, 0x84, 0x73, 0x84, 0x20, 0x05, 0xd2, 0xa4, 0x8c, 0x8c,
      0x56, 0x6c, 0xfc, 0xa8, 0xf8, 0x4c, 0x06, 0x06, 0xf2, 0x52, 0x9b, 0x59,
      0xa6, 0xd3, 0x8a, 0xae, 0x07, 0x1b, 0x53, 0xbb, 0x21, 0x67, 0xea, 0xa4,
      0xfc, 0x3b, 0x01, 0xfe, 0x17, 0x6e, 0x78, 0x7e, 0x48, 0x1b, 0x60, 0x37,
      0xaa, 0xc6, 0x2c, 0xbc, 0x3d, 0x08, 0x97, 0x99, 0x53, 0x6a, 0x86, 0x9f,
      0xa8, 0xcd, 0xfe, 0xa1, 0xe8, 0xb1, 0xfd, 0x2d, 0x1c, 0xd3, 0xa3, 0x03,
      0x50, 0x85, 0x9a, 0x2c, 0xd6, 0xb3, 0xec, 0x2f, 0x9b, 0xfb, 0xb6, 0x8b,
      0xb1, 0x1b, 0x4b, 0xbe, 0x2a, 0xda, 0xa1, 0x8d, 0x64, 0xa9, 0x36, 0x39,
      0x54, 0x3a, 0xe5, 0xe1, 0x62, 0x93, 0xe3, 0x11, 0xc0, 0xcf, 0x8c, 0x8d,
      0x6e, 0x18, 0x0d, 0xf0, 0x5d, 0x08, 0xc2, 0xfd, 0x2d, 0x93, 0xd5, 0x70,
      0x75, 0x1f},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 246
    {SEC_OID_SHA1,
     246,
     {0x30, 0x1c, 0x02, 0x15, 0x00, 0xb9, 0x0b, 0x38, 0xba, 0x0a,
      0x50, 0xa4, 0x3e, 0xc6, 0x89, 0x8d, 0x3f, 0x9b, 0x68, 0x04,
      0x97, 0x77, 0xf4, 0x89, 0xb2, 0x09, 0x03, 0x80, 0xfe, 0x01},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 247
    {SEC_OID_SHA1,
     247,
     {0x30, 0x1a, 0x02, 0x15, 0x00, 0xb9, 0x0b, 0x38, 0xba, 0x0a,
      0x50, 0xa4, 0x3e, 0xc6, 0x89, 0x8d, 0x3f, 0x9b, 0x68, 0x04,
      0x97, 0x77, 0xf4, 0x89, 0xb2, 0x09, 0x01, 0x42},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 248
    {SEC_OID_SHA1,
     248,
     {0x30, 0x2e, 0x02, 0x15, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x02, 0x15, 0xff, 0x46, 0xf4, 0xc7, 0x45, 0xf5, 0xaf, 0x5b, 0xc1,
      0x39, 0x76, 0x72, 0xc0, 0x64, 0x97, 0xfb, 0x68, 0x88, 0x0b, 0x76, 0x4f},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 249
    {SEC_OID_SHA1,
     249,
     {0x30, 0x1a, 0x02, 0x15, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x01, 0x00},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 250
    {SEC_OID_SHA1,
     250,
     {0x30, 0x1a, 0x02, 0x15, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x01, 0x01},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 251
    {SEC_OID_SHA1,
     251,
     {0x30, 0x1a, 0x02, 0x15, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x01, 0xff},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 252
    {SEC_OID_SHA1,
     252,
     {0x30, 0x2d, 0x02, 0x15, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x02, 0x14, 0x5c, 0x85, 0x9c, 0x5d, 0x05, 0x28, 0x52, 0x1f, 0x63,
      0x44, 0xc6, 0x9f, 0xcd, 0xb4, 0x02, 0x4b, 0xbb, 0xfa, 0x44, 0xd8},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 253
    {SEC_OID_SHA1,
     253,
     {0x30, 0x2d, 0x02, 0x15, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x02, 0x14, 0x5c, 0x85, 0x9c, 0x5d, 0x05, 0x28, 0x52, 0x1f, 0x63,
      0x44, 0xc6, 0x9f, 0xcd, 0xb4, 0x02, 0x4b, 0xbb, 0xfa, 0x44, 0xd9},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 254
    {SEC_OID_SHA1,
     254,
     {0x30, 0x2e, 0x02, 0x15, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x02, 0x15, 0x00, 0xb9, 0x0b, 0x38, 0xba, 0x0a, 0x50, 0xa4, 0x3e,
      0xc6, 0x89, 0x8d, 0x3f, 0x9b, 0x68, 0x04, 0x97, 0x77, 0xf4, 0x89, 0xb0},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 255
    {SEC_OID_SHA1,
     255,
     {0x30, 0x2e, 0x02, 0x15, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x02, 0x15, 0x00, 0xb9, 0x0b, 0x38, 0xba, 0x0a, 0x50, 0xa4, 0x3e,
      0xc6, 0x89, 0x8d, 0x3f, 0x9b, 0x68, 0x04, 0x97, 0x77, 0xf4, 0x89, 0xb1},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 256
    {SEC_OID_SHA1,
     256,
     {0x30, 0x2e, 0x02, 0x15, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x02, 0x15, 0x00, 0xb9, 0x0b, 0x38, 0xba, 0x0a, 0x50, 0xa4, 0x3e,
      0xc6, 0x89, 0x8d, 0x3f, 0x9b, 0x68, 0x04, 0x97, 0x77, 0xf4, 0x89, 0xb2},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 257
    {SEC_OID_SHA1,
     257,
     {0x30, 0x2e, 0x02, 0x15, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x02, 0x15, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 258
    {SEC_OID_SHA1,
     258,
     {0x30, 0x81, 0x9b, 0x02, 0x15, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x02, 0x81, 0x81, 0x00, 0xb3, 0x4c, 0xe9, 0xc1, 0xe7, 0x82,
      0x94, 0xd3, 0x25, 0x84, 0x73, 0x84, 0x20, 0x05, 0xd2, 0xa4, 0x8c, 0x8c,
      0x56, 0x6c, 0xfc, 0xa8, 0xf8, 0x4c, 0x06, 0x06, 0xf2, 0x52, 0x9b, 0x59,
      0xa6, 0xd3, 0x8a, 0xae, 0x07, 0x1b, 0x53, 0xbb, 0x21, 0x67, 0xea, 0xa4,
      0xfc, 0x3b, 0x01, 0xfe, 0x17, 0x6e, 0x78, 0x7e, 0x48, 0x1b, 0x60, 0x37,
      0xaa, 0xc6, 0x2c, 0xbc, 0x3d, 0x08, 0x97, 0x99, 0x53, 0x6a, 0x86, 0x9f,
      0xa8, 0xcd, 0xfe, 0xa1, 0xe8, 0xb1, 0xfd, 0x2d, 0x1c, 0xd3, 0xa3, 0x03,
      0x50, 0x85, 0x9a, 0x2c, 0xd6, 0xb3, 0xec, 0x2f, 0x9b, 0xfb, 0xb6, 0x8b,
      0xb1, 0x1b, 0x4b, 0xbe, 0x2a, 0xda, 0xa1, 0x8d, 0x64, 0xa9, 0x36, 0x39,
      0x54, 0x3a, 0xe5, 0xe1, 0x62, 0x93, 0xe3, 0x11, 0xc0, 0xcf, 0x8c, 0x8d,
      0x6e, 0x18, 0x0d, 0xf0, 0x5d, 0x08, 0xc2, 0xfd, 0x2d, 0x93, 0xd5, 0x70,
      0x75, 0x1f},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 259
    {SEC_OID_SHA1,
     259,
     {0x30, 0x1c, 0x02, 0x15, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x03, 0x80, 0xfe, 0x01},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 260
    {SEC_OID_SHA1,
     260,
     {0x30, 0x1a, 0x02, 0x15, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x01, 0x42},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 261
    {SEC_OID_SHA1,
     261,
     {0x30, 0x81, 0x9b, 0x02, 0x81, 0x81, 0x00, 0xb3, 0x4c, 0xe9, 0xc1, 0xe7,
      0x82, 0x94, 0xd3, 0x25, 0x84, 0x73, 0x84, 0x20, 0x05, 0xd2, 0xa4, 0x8c,
      0x8c, 0x56, 0x6c, 0xfc, 0xa8, 0xf8, 0x4c, 0x06, 0x06, 0xf2, 0x52, 0x9b,
      0x59, 0xa6, 0xd3, 0x8a, 0xae, 0x07, 0x1b, 0x53, 0xbb, 0x21, 0x67, 0xea,
      0xa4, 0xfc, 0x3b, 0x01, 0xfe, 0x17, 0x6e, 0x78, 0x7e, 0x48, 0x1b, 0x60,
      0x37, 0xaa, 0xc6, 0x2c, 0xbc, 0x3d, 0x08, 0x97, 0x99, 0x53, 0x6a, 0x86,
      0x9f, 0xa8, 0xcd, 0xfe, 0xa1, 0xe8, 0xb1, 0xfd, 0x2d, 0x1c, 0xd3, 0xa3,
      0x03, 0x50, 0x85, 0x9a, 0x2c, 0xd6, 0xb3, 0xec, 0x2f, 0x9b, 0xfb, 0xb6,
      0x8b, 0xb1, 0x1b, 0x4b, 0xbe, 0x2a, 0xda, 0xa1, 0x8d, 0x64, 0xa9, 0x36,
      0x39, 0x54, 0x3a, 0xe5, 0xe1, 0x62, 0x93, 0xe3, 0x11, 0xc0, 0xcf, 0x8c,
      0x8d, 0x6e, 0x18, 0x0d, 0xf0, 0x5d, 0x08, 0xc2, 0xfd, 0x2d, 0x93, 0xd5,
      0x70, 0x75, 0x1f, 0x02, 0x15, 0xff, 0x46, 0xf4, 0xc7, 0x45, 0xf5, 0xaf,
      0x5b, 0xc1, 0x39, 0x76, 0x72, 0xc0, 0x64, 0x97, 0xfb, 0x68, 0x88, 0x0b,
      0x76, 0x4f},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 262
    {SEC_OID_SHA1,
     262,
     {0x30, 0x81, 0x87, 0x02, 0x81, 0x81, 0x00, 0xb3, 0x4c, 0xe9, 0xc1, 0xe7,
      0x82, 0x94, 0xd3, 0x25, 0x84, 0x73, 0x84, 0x20, 0x05, 0xd2, 0xa4, 0x8c,
      0x8c, 0x56, 0x6c, 0xfc, 0xa8, 0xf8, 0x4c, 0x06, 0x06, 0xf2, 0x52, 0x9b,
      0x59, 0xa6, 0xd3, 0x8a, 0xae, 0x07, 0x1b, 0x53, 0xbb, 0x21, 0x67, 0xea,
      0xa4, 0xfc, 0x3b, 0x01, 0xfe, 0x17, 0x6e, 0x78, 0x7e, 0x48, 0x1b, 0x60,
      0x37, 0xaa, 0xc6, 0x2c, 0xbc, 0x3d, 0x08, 0x97, 0x99, 0x53, 0x6a, 0x86,
      0x9f, 0xa8, 0xcd, 0xfe, 0xa1, 0xe8, 0xb1, 0xfd, 0x2d, 0x1c, 0xd3, 0xa3,
      0x03, 0x50, 0x85, 0x9a, 0x2c, 0xd6, 0xb3, 0xec, 0x2f, 0x9b, 0xfb, 0xb6,
      0x8b, 0xb1, 0x1b, 0x4b, 0xbe, 0x2a, 0xda, 0xa1, 0x8d, 0x64, 0xa9, 0x36,
      0x39, 0x54, 0x3a, 0xe5, 0xe1, 0x62, 0x93, 0xe3, 0x11, 0xc0, 0xcf, 0x8c,
      0x8d, 0x6e, 0x18, 0x0d, 0xf0, 0x5d, 0x08, 0xc2, 0xfd, 0x2d, 0x93, 0xd5,
      0x70, 0x75, 0x1f, 0x02, 0x01, 0x00},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 263
    {SEC_OID_SHA1,
     263,
     {0x30, 0x81, 0x87, 0x02, 0x81, 0x81, 0x00, 0xb3, 0x4c, 0xe9, 0xc1, 0xe7,
      0x82, 0x94, 0xd3, 0x25, 0x84, 0x73, 0x84, 0x20, 0x05, 0xd2, 0xa4, 0x8c,
      0x8c, 0x56, 0x6c, 0xfc, 0xa8, 0xf8, 0x4c, 0x06, 0x06, 0xf2, 0x52, 0x9b,
      0x59, 0xa6, 0xd3, 0x8a, 0xae, 0x07, 0x1b, 0x53, 0xbb, 0x21, 0x67, 0xea,
      0xa4, 0xfc, 0x3b, 0x01, 0xfe, 0x17, 0x6e, 0x78, 0x7e, 0x48, 0x1b, 0x60,
      0x37, 0xaa, 0xc6, 0x2c, 0xbc, 0x3d, 0x08, 0x97, 0x99, 0x53, 0x6a, 0x86,
      0x9f, 0xa8, 0xcd, 0xfe, 0xa1, 0xe8, 0xb1, 0xfd, 0x2d, 0x1c, 0xd3, 0xa3,
      0x03, 0x50, 0x85, 0x9a, 0x2c, 0xd6, 0xb3, 0xec, 0x2f, 0x9b, 0xfb, 0xb6,
      0x8b, 0xb1, 0x1b, 0x4b, 0xbe, 0x2a, 0xda, 0xa1, 0x8d, 0x64, 0xa9, 0x36,
      0x39, 0x54, 0x3a, 0xe5, 0xe1, 0x62, 0x93, 0xe3, 0x11, 0xc0, 0xcf, 0x8c,
      0x8d, 0x6e, 0x18, 0x0d, 0xf0, 0x5d, 0x08, 0xc2, 0xfd, 0x2d, 0x93, 0xd5,
      0x70, 0x75, 0x1f, 0x02, 0x01, 0x01},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 264
    {SEC_OID_SHA1,
     264,
     {0x30, 0x81, 0x87, 0x02, 0x81, 0x81, 0x00, 0xb3, 0x4c, 0xe9, 0xc1, 0xe7,
      0x82, 0x94, 0xd3, 0x25, 0x84, 0x73, 0x84, 0x20, 0x05, 0xd2, 0xa4, 0x8c,
      0x8c, 0x56, 0x6c, 0xfc, 0xa8, 0xf8, 0x4c, 0x06, 0x06, 0xf2, 0x52, 0x9b,
      0x59, 0xa6, 0xd3, 0x8a, 0xae, 0x07, 0x1b, 0x53, 0xbb, 0x21, 0x67, 0xea,
      0xa4, 0xfc, 0x3b, 0x01, 0xfe, 0x17, 0x6e, 0x78, 0x7e, 0x48, 0x1b, 0x60,
      0x37, 0xaa, 0xc6, 0x2c, 0xbc, 0x3d, 0x08, 0x97, 0x99, 0x53, 0x6a, 0x86,
      0x9f, 0xa8, 0xcd, 0xfe, 0xa1, 0xe8, 0xb1, 0xfd, 0x2d, 0x1c, 0xd3, 0xa3,
      0x03, 0x50, 0x85, 0x9a, 0x2c, 0xd6, 0xb3, 0xec, 0x2f, 0x9b, 0xfb, 0xb6,
      0x8b, 0xb1, 0x1b, 0x4b, 0xbe, 0x2a, 0xda, 0xa1, 0x8d, 0x64, 0xa9, 0x36,
      0x39, 0x54, 0x3a, 0xe5, 0xe1, 0x62, 0x93, 0xe3, 0x11, 0xc0, 0xcf, 0x8c,
      0x8d, 0x6e, 0x18, 0x0d, 0xf0, 0x5d, 0x08, 0xc2, 0xfd, 0x2d, 0x93, 0xd5,
      0x70, 0x75, 0x1f, 0x02, 0x01, 0xff},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 265
    {SEC_OID_SHA1,
     265,
     {0x30, 0x81, 0x9a, 0x02, 0x81, 0x81, 0x00, 0xb3, 0x4c, 0xe9, 0xc1, 0xe7,
      0x82, 0x94, 0xd3, 0x25, 0x84, 0x73, 0x84, 0x20, 0x05, 0xd2, 0xa4, 0x8c,
      0x8c, 0x56, 0x6c, 0xfc, 0xa8, 0xf8, 0x4c, 0x06, 0x06, 0xf2, 0x52, 0x9b,
      0x59, 0xa6, 0xd3, 0x8a, 0xae, 0x07, 0x1b, 0x53, 0xbb, 0x21, 0x67, 0xea,
      0xa4, 0xfc, 0x3b, 0x01, 0xfe, 0x17, 0x6e, 0x78, 0x7e, 0x48, 0x1b, 0x60,
      0x37, 0xaa, 0xc6, 0x2c, 0xbc, 0x3d, 0x08, 0x97, 0x99, 0x53, 0x6a, 0x86,
      0x9f, 0xa8, 0xcd, 0xfe, 0xa1, 0xe8, 0xb1, 0xfd, 0x2d, 0x1c, 0xd3, 0xa3,
      0x03, 0x50, 0x85, 0x9a, 0x2c, 0xd6, 0xb3, 0xec, 0x2f, 0x9b, 0xfb, 0xb6,
      0x8b, 0xb1, 0x1b, 0x4b, 0xbe, 0x2a, 0xda, 0xa1, 0x8d, 0x64, 0xa9, 0x36,
      0x39, 0x54, 0x3a, 0xe5, 0xe1, 0x62, 0x93, 0xe3, 0x11, 0xc0, 0xcf, 0x8c,
      0x8d, 0x6e, 0x18, 0x0d, 0xf0, 0x5d, 0x08, 0xc2, 0xfd, 0x2d, 0x93, 0xd5,
      0x70, 0x75, 0x1f, 0x02, 0x14, 0x5c, 0x85, 0x9c, 0x5d, 0x05, 0x28, 0x52,
      0x1f, 0x63, 0x44, 0xc6, 0x9f, 0xcd, 0xb4, 0x02, 0x4b, 0xbb, 0xfa, 0x44,
      0xd8},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 266
    {SEC_OID_SHA1,
     266,
     {0x30, 0x81, 0x9a, 0x02, 0x81, 0x81, 0x00, 0xb3, 0x4c, 0xe9, 0xc1, 0xe7,
      0x82, 0x94, 0xd3, 0x25, 0x84, 0x73, 0x84, 0x20, 0x05, 0xd2, 0xa4, 0x8c,
      0x8c, 0x56, 0x6c, 0xfc, 0xa8, 0xf8, 0x4c, 0x06, 0x06, 0xf2, 0x52, 0x9b,
      0x59, 0xa6, 0xd3, 0x8a, 0xae, 0x07, 0x1b, 0x53, 0xbb, 0x21, 0x67, 0xea,
      0xa4, 0xfc, 0x3b, 0x01, 0xfe, 0x17, 0x6e, 0x78, 0x7e, 0x48, 0x1b, 0x60,
      0x37, 0xaa, 0xc6, 0x2c, 0xbc, 0x3d, 0x08, 0x97, 0x99, 0x53, 0x6a, 0x86,
      0x9f, 0xa8, 0xcd, 0xfe, 0xa1, 0xe8, 0xb1, 0xfd, 0x2d, 0x1c, 0xd3, 0xa3,
      0x03, 0x50, 0x85, 0x9a, 0x2c, 0xd6, 0xb3, 0xec, 0x2f, 0x9b, 0xfb, 0xb6,
      0x8b, 0xb1, 0x1b, 0x4b, 0xbe, 0x2a, 0xda, 0xa1, 0x8d, 0x64, 0xa9, 0x36,
      0x39, 0x54, 0x3a, 0xe5, 0xe1, 0x62, 0x93, 0xe3, 0x11, 0xc0, 0xcf, 0x8c,
      0x8d, 0x6e, 0x18, 0x0d, 0xf0, 0x5d, 0x08, 0xc2, 0xfd, 0x2d, 0x93, 0xd5,
      0x70, 0x75, 0x1f, 0x02, 0x14, 0x5c, 0x85, 0x9c, 0x5d, 0x05, 0x28, 0x52,
      0x1f, 0x63, 0x44, 0xc6, 0x9f, 0xcd, 0xb4, 0x02, 0x4b, 0xbb, 0xfa, 0x44,
      0xd9},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 267
    {SEC_OID_SHA1,
     267,
     {0x30, 0x81, 0x9b, 0x02, 0x81, 0x81, 0x00, 0xb3, 0x4c, 0xe9, 0xc1, 0xe7,
      0x82, 0x94, 0xd3, 0x25, 0x84, 0x73, 0x84, 0x20, 0x05, 0xd2, 0xa4, 0x8c,
      0x8c, 0x56, 0x6c, 0xfc, 0xa8, 0xf8, 0x4c, 0x06, 0x06, 0xf2, 0x52, 0x9b,
      0x59, 0xa6, 0xd3, 0x8a, 0xae, 0x07, 0x1b, 0x53, 0xbb, 0x21, 0x67, 0xea,
      0xa4, 0xfc, 0x3b, 0x01, 0xfe, 0x17, 0x6e, 0x78, 0x7e, 0x48, 0x1b, 0x60,
      0x37, 0xaa, 0xc6, 0x2c, 0xbc, 0x3d, 0x08, 0x97, 0x99, 0x53, 0x6a, 0x86,
      0x9f, 0xa8, 0xcd, 0xfe, 0xa1, 0xe8, 0xb1, 0xfd, 0x2d, 0x1c, 0xd3, 0xa3,
      0x03, 0x50, 0x85, 0x9a, 0x2c, 0xd6, 0xb3, 0xec, 0x2f, 0x9b, 0xfb, 0xb6,
      0x8b, 0xb1, 0x1b, 0x4b, 0xbe, 0x2a, 0xda, 0xa1, 0x8d, 0x64, 0xa9, 0x36,
      0x39, 0x54, 0x3a, 0xe5, 0xe1, 0x62, 0x93, 0xe3, 0x11, 0xc0, 0xcf, 0x8c,
      0x8d, 0x6e, 0x18, 0x0d, 0xf0, 0x5d, 0x08, 0xc2, 0xfd, 0x2d, 0x93, 0xd5,
      0x70, 0x75, 0x1f, 0x02, 0x15, 0x00, 0xb9, 0x0b, 0x38, 0xba, 0x0a, 0x50,
      0xa4, 0x3e, 0xc6, 0x89, 0x8d, 0x3f, 0x9b, 0x68, 0x04, 0x97, 0x77, 0xf4,
      0x89, 0xb0},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 268
    {SEC_OID_SHA1,
     268,
     {0x30, 0x81, 0x9b, 0x02, 0x81, 0x81, 0x00, 0xb3, 0x4c, 0xe9, 0xc1, 0xe7,
      0x82, 0x94, 0xd3, 0x25, 0x84, 0x73, 0x84, 0x20, 0x05, 0xd2, 0xa4, 0x8c,
      0x8c, 0x56, 0x6c, 0xfc, 0xa8, 0xf8, 0x4c, 0x06, 0x06, 0xf2, 0x52, 0x9b,
      0x59, 0xa6, 0xd3, 0x8a, 0xae, 0x07, 0x1b, 0x53, 0xbb, 0x21, 0x67, 0xea,
      0xa4, 0xfc, 0x3b, 0x01, 0xfe, 0x17, 0x6e, 0x78, 0x7e, 0x48, 0x1b, 0x60,
      0x37, 0xaa, 0xc6, 0x2c, 0xbc, 0x3d, 0x08, 0x97, 0x99, 0x53, 0x6a, 0x86,
      0x9f, 0xa8, 0xcd, 0xfe, 0xa1, 0xe8, 0xb1, 0xfd, 0x2d, 0x1c, 0xd3, 0xa3,
      0x03, 0x50, 0x85, 0x9a, 0x2c, 0xd6, 0xb3, 0xec, 0x2f, 0x9b, 0xfb, 0xb6,
      0x8b, 0xb1, 0x1b, 0x4b, 0xbe, 0x2a, 0xda, 0xa1, 0x8d, 0x64, 0xa9, 0x36,
      0x39, 0x54, 0x3a, 0xe5, 0xe1, 0x62, 0x93, 0xe3, 0x11, 0xc0, 0xcf, 0x8c,
      0x8d, 0x6e, 0x18, 0x0d, 0xf0, 0x5d, 0x08, 0xc2, 0xfd, 0x2d, 0x93, 0xd5,
      0x70, 0x75, 0x1f, 0x02, 0x15, 0x00, 0xb9, 0x0b, 0x38, 0xba, 0x0a, 0x50,
      0xa4, 0x3e, 0xc6, 0x89, 0x8d, 0x3f, 0x9b, 0x68, 0x04, 0x97, 0x77, 0xf4,
      0x89, 0xb1},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 269
    {SEC_OID_SHA1,
     269,
     {0x30, 0x81, 0x9b, 0x02, 0x81, 0x81, 0x00, 0xb3, 0x4c, 0xe9, 0xc1, 0xe7,
      0x82, 0x94, 0xd3, 0x25, 0x84, 0x73, 0x84, 0x20, 0x05, 0xd2, 0xa4, 0x8c,
      0x8c, 0x56, 0x6c, 0xfc, 0xa8, 0xf8, 0x4c, 0x06, 0x06, 0xf2, 0x52, 0x9b,
      0x59, 0xa6, 0xd3, 0x8a, 0xae, 0x07, 0x1b, 0x53, 0xbb, 0x21, 0x67, 0xea,
      0xa4, 0xfc, 0x3b, 0x01, 0xfe, 0x17, 0x6e, 0x78, 0x7e, 0x48, 0x1b, 0x60,
      0x37, 0xaa, 0xc6, 0x2c, 0xbc, 0x3d, 0x08, 0x97, 0x99, 0x53, 0x6a, 0x86,
      0x9f, 0xa8, 0xcd, 0xfe, 0xa1, 0xe8, 0xb1, 0xfd, 0x2d, 0x1c, 0xd3, 0xa3,
      0x03, 0x50, 0x85, 0x9a, 0x2c, 0xd6, 0xb3, 0xec, 0x2f, 0x9b, 0xfb, 0xb6,
      0x8b, 0xb1, 0x1b, 0x4b, 0xbe, 0x2a, 0xda, 0xa1, 0x8d, 0x64, 0xa9, 0x36,
      0x39, 0x54, 0x3a, 0xe5, 0xe1, 0x62, 0x93, 0xe3, 0x11, 0xc0, 0xcf, 0x8c,
      0x8d, 0x6e, 0x18, 0x0d, 0xf0, 0x5d, 0x08, 0xc2, 0xfd, 0x2d, 0x93, 0xd5,
      0x70, 0x75, 0x1f, 0x02, 0x15, 0x00, 0xb9, 0x0b, 0x38, 0xba, 0x0a, 0x50,
      0xa4, 0x3e, 0xc6, 0x89, 0x8d, 0x3f, 0x9b, 0x68, 0x04, 0x97, 0x77, 0xf4,
      0x89, 0xb2},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 270
    {SEC_OID_SHA1,
     270,
     {0x30, 0x81, 0x9b, 0x02, 0x81, 0x81, 0x00, 0xb3, 0x4c, 0xe9, 0xc1, 0xe7,
      0x82, 0x94, 0xd3, 0x25, 0x84, 0x73, 0x84, 0x20, 0x05, 0xd2, 0xa4, 0x8c,
      0x8c, 0x56, 0x6c, 0xfc, 0xa8, 0xf8, 0x4c, 0x06, 0x06, 0xf2, 0x52, 0x9b,
      0x59, 0xa6, 0xd3, 0x8a, 0xae, 0x07, 0x1b, 0x53, 0xbb, 0x21, 0x67, 0xea,
      0xa4, 0xfc, 0x3b, 0x01, 0xfe, 0x17, 0x6e, 0x78, 0x7e, 0x48, 0x1b, 0x60,
      0x37, 0xaa, 0xc6, 0x2c, 0xbc, 0x3d, 0x08, 0x97, 0x99, 0x53, 0x6a, 0x86,
      0x9f, 0xa8, 0xcd, 0xfe, 0xa1, 0xe8, 0xb1, 0xfd, 0x2d, 0x1c, 0xd3, 0xa3,
      0x03, 0x50, 0x85, 0x9a, 0x2c, 0xd6, 0xb3, 0xec, 0x2f, 0x9b, 0xfb, 0xb6,
      0x8b, 0xb1, 0x1b, 0x4b, 0xbe, 0x2a, 0xda, 0xa1, 0x8d, 0x64, 0xa9, 0x36,
      0x39, 0x54, 0x3a, 0xe5, 0xe1, 0x62, 0x93, 0xe3, 0x11, 0xc0, 0xcf, 0x8c,
      0x8d, 0x6e, 0x18, 0x0d, 0xf0, 0x5d, 0x08, 0xc2, 0xfd, 0x2d, 0x93, 0xd5,
      0x70, 0x75, 0x1f, 0x02, 0x15, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 271
    {SEC_OID_SHA1,
     271,
     {0x30, 0x82, 0x01, 0x08, 0x02, 0x81, 0x81, 0x00, 0xb3, 0x4c, 0xe9, 0xc1,
      0xe7, 0x82, 0x94, 0xd3, 0x25, 0x84, 0x73, 0x84, 0x20, 0x05, 0xd2, 0xa4,
      0x8c, 0x8c, 0x56, 0x6c, 0xfc, 0xa8, 0xf8, 0x4c, 0x06, 0x06, 0xf2, 0x52,
      0x9b, 0x59, 0xa6, 0xd3, 0x8a, 0xae, 0x07, 0x1b, 0x53, 0xbb, 0x21, 0x67,
      0xea, 0xa4, 0xfc, 0x3b, 0x01, 0xfe, 0x17, 0x6e, 0x78, 0x7e, 0x48, 0x1b,
      0x60, 0x37, 0xaa, 0xc6, 0x2c, 0xbc, 0x3d, 0x08, 0x97, 0x99, 0x53, 0x6a,
      0x86, 0x9f, 0xa8, 0xcd, 0xfe, 0xa1, 0xe8, 0xb1, 0xfd, 0x2d, 0x1c, 0xd3,
      0xa3, 0x03, 0x50, 0x85, 0x9a, 0x2c, 0xd6, 0xb3, 0xec, 0x2f, 0x9b, 0xfb,
      0xb6, 0x8b, 0xb1, 0x1b, 0x4b, 0xbe, 0x2a, 0xda, 0xa1, 0x8d, 0x64, 0xa9,
      0x36, 0x39, 0x54, 0x3a, 0xe5, 0xe1, 0x62, 0x93, 0xe3, 0x11, 0xc0, 0xcf,
      0x8c, 0x8d, 0x6e, 0x18, 0x0d, 0xf0, 0x5d, 0x08, 0xc2, 0xfd, 0x2d, 0x93,
      0xd5, 0x70, 0x75, 0x1f, 0x02, 0x81, 0x81, 0x00, 0xb3, 0x4c, 0xe9, 0xc1,
      0xe7, 0x82, 0x94, 0xd3, 0x25, 0x84, 0x73, 0x84, 0x20, 0x05, 0xd2, 0xa4,
      0x8c, 0x8c, 0x56, 0x6c, 0xfc, 0xa8, 0xf8, 0x4c, 0x06, 0x06, 0xf2, 0x52,
      0x9b, 0x59, 0xa6, 0xd3, 0x8a, 0xae, 0x07, 0x1b, 0x53, 0xbb, 0x21, 0x67,
      0xea, 0xa4, 0xfc, 0x3b, 0x01, 0xfe, 0x17, 0x6e, 0x78, 0x7e, 0x48, 0x1b,
      0x60, 0x37, 0xaa, 0xc6, 0x2c, 0xbc, 0x3d, 0x08, 0x97, 0x99, 0x53, 0x6a,
      0x86, 0x9f, 0xa8, 0xcd, 0xfe, 0xa1, 0xe8, 0xb1, 0xfd, 0x2d, 0x1c, 0xd3,
      0xa3, 0x03, 0x50, 0x85, 0x9a, 0x2c, 0xd6, 0xb3, 0xec, 0x2f, 0x9b, 0xfb,
      0xb6, 0x8b, 0xb1, 0x1b, 0x4b, 0xbe, 0x2a, 0xda, 0xa1, 0x8d, 0x64, 0xa9,
      0x36, 0x39, 0x54, 0x3a, 0xe5, 0xe1, 0x62, 0x93, 0xe3, 0x11, 0xc0, 0xcf,
      0x8c, 0x8d, 0x6e, 0x18, 0x0d, 0xf0, 0x5d, 0x08, 0xc2, 0xfd, 0x2d, 0x93,
      0xd5, 0x70, 0x75, 0x1f},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 272
    {SEC_OID_SHA1,
     272,
     {0x30, 0x81, 0x89, 0x02, 0x81, 0x81, 0x00, 0xb3, 0x4c, 0xe9, 0xc1, 0xe7,
      0x82, 0x94, 0xd3, 0x25, 0x84, 0x73, 0x84, 0x20, 0x05, 0xd2, 0xa4, 0x8c,
      0x8c, 0x56, 0x6c, 0xfc, 0xa8, 0xf8, 0x4c, 0x06, 0x06, 0xf2, 0x52, 0x9b,
      0x59, 0xa6, 0xd3, 0x8a, 0xae, 0x07, 0x1b, 0x53, 0xbb, 0x21, 0x67, 0xea,
      0xa4, 0xfc, 0x3b, 0x01, 0xfe, 0x17, 0x6e, 0x78, 0x7e, 0x48, 0x1b, 0x60,
      0x37, 0xaa, 0xc6, 0x2c, 0xbc, 0x3d, 0x08, 0x97, 0x99, 0x53, 0x6a, 0x86,
      0x9f, 0xa8, 0xcd, 0xfe, 0xa1, 0xe8, 0xb1, 0xfd, 0x2d, 0x1c, 0xd3, 0xa3,
      0x03, 0x50, 0x85, 0x9a, 0x2c, 0xd6, 0xb3, 0xec, 0x2f, 0x9b, 0xfb, 0xb6,
      0x8b, 0xb1, 0x1b, 0x4b, 0xbe, 0x2a, 0xda, 0xa1, 0x8d, 0x64, 0xa9, 0x36,
      0x39, 0x54, 0x3a, 0xe5, 0xe1, 0x62, 0x93, 0xe3, 0x11, 0xc0, 0xcf, 0x8c,
      0x8d, 0x6e, 0x18, 0x0d, 0xf0, 0x5d, 0x08, 0xc2, 0xfd, 0x2d, 0x93, 0xd5,
      0x70, 0x75, 0x1f, 0x09, 0x03, 0x80, 0xfe, 0x01},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 273
    {SEC_OID_SHA1,
     273,
     {0x30, 0x81, 0x87, 0x02, 0x81, 0x81, 0x00, 0xb3, 0x4c, 0xe9, 0xc1, 0xe7,
      0x82, 0x94, 0xd3, 0x25, 0x84, 0x73, 0x84, 0x20, 0x05, 0xd2, 0xa4, 0x8c,
      0x8c, 0x56, 0x6c, 0xfc, 0xa8, 0xf8, 0x4c, 0x06, 0x06, 0xf2, 0x52, 0x9b,
      0x59, 0xa6, 0xd3, 0x8a, 0xae, 0x07, 0x1b, 0x53, 0xbb, 0x21, 0x67, 0xea,
      0xa4, 0xfc, 0x3b, 0x01, 0xfe, 0x17, 0x6e, 0x78, 0x7e, 0x48, 0x1b, 0x60,
      0x37, 0xaa, 0xc6, 0x2c, 0xbc, 0x3d, 0x08, 0x97, 0x99, 0x53, 0x6a, 0x86,
      0x9f, 0xa8, 0xcd, 0xfe, 0xa1, 0xe8, 0xb1, 0xfd, 0x2d, 0x1c, 0xd3, 0xa3,
      0x03, 0x50, 0x85, 0x9a, 0x2c, 0xd6, 0xb3, 0xec, 0x2f, 0x9b, 0xfb, 0xb6,
      0x8b, 0xb1, 0x1b, 0x4b, 0xbe, 0x2a, 0xda, 0xa1, 0x8d, 0x64, 0xa9, 0x36,
      0x39, 0x54, 0x3a, 0xe5, 0xe1, 0x62, 0x93, 0xe3, 0x11, 0xc0, 0xcf, 0x8c,
      0x8d, 0x6e, 0x18, 0x0d, 0xf0, 0x5d, 0x08, 0xc2, 0xfd, 0x2d, 0x93, 0xd5,
      0x70, 0x75, 0x1f, 0x09, 0x01, 0x42},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 274
    {SEC_OID_SHA1,
     274,
     {0x30, 0x1c, 0x09, 0x03, 0x80, 0xfe, 0x01, 0x02, 0x15, 0xff,
      0x46, 0xf4, 0xc7, 0x45, 0xf5, 0xaf, 0x5b, 0xc1, 0x39, 0x76,
      0x72, 0xc0, 0x64, 0x97, 0xfb, 0x68, 0x88, 0x0b, 0x76, 0x4f},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 275
    {SEC_OID_SHA1,
     275,
     {0x30, 0x08, 0x09, 0x03, 0x80, 0xfe, 0x01, 0x02, 0x01, 0x00},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 276
    {SEC_OID_SHA1,
     276,
     {0x30, 0x08, 0x09, 0x03, 0x80, 0xfe, 0x01, 0x02, 0x01, 0x01},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 277
    {SEC_OID_SHA1,
     277,
     {0x30, 0x08, 0x09, 0x03, 0x80, 0xfe, 0x01, 0x02, 0x01, 0xff},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 278
    {SEC_OID_SHA1,
     278,
     {0x30, 0x1b, 0x09, 0x03, 0x80, 0xfe, 0x01, 0x02, 0x14, 0x5c,
      0x85, 0x9c, 0x5d, 0x05, 0x28, 0x52, 0x1f, 0x63, 0x44, 0xc6,
      0x9f, 0xcd, 0xb4, 0x02, 0x4b, 0xbb, 0xfa, 0x44, 0xd8},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 279
    {SEC_OID_SHA1,
     279,
     {0x30, 0x1b, 0x09, 0x03, 0x80, 0xfe, 0x01, 0x02, 0x14, 0x5c,
      0x85, 0x9c, 0x5d, 0x05, 0x28, 0x52, 0x1f, 0x63, 0x44, 0xc6,
      0x9f, 0xcd, 0xb4, 0x02, 0x4b, 0xbb, 0xfa, 0x44, 0xd9},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 280
    {SEC_OID_SHA1,
     280,
     {0x30, 0x1c, 0x09, 0x03, 0x80, 0xfe, 0x01, 0x02, 0x15, 0x00,
      0xb9, 0x0b, 0x38, 0xba, 0x0a, 0x50, 0xa4, 0x3e, 0xc6, 0x89,
      0x8d, 0x3f, 0x9b, 0x68, 0x04, 0x97, 0x77, 0xf4, 0x89, 0xb0},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 281
    {SEC_OID_SHA1,
     281,
     {0x30, 0x1c, 0x09, 0x03, 0x80, 0xfe, 0x01, 0x02, 0x15, 0x00,
      0xb9, 0x0b, 0x38, 0xba, 0x0a, 0x50, 0xa4, 0x3e, 0xc6, 0x89,
      0x8d, 0x3f, 0x9b, 0x68, 0x04, 0x97, 0x77, 0xf4, 0x89, 0xb1},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 282
    {SEC_OID_SHA1,
     282,
     {0x30, 0x1c, 0x09, 0x03, 0x80, 0xfe, 0x01, 0x02, 0x15, 0x00,
      0xb9, 0x0b, 0x38, 0xba, 0x0a, 0x50, 0xa4, 0x3e, 0xc6, 0x89,
      0x8d, 0x3f, 0x9b, 0x68, 0x04, 0x97, 0x77, 0xf4, 0x89, 0xb2},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 283
    {SEC_OID_SHA1,
     283,
     {0x30, 0x1c, 0x09, 0x03, 0x80, 0xfe, 0x01, 0x02, 0x15, 0x01,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 284
    {SEC_OID_SHA1,
     284,
     {0x30, 0x81, 0x89, 0x09, 0x03, 0x80, 0xfe, 0x01, 0x02, 0x81, 0x81, 0x00,
      0xb3, 0x4c, 0xe9, 0xc1, 0xe7, 0x82, 0x94, 0xd3, 0x25, 0x84, 0x73, 0x84,
      0x20, 0x05, 0xd2, 0xa4, 0x8c, 0x8c, 0x56, 0x6c, 0xfc, 0xa8, 0xf8, 0x4c,
      0x06, 0x06, 0xf2, 0x52, 0x9b, 0x59, 0xa6, 0xd3, 0x8a, 0xae, 0x07, 0x1b,
      0x53, 0xbb, 0x21, 0x67, 0xea, 0xa4, 0xfc, 0x3b, 0x01, 0xfe, 0x17, 0x6e,
      0x78, 0x7e, 0x48, 0x1b, 0x60, 0x37, 0xaa, 0xc6, 0x2c, 0xbc, 0x3d, 0x08,
      0x97, 0x99, 0x53, 0x6a, 0x86, 0x9f, 0xa8, 0xcd, 0xfe, 0xa1, 0xe8, 0xb1,
      0xfd, 0x2d, 0x1c, 0xd3, 0xa3, 0x03, 0x50, 0x85, 0x9a, 0x2c, 0xd6, 0xb3,
      0xec, 0x2f, 0x9b, 0xfb, 0xb6, 0x8b, 0xb1, 0x1b, 0x4b, 0xbe, 0x2a, 0xda,
      0xa1, 0x8d, 0x64, 0xa9, 0x36, 0x39, 0x54, 0x3a, 0xe5, 0xe1, 0x62, 0x93,
      0xe3, 0x11, 0xc0, 0xcf, 0x8c, 0x8d, 0x6e, 0x18, 0x0d, 0xf0, 0x5d, 0x08,
      0xc2, 0xfd, 0x2d, 0x93, 0xd5, 0x70, 0x75, 0x1f},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 285
    {SEC_OID_SHA1,
     285,
     {0x30, 0x0a, 0x09, 0x03, 0x80, 0xfe, 0x01, 0x09, 0x03, 0x80, 0xfe, 0x01},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 286
    {SEC_OID_SHA1,
     286,
     {0x30, 0x08, 0x09, 0x03, 0x80, 0xfe, 0x01, 0x09, 0x01, 0x42},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature encoding contains wrong type.
    // tcID: 287
    {SEC_OID_SHA1,
     287,
     {0x30, 0x06, 0x02, 0x01, 0x01, 0x0c, 0x01, 0x30},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature encoding contains wrong type.
    // tcID: 288
    {SEC_OID_SHA1,
     288,
     {0x30, 0x05, 0x02, 0x01, 0x01, 0x0c, 0x00},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature encoding contains wrong type.
    // tcID: 289
    {SEC_OID_SHA1,
     289,
     {0x30, 0x09, 0x0c, 0x02, 0x25, 0x73, 0x0c, 0x03, 0x73, 0x25, 0x73},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature encoding contains wrong type.
    // tcID: 290
    {SEC_OID_SHA1,
     290,
     {0x30, 0x08, 0x02, 0x01, 0x01, 0x30, 0x03, 0x02, 0x01, 0x00},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature encoding contains wrong type.
    // tcID: 291
    {SEC_OID_SHA1,
     291,
     {0x30, 0x03, 0x02, 0x01, 0x01},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature encoding contains wrong type.
    // tcID: 292
    {SEC_OID_SHA1,
     292,
     {0x30, 0x06, 0x02, 0x01, 0x01, 0x01, 0x01, 0x00},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: random signature
    // tcID: 293
    {SEC_OID_SHA1,
     293,
     {0x30, 0x2e, 0x02, 0x15, 0x00, 0x88, 0x54, 0xbd, 0xb5, 0x2d, 0x20, 0xff,
      0x9e, 0xa4, 0x99, 0x48, 0x3f, 0xba, 0x4d, 0x3c, 0x10, 0x1a, 0x58, 0x6f,
      0xc7, 0x02, 0x15, 0x00, 0xb2, 0x30, 0x45, 0x90, 0x09, 0x95, 0xd3, 0xfe,
      0x3c, 0x4c, 0x63, 0x8a, 0x3e, 0x06, 0x45, 0x8a, 0x25, 0xa1, 0xe9, 0xdd},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: random signature
    // tcID: 294
    {SEC_OID_SHA1,
     294,
     {0x30, 0x2c, 0x02, 0x14, 0x4f, 0x6b, 0xf1, 0x89, 0x41, 0xab, 0xbf, 0x33,
      0x21, 0x1d, 0x95, 0x61, 0xa1, 0x4f, 0x9a, 0xeb, 0xd0, 0x3f, 0x4e, 0x94,
      0x02, 0x14, 0x21, 0x8c, 0xda, 0x35, 0x0d, 0xef, 0x7f, 0x75, 0x61, 0x7f,
      0xcc, 0x79, 0x9d, 0x0c, 0xf2, 0xcf, 0x6b, 0x23, 0x43, 0x8d},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: random signature
    // tcID: 295
    {SEC_OID_SHA1,
     295,
     {0x30, 0x2c, 0x02, 0x14, 0x45, 0x9e, 0xaf, 0x08, 0x86, 0x16, 0x00, 0x81,
      0xb4, 0x7f, 0xc5, 0x73, 0xfb, 0x3d, 0x15, 0x2d, 0x68, 0x0d, 0x3b, 0x4b,
      0x02, 0x14, 0x42, 0x93, 0xdb, 0xb9, 0x4d, 0xb4, 0xc9, 0x30, 0xd6, 0x7e,
      0x27, 0xfc, 0x4e, 0xc8, 0x53, 0x8b, 0x58, 0xd1, 0xc7, 0xcd},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: random signature
    // tcID: 296
    {SEC_OID_SHA1,
     296,
     {0x30, 0x2c, 0x02, 0x14, 0x0a, 0x6c, 0x12, 0xb8, 0xff, 0x5c, 0xa2, 0x1c,
      0x4e, 0xa0, 0xc7, 0xac, 0xea, 0x38, 0xd7, 0x6f, 0xd1, 0x70, 0xb9, 0x7f,
      0x02, 0x14, 0x29, 0xce, 0x2c, 0xf2, 0x67, 0x2f, 0xa6, 0x40, 0x03, 0x16,
      0x80, 0xdc, 0xe2, 0x22, 0x39, 0x32, 0xf6, 0x13, 0xf6, 0xa5},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: random signature
    // tcID: 297
    {SEC_OID_SHA1,
     297,
     {0x30, 0x2c, 0x02, 0x14, 0x34, 0xbc, 0xe4, 0x77, 0x3e, 0x5e, 0x11, 0x87,
      0x5e, 0xa2, 0x20, 0x2b, 0xc3, 0x3e, 0x01, 0xfe, 0x00, 0xb3, 0x32, 0x1a,
      0x02, 0x14, 0x2b, 0x29, 0x4e, 0x01, 0xa9, 0x72, 0x96, 0xd8, 0x4e, 0x4c,
      0x60, 0xbf, 0xba, 0x05, 0xd2, 0x76, 0x09, 0x81, 0xc9, 0x20},
     kPubKey0,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: r,s = 1,1
    // tcID: 298
    {SEC_OID_SHA1,
     298,
     {0x30, 0x06, 0x02, 0x01, 0x01, 0x02, 0x01, 0x01},
     kPubKey1,
     {0x54, 0x65, 0x73, 0x74},
     true},

    // Comment: r,s = 1,5
    // tcID: 299
    {SEC_OID_SHA1,
     299,
     {0x30, 0x06, 0x02, 0x01, 0x01, 0x02, 0x01, 0x05},
     kPubKey1,
     {0x54, 0x65, 0x73, 0x74},
     true},

    // Comment: u2 small
    // tcID: 300
    {SEC_OID_SHA1,
     300,
     {0x30, 0x19, 0x02, 0x01, 0x01, 0x02, 0x14, 0x25, 0x02,
      0x3e, 0x8b, 0x9b, 0xa9, 0xba, 0x72, 0xf4, 0x81, 0xe9,
      0x0c, 0xb8, 0xae, 0x67, 0x51, 0x7e, 0x64, 0x1b, 0x8a},
     kPubKey1,
     {0x54, 0x65, 0x73, 0x74},
     true},

    // Comment: s == q-1
    // tcID: 301
    {SEC_OID_SHA1,
     301,
     {0x30, 0x1a, 0x02, 0x01, 0x01, 0x02, 0x15, 0x00, 0xb9, 0x0b,
      0x38, 0xba, 0x0a, 0x50, 0xa4, 0x3e, 0xc6, 0x89, 0x8d, 0x3f,
      0x9b, 0x68, 0x04, 0x97, 0x77, 0xf4, 0x89, 0xb0},
     kPubKey1,
     {0x54, 0x65, 0x73, 0x74},
     true},

    // Comment: s == 1
    // tcID: 302
    {SEC_OID_SHA1,
     302,
     {0x30, 0x19, 0x02, 0x14, 0x62, 0xba, 0x82, 0x73, 0x81,
      0x39, 0x6d, 0xc4, 0x4f, 0xac, 0xc6, 0x6c, 0x34, 0x4f,
      0x91, 0x78, 0x8f, 0x11, 0xc6, 0xfc, 0x02, 0x01, 0x01},
     kPubKey2,
     {0x54, 0x65, 0x73, 0x74},
     true},

    // Comment: Legacy:ASN encoding of s misses leading 0
    // tcID: 303
    {SEC_OID_SHA224,
     303,
     {0x30, 0x3c, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69,
      0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3,
      0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02,
      0x1c, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e, 0xf4,
      0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf, 0x33,
      0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     true},

    // Comment: valid
    // tcID: 304
    {SEC_OID_SHA224,
     304,
     {0x30, 0x3d, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69,
      0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3,
      0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02,
      0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e,
      0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf,
      0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     true},

    // Comment: long form encoding of length of sequence
    // tcID: 305
    {SEC_OID_SHA224,
     305,
     {0x30, 0x81, 0x3d, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57,
      0x69, 0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc,
      0xf3, 0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd,
      0x02, 0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f,
      0x9e, 0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67,
      0xcf, 0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: length of sequence contains leading 0
    // tcID: 306
    {SEC_OID_SHA224,
     306,
     {0x30, 0x82, 0x00, 0x3d, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad,
      0x57, 0x69, 0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0,
      0xcc, 0xf3, 0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9,
      0xcd, 0x02, 0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3,
      0x0f, 0x9e, 0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69,
      0x67, 0xcf, 0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: wrong length of sequence
    // tcID: 307
    {SEC_OID_SHA224,
     307,
     {0x30, 0x3e, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69,
      0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3,
      0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02,
      0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e,
      0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf,
      0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: wrong length of sequence
    // tcID: 308
    {SEC_OID_SHA224,
     308,
     {0x30, 0x3c, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69,
      0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3,
      0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02,
      0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e,
      0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf,
      0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: uint32 overflow in length of sequence
    // tcID: 309
    {SEC_OID_SHA224,
     309,
     {0x30, 0x85, 0x01, 0x00, 0x00, 0x00, 0x3d, 0x02, 0x1c, 0x1e, 0x41, 0xb4,
      0x79, 0xad, 0x57, 0x69, 0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91,
      0xb0, 0xcc, 0xf3, 0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9,
      0xcd, 0x02, 0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f,
      0x9e, 0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf,
      0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: uint64 overflow in length of sequence
    // tcID: 310
    {SEC_OID_SHA224,
     310,
     {0x30, 0x89, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3d, 0x02,
      0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69, 0x05, 0xb9, 0x60, 0xfe,
      0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3, 0x48, 0x43, 0xda, 0xb9, 0x16,
      0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02, 0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88,
      0xd2, 0x37, 0xd3, 0x0f, 0x9e, 0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8,
      0xf1, 0x69, 0x67, 0xcf, 0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: length of sequence = 2**31 - 1
    // tcID: 311
    {SEC_OID_SHA224,
     311,
     {0x30, 0x84, 0x7f, 0xff, 0xff, 0xff, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79,
      0xad, 0x57, 0x69, 0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0,
      0xcc, 0xf3, 0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd,
      0x02, 0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e,
      0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf, 0x33,
      0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: length of sequence = 2**32 - 1
    // tcID: 312
    {SEC_OID_SHA224,
     312,
     {0x30, 0x84, 0xff, 0xff, 0xff, 0xff, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79,
      0xad, 0x57, 0x69, 0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0,
      0xcc, 0xf3, 0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd,
      0x02, 0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e,
      0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf, 0x33,
      0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: length of sequence = 2**40 - 1
    // tcID: 313
    {SEC_OID_SHA224,
     313,
     {0x30, 0x85, 0xff, 0xff, 0xff, 0xff, 0xff, 0x02, 0x1c, 0x1e, 0x41, 0xb4,
      0x79, 0xad, 0x57, 0x69, 0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91,
      0xb0, 0xcc, 0xf3, 0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9,
      0xcd, 0x02, 0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f,
      0x9e, 0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf,
      0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: length of sequence = 2**64 - 1
    // tcID: 314
    {SEC_OID_SHA224,
     314,
     {0x30, 0x88, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x02, 0x1c,
      0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69, 0x05, 0xb9, 0x60, 0xfe, 0x14,
      0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3, 0x48, 0x43, 0xda, 0xb9, 0x16, 0x17,
      0x3b, 0xb8, 0xc9, 0xcd, 0x02, 0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2,
      0x37, 0xd3, 0x0f, 0x9e, 0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1,
      0x69, 0x67, 0xcf, 0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: incorrect length of sequence
    // tcID: 315
    {SEC_OID_SHA224,
     315,
     {0x30, 0xff, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69,
      0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3,
      0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02,
      0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e,
      0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf,
      0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: indefinite length without termination
    // tcID: 316
    {SEC_OID_SHA224,
     316,
     {0x30, 0x80, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69,
      0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3,
      0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02,
      0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e,
      0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf,
      0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: indefinite length without termination
    // tcID: 317
    {SEC_OID_SHA224,
     317,
     {0x30, 0x3d, 0x02, 0x80, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69,
      0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3,
      0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02,
      0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e,
      0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf,
      0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: indefinite length without termination
    // tcID: 318
    {SEC_OID_SHA224,
     318,
     {0x30, 0x3d, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69,
      0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3,
      0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02,
      0x80, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e,
      0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf,
      0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: removing sequence
    // tcID: 319
    {SEC_OID_SHA224, 319, {}, kPubKey3, {0x48, 0x65, 0x6c, 0x6c, 0x6f}, false},

    // Comment: lonely sequence tag
    // tcID: 320
    {SEC_OID_SHA224,
     320,
     {0x30},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: appending 0's to sequence
    // tcID: 321
    {SEC_OID_SHA224,
     321,
     {0x30, 0x3f, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69,
      0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3,
      0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02,
      0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e,
      0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf,
      0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36, 0x00, 0x00},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: prepending 0's to sequence
    // tcID: 322
    {SEC_OID_SHA224,
     322,
     {0x30, 0x3f, 0x00, 0x00, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad,
      0x57, 0x69, 0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0,
      0xcc, 0xf3, 0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9,
      0xcd, 0x02, 0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3,
      0x0f, 0x9e, 0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69,
      0x67, 0xcf, 0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: appending unused 0's to sequence
    // tcID: 323
    {SEC_OID_SHA224,
     323,
     {0x30, 0x3d, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69,
      0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3,
      0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02,
      0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e,
      0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf,
      0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36, 0x00, 0x00},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: appending null value to sequence
    // tcID: 324
    {SEC_OID_SHA224,
     324,
     {0x30, 0x3f, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69,
      0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3,
      0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02,
      0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e,
      0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf,
      0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36, 0x05, 0x00},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: including garbage
    // tcID: 325
    {SEC_OID_SHA224,
     325,
     {0x30, 0x42, 0x49, 0x81, 0x77, 0x30, 0x3d, 0x02, 0x1c, 0x1e, 0x41, 0xb4,
      0x79, 0xad, 0x57, 0x69, 0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91,
      0xb0, 0xcc, 0xf3, 0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9,
      0xcd, 0x02, 0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f,
      0x9e, 0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf,
      0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: including garbage
    // tcID: 326
    {SEC_OID_SHA224,
     326,
     {0x30, 0x41, 0x25, 0x00, 0x30, 0x3d, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79,
      0xad, 0x57, 0x69, 0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0,
      0xcc, 0xf3, 0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd,
      0x02, 0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e,
      0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf, 0x33,
      0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: including garbage
    // tcID: 327
    {SEC_OID_SHA224,
     327,
     {0x30, 0x3f, 0x30, 0x3d, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57,
      0x69, 0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3,
      0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02, 0x1d,
      0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e, 0xf4, 0x1d,
      0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf, 0x33, 0x65, 0x81,
      0x3f, 0xe8, 0x78, 0x62, 0x36, 0x00, 0x04, 0xde, 0xad, 0xbe, 0xef},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: including garbage
    // tcID: 328
    {SEC_OID_SHA224,
     328,
     {0x30, 0x42, 0x22, 0x21, 0x49, 0x81, 0x77, 0x02, 0x1c, 0x1e, 0x41, 0xb4,
      0x79, 0xad, 0x57, 0x69, 0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91,
      0xb0, 0xcc, 0xf3, 0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9,
      0xcd, 0x02, 0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f,
      0x9e, 0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf,
      0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: including garbage
    // tcID: 329
    {SEC_OID_SHA224,
     329,
     {0x30, 0x41, 0x22, 0x20, 0x25, 0x00, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79,
      0xad, 0x57, 0x69, 0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0,
      0xcc, 0xf3, 0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd,
      0x02, 0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e,
      0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf, 0x33,
      0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: including garbage
    // tcID: 330
    {SEC_OID_SHA224,
     330,
     {0x30, 0x45, 0x22, 0x1e, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57,
      0x69, 0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3,
      0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x00, 0x04,
      0xde, 0xad, 0xbe, 0xef, 0x02, 0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2,
      0x37, 0xd3, 0x0f, 0x9e, 0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1,
      0x69, 0x67, 0xcf, 0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: including garbage
    // tcID: 331
    {SEC_OID_SHA224,
     331,
     {0x30, 0x42, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69, 0x05,
      0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3, 0x48, 0x43,
      0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x22, 0x22, 0x49, 0x81,
      0x77, 0x02, 0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f,
      0x9e, 0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf,
      0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: including garbage
    // tcID: 332
    {SEC_OID_SHA224,
     332,
     {0x30, 0x41, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69, 0x05,
      0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3, 0x48, 0x43,
      0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x22, 0x21, 0x25, 0x00,
      0x02, 0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e,
      0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf, 0x33,
      0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: including garbage
    // tcID: 333
    {SEC_OID_SHA224,
     333,
     {0x30, 0x45, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69, 0x05,
      0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3, 0x48, 0x43,
      0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x22, 0x1f, 0x02, 0x1d,
      0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e, 0xf4, 0x1d,
      0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf, 0x33, 0x65, 0x81,
      0x3f, 0xe8, 0x78, 0x62, 0x36, 0x00, 0x04, 0xde, 0xad, 0xbe, 0xef},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: including undefined tags
    // tcID: 334
    {SEC_OID_SHA224,
     334,
     {0x30, 0x45, 0xaa, 0x00, 0xbb, 0x00, 0xcd, 0x00, 0x30, 0x3d, 0x02, 0x1c,
      0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69, 0x05, 0xb9, 0x60, 0xfe, 0x14,
      0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3, 0x48, 0x43, 0xda, 0xb9, 0x16, 0x17,
      0x3b, 0xb8, 0xc9, 0xcd, 0x02, 0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2,
      0x37, 0xd3, 0x0f, 0x9e, 0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1,
      0x69, 0x67, 0xcf, 0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: including undefined tags
    // tcID: 335
    {SEC_OID_SHA224,
     335,
     {0x30, 0x43, 0xaa, 0x02, 0xaa, 0xbb, 0x30, 0x3d, 0x02, 0x1c, 0x1e, 0x41,
      0xb4, 0x79, 0xad, 0x57, 0x69, 0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb,
      0x91, 0xb0, 0xcc, 0xf3, 0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8,
      0xc9, 0xcd, 0x02, 0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3,
      0x0f, 0x9e, 0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67,
      0xcf, 0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: including undefined tags
    // tcID: 336
    {SEC_OID_SHA224,
     336,
     {0x30, 0x45, 0x22, 0x24, 0xaa, 0x00, 0xbb, 0x00, 0xcd, 0x00, 0x02, 0x1c,
      0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69, 0x05, 0xb9, 0x60, 0xfe, 0x14,
      0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3, 0x48, 0x43, 0xda, 0xb9, 0x16, 0x17,
      0x3b, 0xb8, 0xc9, 0xcd, 0x02, 0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2,
      0x37, 0xd3, 0x0f, 0x9e, 0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1,
      0x69, 0x67, 0xcf, 0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: including undefined tags
    // tcID: 337
    {SEC_OID_SHA224,
     337,
     {0x30, 0x43, 0x22, 0x22, 0xaa, 0x02, 0xaa, 0xbb, 0x02, 0x1c, 0x1e, 0x41,
      0xb4, 0x79, 0xad, 0x57, 0x69, 0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb,
      0x91, 0xb0, 0xcc, 0xf3, 0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8,
      0xc9, 0xcd, 0x02, 0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3,
      0x0f, 0x9e, 0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67,
      0xcf, 0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: including undefined tags
    // tcID: 338
    {SEC_OID_SHA224,
     338,
     {0x30, 0x45, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69, 0x05,
      0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3, 0x48, 0x43,
      0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x22, 0x25, 0xaa, 0x00,
      0xbb, 0x00, 0xcd, 0x00, 0x02, 0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2,
      0x37, 0xd3, 0x0f, 0x9e, 0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1,
      0x69, 0x67, 0xcf, 0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: including undefined tags
    // tcID: 339
    {SEC_OID_SHA224,
     339,
     {0x30, 0x43, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69, 0x05,
      0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3, 0x48, 0x43,
      0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x22, 0x23, 0xaa, 0x02,
      0xaa, 0xbb, 0x02, 0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3,
      0x0f, 0x9e, 0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67,
      0xcf, 0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: truncated length of sequence
    // tcID: 340
    {SEC_OID_SHA224,
     340,
     {0x30, 0x81},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: using composition with indefinite length
    // tcID: 341
    {SEC_OID_SHA224,
     341,
     {0x30, 0x80, 0x30, 0x3d, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57,
      0x69, 0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3,
      0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02, 0x1d,
      0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e, 0xf4, 0x1d,
      0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf, 0x33, 0x65, 0x81,
      0x3f, 0xe8, 0x78, 0x62, 0x36, 0x00, 0x00},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: using composition with indefinite length
    // tcID: 342
    {SEC_OID_SHA224,
     342,
     {0x30, 0x41, 0x22, 0x80, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57,
      0x69, 0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3,
      0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x00, 0x00,
      0x02, 0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e,
      0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf, 0x33,
      0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: using composition with indefinite length
    // tcID: 343
    {SEC_OID_SHA224,
     343,
     {0x30, 0x41, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69, 0x05,
      0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3, 0x48, 0x43,
      0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x22, 0x80, 0x02, 0x1d,
      0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e, 0xf4, 0x1d,
      0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf, 0x33, 0x65, 0x81,
      0x3f, 0xe8, 0x78, 0x62, 0x36, 0x00, 0x00},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: using composition with wrong tag
    // tcID: 344
    {SEC_OID_SHA224,
     344,
     {0x30, 0x80, 0x31, 0x3d, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57,
      0x69, 0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3,
      0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02, 0x1d,
      0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e, 0xf4, 0x1d,
      0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf, 0x33, 0x65, 0x81,
      0x3f, 0xe8, 0x78, 0x62, 0x36, 0x00, 0x00},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: using composition with wrong tag
    // tcID: 345
    {SEC_OID_SHA224,
     345,
     {0x30, 0x41, 0x22, 0x80, 0x03, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57,
      0x69, 0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3,
      0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x00, 0x00,
      0x02, 0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e,
      0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf, 0x33,
      0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: using composition with wrong tag
    // tcID: 346
    {SEC_OID_SHA224,
     346,
     {0x30, 0x41, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69, 0x05,
      0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3, 0x48, 0x43,
      0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x22, 0x80, 0x03, 0x1d,
      0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e, 0xf4, 0x1d,
      0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf, 0x33, 0x65, 0x81,
      0x3f, 0xe8, 0x78, 0x62, 0x36, 0x00, 0x00},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Replacing sequence with NULL
    // tcID: 347
    {SEC_OID_SHA224,
     347,
     {0x05, 0x00},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: changing tag value of sequence
    // tcID: 348
    {SEC_OID_SHA224,
     348,
     {0x2e, 0x3d, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69,
      0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3,
      0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02,
      0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e,
      0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf,
      0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: changing tag value of sequence
    // tcID: 349
    {SEC_OID_SHA224,
     349,
     {0x2f, 0x3d, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69,
      0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3,
      0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02,
      0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e,
      0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf,
      0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: changing tag value of sequence
    // tcID: 350
    {SEC_OID_SHA224,
     350,
     {0x31, 0x3d, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69,
      0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3,
      0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02,
      0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e,
      0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf,
      0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: changing tag value of sequence
    // tcID: 351
    {SEC_OID_SHA224,
     351,
     {0x32, 0x3d, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69,
      0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3,
      0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02,
      0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e,
      0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf,
      0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: changing tag value of sequence
    // tcID: 352
    {SEC_OID_SHA224,
     352,
     {0xff, 0x3d, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69,
      0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3,
      0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02,
      0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e,
      0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf,
      0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: dropping value of sequence
    // tcID: 353
    {SEC_OID_SHA224,
     353,
     {0x30, 0x00},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: using composition for sequence
    // tcID: 354
    {SEC_OID_SHA224,
     354,
     {0x30, 0x41, 0x30, 0x01, 0x02, 0x30, 0x3c, 0x1c, 0x1e, 0x41, 0xb4, 0x79,
      0xad, 0x57, 0x69, 0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0,
      0xcc, 0xf3, 0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd,
      0x02, 0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e,
      0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf, 0x33,
      0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: truncated sequence
    // tcID: 355
    {SEC_OID_SHA224,
     355,
     {0x30, 0x3c, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69,
      0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3,
      0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02,
      0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e,
      0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf,
      0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: truncated sequence
    // tcID: 356
    {SEC_OID_SHA224,
     356,
     {0x30, 0x3c, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69, 0x05,
      0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3, 0x48,
      0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02, 0x1d,
      0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e, 0xf4,
      0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf, 0x33,
      0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: indefinite length
    // tcID: 357
    {SEC_OID_SHA224,
     357,
     {0x30, 0x80, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69,
      0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3,
      0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02,
      0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e,
      0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf,
      0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36, 0x00, 0x00},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: indefinite length with truncated delimiter
    // tcID: 358
    {SEC_OID_SHA224,
     358,
     {0x30, 0x80, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69,
      0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3,
      0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02,
      0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e,
      0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf,
      0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36, 0x00},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: indefinite length with additional element
    // tcID: 359
    {SEC_OID_SHA224,
     359,
     {0x30, 0x80, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69, 0x05,
      0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3, 0x48, 0x43,
      0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02, 0x1d, 0x00, 0xad,
      0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e, 0xf4, 0x1d, 0xd4, 0x24,
      0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf, 0x33, 0x65, 0x81, 0x3f, 0xe8,
      0x78, 0x62, 0x36, 0x05, 0x00, 0x00, 0x00},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: indefinite length with truncated element
    // tcID: 360
    {SEC_OID_SHA224,
     360,
     {0x30, 0x80, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69, 0x05,
      0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3, 0x48, 0x43,
      0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02, 0x1d, 0x00, 0xad,
      0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e, 0xf4, 0x1d, 0xd4, 0x24,
      0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf, 0x33, 0x65, 0x81, 0x3f, 0xe8,
      0x78, 0x62, 0x36, 0x06, 0x08, 0x11, 0x22, 0x00, 0x00},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: indefinite length with garbage
    // tcID: 361
    {SEC_OID_SHA224,
     361,
     {0x30, 0x80, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69, 0x05,
      0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3, 0x48, 0x43,
      0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02, 0x1d, 0x00, 0xad,
      0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e, 0xf4, 0x1d, 0xd4, 0x24,
      0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf, 0x33, 0x65, 0x81, 0x3f, 0xe8,
      0x78, 0x62, 0x36, 0x00, 0x00, 0xfe, 0x02, 0xbe, 0xef},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: indefinite length with nonempty EOC
    // tcID: 362
    {SEC_OID_SHA224,
     362,
     {0x30, 0x80, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69, 0x05,
      0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3, 0x48, 0x43,
      0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02, 0x1d, 0x00, 0xad,
      0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e, 0xf4, 0x1d, 0xd4, 0x24,
      0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf, 0x33, 0x65, 0x81, 0x3f, 0xe8,
      0x78, 0x62, 0x36, 0x00, 0x02, 0xbe, 0xef},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: prepend empty sequence
    // tcID: 363
    {SEC_OID_SHA224,
     363,
     {0x30, 0x3f, 0x30, 0x00, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad,
      0x57, 0x69, 0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0,
      0xcc, 0xf3, 0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9,
      0xcd, 0x02, 0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3,
      0x0f, 0x9e, 0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69,
      0x67, 0xcf, 0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: append empty sequence
    // tcID: 364
    {SEC_OID_SHA224,
     364,
     {0x30, 0x3f, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69,
      0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3,
      0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02,
      0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e,
      0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf,
      0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36, 0x30, 0x00},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: append garbage with high tag number
    // tcID: 365
    {SEC_OID_SHA224,
     365,
     {0x30, 0x40, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69,
      0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3,
      0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02,
      0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e,
      0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf,
      0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36, 0xbf, 0x7f, 0x00},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: sequence of sequence
    // tcID: 366
    {SEC_OID_SHA224,
     366,
     {0x30, 0x3f, 0x30, 0x3d, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad,
      0x57, 0x69, 0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0,
      0xcc, 0xf3, 0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9,
      0xcd, 0x02, 0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3,
      0x0f, 0x9e, 0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69,
      0x67, 0xcf, 0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: truncated sequence: removed last 1 elements
    // tcID: 367
    {SEC_OID_SHA224,
     367,
     {0x30, 0x1e, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69,
      0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3,
      0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: repeating element in sequence
    // tcID: 368
    {SEC_OID_SHA224,
     368,
     {0x30, 0x5c, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69, 0x05,
      0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3, 0x48, 0x43,
      0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02, 0x1d, 0x00, 0xad,
      0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e, 0xf4, 0x1d, 0xd4, 0x24,
      0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf, 0x33, 0x65, 0x81, 0x3f, 0xe8,
      0x78, 0x62, 0x36, 0x02, 0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37,
      0xd3, 0x0f, 0x9e, 0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69,
      0x67, 0xcf, 0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: long form encoding of length of integer
    // tcID: 369
    {SEC_OID_SHA224,
     369,
     {0x30, 0x3e, 0x02, 0x81, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57,
      0x69, 0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc,
      0xf3, 0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd,
      0x02, 0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f,
      0x9e, 0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67,
      0xcf, 0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: long form encoding of length of integer
    // tcID: 370
    {SEC_OID_SHA224,
     370,
     {0x30, 0x3e, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69,
      0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3,
      0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02,
      0x81, 0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f,
      0x9e, 0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67,
      0xcf, 0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: length of integer contains leading 0
    // tcID: 371
    {SEC_OID_SHA224,
     371,
     {0x30, 0x3f, 0x02, 0x82, 0x00, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad,
      0x57, 0x69, 0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0,
      0xcc, 0xf3, 0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9,
      0xcd, 0x02, 0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3,
      0x0f, 0x9e, 0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69,
      0x67, 0xcf, 0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: length of integer contains leading 0
    // tcID: 372
    {SEC_OID_SHA224,
     372,
     {0x30, 0x3f, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69,
      0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3,
      0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02,
      0x82, 0x00, 0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3,
      0x0f, 0x9e, 0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69,
      0x67, 0xcf, 0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: wrong length of integer
    // tcID: 373
    {SEC_OID_SHA224,
     373,
     {0x30, 0x3d, 0x02, 0x1d, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69,
      0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3,
      0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02,
      0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e,
      0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf,
      0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: wrong length of integer
    // tcID: 374
    {SEC_OID_SHA224,
     374,
     {0x30, 0x3d, 0x02, 0x1b, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69,
      0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3,
      0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02,
      0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e,
      0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf,
      0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: wrong length of integer
    // tcID: 375
    {SEC_OID_SHA224,
     375,
     {0x30, 0x3d, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69,
      0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3,
      0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02,
      0x1e, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e,
      0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf,
      0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: wrong length of integer
    // tcID: 376
    {SEC_OID_SHA224,
     376,
     {0x30, 0x3d, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69,
      0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3,
      0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02,
      0x1c, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e,
      0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf,
      0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: uint32 overflow in length of integer
    // tcID: 377
    {SEC_OID_SHA224,
     377,
     {0x30, 0x42, 0x02, 0x85, 0x01, 0x00, 0x00, 0x00, 0x1c, 0x1e, 0x41, 0xb4,
      0x79, 0xad, 0x57, 0x69, 0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91,
      0xb0, 0xcc, 0xf3, 0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9,
      0xcd, 0x02, 0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f,
      0x9e, 0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf,
      0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: uint32 overflow in length of integer
    // tcID: 378
    {SEC_OID_SHA224,
     378,
     {0x30, 0x42, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69, 0x05,
      0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3, 0x48, 0x43,
      0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02, 0x85, 0x01, 0x00,
      0x00, 0x00, 0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f,
      0x9e, 0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf,
      0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: uint64 overflow in length of integer
    // tcID: 379
    {SEC_OID_SHA224,
     379,
     {0x30, 0x46, 0x02, 0x89, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69, 0x05, 0xb9, 0x60, 0xfe,
      0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3, 0x48, 0x43, 0xda, 0xb9, 0x16,
      0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02, 0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88,
      0xd2, 0x37, 0xd3, 0x0f, 0x9e, 0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8,
      0xf1, 0x69, 0x67, 0xcf, 0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: uint64 overflow in length of integer
    // tcID: 380
    {SEC_OID_SHA224,
     380,
     {0x30, 0x46, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69, 0x05,
      0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3, 0x48, 0x43,
      0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02, 0x89, 0x01, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88,
      0xd2, 0x37, 0xd3, 0x0f, 0x9e, 0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8,
      0xf1, 0x69, 0x67, 0xcf, 0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: length of integer = 2**31 - 1
    // tcID: 381
    {SEC_OID_SHA224,
     381,
     {0x30, 0x41, 0x02, 0x84, 0x7f, 0xff, 0xff, 0xff, 0x1e, 0x41, 0xb4, 0x79,
      0xad, 0x57, 0x69, 0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0,
      0xcc, 0xf3, 0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd,
      0x02, 0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e,
      0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf, 0x33,
      0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: length of integer = 2**31 - 1
    // tcID: 382
    {SEC_OID_SHA224,
     382,
     {0x30, 0x41, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69, 0x05,
      0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3, 0x48, 0x43,
      0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02, 0x84, 0x7f, 0xff,
      0xff, 0xff, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e,
      0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf, 0x33,
      0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: length of integer = 2**32 - 1
    // tcID: 383
    {SEC_OID_SHA224,
     383,
     {0x30, 0x41, 0x02, 0x84, 0xff, 0xff, 0xff, 0xff, 0x1e, 0x41, 0xb4, 0x79,
      0xad, 0x57, 0x69, 0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0,
      0xcc, 0xf3, 0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd,
      0x02, 0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e,
      0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf, 0x33,
      0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: length of integer = 2**32 - 1
    // tcID: 384
    {SEC_OID_SHA224,
     384,
     {0x30, 0x41, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69, 0x05,
      0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3, 0x48, 0x43,
      0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02, 0x84, 0xff, 0xff,
      0xff, 0xff, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e,
      0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf, 0x33,
      0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: length of integer = 2**40 - 1
    // tcID: 385
    {SEC_OID_SHA224,
     385,
     {0x30, 0x42, 0x02, 0x85, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1e, 0x41, 0xb4,
      0x79, 0xad, 0x57, 0x69, 0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91,
      0xb0, 0xcc, 0xf3, 0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9,
      0xcd, 0x02, 0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f,
      0x9e, 0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf,
      0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: length of integer = 2**40 - 1
    // tcID: 386
    {SEC_OID_SHA224,
     386,
     {0x30, 0x42, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69, 0x05,
      0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3, 0x48, 0x43,
      0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02, 0x85, 0xff, 0xff,
      0xff, 0xff, 0xff, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f,
      0x9e, 0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf,
      0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: length of integer = 2**64 - 1
    // tcID: 387
    {SEC_OID_SHA224,
     387,
     {0x30, 0x45, 0x02, 0x88, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69, 0x05, 0xb9, 0x60, 0xfe, 0x14,
      0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3, 0x48, 0x43, 0xda, 0xb9, 0x16, 0x17,
      0x3b, 0xb8, 0xc9, 0xcd, 0x02, 0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2,
      0x37, 0xd3, 0x0f, 0x9e, 0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1,
      0x69, 0x67, 0xcf, 0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: length of integer = 2**64 - 1
    // tcID: 388
    {SEC_OID_SHA224,
     388,
     {0x30, 0x45, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69, 0x05,
      0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3, 0x48, 0x43,
      0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02, 0x88, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2,
      0x37, 0xd3, 0x0f, 0x9e, 0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1,
      0x69, 0x67, 0xcf, 0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: incorrect length of integer
    // tcID: 389
    {SEC_OID_SHA224,
     389,
     {0x30, 0x3d, 0x02, 0xff, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69,
      0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3,
      0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02,
      0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e,
      0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf,
      0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: incorrect length of integer
    // tcID: 390
    {SEC_OID_SHA224,
     390,
     {0x30, 0x3d, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69,
      0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3,
      0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02,
      0xff, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e,
      0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf,
      0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: removing integer
    // tcID: 391
    {SEC_OID_SHA224,
     391,
     {0x30, 0x1f, 0x02, 0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37,
      0xd3, 0x0f, 0x9e, 0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1,
      0x69, 0x67, 0xcf, 0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: lonely integer tag
    // tcID: 392
    {SEC_OID_SHA224,
     392,
     {0x30, 0x20, 0x02, 0x02, 0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37,
      0xd3, 0x0f, 0x9e, 0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69,
      0x67, 0xcf, 0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: lonely integer tag
    // tcID: 393
    {SEC_OID_SHA224,
     393,
     {0x30, 0x1f, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69,
      0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3,
      0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: appending 0's to integer
    // tcID: 394
    {SEC_OID_SHA224,
     394,
     {0x30, 0x3f, 0x02, 0x1e, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69,
      0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3,
      0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x00,
      0x00, 0x02, 0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3,
      0x0f, 0x9e, 0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69,
      0x67, 0xcf, 0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: appending 0's to integer
    // tcID: 395
    {SEC_OID_SHA224,
     395,
     {0x30, 0x3f, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69,
      0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3,
      0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02,
      0x1f, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e,
      0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf,
      0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36, 0x00, 0x00},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: prepending 0's to integer
    // tcID: 396
    {SEC_OID_SHA224,
     396,
     {0x30, 0x3f, 0x02, 0x1e, 0x00, 0x00, 0x1e, 0x41, 0xb4, 0x79, 0xad,
      0x57, 0x69, 0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0,
      0xcc, 0xf3, 0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9,
      0xcd, 0x02, 0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3,
      0x0f, 0x9e, 0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69,
      0x67, 0xcf, 0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: prepending 0's to integer
    // tcID: 397
    {SEC_OID_SHA224,
     397,
     {0x30, 0x3f, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69,
      0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3,
      0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02,
      0x1f, 0x00, 0x00, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3,
      0x0f, 0x9e, 0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69,
      0x67, 0xcf, 0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: appending unused 0's to integer
    // tcID: 398
    {SEC_OID_SHA224,
     398,
     {0x30, 0x3f, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69,
      0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3,
      0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x00,
      0x00, 0x02, 0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3,
      0x0f, 0x9e, 0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69,
      0x67, 0xcf, 0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: appending null value to integer
    // tcID: 399
    {SEC_OID_SHA224,
     399,
     {0x30, 0x3f, 0x02, 0x1e, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69,
      0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3,
      0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x05,
      0x00, 0x02, 0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3,
      0x0f, 0x9e, 0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69,
      0x67, 0xcf, 0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: appending null value to integer
    // tcID: 400
    {SEC_OID_SHA224,
     400,
     {0x30, 0x3f, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69,
      0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3,
      0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02,
      0x1f, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e,
      0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf,
      0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36, 0x05, 0x00},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: truncated length of integer
    // tcID: 401
    {SEC_OID_SHA224,
     401,
     {0x30, 0x21, 0x02, 0x81, 0x02, 0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2,
      0x37, 0xd3, 0x0f, 0x9e, 0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1,
      0x69, 0x67, 0xcf, 0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: truncated length of integer
    // tcID: 402
    {SEC_OID_SHA224,
     402,
     {0x30, 0x20, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69, 0x05,
      0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3, 0x48, 0x43,
      0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02, 0x81},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Replacing integer with NULL
    // tcID: 403
    {SEC_OID_SHA224,
     403,
     {0x30, 0x21, 0x05, 0x00, 0x02, 0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2,
      0x37, 0xd3, 0x0f, 0x9e, 0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1,
      0x69, 0x67, 0xcf, 0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Replacing integer with NULL
    // tcID: 404
    {SEC_OID_SHA224,
     404,
     {0x30, 0x20, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69, 0x05,
      0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3, 0x48, 0x43,
      0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x05, 0x00},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: changing tag value of integer
    // tcID: 405
    {SEC_OID_SHA224,
     405,
     {0x30, 0x3d, 0x00, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69,
      0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3,
      0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02,
      0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e,
      0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf,
      0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: changing tag value of integer
    // tcID: 406
    {SEC_OID_SHA224,
     406,
     {0x30, 0x3d, 0x01, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69,
      0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3,
      0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02,
      0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e,
      0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf,
      0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: changing tag value of integer
    // tcID: 407
    {SEC_OID_SHA224,
     407,
     {0x30, 0x3d, 0x03, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69,
      0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3,
      0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02,
      0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e,
      0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf,
      0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: changing tag value of integer
    // tcID: 408
    {SEC_OID_SHA224,
     408,
     {0x30, 0x3d, 0x04, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69,
      0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3,
      0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02,
      0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e,
      0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf,
      0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: changing tag value of integer
    // tcID: 409
    {SEC_OID_SHA224,
     409,
     {0x30, 0x3d, 0xff, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69,
      0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3,
      0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02,
      0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e,
      0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf,
      0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: changing tag value of integer
    // tcID: 410
    {SEC_OID_SHA224,
     410,
     {0x30, 0x3d, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69,
      0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3,
      0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x00,
      0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e,
      0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf,
      0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: changing tag value of integer
    // tcID: 411
    {SEC_OID_SHA224,
     411,
     {0x30, 0x3d, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69,
      0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3,
      0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x01,
      0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e,
      0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf,
      0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: changing tag value of integer
    // tcID: 412
    {SEC_OID_SHA224,
     412,
     {0x30, 0x3d, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69,
      0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3,
      0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x03,
      0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e,
      0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf,
      0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: changing tag value of integer
    // tcID: 413
    {SEC_OID_SHA224,
     413,
     {0x30, 0x3d, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69,
      0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3,
      0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x04,
      0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e,
      0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf,
      0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: changing tag value of integer
    // tcID: 414
    {SEC_OID_SHA224,
     414,
     {0x30, 0x3d, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69,
      0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3,
      0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0xff,
      0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e,
      0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf,
      0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: dropping value of integer
    // tcID: 415
    {SEC_OID_SHA224,
     415,
     {0x30, 0x21, 0x02, 0x00, 0x02, 0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2,
      0x37, 0xd3, 0x0f, 0x9e, 0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1,
      0x69, 0x67, 0xcf, 0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: dropping value of integer
    // tcID: 416
    {SEC_OID_SHA224,
     416,
     {0x30, 0x20, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69, 0x05,
      0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3, 0x48, 0x43,
      0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02, 0x00},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: using composition for integer
    // tcID: 417
    {SEC_OID_SHA224,
     417,
     {0x30, 0x41, 0x22, 0x20, 0x02, 0x01, 0x1e, 0x02, 0x1b, 0x41, 0xb4, 0x79,
      0xad, 0x57, 0x69, 0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0,
      0xcc, 0xf3, 0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd,
      0x02, 0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e,
      0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf, 0x33,
      0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: using composition for integer
    // tcID: 418
    {SEC_OID_SHA224,
     418,
     {0x30, 0x41, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69, 0x05,
      0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3, 0x48, 0x43,
      0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x22, 0x21, 0x02, 0x01,
      0x00, 0x02, 0x1c, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e,
      0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf, 0x33,
      0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: modify first byte of integer
    // tcID: 419
    {SEC_OID_SHA224,
     419,
     {0x30, 0x3d, 0x02, 0x1c, 0x1c, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69,
      0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3,
      0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02,
      0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e,
      0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf,
      0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: modify first byte of integer
    // tcID: 420
    {SEC_OID_SHA224,
     420,
     {0x30, 0x3d, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69,
      0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3,
      0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02,
      0x1d, 0x02, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e,
      0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf,
      0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: modify last byte of integer
    // tcID: 421
    {SEC_OID_SHA224,
     421,
     {0x30, 0x3d, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69,
      0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3,
      0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0x4d, 0x02,
      0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e,
      0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf,
      0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: modify last byte of integer
    // tcID: 422
    {SEC_OID_SHA224,
     422,
     {0x30, 0x3d, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69,
      0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3,
      0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02,
      0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e,
      0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf,
      0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0xb6},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: truncated integer
    // tcID: 423
    {SEC_OID_SHA224,
     423,
     {0x30, 0x3c, 0x02, 0x1b, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69,
      0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3,
      0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0x02, 0x1d,
      0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e, 0xf4,
      0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf, 0x33,
      0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: truncated integer
    // tcID: 424
    {SEC_OID_SHA224,
     424,
     {0x30, 0x3c, 0x02, 0x1b, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69, 0x05,
      0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3, 0x48,
      0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02, 0x1d,
      0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e, 0xf4,
      0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf, 0x33,
      0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: truncated integer
    // tcID: 425
    {SEC_OID_SHA224,
     425,
     {0x30, 0x3c, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69,
      0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3,
      0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02,
      0x1c, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e,
      0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf,
      0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: leading ff in integer
    // tcID: 426
    {SEC_OID_SHA224,
     426,
     {0x30, 0x3e, 0x02, 0x1d, 0xff, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57,
      0x69, 0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc,
      0xf3, 0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd,
      0x02, 0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f,
      0x9e, 0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67,
      0xcf, 0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: leading ff in integer
    // tcID: 427
    {SEC_OID_SHA224,
     427,
     {0x30, 0x3e, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69,
      0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3,
      0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02,
      0x1e, 0xff, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f,
      0x9e, 0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67,
      0xcf, 0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: replaced integer by infinity
    // tcID: 428
    {SEC_OID_SHA224,
     428,
     {0x30, 0x22, 0x09, 0x01, 0x80, 0x02, 0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88,
      0xd2, 0x37, 0xd3, 0x0f, 0x9e, 0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8,
      0xf1, 0x69, 0x67, 0xcf, 0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: replaced integer by infinity
    // tcID: 429
    {SEC_OID_SHA224,
     429,
     {0x30, 0x21, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69, 0x05,
      0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3, 0x48, 0x43,
      0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x09, 0x01, 0x80},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: replacing integer with zero
    // tcID: 430
    {SEC_OID_SHA224,
     430,
     {0x30, 0x22, 0x02, 0x01, 0x00, 0x02, 0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88,
      0xd2, 0x37, 0xd3, 0x0f, 0x9e, 0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8,
      0xf1, 0x69, 0x67, 0xcf, 0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: replacing integer with zero
    // tcID: 431
    {SEC_OID_SHA224,
     431,
     {0x30, 0x21, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69, 0x05,
      0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3, 0x48, 0x43,
      0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02, 0x01, 0x00},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the group order
    // tcID: 432
    {SEC_OID_SHA224,
     432,
     {0x30, 0x3e, 0x02, 0x1d, 0x00, 0xd9, 0x38, 0x4b, 0x20, 0x32, 0xd0,
      0x60, 0xe5, 0x98, 0x48, 0xf8, 0x7c, 0xb4, 0x53, 0x59, 0x36, 0xbc,
      0x25, 0xfa, 0x77, 0x95, 0x9e, 0x96, 0xd7, 0xf8, 0x8e, 0x33, 0x2a,
      0x02, 0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f,
      0x9e, 0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67,
      0xcf, 0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the group order
    // tcID: 433
    {SEC_OID_SHA224,
     433,
     {0x30, 0x3e, 0x02, 0x1d, 0xff, 0x63, 0x4b, 0x1d, 0xd3, 0x27, 0xde,
      0x71, 0x25, 0xda, 0x79, 0x03, 0xad, 0x21, 0x63, 0xca, 0x2a, 0xdd,
      0xc0, 0x96, 0x10, 0x1f, 0xd3, 0x95, 0x56, 0x7e, 0xe3, 0x60, 0x70,
      0x02, 0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f,
      0x9e, 0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67,
      0xcf, 0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the group order
    // tcID: 434
    {SEC_OID_SHA224,
     434,
     {0x30, 0x3d, 0x02, 0x1c, 0xe1, 0xbe, 0x4b, 0x86, 0x52, 0xa8, 0x96,
      0xfa, 0x46, 0x9f, 0x01, 0xeb, 0x15, 0x24, 0x6e, 0x4f, 0x33, 0x0c,
      0xb7, 0xbc, 0x25, 0x46, 0xe9, 0xe8, 0xc4, 0x47, 0x36, 0x33, 0x02,
      0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e,
      0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf,
      0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the group order
    // tcID: 435
    {SEC_OID_SHA224,
     435,
     {0x30, 0x3e, 0x02, 0x1d, 0x00, 0x9c, 0xb4, 0xe2, 0x2c, 0xd8, 0x21,
      0x8e, 0xda, 0x25, 0x86, 0xfc, 0x52, 0xde, 0x9c, 0x35, 0xd5, 0x22,
      0x3f, 0x69, 0xef, 0xe0, 0x2c, 0x6a, 0xa9, 0x81, 0x1c, 0x9f, 0x90,
      0x02, 0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f,
      0x9e, 0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67,
      0xcf, 0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the group order
    // tcID: 436
    {SEC_OID_SHA224,
     436,
     {0x30, 0x3e, 0x02, 0x1d, 0xff, 0x26, 0xc7, 0xb4, 0xdf, 0xcd, 0x2f,
      0x9f, 0x1a, 0x67, 0xb7, 0x07, 0x83, 0x4b, 0xac, 0xa6, 0xc9, 0x43,
      0xda, 0x05, 0x88, 0x6a, 0x61, 0x69, 0x28, 0x07, 0x71, 0xcc, 0xd6,
      0x02, 0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f,
      0x9e, 0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67,
      0xcf, 0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the group order
    // tcID: 437
    {SEC_OID_SHA224,
     437,
     {0x30, 0x3e, 0x02, 0x1d, 0x01, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57,
      0x69, 0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc,
      0xf3, 0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd,
      0x02, 0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f,
      0x9e, 0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67,
      0xcf, 0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the group order
    // tcID: 438
    {SEC_OID_SHA224,
     438,
     {0x30, 0x3e, 0x02, 0x1d, 0x00, 0xe1, 0xbe, 0x4b, 0x86, 0x52, 0xa8,
      0x96, 0xfa, 0x46, 0x9f, 0x01, 0xeb, 0x15, 0x24, 0x6e, 0x4f, 0x33,
      0x0c, 0xb7, 0xbc, 0x25, 0x46, 0xe9, 0xe8, 0xc4, 0x47, 0x36, 0x33,
      0x02, 0x1d, 0x00, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f,
      0x9e, 0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67,
      0xcf, 0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the group order
    // tcID: 439
    {SEC_OID_SHA224,
     439,
     {0x30, 0x3d, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69,
      0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3,
      0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02,
      0x1d, 0x01, 0x68, 0xdc, 0xf0, 0x2f, 0x57, 0xb0, 0xca, 0xef, 0x7d,
      0xdc, 0x18, 0x3b, 0xee, 0x1c, 0xa9, 0x4e, 0xe0, 0x9c, 0x1a, 0x02,
      0xee, 0x4b, 0x02, 0x00, 0xa5, 0x4d, 0xcb, 0x93},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the group order
    // tcID: 440
    {SEC_OID_SHA224,
     440,
     {0x30, 0x3c, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69,
      0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3,
      0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02,
      0x1c, 0xf2, 0xef, 0xc2, 0xe2, 0x4c, 0xbe, 0xdb, 0x2f, 0xc0, 0x0c,
      0x23, 0x6c, 0x5b, 0x2d, 0x1a, 0x43, 0x02, 0x36, 0xb5, 0x9b, 0x78,
      0x80, 0x00, 0x7f, 0x2b, 0xa2, 0xf8, 0xd9},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the group order
    // tcID: 441
    {SEC_OID_SHA224,
     441,
     {0x30, 0x3d, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69,
      0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3,
      0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02,
      0x1d, 0xff, 0x52, 0x19, 0xa6, 0x77, 0x2d, 0xc8, 0x2c, 0xf0, 0x61,
      0x0b, 0xe2, 0x2b, 0xdb, 0x5b, 0x1e, 0x37, 0x0e, 0x96, 0x98, 0x30,
      0xcc, 0x9a, 0x7e, 0xc0, 0x17, 0x87, 0x9d, 0xca},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the group order
    // tcID: 442
    {SEC_OID_SHA224,
     442,
     {0x30, 0x3c, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69,
      0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3,
      0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02,
      0x1c, 0x0d, 0x10, 0x3d, 0x1d, 0xb3, 0x41, 0x24, 0xd0, 0x3f, 0xf3,
      0xdc, 0x93, 0xa4, 0xd2, 0xe5, 0xbc, 0xfd, 0xc9, 0x4a, 0x64, 0x87,
      0x7f, 0xff, 0x80, 0xd4, 0x5d, 0x07, 0x27},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the group order
    // tcID: 443
    {SEC_OID_SHA224,
     443,
     {0x30, 0x3d, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69,
      0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3,
      0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02,
      0x1d, 0xfe, 0x97, 0x23, 0x0f, 0xd0, 0xa8, 0x4f, 0x35, 0x10, 0x82,
      0x23, 0xe7, 0xc4, 0x11, 0xe3, 0x56, 0xb1, 0x1f, 0x63, 0xe5, 0xfd,
      0x11, 0xb4, 0xfd, 0xff, 0x5a, 0xb2, 0x34, 0x6d},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the group order
    // tcID: 444
    {SEC_OID_SHA224,
     444,
     {0x30, 0x3d, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69,
      0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3,
      0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02,
      0x1d, 0x01, 0xad, 0xe6, 0x59, 0x88, 0xd2, 0x37, 0xd3, 0x0f, 0x9e,
      0xf4, 0x1d, 0xd4, 0x24, 0xa4, 0xe1, 0xc8, 0xf1, 0x69, 0x67, 0xcf,
      0x33, 0x65, 0x81, 0x3f, 0xe8, 0x78, 0x62, 0x36},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the group order
    // tcID: 445
    {SEC_OID_SHA224,
     445,
     {0x30, 0x3c, 0x02, 0x1c, 0x1e, 0x41, 0xb4, 0x79, 0xad, 0x57, 0x69,
      0x05, 0xb9, 0x60, 0xfe, 0x14, 0xea, 0xdb, 0x91, 0xb0, 0xcc, 0xf3,
      0x48, 0x43, 0xda, 0xb9, 0x16, 0x17, 0x3b, 0xb8, 0xc9, 0xcd, 0x02,
      0x1c, 0x52, 0x19, 0xa6, 0x77, 0x2d, 0xc8, 0x2c, 0xf0, 0x61, 0x0b,
      0xe2, 0x2b, 0xdb, 0x5b, 0x1e, 0x37, 0x0e, 0x96, 0x98, 0x30, 0xcc,
      0x9a, 0x7e, 0xc0, 0x17, 0x87, 0x9d, 0xca},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 446
    {SEC_OID_SHA224,
     446,
     {0x30, 0x22, 0x02, 0x01, 0x00, 0x02, 0x1d, 0xff, 0x45, 0x09, 0x69, 0x59,
      0x7a, 0x87, 0x08, 0x20, 0x21, 0x18, 0x05, 0x98, 0x36, 0x88, 0x38, 0x7a,
      0x10, 0xcd, 0x4d, 0xcc, 0x45, 0x1a, 0x7f, 0x3f, 0x43, 0x2a, 0x96, 0xa3},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 447
    {SEC_OID_SHA224,
     447,
     {0x30, 0x06, 0x02, 0x01, 0x00, 0x02, 0x01, 0x00},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 448
    {SEC_OID_SHA224,
     448,
     {0x30, 0x06, 0x02, 0x01, 0x00, 0x02, 0x01, 0x01},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 449
    {SEC_OID_SHA224,
     449,
     {0x30, 0x06, 0x02, 0x01, 0x00, 0x02, 0x01, 0xff},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 450
    {SEC_OID_SHA224,
     450,
     {0x30, 0x21, 0x02, 0x01, 0x00, 0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42,
      0xbc, 0x7b, 0xef, 0xef, 0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7,
      0x99, 0x59, 0x19, 0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xae},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 451
    {SEC_OID_SHA224,
     451,
     {0x30, 0x21, 0x02, 0x01, 0x00, 0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42,
      0xbc, 0x7b, 0xef, 0xef, 0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7,
      0x99, 0x59, 0x19, 0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xaf},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 452
    {SEC_OID_SHA224,
     452,
     {0x30, 0x22, 0x02, 0x01, 0x00, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6,
      0x85, 0x78, 0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85,
      0xef, 0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5c},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 453
    {SEC_OID_SHA224,
     453,
     {0x30, 0x22, 0x02, 0x01, 0x00, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6,
      0x85, 0x78, 0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85,
      0xef, 0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5d},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 454
    {SEC_OID_SHA224,
     454,
     {0x30, 0x22, 0x02, 0x01, 0x00, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6,
      0x85, 0x78, 0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85,
      0xef, 0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5e},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 455
    {SEC_OID_SHA224,
     455,
     {0x30, 0x22, 0x02, 0x01, 0x00, 0x02, 0x1d, 0x01, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 456
    {SEC_OID_SHA224,
     456,
     {0x30, 0x82, 0x01, 0x08, 0x02, 0x01, 0x00, 0x02, 0x82, 0x01, 0x01, 0x00,
      0x8f, 0x79, 0x35, 0xd9, 0xb9, 0xaa, 0xe9, 0xbf, 0xab, 0xed, 0x88, 0x7a,
      0xcf, 0x49, 0x51, 0xb6, 0xf3, 0x2e, 0xc5, 0x9e, 0x3b, 0xaf, 0x37, 0x18,
      0xe8, 0xea, 0xc4, 0x96, 0x1f, 0x3e, 0xfd, 0x36, 0x06, 0xe7, 0x43, 0x51,
      0xa9, 0xc4, 0x18, 0x33, 0x39, 0xb8, 0x09, 0xe7, 0xc2, 0xae, 0x1c, 0x53,
      0x9b, 0xa7, 0x47, 0x5b, 0x85, 0xd0, 0x11, 0xad, 0xb8, 0xb4, 0x79, 0x87,
      0x75, 0x49, 0x84, 0x69, 0x5c, 0xac, 0x0e, 0x8f, 0x14, 0xb3, 0x36, 0x08,
      0x28, 0xa2, 0x2f, 0xfa, 0x27, 0x11, 0x0a, 0x3d, 0x62, 0xa9, 0x93, 0x45,
      0x34, 0x09, 0xa0, 0xfe, 0x69, 0x6c, 0x46, 0x58, 0xf8, 0x4b, 0xdd, 0x20,
      0x81, 0x9c, 0x37, 0x09, 0xa0, 0x10, 0x57, 0xb1, 0x95, 0xad, 0xcd, 0x00,
      0x23, 0x3d, 0xba, 0x54, 0x84, 0xb6, 0x29, 0x1f, 0x9d, 0x64, 0x8e, 0xf8,
      0x83, 0x44, 0x86, 0x77, 0x97, 0x9c, 0xec, 0x04, 0xb4, 0x34, 0xa6, 0xac,
      0x2e, 0x75, 0xe9, 0x98, 0x5d, 0xe2, 0x3d, 0xb0, 0x29, 0x2f, 0xc1, 0x11,
      0x8c, 0x9f, 0xfa, 0x9d, 0x81, 0x81, 0xe7, 0x33, 0x8d, 0xb7, 0x92, 0xb7,
      0x30, 0xd7, 0xb9, 0xe3, 0x49, 0x59, 0x2f, 0x68, 0x09, 0x98, 0x72, 0x15,
      0x39, 0x15, 0xea, 0x3d, 0x6b, 0x8b, 0x46, 0x53, 0xc6, 0x33, 0x45, 0x8f,
      0x80, 0x3b, 0x32, 0xa4, 0xc2, 0xe0, 0xf2, 0x72, 0x90, 0x25, 0x6e, 0x4e,
      0x3f, 0x8a, 0x3b, 0x08, 0x38, 0xa1, 0xc4, 0x50, 0xe4, 0xe1, 0x8c, 0x1a,
      0x29, 0xa3, 0x7d, 0xdf, 0x5e, 0xa1, 0x43, 0xde, 0x4b, 0x66, 0xff, 0x04,
      0x90, 0x3e, 0xd5, 0xcf, 0x16, 0x23, 0xe1, 0x58, 0xd4, 0x87, 0xc6, 0x08,
      0xe9, 0x7f, 0x21, 0x1c, 0xd8, 0x1d, 0xca, 0x23, 0xcb, 0x6e, 0x38, 0x07,
      0x65, 0xf8, 0x22, 0xe3, 0x42, 0xbe, 0x48, 0x4c, 0x05, 0x76, 0x39, 0x39,
      0x60, 0x1c, 0xd6, 0x67},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 457
    {SEC_OID_SHA224,
     457,
     {0x30, 0x08, 0x02, 0x01, 0x00, 0x09, 0x03, 0x80, 0xfe, 0x01},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 458
    {SEC_OID_SHA224,
     458,
     {0x30, 0x06, 0x02, 0x01, 0x00, 0x09, 0x01, 0x42},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 459
    {SEC_OID_SHA224,
     459,
     {0x30, 0x22, 0x02, 0x01, 0x01, 0x02, 0x1d, 0xff, 0x45, 0x09, 0x69, 0x59,
      0x7a, 0x87, 0x08, 0x20, 0x21, 0x18, 0x05, 0x98, 0x36, 0x88, 0x38, 0x7a,
      0x10, 0xcd, 0x4d, 0xcc, 0x45, 0x1a, 0x7f, 0x3f, 0x43, 0x2a, 0x96, 0xa3},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 460
    {SEC_OID_SHA224,
     460,
     {0x30, 0x06, 0x02, 0x01, 0x01, 0x02, 0x01, 0x00},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 461
    {SEC_OID_SHA224,
     461,
     {0x30, 0x06, 0x02, 0x01, 0x01, 0x02, 0x01, 0x01},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 462
    {SEC_OID_SHA224,
     462,
     {0x30, 0x06, 0x02, 0x01, 0x01, 0x02, 0x01, 0xff},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 463
    {SEC_OID_SHA224,
     463,
     {0x30, 0x21, 0x02, 0x01, 0x01, 0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42,
      0xbc, 0x7b, 0xef, 0xef, 0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7,
      0x99, 0x59, 0x19, 0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xae},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 464
    {SEC_OID_SHA224,
     464,
     {0x30, 0x21, 0x02, 0x01, 0x01, 0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42,
      0xbc, 0x7b, 0xef, 0xef, 0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7,
      0x99, 0x59, 0x19, 0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xaf},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 465
    {SEC_OID_SHA224,
     465,
     {0x30, 0x22, 0x02, 0x01, 0x01, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6,
      0x85, 0x78, 0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85,
      0xef, 0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5c},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 466
    {SEC_OID_SHA224,
     466,
     {0x30, 0x22, 0x02, 0x01, 0x01, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6,
      0x85, 0x78, 0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85,
      0xef, 0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5d},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 467
    {SEC_OID_SHA224,
     467,
     {0x30, 0x22, 0x02, 0x01, 0x01, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6,
      0x85, 0x78, 0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85,
      0xef, 0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5e},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 468
    {SEC_OID_SHA224,
     468,
     {0x30, 0x22, 0x02, 0x01, 0x01, 0x02, 0x1d, 0x01, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 469
    {SEC_OID_SHA224,
     469,
     {0x30, 0x82, 0x01, 0x08, 0x02, 0x01, 0x01, 0x02, 0x82, 0x01, 0x01, 0x00,
      0x8f, 0x79, 0x35, 0xd9, 0xb9, 0xaa, 0xe9, 0xbf, 0xab, 0xed, 0x88, 0x7a,
      0xcf, 0x49, 0x51, 0xb6, 0xf3, 0x2e, 0xc5, 0x9e, 0x3b, 0xaf, 0x37, 0x18,
      0xe8, 0xea, 0xc4, 0x96, 0x1f, 0x3e, 0xfd, 0x36, 0x06, 0xe7, 0x43, 0x51,
      0xa9, 0xc4, 0x18, 0x33, 0x39, 0xb8, 0x09, 0xe7, 0xc2, 0xae, 0x1c, 0x53,
      0x9b, 0xa7, 0x47, 0x5b, 0x85, 0xd0, 0x11, 0xad, 0xb8, 0xb4, 0x79, 0x87,
      0x75, 0x49, 0x84, 0x69, 0x5c, 0xac, 0x0e, 0x8f, 0x14, 0xb3, 0x36, 0x08,
      0x28, 0xa2, 0x2f, 0xfa, 0x27, 0x11, 0x0a, 0x3d, 0x62, 0xa9, 0x93, 0x45,
      0x34, 0x09, 0xa0, 0xfe, 0x69, 0x6c, 0x46, 0x58, 0xf8, 0x4b, 0xdd, 0x20,
      0x81, 0x9c, 0x37, 0x09, 0xa0, 0x10, 0x57, 0xb1, 0x95, 0xad, 0xcd, 0x00,
      0x23, 0x3d, 0xba, 0x54, 0x84, 0xb6, 0x29, 0x1f, 0x9d, 0x64, 0x8e, 0xf8,
      0x83, 0x44, 0x86, 0x77, 0x97, 0x9c, 0xec, 0x04, 0xb4, 0x34, 0xa6, 0xac,
      0x2e, 0x75, 0xe9, 0x98, 0x5d, 0xe2, 0x3d, 0xb0, 0x29, 0x2f, 0xc1, 0x11,
      0x8c, 0x9f, 0xfa, 0x9d, 0x81, 0x81, 0xe7, 0x33, 0x8d, 0xb7, 0x92, 0xb7,
      0x30, 0xd7, 0xb9, 0xe3, 0x49, 0x59, 0x2f, 0x68, 0x09, 0x98, 0x72, 0x15,
      0x39, 0x15, 0xea, 0x3d, 0x6b, 0x8b, 0x46, 0x53, 0xc6, 0x33, 0x45, 0x8f,
      0x80, 0x3b, 0x32, 0xa4, 0xc2, 0xe0, 0xf2, 0x72, 0x90, 0x25, 0x6e, 0x4e,
      0x3f, 0x8a, 0x3b, 0x08, 0x38, 0xa1, 0xc4, 0x50, 0xe4, 0xe1, 0x8c, 0x1a,
      0x29, 0xa3, 0x7d, 0xdf, 0x5e, 0xa1, 0x43, 0xde, 0x4b, 0x66, 0xff, 0x04,
      0x90, 0x3e, 0xd5, 0xcf, 0x16, 0x23, 0xe1, 0x58, 0xd4, 0x87, 0xc6, 0x08,
      0xe9, 0x7f, 0x21, 0x1c, 0xd8, 0x1d, 0xca, 0x23, 0xcb, 0x6e, 0x38, 0x07,
      0x65, 0xf8, 0x22, 0xe3, 0x42, 0xbe, 0x48, 0x4c, 0x05, 0x76, 0x39, 0x39,
      0x60, 0x1c, 0xd6, 0x67},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 470
    {SEC_OID_SHA224,
     470,
     {0x30, 0x08, 0x02, 0x01, 0x01, 0x09, 0x03, 0x80, 0xfe, 0x01},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 471
    {SEC_OID_SHA224,
     471,
     {0x30, 0x06, 0x02, 0x01, 0x01, 0x09, 0x01, 0x42},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 472
    {SEC_OID_SHA224,
     472,
     {0x30, 0x22, 0x02, 0x01, 0xff, 0x02, 0x1d, 0xff, 0x45, 0x09, 0x69, 0x59,
      0x7a, 0x87, 0x08, 0x20, 0x21, 0x18, 0x05, 0x98, 0x36, 0x88, 0x38, 0x7a,
      0x10, 0xcd, 0x4d, 0xcc, 0x45, 0x1a, 0x7f, 0x3f, 0x43, 0x2a, 0x96, 0xa3},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 473
    {SEC_OID_SHA224,
     473,
     {0x30, 0x06, 0x02, 0x01, 0xff, 0x02, 0x01, 0x00},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 474
    {SEC_OID_SHA224,
     474,
     {0x30, 0x06, 0x02, 0x01, 0xff, 0x02, 0x01, 0x01},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 475
    {SEC_OID_SHA224,
     475,
     {0x30, 0x06, 0x02, 0x01, 0xff, 0x02, 0x01, 0xff},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 476
    {SEC_OID_SHA224,
     476,
     {0x30, 0x21, 0x02, 0x01, 0xff, 0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42,
      0xbc, 0x7b, 0xef, 0xef, 0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7,
      0x99, 0x59, 0x19, 0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xae},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 477
    {SEC_OID_SHA224,
     477,
     {0x30, 0x21, 0x02, 0x01, 0xff, 0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42,
      0xbc, 0x7b, 0xef, 0xef, 0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7,
      0x99, 0x59, 0x19, 0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xaf},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 478
    {SEC_OID_SHA224,
     478,
     {0x30, 0x22, 0x02, 0x01, 0xff, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6,
      0x85, 0x78, 0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85,
      0xef, 0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5c},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 479
    {SEC_OID_SHA224,
     479,
     {0x30, 0x22, 0x02, 0x01, 0xff, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6,
      0x85, 0x78, 0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85,
      0xef, 0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5d},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 480
    {SEC_OID_SHA224,
     480,
     {0x30, 0x22, 0x02, 0x01, 0xff, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6,
      0x85, 0x78, 0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85,
      0xef, 0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5e},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 481
    {SEC_OID_SHA224,
     481,
     {0x30, 0x22, 0x02, 0x01, 0xff, 0x02, 0x1d, 0x01, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 482
    {SEC_OID_SHA224,
     482,
     {0x30, 0x82, 0x01, 0x08, 0x02, 0x01, 0xff, 0x02, 0x82, 0x01, 0x01, 0x00,
      0x8f, 0x79, 0x35, 0xd9, 0xb9, 0xaa, 0xe9, 0xbf, 0xab, 0xed, 0x88, 0x7a,
      0xcf, 0x49, 0x51, 0xb6, 0xf3, 0x2e, 0xc5, 0x9e, 0x3b, 0xaf, 0x37, 0x18,
      0xe8, 0xea, 0xc4, 0x96, 0x1f, 0x3e, 0xfd, 0x36, 0x06, 0xe7, 0x43, 0x51,
      0xa9, 0xc4, 0x18, 0x33, 0x39, 0xb8, 0x09, 0xe7, 0xc2, 0xae, 0x1c, 0x53,
      0x9b, 0xa7, 0x47, 0x5b, 0x85, 0xd0, 0x11, 0xad, 0xb8, 0xb4, 0x79, 0x87,
      0x75, 0x49, 0x84, 0x69, 0x5c, 0xac, 0x0e, 0x8f, 0x14, 0xb3, 0x36, 0x08,
      0x28, 0xa2, 0x2f, 0xfa, 0x27, 0x11, 0x0a, 0x3d, 0x62, 0xa9, 0x93, 0x45,
      0x34, 0x09, 0xa0, 0xfe, 0x69, 0x6c, 0x46, 0x58, 0xf8, 0x4b, 0xdd, 0x20,
      0x81, 0x9c, 0x37, 0x09, 0xa0, 0x10, 0x57, 0xb1, 0x95, 0xad, 0xcd, 0x00,
      0x23, 0x3d, 0xba, 0x54, 0x84, 0xb6, 0x29, 0x1f, 0x9d, 0x64, 0x8e, 0xf8,
      0x83, 0x44, 0x86, 0x77, 0x97, 0x9c, 0xec, 0x04, 0xb4, 0x34, 0xa6, 0xac,
      0x2e, 0x75, 0xe9, 0x98, 0x5d, 0xe2, 0x3d, 0xb0, 0x29, 0x2f, 0xc1, 0x11,
      0x8c, 0x9f, 0xfa, 0x9d, 0x81, 0x81, 0xe7, 0x33, 0x8d, 0xb7, 0x92, 0xb7,
      0x30, 0xd7, 0xb9, 0xe3, 0x49, 0x59, 0x2f, 0x68, 0x09, 0x98, 0x72, 0x15,
      0x39, 0x15, 0xea, 0x3d, 0x6b, 0x8b, 0x46, 0x53, 0xc6, 0x33, 0x45, 0x8f,
      0x80, 0x3b, 0x32, 0xa4, 0xc2, 0xe0, 0xf2, 0x72, 0x90, 0x25, 0x6e, 0x4e,
      0x3f, 0x8a, 0x3b, 0x08, 0x38, 0xa1, 0xc4, 0x50, 0xe4, 0xe1, 0x8c, 0x1a,
      0x29, 0xa3, 0x7d, 0xdf, 0x5e, 0xa1, 0x43, 0xde, 0x4b, 0x66, 0xff, 0x04,
      0x90, 0x3e, 0xd5, 0xcf, 0x16, 0x23, 0xe1, 0x58, 0xd4, 0x87, 0xc6, 0x08,
      0xe9, 0x7f, 0x21, 0x1c, 0xd8, 0x1d, 0xca, 0x23, 0xcb, 0x6e, 0x38, 0x07,
      0x65, 0xf8, 0x22, 0xe3, 0x42, 0xbe, 0x48, 0x4c, 0x05, 0x76, 0x39, 0x39,
      0x60, 0x1c, 0xd6, 0x67},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 483
    {SEC_OID_SHA224,
     483,
     {0x30, 0x08, 0x02, 0x01, 0xff, 0x09, 0x03, 0x80, 0xfe, 0x01},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 484
    {SEC_OID_SHA224,
     484,
     {0x30, 0x06, 0x02, 0x01, 0xff, 0x09, 0x01, 0x42},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 485
    {SEC_OID_SHA224,
     485,
     {0x30, 0x3d, 0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b,
      0xef, 0xef, 0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99,
      0x59, 0x19, 0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xae, 0x02,
      0x1d, 0xff, 0x45, 0x09, 0x69, 0x59, 0x7a, 0x87, 0x08, 0x20, 0x21,
      0x18, 0x05, 0x98, 0x36, 0x88, 0x38, 0x7a, 0x10, 0xcd, 0x4d, 0xcc,
      0x45, 0x1a, 0x7f, 0x3f, 0x43, 0x2a, 0x96, 0xa3},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 486
    {SEC_OID_SHA224,
     486,
     {0x30, 0x21, 0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b, 0xef,
      0xef, 0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99, 0x59, 0x19,
      0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xae, 0x02, 0x01, 0x00},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 487
    {SEC_OID_SHA224,
     487,
     {0x30, 0x21, 0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b, 0xef,
      0xef, 0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99, 0x59, 0x19,
      0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xae, 0x02, 0x01, 0x01},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 488
    {SEC_OID_SHA224,
     488,
     {0x30, 0x21, 0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b, 0xef,
      0xef, 0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99, 0x59, 0x19,
      0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xae, 0x02, 0x01, 0xff},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 489
    {SEC_OID_SHA224,
     489,
     {0x30, 0x3c, 0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b,
      0xef, 0xef, 0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99,
      0x59, 0x19, 0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xae, 0x02,
      0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b, 0xef, 0xef, 0x73,
      0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99, 0x59, 0x19, 0xdd,
      0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xae},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 490
    {SEC_OID_SHA224,
     490,
     {0x30, 0x3c, 0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b,
      0xef, 0xef, 0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99,
      0x59, 0x19, 0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xae, 0x02,
      0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b, 0xef, 0xef, 0x73,
      0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99, 0x59, 0x19, 0xdd,
      0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xaf},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 491
    {SEC_OID_SHA224,
     491,
     {0x30, 0x3d, 0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b,
      0xef, 0xef, 0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99,
      0x59, 0x19, 0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xae, 0x02,
      0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7, 0xdf, 0xde,
      0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2, 0x33,
      0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5c},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 492
    {SEC_OID_SHA224,
     492,
     {0x30, 0x3d, 0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b,
      0xef, 0xef, 0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99,
      0x59, 0x19, 0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xae, 0x02,
      0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7, 0xdf, 0xde,
      0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2, 0x33,
      0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5d},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 493
    {SEC_OID_SHA224,
     493,
     {0x30, 0x3d, 0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b,
      0xef, 0xef, 0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99,
      0x59, 0x19, 0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xae, 0x02,
      0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7, 0xdf, 0xde,
      0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2, 0x33,
      0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5e},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 494
    {SEC_OID_SHA224,
     494,
     {0x30, 0x3d, 0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b,
      0xef, 0xef, 0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99,
      0x59, 0x19, 0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xae, 0x02,
      0x1d, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 495
    {SEC_OID_SHA224,
     495,
     {0x30, 0x82, 0x01, 0x23, 0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc,
      0x7b, 0xef, 0xef, 0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99,
      0x59, 0x19, 0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xae, 0x02, 0x82,
      0x01, 0x01, 0x00, 0x8f, 0x79, 0x35, 0xd9, 0xb9, 0xaa, 0xe9, 0xbf, 0xab,
      0xed, 0x88, 0x7a, 0xcf, 0x49, 0x51, 0xb6, 0xf3, 0x2e, 0xc5, 0x9e, 0x3b,
      0xaf, 0x37, 0x18, 0xe8, 0xea, 0xc4, 0x96, 0x1f, 0x3e, 0xfd, 0x36, 0x06,
      0xe7, 0x43, 0x51, 0xa9, 0xc4, 0x18, 0x33, 0x39, 0xb8, 0x09, 0xe7, 0xc2,
      0xae, 0x1c, 0x53, 0x9b, 0xa7, 0x47, 0x5b, 0x85, 0xd0, 0x11, 0xad, 0xb8,
      0xb4, 0x79, 0x87, 0x75, 0x49, 0x84, 0x69, 0x5c, 0xac, 0x0e, 0x8f, 0x14,
      0xb3, 0x36, 0x08, 0x28, 0xa2, 0x2f, 0xfa, 0x27, 0x11, 0x0a, 0x3d, 0x62,
      0xa9, 0x93, 0x45, 0x34, 0x09, 0xa0, 0xfe, 0x69, 0x6c, 0x46, 0x58, 0xf8,
      0x4b, 0xdd, 0x20, 0x81, 0x9c, 0x37, 0x09, 0xa0, 0x10, 0x57, 0xb1, 0x95,
      0xad, 0xcd, 0x00, 0x23, 0x3d, 0xba, 0x54, 0x84, 0xb6, 0x29, 0x1f, 0x9d,
      0x64, 0x8e, 0xf8, 0x83, 0x44, 0x86, 0x77, 0x97, 0x9c, 0xec, 0x04, 0xb4,
      0x34, 0xa6, 0xac, 0x2e, 0x75, 0xe9, 0x98, 0x5d, 0xe2, 0x3d, 0xb0, 0x29,
      0x2f, 0xc1, 0x11, 0x8c, 0x9f, 0xfa, 0x9d, 0x81, 0x81, 0xe7, 0x33, 0x8d,
      0xb7, 0x92, 0xb7, 0x30, 0xd7, 0xb9, 0xe3, 0x49, 0x59, 0x2f, 0x68, 0x09,
      0x98, 0x72, 0x15, 0x39, 0x15, 0xea, 0x3d, 0x6b, 0x8b, 0x46, 0x53, 0xc6,
      0x33, 0x45, 0x8f, 0x80, 0x3b, 0x32, 0xa4, 0xc2, 0xe0, 0xf2, 0x72, 0x90,
      0x25, 0x6e, 0x4e, 0x3f, 0x8a, 0x3b, 0x08, 0x38, 0xa1, 0xc4, 0x50, 0xe4,
      0xe1, 0x8c, 0x1a, 0x29, 0xa3, 0x7d, 0xdf, 0x5e, 0xa1, 0x43, 0xde, 0x4b,
      0x66, 0xff, 0x04, 0x90, 0x3e, 0xd5, 0xcf, 0x16, 0x23, 0xe1, 0x58, 0xd4,
      0x87, 0xc6, 0x08, 0xe9, 0x7f, 0x21, 0x1c, 0xd8, 0x1d, 0xca, 0x23, 0xcb,
      0x6e, 0x38, 0x07, 0x65, 0xf8, 0x22, 0xe3, 0x42, 0xbe, 0x48, 0x4c, 0x05,
      0x76, 0x39, 0x39, 0x60, 0x1c, 0xd6, 0x67},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 496
    {SEC_OID_SHA224,
     496,
     {0x30, 0x23, 0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc,
      0x7b, 0xef, 0xef, 0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2,
      0xf7, 0x99, 0x59, 0x19, 0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a,
      0xb4, 0xae, 0x09, 0x03, 0x80, 0xfe, 0x01},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 497
    {SEC_OID_SHA224,
     497,
     {0x30, 0x21, 0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b, 0xef,
      0xef, 0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99, 0x59, 0x19,
      0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xae, 0x09, 0x01, 0x42},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 498
    {SEC_OID_SHA224,
     498,
     {0x30, 0x3d, 0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b,
      0xef, 0xef, 0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99,
      0x59, 0x19, 0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xaf, 0x02,
      0x1d, 0xff, 0x45, 0x09, 0x69, 0x59, 0x7a, 0x87, 0x08, 0x20, 0x21,
      0x18, 0x05, 0x98, 0x36, 0x88, 0x38, 0x7a, 0x10, 0xcd, 0x4d, 0xcc,
      0x45, 0x1a, 0x7f, 0x3f, 0x43, 0x2a, 0x96, 0xa3},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 499
    {SEC_OID_SHA224,
     499,
     {0x30, 0x21, 0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b, 0xef,
      0xef, 0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99, 0x59, 0x19,
      0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xaf, 0x02, 0x01, 0x00},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 500
    {SEC_OID_SHA224,
     500,
     {0x30, 0x21, 0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b, 0xef,
      0xef, 0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99, 0x59, 0x19,
      0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xaf, 0x02, 0x01, 0x01},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 501
    {SEC_OID_SHA224,
     501,
     {0x30, 0x21, 0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b, 0xef,
      0xef, 0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99, 0x59, 0x19,
      0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xaf, 0x02, 0x01, 0xff},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 502
    {SEC_OID_SHA224,
     502,
     {0x30, 0x3c, 0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b,
      0xef, 0xef, 0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99,
      0x59, 0x19, 0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xaf, 0x02,
      0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b, 0xef, 0xef, 0x73,
      0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99, 0x59, 0x19, 0xdd,
      0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xae},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 503
    {SEC_OID_SHA224,
     503,
     {0x30, 0x3c, 0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b,
      0xef, 0xef, 0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99,
      0x59, 0x19, 0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xaf, 0x02,
      0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b, 0xef, 0xef, 0x73,
      0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99, 0x59, 0x19, 0xdd,
      0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xaf},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 504
    {SEC_OID_SHA224,
     504,
     {0x30, 0x3d, 0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b,
      0xef, 0xef, 0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99,
      0x59, 0x19, 0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xaf, 0x02,
      0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7, 0xdf, 0xde,
      0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2, 0x33,
      0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5c},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 505
    {SEC_OID_SHA224,
     505,
     {0x30, 0x3d, 0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b,
      0xef, 0xef, 0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99,
      0x59, 0x19, 0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xaf, 0x02,
      0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7, 0xdf, 0xde,
      0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2, 0x33,
      0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5d},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 506
    {SEC_OID_SHA224,
     506,
     {0x30, 0x3d, 0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b,
      0xef, 0xef, 0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99,
      0x59, 0x19, 0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xaf, 0x02,
      0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7, 0xdf, 0xde,
      0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2, 0x33,
      0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5e},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 507
    {SEC_OID_SHA224,
     507,
     {0x30, 0x3d, 0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b,
      0xef, 0xef, 0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99,
      0x59, 0x19, 0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xaf, 0x02,
      0x1d, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 508
    {SEC_OID_SHA224,
     508,
     {0x30, 0x82, 0x01, 0x23, 0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc,
      0x7b, 0xef, 0xef, 0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99,
      0x59, 0x19, 0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xaf, 0x02, 0x82,
      0x01, 0x01, 0x00, 0x8f, 0x79, 0x35, 0xd9, 0xb9, 0xaa, 0xe9, 0xbf, 0xab,
      0xed, 0x88, 0x7a, 0xcf, 0x49, 0x51, 0xb6, 0xf3, 0x2e, 0xc5, 0x9e, 0x3b,
      0xaf, 0x37, 0x18, 0xe8, 0xea, 0xc4, 0x96, 0x1f, 0x3e, 0xfd, 0x36, 0x06,
      0xe7, 0x43, 0x51, 0xa9, 0xc4, 0x18, 0x33, 0x39, 0xb8, 0x09, 0xe7, 0xc2,
      0xae, 0x1c, 0x53, 0x9b, 0xa7, 0x47, 0x5b, 0x85, 0xd0, 0x11, 0xad, 0xb8,
      0xb4, 0x79, 0x87, 0x75, 0x49, 0x84, 0x69, 0x5c, 0xac, 0x0e, 0x8f, 0x14,
      0xb3, 0x36, 0x08, 0x28, 0xa2, 0x2f, 0xfa, 0x27, 0x11, 0x0a, 0x3d, 0x62,
      0xa9, 0x93, 0x45, 0x34, 0x09, 0xa0, 0xfe, 0x69, 0x6c, 0x46, 0x58, 0xf8,
      0x4b, 0xdd, 0x20, 0x81, 0x9c, 0x37, 0x09, 0xa0, 0x10, 0x57, 0xb1, 0x95,
      0xad, 0xcd, 0x00, 0x23, 0x3d, 0xba, 0x54, 0x84, 0xb6, 0x29, 0x1f, 0x9d,
      0x64, 0x8e, 0xf8, 0x83, 0x44, 0x86, 0x77, 0x97, 0x9c, 0xec, 0x04, 0xb4,
      0x34, 0xa6, 0xac, 0x2e, 0x75, 0xe9, 0x98, 0x5d, 0xe2, 0x3d, 0xb0, 0x29,
      0x2f, 0xc1, 0x11, 0x8c, 0x9f, 0xfa, 0x9d, 0x81, 0x81, 0xe7, 0x33, 0x8d,
      0xb7, 0x92, 0xb7, 0x30, 0xd7, 0xb9, 0xe3, 0x49, 0x59, 0x2f, 0x68, 0x09,
      0x98, 0x72, 0x15, 0x39, 0x15, 0xea, 0x3d, 0x6b, 0x8b, 0x46, 0x53, 0xc6,
      0x33, 0x45, 0x8f, 0x80, 0x3b, 0x32, 0xa4, 0xc2, 0xe0, 0xf2, 0x72, 0x90,
      0x25, 0x6e, 0x4e, 0x3f, 0x8a, 0x3b, 0x08, 0x38, 0xa1, 0xc4, 0x50, 0xe4,
      0xe1, 0x8c, 0x1a, 0x29, 0xa3, 0x7d, 0xdf, 0x5e, 0xa1, 0x43, 0xde, 0x4b,
      0x66, 0xff, 0x04, 0x90, 0x3e, 0xd5, 0xcf, 0x16, 0x23, 0xe1, 0x58, 0xd4,
      0x87, 0xc6, 0x08, 0xe9, 0x7f, 0x21, 0x1c, 0xd8, 0x1d, 0xca, 0x23, 0xcb,
      0x6e, 0x38, 0x07, 0x65, 0xf8, 0x22, 0xe3, 0x42, 0xbe, 0x48, 0x4c, 0x05,
      0x76, 0x39, 0x39, 0x60, 0x1c, 0xd6, 0x67},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 509
    {SEC_OID_SHA224,
     509,
     {0x30, 0x23, 0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc,
      0x7b, 0xef, 0xef, 0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2,
      0xf7, 0x99, 0x59, 0x19, 0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a,
      0xb4, 0xaf, 0x09, 0x03, 0x80, 0xfe, 0x01},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 510
    {SEC_OID_SHA224,
     510,
     {0x30, 0x21, 0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b, 0xef,
      0xef, 0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99, 0x59, 0x19,
      0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xaf, 0x09, 0x01, 0x42},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 511
    {SEC_OID_SHA224,
     511,
     {0x30, 0x3e, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78,
      0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef,
      0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5c,
      0x02, 0x1d, 0xff, 0x45, 0x09, 0x69, 0x59, 0x7a, 0x87, 0x08, 0x20,
      0x21, 0x18, 0x05, 0x98, 0x36, 0x88, 0x38, 0x7a, 0x10, 0xcd, 0x4d,
      0xcc, 0x45, 0x1a, 0x7f, 0x3f, 0x43, 0x2a, 0x96, 0xa3},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 512
    {SEC_OID_SHA224,
     512,
     {0x30, 0x22, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7,
      0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2,
      0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5c, 0x02, 0x01, 0x00},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 513
    {SEC_OID_SHA224,
     513,
     {0x30, 0x22, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7,
      0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2,
      0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5c, 0x02, 0x01, 0x01},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 514
    {SEC_OID_SHA224,
     514,
     {0x30, 0x22, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7,
      0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2,
      0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5c, 0x02, 0x01, 0xff},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 515
    {SEC_OID_SHA224,
     515,
     {0x30, 0x3d, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78,
      0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef,
      0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5c,
      0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b, 0xef, 0xef,
      0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99, 0x59, 0x19,
      0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xae},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 516
    {SEC_OID_SHA224,
     516,
     {0x30, 0x3d, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78,
      0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef,
      0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5c,
      0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b, 0xef, 0xef,
      0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99, 0x59, 0x19,
      0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xaf},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 517
    {SEC_OID_SHA224,
     517,
     {0x30, 0x3e, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78,
      0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef,
      0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5c,
      0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7, 0xdf,
      0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2,
      0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5c},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 518
    {SEC_OID_SHA224,
     518,
     {0x30, 0x3e, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78,
      0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef,
      0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5c,
      0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7, 0xdf,
      0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2,
      0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5d},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 519
    {SEC_OID_SHA224,
     519,
     {0x30, 0x3e, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78,
      0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef,
      0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5c,
      0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7, 0xdf,
      0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2,
      0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5e},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 520
    {SEC_OID_SHA224,
     520,
     {0x30, 0x3e, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78,
      0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef,
      0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5c,
      0x02, 0x1d, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 521
    {SEC_OID_SHA224,
     521,
     {0x30, 0x82, 0x01, 0x24, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85,
      0x78, 0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef,
      0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5c, 0x02,
      0x82, 0x01, 0x01, 0x00, 0x8f, 0x79, 0x35, 0xd9, 0xb9, 0xaa, 0xe9, 0xbf,
      0xab, 0xed, 0x88, 0x7a, 0xcf, 0x49, 0x51, 0xb6, 0xf3, 0x2e, 0xc5, 0x9e,
      0x3b, 0xaf, 0x37, 0x18, 0xe8, 0xea, 0xc4, 0x96, 0x1f, 0x3e, 0xfd, 0x36,
      0x06, 0xe7, 0x43, 0x51, 0xa9, 0xc4, 0x18, 0x33, 0x39, 0xb8, 0x09, 0xe7,
      0xc2, 0xae, 0x1c, 0x53, 0x9b, 0xa7, 0x47, 0x5b, 0x85, 0xd0, 0x11, 0xad,
      0xb8, 0xb4, 0x79, 0x87, 0x75, 0x49, 0x84, 0x69, 0x5c, 0xac, 0x0e, 0x8f,
      0x14, 0xb3, 0x36, 0x08, 0x28, 0xa2, 0x2f, 0xfa, 0x27, 0x11, 0x0a, 0x3d,
      0x62, 0xa9, 0x93, 0x45, 0x34, 0x09, 0xa0, 0xfe, 0x69, 0x6c, 0x46, 0x58,
      0xf8, 0x4b, 0xdd, 0x20, 0x81, 0x9c, 0x37, 0x09, 0xa0, 0x10, 0x57, 0xb1,
      0x95, 0xad, 0xcd, 0x00, 0x23, 0x3d, 0xba, 0x54, 0x84, 0xb6, 0x29, 0x1f,
      0x9d, 0x64, 0x8e, 0xf8, 0x83, 0x44, 0x86, 0x77, 0x97, 0x9c, 0xec, 0x04,
      0xb4, 0x34, 0xa6, 0xac, 0x2e, 0x75, 0xe9, 0x98, 0x5d, 0xe2, 0x3d, 0xb0,
      0x29, 0x2f, 0xc1, 0x11, 0x8c, 0x9f, 0xfa, 0x9d, 0x81, 0x81, 0xe7, 0x33,
      0x8d, 0xb7, 0x92, 0xb7, 0x30, 0xd7, 0xb9, 0xe3, 0x49, 0x59, 0x2f, 0x68,
      0x09, 0x98, 0x72, 0x15, 0x39, 0x15, 0xea, 0x3d, 0x6b, 0x8b, 0x46, 0x53,
      0xc6, 0x33, 0x45, 0x8f, 0x80, 0x3b, 0x32, 0xa4, 0xc2, 0xe0, 0xf2, 0x72,
      0x90, 0x25, 0x6e, 0x4e, 0x3f, 0x8a, 0x3b, 0x08, 0x38, 0xa1, 0xc4, 0x50,
      0xe4, 0xe1, 0x8c, 0x1a, 0x29, 0xa3, 0x7d, 0xdf, 0x5e, 0xa1, 0x43, 0xde,
      0x4b, 0x66, 0xff, 0x04, 0x90, 0x3e, 0xd5, 0xcf, 0x16, 0x23, 0xe1, 0x58,
      0xd4, 0x87, 0xc6, 0x08, 0xe9, 0x7f, 0x21, 0x1c, 0xd8, 0x1d, 0xca, 0x23,
      0xcb, 0x6e, 0x38, 0x07, 0x65, 0xf8, 0x22, 0xe3, 0x42, 0xbe, 0x48, 0x4c,
      0x05, 0x76, 0x39, 0x39, 0x60, 0x1c, 0xd6, 0x67},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 522
    {SEC_OID_SHA224,
     522,
     {0x30, 0x24, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85,
      0x78, 0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7,
      0x85, 0xef, 0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc,
      0xd5, 0x69, 0x5c, 0x09, 0x03, 0x80, 0xfe, 0x01},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 523
    {SEC_OID_SHA224,
     523,
     {0x30, 0x22, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7,
      0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2,
      0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5c, 0x09, 0x01, 0x42},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 524
    {SEC_OID_SHA224,
     524,
     {0x30, 0x3e, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78,
      0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef,
      0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5d,
      0x02, 0x1d, 0xff, 0x45, 0x09, 0x69, 0x59, 0x7a, 0x87, 0x08, 0x20,
      0x21, 0x18, 0x05, 0x98, 0x36, 0x88, 0x38, 0x7a, 0x10, 0xcd, 0x4d,
      0xcc, 0x45, 0x1a, 0x7f, 0x3f, 0x43, 0x2a, 0x96, 0xa3},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 525
    {SEC_OID_SHA224,
     525,
     {0x30, 0x22, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7,
      0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2,
      0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5d, 0x02, 0x01, 0x00},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 526
    {SEC_OID_SHA224,
     526,
     {0x30, 0x22, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7,
      0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2,
      0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5d, 0x02, 0x01, 0x01},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 527
    {SEC_OID_SHA224,
     527,
     {0x30, 0x22, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7,
      0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2,
      0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5d, 0x02, 0x01, 0xff},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 528
    {SEC_OID_SHA224,
     528,
     {0x30, 0x3d, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78,
      0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef,
      0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5d,
      0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b, 0xef, 0xef,
      0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99, 0x59, 0x19,
      0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xae},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 529
    {SEC_OID_SHA224,
     529,
     {0x30, 0x3d, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78,
      0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef,
      0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5d,
      0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b, 0xef, 0xef,
      0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99, 0x59, 0x19,
      0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xaf},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 530
    {SEC_OID_SHA224,
     530,
     {0x30, 0x3e, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78,
      0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef,
      0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5d,
      0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7, 0xdf,
      0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2,
      0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5c},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 531
    {SEC_OID_SHA224,
     531,
     {0x30, 0x3e, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78,
      0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef,
      0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5d,
      0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7, 0xdf,
      0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2,
      0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5d},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 532
    {SEC_OID_SHA224,
     532,
     {0x30, 0x3e, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78,
      0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef,
      0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5d,
      0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7, 0xdf,
      0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2,
      0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5e},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 533
    {SEC_OID_SHA224,
     533,
     {0x30, 0x3e, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78,
      0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef,
      0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5d,
      0x02, 0x1d, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 534
    {SEC_OID_SHA224,
     534,
     {0x30, 0x82, 0x01, 0x24, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85,
      0x78, 0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef,
      0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5d, 0x02,
      0x82, 0x01, 0x01, 0x00, 0x8f, 0x79, 0x35, 0xd9, 0xb9, 0xaa, 0xe9, 0xbf,
      0xab, 0xed, 0x88, 0x7a, 0xcf, 0x49, 0x51, 0xb6, 0xf3, 0x2e, 0xc5, 0x9e,
      0x3b, 0xaf, 0x37, 0x18, 0xe8, 0xea, 0xc4, 0x96, 0x1f, 0x3e, 0xfd, 0x36,
      0x06, 0xe7, 0x43, 0x51, 0xa9, 0xc4, 0x18, 0x33, 0x39, 0xb8, 0x09, 0xe7,
      0xc2, 0xae, 0x1c, 0x53, 0x9b, 0xa7, 0x47, 0x5b, 0x85, 0xd0, 0x11, 0xad,
      0xb8, 0xb4, 0x79, 0x87, 0x75, 0x49, 0x84, 0x69, 0x5c, 0xac, 0x0e, 0x8f,
      0x14, 0xb3, 0x36, 0x08, 0x28, 0xa2, 0x2f, 0xfa, 0x27, 0x11, 0x0a, 0x3d,
      0x62, 0xa9, 0x93, 0x45, 0x34, 0x09, 0xa0, 0xfe, 0x69, 0x6c, 0x46, 0x58,
      0xf8, 0x4b, 0xdd, 0x20, 0x81, 0x9c, 0x37, 0x09, 0xa0, 0x10, 0x57, 0xb1,
      0x95, 0xad, 0xcd, 0x00, 0x23, 0x3d, 0xba, 0x54, 0x84, 0xb6, 0x29, 0x1f,
      0x9d, 0x64, 0x8e, 0xf8, 0x83, 0x44, 0x86, 0x77, 0x97, 0x9c, 0xec, 0x04,
      0xb4, 0x34, 0xa6, 0xac, 0x2e, 0x75, 0xe9, 0x98, 0x5d, 0xe2, 0x3d, 0xb0,
      0x29, 0x2f, 0xc1, 0x11, 0x8c, 0x9f, 0xfa, 0x9d, 0x81, 0x81, 0xe7, 0x33,
      0x8d, 0xb7, 0x92, 0xb7, 0x30, 0xd7, 0xb9, 0xe3, 0x49, 0x59, 0x2f, 0x68,
      0x09, 0x98, 0x72, 0x15, 0x39, 0x15, 0xea, 0x3d, 0x6b, 0x8b, 0x46, 0x53,
      0xc6, 0x33, 0x45, 0x8f, 0x80, 0x3b, 0x32, 0xa4, 0xc2, 0xe0, 0xf2, 0x72,
      0x90, 0x25, 0x6e, 0x4e, 0x3f, 0x8a, 0x3b, 0x08, 0x38, 0xa1, 0xc4, 0x50,
      0xe4, 0xe1, 0x8c, 0x1a, 0x29, 0xa3, 0x7d, 0xdf, 0x5e, 0xa1, 0x43, 0xde,
      0x4b, 0x66, 0xff, 0x04, 0x90, 0x3e, 0xd5, 0xcf, 0x16, 0x23, 0xe1, 0x58,
      0xd4, 0x87, 0xc6, 0x08, 0xe9, 0x7f, 0x21, 0x1c, 0xd8, 0x1d, 0xca, 0x23,
      0xcb, 0x6e, 0x38, 0x07, 0x65, 0xf8, 0x22, 0xe3, 0x42, 0xbe, 0x48, 0x4c,
      0x05, 0x76, 0x39, 0x39, 0x60, 0x1c, 0xd6, 0x67},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 535
    {SEC_OID_SHA224,
     535,
     {0x30, 0x24, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85,
      0x78, 0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7,
      0x85, 0xef, 0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc,
      0xd5, 0x69, 0x5d, 0x09, 0x03, 0x80, 0xfe, 0x01},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 536
    {SEC_OID_SHA224,
     536,
     {0x30, 0x22, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7,
      0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2,
      0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5d, 0x09, 0x01, 0x42},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 537
    {SEC_OID_SHA224,
     537,
     {0x30, 0x3e, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78,
      0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef,
      0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5e,
      0x02, 0x1d, 0xff, 0x45, 0x09, 0x69, 0x59, 0x7a, 0x87, 0x08, 0x20,
      0x21, 0x18, 0x05, 0x98, 0x36, 0x88, 0x38, 0x7a, 0x10, 0xcd, 0x4d,
      0xcc, 0x45, 0x1a, 0x7f, 0x3f, 0x43, 0x2a, 0x96, 0xa3},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 538
    {SEC_OID_SHA224,
     538,
     {0x30, 0x22, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7,
      0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2,
      0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5e, 0x02, 0x01, 0x00},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 539
    {SEC_OID_SHA224,
     539,
     {0x30, 0x22, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7,
      0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2,
      0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5e, 0x02, 0x01, 0x01},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 540
    {SEC_OID_SHA224,
     540,
     {0x30, 0x22, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7,
      0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2,
      0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5e, 0x02, 0x01, 0xff},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 541
    {SEC_OID_SHA224,
     541,
     {0x30, 0x3d, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78,
      0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef,
      0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5e,
      0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b, 0xef, 0xef,
      0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99, 0x59, 0x19,
      0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xae},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 542
    {SEC_OID_SHA224,
     542,
     {0x30, 0x3d, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78,
      0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef,
      0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5e,
      0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b, 0xef, 0xef,
      0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99, 0x59, 0x19,
      0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xaf},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 543
    {SEC_OID_SHA224,
     543,
     {0x30, 0x3e, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78,
      0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef,
      0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5e,
      0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7, 0xdf,
      0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2,
      0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5c},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 544
    {SEC_OID_SHA224,
     544,
     {0x30, 0x3e, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78,
      0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef,
      0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5e,
      0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7, 0xdf,
      0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2,
      0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5d},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 545
    {SEC_OID_SHA224,
     545,
     {0x30, 0x3e, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78,
      0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef,
      0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5e,
      0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7, 0xdf,
      0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2,
      0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5e},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 546
    {SEC_OID_SHA224,
     546,
     {0x30, 0x3e, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78,
      0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef,
      0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5e,
      0x02, 0x1d, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 547
    {SEC_OID_SHA224,
     547,
     {0x30, 0x82, 0x01, 0x24, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85,
      0x78, 0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef,
      0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5e, 0x02,
      0x82, 0x01, 0x01, 0x00, 0x8f, 0x79, 0x35, 0xd9, 0xb9, 0xaa, 0xe9, 0xbf,
      0xab, 0xed, 0x88, 0x7a, 0xcf, 0x49, 0x51, 0xb6, 0xf3, 0x2e, 0xc5, 0x9e,
      0x3b, 0xaf, 0x37, 0x18, 0xe8, 0xea, 0xc4, 0x96, 0x1f, 0x3e, 0xfd, 0x36,
      0x06, 0xe7, 0x43, 0x51, 0xa9, 0xc4, 0x18, 0x33, 0x39, 0xb8, 0x09, 0xe7,
      0xc2, 0xae, 0x1c, 0x53, 0x9b, 0xa7, 0x47, 0x5b, 0x85, 0xd0, 0x11, 0xad,
      0xb8, 0xb4, 0x79, 0x87, 0x75, 0x49, 0x84, 0x69, 0x5c, 0xac, 0x0e, 0x8f,
      0x14, 0xb3, 0x36, 0x08, 0x28, 0xa2, 0x2f, 0xfa, 0x27, 0x11, 0x0a, 0x3d,
      0x62, 0xa9, 0x93, 0x45, 0x34, 0x09, 0xa0, 0xfe, 0x69, 0x6c, 0x46, 0x58,
      0xf8, 0x4b, 0xdd, 0x20, 0x81, 0x9c, 0x37, 0x09, 0xa0, 0x10, 0x57, 0xb1,
      0x95, 0xad, 0xcd, 0x00, 0x23, 0x3d, 0xba, 0x54, 0x84, 0xb6, 0x29, 0x1f,
      0x9d, 0x64, 0x8e, 0xf8, 0x83, 0x44, 0x86, 0x77, 0x97, 0x9c, 0xec, 0x04,
      0xb4, 0x34, 0xa6, 0xac, 0x2e, 0x75, 0xe9, 0x98, 0x5d, 0xe2, 0x3d, 0xb0,
      0x29, 0x2f, 0xc1, 0x11, 0x8c, 0x9f, 0xfa, 0x9d, 0x81, 0x81, 0xe7, 0x33,
      0x8d, 0xb7, 0x92, 0xb7, 0x30, 0xd7, 0xb9, 0xe3, 0x49, 0x59, 0x2f, 0x68,
      0x09, 0x98, 0x72, 0x15, 0x39, 0x15, 0xea, 0x3d, 0x6b, 0x8b, 0x46, 0x53,
      0xc6, 0x33, 0x45, 0x8f, 0x80, 0x3b, 0x32, 0xa4, 0xc2, 0xe0, 0xf2, 0x72,
      0x90, 0x25, 0x6e, 0x4e, 0x3f, 0x8a, 0x3b, 0x08, 0x38, 0xa1, 0xc4, 0x50,
      0xe4, 0xe1, 0x8c, 0x1a, 0x29, 0xa3, 0x7d, 0xdf, 0x5e, 0xa1, 0x43, 0xde,
      0x4b, 0x66, 0xff, 0x04, 0x90, 0x3e, 0xd5, 0xcf, 0x16, 0x23, 0xe1, 0x58,
      0xd4, 0x87, 0xc6, 0x08, 0xe9, 0x7f, 0x21, 0x1c, 0xd8, 0x1d, 0xca, 0x23,
      0xcb, 0x6e, 0x38, 0x07, 0x65, 0xf8, 0x22, 0xe3, 0x42, 0xbe, 0x48, 0x4c,
      0x05, 0x76, 0x39, 0x39, 0x60, 0x1c, 0xd6, 0x67},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 548
    {SEC_OID_SHA224,
     548,
     {0x30, 0x24, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85,
      0x78, 0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7,
      0x85, 0xef, 0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc,
      0xd5, 0x69, 0x5e, 0x09, 0x03, 0x80, 0xfe, 0x01},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 549
    {SEC_OID_SHA224,
     549,
     {0x30, 0x22, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7,
      0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2,
      0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5e, 0x09, 0x01, 0x42},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 550
    {SEC_OID_SHA224,
     550,
     {0x30, 0x3e, 0x02, 0x1d, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x02, 0x1d, 0xff, 0x45, 0x09, 0x69, 0x59, 0x7a, 0x87, 0x08, 0x20,
      0x21, 0x18, 0x05, 0x98, 0x36, 0x88, 0x38, 0x7a, 0x10, 0xcd, 0x4d,
      0xcc, 0x45, 0x1a, 0x7f, 0x3f, 0x43, 0x2a, 0x96, 0xa3},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 551
    {SEC_OID_SHA224,
     551,
     {0x30, 0x22, 0x02, 0x1d, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x01, 0x00},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 552
    {SEC_OID_SHA224,
     552,
     {0x30, 0x22, 0x02, 0x1d, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x01, 0x01},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 553
    {SEC_OID_SHA224,
     553,
     {0x30, 0x22, 0x02, 0x1d, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x01, 0xff},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 554
    {SEC_OID_SHA224,
     554,
     {0x30, 0x3d, 0x02, 0x1d, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b, 0xef, 0xef,
      0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99, 0x59, 0x19,
      0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xae},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 555
    {SEC_OID_SHA224,
     555,
     {0x30, 0x3d, 0x02, 0x1d, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b, 0xef, 0xef,
      0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99, 0x59, 0x19,
      0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xaf},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 556
    {SEC_OID_SHA224,
     556,
     {0x30, 0x3e, 0x02, 0x1d, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7, 0xdf,
      0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2,
      0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5c},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 557
    {SEC_OID_SHA224,
     557,
     {0x30, 0x3e, 0x02, 0x1d, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7, 0xdf,
      0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2,
      0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5d},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 558
    {SEC_OID_SHA224,
     558,
     {0x30, 0x3e, 0x02, 0x1d, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7, 0xdf,
      0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2,
      0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5e},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 559
    {SEC_OID_SHA224,
     559,
     {0x30, 0x3e, 0x02, 0x1d, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x02, 0x1d, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 560
    {SEC_OID_SHA224,
     560,
     {0x30, 0x82, 0x01, 0x24, 0x02, 0x1d, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02,
      0x82, 0x01, 0x01, 0x00, 0x8f, 0x79, 0x35, 0xd9, 0xb9, 0xaa, 0xe9, 0xbf,
      0xab, 0xed, 0x88, 0x7a, 0xcf, 0x49, 0x51, 0xb6, 0xf3, 0x2e, 0xc5, 0x9e,
      0x3b, 0xaf, 0x37, 0x18, 0xe8, 0xea, 0xc4, 0x96, 0x1f, 0x3e, 0xfd, 0x36,
      0x06, 0xe7, 0x43, 0x51, 0xa9, 0xc4, 0x18, 0x33, 0x39, 0xb8, 0x09, 0xe7,
      0xc2, 0xae, 0x1c, 0x53, 0x9b, 0xa7, 0x47, 0x5b, 0x85, 0xd0, 0x11, 0xad,
      0xb8, 0xb4, 0x79, 0x87, 0x75, 0x49, 0x84, 0x69, 0x5c, 0xac, 0x0e, 0x8f,
      0x14, 0xb3, 0x36, 0x08, 0x28, 0xa2, 0x2f, 0xfa, 0x27, 0x11, 0x0a, 0x3d,
      0x62, 0xa9, 0x93, 0x45, 0x34, 0x09, 0xa0, 0xfe, 0x69, 0x6c, 0x46, 0x58,
      0xf8, 0x4b, 0xdd, 0x20, 0x81, 0x9c, 0x37, 0x09, 0xa0, 0x10, 0x57, 0xb1,
      0x95, 0xad, 0xcd, 0x00, 0x23, 0x3d, 0xba, 0x54, 0x84, 0xb6, 0x29, 0x1f,
      0x9d, 0x64, 0x8e, 0xf8, 0x83, 0x44, 0x86, 0x77, 0x97, 0x9c, 0xec, 0x04,
      0xb4, 0x34, 0xa6, 0xac, 0x2e, 0x75, 0xe9, 0x98, 0x5d, 0xe2, 0x3d, 0xb0,
      0x29, 0x2f, 0xc1, 0x11, 0x8c, 0x9f, 0xfa, 0x9d, 0x81, 0x81, 0xe7, 0x33,
      0x8d, 0xb7, 0x92, 0xb7, 0x30, 0xd7, 0xb9, 0xe3, 0x49, 0x59, 0x2f, 0x68,
      0x09, 0x98, 0x72, 0x15, 0x39, 0x15, 0xea, 0x3d, 0x6b, 0x8b, 0x46, 0x53,
      0xc6, 0x33, 0x45, 0x8f, 0x80, 0x3b, 0x32, 0xa4, 0xc2, 0xe0, 0xf2, 0x72,
      0x90, 0x25, 0x6e, 0x4e, 0x3f, 0x8a, 0x3b, 0x08, 0x38, 0xa1, 0xc4, 0x50,
      0xe4, 0xe1, 0x8c, 0x1a, 0x29, 0xa3, 0x7d, 0xdf, 0x5e, 0xa1, 0x43, 0xde,
      0x4b, 0x66, 0xff, 0x04, 0x90, 0x3e, 0xd5, 0xcf, 0x16, 0x23, 0xe1, 0x58,
      0xd4, 0x87, 0xc6, 0x08, 0xe9, 0x7f, 0x21, 0x1c, 0xd8, 0x1d, 0xca, 0x23,
      0xcb, 0x6e, 0x38, 0x07, 0x65, 0xf8, 0x22, 0xe3, 0x42, 0xbe, 0x48, 0x4c,
      0x05, 0x76, 0x39, 0x39, 0x60, 0x1c, 0xd6, 0x67},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 561
    {SEC_OID_SHA224,
     561,
     {0x30, 0x24, 0x02, 0x1d, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x09, 0x03, 0x80, 0xfe, 0x01},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 562
    {SEC_OID_SHA224,
     562,
     {0x30, 0x22, 0x02, 0x1d, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x01, 0x42},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 563
    {SEC_OID_SHA224,
     563,
     {0x30, 0x82, 0x01, 0x24, 0x02, 0x82, 0x01, 0x01, 0x00, 0x8f, 0x79, 0x35,
      0xd9, 0xb9, 0xaa, 0xe9, 0xbf, 0xab, 0xed, 0x88, 0x7a, 0xcf, 0x49, 0x51,
      0xb6, 0xf3, 0x2e, 0xc5, 0x9e, 0x3b, 0xaf, 0x37, 0x18, 0xe8, 0xea, 0xc4,
      0x96, 0x1f, 0x3e, 0xfd, 0x36, 0x06, 0xe7, 0x43, 0x51, 0xa9, 0xc4, 0x18,
      0x33, 0x39, 0xb8, 0x09, 0xe7, 0xc2, 0xae, 0x1c, 0x53, 0x9b, 0xa7, 0x47,
      0x5b, 0x85, 0xd0, 0x11, 0xad, 0xb8, 0xb4, 0x79, 0x87, 0x75, 0x49, 0x84,
      0x69, 0x5c, 0xac, 0x0e, 0x8f, 0x14, 0xb3, 0x36, 0x08, 0x28, 0xa2, 0x2f,
      0xfa, 0x27, 0x11, 0x0a, 0x3d, 0x62, 0xa9, 0x93, 0x45, 0x34, 0x09, 0xa0,
      0xfe, 0x69, 0x6c, 0x46, 0x58, 0xf8, 0x4b, 0xdd, 0x20, 0x81, 0x9c, 0x37,
      0x09, 0xa0, 0x10, 0x57, 0xb1, 0x95, 0xad, 0xcd, 0x00, 0x23, 0x3d, 0xba,
      0x54, 0x84, 0xb6, 0x29, 0x1f, 0x9d, 0x64, 0x8e, 0xf8, 0x83, 0x44, 0x86,
      0x77, 0x97, 0x9c, 0xec, 0x04, 0xb4, 0x34, 0xa6, 0xac, 0x2e, 0x75, 0xe9,
      0x98, 0x5d, 0xe2, 0x3d, 0xb0, 0x29, 0x2f, 0xc1, 0x11, 0x8c, 0x9f, 0xfa,
      0x9d, 0x81, 0x81, 0xe7, 0x33, 0x8d, 0xb7, 0x92, 0xb7, 0x30, 0xd7, 0xb9,
      0xe3, 0x49, 0x59, 0x2f, 0x68, 0x09, 0x98, 0x72, 0x15, 0x39, 0x15, 0xea,
      0x3d, 0x6b, 0x8b, 0x46, 0x53, 0xc6, 0x33, 0x45, 0x8f, 0x80, 0x3b, 0x32,
      0xa4, 0xc2, 0xe0, 0xf2, 0x72, 0x90, 0x25, 0x6e, 0x4e, 0x3f, 0x8a, 0x3b,
      0x08, 0x38, 0xa1, 0xc4, 0x50, 0xe4, 0xe1, 0x8c, 0x1a, 0x29, 0xa3, 0x7d,
      0xdf, 0x5e, 0xa1, 0x43, 0xde, 0x4b, 0x66, 0xff, 0x04, 0x90, 0x3e, 0xd5,
      0xcf, 0x16, 0x23, 0xe1, 0x58, 0xd4, 0x87, 0xc6, 0x08, 0xe9, 0x7f, 0x21,
      0x1c, 0xd8, 0x1d, 0xca, 0x23, 0xcb, 0x6e, 0x38, 0x07, 0x65, 0xf8, 0x22,
      0xe3, 0x42, 0xbe, 0x48, 0x4c, 0x05, 0x76, 0x39, 0x39, 0x60, 0x1c, 0xd6,
      0x67, 0x02, 0x1d, 0xff, 0x45, 0x09, 0x69, 0x59, 0x7a, 0x87, 0x08, 0x20,
      0x21, 0x18, 0x05, 0x98, 0x36, 0x88, 0x38, 0x7a, 0x10, 0xcd, 0x4d, 0xcc,
      0x45, 0x1a, 0x7f, 0x3f, 0x43, 0x2a, 0x96, 0xa3},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 564
    {SEC_OID_SHA224,
     564,
     {0x30, 0x82, 0x01, 0x08, 0x02, 0x82, 0x01, 0x01, 0x00, 0x8f, 0x79, 0x35,
      0xd9, 0xb9, 0xaa, 0xe9, 0xbf, 0xab, 0xed, 0x88, 0x7a, 0xcf, 0x49, 0x51,
      0xb6, 0xf3, 0x2e, 0xc5, 0x9e, 0x3b, 0xaf, 0x37, 0x18, 0xe8, 0xea, 0xc4,
      0x96, 0x1f, 0x3e, 0xfd, 0x36, 0x06, 0xe7, 0x43, 0x51, 0xa9, 0xc4, 0x18,
      0x33, 0x39, 0xb8, 0x09, 0xe7, 0xc2, 0xae, 0x1c, 0x53, 0x9b, 0xa7, 0x47,
      0x5b, 0x85, 0xd0, 0x11, 0xad, 0xb8, 0xb4, 0x79, 0x87, 0x75, 0x49, 0x84,
      0x69, 0x5c, 0xac, 0x0e, 0x8f, 0x14, 0xb3, 0x36, 0x08, 0x28, 0xa2, 0x2f,
      0xfa, 0x27, 0x11, 0x0a, 0x3d, 0x62, 0xa9, 0x93, 0x45, 0x34, 0x09, 0xa0,
      0xfe, 0x69, 0x6c, 0x46, 0x58, 0xf8, 0x4b, 0xdd, 0x20, 0x81, 0x9c, 0x37,
      0x09, 0xa0, 0x10, 0x57, 0xb1, 0x95, 0xad, 0xcd, 0x00, 0x23, 0x3d, 0xba,
      0x54, 0x84, 0xb6, 0x29, 0x1f, 0x9d, 0x64, 0x8e, 0xf8, 0x83, 0x44, 0x86,
      0x77, 0x97, 0x9c, 0xec, 0x04, 0xb4, 0x34, 0xa6, 0xac, 0x2e, 0x75, 0xe9,
      0x98, 0x5d, 0xe2, 0x3d, 0xb0, 0x29, 0x2f, 0xc1, 0x11, 0x8c, 0x9f, 0xfa,
      0x9d, 0x81, 0x81, 0xe7, 0x33, 0x8d, 0xb7, 0x92, 0xb7, 0x30, 0xd7, 0xb9,
      0xe3, 0x49, 0x59, 0x2f, 0x68, 0x09, 0x98, 0x72, 0x15, 0x39, 0x15, 0xea,
      0x3d, 0x6b, 0x8b, 0x46, 0x53, 0xc6, 0x33, 0x45, 0x8f, 0x80, 0x3b, 0x32,
      0xa4, 0xc2, 0xe0, 0xf2, 0x72, 0x90, 0x25, 0x6e, 0x4e, 0x3f, 0x8a, 0x3b,
      0x08, 0x38, 0xa1, 0xc4, 0x50, 0xe4, 0xe1, 0x8c, 0x1a, 0x29, 0xa3, 0x7d,
      0xdf, 0x5e, 0xa1, 0x43, 0xde, 0x4b, 0x66, 0xff, 0x04, 0x90, 0x3e, 0xd5,
      0xcf, 0x16, 0x23, 0xe1, 0x58, 0xd4, 0x87, 0xc6, 0x08, 0xe9, 0x7f, 0x21,
      0x1c, 0xd8, 0x1d, 0xca, 0x23, 0xcb, 0x6e, 0x38, 0x07, 0x65, 0xf8, 0x22,
      0xe3, 0x42, 0xbe, 0x48, 0x4c, 0x05, 0x76, 0x39, 0x39, 0x60, 0x1c, 0xd6,
      0x67, 0x02, 0x01, 0x00},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 565
    {SEC_OID_SHA224,
     565,
     {0x30, 0x82, 0x01, 0x08, 0x02, 0x82, 0x01, 0x01, 0x00, 0x8f, 0x79, 0x35,
      0xd9, 0xb9, 0xaa, 0xe9, 0xbf, 0xab, 0xed, 0x88, 0x7a, 0xcf, 0x49, 0x51,
      0xb6, 0xf3, 0x2e, 0xc5, 0x9e, 0x3b, 0xaf, 0x37, 0x18, 0xe8, 0xea, 0xc4,
      0x96, 0x1f, 0x3e, 0xfd, 0x36, 0x06, 0xe7, 0x43, 0x51, 0xa9, 0xc4, 0x18,
      0x33, 0x39, 0xb8, 0x09, 0xe7, 0xc2, 0xae, 0x1c, 0x53, 0x9b, 0xa7, 0x47,
      0x5b, 0x85, 0xd0, 0x11, 0xad, 0xb8, 0xb4, 0x79, 0x87, 0x75, 0x49, 0x84,
      0x69, 0x5c, 0xac, 0x0e, 0x8f, 0x14, 0xb3, 0x36, 0x08, 0x28, 0xa2, 0x2f,
      0xfa, 0x27, 0x11, 0x0a, 0x3d, 0x62, 0xa9, 0x93, 0x45, 0x34, 0x09, 0xa0,
      0xfe, 0x69, 0x6c, 0x46, 0x58, 0xf8, 0x4b, 0xdd, 0x20, 0x81, 0x9c, 0x37,
      0x09, 0xa0, 0x10, 0x57, 0xb1, 0x95, 0xad, 0xcd, 0x00, 0x23, 0x3d, 0xba,
      0x54, 0x84, 0xb6, 0x29, 0x1f, 0x9d, 0x64, 0x8e, 0xf8, 0x83, 0x44, 0x86,
      0x77, 0x97, 0x9c, 0xec, 0x04, 0xb4, 0x34, 0xa6, 0xac, 0x2e, 0x75, 0xe9,
      0x98, 0x5d, 0xe2, 0x3d, 0xb0, 0x29, 0x2f, 0xc1, 0x11, 0x8c, 0x9f, 0xfa,
      0x9d, 0x81, 0x81, 0xe7, 0x33, 0x8d, 0xb7, 0x92, 0xb7, 0x30, 0xd7, 0xb9,
      0xe3, 0x49, 0x59, 0x2f, 0x68, 0x09, 0x98, 0x72, 0x15, 0x39, 0x15, 0xea,
      0x3d, 0x6b, 0x8b, 0x46, 0x53, 0xc6, 0x33, 0x45, 0x8f, 0x80, 0x3b, 0x32,
      0xa4, 0xc2, 0xe0, 0xf2, 0x72, 0x90, 0x25, 0x6e, 0x4e, 0x3f, 0x8a, 0x3b,
      0x08, 0x38, 0xa1, 0xc4, 0x50, 0xe4, 0xe1, 0x8c, 0x1a, 0x29, 0xa3, 0x7d,
      0xdf, 0x5e, 0xa1, 0x43, 0xde, 0x4b, 0x66, 0xff, 0x04, 0x90, 0x3e, 0xd5,
      0xcf, 0x16, 0x23, 0xe1, 0x58, 0xd4, 0x87, 0xc6, 0x08, 0xe9, 0x7f, 0x21,
      0x1c, 0xd8, 0x1d, 0xca, 0x23, 0xcb, 0x6e, 0x38, 0x07, 0x65, 0xf8, 0x22,
      0xe3, 0x42, 0xbe, 0x48, 0x4c, 0x05, 0x76, 0x39, 0x39, 0x60, 0x1c, 0xd6,
      0x67, 0x02, 0x01, 0x01},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 566
    {SEC_OID_SHA224,
     566,
     {0x30, 0x82, 0x01, 0x08, 0x02, 0x82, 0x01, 0x01, 0x00, 0x8f, 0x79, 0x35,
      0xd9, 0xb9, 0xaa, 0xe9, 0xbf, 0xab, 0xed, 0x88, 0x7a, 0xcf, 0x49, 0x51,
      0xb6, 0xf3, 0x2e, 0xc5, 0x9e, 0x3b, 0xaf, 0x37, 0x18, 0xe8, 0xea, 0xc4,
      0x96, 0x1f, 0x3e, 0xfd, 0x36, 0x06, 0xe7, 0x43, 0x51, 0xa9, 0xc4, 0x18,
      0x33, 0x39, 0xb8, 0x09, 0xe7, 0xc2, 0xae, 0x1c, 0x53, 0x9b, 0xa7, 0x47,
      0x5b, 0x85, 0xd0, 0x11, 0xad, 0xb8, 0xb4, 0x79, 0x87, 0x75, 0x49, 0x84,
      0x69, 0x5c, 0xac, 0x0e, 0x8f, 0x14, 0xb3, 0x36, 0x08, 0x28, 0xa2, 0x2f,
      0xfa, 0x27, 0x11, 0x0a, 0x3d, 0x62, 0xa9, 0x93, 0x45, 0x34, 0x09, 0xa0,
      0xfe, 0x69, 0x6c, 0x46, 0x58, 0xf8, 0x4b, 0xdd, 0x20, 0x81, 0x9c, 0x37,
      0x09, 0xa0, 0x10, 0x57, 0xb1, 0x95, 0xad, 0xcd, 0x00, 0x23, 0x3d, 0xba,
      0x54, 0x84, 0xb6, 0x29, 0x1f, 0x9d, 0x64, 0x8e, 0xf8, 0x83, 0x44, 0x86,
      0x77, 0x97, 0x9c, 0xec, 0x04, 0xb4, 0x34, 0xa6, 0xac, 0x2e, 0x75, 0xe9,
      0x98, 0x5d, 0xe2, 0x3d, 0xb0, 0x29, 0x2f, 0xc1, 0x11, 0x8c, 0x9f, 0xfa,
      0x9d, 0x81, 0x81, 0xe7, 0x33, 0x8d, 0xb7, 0x92, 0xb7, 0x30, 0xd7, 0xb9,
      0xe3, 0x49, 0x59, 0x2f, 0x68, 0x09, 0x98, 0x72, 0x15, 0x39, 0x15, 0xea,
      0x3d, 0x6b, 0x8b, 0x46, 0x53, 0xc6, 0x33, 0x45, 0x8f, 0x80, 0x3b, 0x32,
      0xa4, 0xc2, 0xe0, 0xf2, 0x72, 0x90, 0x25, 0x6e, 0x4e, 0x3f, 0x8a, 0x3b,
      0x08, 0x38, 0xa1, 0xc4, 0x50, 0xe4, 0xe1, 0x8c, 0x1a, 0x29, 0xa3, 0x7d,
      0xdf, 0x5e, 0xa1, 0x43, 0xde, 0x4b, 0x66, 0xff, 0x04, 0x90, 0x3e, 0xd5,
      0xcf, 0x16, 0x23, 0xe1, 0x58, 0xd4, 0x87, 0xc6, 0x08, 0xe9, 0x7f, 0x21,
      0x1c, 0xd8, 0x1d, 0xca, 0x23, 0xcb, 0x6e, 0x38, 0x07, 0x65, 0xf8, 0x22,
      0xe3, 0x42, 0xbe, 0x48, 0x4c, 0x05, 0x76, 0x39, 0x39, 0x60, 0x1c, 0xd6,
      0x67, 0x02, 0x01, 0xff},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 567
    {SEC_OID_SHA224,
     567,
     {0x30, 0x82, 0x01, 0x23, 0x02, 0x82, 0x01, 0x01, 0x00, 0x8f, 0x79, 0x35,
      0xd9, 0xb9, 0xaa, 0xe9, 0xbf, 0xab, 0xed, 0x88, 0x7a, 0xcf, 0x49, 0x51,
      0xb6, 0xf3, 0x2e, 0xc5, 0x9e, 0x3b, 0xaf, 0x37, 0x18, 0xe8, 0xea, 0xc4,
      0x96, 0x1f, 0x3e, 0xfd, 0x36, 0x06, 0xe7, 0x43, 0x51, 0xa9, 0xc4, 0x18,
      0x33, 0x39, 0xb8, 0x09, 0xe7, 0xc2, 0xae, 0x1c, 0x53, 0x9b, 0xa7, 0x47,
      0x5b, 0x85, 0xd0, 0x11, 0xad, 0xb8, 0xb4, 0x79, 0x87, 0x75, 0x49, 0x84,
      0x69, 0x5c, 0xac, 0x0e, 0x8f, 0x14, 0xb3, 0x36, 0x08, 0x28, 0xa2, 0x2f,
      0xfa, 0x27, 0x11, 0x0a, 0x3d, 0x62, 0xa9, 0x93, 0x45, 0x34, 0x09, 0xa0,
      0xfe, 0x69, 0x6c, 0x46, 0x58, 0xf8, 0x4b, 0xdd, 0x20, 0x81, 0x9c, 0x37,
      0x09, 0xa0, 0x10, 0x57, 0xb1, 0x95, 0xad, 0xcd, 0x00, 0x23, 0x3d, 0xba,
      0x54, 0x84, 0xb6, 0x29, 0x1f, 0x9d, 0x64, 0x8e, 0xf8, 0x83, 0x44, 0x86,
      0x77, 0x97, 0x9c, 0xec, 0x04, 0xb4, 0x34, 0xa6, 0xac, 0x2e, 0x75, 0xe9,
      0x98, 0x5d, 0xe2, 0x3d, 0xb0, 0x29, 0x2f, 0xc1, 0x11, 0x8c, 0x9f, 0xfa,
      0x9d, 0x81, 0x81, 0xe7, 0x33, 0x8d, 0xb7, 0x92, 0xb7, 0x30, 0xd7, 0xb9,
      0xe3, 0x49, 0x59, 0x2f, 0x68, 0x09, 0x98, 0x72, 0x15, 0x39, 0x15, 0xea,
      0x3d, 0x6b, 0x8b, 0x46, 0x53, 0xc6, 0x33, 0x45, 0x8f, 0x80, 0x3b, 0x32,
      0xa4, 0xc2, 0xe0, 0xf2, 0x72, 0x90, 0x25, 0x6e, 0x4e, 0x3f, 0x8a, 0x3b,
      0x08, 0x38, 0xa1, 0xc4, 0x50, 0xe4, 0xe1, 0x8c, 0x1a, 0x29, 0xa3, 0x7d,
      0xdf, 0x5e, 0xa1, 0x43, 0xde, 0x4b, 0x66, 0xff, 0x04, 0x90, 0x3e, 0xd5,
      0xcf, 0x16, 0x23, 0xe1, 0x58, 0xd4, 0x87, 0xc6, 0x08, 0xe9, 0x7f, 0x21,
      0x1c, 0xd8, 0x1d, 0xca, 0x23, 0xcb, 0x6e, 0x38, 0x07, 0x65, 0xf8, 0x22,
      0xe3, 0x42, 0xbe, 0x48, 0x4c, 0x05, 0x76, 0x39, 0x39, 0x60, 0x1c, 0xd6,
      0x67, 0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b, 0xef, 0xef,
      0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99, 0x59, 0x19, 0xdd,
      0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xae},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 568
    {SEC_OID_SHA224,
     568,
     {0x30, 0x82, 0x01, 0x23, 0x02, 0x82, 0x01, 0x01, 0x00, 0x8f, 0x79, 0x35,
      0xd9, 0xb9, 0xaa, 0xe9, 0xbf, 0xab, 0xed, 0x88, 0x7a, 0xcf, 0x49, 0x51,
      0xb6, 0xf3, 0x2e, 0xc5, 0x9e, 0x3b, 0xaf, 0x37, 0x18, 0xe8, 0xea, 0xc4,
      0x96, 0x1f, 0x3e, 0xfd, 0x36, 0x06, 0xe7, 0x43, 0x51, 0xa9, 0xc4, 0x18,
      0x33, 0x39, 0xb8, 0x09, 0xe7, 0xc2, 0xae, 0x1c, 0x53, 0x9b, 0xa7, 0x47,
      0x5b, 0x85, 0xd0, 0x11, 0xad, 0xb8, 0xb4, 0x79, 0x87, 0x75, 0x49, 0x84,
      0x69, 0x5c, 0xac, 0x0e, 0x8f, 0x14, 0xb3, 0x36, 0x08, 0x28, 0xa2, 0x2f,
      0xfa, 0x27, 0x11, 0x0a, 0x3d, 0x62, 0xa9, 0x93, 0x45, 0x34, 0x09, 0xa0,
      0xfe, 0x69, 0x6c, 0x46, 0x58, 0xf8, 0x4b, 0xdd, 0x20, 0x81, 0x9c, 0x37,
      0x09, 0xa0, 0x10, 0x57, 0xb1, 0x95, 0xad, 0xcd, 0x00, 0x23, 0x3d, 0xba,
      0x54, 0x84, 0xb6, 0x29, 0x1f, 0x9d, 0x64, 0x8e, 0xf8, 0x83, 0x44, 0x86,
      0x77, 0x97, 0x9c, 0xec, 0x04, 0xb4, 0x34, 0xa6, 0xac, 0x2e, 0x75, 0xe9,
      0x98, 0x5d, 0xe2, 0x3d, 0xb0, 0x29, 0x2f, 0xc1, 0x11, 0x8c, 0x9f, 0xfa,
      0x9d, 0x81, 0x81, 0xe7, 0x33, 0x8d, 0xb7, 0x92, 0xb7, 0x30, 0xd7, 0xb9,
      0xe3, 0x49, 0x59, 0x2f, 0x68, 0x09, 0x98, 0x72, 0x15, 0x39, 0x15, 0xea,
      0x3d, 0x6b, 0x8b, 0x46, 0x53, 0xc6, 0x33, 0x45, 0x8f, 0x80, 0x3b, 0x32,
      0xa4, 0xc2, 0xe0, 0xf2, 0x72, 0x90, 0x25, 0x6e, 0x4e, 0x3f, 0x8a, 0x3b,
      0x08, 0x38, 0xa1, 0xc4, 0x50, 0xe4, 0xe1, 0x8c, 0x1a, 0x29, 0xa3, 0x7d,
      0xdf, 0x5e, 0xa1, 0x43, 0xde, 0x4b, 0x66, 0xff, 0x04, 0x90, 0x3e, 0xd5,
      0xcf, 0x16, 0x23, 0xe1, 0x58, 0xd4, 0x87, 0xc6, 0x08, 0xe9, 0x7f, 0x21,
      0x1c, 0xd8, 0x1d, 0xca, 0x23, 0xcb, 0x6e, 0x38, 0x07, 0x65, 0xf8, 0x22,
      0xe3, 0x42, 0xbe, 0x48, 0x4c, 0x05, 0x76, 0x39, 0x39, 0x60, 0x1c, 0xd6,
      0x67, 0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b, 0xef, 0xef,
      0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99, 0x59, 0x19, 0xdd,
      0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xaf},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 569
    {SEC_OID_SHA224,
     569,
     {0x30, 0x82, 0x01, 0x24, 0x02, 0x82, 0x01, 0x01, 0x00, 0x8f, 0x79, 0x35,
      0xd9, 0xb9, 0xaa, 0xe9, 0xbf, 0xab, 0xed, 0x88, 0x7a, 0xcf, 0x49, 0x51,
      0xb6, 0xf3, 0x2e, 0xc5, 0x9e, 0x3b, 0xaf, 0x37, 0x18, 0xe8, 0xea, 0xc4,
      0x96, 0x1f, 0x3e, 0xfd, 0x36, 0x06, 0xe7, 0x43, 0x51, 0xa9, 0xc4, 0x18,
      0x33, 0x39, 0xb8, 0x09, 0xe7, 0xc2, 0xae, 0x1c, 0x53, 0x9b, 0xa7, 0x47,
      0x5b, 0x85, 0xd0, 0x11, 0xad, 0xb8, 0xb4, 0x79, 0x87, 0x75, 0x49, 0x84,
      0x69, 0x5c, 0xac, 0x0e, 0x8f, 0x14, 0xb3, 0x36, 0x08, 0x28, 0xa2, 0x2f,
      0xfa, 0x27, 0x11, 0x0a, 0x3d, 0x62, 0xa9, 0x93, 0x45, 0x34, 0x09, 0xa0,
      0xfe, 0x69, 0x6c, 0x46, 0x58, 0xf8, 0x4b, 0xdd, 0x20, 0x81, 0x9c, 0x37,
      0x09, 0xa0, 0x10, 0x57, 0xb1, 0x95, 0xad, 0xcd, 0x00, 0x23, 0x3d, 0xba,
      0x54, 0x84, 0xb6, 0x29, 0x1f, 0x9d, 0x64, 0x8e, 0xf8, 0x83, 0x44, 0x86,
      0x77, 0x97, 0x9c, 0xec, 0x04, 0xb4, 0x34, 0xa6, 0xac, 0x2e, 0x75, 0xe9,
      0x98, 0x5d, 0xe2, 0x3d, 0xb0, 0x29, 0x2f, 0xc1, 0x11, 0x8c, 0x9f, 0xfa,
      0x9d, 0x81, 0x81, 0xe7, 0x33, 0x8d, 0xb7, 0x92, 0xb7, 0x30, 0xd7, 0xb9,
      0xe3, 0x49, 0x59, 0x2f, 0x68, 0x09, 0x98, 0x72, 0x15, 0x39, 0x15, 0xea,
      0x3d, 0x6b, 0x8b, 0x46, 0x53, 0xc6, 0x33, 0x45, 0x8f, 0x80, 0x3b, 0x32,
      0xa4, 0xc2, 0xe0, 0xf2, 0x72, 0x90, 0x25, 0x6e, 0x4e, 0x3f, 0x8a, 0x3b,
      0x08, 0x38, 0xa1, 0xc4, 0x50, 0xe4, 0xe1, 0x8c, 0x1a, 0x29, 0xa3, 0x7d,
      0xdf, 0x5e, 0xa1, 0x43, 0xde, 0x4b, 0x66, 0xff, 0x04, 0x90, 0x3e, 0xd5,
      0xcf, 0x16, 0x23, 0xe1, 0x58, 0xd4, 0x87, 0xc6, 0x08, 0xe9, 0x7f, 0x21,
      0x1c, 0xd8, 0x1d, 0xca, 0x23, 0xcb, 0x6e, 0x38, 0x07, 0x65, 0xf8, 0x22,
      0xe3, 0x42, 0xbe, 0x48, 0x4c, 0x05, 0x76, 0x39, 0x39, 0x60, 0x1c, 0xd6,
      0x67, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7, 0xdf,
      0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2, 0x33,
      0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5c},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 570
    {SEC_OID_SHA224,
     570,
     {0x30, 0x82, 0x01, 0x24, 0x02, 0x82, 0x01, 0x01, 0x00, 0x8f, 0x79, 0x35,
      0xd9, 0xb9, 0xaa, 0xe9, 0xbf, 0xab, 0xed, 0x88, 0x7a, 0xcf, 0x49, 0x51,
      0xb6, 0xf3, 0x2e, 0xc5, 0x9e, 0x3b, 0xaf, 0x37, 0x18, 0xe8, 0xea, 0xc4,
      0x96, 0x1f, 0x3e, 0xfd, 0x36, 0x06, 0xe7, 0x43, 0x51, 0xa9, 0xc4, 0x18,
      0x33, 0x39, 0xb8, 0x09, 0xe7, 0xc2, 0xae, 0x1c, 0x53, 0x9b, 0xa7, 0x47,
      0x5b, 0x85, 0xd0, 0x11, 0xad, 0xb8, 0xb4, 0x79, 0x87, 0x75, 0x49, 0x84,
      0x69, 0x5c, 0xac, 0x0e, 0x8f, 0x14, 0xb3, 0x36, 0x08, 0x28, 0xa2, 0x2f,
      0xfa, 0x27, 0x11, 0x0a, 0x3d, 0x62, 0xa9, 0x93, 0x45, 0x34, 0x09, 0xa0,
      0xfe, 0x69, 0x6c, 0x46, 0x58, 0xf8, 0x4b, 0xdd, 0x20, 0x81, 0x9c, 0x37,
      0x09, 0xa0, 0x10, 0x57, 0xb1, 0x95, 0xad, 0xcd, 0x00, 0x23, 0x3d, 0xba,
      0x54, 0x84, 0xb6, 0x29, 0x1f, 0x9d, 0x64, 0x8e, 0xf8, 0x83, 0x44, 0x86,
      0x77, 0x97, 0x9c, 0xec, 0x04, 0xb4, 0x34, 0xa6, 0xac, 0x2e, 0x75, 0xe9,
      0x98, 0x5d, 0xe2, 0x3d, 0xb0, 0x29, 0x2f, 0xc1, 0x11, 0x8c, 0x9f, 0xfa,
      0x9d, 0x81, 0x81, 0xe7, 0x33, 0x8d, 0xb7, 0x92, 0xb7, 0x30, 0xd7, 0xb9,
      0xe3, 0x49, 0x59, 0x2f, 0x68, 0x09, 0x98, 0x72, 0x15, 0x39, 0x15, 0xea,
      0x3d, 0x6b, 0x8b, 0x46, 0x53, 0xc6, 0x33, 0x45, 0x8f, 0x80, 0x3b, 0x32,
      0xa4, 0xc2, 0xe0, 0xf2, 0x72, 0x90, 0x25, 0x6e, 0x4e, 0x3f, 0x8a, 0x3b,
      0x08, 0x38, 0xa1, 0xc4, 0x50, 0xe4, 0xe1, 0x8c, 0x1a, 0x29, 0xa3, 0x7d,
      0xdf, 0x5e, 0xa1, 0x43, 0xde, 0x4b, 0x66, 0xff, 0x04, 0x90, 0x3e, 0xd5,
      0xcf, 0x16, 0x23, 0xe1, 0x58, 0xd4, 0x87, 0xc6, 0x08, 0xe9, 0x7f, 0x21,
      0x1c, 0xd8, 0x1d, 0xca, 0x23, 0xcb, 0x6e, 0x38, 0x07, 0x65, 0xf8, 0x22,
      0xe3, 0x42, 0xbe, 0x48, 0x4c, 0x05, 0x76, 0x39, 0x39, 0x60, 0x1c, 0xd6,
      0x67, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7, 0xdf,
      0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2, 0x33,
      0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5d},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 571
    {SEC_OID_SHA224,
     571,
     {0x30, 0x82, 0x01, 0x24, 0x02, 0x82, 0x01, 0x01, 0x00, 0x8f, 0x79, 0x35,
      0xd9, 0xb9, 0xaa, 0xe9, 0xbf, 0xab, 0xed, 0x88, 0x7a, 0xcf, 0x49, 0x51,
      0xb6, 0xf3, 0x2e, 0xc5, 0x9e, 0x3b, 0xaf, 0x37, 0x18, 0xe8, 0xea, 0xc4,
      0x96, 0x1f, 0x3e, 0xfd, 0x36, 0x06, 0xe7, 0x43, 0x51, 0xa9, 0xc4, 0x18,
      0x33, 0x39, 0xb8, 0x09, 0xe7, 0xc2, 0xae, 0x1c, 0x53, 0x9b, 0xa7, 0x47,
      0x5b, 0x85, 0xd0, 0x11, 0xad, 0xb8, 0xb4, 0x79, 0x87, 0x75, 0x49, 0x84,
      0x69, 0x5c, 0xac, 0x0e, 0x8f, 0x14, 0xb3, 0x36, 0x08, 0x28, 0xa2, 0x2f,
      0xfa, 0x27, 0x11, 0x0a, 0x3d, 0x62, 0xa9, 0x93, 0x45, 0x34, 0x09, 0xa0,
      0xfe, 0x69, 0x6c, 0x46, 0x58, 0xf8, 0x4b, 0xdd, 0x20, 0x81, 0x9c, 0x37,
      0x09, 0xa0, 0x10, 0x57, 0xb1, 0x95, 0xad, 0xcd, 0x00, 0x23, 0x3d, 0xba,
      0x54, 0x84, 0xb6, 0x29, 0x1f, 0x9d, 0x64, 0x8e, 0xf8, 0x83, 0x44, 0x86,
      0x77, 0x97, 0x9c, 0xec, 0x04, 0xb4, 0x34, 0xa6, 0xac, 0x2e, 0x75, 0xe9,
      0x98, 0x5d, 0xe2, 0x3d, 0xb0, 0x29, 0x2f, 0xc1, 0x11, 0x8c, 0x9f, 0xfa,
      0x9d, 0x81, 0x81, 0xe7, 0x33, 0x8d, 0xb7, 0x92, 0xb7, 0x30, 0xd7, 0xb9,
      0xe3, 0x49, 0x59, 0x2f, 0x68, 0x09, 0x98, 0x72, 0x15, 0x39, 0x15, 0xea,
      0x3d, 0x6b, 0x8b, 0x46, 0x53, 0xc6, 0x33, 0x45, 0x8f, 0x80, 0x3b, 0x32,
      0xa4, 0xc2, 0xe0, 0xf2, 0x72, 0x90, 0x25, 0x6e, 0x4e, 0x3f, 0x8a, 0x3b,
      0x08, 0x38, 0xa1, 0xc4, 0x50, 0xe4, 0xe1, 0x8c, 0x1a, 0x29, 0xa3, 0x7d,
      0xdf, 0x5e, 0xa1, 0x43, 0xde, 0x4b, 0x66, 0xff, 0x04, 0x90, 0x3e, 0xd5,
      0xcf, 0x16, 0x23, 0xe1, 0x58, 0xd4, 0x87, 0xc6, 0x08, 0xe9, 0x7f, 0x21,
      0x1c, 0xd8, 0x1d, 0xca, 0x23, 0xcb, 0x6e, 0x38, 0x07, 0x65, 0xf8, 0x22,
      0xe3, 0x42, 0xbe, 0x48, 0x4c, 0x05, 0x76, 0x39, 0x39, 0x60, 0x1c, 0xd6,
      0x67, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7, 0xdf,
      0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2, 0x33,
      0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5e},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 572
    {SEC_OID_SHA224,
     572,
     {0x30, 0x82, 0x01, 0x24, 0x02, 0x82, 0x01, 0x01, 0x00, 0x8f, 0x79, 0x35,
      0xd9, 0xb9, 0xaa, 0xe9, 0xbf, 0xab, 0xed, 0x88, 0x7a, 0xcf, 0x49, 0x51,
      0xb6, 0xf3, 0x2e, 0xc5, 0x9e, 0x3b, 0xaf, 0x37, 0x18, 0xe8, 0xea, 0xc4,
      0x96, 0x1f, 0x3e, 0xfd, 0x36, 0x06, 0xe7, 0x43, 0x51, 0xa9, 0xc4, 0x18,
      0x33, 0x39, 0xb8, 0x09, 0xe7, 0xc2, 0xae, 0x1c, 0x53, 0x9b, 0xa7, 0x47,
      0x5b, 0x85, 0xd0, 0x11, 0xad, 0xb8, 0xb4, 0x79, 0x87, 0x75, 0x49, 0x84,
      0x69, 0x5c, 0xac, 0x0e, 0x8f, 0x14, 0xb3, 0x36, 0x08, 0x28, 0xa2, 0x2f,
      0xfa, 0x27, 0x11, 0x0a, 0x3d, 0x62, 0xa9, 0x93, 0x45, 0x34, 0x09, 0xa0,
      0xfe, 0x69, 0x6c, 0x46, 0x58, 0xf8, 0x4b, 0xdd, 0x20, 0x81, 0x9c, 0x37,
      0x09, 0xa0, 0x10, 0x57, 0xb1, 0x95, 0xad, 0xcd, 0x00, 0x23, 0x3d, 0xba,
      0x54, 0x84, 0xb6, 0x29, 0x1f, 0x9d, 0x64, 0x8e, 0xf8, 0x83, 0x44, 0x86,
      0x77, 0x97, 0x9c, 0xec, 0x04, 0xb4, 0x34, 0xa6, 0xac, 0x2e, 0x75, 0xe9,
      0x98, 0x5d, 0xe2, 0x3d, 0xb0, 0x29, 0x2f, 0xc1, 0x11, 0x8c, 0x9f, 0xfa,
      0x9d, 0x81, 0x81, 0xe7, 0x33, 0x8d, 0xb7, 0x92, 0xb7, 0x30, 0xd7, 0xb9,
      0xe3, 0x49, 0x59, 0x2f, 0x68, 0x09, 0x98, 0x72, 0x15, 0x39, 0x15, 0xea,
      0x3d, 0x6b, 0x8b, 0x46, 0x53, 0xc6, 0x33, 0x45, 0x8f, 0x80, 0x3b, 0x32,
      0xa4, 0xc2, 0xe0, 0xf2, 0x72, 0x90, 0x25, 0x6e, 0x4e, 0x3f, 0x8a, 0x3b,
      0x08, 0x38, 0xa1, 0xc4, 0x50, 0xe4, 0xe1, 0x8c, 0x1a, 0x29, 0xa3, 0x7d,
      0xdf, 0x5e, 0xa1, 0x43, 0xde, 0x4b, 0x66, 0xff, 0x04, 0x90, 0x3e, 0xd5,
      0xcf, 0x16, 0x23, 0xe1, 0x58, 0xd4, 0x87, 0xc6, 0x08, 0xe9, 0x7f, 0x21,
      0x1c, 0xd8, 0x1d, 0xca, 0x23, 0xcb, 0x6e, 0x38, 0x07, 0x65, 0xf8, 0x22,
      0xe3, 0x42, 0xbe, 0x48, 0x4c, 0x05, 0x76, 0x39, 0x39, 0x60, 0x1c, 0xd6,
      0x67, 0x02, 0x1d, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 573
    {SEC_OID_SHA224,
     573,
     {0x30, 0x82, 0x02, 0x0a, 0x02, 0x82, 0x01, 0x01, 0x00, 0x8f, 0x79, 0x35,
      0xd9, 0xb9, 0xaa, 0xe9, 0xbf, 0xab, 0xed, 0x88, 0x7a, 0xcf, 0x49, 0x51,
      0xb6, 0xf3, 0x2e, 0xc5, 0x9e, 0x3b, 0xaf, 0x37, 0x18, 0xe8, 0xea, 0xc4,
      0x96, 0x1f, 0x3e, 0xfd, 0x36, 0x06, 0xe7, 0x43, 0x51, 0xa9, 0xc4, 0x18,
      0x33, 0x39, 0xb8, 0x09, 0xe7, 0xc2, 0xae, 0x1c, 0x53, 0x9b, 0xa7, 0x47,
      0x5b, 0x85, 0xd0, 0x11, 0xad, 0xb8, 0xb4, 0x79, 0x87, 0x75, 0x49, 0x84,
      0x69, 0x5c, 0xac, 0x0e, 0x8f, 0x14, 0xb3, 0x36, 0x08, 0x28, 0xa2, 0x2f,
      0xfa, 0x27, 0x11, 0x0a, 0x3d, 0x62, 0xa9, 0x93, 0x45, 0x34, 0x09, 0xa0,
      0xfe, 0x69, 0x6c, 0x46, 0x58, 0xf8, 0x4b, 0xdd, 0x20, 0x81, 0x9c, 0x37,
      0x09, 0xa0, 0x10, 0x57, 0xb1, 0x95, 0xad, 0xcd, 0x00, 0x23, 0x3d, 0xba,
      0x54, 0x84, 0xb6, 0x29, 0x1f, 0x9d, 0x64, 0x8e, 0xf8, 0x83, 0x44, 0x86,
      0x77, 0x97, 0x9c, 0xec, 0x04, 0xb4, 0x34, 0xa6, 0xac, 0x2e, 0x75, 0xe9,
      0x98, 0x5d, 0xe2, 0x3d, 0xb0, 0x29, 0x2f, 0xc1, 0x11, 0x8c, 0x9f, 0xfa,
      0x9d, 0x81, 0x81, 0xe7, 0x33, 0x8d, 0xb7, 0x92, 0xb7, 0x30, 0xd7, 0xb9,
      0xe3, 0x49, 0x59, 0x2f, 0x68, 0x09, 0x98, 0x72, 0x15, 0x39, 0x15, 0xea,
      0x3d, 0x6b, 0x8b, 0x46, 0x53, 0xc6, 0x33, 0x45, 0x8f, 0x80, 0x3b, 0x32,
      0xa4, 0xc2, 0xe0, 0xf2, 0x72, 0x90, 0x25, 0x6e, 0x4e, 0x3f, 0x8a, 0x3b,
      0x08, 0x38, 0xa1, 0xc4, 0x50, 0xe4, 0xe1, 0x8c, 0x1a, 0x29, 0xa3, 0x7d,
      0xdf, 0x5e, 0xa1, 0x43, 0xde, 0x4b, 0x66, 0xff, 0x04, 0x90, 0x3e, 0xd5,
      0xcf, 0x16, 0x23, 0xe1, 0x58, 0xd4, 0x87, 0xc6, 0x08, 0xe9, 0x7f, 0x21,
      0x1c, 0xd8, 0x1d, 0xca, 0x23, 0xcb, 0x6e, 0x38, 0x07, 0x65, 0xf8, 0x22,
      0xe3, 0x42, 0xbe, 0x48, 0x4c, 0x05, 0x76, 0x39, 0x39, 0x60, 0x1c, 0xd6,
      0x67, 0x02, 0x82, 0x01, 0x01, 0x00, 0x8f, 0x79, 0x35, 0xd9, 0xb9, 0xaa,
      0xe9, 0xbf, 0xab, 0xed, 0x88, 0x7a, 0xcf, 0x49, 0x51, 0xb6, 0xf3, 0x2e,
      0xc5, 0x9e, 0x3b, 0xaf, 0x37, 0x18, 0xe8, 0xea, 0xc4, 0x96, 0x1f, 0x3e,
      0xfd, 0x36, 0x06, 0xe7, 0x43, 0x51, 0xa9, 0xc4, 0x18, 0x33, 0x39, 0xb8,
      0x09, 0xe7, 0xc2, 0xae, 0x1c, 0x53, 0x9b, 0xa7, 0x47, 0x5b, 0x85, 0xd0,
      0x11, 0xad, 0xb8, 0xb4, 0x79, 0x87, 0x75, 0x49, 0x84, 0x69, 0x5c, 0xac,
      0x0e, 0x8f, 0x14, 0xb3, 0x36, 0x08, 0x28, 0xa2, 0x2f, 0xfa, 0x27, 0x11,
      0x0a, 0x3d, 0x62, 0xa9, 0x93, 0x45, 0x34, 0x09, 0xa0, 0xfe, 0x69, 0x6c,
      0x46, 0x58, 0xf8, 0x4b, 0xdd, 0x20, 0x81, 0x9c, 0x37, 0x09, 0xa0, 0x10,
      0x57, 0xb1, 0x95, 0xad, 0xcd, 0x00, 0x23, 0x3d, 0xba, 0x54, 0x84, 0xb6,
      0x29, 0x1f, 0x9d, 0x64, 0x8e, 0xf8, 0x83, 0x44, 0x86, 0x77, 0x97, 0x9c,
      0xec, 0x04, 0xb4, 0x34, 0xa6, 0xac, 0x2e, 0x75, 0xe9, 0x98, 0x5d, 0xe2,
      0x3d, 0xb0, 0x29, 0x2f, 0xc1, 0x11, 0x8c, 0x9f, 0xfa, 0x9d, 0x81, 0x81,
      0xe7, 0x33, 0x8d, 0xb7, 0x92, 0xb7, 0x30, 0xd7, 0xb9, 0xe3, 0x49, 0x59,
      0x2f, 0x68, 0x09, 0x98, 0x72, 0x15, 0x39, 0x15, 0xea, 0x3d, 0x6b, 0x8b,
      0x46, 0x53, 0xc6, 0x33, 0x45, 0x8f, 0x80, 0x3b, 0x32, 0xa4, 0xc2, 0xe0,
      0xf2, 0x72, 0x90, 0x25, 0x6e, 0x4e, 0x3f, 0x8a, 0x3b, 0x08, 0x38, 0xa1,
      0xc4, 0x50, 0xe4, 0xe1, 0x8c, 0x1a, 0x29, 0xa3, 0x7d, 0xdf, 0x5e, 0xa1,
      0x43, 0xde, 0x4b, 0x66, 0xff, 0x04, 0x90, 0x3e, 0xd5, 0xcf, 0x16, 0x23,
      0xe1, 0x58, 0xd4, 0x87, 0xc6, 0x08, 0xe9, 0x7f, 0x21, 0x1c, 0xd8, 0x1d,
      0xca, 0x23, 0xcb, 0x6e, 0x38, 0x07, 0x65, 0xf8, 0x22, 0xe3, 0x42, 0xbe,
      0x48, 0x4c, 0x05, 0x76, 0x39, 0x39, 0x60, 0x1c, 0xd6, 0x67},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 574
    {SEC_OID_SHA224,
     574,
     {0x30, 0x82, 0x01, 0x0a, 0x02, 0x82, 0x01, 0x01, 0x00, 0x8f, 0x79, 0x35,
      0xd9, 0xb9, 0xaa, 0xe9, 0xbf, 0xab, 0xed, 0x88, 0x7a, 0xcf, 0x49, 0x51,
      0xb6, 0xf3, 0x2e, 0xc5, 0x9e, 0x3b, 0xaf, 0x37, 0x18, 0xe8, 0xea, 0xc4,
      0x96, 0x1f, 0x3e, 0xfd, 0x36, 0x06, 0xe7, 0x43, 0x51, 0xa9, 0xc4, 0x18,
      0x33, 0x39, 0xb8, 0x09, 0xe7, 0xc2, 0xae, 0x1c, 0x53, 0x9b, 0xa7, 0x47,
      0x5b, 0x85, 0xd0, 0x11, 0xad, 0xb8, 0xb4, 0x79, 0x87, 0x75, 0x49, 0x84,
      0x69, 0x5c, 0xac, 0x0e, 0x8f, 0x14, 0xb3, 0x36, 0x08, 0x28, 0xa2, 0x2f,
      0xfa, 0x27, 0x11, 0x0a, 0x3d, 0x62, 0xa9, 0x93, 0x45, 0x34, 0x09, 0xa0,
      0xfe, 0x69, 0x6c, 0x46, 0x58, 0xf8, 0x4b, 0xdd, 0x20, 0x81, 0x9c, 0x37,
      0x09, 0xa0, 0x10, 0x57, 0xb1, 0x95, 0xad, 0xcd, 0x00, 0x23, 0x3d, 0xba,
      0x54, 0x84, 0xb6, 0x29, 0x1f, 0x9d, 0x64, 0x8e, 0xf8, 0x83, 0x44, 0x86,
      0x77, 0x97, 0x9c, 0xec, 0x04, 0xb4, 0x34, 0xa6, 0xac, 0x2e, 0x75, 0xe9,
      0x98, 0x5d, 0xe2, 0x3d, 0xb0, 0x29, 0x2f, 0xc1, 0x11, 0x8c, 0x9f, 0xfa,
      0x9d, 0x81, 0x81, 0xe7, 0x33, 0x8d, 0xb7, 0x92, 0xb7, 0x30, 0xd7, 0xb9,
      0xe3, 0x49, 0x59, 0x2f, 0x68, 0x09, 0x98, 0x72, 0x15, 0x39, 0x15, 0xea,
      0x3d, 0x6b, 0x8b, 0x46, 0x53, 0xc6, 0x33, 0x45, 0x8f, 0x80, 0x3b, 0x32,
      0xa4, 0xc2, 0xe0, 0xf2, 0x72, 0x90, 0x25, 0x6e, 0x4e, 0x3f, 0x8a, 0x3b,
      0x08, 0x38, 0xa1, 0xc4, 0x50, 0xe4, 0xe1, 0x8c, 0x1a, 0x29, 0xa3, 0x7d,
      0xdf, 0x5e, 0xa1, 0x43, 0xde, 0x4b, 0x66, 0xff, 0x04, 0x90, 0x3e, 0xd5,
      0xcf, 0x16, 0x23, 0xe1, 0x58, 0xd4, 0x87, 0xc6, 0x08, 0xe9, 0x7f, 0x21,
      0x1c, 0xd8, 0x1d, 0xca, 0x23, 0xcb, 0x6e, 0x38, 0x07, 0x65, 0xf8, 0x22,
      0xe3, 0x42, 0xbe, 0x48, 0x4c, 0x05, 0x76, 0x39, 0x39, 0x60, 0x1c, 0xd6,
      0x67, 0x09, 0x03, 0x80, 0xfe, 0x01},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 575
    {SEC_OID_SHA224,
     575,
     {0x30, 0x82, 0x01, 0x08, 0x02, 0x82, 0x01, 0x01, 0x00, 0x8f, 0x79, 0x35,
      0xd9, 0xb9, 0xaa, 0xe9, 0xbf, 0xab, 0xed, 0x88, 0x7a, 0xcf, 0x49, 0x51,
      0xb6, 0xf3, 0x2e, 0xc5, 0x9e, 0x3b, 0xaf, 0x37, 0x18, 0xe8, 0xea, 0xc4,
      0x96, 0x1f, 0x3e, 0xfd, 0x36, 0x06, 0xe7, 0x43, 0x51, 0xa9, 0xc4, 0x18,
      0x33, 0x39, 0xb8, 0x09, 0xe7, 0xc2, 0xae, 0x1c, 0x53, 0x9b, 0xa7, 0x47,
      0x5b, 0x85, 0xd0, 0x11, 0xad, 0xb8, 0xb4, 0x79, 0x87, 0x75, 0x49, 0x84,
      0x69, 0x5c, 0xac, 0x0e, 0x8f, 0x14, 0xb3, 0x36, 0x08, 0x28, 0xa2, 0x2f,
      0xfa, 0x27, 0x11, 0x0a, 0x3d, 0x62, 0xa9, 0x93, 0x45, 0x34, 0x09, 0xa0,
      0xfe, 0x69, 0x6c, 0x46, 0x58, 0xf8, 0x4b, 0xdd, 0x20, 0x81, 0x9c, 0x37,
      0x09, 0xa0, 0x10, 0x57, 0xb1, 0x95, 0xad, 0xcd, 0x00, 0x23, 0x3d, 0xba,
      0x54, 0x84, 0xb6, 0x29, 0x1f, 0x9d, 0x64, 0x8e, 0xf8, 0x83, 0x44, 0x86,
      0x77, 0x97, 0x9c, 0xec, 0x04, 0xb4, 0x34, 0xa6, 0xac, 0x2e, 0x75, 0xe9,
      0x98, 0x5d, 0xe2, 0x3d, 0xb0, 0x29, 0x2f, 0xc1, 0x11, 0x8c, 0x9f, 0xfa,
      0x9d, 0x81, 0x81, 0xe7, 0x33, 0x8d, 0xb7, 0x92, 0xb7, 0x30, 0xd7, 0xb9,
      0xe3, 0x49, 0x59, 0x2f, 0x68, 0x09, 0x98, 0x72, 0x15, 0x39, 0x15, 0xea,
      0x3d, 0x6b, 0x8b, 0x46, 0x53, 0xc6, 0x33, 0x45, 0x8f, 0x80, 0x3b, 0x32,
      0xa4, 0xc2, 0xe0, 0xf2, 0x72, 0x90, 0x25, 0x6e, 0x4e, 0x3f, 0x8a, 0x3b,
      0x08, 0x38, 0xa1, 0xc4, 0x50, 0xe4, 0xe1, 0x8c, 0x1a, 0x29, 0xa3, 0x7d,
      0xdf, 0x5e, 0xa1, 0x43, 0xde, 0x4b, 0x66, 0xff, 0x04, 0x90, 0x3e, 0xd5,
      0xcf, 0x16, 0x23, 0xe1, 0x58, 0xd4, 0x87, 0xc6, 0x08, 0xe9, 0x7f, 0x21,
      0x1c, 0xd8, 0x1d, 0xca, 0x23, 0xcb, 0x6e, 0x38, 0x07, 0x65, 0xf8, 0x22,
      0xe3, 0x42, 0xbe, 0x48, 0x4c, 0x05, 0x76, 0x39, 0x39, 0x60, 0x1c, 0xd6,
      0x67, 0x09, 0x01, 0x42},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 576
    {SEC_OID_SHA224,
     576,
     {0x30, 0x24, 0x09, 0x03, 0x80, 0xfe, 0x01, 0x02, 0x1d, 0xff,
      0x45, 0x09, 0x69, 0x59, 0x7a, 0x87, 0x08, 0x20, 0x21, 0x18,
      0x05, 0x98, 0x36, 0x88, 0x38, 0x7a, 0x10, 0xcd, 0x4d, 0xcc,
      0x45, 0x1a, 0x7f, 0x3f, 0x43, 0x2a, 0x96, 0xa3},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 577
    {SEC_OID_SHA224,
     577,
     {0x30, 0x08, 0x09, 0x03, 0x80, 0xfe, 0x01, 0x02, 0x01, 0x00},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 578
    {SEC_OID_SHA224,
     578,
     {0x30, 0x08, 0x09, 0x03, 0x80, 0xfe, 0x01, 0x02, 0x01, 0x01},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 579
    {SEC_OID_SHA224,
     579,
     {0x30, 0x08, 0x09, 0x03, 0x80, 0xfe, 0x01, 0x02, 0x01, 0xff},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 580
    {SEC_OID_SHA224,
     580,
     {0x30, 0x23, 0x09, 0x03, 0x80, 0xfe, 0x01, 0x02, 0x1c, 0x5d,
      0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b, 0xef, 0xef, 0x73, 0xfd,
      0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99, 0x59, 0x19, 0xdd,
      0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xae},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 581
    {SEC_OID_SHA224,
     581,
     {0x30, 0x23, 0x09, 0x03, 0x80, 0xfe, 0x01, 0x02, 0x1c, 0x5d,
      0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b, 0xef, 0xef, 0x73, 0xfd,
      0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99, 0x59, 0x19, 0xdd,
      0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xaf},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 582
    {SEC_OID_SHA224,
     582,
     {0x30, 0x24, 0x09, 0x03, 0x80, 0xfe, 0x01, 0x02, 0x1d, 0x00,
      0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7, 0xdf, 0xde, 0xe7,
      0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2, 0x33,
      0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5c},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 583
    {SEC_OID_SHA224,
     583,
     {0x30, 0x24, 0x09, 0x03, 0x80, 0xfe, 0x01, 0x02, 0x1d, 0x00,
      0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7, 0xdf, 0xde, 0xe7,
      0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2, 0x33,
      0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5d},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 584
    {SEC_OID_SHA224,
     584,
     {0x30, 0x24, 0x09, 0x03, 0x80, 0xfe, 0x01, 0x02, 0x1d, 0x00,
      0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7, 0xdf, 0xde, 0xe7,
      0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2, 0x33,
      0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5e},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 585
    {SEC_OID_SHA224,
     585,
     {0x30, 0x24, 0x09, 0x03, 0x80, 0xfe, 0x01, 0x02, 0x1d, 0x01,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 586
    {SEC_OID_SHA224,
     586,
     {0x30, 0x82, 0x01, 0x0a, 0x09, 0x03, 0x80, 0xfe, 0x01, 0x02, 0x82, 0x01,
      0x01, 0x00, 0x8f, 0x79, 0x35, 0xd9, 0xb9, 0xaa, 0xe9, 0xbf, 0xab, 0xed,
      0x88, 0x7a, 0xcf, 0x49, 0x51, 0xb6, 0xf3, 0x2e, 0xc5, 0x9e, 0x3b, 0xaf,
      0x37, 0x18, 0xe8, 0xea, 0xc4, 0x96, 0x1f, 0x3e, 0xfd, 0x36, 0x06, 0xe7,
      0x43, 0x51, 0xa9, 0xc4, 0x18, 0x33, 0x39, 0xb8, 0x09, 0xe7, 0xc2, 0xae,
      0x1c, 0x53, 0x9b, 0xa7, 0x47, 0x5b, 0x85, 0xd0, 0x11, 0xad, 0xb8, 0xb4,
      0x79, 0x87, 0x75, 0x49, 0x84, 0x69, 0x5c, 0xac, 0x0e, 0x8f, 0x14, 0xb3,
      0x36, 0x08, 0x28, 0xa2, 0x2f, 0xfa, 0x27, 0x11, 0x0a, 0x3d, 0x62, 0xa9,
      0x93, 0x45, 0x34, 0x09, 0xa0, 0xfe, 0x69, 0x6c, 0x46, 0x58, 0xf8, 0x4b,
      0xdd, 0x20, 0x81, 0x9c, 0x37, 0x09, 0xa0, 0x10, 0x57, 0xb1, 0x95, 0xad,
      0xcd, 0x00, 0x23, 0x3d, 0xba, 0x54, 0x84, 0xb6, 0x29, 0x1f, 0x9d, 0x64,
      0x8e, 0xf8, 0x83, 0x44, 0x86, 0x77, 0x97, 0x9c, 0xec, 0x04, 0xb4, 0x34,
      0xa6, 0xac, 0x2e, 0x75, 0xe9, 0x98, 0x5d, 0xe2, 0x3d, 0xb0, 0x29, 0x2f,
      0xc1, 0x11, 0x8c, 0x9f, 0xfa, 0x9d, 0x81, 0x81, 0xe7, 0x33, 0x8d, 0xb7,
      0x92, 0xb7, 0x30, 0xd7, 0xb9, 0xe3, 0x49, 0x59, 0x2f, 0x68, 0x09, 0x98,
      0x72, 0x15, 0x39, 0x15, 0xea, 0x3d, 0x6b, 0x8b, 0x46, 0x53, 0xc6, 0x33,
      0x45, 0x8f, 0x80, 0x3b, 0x32, 0xa4, 0xc2, 0xe0, 0xf2, 0x72, 0x90, 0x25,
      0x6e, 0x4e, 0x3f, 0x8a, 0x3b, 0x08, 0x38, 0xa1, 0xc4, 0x50, 0xe4, 0xe1,
      0x8c, 0x1a, 0x29, 0xa3, 0x7d, 0xdf, 0x5e, 0xa1, 0x43, 0xde, 0x4b, 0x66,
      0xff, 0x04, 0x90, 0x3e, 0xd5, 0xcf, 0x16, 0x23, 0xe1, 0x58, 0xd4, 0x87,
      0xc6, 0x08, 0xe9, 0x7f, 0x21, 0x1c, 0xd8, 0x1d, 0xca, 0x23, 0xcb, 0x6e,
      0x38, 0x07, 0x65, 0xf8, 0x22, 0xe3, 0x42, 0xbe, 0x48, 0x4c, 0x05, 0x76,
      0x39, 0x39, 0x60, 0x1c, 0xd6, 0x67},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 587
    {SEC_OID_SHA224,
     587,
     {0x30, 0x0a, 0x09, 0x03, 0x80, 0xfe, 0x01, 0x09, 0x03, 0x80, 0xfe, 0x01},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 588
    {SEC_OID_SHA224,
     588,
     {0x30, 0x08, 0x09, 0x03, 0x80, 0xfe, 0x01, 0x09, 0x01, 0x42},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signature encoding contains wrong type.
    // tcID: 589
    {SEC_OID_SHA224,
     589,
     {0x30, 0x06, 0x02, 0x01, 0x01, 0x0c, 0x01, 0x30},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signature encoding contains wrong type.
    // tcID: 590
    {SEC_OID_SHA224,
     590,
     {0x30, 0x05, 0x02, 0x01, 0x01, 0x0c, 0x00},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signature encoding contains wrong type.
    // tcID: 591
    {SEC_OID_SHA224,
     591,
     {0x30, 0x09, 0x0c, 0x02, 0x25, 0x73, 0x0c, 0x03, 0x73, 0x25, 0x73},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signature encoding contains wrong type.
    // tcID: 592
    {SEC_OID_SHA224,
     592,
     {0x30, 0x08, 0x02, 0x01, 0x01, 0x30, 0x03, 0x02, 0x01, 0x00},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signature encoding contains wrong type.
    // tcID: 593
    {SEC_OID_SHA224,
     593,
     {0x30, 0x03, 0x02, 0x01, 0x01},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: Signature encoding contains wrong type.
    // tcID: 594
    {SEC_OID_SHA224,
     594,
     {0x30, 0x06, 0x02, 0x01, 0x01, 0x01, 0x01, 0x00},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     false},

    // Comment: random signature
    // tcID: 595
    {SEC_OID_SHA224,
     595,
     {0x30, 0x3e, 0x02, 0x1d, 0x00, 0x85, 0xc7, 0x71, 0xec, 0xf9, 0xc7,
      0x7d, 0xeb, 0xae, 0x0c, 0x54, 0xf7, 0x49, 0xdb, 0xa4, 0xb0, 0x7a,
      0xe5, 0x19, 0xca, 0x10, 0x37, 0x09, 0x1d, 0xd6, 0xf2, 0x94, 0xcf,
      0x02, 0x1d, 0x00, 0xa0, 0x2f, 0x74, 0x98, 0x51, 0x98, 0xcf, 0x88,
      0xe3, 0x10, 0xe5, 0x52, 0x77, 0xba, 0x59, 0x8b, 0x33, 0x61, 0x64,
      0x85, 0x0f, 0xdd, 0x53, 0x08, 0xa7, 0xbe, 0xb1, 0xa7},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     true},

    // Comment: random signature
    // tcID: 596
    {SEC_OID_SHA224,
     596,
     {0x30, 0x3c, 0x02, 0x1c, 0x04, 0x3c, 0xd5, 0x58, 0x0b, 0x8b, 0xfb,
      0x59, 0x75, 0xed, 0xef, 0x13, 0x2d, 0x6d, 0xe7, 0x84, 0x80, 0x96,
      0x39, 0x2e, 0x0a, 0xdf, 0x46, 0x34, 0x2b, 0xad, 0x7b, 0xb7, 0x02,
      0x1c, 0x14, 0x2b, 0x65, 0x72, 0xce, 0x61, 0xb0, 0x32, 0xd4, 0x5d,
      0x45, 0x97, 0xa8, 0x8c, 0x4e, 0x54, 0xdd, 0x59, 0x3f, 0xa7, 0xca,
      0x6c, 0x8e, 0x68, 0x82, 0xdf, 0x77, 0xf6},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     true},

    // Comment: random signature
    // tcID: 597
    {SEC_OID_SHA224,
     597,
     {0x30, 0x3d, 0x02, 0x1d, 0x00, 0x91, 0x4e, 0x4f, 0x7b, 0xa8, 0xdf,
      0x44, 0xcf, 0x63, 0xc5, 0x7d, 0x21, 0x9c, 0x6b, 0x5d, 0xa0, 0x93,
      0xfe, 0x3a, 0x94, 0x60, 0x4b, 0xd2, 0xef, 0x88, 0xb6, 0x30, 0xf5,
      0x02, 0x1c, 0x6a, 0x7b, 0x80, 0x4c, 0xbf, 0xc6, 0x99, 0x37, 0x90,
      0x3b, 0xbd, 0x0c, 0x8f, 0x67, 0x30, 0x6a, 0x6e, 0x8b, 0xf0, 0xd0,
      0x50, 0x1a, 0xe3, 0xf3, 0x19, 0x0d, 0xca, 0x19},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     true},

    // Comment: random signature
    // tcID: 598
    {SEC_OID_SHA224,
     598,
     {0x30, 0x3d, 0x02, 0x1c, 0x0a, 0x8f, 0xfb, 0x16, 0x0d, 0xa0, 0xff,
      0xe3, 0x19, 0xe7, 0xd3, 0xa5, 0xea, 0x29, 0x9f, 0x53, 0x1f, 0x84,
      0x21, 0xbf, 0xdc, 0xfd, 0x6b, 0xb6, 0x6c, 0x6a, 0xdc, 0xf2, 0x02,
      0x1d, 0x00, 0x8a, 0x75, 0xe2, 0xcb, 0xaa, 0x70, 0x9b, 0x2b, 0x5d,
      0x81, 0xd3, 0x46, 0xf6, 0xe9, 0x0a, 0x8d, 0xc3, 0x53, 0xc5, 0x83,
      0x53, 0x93, 0xb1, 0xd5, 0xa6, 0x65, 0x3f, 0x3c},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     true},

    // Comment: random signature
    // tcID: 599
    {SEC_OID_SHA224,
     599,
     {0x30, 0x3d, 0x02, 0x1d, 0x00, 0xa7, 0xf1, 0x64, 0xd3, 0x2f, 0x44,
      0x68, 0x4f, 0xcd, 0xe8, 0x9f, 0x0f, 0xa9, 0x64, 0x71, 0x28, 0xbc,
      0x0c, 0x29, 0x0f, 0x08, 0xc9, 0xb9, 0xe6, 0xf7, 0xdb, 0x3f, 0xe1,
      0x02, 0x1c, 0x2d, 0xca, 0x34, 0xdb, 0x2f, 0x32, 0x0c, 0x95, 0xde,
      0x4e, 0x9d, 0xe4, 0x98, 0x6b, 0xbf, 0x50, 0x86, 0x07, 0x53, 0xd5,
      0xde, 0xb7, 0x28, 0x23, 0x76, 0x78, 0xaf, 0xb6},
     kPubKey3,
     {0x48, 0x65, 0x6c, 0x6c, 0x6f},
     true},

    // Comment: r,s = 1,1
    // tcID: 600
    {SEC_OID_SHA224,
     600,
     {0x30, 0x06, 0x02, 0x01, 0x01, 0x02, 0x01, 0x01},
     kPubKey4,
     {0x54, 0x65, 0x73, 0x74},
     true},

    // Comment: r,s = 1,5
    // tcID: 601
    {SEC_OID_SHA224,
     601,
     {0x30, 0x06, 0x02, 0x01, 0x01, 0x02, 0x01, 0x05},
     kPubKey4,
     {0x54, 0x65, 0x73, 0x74},
     true},

    // Comment: u2 small
    // tcID: 602
    {SEC_OID_SHA224,
     602,
     {0x30, 0x22, 0x02, 0x01, 0x01, 0x02, 0x1d, 0x00, 0x95, 0x92, 0x12, 0x1e,
      0xd1, 0x2d, 0x93, 0x19, 0x7f, 0x1f, 0xfb, 0x86, 0x3a, 0xc6, 0x39, 0x37,
      0xf2, 0x8e, 0xf4, 0xf6, 0x2f, 0x1e, 0x00, 0x9a, 0x30, 0xaa, 0xba, 0xb1},
     kPubKey4,
     {0x54, 0x65, 0x73, 0x74},
     true},

    // Comment: s == q-1
    // tcID: 603
    {SEC_OID_SHA224,
     603,
     {0x30, 0x22, 0x02, 0x01, 0x01, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6,
      0x85, 0x78, 0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85,
      0xef, 0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5c},
     kPubKey4,
     {0x54, 0x65, 0x73, 0x74},
     true},

    // Comment: s == 1
    // tcID: 604
    {SEC_OID_SHA224,
     604,
     {0x30, 0x21, 0x02, 0x1c, 0x5a, 0x25, 0x2f, 0x4f, 0xc5, 0x56, 0x18, 0x74,
      0x7f, 0xd9, 0x4b, 0x13, 0xc9, 0xbe, 0xe6, 0x2b, 0xb9, 0x58, 0xd8, 0x57,
      0x77, 0xcb, 0x07, 0xdd, 0x90, 0x71, 0x0d, 0x24, 0x02, 0x01, 0x01},
     kPubKey5,
     {0x54, 0x65, 0x73, 0x74},
     true},

    // Comment: Legacy:ASN encoding of r misses leading 0
    // tcID: 605
    {SEC_OID_SHA256,
     605,
     {0x30, 0x3c, 0x02, 0x1c, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4, 0x46,
      0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58, 0x0e,
      0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93, 0x02,
      0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4, 0x14,
      0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38, 0x6c,
      0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     true},

    // Comment: valid
    // tcID: 606
    {SEC_OID_SHA256,
     606,
     {0x30, 0x3d, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4,
      0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58,
      0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93,
      0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4,
      0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38,
      0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     true},

    // Comment: long form encoding of length of sequence
    // tcID: 607
    {SEC_OID_SHA256,
     607,
     {0x30, 0x81, 0x3d, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb,
      0xd4, 0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a,
      0x58, 0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee,
      0x93, 0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad,
      0xe4, 0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c,
      0x38, 0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: length of sequence contains leading 0
    // tcID: 608
    {SEC_OID_SHA256,
     608,
     {0x30, 0x82, 0x00, 0x3d, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1,
      0xcb, 0xd4, 0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13,
      0x0a, 0x58, 0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5,
      0xee, 0x93, 0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f,
      0xad, 0xe4, 0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48,
      0x0c, 0x38, 0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: wrong length of sequence
    // tcID: 609
    {SEC_OID_SHA256,
     609,
     {0x30, 0x3e, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4,
      0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58,
      0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93,
      0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4,
      0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38,
      0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: wrong length of sequence
    // tcID: 610
    {SEC_OID_SHA256,
     610,
     {0x30, 0x3c, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4,
      0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58,
      0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93,
      0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4,
      0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38,
      0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: uint32 overflow in length of sequence
    // tcID: 611
    {SEC_OID_SHA256,
     611,
     {0x30, 0x85, 0x01, 0x00, 0x00, 0x00, 0x3d, 0x02, 0x1d, 0x00, 0x9b, 0x6f,
      0xe4, 0xa1, 0xcb, 0xd4, 0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3,
      0x13, 0x0a, 0x58, 0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5,
      0xee, 0x93, 0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad,
      0xe4, 0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38,
      0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: uint64 overflow in length of sequence
    // tcID: 612
    {SEC_OID_SHA256,
     612,
     {0x30, 0x89, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3d, 0x02,
      0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4, 0x46, 0x7d, 0x75, 0x84,
      0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58, 0x0e, 0x61, 0xb9, 0x69, 0xa6,
      0x06, 0x73, 0x73, 0xd5, 0xee, 0x93, 0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47,
      0x11, 0xd6, 0x8f, 0xad, 0xe4, 0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54,
      0x70, 0x48, 0x0c, 0x38, 0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: length of sequence = 2**31 - 1
    // tcID: 613
    {SEC_OID_SHA256,
     613,
     {0x30, 0x84, 0x7f, 0xff, 0xff, 0xff, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4,
      0xa1, 0xcb, 0xd4, 0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13,
      0x0a, 0x58, 0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee,
      0x93, 0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4,
      0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38, 0x6c,
      0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: length of sequence = 2**32 - 1
    // tcID: 614
    {SEC_OID_SHA256,
     614,
     {0x30, 0x84, 0xff, 0xff, 0xff, 0xff, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4,
      0xa1, 0xcb, 0xd4, 0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13,
      0x0a, 0x58, 0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee,
      0x93, 0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4,
      0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38, 0x6c,
      0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: length of sequence = 2**40 - 1
    // tcID: 615
    {SEC_OID_SHA256,
     615,
     {0x30, 0x85, 0xff, 0xff, 0xff, 0xff, 0xff, 0x02, 0x1d, 0x00, 0x9b, 0x6f,
      0xe4, 0xa1, 0xcb, 0xd4, 0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3,
      0x13, 0x0a, 0x58, 0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5,
      0xee, 0x93, 0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad,
      0xe4, 0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38,
      0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: length of sequence = 2**64 - 1
    // tcID: 616
    {SEC_OID_SHA256,
     616,
     {0x30, 0x88, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x02, 0x1d,
      0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4, 0x46, 0x7d, 0x75, 0x84, 0xae,
      0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58, 0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06,
      0x73, 0x73, 0xd5, 0xee, 0x93, 0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11,
      0xd6, 0x8f, 0xad, 0xe4, 0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70,
      0x48, 0x0c, 0x38, 0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: incorrect length of sequence
    // tcID: 617
    {SEC_OID_SHA256,
     617,
     {0x30, 0xff, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4,
      0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58,
      0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93,
      0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4,
      0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38,
      0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: indefinite length without termination
    // tcID: 618
    {SEC_OID_SHA256,
     618,
     {0x30, 0x80, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4,
      0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58,
      0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93,
      0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4,
      0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38,
      0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: indefinite length without termination
    // tcID: 619
    {SEC_OID_SHA256,
     619,
     {0x30, 0x3d, 0x02, 0x80, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4,
      0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58,
      0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93,
      0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4,
      0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38,
      0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: indefinite length without termination
    // tcID: 620
    {SEC_OID_SHA256,
     620,
     {0x30, 0x3d, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4,
      0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58,
      0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93,
      0x02, 0x80, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4,
      0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38,
      0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: removing sequence
    // tcID: 621
    {SEC_OID_SHA256, 621, {}, kPubKey3, {0x54, 0x65, 0x73, 0x74}, false},

    // Comment: lonely sequence tag
    // tcID: 622
    {SEC_OID_SHA256, 622, {0x30}, kPubKey3, {0x54, 0x65, 0x73, 0x74}, false},

    // Comment: appending 0's to sequence
    // tcID: 623
    {SEC_OID_SHA256,
     623,
     {0x30, 0x3f, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4,
      0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58,
      0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93,
      0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4,
      0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38,
      0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16, 0x00, 0x00},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: prepending 0's to sequence
    // tcID: 624
    {SEC_OID_SHA256,
     624,
     {0x30, 0x3f, 0x00, 0x00, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1,
      0xcb, 0xd4, 0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13,
      0x0a, 0x58, 0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5,
      0xee, 0x93, 0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f,
      0xad, 0xe4, 0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48,
      0x0c, 0x38, 0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: appending unused 0's to sequence
    // tcID: 625
    {SEC_OID_SHA256,
     625,
     {0x30, 0x3d, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4,
      0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58,
      0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93,
      0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4,
      0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38,
      0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16, 0x00, 0x00},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: appending null value to sequence
    // tcID: 626
    {SEC_OID_SHA256,
     626,
     {0x30, 0x3f, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4,
      0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58,
      0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93,
      0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4,
      0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38,
      0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16, 0x05, 0x00},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: including garbage
    // tcID: 627
    {SEC_OID_SHA256,
     627,
     {0x30, 0x42, 0x49, 0x81, 0x77, 0x30, 0x3d, 0x02, 0x1d, 0x00, 0x9b, 0x6f,
      0xe4, 0xa1, 0xcb, 0xd4, 0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3,
      0x13, 0x0a, 0x58, 0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5,
      0xee, 0x93, 0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad,
      0xe4, 0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38,
      0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: including garbage
    // tcID: 628
    {SEC_OID_SHA256,
     628,
     {0x30, 0x41, 0x25, 0x00, 0x30, 0x3d, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4,
      0xa1, 0xcb, 0xd4, 0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13,
      0x0a, 0x58, 0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee,
      0x93, 0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4,
      0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38, 0x6c,
      0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: including garbage
    // tcID: 629
    {SEC_OID_SHA256,
     629,
     {0x30, 0x3f, 0x30, 0x3d, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb,
      0xd4, 0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58,
      0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93, 0x02,
      0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4, 0x14, 0x2c,
      0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38, 0x6c, 0x06, 0x2b,
      0x38, 0xfb, 0x42, 0xb1, 0x16, 0x00, 0x04, 0xde, 0xad, 0xbe, 0xef},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: including garbage
    // tcID: 630
    {SEC_OID_SHA256,
     630,
     {0x30, 0x42, 0x22, 0x22, 0x49, 0x81, 0x77, 0x02, 0x1d, 0x00, 0x9b, 0x6f,
      0xe4, 0xa1, 0xcb, 0xd4, 0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3,
      0x13, 0x0a, 0x58, 0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5,
      0xee, 0x93, 0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad,
      0xe4, 0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38,
      0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: including garbage
    // tcID: 631
    {SEC_OID_SHA256,
     631,
     {0x30, 0x41, 0x22, 0x21, 0x25, 0x00, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4,
      0xa1, 0xcb, 0xd4, 0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13,
      0x0a, 0x58, 0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee,
      0x93, 0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4,
      0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38, 0x6c,
      0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: including garbage
    // tcID: 632
    {SEC_OID_SHA256,
     632,
     {0x30, 0x45, 0x22, 0x1f, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb,
      0xd4, 0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58,
      0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93, 0x00,
      0x04, 0xde, 0xad, 0xbe, 0xef, 0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11,
      0xd6, 0x8f, 0xad, 0xe4, 0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70,
      0x48, 0x0c, 0x38, 0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: including garbage
    // tcID: 633
    {SEC_OID_SHA256,
     633,
     {0x30, 0x42, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4, 0x46,
      0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58, 0x0e, 0x61,
      0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93, 0x22, 0x21, 0x49,
      0x81, 0x77, 0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad,
      0xe4, 0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38,
      0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: including garbage
    // tcID: 634
    {SEC_OID_SHA256,
     634,
     {0x30, 0x41, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4, 0x46,
      0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58, 0x0e, 0x61,
      0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93, 0x22, 0x20, 0x25,
      0x00, 0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4,
      0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38, 0x6c,
      0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: including garbage
    // tcID: 635
    {SEC_OID_SHA256,
     635,
     {0x30, 0x45, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4, 0x46,
      0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58, 0x0e, 0x61,
      0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93, 0x22, 0x1e, 0x02,
      0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4, 0x14, 0x2c,
      0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38, 0x6c, 0x06, 0x2b,
      0x38, 0xfb, 0x42, 0xb1, 0x16, 0x00, 0x04, 0xde, 0xad, 0xbe, 0xef},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: including undefined tags
    // tcID: 636
    {SEC_OID_SHA256,
     636,
     {0x30, 0x45, 0xaa, 0x00, 0xbb, 0x00, 0xcd, 0x00, 0x30, 0x3d, 0x02, 0x1d,
      0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4, 0x46, 0x7d, 0x75, 0x84, 0xae,
      0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58, 0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06,
      0x73, 0x73, 0xd5, 0xee, 0x93, 0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11,
      0xd6, 0x8f, 0xad, 0xe4, 0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70,
      0x48, 0x0c, 0x38, 0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: including undefined tags
    // tcID: 637
    {SEC_OID_SHA256,
     637,
     {0x30, 0x43, 0xaa, 0x02, 0xaa, 0xbb, 0x30, 0x3d, 0x02, 0x1d, 0x00, 0x9b,
      0x6f, 0xe4, 0xa1, 0xcb, 0xd4, 0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a,
      0xe3, 0x13, 0x0a, 0x58, 0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73,
      0xd5, 0xee, 0x93, 0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f,
      0xad, 0xe4, 0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c,
      0x38, 0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: including undefined tags
    // tcID: 638
    {SEC_OID_SHA256,
     638,
     {0x30, 0x45, 0x22, 0x25, 0xaa, 0x00, 0xbb, 0x00, 0xcd, 0x00, 0x02, 0x1d,
      0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4, 0x46, 0x7d, 0x75, 0x84, 0xae,
      0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58, 0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06,
      0x73, 0x73, 0xd5, 0xee, 0x93, 0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11,
      0xd6, 0x8f, 0xad, 0xe4, 0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70,
      0x48, 0x0c, 0x38, 0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: including undefined tags
    // tcID: 639
    {SEC_OID_SHA256,
     639,
     {0x30, 0x43, 0x22, 0x23, 0xaa, 0x02, 0xaa, 0xbb, 0x02, 0x1d, 0x00, 0x9b,
      0x6f, 0xe4, 0xa1, 0xcb, 0xd4, 0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a,
      0xe3, 0x13, 0x0a, 0x58, 0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73,
      0xd5, 0xee, 0x93, 0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f,
      0xad, 0xe4, 0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c,
      0x38, 0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: including undefined tags
    // tcID: 640
    {SEC_OID_SHA256,
     640,
     {0x30, 0x45, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4, 0x46,
      0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58, 0x0e, 0x61,
      0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93, 0x22, 0x24, 0xaa,
      0x00, 0xbb, 0x00, 0xcd, 0x00, 0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11,
      0xd6, 0x8f, 0xad, 0xe4, 0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70,
      0x48, 0x0c, 0x38, 0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: including undefined tags
    // tcID: 641
    {SEC_OID_SHA256,
     641,
     {0x30, 0x43, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4, 0x46,
      0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58, 0x0e, 0x61,
      0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93, 0x22, 0x22, 0xaa,
      0x02, 0xaa, 0xbb, 0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f,
      0xad, 0xe4, 0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c,
      0x38, 0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: truncated length of sequence
    // tcID: 642
    {SEC_OID_SHA256,
     642,
     {0x30, 0x81},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: using composition with indefinite length
    // tcID: 643
    {SEC_OID_SHA256,
     643,
     {0x30, 0x80, 0x30, 0x3d, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb,
      0xd4, 0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58,
      0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93, 0x02,
      0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4, 0x14, 0x2c,
      0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38, 0x6c, 0x06, 0x2b,
      0x38, 0xfb, 0x42, 0xb1, 0x16, 0x00, 0x00},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: using composition with indefinite length
    // tcID: 644
    {SEC_OID_SHA256,
     644,
     {0x30, 0x41, 0x22, 0x80, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb,
      0xd4, 0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58,
      0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93, 0x00,
      0x00, 0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4,
      0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38, 0x6c,
      0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: using composition with indefinite length
    // tcID: 645
    {SEC_OID_SHA256,
     645,
     {0x30, 0x41, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4, 0x46,
      0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58, 0x0e, 0x61,
      0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93, 0x22, 0x80, 0x02,
      0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4, 0x14, 0x2c,
      0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38, 0x6c, 0x06, 0x2b,
      0x38, 0xfb, 0x42, 0xb1, 0x16, 0x00, 0x00},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: using composition with wrong tag
    // tcID: 646
    {SEC_OID_SHA256,
     646,
     {0x30, 0x80, 0x31, 0x3d, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb,
      0xd4, 0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58,
      0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93, 0x02,
      0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4, 0x14, 0x2c,
      0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38, 0x6c, 0x06, 0x2b,
      0x38, 0xfb, 0x42, 0xb1, 0x16, 0x00, 0x00},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: using composition with wrong tag
    // tcID: 647
    {SEC_OID_SHA256,
     647,
     {0x30, 0x41, 0x22, 0x80, 0x03, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb,
      0xd4, 0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58,
      0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93, 0x00,
      0x00, 0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4,
      0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38, 0x6c,
      0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: using composition with wrong tag
    // tcID: 648
    {SEC_OID_SHA256,
     648,
     {0x30, 0x41, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4, 0x46,
      0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58, 0x0e, 0x61,
      0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93, 0x22, 0x80, 0x03,
      0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4, 0x14, 0x2c,
      0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38, 0x6c, 0x06, 0x2b,
      0x38, 0xfb, 0x42, 0xb1, 0x16, 0x00, 0x00},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Replacing sequence with NULL
    // tcID: 649
    {SEC_OID_SHA256,
     649,
     {0x05, 0x00},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: changing tag value of sequence
    // tcID: 650
    {SEC_OID_SHA256,
     650,
     {0x2e, 0x3d, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4,
      0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58,
      0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93,
      0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4,
      0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38,
      0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: changing tag value of sequence
    // tcID: 651
    {SEC_OID_SHA256,
     651,
     {0x2f, 0x3d, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4,
      0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58,
      0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93,
      0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4,
      0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38,
      0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: changing tag value of sequence
    // tcID: 652
    {SEC_OID_SHA256,
     652,
     {0x31, 0x3d, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4,
      0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58,
      0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93,
      0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4,
      0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38,
      0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: changing tag value of sequence
    // tcID: 653
    {SEC_OID_SHA256,
     653,
     {0x32, 0x3d, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4,
      0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58,
      0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93,
      0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4,
      0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38,
      0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: changing tag value of sequence
    // tcID: 654
    {SEC_OID_SHA256,
     654,
     {0xff, 0x3d, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4,
      0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58,
      0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93,
      0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4,
      0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38,
      0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: dropping value of sequence
    // tcID: 655
    {SEC_OID_SHA256,
     655,
     {0x30, 0x00},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: using composition for sequence
    // tcID: 656
    {SEC_OID_SHA256,
     656,
     {0x30, 0x41, 0x30, 0x01, 0x02, 0x30, 0x3c, 0x1d, 0x00, 0x9b, 0x6f, 0xe4,
      0xa1, 0xcb, 0xd4, 0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13,
      0x0a, 0x58, 0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee,
      0x93, 0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4,
      0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38, 0x6c,
      0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: truncated sequence
    // tcID: 657
    {SEC_OID_SHA256,
     657,
     {0x30, 0x3c, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4,
      0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58,
      0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93,
      0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4,
      0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38,
      0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: truncated sequence
    // tcID: 658
    {SEC_OID_SHA256,
     658,
     {0x30, 0x3c, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4, 0x46,
      0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58, 0x0e,
      0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93, 0x02,
      0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4, 0x14,
      0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38, 0x6c,
      0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: indefinite length
    // tcID: 659
    {SEC_OID_SHA256,
     659,
     {0x30, 0x80, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4,
      0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58,
      0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93,
      0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4,
      0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38,
      0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16, 0x00, 0x00},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: indefinite length with truncated delimiter
    // tcID: 660
    {SEC_OID_SHA256,
     660,
     {0x30, 0x80, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4,
      0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58,
      0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93,
      0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4,
      0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38,
      0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16, 0x00},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: indefinite length with additional element
    // tcID: 661
    {SEC_OID_SHA256,
     661,
     {0x30, 0x80, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4, 0x46,
      0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58, 0x0e, 0x61,
      0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93, 0x02, 0x1c, 0x5f,
      0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4, 0x14, 0x2c, 0x8c, 0xf6,
      0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38, 0x6c, 0x06, 0x2b, 0x38, 0xfb,
      0x42, 0xb1, 0x16, 0x05, 0x00, 0x00, 0x00},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: indefinite length with truncated element
    // tcID: 662
    {SEC_OID_SHA256,
     662,
     {0x30, 0x80, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4, 0x46,
      0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58, 0x0e, 0x61,
      0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93, 0x02, 0x1c, 0x5f,
      0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4, 0x14, 0x2c, 0x8c, 0xf6,
      0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38, 0x6c, 0x06, 0x2b, 0x38, 0xfb,
      0x42, 0xb1, 0x16, 0x06, 0x08, 0x11, 0x22, 0x00, 0x00},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: indefinite length with garbage
    // tcID: 663
    {SEC_OID_SHA256,
     663,
     {0x30, 0x80, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4, 0x46,
      0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58, 0x0e, 0x61,
      0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93, 0x02, 0x1c, 0x5f,
      0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4, 0x14, 0x2c, 0x8c, 0xf6,
      0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38, 0x6c, 0x06, 0x2b, 0x38, 0xfb,
      0x42, 0xb1, 0x16, 0x00, 0x00, 0xfe, 0x02, 0xbe, 0xef},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: indefinite length with nonempty EOC
    // tcID: 664
    {SEC_OID_SHA256,
     664,
     {0x30, 0x80, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4, 0x46,
      0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58, 0x0e, 0x61,
      0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93, 0x02, 0x1c, 0x5f,
      0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4, 0x14, 0x2c, 0x8c, 0xf6,
      0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38, 0x6c, 0x06, 0x2b, 0x38, 0xfb,
      0x42, 0xb1, 0x16, 0x00, 0x02, 0xbe, 0xef},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: prepend empty sequence
    // tcID: 665
    {SEC_OID_SHA256,
     665,
     {0x30, 0x3f, 0x30, 0x00, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1,
      0xcb, 0xd4, 0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13,
      0x0a, 0x58, 0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5,
      0xee, 0x93, 0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f,
      0xad, 0xe4, 0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48,
      0x0c, 0x38, 0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: append empty sequence
    // tcID: 666
    {SEC_OID_SHA256,
     666,
     {0x30, 0x3f, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4,
      0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58,
      0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93,
      0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4,
      0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38,
      0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16, 0x30, 0x00},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: append garbage with high tag number
    // tcID: 667
    {SEC_OID_SHA256,
     667,
     {0x30, 0x40, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4,
      0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58,
      0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93,
      0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4,
      0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38,
      0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16, 0xbf, 0x7f, 0x00},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: sequence of sequence
    // tcID: 668
    {SEC_OID_SHA256,
     668,
     {0x30, 0x3f, 0x30, 0x3d, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1,
      0xcb, 0xd4, 0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13,
      0x0a, 0x58, 0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5,
      0xee, 0x93, 0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f,
      0xad, 0xe4, 0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48,
      0x0c, 0x38, 0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: truncated sequence: removed last 1 elements
    // tcID: 669
    {SEC_OID_SHA256,
     669,
     {0x30, 0x1f, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4,
      0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58,
      0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: repeating element in sequence
    // tcID: 670
    {SEC_OID_SHA256,
     670,
     {0x30, 0x5b, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4, 0x46,
      0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58, 0x0e, 0x61,
      0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93, 0x02, 0x1c, 0x5f,
      0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4, 0x14, 0x2c, 0x8c, 0xf6,
      0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38, 0x6c, 0x06, 0x2b, 0x38, 0xfb,
      0x42, 0xb1, 0x16, 0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f,
      0xad, 0xe4, 0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c,
      0x38, 0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: long form encoding of length of integer
    // tcID: 671
    {SEC_OID_SHA256,
     671,
     {0x30, 0x3e, 0x02, 0x81, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb,
      0xd4, 0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a,
      0x58, 0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee,
      0x93, 0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad,
      0xe4, 0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c,
      0x38, 0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: long form encoding of length of integer
    // tcID: 672
    {SEC_OID_SHA256,
     672,
     {0x30, 0x3e, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4,
      0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58,
      0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93,
      0x02, 0x81, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad,
      0xe4, 0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c,
      0x38, 0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: length of integer contains leading 0
    // tcID: 673
    {SEC_OID_SHA256,
     673,
     {0x30, 0x3f, 0x02, 0x82, 0x00, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1,
      0xcb, 0xd4, 0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13,
      0x0a, 0x58, 0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5,
      0xee, 0x93, 0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f,
      0xad, 0xe4, 0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48,
      0x0c, 0x38, 0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: length of integer contains leading 0
    // tcID: 674
    {SEC_OID_SHA256,
     674,
     {0x30, 0x3f, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4,
      0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58,
      0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93,
      0x02, 0x82, 0x00, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f,
      0xad, 0xe4, 0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48,
      0x0c, 0x38, 0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: wrong length of integer
    // tcID: 675
    {SEC_OID_SHA256,
     675,
     {0x30, 0x3d, 0x02, 0x1e, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4,
      0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58,
      0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93,
      0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4,
      0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38,
      0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: wrong length of integer
    // tcID: 676
    {SEC_OID_SHA256,
     676,
     {0x30, 0x3d, 0x02, 0x1c, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4,
      0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58,
      0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93,
      0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4,
      0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38,
      0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: wrong length of integer
    // tcID: 677
    {SEC_OID_SHA256,
     677,
     {0x30, 0x3d, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4,
      0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58,
      0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93,
      0x02, 0x1d, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4,
      0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38,
      0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: wrong length of integer
    // tcID: 678
    {SEC_OID_SHA256,
     678,
     {0x30, 0x3d, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4,
      0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58,
      0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93,
      0x02, 0x1b, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4,
      0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38,
      0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: uint32 overflow in length of integer
    // tcID: 679
    {SEC_OID_SHA256,
     679,
     {0x30, 0x42, 0x02, 0x85, 0x01, 0x00, 0x00, 0x00, 0x1d, 0x00, 0x9b, 0x6f,
      0xe4, 0xa1, 0xcb, 0xd4, 0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3,
      0x13, 0x0a, 0x58, 0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5,
      0xee, 0x93, 0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad,
      0xe4, 0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38,
      0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: uint32 overflow in length of integer
    // tcID: 680
    {SEC_OID_SHA256,
     680,
     {0x30, 0x42, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4, 0x46,
      0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58, 0x0e, 0x61,
      0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93, 0x02, 0x85, 0x01,
      0x00, 0x00, 0x00, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad,
      0xe4, 0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38,
      0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: uint64 overflow in length of integer
    // tcID: 681
    {SEC_OID_SHA256,
     681,
     {0x30, 0x46, 0x02, 0x89, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4, 0x46, 0x7d, 0x75, 0x84,
      0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58, 0x0e, 0x61, 0xb9, 0x69, 0xa6,
      0x06, 0x73, 0x73, 0xd5, 0xee, 0x93, 0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47,
      0x11, 0xd6, 0x8f, 0xad, 0xe4, 0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54,
      0x70, 0x48, 0x0c, 0x38, 0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: uint64 overflow in length of integer
    // tcID: 682
    {SEC_OID_SHA256,
     682,
     {0x30, 0x46, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4, 0x46,
      0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58, 0x0e, 0x61,
      0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93, 0x02, 0x89, 0x01,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x5f, 0xe8, 0x23, 0x47,
      0x11, 0xd6, 0x8f, 0xad, 0xe4, 0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54,
      0x70, 0x48, 0x0c, 0x38, 0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: length of integer = 2**31 - 1
    // tcID: 683
    {SEC_OID_SHA256,
     683,
     {0x30, 0x41, 0x02, 0x84, 0x7f, 0xff, 0xff, 0xff, 0x00, 0x9b, 0x6f, 0xe4,
      0xa1, 0xcb, 0xd4, 0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13,
      0x0a, 0x58, 0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee,
      0x93, 0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4,
      0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38, 0x6c,
      0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: length of integer = 2**31 - 1
    // tcID: 684
    {SEC_OID_SHA256,
     684,
     {0x30, 0x41, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4, 0x46,
      0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58, 0x0e, 0x61,
      0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93, 0x02, 0x84, 0x7f,
      0xff, 0xff, 0xff, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4,
      0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38, 0x6c,
      0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: length of integer = 2**32 - 1
    // tcID: 685
    {SEC_OID_SHA256,
     685,
     {0x30, 0x41, 0x02, 0x84, 0xff, 0xff, 0xff, 0xff, 0x00, 0x9b, 0x6f, 0xe4,
      0xa1, 0xcb, 0xd4, 0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13,
      0x0a, 0x58, 0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee,
      0x93, 0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4,
      0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38, 0x6c,
      0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: length of integer = 2**32 - 1
    // tcID: 686
    {SEC_OID_SHA256,
     686,
     {0x30, 0x41, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4, 0x46,
      0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58, 0x0e, 0x61,
      0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93, 0x02, 0x84, 0xff,
      0xff, 0xff, 0xff, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4,
      0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38, 0x6c,
      0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: length of integer = 2**40 - 1
    // tcID: 687
    {SEC_OID_SHA256,
     687,
     {0x30, 0x42, 0x02, 0x85, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x9b, 0x6f,
      0xe4, 0xa1, 0xcb, 0xd4, 0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3,
      0x13, 0x0a, 0x58, 0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5,
      0xee, 0x93, 0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad,
      0xe4, 0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38,
      0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: length of integer = 2**40 - 1
    // tcID: 688
    {SEC_OID_SHA256,
     688,
     {0x30, 0x42, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4, 0x46,
      0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58, 0x0e, 0x61,
      0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93, 0x02, 0x85, 0xff,
      0xff, 0xff, 0xff, 0xff, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad,
      0xe4, 0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38,
      0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: length of integer = 2**64 - 1
    // tcID: 689
    {SEC_OID_SHA256,
     689,
     {0x30, 0x45, 0x02, 0x88, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4, 0x46, 0x7d, 0x75, 0x84, 0xae,
      0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58, 0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06,
      0x73, 0x73, 0xd5, 0xee, 0x93, 0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11,
      0xd6, 0x8f, 0xad, 0xe4, 0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70,
      0x48, 0x0c, 0x38, 0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: length of integer = 2**64 - 1
    // tcID: 690
    {SEC_OID_SHA256,
     690,
     {0x30, 0x45, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4, 0x46,
      0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58, 0x0e, 0x61,
      0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93, 0x02, 0x88, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5f, 0xe8, 0x23, 0x47, 0x11,
      0xd6, 0x8f, 0xad, 0xe4, 0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70,
      0x48, 0x0c, 0x38, 0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: incorrect length of integer
    // tcID: 691
    {SEC_OID_SHA256,
     691,
     {0x30, 0x3d, 0x02, 0xff, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4,
      0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58,
      0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93,
      0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4,
      0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38,
      0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: incorrect length of integer
    // tcID: 692
    {SEC_OID_SHA256,
     692,
     {0x30, 0x3d, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4,
      0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58,
      0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93,
      0x02, 0xff, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4,
      0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38,
      0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: removing integer
    // tcID: 693
    {SEC_OID_SHA256,
     693,
     {0x30, 0x1e, 0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f,
      0xad, 0xe4, 0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48,
      0x0c, 0x38, 0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: lonely integer tag
    // tcID: 694
    {SEC_OID_SHA256,
     694,
     {0x30, 0x1f, 0x02, 0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6,
      0x8f, 0xad, 0xe4, 0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70,
      0x48, 0x0c, 0x38, 0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: lonely integer tag
    // tcID: 695
    {SEC_OID_SHA256,
     695,
     {0x30, 0x20, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4, 0x46,
      0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58, 0x0e, 0x61,
      0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93, 0x02},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: appending 0's to integer
    // tcID: 696
    {SEC_OID_SHA256,
     696,
     {0x30, 0x3f, 0x02, 0x1f, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4,
      0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58,
      0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93,
      0x00, 0x00, 0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f,
      0xad, 0xe4, 0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48,
      0x0c, 0x38, 0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: appending 0's to integer
    // tcID: 697
    {SEC_OID_SHA256,
     697,
     {0x30, 0x3f, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4,
      0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58,
      0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93,
      0x02, 0x1e, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4,
      0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38,
      0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16, 0x00, 0x00},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: prepending 0's to integer
    // tcID: 698
    {SEC_OID_SHA256,
     698,
     {0x30, 0x3f, 0x02, 0x1f, 0x00, 0x00, 0x00, 0x9b, 0x6f, 0xe4, 0xa1,
      0xcb, 0xd4, 0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13,
      0x0a, 0x58, 0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5,
      0xee, 0x93, 0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f,
      0xad, 0xe4, 0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48,
      0x0c, 0x38, 0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: prepending 0's to integer
    // tcID: 699
    {SEC_OID_SHA256,
     699,
     {0x30, 0x3f, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4,
      0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58,
      0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93,
      0x02, 0x1e, 0x00, 0x00, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f,
      0xad, 0xe4, 0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48,
      0x0c, 0x38, 0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: appending unused 0's to integer
    // tcID: 700
    {SEC_OID_SHA256,
     700,
     {0x30, 0x3f, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4,
      0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58,
      0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93,
      0x00, 0x00, 0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f,
      0xad, 0xe4, 0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48,
      0x0c, 0x38, 0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: appending null value to integer
    // tcID: 701
    {SEC_OID_SHA256,
     701,
     {0x30, 0x3f, 0x02, 0x1f, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4,
      0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58,
      0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93,
      0x05, 0x00, 0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f,
      0xad, 0xe4, 0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48,
      0x0c, 0x38, 0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: appending null value to integer
    // tcID: 702
    {SEC_OID_SHA256,
     702,
     {0x30, 0x3f, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4,
      0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58,
      0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93,
      0x02, 0x1e, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4,
      0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38,
      0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16, 0x05, 0x00},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: truncated length of integer
    // tcID: 703
    {SEC_OID_SHA256,
     703,
     {0x30, 0x20, 0x02, 0x81, 0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6,
      0x8f, 0xad, 0xe4, 0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48,
      0x0c, 0x38, 0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: truncated length of integer
    // tcID: 704
    {SEC_OID_SHA256,
     704,
     {0x30, 0x21, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4, 0x46,
      0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58, 0x0e, 0x61,
      0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93, 0x02, 0x81},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Replacing integer with NULL
    // tcID: 705
    {SEC_OID_SHA256,
     705,
     {0x30, 0x20, 0x05, 0x00, 0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6,
      0x8f, 0xad, 0xe4, 0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48,
      0x0c, 0x38, 0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Replacing integer with NULL
    // tcID: 706
    {SEC_OID_SHA256,
     706,
     {0x30, 0x21, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4, 0x46,
      0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58, 0x0e, 0x61,
      0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93, 0x05, 0x00},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: changing tag value of integer
    // tcID: 707
    {SEC_OID_SHA256,
     707,
     {0x30, 0x3d, 0x00, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4,
      0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58,
      0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93,
      0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4,
      0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38,
      0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: changing tag value of integer
    // tcID: 708
    {SEC_OID_SHA256,
     708,
     {0x30, 0x3d, 0x01, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4,
      0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58,
      0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93,
      0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4,
      0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38,
      0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: changing tag value of integer
    // tcID: 709
    {SEC_OID_SHA256,
     709,
     {0x30, 0x3d, 0x03, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4,
      0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58,
      0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93,
      0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4,
      0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38,
      0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: changing tag value of integer
    // tcID: 710
    {SEC_OID_SHA256,
     710,
     {0x30, 0x3d, 0x04, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4,
      0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58,
      0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93,
      0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4,
      0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38,
      0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: changing tag value of integer
    // tcID: 711
    {SEC_OID_SHA256,
     711,
     {0x30, 0x3d, 0xff, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4,
      0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58,
      0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93,
      0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4,
      0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38,
      0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: changing tag value of integer
    // tcID: 712
    {SEC_OID_SHA256,
     712,
     {0x30, 0x3d, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4,
      0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58,
      0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93,
      0x00, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4,
      0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38,
      0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: changing tag value of integer
    // tcID: 713
    {SEC_OID_SHA256,
     713,
     {0x30, 0x3d, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4,
      0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58,
      0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93,
      0x01, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4,
      0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38,
      0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: changing tag value of integer
    // tcID: 714
    {SEC_OID_SHA256,
     714,
     {0x30, 0x3d, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4,
      0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58,
      0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93,
      0x03, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4,
      0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38,
      0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: changing tag value of integer
    // tcID: 715
    {SEC_OID_SHA256,
     715,
     {0x30, 0x3d, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4,
      0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58,
      0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93,
      0x04, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4,
      0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38,
      0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: changing tag value of integer
    // tcID: 716
    {SEC_OID_SHA256,
     716,
     {0x30, 0x3d, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4,
      0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58,
      0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93,
      0xff, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4,
      0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38,
      0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: dropping value of integer
    // tcID: 717
    {SEC_OID_SHA256,
     717,
     {0x30, 0x20, 0x02, 0x00, 0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6,
      0x8f, 0xad, 0xe4, 0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48,
      0x0c, 0x38, 0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: dropping value of integer
    // tcID: 718
    {SEC_OID_SHA256,
     718,
     {0x30, 0x21, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4, 0x46,
      0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58, 0x0e, 0x61,
      0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93, 0x02, 0x00},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: using composition for integer
    // tcID: 719
    {SEC_OID_SHA256,
     719,
     {0x30, 0x41, 0x22, 0x21, 0x02, 0x01, 0x00, 0x02, 0x1c, 0x9b, 0x6f, 0xe4,
      0xa1, 0xcb, 0xd4, 0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13,
      0x0a, 0x58, 0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee,
      0x93, 0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4,
      0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38, 0x6c,
      0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: using composition for integer
    // tcID: 720
    {SEC_OID_SHA256,
     720,
     {0x30, 0x41, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4, 0x46,
      0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58, 0x0e, 0x61,
      0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93, 0x22, 0x20, 0x02,
      0x01, 0x5f, 0x02, 0x1b, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4,
      0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38, 0x6c,
      0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: modify first byte of integer
    // tcID: 721
    {SEC_OID_SHA256,
     721,
     {0x30, 0x3d, 0x02, 0x1d, 0x02, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4,
      0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58,
      0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93,
      0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4,
      0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38,
      0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: modify first byte of integer
    // tcID: 722
    {SEC_OID_SHA256,
     722,
     {0x30, 0x3d, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4,
      0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58,
      0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93,
      0x02, 0x1c, 0x5d, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4,
      0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38,
      0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: modify last byte of integer
    // tcID: 723
    {SEC_OID_SHA256,
     723,
     {0x30, 0x3d, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4,
      0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58,
      0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x13,
      0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4,
      0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38,
      0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: modify last byte of integer
    // tcID: 724
    {SEC_OID_SHA256,
     724,
     {0x30, 0x3d, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4,
      0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58,
      0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93,
      0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4,
      0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38,
      0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x96},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: truncated integer
    // tcID: 725
    {SEC_OID_SHA256,
     725,
     {0x30, 0x3c, 0x02, 0x1c, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4,
      0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58,
      0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x02,
      0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4, 0x14,
      0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38, 0x6c,
      0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: truncated integer
    // tcID: 726
    {SEC_OID_SHA256,
     726,
     {0x30, 0x3c, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4,
      0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58,
      0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93,
      0x02, 0x1b, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4,
      0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38,
      0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: truncated integer
    // tcID: 727
    {SEC_OID_SHA256,
     727,
     {0x30, 0x3c, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4,
      0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58,
      0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93,
      0x02, 0x1b, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4, 0x14,
      0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38, 0x6c,
      0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: leading ff in integer
    // tcID: 728
    {SEC_OID_SHA256,
     728,
     {0x30, 0x3e, 0x02, 0x1e, 0xff, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb,
      0xd4, 0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a,
      0x58, 0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee,
      0x93, 0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad,
      0xe4, 0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c,
      0x38, 0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: leading ff in integer
    // tcID: 729
    {SEC_OID_SHA256,
     729,
     {0x30, 0x3e, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4,
      0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58,
      0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93,
      0x02, 0x1d, 0xff, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad,
      0xe4, 0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c,
      0x38, 0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: replaced integer by infinity
    // tcID: 730
    {SEC_OID_SHA256,
     730,
     {0x30, 0x21, 0x09, 0x01, 0x80, 0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11,
      0xd6, 0x8f, 0xad, 0xe4, 0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70,
      0x48, 0x0c, 0x38, 0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: replaced integer by infinity
    // tcID: 731
    {SEC_OID_SHA256,
     731,
     {0x30, 0x22, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4, 0x46,
      0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58, 0x0e, 0x61,
      0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93, 0x09, 0x01, 0x80},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: replacing integer with zero
    // tcID: 732
    {SEC_OID_SHA256,
     732,
     {0x30, 0x21, 0x02, 0x01, 0x00, 0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11,
      0xd6, 0x8f, 0xad, 0xe4, 0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70,
      0x48, 0x0c, 0x38, 0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: replacing integer with zero
    // tcID: 733
    {SEC_OID_SHA256,
     733,
     {0x30, 0x22, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4, 0x46,
      0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58, 0x0e, 0x61,
      0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93, 0x02, 0x01, 0x00},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the group order
    // tcID: 734
    {SEC_OID_SHA256,
     734,
     {0x30, 0x3d, 0x02, 0x1d, 0x01, 0x56, 0x66, 0x7b, 0x48, 0x51, 0x4d,
      0x3e, 0x5d, 0x54, 0x6c, 0xa8, 0x9f, 0xf4, 0x5a, 0xda, 0x90, 0x47,
      0x41, 0x13, 0xed, 0x24, 0x8b, 0x87, 0x34, 0x30, 0xab, 0x57, 0xf0,
      0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4,
      0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38,
      0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the group order
    // tcID: 735
    {SEC_OID_SHA256,
     735,
     {0x30, 0x3c, 0x02, 0x1c, 0xe0, 0x79, 0x4d, 0xfb, 0x46, 0x5b, 0x4e,
      0x9d, 0x96, 0x9c, 0xb3, 0xd0, 0x61, 0x6b, 0x4b, 0x84, 0x68, 0xdb,
      0xaf, 0x85, 0xae, 0xc0, 0x85, 0xb2, 0xb7, 0x00, 0x85, 0x36, 0x02,
      0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4, 0x14,
      0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38, 0x6c,
      0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the group order
    // tcID: 736
    {SEC_OID_SHA256,
     736,
     {0x30, 0x3d, 0x02, 0x1d, 0xff, 0x64, 0x90, 0x1b, 0x5e, 0x34, 0x2b,
      0xb9, 0x82, 0x8a, 0x7b, 0x51, 0xc7, 0xd5, 0x1c, 0xec, 0xf5, 0xa7,
      0xf1, 0x9e, 0x46, 0x96, 0x59, 0xf9, 0x8c, 0x8c, 0x2a, 0x11, 0x6d,
      0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4,
      0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38,
      0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the group order
    // tcID: 737
    {SEC_OID_SHA256,
     737,
     {0x30, 0x3c, 0x02, 0x1c, 0x1f, 0x86, 0xb2, 0x04, 0xb9, 0xa4, 0xb1,
      0x62, 0x69, 0x63, 0x4c, 0x2f, 0x9e, 0x94, 0xb4, 0x7b, 0x97, 0x24,
      0x50, 0x7a, 0x51, 0x3f, 0x7a, 0x4d, 0x48, 0xff, 0x7a, 0xca, 0x02,
      0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4, 0x14,
      0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38, 0x6c,
      0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the group order
    // tcID: 738
    {SEC_OID_SHA256,
     738,
     {0x30, 0x3d, 0x02, 0x1d, 0xfe, 0xa9, 0x99, 0x84, 0xb7, 0xae, 0xb2,
      0xc1, 0xa2, 0xab, 0x93, 0x57, 0x60, 0x0b, 0xa5, 0x25, 0x6f, 0xb8,
      0xbe, 0xec, 0x12, 0xdb, 0x74, 0x78, 0xcb, 0xcf, 0x54, 0xa8, 0x10,
      0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4,
      0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38,
      0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the group order
    // tcID: 739
    {SEC_OID_SHA256,
     739,
     {0x30, 0x3d, 0x02, 0x1d, 0x01, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4,
      0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58,
      0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93,
      0x02, 0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4,
      0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38,
      0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the group order
    // tcID: 740
    {SEC_OID_SHA256,
     740,
     {0x30, 0x3c, 0x02, 0x1c, 0x64, 0x90, 0x1b, 0x5e, 0x34, 0x2b, 0xb9,
      0x82, 0x8a, 0x7b, 0x51, 0xc7, 0xd5, 0x1c, 0xec, 0xf5, 0xa7, 0xf1,
      0x9e, 0x46, 0x96, 0x59, 0xf9, 0x8c, 0x8c, 0x2a, 0x11, 0x6d, 0x02,
      0x1c, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad, 0xe4, 0x14,
      0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c, 0x38, 0x6c,
      0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the group order
    // tcID: 741
    {SEC_OID_SHA256,
     741,
     {0x30, 0x3e, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4,
      0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58,
      0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93,
      0x02, 0x1d, 0x01, 0x1a, 0xde, 0xb9, 0xed, 0x97, 0x4f, 0x87, 0x8d,
      0xc2, 0xfc, 0x26, 0xf4, 0xbf, 0x86, 0xff, 0xda, 0x5f, 0x7a, 0xbe,
      0x6c, 0x26, 0xeb, 0xab, 0xf9, 0xb8, 0x18, 0x1a, 0x73},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the group order
    // tcID: 742
    {SEC_OID_SHA256,
     742,
     {0x30, 0x3d, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4,
      0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58,
      0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93,
      0x02, 0x1c, 0xa4, 0xf1, 0x8c, 0xa0, 0x8c, 0x5d, 0x97, 0xce, 0x05,
      0x2c, 0x32, 0x25, 0x2c, 0x97, 0x70, 0xce, 0x81, 0x15, 0x5a, 0x04,
      0xb1, 0x20, 0xaa, 0x78, 0x3e, 0x6d, 0x47, 0xb9},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the group order
    // tcID: 743
    {SEC_OID_SHA256,
     743,
     {0x30, 0x3d, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4,
      0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58,
      0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93,
      0x02, 0x1c, 0xa0, 0x17, 0xdc, 0xb8, 0xee, 0x29, 0x70, 0x52, 0x1b,
      0xeb, 0xd3, 0x73, 0x09, 0xf0, 0xc7, 0xab, 0x8f, 0xb7, 0xf3, 0xc7,
      0x93, 0xf9, 0xd4, 0xc7, 0x04, 0xbd, 0x4e, 0xea},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the group order
    // tcID: 744
    {SEC_OID_SHA256,
     744,
     {0x30, 0x3d, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4,
      0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58,
      0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93,
      0x02, 0x1c, 0x5b, 0x0e, 0x73, 0x5f, 0x73, 0xa2, 0x68, 0x31, 0xfa,
      0xd3, 0xcd, 0xda, 0xd3, 0x68, 0x8f, 0x31, 0x7e, 0xea, 0xa5, 0xfb,
      0x4e, 0xdf, 0x55, 0x87, 0xc1, 0x92, 0xb8, 0x47},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the group order
    // tcID: 745
    {SEC_OID_SHA256,
     745,
     {0x30, 0x3e, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4,
      0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58,
      0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93,
      0x02, 0x1d, 0xfe, 0xe5, 0x21, 0x46, 0x12, 0x68, 0xb0, 0x78, 0x72,
      0x3d, 0x03, 0xd9, 0x0b, 0x40, 0x79, 0x00, 0x25, 0xa0, 0x85, 0x41,
      0x93, 0xd9, 0x14, 0x54, 0x06, 0x47, 0xe7, 0xe5, 0x8d},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the group order
    // tcID: 746
    {SEC_OID_SHA256,
     746,
     {0x30, 0x3e, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4,
      0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58,
      0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93,
      0x02, 0x1d, 0x01, 0x5f, 0xe8, 0x23, 0x47, 0x11, 0xd6, 0x8f, 0xad,
      0xe4, 0x14, 0x2c, 0x8c, 0xf6, 0x0f, 0x38, 0x54, 0x70, 0x48, 0x0c,
      0x38, 0x6c, 0x06, 0x2b, 0x38, 0xfb, 0x42, 0xb1, 0x16},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the group order
    // tcID: 747
    {SEC_OID_SHA256,
     747,
     {0x30, 0x3e, 0x02, 0x1d, 0x00, 0x9b, 0x6f, 0xe4, 0xa1, 0xcb, 0xd4,
      0x46, 0x7d, 0x75, 0x84, 0xae, 0x38, 0x2a, 0xe3, 0x13, 0x0a, 0x58,
      0x0e, 0x61, 0xb9, 0x69, 0xa6, 0x06, 0x73, 0x73, 0xd5, 0xee, 0x93,
      0x02, 0x1d, 0x00, 0xa0, 0x17, 0xdc, 0xb8, 0xee, 0x29, 0x70, 0x52,
      0x1b, 0xeb, 0xd3, 0x73, 0x09, 0xf0, 0xc7, 0xab, 0x8f, 0xb7, 0xf3,
      0xc7, 0x93, 0xf9, 0xd4, 0xc7, 0x04, 0xbd, 0x4e, 0xea},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 748
    {SEC_OID_SHA256,
     748,
     {0x30, 0x22, 0x02, 0x01, 0x00, 0x02, 0x1d, 0xff, 0x45, 0x09, 0x69, 0x59,
      0x7a, 0x87, 0x08, 0x20, 0x21, 0x18, 0x05, 0x98, 0x36, 0x88, 0x38, 0x7a,
      0x10, 0xcd, 0x4d, 0xcc, 0x45, 0x1a, 0x7f, 0x3f, 0x43, 0x2a, 0x96, 0xa3},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 749
    {SEC_OID_SHA256,
     749,
     {0x30, 0x06, 0x02, 0x01, 0x00, 0x02, 0x01, 0x00},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 750
    {SEC_OID_SHA256,
     750,
     {0x30, 0x06, 0x02, 0x01, 0x00, 0x02, 0x01, 0x01},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 751
    {SEC_OID_SHA256,
     751,
     {0x30, 0x06, 0x02, 0x01, 0x00, 0x02, 0x01, 0xff},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 752
    {SEC_OID_SHA256,
     752,
     {0x30, 0x21, 0x02, 0x01, 0x00, 0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42,
      0xbc, 0x7b, 0xef, 0xef, 0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7,
      0x99, 0x59, 0x19, 0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xae},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 753
    {SEC_OID_SHA256,
     753,
     {0x30, 0x21, 0x02, 0x01, 0x00, 0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42,
      0xbc, 0x7b, 0xef, 0xef, 0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7,
      0x99, 0x59, 0x19, 0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xaf},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 754
    {SEC_OID_SHA256,
     754,
     {0x30, 0x22, 0x02, 0x01, 0x00, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6,
      0x85, 0x78, 0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85,
      0xef, 0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5c},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 755
    {SEC_OID_SHA256,
     755,
     {0x30, 0x22, 0x02, 0x01, 0x00, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6,
      0x85, 0x78, 0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85,
      0xef, 0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5d},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 756
    {SEC_OID_SHA256,
     756,
     {0x30, 0x22, 0x02, 0x01, 0x00, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6,
      0x85, 0x78, 0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85,
      0xef, 0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5e},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 757
    {SEC_OID_SHA256,
     757,
     {0x30, 0x22, 0x02, 0x01, 0x00, 0x02, 0x1d, 0x01, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 758
    {SEC_OID_SHA256,
     758,
     {0x30, 0x82, 0x01, 0x08, 0x02, 0x01, 0x00, 0x02, 0x82, 0x01, 0x01, 0x00,
      0x8f, 0x79, 0x35, 0xd9, 0xb9, 0xaa, 0xe9, 0xbf, 0xab, 0xed, 0x88, 0x7a,
      0xcf, 0x49, 0x51, 0xb6, 0xf3, 0x2e, 0xc5, 0x9e, 0x3b, 0xaf, 0x37, 0x18,
      0xe8, 0xea, 0xc4, 0x96, 0x1f, 0x3e, 0xfd, 0x36, 0x06, 0xe7, 0x43, 0x51,
      0xa9, 0xc4, 0x18, 0x33, 0x39, 0xb8, 0x09, 0xe7, 0xc2, 0xae, 0x1c, 0x53,
      0x9b, 0xa7, 0x47, 0x5b, 0x85, 0xd0, 0x11, 0xad, 0xb8, 0xb4, 0x79, 0x87,
      0x75, 0x49, 0x84, 0x69, 0x5c, 0xac, 0x0e, 0x8f, 0x14, 0xb3, 0x36, 0x08,
      0x28, 0xa2, 0x2f, 0xfa, 0x27, 0x11, 0x0a, 0x3d, 0x62, 0xa9, 0x93, 0x45,
      0x34, 0x09, 0xa0, 0xfe, 0x69, 0x6c, 0x46, 0x58, 0xf8, 0x4b, 0xdd, 0x20,
      0x81, 0x9c, 0x37, 0x09, 0xa0, 0x10, 0x57, 0xb1, 0x95, 0xad, 0xcd, 0x00,
      0x23, 0x3d, 0xba, 0x54, 0x84, 0xb6, 0x29, 0x1f, 0x9d, 0x64, 0x8e, 0xf8,
      0x83, 0x44, 0x86, 0x77, 0x97, 0x9c, 0xec, 0x04, 0xb4, 0x34, 0xa6, 0xac,
      0x2e, 0x75, 0xe9, 0x98, 0x5d, 0xe2, 0x3d, 0xb0, 0x29, 0x2f, 0xc1, 0x11,
      0x8c, 0x9f, 0xfa, 0x9d, 0x81, 0x81, 0xe7, 0x33, 0x8d, 0xb7, 0x92, 0xb7,
      0x30, 0xd7, 0xb9, 0xe3, 0x49, 0x59, 0x2f, 0x68, 0x09, 0x98, 0x72, 0x15,
      0x39, 0x15, 0xea, 0x3d, 0x6b, 0x8b, 0x46, 0x53, 0xc6, 0x33, 0x45, 0x8f,
      0x80, 0x3b, 0x32, 0xa4, 0xc2, 0xe0, 0xf2, 0x72, 0x90, 0x25, 0x6e, 0x4e,
      0x3f, 0x8a, 0x3b, 0x08, 0x38, 0xa1, 0xc4, 0x50, 0xe4, 0xe1, 0x8c, 0x1a,
      0x29, 0xa3, 0x7d, 0xdf, 0x5e, 0xa1, 0x43, 0xde, 0x4b, 0x66, 0xff, 0x04,
      0x90, 0x3e, 0xd5, 0xcf, 0x16, 0x23, 0xe1, 0x58, 0xd4, 0x87, 0xc6, 0x08,
      0xe9, 0x7f, 0x21, 0x1c, 0xd8, 0x1d, 0xca, 0x23, 0xcb, 0x6e, 0x38, 0x07,
      0x65, 0xf8, 0x22, 0xe3, 0x42, 0xbe, 0x48, 0x4c, 0x05, 0x76, 0x39, 0x39,
      0x60, 0x1c, 0xd6, 0x67},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 759
    {SEC_OID_SHA256,
     759,
     {0x30, 0x08, 0x02, 0x01, 0x00, 0x09, 0x03, 0x80, 0xfe, 0x01},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 760
    {SEC_OID_SHA256,
     760,
     {0x30, 0x06, 0x02, 0x01, 0x00, 0x09, 0x01, 0x42},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 761
    {SEC_OID_SHA256,
     761,
     {0x30, 0x22, 0x02, 0x01, 0x01, 0x02, 0x1d, 0xff, 0x45, 0x09, 0x69, 0x59,
      0x7a, 0x87, 0x08, 0x20, 0x21, 0x18, 0x05, 0x98, 0x36, 0x88, 0x38, 0x7a,
      0x10, 0xcd, 0x4d, 0xcc, 0x45, 0x1a, 0x7f, 0x3f, 0x43, 0x2a, 0x96, 0xa3},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 762
    {SEC_OID_SHA256,
     762,
     {0x30, 0x06, 0x02, 0x01, 0x01, 0x02, 0x01, 0x00},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 763
    {SEC_OID_SHA256,
     763,
     {0x30, 0x06, 0x02, 0x01, 0x01, 0x02, 0x01, 0x01},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 764
    {SEC_OID_SHA256,
     764,
     {0x30, 0x06, 0x02, 0x01, 0x01, 0x02, 0x01, 0xff},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 765
    {SEC_OID_SHA256,
     765,
     {0x30, 0x21, 0x02, 0x01, 0x01, 0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42,
      0xbc, 0x7b, 0xef, 0xef, 0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7,
      0x99, 0x59, 0x19, 0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xae},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 766
    {SEC_OID_SHA256,
     766,
     {0x30, 0x21, 0x02, 0x01, 0x01, 0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42,
      0xbc, 0x7b, 0xef, 0xef, 0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7,
      0x99, 0x59, 0x19, 0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xaf},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 767
    {SEC_OID_SHA256,
     767,
     {0x30, 0x22, 0x02, 0x01, 0x01, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6,
      0x85, 0x78, 0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85,
      0xef, 0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5c},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 768
    {SEC_OID_SHA256,
     768,
     {0x30, 0x22, 0x02, 0x01, 0x01, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6,
      0x85, 0x78, 0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85,
      0xef, 0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5d},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 769
    {SEC_OID_SHA256,
     769,
     {0x30, 0x22, 0x02, 0x01, 0x01, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6,
      0x85, 0x78, 0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85,
      0xef, 0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5e},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 770
    {SEC_OID_SHA256,
     770,
     {0x30, 0x22, 0x02, 0x01, 0x01, 0x02, 0x1d, 0x01, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 771
    {SEC_OID_SHA256,
     771,
     {0x30, 0x82, 0x01, 0x08, 0x02, 0x01, 0x01, 0x02, 0x82, 0x01, 0x01, 0x00,
      0x8f, 0x79, 0x35, 0xd9, 0xb9, 0xaa, 0xe9, 0xbf, 0xab, 0xed, 0x88, 0x7a,
      0xcf, 0x49, 0x51, 0xb6, 0xf3, 0x2e, 0xc5, 0x9e, 0x3b, 0xaf, 0x37, 0x18,
      0xe8, 0xea, 0xc4, 0x96, 0x1f, 0x3e, 0xfd, 0x36, 0x06, 0xe7, 0x43, 0x51,
      0xa9, 0xc4, 0x18, 0x33, 0x39, 0xb8, 0x09, 0xe7, 0xc2, 0xae, 0x1c, 0x53,
      0x9b, 0xa7, 0x47, 0x5b, 0x85, 0xd0, 0x11, 0xad, 0xb8, 0xb4, 0x79, 0x87,
      0x75, 0x49, 0x84, 0x69, 0x5c, 0xac, 0x0e, 0x8f, 0x14, 0xb3, 0x36, 0x08,
      0x28, 0xa2, 0x2f, 0xfa, 0x27, 0x11, 0x0a, 0x3d, 0x62, 0xa9, 0x93, 0x45,
      0x34, 0x09, 0xa0, 0xfe, 0x69, 0x6c, 0x46, 0x58, 0xf8, 0x4b, 0xdd, 0x20,
      0x81, 0x9c, 0x37, 0x09, 0xa0, 0x10, 0x57, 0xb1, 0x95, 0xad, 0xcd, 0x00,
      0x23, 0x3d, 0xba, 0x54, 0x84, 0xb6, 0x29, 0x1f, 0x9d, 0x64, 0x8e, 0xf8,
      0x83, 0x44, 0x86, 0x77, 0x97, 0x9c, 0xec, 0x04, 0xb4, 0x34, 0xa6, 0xac,
      0x2e, 0x75, 0xe9, 0x98, 0x5d, 0xe2, 0x3d, 0xb0, 0x29, 0x2f, 0xc1, 0x11,
      0x8c, 0x9f, 0xfa, 0x9d, 0x81, 0x81, 0xe7, 0x33, 0x8d, 0xb7, 0x92, 0xb7,
      0x30, 0xd7, 0xb9, 0xe3, 0x49, 0x59, 0x2f, 0x68, 0x09, 0x98, 0x72, 0x15,
      0x39, 0x15, 0xea, 0x3d, 0x6b, 0x8b, 0x46, 0x53, 0xc6, 0x33, 0x45, 0x8f,
      0x80, 0x3b, 0x32, 0xa4, 0xc2, 0xe0, 0xf2, 0x72, 0x90, 0x25, 0x6e, 0x4e,
      0x3f, 0x8a, 0x3b, 0x08, 0x38, 0xa1, 0xc4, 0x50, 0xe4, 0xe1, 0x8c, 0x1a,
      0x29, 0xa3, 0x7d, 0xdf, 0x5e, 0xa1, 0x43, 0xde, 0x4b, 0x66, 0xff, 0x04,
      0x90, 0x3e, 0xd5, 0xcf, 0x16, 0x23, 0xe1, 0x58, 0xd4, 0x87, 0xc6, 0x08,
      0xe9, 0x7f, 0x21, 0x1c, 0xd8, 0x1d, 0xca, 0x23, 0xcb, 0x6e, 0x38, 0x07,
      0x65, 0xf8, 0x22, 0xe3, 0x42, 0xbe, 0x48, 0x4c, 0x05, 0x76, 0x39, 0x39,
      0x60, 0x1c, 0xd6, 0x67},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 772
    {SEC_OID_SHA256,
     772,
     {0x30, 0x08, 0x02, 0x01, 0x01, 0x09, 0x03, 0x80, 0xfe, 0x01},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 773
    {SEC_OID_SHA256,
     773,
     {0x30, 0x06, 0x02, 0x01, 0x01, 0x09, 0x01, 0x42},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 774
    {SEC_OID_SHA256,
     774,
     {0x30, 0x22, 0x02, 0x01, 0xff, 0x02, 0x1d, 0xff, 0x45, 0x09, 0x69, 0x59,
      0x7a, 0x87, 0x08, 0x20, 0x21, 0x18, 0x05, 0x98, 0x36, 0x88, 0x38, 0x7a,
      0x10, 0xcd, 0x4d, 0xcc, 0x45, 0x1a, 0x7f, 0x3f, 0x43, 0x2a, 0x96, 0xa3},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 775
    {SEC_OID_SHA256,
     775,
     {0x30, 0x06, 0x02, 0x01, 0xff, 0x02, 0x01, 0x00},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 776
    {SEC_OID_SHA256,
     776,
     {0x30, 0x06, 0x02, 0x01, 0xff, 0x02, 0x01, 0x01},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 777
    {SEC_OID_SHA256,
     777,
     {0x30, 0x06, 0x02, 0x01, 0xff, 0x02, 0x01, 0xff},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 778
    {SEC_OID_SHA256,
     778,
     {0x30, 0x21, 0x02, 0x01, 0xff, 0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42,
      0xbc, 0x7b, 0xef, 0xef, 0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7,
      0x99, 0x59, 0x19, 0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xae},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 779
    {SEC_OID_SHA256,
     779,
     {0x30, 0x21, 0x02, 0x01, 0xff, 0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42,
      0xbc, 0x7b, 0xef, 0xef, 0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7,
      0x99, 0x59, 0x19, 0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xaf},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 780
    {SEC_OID_SHA256,
     780,
     {0x30, 0x22, 0x02, 0x01, 0xff, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6,
      0x85, 0x78, 0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85,
      0xef, 0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5c},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 781
    {SEC_OID_SHA256,
     781,
     {0x30, 0x22, 0x02, 0x01, 0xff, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6,
      0x85, 0x78, 0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85,
      0xef, 0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5d},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 782
    {SEC_OID_SHA256,
     782,
     {0x30, 0x22, 0x02, 0x01, 0xff, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6,
      0x85, 0x78, 0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85,
      0xef, 0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5e},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 783
    {SEC_OID_SHA256,
     783,
     {0x30, 0x22, 0x02, 0x01, 0xff, 0x02, 0x1d, 0x01, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 784
    {SEC_OID_SHA256,
     784,
     {0x30, 0x82, 0x01, 0x08, 0x02, 0x01, 0xff, 0x02, 0x82, 0x01, 0x01, 0x00,
      0x8f, 0x79, 0x35, 0xd9, 0xb9, 0xaa, 0xe9, 0xbf, 0xab, 0xed, 0x88, 0x7a,
      0xcf, 0x49, 0x51, 0xb6, 0xf3, 0x2e, 0xc5, 0x9e, 0x3b, 0xaf, 0x37, 0x18,
      0xe8, 0xea, 0xc4, 0x96, 0x1f, 0x3e, 0xfd, 0x36, 0x06, 0xe7, 0x43, 0x51,
      0xa9, 0xc4, 0x18, 0x33, 0x39, 0xb8, 0x09, 0xe7, 0xc2, 0xae, 0x1c, 0x53,
      0x9b, 0xa7, 0x47, 0x5b, 0x85, 0xd0, 0x11, 0xad, 0xb8, 0xb4, 0x79, 0x87,
      0x75, 0x49, 0x84, 0x69, 0x5c, 0xac, 0x0e, 0x8f, 0x14, 0xb3, 0x36, 0x08,
      0x28, 0xa2, 0x2f, 0xfa, 0x27, 0x11, 0x0a, 0x3d, 0x62, 0xa9, 0x93, 0x45,
      0x34, 0x09, 0xa0, 0xfe, 0x69, 0x6c, 0x46, 0x58, 0xf8, 0x4b, 0xdd, 0x20,
      0x81, 0x9c, 0x37, 0x09, 0xa0, 0x10, 0x57, 0xb1, 0x95, 0xad, 0xcd, 0x00,
      0x23, 0x3d, 0xba, 0x54, 0x84, 0xb6, 0x29, 0x1f, 0x9d, 0x64, 0x8e, 0xf8,
      0x83, 0x44, 0x86, 0x77, 0x97, 0x9c, 0xec, 0x04, 0xb4, 0x34, 0xa6, 0xac,
      0x2e, 0x75, 0xe9, 0x98, 0x5d, 0xe2, 0x3d, 0xb0, 0x29, 0x2f, 0xc1, 0x11,
      0x8c, 0x9f, 0xfa, 0x9d, 0x81, 0x81, 0xe7, 0x33, 0x8d, 0xb7, 0x92, 0xb7,
      0x30, 0xd7, 0xb9, 0xe3, 0x49, 0x59, 0x2f, 0x68, 0x09, 0x98, 0x72, 0x15,
      0x39, 0x15, 0xea, 0x3d, 0x6b, 0x8b, 0x46, 0x53, 0xc6, 0x33, 0x45, 0x8f,
      0x80, 0x3b, 0x32, 0xa4, 0xc2, 0xe0, 0xf2, 0x72, 0x90, 0x25, 0x6e, 0x4e,
      0x3f, 0x8a, 0x3b, 0x08, 0x38, 0xa1, 0xc4, 0x50, 0xe4, 0xe1, 0x8c, 0x1a,
      0x29, 0xa3, 0x7d, 0xdf, 0x5e, 0xa1, 0x43, 0xde, 0x4b, 0x66, 0xff, 0x04,
      0x90, 0x3e, 0xd5, 0xcf, 0x16, 0x23, 0xe1, 0x58, 0xd4, 0x87, 0xc6, 0x08,
      0xe9, 0x7f, 0x21, 0x1c, 0xd8, 0x1d, 0xca, 0x23, 0xcb, 0x6e, 0x38, 0x07,
      0x65, 0xf8, 0x22, 0xe3, 0x42, 0xbe, 0x48, 0x4c, 0x05, 0x76, 0x39, 0x39,
      0x60, 0x1c, 0xd6, 0x67},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 785
    {SEC_OID_SHA256,
     785,
     {0x30, 0x08, 0x02, 0x01, 0xff, 0x09, 0x03, 0x80, 0xfe, 0x01},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 786
    {SEC_OID_SHA256,
     786,
     {0x30, 0x06, 0x02, 0x01, 0xff, 0x09, 0x01, 0x42},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 787
    {SEC_OID_SHA256,
     787,
     {0x30, 0x3d, 0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b,
      0xef, 0xef, 0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99,
      0x59, 0x19, 0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xae, 0x02,
      0x1d, 0xff, 0x45, 0x09, 0x69, 0x59, 0x7a, 0x87, 0x08, 0x20, 0x21,
      0x18, 0x05, 0x98, 0x36, 0x88, 0x38, 0x7a, 0x10, 0xcd, 0x4d, 0xcc,
      0x45, 0x1a, 0x7f, 0x3f, 0x43, 0x2a, 0x96, 0xa3},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 788
    {SEC_OID_SHA256,
     788,
     {0x30, 0x21, 0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b, 0xef,
      0xef, 0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99, 0x59, 0x19,
      0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xae, 0x02, 0x01, 0x00},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 789
    {SEC_OID_SHA256,
     789,
     {0x30, 0x21, 0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b, 0xef,
      0xef, 0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99, 0x59, 0x19,
      0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xae, 0x02, 0x01, 0x01},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 790
    {SEC_OID_SHA256,
     790,
     {0x30, 0x21, 0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b, 0xef,
      0xef, 0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99, 0x59, 0x19,
      0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xae, 0x02, 0x01, 0xff},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 791
    {SEC_OID_SHA256,
     791,
     {0x30, 0x3c, 0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b,
      0xef, 0xef, 0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99,
      0x59, 0x19, 0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xae, 0x02,
      0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b, 0xef, 0xef, 0x73,
      0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99, 0x59, 0x19, 0xdd,
      0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xae},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 792
    {SEC_OID_SHA256,
     792,
     {0x30, 0x3c, 0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b,
      0xef, 0xef, 0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99,
      0x59, 0x19, 0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xae, 0x02,
      0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b, 0xef, 0xef, 0x73,
      0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99, 0x59, 0x19, 0xdd,
      0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xaf},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 793
    {SEC_OID_SHA256,
     793,
     {0x30, 0x3d, 0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b,
      0xef, 0xef, 0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99,
      0x59, 0x19, 0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xae, 0x02,
      0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7, 0xdf, 0xde,
      0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2, 0x33,
      0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5c},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 794
    {SEC_OID_SHA256,
     794,
     {0x30, 0x3d, 0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b,
      0xef, 0xef, 0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99,
      0x59, 0x19, 0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xae, 0x02,
      0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7, 0xdf, 0xde,
      0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2, 0x33,
      0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5d},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 795
    {SEC_OID_SHA256,
     795,
     {0x30, 0x3d, 0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b,
      0xef, 0xef, 0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99,
      0x59, 0x19, 0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xae, 0x02,
      0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7, 0xdf, 0xde,
      0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2, 0x33,
      0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5e},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 796
    {SEC_OID_SHA256,
     796,
     {0x30, 0x3d, 0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b,
      0xef, 0xef, 0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99,
      0x59, 0x19, 0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xae, 0x02,
      0x1d, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 797
    {SEC_OID_SHA256,
     797,
     {0x30, 0x82, 0x01, 0x23, 0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc,
      0x7b, 0xef, 0xef, 0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99,
      0x59, 0x19, 0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xae, 0x02, 0x82,
      0x01, 0x01, 0x00, 0x8f, 0x79, 0x35, 0xd9, 0xb9, 0xaa, 0xe9, 0xbf, 0xab,
      0xed, 0x88, 0x7a, 0xcf, 0x49, 0x51, 0xb6, 0xf3, 0x2e, 0xc5, 0x9e, 0x3b,
      0xaf, 0x37, 0x18, 0xe8, 0xea, 0xc4, 0x96, 0x1f, 0x3e, 0xfd, 0x36, 0x06,
      0xe7, 0x43, 0x51, 0xa9, 0xc4, 0x18, 0x33, 0x39, 0xb8, 0x09, 0xe7, 0xc2,
      0xae, 0x1c, 0x53, 0x9b, 0xa7, 0x47, 0x5b, 0x85, 0xd0, 0x11, 0xad, 0xb8,
      0xb4, 0x79, 0x87, 0x75, 0x49, 0x84, 0x69, 0x5c, 0xac, 0x0e, 0x8f, 0x14,
      0xb3, 0x36, 0x08, 0x28, 0xa2, 0x2f, 0xfa, 0x27, 0x11, 0x0a, 0x3d, 0x62,
      0xa9, 0x93, 0x45, 0x34, 0x09, 0xa0, 0xfe, 0x69, 0x6c, 0x46, 0x58, 0xf8,
      0x4b, 0xdd, 0x20, 0x81, 0x9c, 0x37, 0x09, 0xa0, 0x10, 0x57, 0xb1, 0x95,
      0xad, 0xcd, 0x00, 0x23, 0x3d, 0xba, 0x54, 0x84, 0xb6, 0x29, 0x1f, 0x9d,
      0x64, 0x8e, 0xf8, 0x83, 0x44, 0x86, 0x77, 0x97, 0x9c, 0xec, 0x04, 0xb4,
      0x34, 0xa6, 0xac, 0x2e, 0x75, 0xe9, 0x98, 0x5d, 0xe2, 0x3d, 0xb0, 0x29,
      0x2f, 0xc1, 0x11, 0x8c, 0x9f, 0xfa, 0x9d, 0x81, 0x81, 0xe7, 0x33, 0x8d,
      0xb7, 0x92, 0xb7, 0x30, 0xd7, 0xb9, 0xe3, 0x49, 0x59, 0x2f, 0x68, 0x09,
      0x98, 0x72, 0x15, 0x39, 0x15, 0xea, 0x3d, 0x6b, 0x8b, 0x46, 0x53, 0xc6,
      0x33, 0x45, 0x8f, 0x80, 0x3b, 0x32, 0xa4, 0xc2, 0xe0, 0xf2, 0x72, 0x90,
      0x25, 0x6e, 0x4e, 0x3f, 0x8a, 0x3b, 0x08, 0x38, 0xa1, 0xc4, 0x50, 0xe4,
      0xe1, 0x8c, 0x1a, 0x29, 0xa3, 0x7d, 0xdf, 0x5e, 0xa1, 0x43, 0xde, 0x4b,
      0x66, 0xff, 0x04, 0x90, 0x3e, 0xd5, 0xcf, 0x16, 0x23, 0xe1, 0x58, 0xd4,
      0x87, 0xc6, 0x08, 0xe9, 0x7f, 0x21, 0x1c, 0xd8, 0x1d, 0xca, 0x23, 0xcb,
      0x6e, 0x38, 0x07, 0x65, 0xf8, 0x22, 0xe3, 0x42, 0xbe, 0x48, 0x4c, 0x05,
      0x76, 0x39, 0x39, 0x60, 0x1c, 0xd6, 0x67},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 798
    {SEC_OID_SHA256,
     798,
     {0x30, 0x23, 0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc,
      0x7b, 0xef, 0xef, 0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2,
      0xf7, 0x99, 0x59, 0x19, 0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a,
      0xb4, 0xae, 0x09, 0x03, 0x80, 0xfe, 0x01},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 799
    {SEC_OID_SHA256,
     799,
     {0x30, 0x21, 0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b, 0xef,
      0xef, 0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99, 0x59, 0x19,
      0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xae, 0x09, 0x01, 0x42},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 800
    {SEC_OID_SHA256,
     800,
     {0x30, 0x3d, 0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b,
      0xef, 0xef, 0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99,
      0x59, 0x19, 0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xaf, 0x02,
      0x1d, 0xff, 0x45, 0x09, 0x69, 0x59, 0x7a, 0x87, 0x08, 0x20, 0x21,
      0x18, 0x05, 0x98, 0x36, 0x88, 0x38, 0x7a, 0x10, 0xcd, 0x4d, 0xcc,
      0x45, 0x1a, 0x7f, 0x3f, 0x43, 0x2a, 0x96, 0xa3},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 801
    {SEC_OID_SHA256,
     801,
     {0x30, 0x21, 0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b, 0xef,
      0xef, 0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99, 0x59, 0x19,
      0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xaf, 0x02, 0x01, 0x00},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 802
    {SEC_OID_SHA256,
     802,
     {0x30, 0x21, 0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b, 0xef,
      0xef, 0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99, 0x59, 0x19,
      0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xaf, 0x02, 0x01, 0x01},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 803
    {SEC_OID_SHA256,
     803,
     {0x30, 0x21, 0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b, 0xef,
      0xef, 0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99, 0x59, 0x19,
      0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xaf, 0x02, 0x01, 0xff},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 804
    {SEC_OID_SHA256,
     804,
     {0x30, 0x3c, 0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b,
      0xef, 0xef, 0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99,
      0x59, 0x19, 0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xaf, 0x02,
      0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b, 0xef, 0xef, 0x73,
      0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99, 0x59, 0x19, 0xdd,
      0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xae},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 805
    {SEC_OID_SHA256,
     805,
     {0x30, 0x3c, 0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b,
      0xef, 0xef, 0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99,
      0x59, 0x19, 0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xaf, 0x02,
      0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b, 0xef, 0xef, 0x73,
      0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99, 0x59, 0x19, 0xdd,
      0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xaf},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 806
    {SEC_OID_SHA256,
     806,
     {0x30, 0x3d, 0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b,
      0xef, 0xef, 0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99,
      0x59, 0x19, 0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xaf, 0x02,
      0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7, 0xdf, 0xde,
      0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2, 0x33,
      0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5c},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 807
    {SEC_OID_SHA256,
     807,
     {0x30, 0x3d, 0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b,
      0xef, 0xef, 0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99,
      0x59, 0x19, 0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xaf, 0x02,
      0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7, 0xdf, 0xde,
      0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2, 0x33,
      0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5d},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 808
    {SEC_OID_SHA256,
     808,
     {0x30, 0x3d, 0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b,
      0xef, 0xef, 0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99,
      0x59, 0x19, 0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xaf, 0x02,
      0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7, 0xdf, 0xde,
      0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2, 0x33,
      0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5e},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 809
    {SEC_OID_SHA256,
     809,
     {0x30, 0x3d, 0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b,
      0xef, 0xef, 0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99,
      0x59, 0x19, 0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xaf, 0x02,
      0x1d, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 810
    {SEC_OID_SHA256,
     810,
     {0x30, 0x82, 0x01, 0x23, 0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc,
      0x7b, 0xef, 0xef, 0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99,
      0x59, 0x19, 0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xaf, 0x02, 0x82,
      0x01, 0x01, 0x00, 0x8f, 0x79, 0x35, 0xd9, 0xb9, 0xaa, 0xe9, 0xbf, 0xab,
      0xed, 0x88, 0x7a, 0xcf, 0x49, 0x51, 0xb6, 0xf3, 0x2e, 0xc5, 0x9e, 0x3b,
      0xaf, 0x37, 0x18, 0xe8, 0xea, 0xc4, 0x96, 0x1f, 0x3e, 0xfd, 0x36, 0x06,
      0xe7, 0x43, 0x51, 0xa9, 0xc4, 0x18, 0x33, 0x39, 0xb8, 0x09, 0xe7, 0xc2,
      0xae, 0x1c, 0x53, 0x9b, 0xa7, 0x47, 0x5b, 0x85, 0xd0, 0x11, 0xad, 0xb8,
      0xb4, 0x79, 0x87, 0x75, 0x49, 0x84, 0x69, 0x5c, 0xac, 0x0e, 0x8f, 0x14,
      0xb3, 0x36, 0x08, 0x28, 0xa2, 0x2f, 0xfa, 0x27, 0x11, 0x0a, 0x3d, 0x62,
      0xa9, 0x93, 0x45, 0x34, 0x09, 0xa0, 0xfe, 0x69, 0x6c, 0x46, 0x58, 0xf8,
      0x4b, 0xdd, 0x20, 0x81, 0x9c, 0x37, 0x09, 0xa0, 0x10, 0x57, 0xb1, 0x95,
      0xad, 0xcd, 0x00, 0x23, 0x3d, 0xba, 0x54, 0x84, 0xb6, 0x29, 0x1f, 0x9d,
      0x64, 0x8e, 0xf8, 0x83, 0x44, 0x86, 0x77, 0x97, 0x9c, 0xec, 0x04, 0xb4,
      0x34, 0xa6, 0xac, 0x2e, 0x75, 0xe9, 0x98, 0x5d, 0xe2, 0x3d, 0xb0, 0x29,
      0x2f, 0xc1, 0x11, 0x8c, 0x9f, 0xfa, 0x9d, 0x81, 0x81, 0xe7, 0x33, 0x8d,
      0xb7, 0x92, 0xb7, 0x30, 0xd7, 0xb9, 0xe3, 0x49, 0x59, 0x2f, 0x68, 0x09,
      0x98, 0x72, 0x15, 0x39, 0x15, 0xea, 0x3d, 0x6b, 0x8b, 0x46, 0x53, 0xc6,
      0x33, 0x45, 0x8f, 0x80, 0x3b, 0x32, 0xa4, 0xc2, 0xe0, 0xf2, 0x72, 0x90,
      0x25, 0x6e, 0x4e, 0x3f, 0x8a, 0x3b, 0x08, 0x38, 0xa1, 0xc4, 0x50, 0xe4,
      0xe1, 0x8c, 0x1a, 0x29, 0xa3, 0x7d, 0xdf, 0x5e, 0xa1, 0x43, 0xde, 0x4b,
      0x66, 0xff, 0x04, 0x90, 0x3e, 0xd5, 0xcf, 0x16, 0x23, 0xe1, 0x58, 0xd4,
      0x87, 0xc6, 0x08, 0xe9, 0x7f, 0x21, 0x1c, 0xd8, 0x1d, 0xca, 0x23, 0xcb,
      0x6e, 0x38, 0x07, 0x65, 0xf8, 0x22, 0xe3, 0x42, 0xbe, 0x48, 0x4c, 0x05,
      0x76, 0x39, 0x39, 0x60, 0x1c, 0xd6, 0x67},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 811
    {SEC_OID_SHA256,
     811,
     {0x30, 0x23, 0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc,
      0x7b, 0xef, 0xef, 0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2,
      0xf7, 0x99, 0x59, 0x19, 0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a,
      0xb4, 0xaf, 0x09, 0x03, 0x80, 0xfe, 0x01},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 812
    {SEC_OID_SHA256,
     812,
     {0x30, 0x21, 0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b, 0xef,
      0xef, 0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99, 0x59, 0x19,
      0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xaf, 0x09, 0x01, 0x42},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 813
    {SEC_OID_SHA256,
     813,
     {0x30, 0x3e, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78,
      0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef,
      0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5c,
      0x02, 0x1d, 0xff, 0x45, 0x09, 0x69, 0x59, 0x7a, 0x87, 0x08, 0x20,
      0x21, 0x18, 0x05, 0x98, 0x36, 0x88, 0x38, 0x7a, 0x10, 0xcd, 0x4d,
      0xcc, 0x45, 0x1a, 0x7f, 0x3f, 0x43, 0x2a, 0x96, 0xa3},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 814
    {SEC_OID_SHA256,
     814,
     {0x30, 0x22, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7,
      0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2,
      0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5c, 0x02, 0x01, 0x00},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 815
    {SEC_OID_SHA256,
     815,
     {0x30, 0x22, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7,
      0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2,
      0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5c, 0x02, 0x01, 0x01},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 816
    {SEC_OID_SHA256,
     816,
     {0x30, 0x22, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7,
      0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2,
      0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5c, 0x02, 0x01, 0xff},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 817
    {SEC_OID_SHA256,
     817,
     {0x30, 0x3d, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78,
      0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef,
      0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5c,
      0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b, 0xef, 0xef,
      0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99, 0x59, 0x19,
      0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xae},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 818
    {SEC_OID_SHA256,
     818,
     {0x30, 0x3d, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78,
      0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef,
      0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5c,
      0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b, 0xef, 0xef,
      0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99, 0x59, 0x19,
      0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xaf},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 819
    {SEC_OID_SHA256,
     819,
     {0x30, 0x3e, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78,
      0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef,
      0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5c,
      0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7, 0xdf,
      0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2,
      0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5c},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 820
    {SEC_OID_SHA256,
     820,
     {0x30, 0x3e, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78,
      0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef,
      0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5c,
      0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7, 0xdf,
      0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2,
      0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5d},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 821
    {SEC_OID_SHA256,
     821,
     {0x30, 0x3e, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78,
      0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef,
      0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5c,
      0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7, 0xdf,
      0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2,
      0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5e},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 822
    {SEC_OID_SHA256,
     822,
     {0x30, 0x3e, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78,
      0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef,
      0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5c,
      0x02, 0x1d, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 823
    {SEC_OID_SHA256,
     823,
     {0x30, 0x82, 0x01, 0x24, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85,
      0x78, 0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef,
      0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5c, 0x02,
      0x82, 0x01, 0x01, 0x00, 0x8f, 0x79, 0x35, 0xd9, 0xb9, 0xaa, 0xe9, 0xbf,
      0xab, 0xed, 0x88, 0x7a, 0xcf, 0x49, 0x51, 0xb6, 0xf3, 0x2e, 0xc5, 0x9e,
      0x3b, 0xaf, 0x37, 0x18, 0xe8, 0xea, 0xc4, 0x96, 0x1f, 0x3e, 0xfd, 0x36,
      0x06, 0xe7, 0x43, 0x51, 0xa9, 0xc4, 0x18, 0x33, 0x39, 0xb8, 0x09, 0xe7,
      0xc2, 0xae, 0x1c, 0x53, 0x9b, 0xa7, 0x47, 0x5b, 0x85, 0xd0, 0x11, 0xad,
      0xb8, 0xb4, 0x79, 0x87, 0x75, 0x49, 0x84, 0x69, 0x5c, 0xac, 0x0e, 0x8f,
      0x14, 0xb3, 0x36, 0x08, 0x28, 0xa2, 0x2f, 0xfa, 0x27, 0x11, 0x0a, 0x3d,
      0x62, 0xa9, 0x93, 0x45, 0x34, 0x09, 0xa0, 0xfe, 0x69, 0x6c, 0x46, 0x58,
      0xf8, 0x4b, 0xdd, 0x20, 0x81, 0x9c, 0x37, 0x09, 0xa0, 0x10, 0x57, 0xb1,
      0x95, 0xad, 0xcd, 0x00, 0x23, 0x3d, 0xba, 0x54, 0x84, 0xb6, 0x29, 0x1f,
      0x9d, 0x64, 0x8e, 0xf8, 0x83, 0x44, 0x86, 0x77, 0x97, 0x9c, 0xec, 0x04,
      0xb4, 0x34, 0xa6, 0xac, 0x2e, 0x75, 0xe9, 0x98, 0x5d, 0xe2, 0x3d, 0xb0,
      0x29, 0x2f, 0xc1, 0x11, 0x8c, 0x9f, 0xfa, 0x9d, 0x81, 0x81, 0xe7, 0x33,
      0x8d, 0xb7, 0x92, 0xb7, 0x30, 0xd7, 0xb9, 0xe3, 0x49, 0x59, 0x2f, 0x68,
      0x09, 0x98, 0x72, 0x15, 0x39, 0x15, 0xea, 0x3d, 0x6b, 0x8b, 0x46, 0x53,
      0xc6, 0x33, 0x45, 0x8f, 0x80, 0x3b, 0x32, 0xa4, 0xc2, 0xe0, 0xf2, 0x72,
      0x90, 0x25, 0x6e, 0x4e, 0x3f, 0x8a, 0x3b, 0x08, 0x38, 0xa1, 0xc4, 0x50,
      0xe4, 0xe1, 0x8c, 0x1a, 0x29, 0xa3, 0x7d, 0xdf, 0x5e, 0xa1, 0x43, 0xde,
      0x4b, 0x66, 0xff, 0x04, 0x90, 0x3e, 0xd5, 0xcf, 0x16, 0x23, 0xe1, 0x58,
      0xd4, 0x87, 0xc6, 0x08, 0xe9, 0x7f, 0x21, 0x1c, 0xd8, 0x1d, 0xca, 0x23,
      0xcb, 0x6e, 0x38, 0x07, 0x65, 0xf8, 0x22, 0xe3, 0x42, 0xbe, 0x48, 0x4c,
      0x05, 0x76, 0x39, 0x39, 0x60, 0x1c, 0xd6, 0x67},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 824
    {SEC_OID_SHA256,
     824,
     {0x30, 0x24, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85,
      0x78, 0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7,
      0x85, 0xef, 0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc,
      0xd5, 0x69, 0x5c, 0x09, 0x03, 0x80, 0xfe, 0x01},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 825
    {SEC_OID_SHA256,
     825,
     {0x30, 0x22, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7,
      0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2,
      0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5c, 0x09, 0x01, 0x42},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 826
    {SEC_OID_SHA256,
     826,
     {0x30, 0x3e, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78,
      0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef,
      0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5d,
      0x02, 0x1d, 0xff, 0x45, 0x09, 0x69, 0x59, 0x7a, 0x87, 0x08, 0x20,
      0x21, 0x18, 0x05, 0x98, 0x36, 0x88, 0x38, 0x7a, 0x10, 0xcd, 0x4d,
      0xcc, 0x45, 0x1a, 0x7f, 0x3f, 0x43, 0x2a, 0x96, 0xa3},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 827
    {SEC_OID_SHA256,
     827,
     {0x30, 0x22, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7,
      0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2,
      0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5d, 0x02, 0x01, 0x00},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 828
    {SEC_OID_SHA256,
     828,
     {0x30, 0x22, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7,
      0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2,
      0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5d, 0x02, 0x01, 0x01},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 829
    {SEC_OID_SHA256,
     829,
     {0x30, 0x22, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7,
      0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2,
      0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5d, 0x02, 0x01, 0xff},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 830
    {SEC_OID_SHA256,
     830,
     {0x30, 0x3d, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78,
      0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef,
      0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5d,
      0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b, 0xef, 0xef,
      0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99, 0x59, 0x19,
      0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xae},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 831
    {SEC_OID_SHA256,
     831,
     {0x30, 0x3d, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78,
      0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef,
      0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5d,
      0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b, 0xef, 0xef,
      0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99, 0x59, 0x19,
      0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xaf},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 832
    {SEC_OID_SHA256,
     832,
     {0x30, 0x3e, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78,
      0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef,
      0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5d,
      0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7, 0xdf,
      0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2,
      0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5c},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 833
    {SEC_OID_SHA256,
     833,
     {0x30, 0x3e, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78,
      0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef,
      0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5d,
      0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7, 0xdf,
      0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2,
      0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5d},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 834
    {SEC_OID_SHA256,
     834,
     {0x30, 0x3e, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78,
      0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef,
      0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5d,
      0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7, 0xdf,
      0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2,
      0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5e},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 835
    {SEC_OID_SHA256,
     835,
     {0x30, 0x3e, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78,
      0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef,
      0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5d,
      0x02, 0x1d, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 836
    {SEC_OID_SHA256,
     836,
     {0x30, 0x82, 0x01, 0x24, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85,
      0x78, 0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef,
      0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5d, 0x02,
      0x82, 0x01, 0x01, 0x00, 0x8f, 0x79, 0x35, 0xd9, 0xb9, 0xaa, 0xe9, 0xbf,
      0xab, 0xed, 0x88, 0x7a, 0xcf, 0x49, 0x51, 0xb6, 0xf3, 0x2e, 0xc5, 0x9e,
      0x3b, 0xaf, 0x37, 0x18, 0xe8, 0xea, 0xc4, 0x96, 0x1f, 0x3e, 0xfd, 0x36,
      0x06, 0xe7, 0x43, 0x51, 0xa9, 0xc4, 0x18, 0x33, 0x39, 0xb8, 0x09, 0xe7,
      0xc2, 0xae, 0x1c, 0x53, 0x9b, 0xa7, 0x47, 0x5b, 0x85, 0xd0, 0x11, 0xad,
      0xb8, 0xb4, 0x79, 0x87, 0x75, 0x49, 0x84, 0x69, 0x5c, 0xac, 0x0e, 0x8f,
      0x14, 0xb3, 0x36, 0x08, 0x28, 0xa2, 0x2f, 0xfa, 0x27, 0x11, 0x0a, 0x3d,
      0x62, 0xa9, 0x93, 0x45, 0x34, 0x09, 0xa0, 0xfe, 0x69, 0x6c, 0x46, 0x58,
      0xf8, 0x4b, 0xdd, 0x20, 0x81, 0x9c, 0x37, 0x09, 0xa0, 0x10, 0x57, 0xb1,
      0x95, 0xad, 0xcd, 0x00, 0x23, 0x3d, 0xba, 0x54, 0x84, 0xb6, 0x29, 0x1f,
      0x9d, 0x64, 0x8e, 0xf8, 0x83, 0x44, 0x86, 0x77, 0x97, 0x9c, 0xec, 0x04,
      0xb4, 0x34, 0xa6, 0xac, 0x2e, 0x75, 0xe9, 0x98, 0x5d, 0xe2, 0x3d, 0xb0,
      0x29, 0x2f, 0xc1, 0x11, 0x8c, 0x9f, 0xfa, 0x9d, 0x81, 0x81, 0xe7, 0x33,
      0x8d, 0xb7, 0x92, 0xb7, 0x30, 0xd7, 0xb9, 0xe3, 0x49, 0x59, 0x2f, 0x68,
      0x09, 0x98, 0x72, 0x15, 0x39, 0x15, 0xea, 0x3d, 0x6b, 0x8b, 0x46, 0x53,
      0xc6, 0x33, 0x45, 0x8f, 0x80, 0x3b, 0x32, 0xa4, 0xc2, 0xe0, 0xf2, 0x72,
      0x90, 0x25, 0x6e, 0x4e, 0x3f, 0x8a, 0x3b, 0x08, 0x38, 0xa1, 0xc4, 0x50,
      0xe4, 0xe1, 0x8c, 0x1a, 0x29, 0xa3, 0x7d, 0xdf, 0x5e, 0xa1, 0x43, 0xde,
      0x4b, 0x66, 0xff, 0x04, 0x90, 0x3e, 0xd5, 0xcf, 0x16, 0x23, 0xe1, 0x58,
      0xd4, 0x87, 0xc6, 0x08, 0xe9, 0x7f, 0x21, 0x1c, 0xd8, 0x1d, 0xca, 0x23,
      0xcb, 0x6e, 0x38, 0x07, 0x65, 0xf8, 0x22, 0xe3, 0x42, 0xbe, 0x48, 0x4c,
      0x05, 0x76, 0x39, 0x39, 0x60, 0x1c, 0xd6, 0x67},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 837
    {SEC_OID_SHA256,
     837,
     {0x30, 0x24, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85,
      0x78, 0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7,
      0x85, 0xef, 0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc,
      0xd5, 0x69, 0x5d, 0x09, 0x03, 0x80, 0xfe, 0x01},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 838
    {SEC_OID_SHA256,
     838,
     {0x30, 0x22, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7,
      0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2,
      0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5d, 0x09, 0x01, 0x42},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 839
    {SEC_OID_SHA256,
     839,
     {0x30, 0x3e, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78,
      0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef,
      0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5e,
      0x02, 0x1d, 0xff, 0x45, 0x09, 0x69, 0x59, 0x7a, 0x87, 0x08, 0x20,
      0x21, 0x18, 0x05, 0x98, 0x36, 0x88, 0x38, 0x7a, 0x10, 0xcd, 0x4d,
      0xcc, 0x45, 0x1a, 0x7f, 0x3f, 0x43, 0x2a, 0x96, 0xa3},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 840
    {SEC_OID_SHA256,
     840,
     {0x30, 0x22, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7,
      0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2,
      0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5e, 0x02, 0x01, 0x00},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 841
    {SEC_OID_SHA256,
     841,
     {0x30, 0x22, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7,
      0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2,
      0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5e, 0x02, 0x01, 0x01},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 842
    {SEC_OID_SHA256,
     842,
     {0x30, 0x22, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7,
      0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2,
      0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5e, 0x02, 0x01, 0xff},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 843
    {SEC_OID_SHA256,
     843,
     {0x30, 0x3d, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78,
      0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef,
      0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5e,
      0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b, 0xef, 0xef,
      0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99, 0x59, 0x19,
      0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xae},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 844
    {SEC_OID_SHA256,
     844,
     {0x30, 0x3d, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78,
      0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef,
      0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5e,
      0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b, 0xef, 0xef,
      0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99, 0x59, 0x19,
      0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xaf},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 845
    {SEC_OID_SHA256,
     845,
     {0x30, 0x3e, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78,
      0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef,
      0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5e,
      0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7, 0xdf,
      0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2,
      0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5c},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 846
    {SEC_OID_SHA256,
     846,
     {0x30, 0x3e, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78,
      0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef,
      0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5e,
      0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7, 0xdf,
      0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2,
      0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5d},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 847
    {SEC_OID_SHA256,
     847,
     {0x30, 0x3e, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78,
      0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef,
      0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5e,
      0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7, 0xdf,
      0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2,
      0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5e},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 848
    {SEC_OID_SHA256,
     848,
     {0x30, 0x3e, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78,
      0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef,
      0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5e,
      0x02, 0x1d, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 849
    {SEC_OID_SHA256,
     849,
     {0x30, 0x82, 0x01, 0x24, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85,
      0x78, 0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef,
      0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5e, 0x02,
      0x82, 0x01, 0x01, 0x00, 0x8f, 0x79, 0x35, 0xd9, 0xb9, 0xaa, 0xe9, 0xbf,
      0xab, 0xed, 0x88, 0x7a, 0xcf, 0x49, 0x51, 0xb6, 0xf3, 0x2e, 0xc5, 0x9e,
      0x3b, 0xaf, 0x37, 0x18, 0xe8, 0xea, 0xc4, 0x96, 0x1f, 0x3e, 0xfd, 0x36,
      0x06, 0xe7, 0x43, 0x51, 0xa9, 0xc4, 0x18, 0x33, 0x39, 0xb8, 0x09, 0xe7,
      0xc2, 0xae, 0x1c, 0x53, 0x9b, 0xa7, 0x47, 0x5b, 0x85, 0xd0, 0x11, 0xad,
      0xb8, 0xb4, 0x79, 0x87, 0x75, 0x49, 0x84, 0x69, 0x5c, 0xac, 0x0e, 0x8f,
      0x14, 0xb3, 0x36, 0x08, 0x28, 0xa2, 0x2f, 0xfa, 0x27, 0x11, 0x0a, 0x3d,
      0x62, 0xa9, 0x93, 0x45, 0x34, 0x09, 0xa0, 0xfe, 0x69, 0x6c, 0x46, 0x58,
      0xf8, 0x4b, 0xdd, 0x20, 0x81, 0x9c, 0x37, 0x09, 0xa0, 0x10, 0x57, 0xb1,
      0x95, 0xad, 0xcd, 0x00, 0x23, 0x3d, 0xba, 0x54, 0x84, 0xb6, 0x29, 0x1f,
      0x9d, 0x64, 0x8e, 0xf8, 0x83, 0x44, 0x86, 0x77, 0x97, 0x9c, 0xec, 0x04,
      0xb4, 0x34, 0xa6, 0xac, 0x2e, 0x75, 0xe9, 0x98, 0x5d, 0xe2, 0x3d, 0xb0,
      0x29, 0x2f, 0xc1, 0x11, 0x8c, 0x9f, 0xfa, 0x9d, 0x81, 0x81, 0xe7, 0x33,
      0x8d, 0xb7, 0x92, 0xb7, 0x30, 0xd7, 0xb9, 0xe3, 0x49, 0x59, 0x2f, 0x68,
      0x09, 0x98, 0x72, 0x15, 0x39, 0x15, 0xea, 0x3d, 0x6b, 0x8b, 0x46, 0x53,
      0xc6, 0x33, 0x45, 0x8f, 0x80, 0x3b, 0x32, 0xa4, 0xc2, 0xe0, 0xf2, 0x72,
      0x90, 0x25, 0x6e, 0x4e, 0x3f, 0x8a, 0x3b, 0x08, 0x38, 0xa1, 0xc4, 0x50,
      0xe4, 0xe1, 0x8c, 0x1a, 0x29, 0xa3, 0x7d, 0xdf, 0x5e, 0xa1, 0x43, 0xde,
      0x4b, 0x66, 0xff, 0x04, 0x90, 0x3e, 0xd5, 0xcf, 0x16, 0x23, 0xe1, 0x58,
      0xd4, 0x87, 0xc6, 0x08, 0xe9, 0x7f, 0x21, 0x1c, 0xd8, 0x1d, 0xca, 0x23,
      0xcb, 0x6e, 0x38, 0x07, 0x65, 0xf8, 0x22, 0xe3, 0x42, 0xbe, 0x48, 0x4c,
      0x05, 0x76, 0x39, 0x39, 0x60, 0x1c, 0xd6, 0x67},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 850
    {SEC_OID_SHA256,
     850,
     {0x30, 0x24, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85,
      0x78, 0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7,
      0x85, 0xef, 0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc,
      0xd5, 0x69, 0x5e, 0x09, 0x03, 0x80, 0xfe, 0x01},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 851
    {SEC_OID_SHA256,
     851,
     {0x30, 0x22, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7,
      0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2,
      0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5e, 0x09, 0x01, 0x42},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 852
    {SEC_OID_SHA256,
     852,
     {0x30, 0x3e, 0x02, 0x1d, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x02, 0x1d, 0xff, 0x45, 0x09, 0x69, 0x59, 0x7a, 0x87, 0x08, 0x20,
      0x21, 0x18, 0x05, 0x98, 0x36, 0x88, 0x38, 0x7a, 0x10, 0xcd, 0x4d,
      0xcc, 0x45, 0x1a, 0x7f, 0x3f, 0x43, 0x2a, 0x96, 0xa3},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 853
    {SEC_OID_SHA256,
     853,
     {0x30, 0x22, 0x02, 0x1d, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x01, 0x00},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 854
    {SEC_OID_SHA256,
     854,
     {0x30, 0x22, 0x02, 0x1d, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x01, 0x01},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 855
    {SEC_OID_SHA256,
     855,
     {0x30, 0x22, 0x02, 0x1d, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x01, 0xff},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 856
    {SEC_OID_SHA256,
     856,
     {0x30, 0x3d, 0x02, 0x1d, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b, 0xef, 0xef,
      0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99, 0x59, 0x19,
      0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xae},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 857
    {SEC_OID_SHA256,
     857,
     {0x30, 0x3d, 0x02, 0x1d, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b, 0xef, 0xef,
      0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99, 0x59, 0x19,
      0xdd, 0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xaf},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 858
    {SEC_OID_SHA256,
     858,
     {0x30, 0x3e, 0x02, 0x1d, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7, 0xdf,
      0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2,
      0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5c},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 859
    {SEC_OID_SHA256,
     859,
     {0x30, 0x3e, 0x02, 0x1d, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7, 0xdf,
      0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2,
      0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5d},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 860
    {SEC_OID_SHA256,
     860,
     {0x30, 0x3e, 0x02, 0x1d, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7, 0xdf,
      0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2,
      0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5e},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 861
    {SEC_OID_SHA256,
     861,
     {0x30, 0x3e, 0x02, 0x1d, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x02, 0x1d, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 862
    {SEC_OID_SHA256,
     862,
     {0x30, 0x82, 0x01, 0x24, 0x02, 0x1d, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02,
      0x82, 0x01, 0x01, 0x00, 0x8f, 0x79, 0x35, 0xd9, 0xb9, 0xaa, 0xe9, 0xbf,
      0xab, 0xed, 0x88, 0x7a, 0xcf, 0x49, 0x51, 0xb6, 0xf3, 0x2e, 0xc5, 0x9e,
      0x3b, 0xaf, 0x37, 0x18, 0xe8, 0xea, 0xc4, 0x96, 0x1f, 0x3e, 0xfd, 0x36,
      0x06, 0xe7, 0x43, 0x51, 0xa9, 0xc4, 0x18, 0x33, 0x39, 0xb8, 0x09, 0xe7,
      0xc2, 0xae, 0x1c, 0x53, 0x9b, 0xa7, 0x47, 0x5b, 0x85, 0xd0, 0x11, 0xad,
      0xb8, 0xb4, 0x79, 0x87, 0x75, 0x49, 0x84, 0x69, 0x5c, 0xac, 0x0e, 0x8f,
      0x14, 0xb3, 0x36, 0x08, 0x28, 0xa2, 0x2f, 0xfa, 0x27, 0x11, 0x0a, 0x3d,
      0x62, 0xa9, 0x93, 0x45, 0x34, 0x09, 0xa0, 0xfe, 0x69, 0x6c, 0x46, 0x58,
      0xf8, 0x4b, 0xdd, 0x20, 0x81, 0x9c, 0x37, 0x09, 0xa0, 0x10, 0x57, 0xb1,
      0x95, 0xad, 0xcd, 0x00, 0x23, 0x3d, 0xba, 0x54, 0x84, 0xb6, 0x29, 0x1f,
      0x9d, 0x64, 0x8e, 0xf8, 0x83, 0x44, 0x86, 0x77, 0x97, 0x9c, 0xec, 0x04,
      0xb4, 0x34, 0xa6, 0xac, 0x2e, 0x75, 0xe9, 0x98, 0x5d, 0xe2, 0x3d, 0xb0,
      0x29, 0x2f, 0xc1, 0x11, 0x8c, 0x9f, 0xfa, 0x9d, 0x81, 0x81, 0xe7, 0x33,
      0x8d, 0xb7, 0x92, 0xb7, 0x30, 0xd7, 0xb9, 0xe3, 0x49, 0x59, 0x2f, 0x68,
      0x09, 0x98, 0x72, 0x15, 0x39, 0x15, 0xea, 0x3d, 0x6b, 0x8b, 0x46, 0x53,
      0xc6, 0x33, 0x45, 0x8f, 0x80, 0x3b, 0x32, 0xa4, 0xc2, 0xe0, 0xf2, 0x72,
      0x90, 0x25, 0x6e, 0x4e, 0x3f, 0x8a, 0x3b, 0x08, 0x38, 0xa1, 0xc4, 0x50,
      0xe4, 0xe1, 0x8c, 0x1a, 0x29, 0xa3, 0x7d, 0xdf, 0x5e, 0xa1, 0x43, 0xde,
      0x4b, 0x66, 0xff, 0x04, 0x90, 0x3e, 0xd5, 0xcf, 0x16, 0x23, 0xe1, 0x58,
      0xd4, 0x87, 0xc6, 0x08, 0xe9, 0x7f, 0x21, 0x1c, 0xd8, 0x1d, 0xca, 0x23,
      0xcb, 0x6e, 0x38, 0x07, 0x65, 0xf8, 0x22, 0xe3, 0x42, 0xbe, 0x48, 0x4c,
      0x05, 0x76, 0x39, 0x39, 0x60, 0x1c, 0xd6, 0x67},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 863
    {SEC_OID_SHA256,
     863,
     {0x30, 0x24, 0x02, 0x1d, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x09, 0x03, 0x80, 0xfe, 0x01},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 864
    {SEC_OID_SHA256,
     864,
     {0x30, 0x22, 0x02, 0x1d, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x01, 0x42},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 865
    {SEC_OID_SHA256,
     865,
     {0x30, 0x82, 0x01, 0x24, 0x02, 0x82, 0x01, 0x01, 0x00, 0x8f, 0x79, 0x35,
      0xd9, 0xb9, 0xaa, 0xe9, 0xbf, 0xab, 0xed, 0x88, 0x7a, 0xcf, 0x49, 0x51,
      0xb6, 0xf3, 0x2e, 0xc5, 0x9e, 0x3b, 0xaf, 0x37, 0x18, 0xe8, 0xea, 0xc4,
      0x96, 0x1f, 0x3e, 0xfd, 0x36, 0x06, 0xe7, 0x43, 0x51, 0xa9, 0xc4, 0x18,
      0x33, 0x39, 0xb8, 0x09, 0xe7, 0xc2, 0xae, 0x1c, 0x53, 0x9b, 0xa7, 0x47,
      0x5b, 0x85, 0xd0, 0x11, 0xad, 0xb8, 0xb4, 0x79, 0x87, 0x75, 0x49, 0x84,
      0x69, 0x5c, 0xac, 0x0e, 0x8f, 0x14, 0xb3, 0x36, 0x08, 0x28, 0xa2, 0x2f,
      0xfa, 0x27, 0x11, 0x0a, 0x3d, 0x62, 0xa9, 0x93, 0x45, 0x34, 0x09, 0xa0,
      0xfe, 0x69, 0x6c, 0x46, 0x58, 0xf8, 0x4b, 0xdd, 0x20, 0x81, 0x9c, 0x37,
      0x09, 0xa0, 0x10, 0x57, 0xb1, 0x95, 0xad, 0xcd, 0x00, 0x23, 0x3d, 0xba,
      0x54, 0x84, 0xb6, 0x29, 0x1f, 0x9d, 0x64, 0x8e, 0xf8, 0x83, 0x44, 0x86,
      0x77, 0x97, 0x9c, 0xec, 0x04, 0xb4, 0x34, 0xa6, 0xac, 0x2e, 0x75, 0xe9,
      0x98, 0x5d, 0xe2, 0x3d, 0xb0, 0x29, 0x2f, 0xc1, 0x11, 0x8c, 0x9f, 0xfa,
      0x9d, 0x81, 0x81, 0xe7, 0x33, 0x8d, 0xb7, 0x92, 0xb7, 0x30, 0xd7, 0xb9,
      0xe3, 0x49, 0x59, 0x2f, 0x68, 0x09, 0x98, 0x72, 0x15, 0x39, 0x15, 0xea,
      0x3d, 0x6b, 0x8b, 0x46, 0x53, 0xc6, 0x33, 0x45, 0x8f, 0x80, 0x3b, 0x32,
      0xa4, 0xc2, 0xe0, 0xf2, 0x72, 0x90, 0x25, 0x6e, 0x4e, 0x3f, 0x8a, 0x3b,
      0x08, 0x38, 0xa1, 0xc4, 0x50, 0xe4, 0xe1, 0x8c, 0x1a, 0x29, 0xa3, 0x7d,
      0xdf, 0x5e, 0xa1, 0x43, 0xde, 0x4b, 0x66, 0xff, 0x04, 0x90, 0x3e, 0xd5,
      0xcf, 0x16, 0x23, 0xe1, 0x58, 0xd4, 0x87, 0xc6, 0x08, 0xe9, 0x7f, 0x21,
      0x1c, 0xd8, 0x1d, 0xca, 0x23, 0xcb, 0x6e, 0x38, 0x07, 0x65, 0xf8, 0x22,
      0xe3, 0x42, 0xbe, 0x48, 0x4c, 0x05, 0x76, 0x39, 0x39, 0x60, 0x1c, 0xd6,
      0x67, 0x02, 0x1d, 0xff, 0x45, 0x09, 0x69, 0x59, 0x7a, 0x87, 0x08, 0x20,
      0x21, 0x18, 0x05, 0x98, 0x36, 0x88, 0x38, 0x7a, 0x10, 0xcd, 0x4d, 0xcc,
      0x45, 0x1a, 0x7f, 0x3f, 0x43, 0x2a, 0x96, 0xa3},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 866
    {SEC_OID_SHA256,
     866,
     {0x30, 0x82, 0x01, 0x08, 0x02, 0x82, 0x01, 0x01, 0x00, 0x8f, 0x79, 0x35,
      0xd9, 0xb9, 0xaa, 0xe9, 0xbf, 0xab, 0xed, 0x88, 0x7a, 0xcf, 0x49, 0x51,
      0xb6, 0xf3, 0x2e, 0xc5, 0x9e, 0x3b, 0xaf, 0x37, 0x18, 0xe8, 0xea, 0xc4,
      0x96, 0x1f, 0x3e, 0xfd, 0x36, 0x06, 0xe7, 0x43, 0x51, 0xa9, 0xc4, 0x18,
      0x33, 0x39, 0xb8, 0x09, 0xe7, 0xc2, 0xae, 0x1c, 0x53, 0x9b, 0xa7, 0x47,
      0x5b, 0x85, 0xd0, 0x11, 0xad, 0xb8, 0xb4, 0x79, 0x87, 0x75, 0x49, 0x84,
      0x69, 0x5c, 0xac, 0x0e, 0x8f, 0x14, 0xb3, 0x36, 0x08, 0x28, 0xa2, 0x2f,
      0xfa, 0x27, 0x11, 0x0a, 0x3d, 0x62, 0xa9, 0x93, 0x45, 0x34, 0x09, 0xa0,
      0xfe, 0x69, 0x6c, 0x46, 0x58, 0xf8, 0x4b, 0xdd, 0x20, 0x81, 0x9c, 0x37,
      0x09, 0xa0, 0x10, 0x57, 0xb1, 0x95, 0xad, 0xcd, 0x00, 0x23, 0x3d, 0xba,
      0x54, 0x84, 0xb6, 0x29, 0x1f, 0x9d, 0x64, 0x8e, 0xf8, 0x83, 0x44, 0x86,
      0x77, 0x97, 0x9c, 0xec, 0x04, 0xb4, 0x34, 0xa6, 0xac, 0x2e, 0x75, 0xe9,
      0x98, 0x5d, 0xe2, 0x3d, 0xb0, 0x29, 0x2f, 0xc1, 0x11, 0x8c, 0x9f, 0xfa,
      0x9d, 0x81, 0x81, 0xe7, 0x33, 0x8d, 0xb7, 0x92, 0xb7, 0x30, 0xd7, 0xb9,
      0xe3, 0x49, 0x59, 0x2f, 0x68, 0x09, 0x98, 0x72, 0x15, 0x39, 0x15, 0xea,
      0x3d, 0x6b, 0x8b, 0x46, 0x53, 0xc6, 0x33, 0x45, 0x8f, 0x80, 0x3b, 0x32,
      0xa4, 0xc2, 0xe0, 0xf2, 0x72, 0x90, 0x25, 0x6e, 0x4e, 0x3f, 0x8a, 0x3b,
      0x08, 0x38, 0xa1, 0xc4, 0x50, 0xe4, 0xe1, 0x8c, 0x1a, 0x29, 0xa3, 0x7d,
      0xdf, 0x5e, 0xa1, 0x43, 0xde, 0x4b, 0x66, 0xff, 0x04, 0x90, 0x3e, 0xd5,
      0xcf, 0x16, 0x23, 0xe1, 0x58, 0xd4, 0x87, 0xc6, 0x08, 0xe9, 0x7f, 0x21,
      0x1c, 0xd8, 0x1d, 0xca, 0x23, 0xcb, 0x6e, 0x38, 0x07, 0x65, 0xf8, 0x22,
      0xe3, 0x42, 0xbe, 0x48, 0x4c, 0x05, 0x76, 0x39, 0x39, 0x60, 0x1c, 0xd6,
      0x67, 0x02, 0x01, 0x00},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 867
    {SEC_OID_SHA256,
     867,
     {0x30, 0x82, 0x01, 0x08, 0x02, 0x82, 0x01, 0x01, 0x00, 0x8f, 0x79, 0x35,
      0xd9, 0xb9, 0xaa, 0xe9, 0xbf, 0xab, 0xed, 0x88, 0x7a, 0xcf, 0x49, 0x51,
      0xb6, 0xf3, 0x2e, 0xc5, 0x9e, 0x3b, 0xaf, 0x37, 0x18, 0xe8, 0xea, 0xc4,
      0x96, 0x1f, 0x3e, 0xfd, 0x36, 0x06, 0xe7, 0x43, 0x51, 0xa9, 0xc4, 0x18,
      0x33, 0x39, 0xb8, 0x09, 0xe7, 0xc2, 0xae, 0x1c, 0x53, 0x9b, 0xa7, 0x47,
      0x5b, 0x85, 0xd0, 0x11, 0xad, 0xb8, 0xb4, 0x79, 0x87, 0x75, 0x49, 0x84,
      0x69, 0x5c, 0xac, 0x0e, 0x8f, 0x14, 0xb3, 0x36, 0x08, 0x28, 0xa2, 0x2f,
      0xfa, 0x27, 0x11, 0x0a, 0x3d, 0x62, 0xa9, 0x93, 0x45, 0x34, 0x09, 0xa0,
      0xfe, 0x69, 0x6c, 0x46, 0x58, 0xf8, 0x4b, 0xdd, 0x20, 0x81, 0x9c, 0x37,
      0x09, 0xa0, 0x10, 0x57, 0xb1, 0x95, 0xad, 0xcd, 0x00, 0x23, 0x3d, 0xba,
      0x54, 0x84, 0xb6, 0x29, 0x1f, 0x9d, 0x64, 0x8e, 0xf8, 0x83, 0x44, 0x86,
      0x77, 0x97, 0x9c, 0xec, 0x04, 0xb4, 0x34, 0xa6, 0xac, 0x2e, 0x75, 0xe9,
      0x98, 0x5d, 0xe2, 0x3d, 0xb0, 0x29, 0x2f, 0xc1, 0x11, 0x8c, 0x9f, 0xfa,
      0x9d, 0x81, 0x81, 0xe7, 0x33, 0x8d, 0xb7, 0x92, 0xb7, 0x30, 0xd7, 0xb9,
      0xe3, 0x49, 0x59, 0x2f, 0x68, 0x09, 0x98, 0x72, 0x15, 0x39, 0x15, 0xea,
      0x3d, 0x6b, 0x8b, 0x46, 0x53, 0xc6, 0x33, 0x45, 0x8f, 0x80, 0x3b, 0x32,
      0xa4, 0xc2, 0xe0, 0xf2, 0x72, 0x90, 0x25, 0x6e, 0x4e, 0x3f, 0x8a, 0x3b,
      0x08, 0x38, 0xa1, 0xc4, 0x50, 0xe4, 0xe1, 0x8c, 0x1a, 0x29, 0xa3, 0x7d,
      0xdf, 0x5e, 0xa1, 0x43, 0xde, 0x4b, 0x66, 0xff, 0x04, 0x90, 0x3e, 0xd5,
      0xcf, 0x16, 0x23, 0xe1, 0x58, 0xd4, 0x87, 0xc6, 0x08, 0xe9, 0x7f, 0x21,
      0x1c, 0xd8, 0x1d, 0xca, 0x23, 0xcb, 0x6e, 0x38, 0x07, 0x65, 0xf8, 0x22,
      0xe3, 0x42, 0xbe, 0x48, 0x4c, 0x05, 0x76, 0x39, 0x39, 0x60, 0x1c, 0xd6,
      0x67, 0x02, 0x01, 0x01},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 868
    {SEC_OID_SHA256,
     868,
     {0x30, 0x82, 0x01, 0x08, 0x02, 0x82, 0x01, 0x01, 0x00, 0x8f, 0x79, 0x35,
      0xd9, 0xb9, 0xaa, 0xe9, 0xbf, 0xab, 0xed, 0x88, 0x7a, 0xcf, 0x49, 0x51,
      0xb6, 0xf3, 0x2e, 0xc5, 0x9e, 0x3b, 0xaf, 0x37, 0x18, 0xe8, 0xea, 0xc4,
      0x96, 0x1f, 0x3e, 0xfd, 0x36, 0x06, 0xe7, 0x43, 0x51, 0xa9, 0xc4, 0x18,
      0x33, 0x39, 0xb8, 0x09, 0xe7, 0xc2, 0xae, 0x1c, 0x53, 0x9b, 0xa7, 0x47,
      0x5b, 0x85, 0xd0, 0x11, 0xad, 0xb8, 0xb4, 0x79, 0x87, 0x75, 0x49, 0x84,
      0x69, 0x5c, 0xac, 0x0e, 0x8f, 0x14, 0xb3, 0x36, 0x08, 0x28, 0xa2, 0x2f,
      0xfa, 0x27, 0x11, 0x0a, 0x3d, 0x62, 0xa9, 0x93, 0x45, 0x34, 0x09, 0xa0,
      0xfe, 0x69, 0x6c, 0x46, 0x58, 0xf8, 0x4b, 0xdd, 0x20, 0x81, 0x9c, 0x37,
      0x09, 0xa0, 0x10, 0x57, 0xb1, 0x95, 0xad, 0xcd, 0x00, 0x23, 0x3d, 0xba,
      0x54, 0x84, 0xb6, 0x29, 0x1f, 0x9d, 0x64, 0x8e, 0xf8, 0x83, 0x44, 0x86,
      0x77, 0x97, 0x9c, 0xec, 0x04, 0xb4, 0x34, 0xa6, 0xac, 0x2e, 0x75, 0xe9,
      0x98, 0x5d, 0xe2, 0x3d, 0xb0, 0x29, 0x2f, 0xc1, 0x11, 0x8c, 0x9f, 0xfa,
      0x9d, 0x81, 0x81, 0xe7, 0x33, 0x8d, 0xb7, 0x92, 0xb7, 0x30, 0xd7, 0xb9,
      0xe3, 0x49, 0x59, 0x2f, 0x68, 0x09, 0x98, 0x72, 0x15, 0x39, 0x15, 0xea,
      0x3d, 0x6b, 0x8b, 0x46, 0x53, 0xc6, 0x33, 0x45, 0x8f, 0x80, 0x3b, 0x32,
      0xa4, 0xc2, 0xe0, 0xf2, 0x72, 0x90, 0x25, 0x6e, 0x4e, 0x3f, 0x8a, 0x3b,
      0x08, 0x38, 0xa1, 0xc4, 0x50, 0xe4, 0xe1, 0x8c, 0x1a, 0x29, 0xa3, 0x7d,
      0xdf, 0x5e, 0xa1, 0x43, 0xde, 0x4b, 0x66, 0xff, 0x04, 0x90, 0x3e, 0xd5,
      0xcf, 0x16, 0x23, 0xe1, 0x58, 0xd4, 0x87, 0xc6, 0x08, 0xe9, 0x7f, 0x21,
      0x1c, 0xd8, 0x1d, 0xca, 0x23, 0xcb, 0x6e, 0x38, 0x07, 0x65, 0xf8, 0x22,
      0xe3, 0x42, 0xbe, 0x48, 0x4c, 0x05, 0x76, 0x39, 0x39, 0x60, 0x1c, 0xd6,
      0x67, 0x02, 0x01, 0xff},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 869
    {SEC_OID_SHA256,
     869,
     {0x30, 0x82, 0x01, 0x23, 0x02, 0x82, 0x01, 0x01, 0x00, 0x8f, 0x79, 0x35,
      0xd9, 0xb9, 0xaa, 0xe9, 0xbf, 0xab, 0xed, 0x88, 0x7a, 0xcf, 0x49, 0x51,
      0xb6, 0xf3, 0x2e, 0xc5, 0x9e, 0x3b, 0xaf, 0x37, 0x18, 0xe8, 0xea, 0xc4,
      0x96, 0x1f, 0x3e, 0xfd, 0x36, 0x06, 0xe7, 0x43, 0x51, 0xa9, 0xc4, 0x18,
      0x33, 0x39, 0xb8, 0x09, 0xe7, 0xc2, 0xae, 0x1c, 0x53, 0x9b, 0xa7, 0x47,
      0x5b, 0x85, 0xd0, 0x11, 0xad, 0xb8, 0xb4, 0x79, 0x87, 0x75, 0x49, 0x84,
      0x69, 0x5c, 0xac, 0x0e, 0x8f, 0x14, 0xb3, 0x36, 0x08, 0x28, 0xa2, 0x2f,
      0xfa, 0x27, 0x11, 0x0a, 0x3d, 0x62, 0xa9, 0x93, 0x45, 0x34, 0x09, 0xa0,
      0xfe, 0x69, 0x6c, 0x46, 0x58, 0xf8, 0x4b, 0xdd, 0x20, 0x81, 0x9c, 0x37,
      0x09, 0xa0, 0x10, 0x57, 0xb1, 0x95, 0xad, 0xcd, 0x00, 0x23, 0x3d, 0xba,
      0x54, 0x84, 0xb6, 0x29, 0x1f, 0x9d, 0x64, 0x8e, 0xf8, 0x83, 0x44, 0x86,
      0x77, 0x97, 0x9c, 0xec, 0x04, 0xb4, 0x34, 0xa6, 0xac, 0x2e, 0x75, 0xe9,
      0x98, 0x5d, 0xe2, 0x3d, 0xb0, 0x29, 0x2f, 0xc1, 0x11, 0x8c, 0x9f, 0xfa,
      0x9d, 0x81, 0x81, 0xe7, 0x33, 0x8d, 0xb7, 0x92, 0xb7, 0x30, 0xd7, 0xb9,
      0xe3, 0x49, 0x59, 0x2f, 0x68, 0x09, 0x98, 0x72, 0x15, 0x39, 0x15, 0xea,
      0x3d, 0x6b, 0x8b, 0x46, 0x53, 0xc6, 0x33, 0x45, 0x8f, 0x80, 0x3b, 0x32,
      0xa4, 0xc2, 0xe0, 0xf2, 0x72, 0x90, 0x25, 0x6e, 0x4e, 0x3f, 0x8a, 0x3b,
      0x08, 0x38, 0xa1, 0xc4, 0x50, 0xe4, 0xe1, 0x8c, 0x1a, 0x29, 0xa3, 0x7d,
      0xdf, 0x5e, 0xa1, 0x43, 0xde, 0x4b, 0x66, 0xff, 0x04, 0x90, 0x3e, 0xd5,
      0xcf, 0x16, 0x23, 0xe1, 0x58, 0xd4, 0x87, 0xc6, 0x08, 0xe9, 0x7f, 0x21,
      0x1c, 0xd8, 0x1d, 0xca, 0x23, 0xcb, 0x6e, 0x38, 0x07, 0x65, 0xf8, 0x22,
      0xe3, 0x42, 0xbe, 0x48, 0x4c, 0x05, 0x76, 0x39, 0x39, 0x60, 0x1c, 0xd6,
      0x67, 0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b, 0xef, 0xef,
      0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99, 0x59, 0x19, 0xdd,
      0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xae},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 870
    {SEC_OID_SHA256,
     870,
     {0x30, 0x82, 0x01, 0x23, 0x02, 0x82, 0x01, 0x01, 0x00, 0x8f, 0x79, 0x35,
      0xd9, 0xb9, 0xaa, 0xe9, 0xbf, 0xab, 0xed, 0x88, 0x7a, 0xcf, 0x49, 0x51,
      0xb6, 0xf3, 0x2e, 0xc5, 0x9e, 0x3b, 0xaf, 0x37, 0x18, 0xe8, 0xea, 0xc4,
      0x96, 0x1f, 0x3e, 0xfd, 0x36, 0x06, 0xe7, 0x43, 0x51, 0xa9, 0xc4, 0x18,
      0x33, 0x39, 0xb8, 0x09, 0xe7, 0xc2, 0xae, 0x1c, 0x53, 0x9b, 0xa7, 0x47,
      0x5b, 0x85, 0xd0, 0x11, 0xad, 0xb8, 0xb4, 0x79, 0x87, 0x75, 0x49, 0x84,
      0x69, 0x5c, 0xac, 0x0e, 0x8f, 0x14, 0xb3, 0x36, 0x08, 0x28, 0xa2, 0x2f,
      0xfa, 0x27, 0x11, 0x0a, 0x3d, 0x62, 0xa9, 0x93, 0x45, 0x34, 0x09, 0xa0,
      0xfe, 0x69, 0x6c, 0x46, 0x58, 0xf8, 0x4b, 0xdd, 0x20, 0x81, 0x9c, 0x37,
      0x09, 0xa0, 0x10, 0x57, 0xb1, 0x95, 0xad, 0xcd, 0x00, 0x23, 0x3d, 0xba,
      0x54, 0x84, 0xb6, 0x29, 0x1f, 0x9d, 0x64, 0x8e, 0xf8, 0x83, 0x44, 0x86,
      0x77, 0x97, 0x9c, 0xec, 0x04, 0xb4, 0x34, 0xa6, 0xac, 0x2e, 0x75, 0xe9,
      0x98, 0x5d, 0xe2, 0x3d, 0xb0, 0x29, 0x2f, 0xc1, 0x11, 0x8c, 0x9f, 0xfa,
      0x9d, 0x81, 0x81, 0xe7, 0x33, 0x8d, 0xb7, 0x92, 0xb7, 0x30, 0xd7, 0xb9,
      0xe3, 0x49, 0x59, 0x2f, 0x68, 0x09, 0x98, 0x72, 0x15, 0x39, 0x15, 0xea,
      0x3d, 0x6b, 0x8b, 0x46, 0x53, 0xc6, 0x33, 0x45, 0x8f, 0x80, 0x3b, 0x32,
      0xa4, 0xc2, 0xe0, 0xf2, 0x72, 0x90, 0x25, 0x6e, 0x4e, 0x3f, 0x8a, 0x3b,
      0x08, 0x38, 0xa1, 0xc4, 0x50, 0xe4, 0xe1, 0x8c, 0x1a, 0x29, 0xa3, 0x7d,
      0xdf, 0x5e, 0xa1, 0x43, 0xde, 0x4b, 0x66, 0xff, 0x04, 0x90, 0x3e, 0xd5,
      0xcf, 0x16, 0x23, 0xe1, 0x58, 0xd4, 0x87, 0xc6, 0x08, 0xe9, 0x7f, 0x21,
      0x1c, 0xd8, 0x1d, 0xca, 0x23, 0xcb, 0x6e, 0x38, 0x07, 0x65, 0xf8, 0x22,
      0xe3, 0x42, 0xbe, 0x48, 0x4c, 0x05, 0x76, 0x39, 0x39, 0x60, 0x1c, 0xd6,
      0x67, 0x02, 0x1c, 0x5d, 0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b, 0xef, 0xef,
      0x73, 0xfd, 0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99, 0x59, 0x19, 0xdd,
      0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xaf},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 871
    {SEC_OID_SHA256,
     871,
     {0x30, 0x82, 0x01, 0x24, 0x02, 0x82, 0x01, 0x01, 0x00, 0x8f, 0x79, 0x35,
      0xd9, 0xb9, 0xaa, 0xe9, 0xbf, 0xab, 0xed, 0x88, 0x7a, 0xcf, 0x49, 0x51,
      0xb6, 0xf3, 0x2e, 0xc5, 0x9e, 0x3b, 0xaf, 0x37, 0x18, 0xe8, 0xea, 0xc4,
      0x96, 0x1f, 0x3e, 0xfd, 0x36, 0x06, 0xe7, 0x43, 0x51, 0xa9, 0xc4, 0x18,
      0x33, 0x39, 0xb8, 0x09, 0xe7, 0xc2, 0xae, 0x1c, 0x53, 0x9b, 0xa7, 0x47,
      0x5b, 0x85, 0xd0, 0x11, 0xad, 0xb8, 0xb4, 0x79, 0x87, 0x75, 0x49, 0x84,
      0x69, 0x5c, 0xac, 0x0e, 0x8f, 0x14, 0xb3, 0x36, 0x08, 0x28, 0xa2, 0x2f,
      0xfa, 0x27, 0x11, 0x0a, 0x3d, 0x62, 0xa9, 0x93, 0x45, 0x34, 0x09, 0xa0,
      0xfe, 0x69, 0x6c, 0x46, 0x58, 0xf8, 0x4b, 0xdd, 0x20, 0x81, 0x9c, 0x37,
      0x09, 0xa0, 0x10, 0x57, 0xb1, 0x95, 0xad, 0xcd, 0x00, 0x23, 0x3d, 0xba,
      0x54, 0x84, 0xb6, 0x29, 0x1f, 0x9d, 0x64, 0x8e, 0xf8, 0x83, 0x44, 0x86,
      0x77, 0x97, 0x9c, 0xec, 0x04, 0xb4, 0x34, 0xa6, 0xac, 0x2e, 0x75, 0xe9,
      0x98, 0x5d, 0xe2, 0x3d, 0xb0, 0x29, 0x2f, 0xc1, 0x11, 0x8c, 0x9f, 0xfa,
      0x9d, 0x81, 0x81, 0xe7, 0x33, 0x8d, 0xb7, 0x92, 0xb7, 0x30, 0xd7, 0xb9,
      0xe3, 0x49, 0x59, 0x2f, 0x68, 0x09, 0x98, 0x72, 0x15, 0x39, 0x15, 0xea,
      0x3d, 0x6b, 0x8b, 0x46, 0x53, 0xc6, 0x33, 0x45, 0x8f, 0x80, 0x3b, 0x32,
      0xa4, 0xc2, 0xe0, 0xf2, 0x72, 0x90, 0x25, 0x6e, 0x4e, 0x3f, 0x8a, 0x3b,
      0x08, 0x38, 0xa1, 0xc4, 0x50, 0xe4, 0xe1, 0x8c, 0x1a, 0x29, 0xa3, 0x7d,
      0xdf, 0x5e, 0xa1, 0x43, 0xde, 0x4b, 0x66, 0xff, 0x04, 0x90, 0x3e, 0xd5,
      0xcf, 0x16, 0x23, 0xe1, 0x58, 0xd4, 0x87, 0xc6, 0x08, 0xe9, 0x7f, 0x21,
      0x1c, 0xd8, 0x1d, 0xca, 0x23, 0xcb, 0x6e, 0x38, 0x07, 0x65, 0xf8, 0x22,
      0xe3, 0x42, 0xbe, 0x48, 0x4c, 0x05, 0x76, 0x39, 0x39, 0x60, 0x1c, 0xd6,
      0x67, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7, 0xdf,
      0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2, 0x33,
      0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5c},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 872
    {SEC_OID_SHA256,
     872,
     {0x30, 0x82, 0x01, 0x24, 0x02, 0x82, 0x01, 0x01, 0x00, 0x8f, 0x79, 0x35,
      0xd9, 0xb9, 0xaa, 0xe9, 0xbf, 0xab, 0xed, 0x88, 0x7a, 0xcf, 0x49, 0x51,
      0xb6, 0xf3, 0x2e, 0xc5, 0x9e, 0x3b, 0xaf, 0x37, 0x18, 0xe8, 0xea, 0xc4,
      0x96, 0x1f, 0x3e, 0xfd, 0x36, 0x06, 0xe7, 0x43, 0x51, 0xa9, 0xc4, 0x18,
      0x33, 0x39, 0xb8, 0x09, 0xe7, 0xc2, 0xae, 0x1c, 0x53, 0x9b, 0xa7, 0x47,
      0x5b, 0x85, 0xd0, 0x11, 0xad, 0xb8, 0xb4, 0x79, 0x87, 0x75, 0x49, 0x84,
      0x69, 0x5c, 0xac, 0x0e, 0x8f, 0x14, 0xb3, 0x36, 0x08, 0x28, 0xa2, 0x2f,
      0xfa, 0x27, 0x11, 0x0a, 0x3d, 0x62, 0xa9, 0x93, 0x45, 0x34, 0x09, 0xa0,
      0xfe, 0x69, 0x6c, 0x46, 0x58, 0xf8, 0x4b, 0xdd, 0x20, 0x81, 0x9c, 0x37,
      0x09, 0xa0, 0x10, 0x57, 0xb1, 0x95, 0xad, 0xcd, 0x00, 0x23, 0x3d, 0xba,
      0x54, 0x84, 0xb6, 0x29, 0x1f, 0x9d, 0x64, 0x8e, 0xf8, 0x83, 0x44, 0x86,
      0x77, 0x97, 0x9c, 0xec, 0x04, 0xb4, 0x34, 0xa6, 0xac, 0x2e, 0x75, 0xe9,
      0x98, 0x5d, 0xe2, 0x3d, 0xb0, 0x29, 0x2f, 0xc1, 0x11, 0x8c, 0x9f, 0xfa,
      0x9d, 0x81, 0x81, 0xe7, 0x33, 0x8d, 0xb7, 0x92, 0xb7, 0x30, 0xd7, 0xb9,
      0xe3, 0x49, 0x59, 0x2f, 0x68, 0x09, 0x98, 0x72, 0x15, 0x39, 0x15, 0xea,
      0x3d, 0x6b, 0x8b, 0x46, 0x53, 0xc6, 0x33, 0x45, 0x8f, 0x80, 0x3b, 0x32,
      0xa4, 0xc2, 0xe0, 0xf2, 0x72, 0x90, 0x25, 0x6e, 0x4e, 0x3f, 0x8a, 0x3b,
      0x08, 0x38, 0xa1, 0xc4, 0x50, 0xe4, 0xe1, 0x8c, 0x1a, 0x29, 0xa3, 0x7d,
      0xdf, 0x5e, 0xa1, 0x43, 0xde, 0x4b, 0x66, 0xff, 0x04, 0x90, 0x3e, 0xd5,
      0xcf, 0x16, 0x23, 0xe1, 0x58, 0xd4, 0x87, 0xc6, 0x08, 0xe9, 0x7f, 0x21,
      0x1c, 0xd8, 0x1d, 0xca, 0x23, 0xcb, 0x6e, 0x38, 0x07, 0x65, 0xf8, 0x22,
      0xe3, 0x42, 0xbe, 0x48, 0x4c, 0x05, 0x76, 0x39, 0x39, 0x60, 0x1c, 0xd6,
      0x67, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7, 0xdf,
      0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2, 0x33,
      0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5d},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 873
    {SEC_OID_SHA256,
     873,
     {0x30, 0x82, 0x01, 0x24, 0x02, 0x82, 0x01, 0x01, 0x00, 0x8f, 0x79, 0x35,
      0xd9, 0xb9, 0xaa, 0xe9, 0xbf, 0xab, 0xed, 0x88, 0x7a, 0xcf, 0x49, 0x51,
      0xb6, 0xf3, 0x2e, 0xc5, 0x9e, 0x3b, 0xaf, 0x37, 0x18, 0xe8, 0xea, 0xc4,
      0x96, 0x1f, 0x3e, 0xfd, 0x36, 0x06, 0xe7, 0x43, 0x51, 0xa9, 0xc4, 0x18,
      0x33, 0x39, 0xb8, 0x09, 0xe7, 0xc2, 0xae, 0x1c, 0x53, 0x9b, 0xa7, 0x47,
      0x5b, 0x85, 0xd0, 0x11, 0xad, 0xb8, 0xb4, 0x79, 0x87, 0x75, 0x49, 0x84,
      0x69, 0x5c, 0xac, 0x0e, 0x8f, 0x14, 0xb3, 0x36, 0x08, 0x28, 0xa2, 0x2f,
      0xfa, 0x27, 0x11, 0x0a, 0x3d, 0x62, 0xa9, 0x93, 0x45, 0x34, 0x09, 0xa0,
      0xfe, 0x69, 0x6c, 0x46, 0x58, 0xf8, 0x4b, 0xdd, 0x20, 0x81, 0x9c, 0x37,
      0x09, 0xa0, 0x10, 0x57, 0xb1, 0x95, 0xad, 0xcd, 0x00, 0x23, 0x3d, 0xba,
      0x54, 0x84, 0xb6, 0x29, 0x1f, 0x9d, 0x64, 0x8e, 0xf8, 0x83, 0x44, 0x86,
      0x77, 0x97, 0x9c, 0xec, 0x04, 0xb4, 0x34, 0xa6, 0xac, 0x2e, 0x75, 0xe9,
      0x98, 0x5d, 0xe2, 0x3d, 0xb0, 0x29, 0x2f, 0xc1, 0x11, 0x8c, 0x9f, 0xfa,
      0x9d, 0x81, 0x81, 0xe7, 0x33, 0x8d, 0xb7, 0x92, 0xb7, 0x30, 0xd7, 0xb9,
      0xe3, 0x49, 0x59, 0x2f, 0x68, 0x09, 0x98, 0x72, 0x15, 0x39, 0x15, 0xea,
      0x3d, 0x6b, 0x8b, 0x46, 0x53, 0xc6, 0x33, 0x45, 0x8f, 0x80, 0x3b, 0x32,
      0xa4, 0xc2, 0xe0, 0xf2, 0x72, 0x90, 0x25, 0x6e, 0x4e, 0x3f, 0x8a, 0x3b,
      0x08, 0x38, 0xa1, 0xc4, 0x50, 0xe4, 0xe1, 0x8c, 0x1a, 0x29, 0xa3, 0x7d,
      0xdf, 0x5e, 0xa1, 0x43, 0xde, 0x4b, 0x66, 0xff, 0x04, 0x90, 0x3e, 0xd5,
      0xcf, 0x16, 0x23, 0xe1, 0x58, 0xd4, 0x87, 0xc6, 0x08, 0xe9, 0x7f, 0x21,
      0x1c, 0xd8, 0x1d, 0xca, 0x23, 0xcb, 0x6e, 0x38, 0x07, 0x65, 0xf8, 0x22,
      0xe3, 0x42, 0xbe, 0x48, 0x4c, 0x05, 0x76, 0x39, 0x39, 0x60, 0x1c, 0xd6,
      0x67, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7, 0xdf,
      0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2, 0x33,
      0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5e},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 874
    {SEC_OID_SHA256,
     874,
     {0x30, 0x82, 0x01, 0x24, 0x02, 0x82, 0x01, 0x01, 0x00, 0x8f, 0x79, 0x35,
      0xd9, 0xb9, 0xaa, 0xe9, 0xbf, 0xab, 0xed, 0x88, 0x7a, 0xcf, 0x49, 0x51,
      0xb6, 0xf3, 0x2e, 0xc5, 0x9e, 0x3b, 0xaf, 0x37, 0x18, 0xe8, 0xea, 0xc4,
      0x96, 0x1f, 0x3e, 0xfd, 0x36, 0x06, 0xe7, 0x43, 0x51, 0xa9, 0xc4, 0x18,
      0x33, 0x39, 0xb8, 0x09, 0xe7, 0xc2, 0xae, 0x1c, 0x53, 0x9b, 0xa7, 0x47,
      0x5b, 0x85, 0xd0, 0x11, 0xad, 0xb8, 0xb4, 0x79, 0x87, 0x75, 0x49, 0x84,
      0x69, 0x5c, 0xac, 0x0e, 0x8f, 0x14, 0xb3, 0x36, 0x08, 0x28, 0xa2, 0x2f,
      0xfa, 0x27, 0x11, 0x0a, 0x3d, 0x62, 0xa9, 0x93, 0x45, 0x34, 0x09, 0xa0,
      0xfe, 0x69, 0x6c, 0x46, 0x58, 0xf8, 0x4b, 0xdd, 0x20, 0x81, 0x9c, 0x37,
      0x09, 0xa0, 0x10, 0x57, 0xb1, 0x95, 0xad, 0xcd, 0x00, 0x23, 0x3d, 0xba,
      0x54, 0x84, 0xb6, 0x29, 0x1f, 0x9d, 0x64, 0x8e, 0xf8, 0x83, 0x44, 0x86,
      0x77, 0x97, 0x9c, 0xec, 0x04, 0xb4, 0x34, 0xa6, 0xac, 0x2e, 0x75, 0xe9,
      0x98, 0x5d, 0xe2, 0x3d, 0xb0, 0x29, 0x2f, 0xc1, 0x11, 0x8c, 0x9f, 0xfa,
      0x9d, 0x81, 0x81, 0xe7, 0x33, 0x8d, 0xb7, 0x92, 0xb7, 0x30, 0xd7, 0xb9,
      0xe3, 0x49, 0x59, 0x2f, 0x68, 0x09, 0x98, 0x72, 0x15, 0x39, 0x15, 0xea,
      0x3d, 0x6b, 0x8b, 0x46, 0x53, 0xc6, 0x33, 0x45, 0x8f, 0x80, 0x3b, 0x32,
      0xa4, 0xc2, 0xe0, 0xf2, 0x72, 0x90, 0x25, 0x6e, 0x4e, 0x3f, 0x8a, 0x3b,
      0x08, 0x38, 0xa1, 0xc4, 0x50, 0xe4, 0xe1, 0x8c, 0x1a, 0x29, 0xa3, 0x7d,
      0xdf, 0x5e, 0xa1, 0x43, 0xde, 0x4b, 0x66, 0xff, 0x04, 0x90, 0x3e, 0xd5,
      0xcf, 0x16, 0x23, 0xe1, 0x58, 0xd4, 0x87, 0xc6, 0x08, 0xe9, 0x7f, 0x21,
      0x1c, 0xd8, 0x1d, 0xca, 0x23, 0xcb, 0x6e, 0x38, 0x07, 0x65, 0xf8, 0x22,
      0xe3, 0x42, 0xbe, 0x48, 0x4c, 0x05, 0x76, 0x39, 0x39, 0x60, 0x1c, 0xd6,
      0x67, 0x02, 0x1d, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 875
    {SEC_OID_SHA256,
     875,
     {0x30, 0x82, 0x02, 0x0a, 0x02, 0x82, 0x01, 0x01, 0x00, 0x8f, 0x79, 0x35,
      0xd9, 0xb9, 0xaa, 0xe9, 0xbf, 0xab, 0xed, 0x88, 0x7a, 0xcf, 0x49, 0x51,
      0xb6, 0xf3, 0x2e, 0xc5, 0x9e, 0x3b, 0xaf, 0x37, 0x18, 0xe8, 0xea, 0xc4,
      0x96, 0x1f, 0x3e, 0xfd, 0x36, 0x06, 0xe7, 0x43, 0x51, 0xa9, 0xc4, 0x18,
      0x33, 0x39, 0xb8, 0x09, 0xe7, 0xc2, 0xae, 0x1c, 0x53, 0x9b, 0xa7, 0x47,
      0x5b, 0x85, 0xd0, 0x11, 0xad, 0xb8, 0xb4, 0x79, 0x87, 0x75, 0x49, 0x84,
      0x69, 0x5c, 0xac, 0x0e, 0x8f, 0x14, 0xb3, 0x36, 0x08, 0x28, 0xa2, 0x2f,
      0xfa, 0x27, 0x11, 0x0a, 0x3d, 0x62, 0xa9, 0x93, 0x45, 0x34, 0x09, 0xa0,
      0xfe, 0x69, 0x6c, 0x46, 0x58, 0xf8, 0x4b, 0xdd, 0x20, 0x81, 0x9c, 0x37,
      0x09, 0xa0, 0x10, 0x57, 0xb1, 0x95, 0xad, 0xcd, 0x00, 0x23, 0x3d, 0xba,
      0x54, 0x84, 0xb6, 0x29, 0x1f, 0x9d, 0x64, 0x8e, 0xf8, 0x83, 0x44, 0x86,
      0x77, 0x97, 0x9c, 0xec, 0x04, 0xb4, 0x34, 0xa6, 0xac, 0x2e, 0x75, 0xe9,
      0x98, 0x5d, 0xe2, 0x3d, 0xb0, 0x29, 0x2f, 0xc1, 0x11, 0x8c, 0x9f, 0xfa,
      0x9d, 0x81, 0x81, 0xe7, 0x33, 0x8d, 0xb7, 0x92, 0xb7, 0x30, 0xd7, 0xb9,
      0xe3, 0x49, 0x59, 0x2f, 0x68, 0x09, 0x98, 0x72, 0x15, 0x39, 0x15, 0xea,
      0x3d, 0x6b, 0x8b, 0x46, 0x53, 0xc6, 0x33, 0x45, 0x8f, 0x80, 0x3b, 0x32,
      0xa4, 0xc2, 0xe0, 0xf2, 0x72, 0x90, 0x25, 0x6e, 0x4e, 0x3f, 0x8a, 0x3b,
      0x08, 0x38, 0xa1, 0xc4, 0x50, 0xe4, 0xe1, 0x8c, 0x1a, 0x29, 0xa3, 0x7d,
      0xdf, 0x5e, 0xa1, 0x43, 0xde, 0x4b, 0x66, 0xff, 0x04, 0x90, 0x3e, 0xd5,
      0xcf, 0x16, 0x23, 0xe1, 0x58, 0xd4, 0x87, 0xc6, 0x08, 0xe9, 0x7f, 0x21,
      0x1c, 0xd8, 0x1d, 0xca, 0x23, 0xcb, 0x6e, 0x38, 0x07, 0x65, 0xf8, 0x22,
      0xe3, 0x42, 0xbe, 0x48, 0x4c, 0x05, 0x76, 0x39, 0x39, 0x60, 0x1c, 0xd6,
      0x67, 0x02, 0x82, 0x01, 0x01, 0x00, 0x8f, 0x79, 0x35, 0xd9, 0xb9, 0xaa,
      0xe9, 0xbf, 0xab, 0xed, 0x88, 0x7a, 0xcf, 0x49, 0x51, 0xb6, 0xf3, 0x2e,
      0xc5, 0x9e, 0x3b, 0xaf, 0x37, 0x18, 0xe8, 0xea, 0xc4, 0x96, 0x1f, 0x3e,
      0xfd, 0x36, 0x06, 0xe7, 0x43, 0x51, 0xa9, 0xc4, 0x18, 0x33, 0x39, 0xb8,
      0x09, 0xe7, 0xc2, 0xae, 0x1c, 0x53, 0x9b, 0xa7, 0x47, 0x5b, 0x85, 0xd0,
      0x11, 0xad, 0xb8, 0xb4, 0x79, 0x87, 0x75, 0x49, 0x84, 0x69, 0x5c, 0xac,
      0x0e, 0x8f, 0x14, 0xb3, 0x36, 0x08, 0x28, 0xa2, 0x2f, 0xfa, 0x27, 0x11,
      0x0a, 0x3d, 0x62, 0xa9, 0x93, 0x45, 0x34, 0x09, 0xa0, 0xfe, 0x69, 0x6c,
      0x46, 0x58, 0xf8, 0x4b, 0xdd, 0x20, 0x81, 0x9c, 0x37, 0x09, 0xa0, 0x10,
      0x57, 0xb1, 0x95, 0xad, 0xcd, 0x00, 0x23, 0x3d, 0xba, 0x54, 0x84, 0xb6,
      0x29, 0x1f, 0x9d, 0x64, 0x8e, 0xf8, 0x83, 0x44, 0x86, 0x77, 0x97, 0x9c,
      0xec, 0x04, 0xb4, 0x34, 0xa6, 0xac, 0x2e, 0x75, 0xe9, 0x98, 0x5d, 0xe2,
      0x3d, 0xb0, 0x29, 0x2f, 0xc1, 0x11, 0x8c, 0x9f, 0xfa, 0x9d, 0x81, 0x81,
      0xe7, 0x33, 0x8d, 0xb7, 0x92, 0xb7, 0x30, 0xd7, 0xb9, 0xe3, 0x49, 0x59,
      0x2f, 0x68, 0x09, 0x98, 0x72, 0x15, 0x39, 0x15, 0xea, 0x3d, 0x6b, 0x8b,
      0x46, 0x53, 0xc6, 0x33, 0x45, 0x8f, 0x80, 0x3b, 0x32, 0xa4, 0xc2, 0xe0,
      0xf2, 0x72, 0x90, 0x25, 0x6e, 0x4e, 0x3f, 0x8a, 0x3b, 0x08, 0x38, 0xa1,
      0xc4, 0x50, 0xe4, 0xe1, 0x8c, 0x1a, 0x29, 0xa3, 0x7d, 0xdf, 0x5e, 0xa1,
      0x43, 0xde, 0x4b, 0x66, 0xff, 0x04, 0x90, 0x3e, 0xd5, 0xcf, 0x16, 0x23,
      0xe1, 0x58, 0xd4, 0x87, 0xc6, 0x08, 0xe9, 0x7f, 0x21, 0x1c, 0xd8, 0x1d,
      0xca, 0x23, 0xcb, 0x6e, 0x38, 0x07, 0x65, 0xf8, 0x22, 0xe3, 0x42, 0xbe,
      0x48, 0x4c, 0x05, 0x76, 0x39, 0x39, 0x60, 0x1c, 0xd6, 0x67},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 876
    {SEC_OID_SHA256,
     876,
     {0x30, 0x82, 0x01, 0x0a, 0x02, 0x82, 0x01, 0x01, 0x00, 0x8f, 0x79, 0x35,
      0xd9, 0xb9, 0xaa, 0xe9, 0xbf, 0xab, 0xed, 0x88, 0x7a, 0xcf, 0x49, 0x51,
      0xb6, 0xf3, 0x2e, 0xc5, 0x9e, 0x3b, 0xaf, 0x37, 0x18, 0xe8, 0xea, 0xc4,
      0x96, 0x1f, 0x3e, 0xfd, 0x36, 0x06, 0xe7, 0x43, 0x51, 0xa9, 0xc4, 0x18,
      0x33, 0x39, 0xb8, 0x09, 0xe7, 0xc2, 0xae, 0x1c, 0x53, 0x9b, 0xa7, 0x47,
      0x5b, 0x85, 0xd0, 0x11, 0xad, 0xb8, 0xb4, 0x79, 0x87, 0x75, 0x49, 0x84,
      0x69, 0x5c, 0xac, 0x0e, 0x8f, 0x14, 0xb3, 0x36, 0x08, 0x28, 0xa2, 0x2f,
      0xfa, 0x27, 0x11, 0x0a, 0x3d, 0x62, 0xa9, 0x93, 0x45, 0x34, 0x09, 0xa0,
      0xfe, 0x69, 0x6c, 0x46, 0x58, 0xf8, 0x4b, 0xdd, 0x20, 0x81, 0x9c, 0x37,
      0x09, 0xa0, 0x10, 0x57, 0xb1, 0x95, 0xad, 0xcd, 0x00, 0x23, 0x3d, 0xba,
      0x54, 0x84, 0xb6, 0x29, 0x1f, 0x9d, 0x64, 0x8e, 0xf8, 0x83, 0x44, 0x86,
      0x77, 0x97, 0x9c, 0xec, 0x04, 0xb4, 0x34, 0xa6, 0xac, 0x2e, 0x75, 0xe9,
      0x98, 0x5d, 0xe2, 0x3d, 0xb0, 0x29, 0x2f, 0xc1, 0x11, 0x8c, 0x9f, 0xfa,
      0x9d, 0x81, 0x81, 0xe7, 0x33, 0x8d, 0xb7, 0x92, 0xb7, 0x30, 0xd7, 0xb9,
      0xe3, 0x49, 0x59, 0x2f, 0x68, 0x09, 0x98, 0x72, 0x15, 0x39, 0x15, 0xea,
      0x3d, 0x6b, 0x8b, 0x46, 0x53, 0xc6, 0x33, 0x45, 0x8f, 0x80, 0x3b, 0x32,
      0xa4, 0xc2, 0xe0, 0xf2, 0x72, 0x90, 0x25, 0x6e, 0x4e, 0x3f, 0x8a, 0x3b,
      0x08, 0x38, 0xa1, 0xc4, 0x50, 0xe4, 0xe1, 0x8c, 0x1a, 0x29, 0xa3, 0x7d,
      0xdf, 0x5e, 0xa1, 0x43, 0xde, 0x4b, 0x66, 0xff, 0x04, 0x90, 0x3e, 0xd5,
      0xcf, 0x16, 0x23, 0xe1, 0x58, 0xd4, 0x87, 0xc6, 0x08, 0xe9, 0x7f, 0x21,
      0x1c, 0xd8, 0x1d, 0xca, 0x23, 0xcb, 0x6e, 0x38, 0x07, 0x65, 0xf8, 0x22,
      0xe3, 0x42, 0xbe, 0x48, 0x4c, 0x05, 0x76, 0x39, 0x39, 0x60, 0x1c, 0xd6,
      0x67, 0x09, 0x03, 0x80, 0xfe, 0x01},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 877
    {SEC_OID_SHA256,
     877,
     {0x30, 0x82, 0x01, 0x08, 0x02, 0x82, 0x01, 0x01, 0x00, 0x8f, 0x79, 0x35,
      0xd9, 0xb9, 0xaa, 0xe9, 0xbf, 0xab, 0xed, 0x88, 0x7a, 0xcf, 0x49, 0x51,
      0xb6, 0xf3, 0x2e, 0xc5, 0x9e, 0x3b, 0xaf, 0x37, 0x18, 0xe8, 0xea, 0xc4,
      0x96, 0x1f, 0x3e, 0xfd, 0x36, 0x06, 0xe7, 0x43, 0x51, 0xa9, 0xc4, 0x18,
      0x33, 0x39, 0xb8, 0x09, 0xe7, 0xc2, 0xae, 0x1c, 0x53, 0x9b, 0xa7, 0x47,
      0x5b, 0x85, 0xd0, 0x11, 0xad, 0xb8, 0xb4, 0x79, 0x87, 0x75, 0x49, 0x84,
      0x69, 0x5c, 0xac, 0x0e, 0x8f, 0x14, 0xb3, 0x36, 0x08, 0x28, 0xa2, 0x2f,
      0xfa, 0x27, 0x11, 0x0a, 0x3d, 0x62, 0xa9, 0x93, 0x45, 0x34, 0x09, 0xa0,
      0xfe, 0x69, 0x6c, 0x46, 0x58, 0xf8, 0x4b, 0xdd, 0x20, 0x81, 0x9c, 0x37,
      0x09, 0xa0, 0x10, 0x57, 0xb1, 0x95, 0xad, 0xcd, 0x00, 0x23, 0x3d, 0xba,
      0x54, 0x84, 0xb6, 0x29, 0x1f, 0x9d, 0x64, 0x8e, 0xf8, 0x83, 0x44, 0x86,
      0x77, 0x97, 0x9c, 0xec, 0x04, 0xb4, 0x34, 0xa6, 0xac, 0x2e, 0x75, 0xe9,
      0x98, 0x5d, 0xe2, 0x3d, 0xb0, 0x29, 0x2f, 0xc1, 0x11, 0x8c, 0x9f, 0xfa,
      0x9d, 0x81, 0x81, 0xe7, 0x33, 0x8d, 0xb7, 0x92, 0xb7, 0x30, 0xd7, 0xb9,
      0xe3, 0x49, 0x59, 0x2f, 0x68, 0x09, 0x98, 0x72, 0x15, 0x39, 0x15, 0xea,
      0x3d, 0x6b, 0x8b, 0x46, 0x53, 0xc6, 0x33, 0x45, 0x8f, 0x80, 0x3b, 0x32,
      0xa4, 0xc2, 0xe0, 0xf2, 0x72, 0x90, 0x25, 0x6e, 0x4e, 0x3f, 0x8a, 0x3b,
      0x08, 0x38, 0xa1, 0xc4, 0x50, 0xe4, 0xe1, 0x8c, 0x1a, 0x29, 0xa3, 0x7d,
      0xdf, 0x5e, 0xa1, 0x43, 0xde, 0x4b, 0x66, 0xff, 0x04, 0x90, 0x3e, 0xd5,
      0xcf, 0x16, 0x23, 0xe1, 0x58, 0xd4, 0x87, 0xc6, 0x08, 0xe9, 0x7f, 0x21,
      0x1c, 0xd8, 0x1d, 0xca, 0x23, 0xcb, 0x6e, 0x38, 0x07, 0x65, 0xf8, 0x22,
      0xe3, 0x42, 0xbe, 0x48, 0x4c, 0x05, 0x76, 0x39, 0x39, 0x60, 0x1c, 0xd6,
      0x67, 0x09, 0x01, 0x42},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 878
    {SEC_OID_SHA256,
     878,
     {0x30, 0x24, 0x09, 0x03, 0x80, 0xfe, 0x01, 0x02, 0x1d, 0xff,
      0x45, 0x09, 0x69, 0x59, 0x7a, 0x87, 0x08, 0x20, 0x21, 0x18,
      0x05, 0x98, 0x36, 0x88, 0x38, 0x7a, 0x10, 0xcd, 0x4d, 0xcc,
      0x45, 0x1a, 0x7f, 0x3f, 0x43, 0x2a, 0x96, 0xa3},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 879
    {SEC_OID_SHA256,
     879,
     {0x30, 0x08, 0x09, 0x03, 0x80, 0xfe, 0x01, 0x02, 0x01, 0x00},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 880
    {SEC_OID_SHA256,
     880,
     {0x30, 0x08, 0x09, 0x03, 0x80, 0xfe, 0x01, 0x02, 0x01, 0x01},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 881
    {SEC_OID_SHA256,
     881,
     {0x30, 0x08, 0x09, 0x03, 0x80, 0xfe, 0x01, 0x02, 0x01, 0xff},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 882
    {SEC_OID_SHA256,
     882,
     {0x30, 0x23, 0x09, 0x03, 0x80, 0xfe, 0x01, 0x02, 0x1c, 0x5d,
      0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b, 0xef, 0xef, 0x73, 0xfd,
      0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99, 0x59, 0x19, 0xdd,
      0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xae},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 883
    {SEC_OID_SHA256,
     883,
     {0x30, 0x23, 0x09, 0x03, 0x80, 0xfe, 0x01, 0x02, 0x1c, 0x5d,
      0x7b, 0x4b, 0x53, 0x42, 0xbc, 0x7b, 0xef, 0xef, 0x73, 0xfd,
      0x33, 0xe4, 0xbb, 0xe3, 0xc2, 0xf7, 0x99, 0x59, 0x19, 0xdd,
      0x72, 0xc0, 0x60, 0x5e, 0x6a, 0xb4, 0xaf},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 884
    {SEC_OID_SHA256,
     884,
     {0x30, 0x24, 0x09, 0x03, 0x80, 0xfe, 0x01, 0x02, 0x1d, 0x00,
      0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7, 0xdf, 0xde, 0xe7,
      0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2, 0x33,
      0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5c},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 885
    {SEC_OID_SHA256,
     885,
     {0x30, 0x24, 0x09, 0x03, 0x80, 0xfe, 0x01, 0x02, 0x1d, 0x00,
      0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7, 0xdf, 0xde, 0xe7,
      0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2, 0x33,
      0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5d},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 886
    {SEC_OID_SHA256,
     886,
     {0x30, 0x24, 0x09, 0x03, 0x80, 0xfe, 0x01, 0x02, 0x1d, 0x00,
      0xba, 0xf6, 0x96, 0xa6, 0x85, 0x78, 0xf7, 0xdf, 0xde, 0xe7,
      0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85, 0xef, 0x32, 0xb2, 0x33,
      0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5e},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 887
    {SEC_OID_SHA256,
     887,
     {0x30, 0x24, 0x09, 0x03, 0x80, 0xfe, 0x01, 0x02, 0x1d, 0x01,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 888
    {SEC_OID_SHA256,
     888,
     {0x30, 0x82, 0x01, 0x0a, 0x09, 0x03, 0x80, 0xfe, 0x01, 0x02, 0x82, 0x01,
      0x01, 0x00, 0x8f, 0x79, 0x35, 0xd9, 0xb9, 0xaa, 0xe9, 0xbf, 0xab, 0xed,
      0x88, 0x7a, 0xcf, 0x49, 0x51, 0xb6, 0xf3, 0x2e, 0xc5, 0x9e, 0x3b, 0xaf,
      0x37, 0x18, 0xe8, 0xea, 0xc4, 0x96, 0x1f, 0x3e, 0xfd, 0x36, 0x06, 0xe7,
      0x43, 0x51, 0xa9, 0xc4, 0x18, 0x33, 0x39, 0xb8, 0x09, 0xe7, 0xc2, 0xae,
      0x1c, 0x53, 0x9b, 0xa7, 0x47, 0x5b, 0x85, 0xd0, 0x11, 0xad, 0xb8, 0xb4,
      0x79, 0x87, 0x75, 0x49, 0x84, 0x69, 0x5c, 0xac, 0x0e, 0x8f, 0x14, 0xb3,
      0x36, 0x08, 0x28, 0xa2, 0x2f, 0xfa, 0x27, 0x11, 0x0a, 0x3d, 0x62, 0xa9,
      0x93, 0x45, 0x34, 0x09, 0xa0, 0xfe, 0x69, 0x6c, 0x46, 0x58, 0xf8, 0x4b,
      0xdd, 0x20, 0x81, 0x9c, 0x37, 0x09, 0xa0, 0x10, 0x57, 0xb1, 0x95, 0xad,
      0xcd, 0x00, 0x23, 0x3d, 0xba, 0x54, 0x84, 0xb6, 0x29, 0x1f, 0x9d, 0x64,
      0x8e, 0xf8, 0x83, 0x44, 0x86, 0x77, 0x97, 0x9c, 0xec, 0x04, 0xb4, 0x34,
      0xa6, 0xac, 0x2e, 0x75, 0xe9, 0x98, 0x5d, 0xe2, 0x3d, 0xb0, 0x29, 0x2f,
      0xc1, 0x11, 0x8c, 0x9f, 0xfa, 0x9d, 0x81, 0x81, 0xe7, 0x33, 0x8d, 0xb7,
      0x92, 0xb7, 0x30, 0xd7, 0xb9, 0xe3, 0x49, 0x59, 0x2f, 0x68, 0x09, 0x98,
      0x72, 0x15, 0x39, 0x15, 0xea, 0x3d, 0x6b, 0x8b, 0x46, 0x53, 0xc6, 0x33,
      0x45, 0x8f, 0x80, 0x3b, 0x32, 0xa4, 0xc2, 0xe0, 0xf2, 0x72, 0x90, 0x25,
      0x6e, 0x4e, 0x3f, 0x8a, 0x3b, 0x08, 0x38, 0xa1, 0xc4, 0x50, 0xe4, 0xe1,
      0x8c, 0x1a, 0x29, 0xa3, 0x7d, 0xdf, 0x5e, 0xa1, 0x43, 0xde, 0x4b, 0x66,
      0xff, 0x04, 0x90, 0x3e, 0xd5, 0xcf, 0x16, 0x23, 0xe1, 0x58, 0xd4, 0x87,
      0xc6, 0x08, 0xe9, 0x7f, 0x21, 0x1c, 0xd8, 0x1d, 0xca, 0x23, 0xcb, 0x6e,
      0x38, 0x07, 0x65, 0xf8, 0x22, 0xe3, 0x42, 0xbe, 0x48, 0x4c, 0x05, 0x76,
      0x39, 0x39, 0x60, 0x1c, 0xd6, 0x67},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 889
    {SEC_OID_SHA256,
     889,
     {0x30, 0x0a, 0x09, 0x03, 0x80, 0xfe, 0x01, 0x09, 0x03, 0x80, 0xfe, 0x01},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signatures with special case values for r and s.
    // tcID: 890
    {SEC_OID_SHA256,
     890,
     {0x30, 0x08, 0x09, 0x03, 0x80, 0xfe, 0x01, 0x09, 0x01, 0x42},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signature encoding contains wrong type.
    // tcID: 891
    {SEC_OID_SHA256,
     891,
     {0x30, 0x06, 0x02, 0x01, 0x01, 0x0c, 0x01, 0x30},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signature encoding contains wrong type.
    // tcID: 892
    {SEC_OID_SHA256,
     892,
     {0x30, 0x05, 0x02, 0x01, 0x01, 0x0c, 0x00},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signature encoding contains wrong type.
    // tcID: 893
    {SEC_OID_SHA256,
     893,
     {0x30, 0x09, 0x0c, 0x02, 0x25, 0x73, 0x0c, 0x03, 0x73, 0x25, 0x73},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signature encoding contains wrong type.
    // tcID: 894
    {SEC_OID_SHA256,
     894,
     {0x30, 0x08, 0x02, 0x01, 0x01, 0x30, 0x03, 0x02, 0x01, 0x00},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signature encoding contains wrong type.
    // tcID: 895
    {SEC_OID_SHA256,
     895,
     {0x30, 0x03, 0x02, 0x01, 0x01},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: Signature encoding contains wrong type.
    // tcID: 896
    {SEC_OID_SHA256,
     896,
     {0x30, 0x06, 0x02, 0x01, 0x01, 0x01, 0x01, 0x00},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     false},

    // Comment: random signature
    // tcID: 897
    {SEC_OID_SHA256,
     897,
     {0x30, 0x3c, 0x02, 0x1c, 0x29, 0x64, 0x10, 0xb8, 0xcb, 0x62, 0x00,
      0xed, 0xaf, 0xd1, 0x20, 0x5e, 0x73, 0x77, 0xa0, 0x9a, 0xd2, 0x01,
      0x1a, 0xc7, 0xb1, 0x5b, 0x8b, 0xc9, 0xb9, 0xb4, 0xc6, 0xdb, 0x02,
      0x1c, 0x25, 0xca, 0x28, 0x3c, 0x86, 0x8d, 0xc2, 0xa5, 0xce, 0x86,
      0xaa, 0xfc, 0xf6, 0x81, 0xce, 0x21, 0xd6, 0x60, 0xb4, 0x61, 0xda,
      0x48, 0x27, 0x0f, 0x15, 0xb5, 0x38, 0x89},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     true},

    // Comment: random signature
    // tcID: 898
    {SEC_OID_SHA256,
     898,
     {0x30, 0x3d, 0x02, 0x1c, 0x34, 0x7c, 0x4f, 0x68, 0x75, 0xbf, 0x44,
      0x76, 0xaf, 0xbd, 0xd6, 0xb2, 0xb1, 0xf9, 0xe3, 0x5c, 0x87, 0x0e,
      0x78, 0x5e, 0x70, 0x8e, 0x66, 0x11, 0x09, 0xbd, 0x06, 0x8e, 0x02,
      0x1d, 0x00, 0xb0, 0xb9, 0x08, 0xa6, 0x17, 0xd3, 0xad, 0x6c, 0x8b,
      0xc2, 0x77, 0xf3, 0x97, 0x09, 0x5c, 0x00, 0xe6, 0x59, 0xc8, 0x6c,
      0xa7, 0xc6, 0x00, 0x09, 0x05, 0x71, 0xab, 0x17},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     true},

    // Comment: random signature
    // tcID: 899
    {SEC_OID_SHA256,
     899,
     {0x30, 0x3c, 0x02, 0x1c, 0x3c, 0x76, 0xbc, 0x6f, 0x17, 0x36, 0x94,
      0x14, 0xd4, 0xc2, 0x1c, 0x53, 0x61, 0xed, 0x0c, 0xca, 0x6e, 0x79,
      0xf7, 0x3f, 0x90, 0x70, 0x6f, 0x1f, 0x7c, 0xa9, 0xf0, 0x5a, 0x02,
      0x1c, 0x3c, 0xc6, 0x0d, 0x8a, 0x0d, 0x44, 0xfb, 0x96, 0x7b, 0xaa,
      0x0e, 0x56, 0x21, 0xe1, 0x2c, 0xd4, 0x34, 0xaa, 0xfd, 0x74, 0x8c,
      0xba, 0x3e, 0x7c, 0xdc, 0x73, 0x3b, 0x2f},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     true},

    // Comment: random signature
    // tcID: 900
    {SEC_OID_SHA256,
     900,
     {0x30, 0x3e, 0x02, 0x1d, 0x00, 0x86, 0xa5, 0xef, 0xea, 0x8e, 0x6a,
      0x80, 0x33, 0xb8, 0xa0, 0x03, 0x4b, 0x52, 0xae, 0x61, 0x4e, 0x1f,
      0x14, 0xfb, 0xcb, 0xfa, 0x0b, 0xb5, 0x01, 0x94, 0xef, 0xa6, 0xa7,
      0x02, 0x1d, 0x00, 0xb3, 0xd6, 0x6f, 0x6d, 0x2b, 0x10, 0xcf, 0xe6,
      0x2f, 0xe9, 0x6b, 0x78, 0xfc, 0xf4, 0x1c, 0xa7, 0xb4, 0x42, 0xac,
      0xeb, 0x98, 0xab, 0x10, 0x9a, 0x01, 0x40, 0x9e, 0x4a},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     true},

    // Comment: random signature
    // tcID: 901
    {SEC_OID_SHA256,
     901,
     {0x30, 0x3d, 0x02, 0x1c, 0x16, 0x72, 0x7d, 0x52, 0xbd, 0x71, 0x1e,
      0x9a, 0x63, 0xe0, 0xdd, 0x2c, 0x4d, 0xb0, 0x45, 0xcf, 0xb9, 0x93,
      0x94, 0x2b, 0x1e, 0x39, 0xe4, 0xf4, 0x3a, 0x65, 0xc1, 0x1a, 0x02,
      0x1d, 0x00, 0x9f, 0xb9, 0xc0, 0x2d, 0x10, 0xc9, 0x68, 0xe7, 0x5b,
      0xb1, 0x5a, 0xca, 0xb8, 0x46, 0x7f, 0x30, 0xb8, 0x44, 0x81, 0xf6,
      0x79, 0xe1, 0x36, 0xe8, 0xaf, 0x65, 0xa2, 0x66},
     kPubKey3,
     {0x54, 0x65, 0x73, 0x74},
     true},

    // Comment: r,s = 1,1
    // tcID: 902
    {SEC_OID_SHA256,
     902,
     {0x30, 0x06, 0x02, 0x01, 0x01, 0x02, 0x01, 0x01},
     kPubKey6,
     {0x54, 0x65, 0x73, 0x74},
     true},

    // Comment: r,s = 1,5
    // tcID: 903
    {SEC_OID_SHA256,
     903,
     {0x30, 0x06, 0x02, 0x01, 0x01, 0x02, 0x01, 0x05},
     kPubKey6,
     {0x54, 0x65, 0x73, 0x74},
     true},

    // Comment: u2 small
    // tcID: 904
    {SEC_OID_SHA256,
     904,
     {0x30, 0x22, 0x02, 0x01, 0x01, 0x02, 0x1d, 0x00, 0x95, 0x92, 0x12, 0x1e,
      0xd1, 0x2d, 0x93, 0x19, 0x7f, 0x1f, 0xfb, 0x86, 0x3a, 0xc6, 0x39, 0x37,
      0xf2, 0x8e, 0xf4, 0xf6, 0x2f, 0x1e, 0x00, 0x9a, 0x30, 0xaa, 0xba, 0xb1},
     kPubKey6,
     {0x54, 0x65, 0x73, 0x74},
     true},

    // Comment: s == q-1
    // tcID: 905
    {SEC_OID_SHA256,
     905,
     {0x30, 0x22, 0x02, 0x01, 0x01, 0x02, 0x1d, 0x00, 0xba, 0xf6, 0x96, 0xa6,
      0x85, 0x78, 0xf7, 0xdf, 0xde, 0xe7, 0xfa, 0x67, 0xc9, 0x77, 0xc7, 0x85,
      0xef, 0x32, 0xb2, 0x33, 0xba, 0xe5, 0x80, 0xc0, 0xbc, 0xd5, 0x69, 0x5c},
     kPubKey6,
     {0x54, 0x65, 0x73, 0x74},
     true},

    // Comment: s == 1
    // tcID: 906
    {SEC_OID_SHA256,
     906,
     {0x30, 0x21, 0x02, 0x1c, 0x5a, 0x25, 0x2f, 0x4f, 0xc5, 0x56, 0x18, 0x74,
      0x7f, 0xd9, 0x4b, 0x13, 0xc9, 0xbe, 0xe6, 0x2b, 0xb9, 0x58, 0xd8, 0x57,
      0x77, 0xcb, 0x07, 0xdd, 0x90, 0x71, 0x0d, 0x24, 0x02, 0x01, 0x01},
     kPubKey7,
     {0x54, 0x65, 0x73, 0x74},
     true}};

#endif  // dsa_vectors_h__
