"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.compoundExpand = void 0;
const tslib_1 = require("tslib");
const jsx_runtime_1 = require("react/jsx-runtime");
const react_styles_1 = require("@patternfly/react-styles");
const table_1 = tslib_1.__importDefault(require("@patternfly/react-styles/css/components/Table/table"));
const TableText_1 = require("../../TableText");
const compoundExpand = (value, { rowIndex, columnIndex, rowData, column, property }) => {
    if (!value) {
        return null;
    }
    const { title, props } = value;
    const { extraParams: { onExpand, expandId = 'expand-toggle' } } = column;
    const extraData = {
        rowIndex,
        columnIndex,
        column,
        property
    };
    /**
     * @param {React.MouseEvent} event - Mouse event
     */
    function onToggle(event) {
        // tslint:disable-next-line:no-unused-expression
        onExpand && onExpand(event, rowIndex, columnIndex, props.isOpen, rowData, extraData);
    }
    return {
        className: (0, react_styles_1.css)(table_1.default.tableCompoundExpansionToggle, props.isOpen && table_1.default.modifiers.expanded),
        children: props.isOpen !== undefined && ((0, jsx_runtime_1.jsx)("button", { type: "button", className: (0, react_styles_1.css)(table_1.default.tableButton), onClick: onToggle, "aria-expanded": props.isOpen, "aria-controls": props.ariaControls, id: `${expandId}-${rowIndex}-${columnIndex}`, children: (0, jsx_runtime_1.jsx)(TableText_1.TableText, { children: title }) }))
    };
};
exports.compoundExpand = compoundExpand;
//# sourceMappingURL=compoundExpand.js.map